/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling;

import com.google.inject.Singleton;
import io.durg.kirtimukh.throttling.ThrottlingBucketKey;
import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.durg.kirtimukh.throttling.ticker.StrategyChecker;
import io.durg.kirtimukh.throttling.ticker.impl.LeakyBucketTicker;
import io.durg.kirtimukh.throttling.ticker.impl.PriorityBucketTicker;
import io.durg.kirtimukh.throttling.ticker.impl.QuotaStrategyTicker;
import io.durg.kirtimukh.throttling.window.impl.PriorityWindowChecker;
import io.durg.kirtimukh.throttling.window.impl.TimedWindowChecker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class ThrottlingController {
    private final ConcurrentHashMap<String, TimedWindowChecker> windowCheckerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ThrottlingStrategyType> strategyTypeMap = new ConcurrentHashMap();
    private final ThrottlingStrategyConfig defaultStrategyConfig;

    public ThrottlingController(ThrottlingStrategyConfig defaultConfig, Map<String, ThrottlingStrategyConfig> commandConfigs) {
        this.defaultStrategyConfig = defaultConfig;
        for (Map.Entry<String, ThrottlingStrategyConfig> entry : commandConfigs.entrySet()) {
            this.strategyTypeMap.put(entry.getKey(), entry.getValue().getType());
            this.windowCheckerMap.put(entry.getKey(), this.getWindowChecker(entry.getKey(), entry.getValue()));
        }
    }

    private TimedWindowChecker getTimedWindowChecker(String configKey, ThrottlingStrategyConfig strategyConfig) {
        return TimedWindowChecker.builder().commandKey(configKey).strategyConfig(strategyConfig).build();
    }

    private TimedWindowChecker getWindowChecker(final String configKey, final ThrottlingStrategyConfig strategyConfig) {
        return strategyConfig.getUnit().accept(new ThrottlingWindowUnit.ThrottlingWindowVisitor<TimedWindowChecker>(){

            @Override
            public TimedWindowChecker visitMillisecond() {
                return ThrottlingController.this.getTimedWindowChecker(configKey, strategyConfig);
            }

            @Override
            public TimedWindowChecker visitSecond() {
                return ThrottlingController.this.getTimedWindowChecker(configKey, strategyConfig);
            }

            @Override
            public TimedWindowChecker visitMinute() {
                return ThrottlingController.this.getTimedWindowChecker(configKey, strategyConfig);
            }
        });
    }

    private TimedWindowChecker getWindowChecker(ThrottlingBucketKey bucketKey) {
        String configKey = bucketKey.getConfigName();
        if (!this.windowCheckerMap.containsKey(configKey)) {
            this.windowCheckerMap.put(configKey, this.getWindowChecker(configKey, this.defaultStrategyConfig));
        }
        return this.windowCheckerMap.get(configKey);
    }

    private PriorityWindowChecker getPriorityWindowChecker(ThrottlingBucketKey bucketKey) {
        return PriorityWindowChecker.builder().bucketKey(bucketKey).build();
    }

    private StrategyChecker getStrategyChecker(final ThrottlingBucketKey bucketKey) {
        String configKey = bucketKey.getConfigName();
        ThrottlingStrategyType strategyType = this.strategyTypeMap.getOrDefault(configKey, this.defaultStrategyConfig.getType());
        return strategyType.accept(new ThrottlingStrategyType.ThrottlingStrategyTypeVisitor<StrategyChecker>(){

            @Override
            public StrategyChecker visitQuota() {
                TimedWindowChecker windowChecker = ThrottlingController.this.getWindowChecker(bucketKey);
                return new QuotaStrategyTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitLeakyBucket() {
                TimedWindowChecker windowChecker = ThrottlingController.this.getWindowChecker(bucketKey);
                return new LeakyBucketTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitPriorityBuckets() {
                PriorityWindowChecker windowChecker = ThrottlingController.this.getPriorityWindowChecker(bucketKey);
                return new PriorityBucketTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitNg() {
                throw new UnsupportedOperationException("Ng strategy unsupported");
            }
        });
    }

    public Map<String, TimedWindowChecker> getInfo() {
        return this.windowCheckerMap;
    }

    public StrategyChecker register(ThrottlingBucketKey bucketKey) {
        return this.getStrategyChecker(bucketKey);
    }
}

