/*
 * Decompiled with CFR 0.152.
 */
package io.durg.aop.interceptors;

import com.google.common.base.Stopwatch;
import io.durg.aop.annotation.Throttle;
import io.durg.aop.annotation.Throttleable;
import io.durg.kirtimukh.throttling.ThrottlingBucketKey;
import io.durg.kirtimukh.throttling.ThrottlingManager;
import io.durg.kirtimukh.throttling.enums.ThrottlingStage;
import io.durg.kirtimukh.throttling.exception.ThrottlingException;
import io.durg.kirtimukh.throttling.ticker.StrategyChecker;
import java.util.Objects;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ThrottlingFunctionWrapper {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ThrottlingFunctionWrapper ajc$perSingletonInstance;

    @Pointcut(value="@annotation(io.durg.aop.annotation.Throttle)")
    public void throttlePointcutFunction() {
    }

    @Pointcut(value="@annotation(io.durg.aop.annotation.Throttleable)")
    public void throttleablePointcutFunction() {
    }

    @Pointcut(value="execution(* *(..))")
    public void pointCutExecution() {
    }

    private ThrottlingBucketKey getThrottleBucketKey(Signature signature) {
        MethodSignature methodSignature = (MethodSignature)MethodSignature.class.cast(signature);
        Throttle throttleFunction = methodSignature.getMethod().getAnnotation(Throttle.class);
        String bucketName = null;
        if (Objects.isNull(throttleFunction)) {
            Throttleable throttleableFunction = methodSignature.getMethod().getAnnotation(Throttleable.class);
            if (Objects.isNull(throttleableFunction)) {
                throw new UnsupportedOperationException("Pointcut called without annotations");
            }
            bucketName = throttleableFunction.bucket();
        } else {
            bucketName = throttleFunction.bucket();
        }
        return ThrottlingBucketKey.builder().bucketName(bucketName).clazz(methodSignature.getDeclaringType()).functionName(methodSignature.getMethod().getName()).build();
    }

    private StrategyChecker getStrategyChecker(ThrottlingBucketKey bucketKey) {
        return ThrottlingManager.register(bucketKey);
    }

    private void enter(ThrottlingBucketKey bucketKey, StrategyChecker checker, Stopwatch stopwatch) {
        try {
            checker.enter();
            ThrottlingManager.ticker(bucketKey, ThrottlingStage.ENTERED, stopwatch);
        }
        catch (ThrottlingException e) {
            stopwatch.stop();
            ThrottlingManager.ticker(bucketKey, ThrottlingStage.THROTTLED, stopwatch);
            ThrottlingManager.translate(e);
        }
    }

    private Object exit(ThrottlingBucketKey bucketKey, ProceedingJoinPoint joinPoint, StrategyChecker checker, Stopwatch stopwatch) throws Throwable {
        try {
            Object response = joinPoint.proceed();
            stopwatch.stop();
            ThrottlingManager.ticker(bucketKey, ThrottlingStage.COMPLETED, stopwatch);
            Object object = response;
            return object;
        }
        catch (Throwable t) {
            stopwatch.stop();
            ThrottlingManager.ticker(bucketKey, ThrottlingStage.ERROR, stopwatch);
            throw t;
        }
        finally {
            checker.exit();
            ThrottlingManager.ticker(bucketKey, ThrottlingStage.ACCEPTED, stopwatch);
        }
    }

    @Around(value="(throttlePointcutFunction() || throttleablePointcutFunction()) && pointCutExecution()")
    public Object processThrottle(ProceedingJoinPoint joinPoint) throws Throwable {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ThrottlingBucketKey bucketKey = this.getThrottleBucketKey(joinPoint.getSignature());
        StrategyChecker checker = this.getStrategyChecker(bucketKey);
        this.enter(bucketKey, checker, stopwatch);
        return this.exit(bucketKey, joinPoint, checker, stopwatch);
    }

    public static ThrottlingFunctionWrapper aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.durg.aop.interceptors.ThrottlingFunctionWrapper", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ThrottlingFunctionWrapper.ajc$perSingletonInstance = new ThrottlingFunctionWrapper();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

