/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling;

import com.google.inject.Singleton;
import io.durg.kirtimukh.throttling.ThrottlingKey;
import io.durg.kirtimukh.throttling.checker.StrategyChecker;
import io.durg.kirtimukh.throttling.checker.impl.LeakyBucketStrategyChecker;
import io.durg.kirtimukh.throttling.checker.impl.PriorityBucketStrategyChecker;
import io.durg.kirtimukh.throttling.checker.impl.QuotaStrategyChecker;
import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.custom.CustomGatePass;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingController;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.durg.kirtimukh.throttling.window.impl.PriorityWindowChecker;
import io.durg.kirtimukh.throttling.window.impl.TimedWindowChecker;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

@Singleton
public class ThrottlingController {
    private final ConcurrentHashMap<String, TimedWindowChecker> windowCheckerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ThrottlingStrategyType> strategyTypeMap = new ConcurrentHashMap();
    private final ThrottlingStrategyConfig defaultStrategyConfig;
    private final CustomThrottlingController customThrottlingController;

    public ThrottlingController(ThrottlingStrategyConfig defaultConfig, Map<String, ThrottlingStrategyConfig> commandConfigs, CustomThrottlingController customThrottlingController) {
        this.defaultStrategyConfig = defaultConfig;
        this.customThrottlingController = customThrottlingController;
        for (Map.Entry<String, ThrottlingStrategyConfig> entry : commandConfigs.entrySet()) {
            this.strategyTypeMap.put(entry.getKey(), entry.getValue().getType());
            this.windowCheckerMap.put(entry.getKey(), this.getWindowChecker(entry.getKey(), entry.getValue()));
        }
    }

    private TimedWindowChecker getTimedWindowChecker(String configKey, ThrottlingStrategyConfig strategyConfig) {
        return TimedWindowChecker.builder().commandKey(configKey).strategyConfig(strategyConfig).build();
    }

    private TimedWindowChecker getWindowChecker(final String configKey, final ThrottlingStrategyConfig strategyConfig) {
        return strategyConfig.getUnit().accept(new ThrottlingWindowUnit.Visitor<TimedWindowChecker>(){

            @Override
            public TimedWindowChecker visitMillisecond() {
                return ThrottlingController.this.getTimedWindowChecker(configKey, strategyConfig);
            }

            @Override
            public TimedWindowChecker visitSecond() {
                return ThrottlingController.this.getTimedWindowChecker(configKey, strategyConfig);
            }

            @Override
            public TimedWindowChecker visitMinute() {
                return ThrottlingController.this.getTimedWindowChecker(configKey, strategyConfig);
            }
        });
    }

    private TimedWindowChecker getWindowChecker(ThrottlingKey bucketKey) {
        String configKey = bucketKey.getConfigName();
        if (!this.windowCheckerMap.containsKey(configKey)) {
            this.windowCheckerMap.put(configKey, this.getWindowChecker(configKey, this.defaultStrategyConfig));
        }
        return this.windowCheckerMap.get(configKey);
    }

    private PriorityWindowChecker getPriorityWindowChecker(ThrottlingKey bucketKey) {
        return PriorityWindowChecker.builder().bucketKey(bucketKey).build();
    }

    private CustomGatePass getCustomGateKeeper(ThrottlingKey bucketKey) {
        if (Objects.isNull(this.customThrottlingController)) {
            throw new UnsupportedOperationException("Custom config found without resolver");
        }
        return this.customThrottlingController.resolve(bucketKey);
    }

    private StrategyChecker getStrategyChecker(final ThrottlingKey bucketKey) {
        String configKey = bucketKey.getConfigName();
        ThrottlingStrategyType strategyType = this.strategyTypeMap.getOrDefault(configKey, this.defaultStrategyConfig.getType());
        return strategyType.accept(new ThrottlingStrategyType.Visitor<StrategyChecker>(){

            @Override
            public StrategyChecker visitQuota() {
                TimedWindowChecker windowChecker = ThrottlingController.this.getWindowChecker(bucketKey);
                return new QuotaStrategyChecker(windowChecker);
            }

            @Override
            public StrategyChecker visitLeakyBucket() {
                TimedWindowChecker windowChecker = ThrottlingController.this.getWindowChecker(bucketKey);
                return new LeakyBucketStrategyChecker(windowChecker);
            }

            @Override
            public StrategyChecker visitPriorityBucket() {
                PriorityWindowChecker windowChecker = ThrottlingController.this.getPriorityWindowChecker(bucketKey);
                return new PriorityBucketStrategyChecker(windowChecker);
            }

            @Override
            public StrategyChecker visitCustomStrategy() {
                CustomGatePass customGatePass = ThrottlingController.this.getCustomGateKeeper(bucketKey);
                return ThrottlingController.this.customThrottlingController.checker(customGatePass);
            }
        });
    }

    public Map<String, TimedWindowChecker> getInfo() {
        return this.windowCheckerMap;
    }

    public StrategyChecker register(ThrottlingKey bucketKey) {
        return this.getStrategyChecker(bucketKey);
    }

    @Generated
    public static ThrottlingControllerBuilder builder() {
        return new ThrottlingControllerBuilder();
    }

    @Generated
    public static class ThrottlingControllerBuilder {
        @Generated
        private ThrottlingStrategyConfig defaultConfig;
        @Generated
        private Map<String, ThrottlingStrategyConfig> commandConfigs;
        @Generated
        private CustomThrottlingController customThrottlingController;

        @Generated
        ThrottlingControllerBuilder() {
        }

        @Generated
        public ThrottlingControllerBuilder defaultConfig(ThrottlingStrategyConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        @Generated
        public ThrottlingControllerBuilder commandConfigs(Map<String, ThrottlingStrategyConfig> commandConfigs) {
            this.commandConfigs = commandConfigs;
            return this;
        }

        @Generated
        public ThrottlingControllerBuilder customThrottlingController(CustomThrottlingController customThrottlingController) {
            this.customThrottlingController = customThrottlingController;
            return this;
        }

        @Generated
        public ThrottlingController build() {
            return new ThrottlingController(this.defaultConfig, this.commandConfigs, this.customThrottlingController);
        }

        @Generated
        public String toString() {
            return "ThrottlingController.ThrottlingControllerBuilder(defaultConfig=" + this.defaultConfig + ", commandConfigs=" + this.commandConfigs + ", customThrottlingController=" + this.customThrottlingController + ")";
        }
    }
}

