/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.window.impl;

import io.durg.kirtimukh.throttling.ThrottlingKey;
import io.durg.kirtimukh.throttling.config.PriorityBucketThrottlingConfig;
import io.durg.kirtimukh.throttling.config.impl.PriorityBucketThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.exception.SimpleThrottlingException;
import io.durg.kirtimukh.throttling.tick.Tick;
import io.durg.kirtimukh.throttling.tick.impl.WindowLocationTick;
import io.durg.kirtimukh.throttling.window.Window;
import io.durg.kirtimukh.throttling.window.WindowChecker;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityWindowChecker
implements WindowChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PriorityWindowChecker.class);
    private int priority;
    private ThrottlingKey throttlingKey;
    private ConcurrentNavigableMap<Integer, Window> priorityWindows;

    public PriorityWindowChecker(ThrottlingKey bucketKey, PriorityBucketThrottlingStrategyConfig strategyConfig) {
        this.throttlingKey = bucketKey;
        this.priorityWindows = new ConcurrentSkipListMap<Integer, Window>();
        for (Map.Entry<String, PriorityBucketThrottlingConfig> configEntry : strategyConfig.getBucketConfigs().entrySet()) {
            if (this.priorityWindows.containsKey(configEntry.getValue().getPriority())) continue;
            this.priorityWindows.put(configEntry.getValue().getPriority(), Window.builder().threshold(strategyConfig.getSharedBucketThreshold()).build());
        }
        this.priorityWindows.put(Integer.MAX_VALUE, Window.builder().threshold(strategyConfig.getSharedBucketThreshold()).build());
    }

    @Override
    public WindowLocationTick acquire() {
        for (Map.Entry entry : this.priorityWindows.tailMap((Object)this.priority).entrySet()) {
            int location = ((Window)entry.getValue()).add();
            if (location < 0) continue;
            return WindowLocationTick.builder().windowId((Integer)entry.getKey()).location(location).build();
        }
        throw SimpleThrottlingException.builder().commandKey(this.throttlingKey.getConfigName()).strategyType(ThrottlingStrategyType.PRIORITY_BUCKET).message("Threshold limits exhausted").build();
    }

    @Override
    public boolean release(Tick location) {
        WindowLocationTick windowLocationTick = (WindowLocationTick)location;
        return ((Window)this.priorityWindows.get(windowLocationTick.getWindowId())).remove(windowLocationTick.getLocation());
    }

    @Generated
    public static PriorityWindowCheckerBuilder builder() {
        return new PriorityWindowCheckerBuilder();
    }

    @Generated
    private PriorityWindowChecker() {
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public ThrottlingKey getThrottlingKey() {
        return this.throttlingKey;
    }

    @Generated
    public ConcurrentNavigableMap<Integer, Window> getPriorityWindows() {
        return this.priorityWindows;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setThrottlingKey(ThrottlingKey throttlingKey) {
        this.throttlingKey = throttlingKey;
    }

    @Generated
    public void setPriorityWindows(ConcurrentNavigableMap<Integer, Window> priorityWindows) {
        this.priorityWindows = priorityWindows;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PriorityWindowChecker)) {
            return false;
        }
        PriorityWindowChecker other = (PriorityWindowChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        ThrottlingKey this$throttlingKey = this.getThrottlingKey();
        ThrottlingKey other$throttlingKey = other.getThrottlingKey();
        if (this$throttlingKey == null ? other$throttlingKey != null : !((Object)this$throttlingKey).equals(other$throttlingKey)) {
            return false;
        }
        ConcurrentNavigableMap<Integer, Window> this$priorityWindows = this.getPriorityWindows();
        ConcurrentNavigableMap<Integer, Window> other$priorityWindows = other.getPriorityWindows();
        return !(this$priorityWindows == null ? other$priorityWindows != null : !this$priorityWindows.equals(other$priorityWindows));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PriorityWindowChecker;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        ThrottlingKey $throttlingKey = this.getThrottlingKey();
        result = result * 59 + ($throttlingKey == null ? 43 : ((Object)$throttlingKey).hashCode());
        ConcurrentNavigableMap<Integer, Window> $priorityWindows = this.getPriorityWindows();
        result = result * 59 + ($priorityWindows == null ? 43 : $priorityWindows.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PriorityWindowChecker(priority=" + this.getPriority() + ", throttlingKey=" + this.getThrottlingKey() + ", priorityWindows=" + this.getPriorityWindows() + ")";
    }

    @Generated
    public static class PriorityWindowCheckerBuilder {
        @Generated
        private ThrottlingKey bucketKey;
        @Generated
        private PriorityBucketThrottlingStrategyConfig strategyConfig;

        @Generated
        PriorityWindowCheckerBuilder() {
        }

        @Generated
        public PriorityWindowCheckerBuilder bucketKey(ThrottlingKey bucketKey) {
            this.bucketKey = bucketKey;
            return this;
        }

        @Generated
        public PriorityWindowCheckerBuilder strategyConfig(PriorityBucketThrottlingStrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        @Generated
        public PriorityWindowChecker build() {
            return new PriorityWindowChecker(this.bucketKey, this.strategyConfig);
        }

        @Generated
        public String toString() {
            return "PriorityWindowChecker.PriorityWindowCheckerBuilder(bucketKey=" + this.bucketKey + ", strategyConfig=" + this.strategyConfig + ")";
        }
    }
}

