/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.window.impl;

import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.exception.SimpleThrottlingException;
import io.durg.kirtimukh.throttling.tick.Tick;
import io.durg.kirtimukh.throttling.tick.impl.LocationTick;
import io.durg.kirtimukh.throttling.window.Window;
import io.durg.kirtimukh.throttling.window.WindowChecker;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWindowChecker
implements WindowChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleWindowChecker.class);
    private final String commandKey;
    private final ThrottlingStrategyType strategyType;
    private final Window window;

    public SimpleWindowChecker(String commandKey, ThrottlingStrategyConfig strategyConfig) {
        this.commandKey = commandKey;
        this.strategyType = strategyConfig.getType();
        this.window = Window.builder().threshold(strategyConfig.getThreshold()).build();
    }

    @Override
    public Tick acquire() {
        int location = this.window.add();
        if (location < 0) {
            throw SimpleThrottlingException.builder().commandKey(this.commandKey).strategyType(this.strategyType).cardinality(this.window.cardinality()).threshold(this.window.getThreshold()).message("Threshold limits exhausted").build();
        }
        log.debug("[{}] Cardinality {} allowed limit {}", new Object[]{this.commandKey, this.window.cardinality(), this.window.getThreshold()});
        return LocationTick.builder().location(location).build();
    }

    @Override
    public boolean release(Tick location) {
        return this.window.remove(location.getLocation());
    }

    @Generated
    public static SimpleWindowCheckerBuilder builder() {
        return new SimpleWindowCheckerBuilder();
    }

    @Generated
    private SimpleWindowChecker() {
        this.commandKey = null;
        this.strategyType = null;
        this.window = null;
    }

    @Generated
    public String getCommandKey() {
        return this.commandKey;
    }

    @Generated
    public ThrottlingStrategyType getStrategyType() {
        return this.strategyType;
    }

    @Generated
    public Window getWindow() {
        return this.window;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleWindowChecker)) {
            return false;
        }
        SimpleWindowChecker other = (SimpleWindowChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$commandKey = this.getCommandKey();
        String other$commandKey = other.getCommandKey();
        if (this$commandKey == null ? other$commandKey != null : !this$commandKey.equals(other$commandKey)) {
            return false;
        }
        ThrottlingStrategyType this$strategyType = this.getStrategyType();
        ThrottlingStrategyType other$strategyType = other.getStrategyType();
        if (this$strategyType == null ? other$strategyType != null : !((Object)((Object)this$strategyType)).equals((Object)other$strategyType)) {
            return false;
        }
        Window this$window = this.getWindow();
        Window other$window = other.getWindow();
        return !(this$window == null ? other$window != null : !((Object)this$window).equals(other$window));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleWindowChecker;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $commandKey = this.getCommandKey();
        result = result * 59 + ($commandKey == null ? 43 : $commandKey.hashCode());
        ThrottlingStrategyType $strategyType = this.getStrategyType();
        result = result * 59 + ($strategyType == null ? 43 : ((Object)((Object)$strategyType)).hashCode());
        Window $window = this.getWindow();
        result = result * 59 + ($window == null ? 43 : ((Object)$window).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimpleWindowChecker(commandKey=" + this.getCommandKey() + ", strategyType=" + (Object)((Object)this.getStrategyType()) + ", window=" + this.getWindow() + ")";
    }

    @Generated
    public static class SimpleWindowCheckerBuilder {
        @Generated
        private String commandKey;
        @Generated
        private ThrottlingStrategyConfig strategyConfig;

        @Generated
        SimpleWindowCheckerBuilder() {
        }

        @Generated
        public SimpleWindowCheckerBuilder commandKey(String commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        @Generated
        public SimpleWindowCheckerBuilder strategyConfig(ThrottlingStrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        @Generated
        public SimpleWindowChecker build() {
            return new SimpleWindowChecker(this.commandKey, this.strategyConfig);
        }

        @Generated
        public String toString() {
            return "SimpleWindowChecker.SimpleWindowCheckerBuilder(commandKey=" + this.commandKey + ", strategyConfig=" + this.strategyConfig + ")";
        }
    }
}

