/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling;

import com.google.inject.Singleton;
import io.durg.kirtimukh.throttling.ThrottlingKey;
import io.durg.kirtimukh.throttling.checker.StrategyChecker;
import io.durg.kirtimukh.throttling.checker.impl.LeakyBucketStrategyChecker;
import io.durg.kirtimukh.throttling.checker.impl.NoStrategyChecker;
import io.durg.kirtimukh.throttling.checker.impl.PriorityBucketStrategyChecker;
import io.durg.kirtimukh.throttling.checker.impl.QuotaStrategyChecker;
import io.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingController;
import io.durg.kirtimukh.throttling.custom.GatePass;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.window.WindowChecker;
import io.durg.kirtimukh.throttling.window.WindowCheckerUtils;
import io.durg.kirtimukh.throttling.window.impl.PriorityWindowChecker;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

@Singleton
public class ThrottlingController {
    private boolean enabled = true;
    private final NoStrategyChecker noStrategyChecker = new NoStrategyChecker();
    private final ConcurrentHashMap<String, WindowChecker> windowCheckerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ThrottlingStrategyType> strategyTypeMap = new ConcurrentHashMap();
    private final CustomThrottlingController customThrottlingController;
    private ThrottlingStrategyConfig defaultStrategyConfig;
    private Map<String, ThrottlingStrategyConfig> commandStrategyConfigs;

    public ThrottlingController(ThrottlingStrategyConfig defaultConfig, Map<String, ThrottlingStrategyConfig> commandConfigs, CustomThrottlingController customThrottlingController) {
        this.defaultStrategyConfig = defaultConfig;
        this.commandStrategyConfigs = commandConfigs;
        this.customThrottlingController = customThrottlingController;
        this.initialise();
    }

    private synchronized boolean initialise() {
        for (Map.Entry<String, ThrottlingStrategyConfig> entry : this.commandStrategyConfigs.entrySet()) {
            this.strategyTypeMap.put(entry.getKey(), entry.getValue().getType());
        }
        return true;
    }

    private WindowChecker getWindowChecker(ThrottlingKey throttlingKey) {
        String configKey = throttlingKey.getConfigName();
        if (!this.windowCheckerMap.containsKey(configKey)) {
            this.windowCheckerMap.put(configKey, WindowCheckerUtils.getWindowChecker(throttlingKey, this.defaultStrategyConfig));
        }
        return this.windowCheckerMap.get(configKey);
    }

    private GatePass getCustomGateKeeper(ThrottlingKey bucketKey) {
        if (Objects.isNull(this.customThrottlingController)) {
            throw new UnsupportedOperationException("Custom config found without resolver");
        }
        return this.customThrottlingController.resolve(bucketKey);
    }

    private StrategyChecker getStrategyChecker(final ThrottlingKey bucketKey) {
        String configKey = bucketKey.getConfigName();
        ThrottlingStrategyType strategyType = this.strategyTypeMap.getOrDefault(configKey, this.defaultStrategyConfig.getType());
        return strategyType.accept(new ThrottlingStrategyType.Visitor<StrategyChecker>(){

            @Override
            public StrategyChecker visitQuota() {
                return new QuotaStrategyChecker(ThrottlingController.this.getWindowChecker(bucketKey));
            }

            @Override
            public StrategyChecker visitLeakyBucket() {
                return new LeakyBucketStrategyChecker(ThrottlingController.this.getWindowChecker(bucketKey));
            }

            @Override
            public StrategyChecker visitPriorityBucket() {
                return new PriorityBucketStrategyChecker((PriorityWindowChecker)ThrottlingController.this.getWindowChecker(bucketKey));
            }

            @Override
            public StrategyChecker visitCustomStrategy() {
                return ThrottlingController.this.customThrottlingController.checker(ThrottlingController.this.getCustomGateKeeper(bucketKey));
            }
        });
    }

    public Map<String, WindowChecker> getInfo() {
        return this.windowCheckerMap;
    }

    public boolean disable() {
        this.enabled = false;
        return this.reset();
    }

    public boolean reset() {
        this.windowCheckerMap.clear();
        this.strategyTypeMap.clear();
        return this.initialise();
    }

    public boolean reload(ThrottlingStrategyConfig defaultConfig, Map<String, ThrottlingStrategyConfig> commandConfigs) {
        this.defaultStrategyConfig = defaultConfig;
        this.commandStrategyConfigs = commandConfigs;
        return this.reset();
    }

    public StrategyChecker register(ThrottlingKey bucketKey) {
        return this.enabled ? this.getStrategyChecker(bucketKey) : this.noStrategyChecker;
    }

    @Generated
    public static ThrottlingControllerBuilder builder() {
        return new ThrottlingControllerBuilder();
    }

    @Generated
    public static class ThrottlingControllerBuilder {
        @Generated
        private ThrottlingStrategyConfig defaultConfig;
        @Generated
        private Map<String, ThrottlingStrategyConfig> commandConfigs;
        @Generated
        private CustomThrottlingController customThrottlingController;

        @Generated
        ThrottlingControllerBuilder() {
        }

        @Generated
        public ThrottlingControllerBuilder defaultConfig(ThrottlingStrategyConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        @Generated
        public ThrottlingControllerBuilder commandConfigs(Map<String, ThrottlingStrategyConfig> commandConfigs) {
            this.commandConfigs = commandConfigs;
            return this;
        }

        @Generated
        public ThrottlingControllerBuilder customThrottlingController(CustomThrottlingController customThrottlingController) {
            this.customThrottlingController = customThrottlingController;
            return this;
        }

        @Generated
        public ThrottlingController build() {
            return new ThrottlingController(this.defaultConfig, this.commandConfigs, this.customThrottlingController);
        }

        @Generated
        public String toString() {
            return "ThrottlingController.ThrottlingControllerBuilder(defaultConfig=" + this.defaultConfig + ", commandConfigs=" + this.commandConfigs + ", customThrottlingController=" + this.customThrottlingController + ")";
        }
    }
}

