/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.custom.ng;

import io.durg.kirtimukh.throttling.custom.GatePass;
import io.durg.kirtimukh.throttling.custom.ThrottlingKeyType;
import io.durg.kirtimukh.throttling.custom.ThrottlingVerdict;
import io.durg.kirtimukh.throttling.exception.impl.CustomThrottlingException;
import lombok.Generated;

public class NgThrottlingVerdictVisitor
implements ThrottlingVerdict.Visitor<Void> {
    private final GatePass<ThrottlingKeyType> gatePass;

    public NgThrottlingVerdictVisitor(GatePass<ThrottlingKeyType> gatePass) {
        this.gatePass = gatePass;
    }

    @Override
    public Void visitAllow() {
        return null;
    }

    @Override
    public Void visitDeny() {
        throw CustomThrottlingException.builder().keyType(this.gatePass.getKeyType()).key(this.gatePass.getKey()).keyType(this.gatePass.getKeyType()).verdict(ThrottlingVerdict.DENY).message("Threshold limits exhausted").build();
    }

    @Override
    public Void visitWait() {
        throw CustomThrottlingException.builder().keyType(this.gatePass.getKeyType()).key(this.gatePass.getKey()).verdict(ThrottlingVerdict.WAIT).retryAfterMs(this.gatePass.retryAfter()).graceful(true).message(String.format("Limits exhausted so wait for %s", this.gatePass.retryAfter())).build();
    }

    @Override
    public Void visitAck() {
        throw CustomThrottlingException.builder().keyType(this.gatePass.getKeyType()).key(this.gatePass.getKey()).verdict(ThrottlingVerdict.ACK).graceful(true).message("Limits exhausted but request accepted").build();
    }

    @Generated
    public static NgThrottlingVerdictVisitorBuilder builder() {
        return new NgThrottlingVerdictVisitorBuilder();
    }

    @Generated
    public static class NgThrottlingVerdictVisitorBuilder {
        @Generated
        private GatePass<ThrottlingKeyType> gatePass;

        @Generated
        NgThrottlingVerdictVisitorBuilder() {
        }

        @Generated
        public NgThrottlingVerdictVisitorBuilder gatePass(GatePass<ThrottlingKeyType> gatePass) {
            this.gatePass = gatePass;
            return this;
        }

        @Generated
        public NgThrottlingVerdictVisitor build() {
            return new NgThrottlingVerdictVisitor(this.gatePass);
        }

        @Generated
        public String toString() {
            return "NgThrottlingVerdictVisitor.NgThrottlingVerdictVisitorBuilder(gatePass=" + this.gatePass + ")";
        }
    }
}

