/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.discovery.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceFinderBuilders;
import com.flipkart.ranger.finder.BaseServiceFinderBuilder;
import com.flipkart.ranger.finder.sharded.SimpleShardedServiceFinder;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.model.ServiceNodeSelector;
import com.flipkart.ranger.model.ShardSelector;
import io.appform.dropwizard.discovery.client.selector.HierarchicalEnvironmentAwareShardSelector;
import io.appform.dropwizard.discovery.client.selector.TsaheyluHealthSelector;
import io.appform.dropwizard.discovery.common.ShardInfo;
import io.durg.tsaheylu.metered.ErrorRegistry;
import java.util.List;
import java.util.Optional;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryClient.class);
    private final ShardInfo criteria;
    private SimpleShardedServiceFinder<ShardInfo> serviceFinder;

    private ServiceDiscoveryClient(String namespace, String serviceName, String environment, ObjectMapper objectMapper, String connectionString, int refreshTimeMs, ErrorRegistry errorRegistry, boolean disableWatchers) {
        this(namespace, serviceName, environment, objectMapper, CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)new RetryForever(5000)), refreshTimeMs, errorRegistry, disableWatchers);
    }

    ServiceDiscoveryClient(String namespace, String serviceName, String environment, ObjectMapper objectMapper, CuratorFramework curator, int refreshTimeMs, ErrorRegistry errorRegistry, boolean disableWatchers) {
        int effectiveRefreshTimeMs = refreshTimeMs;
        if (effectiveRefreshTimeMs < 5000) {
            effectiveRefreshTimeMs = 5000;
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)refreshTimeMs, (Object)5000);
        }
        this.criteria = ShardInfo.builder().environment(environment).build();
        BaseServiceFinderBuilder builder = ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(curator).withNamespace(namespace).withServiceName(serviceName).withDeserializer(data -> {
            try {
                return (ServiceNode)objectMapper.readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withNodeRefreshIntervalMs(effectiveRefreshTimeMs).withDisableWatchers(disableWatchers).withNodeSelector((ServiceNodeSelector)new TsaheyluHealthSelector(errorRegistry)).withShardSelector((ShardSelector)new HierarchicalEnvironmentAwareShardSelector());
        this.serviceFinder = (SimpleShardedServiceFinder)builder.build();
    }

    public void start() throws Exception {
        this.serviceFinder.start();
    }

    public void stop() throws Exception {
        this.serviceFinder.stop();
    }

    public Optional<ServiceNode<ShardInfo>> getNode() {
        return this.getNode(this.criteria);
    }

    public List<ServiceNode<ShardInfo>> getAllNodes() {
        return this.getAllNodes(this.criteria);
    }

    public Optional<ServiceNode<ShardInfo>> getNode(ShardInfo shardInfo) {
        return Optional.ofNullable(this.serviceFinder.get((Object)shardInfo));
    }

    public List<ServiceNode<ShardInfo>> getAllNodes(ShardInfo shardInfo) {
        return this.serviceFinder.getAll((Object)shardInfo);
    }

    public static FromConnectionStringBuilder fromConnectionString() {
        return new FromConnectionStringBuilder();
    }

    public static FromCuratorBuilder fromCurator() {
        return new FromCuratorBuilder();
    }

    public static class FromConnectionStringBuilder {
        private String namespace;
        private String serviceName;
        private String environment;
        private ObjectMapper objectMapper;
        private String connectionString;
        private int refreshTimeMs;
        private ErrorRegistry errorRegistry;
        private boolean disableWatchers;

        FromConnectionStringBuilder() {
        }

        public FromConnectionStringBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FromConnectionStringBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public FromConnectionStringBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public FromConnectionStringBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public FromConnectionStringBuilder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public FromConnectionStringBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        public FromConnectionStringBuilder errorRegistry(ErrorRegistry errorRegistry) {
            this.errorRegistry = errorRegistry;
            return this;
        }

        public FromConnectionStringBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.namespace, this.serviceName, this.environment, this.objectMapper, this.connectionString, this.refreshTimeMs, this.errorRegistry, this.disableWatchers);
        }

        public String toString() {
            return "ServiceDiscoveryClient.FromConnectionStringBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", objectMapper=" + this.objectMapper + ", connectionString=" + this.connectionString + ", refreshTimeMs=" + this.refreshTimeMs + ", errorRegistry=" + this.errorRegistry + ", disableWatchers=" + this.disableWatchers + ")";
        }
    }

    public static class FromCuratorBuilder {
        private String namespace;
        private String serviceName;
        private String environment;
        private ObjectMapper objectMapper;
        private CuratorFramework curator;
        private int refreshTimeMs;
        private ErrorRegistry errorRegistry;
        private boolean disableWatchers;

        FromCuratorBuilder() {
        }

        public FromCuratorBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public FromCuratorBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public FromCuratorBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public FromCuratorBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public FromCuratorBuilder curator(CuratorFramework curator) {
            this.curator = curator;
            return this;
        }

        public FromCuratorBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        public FromCuratorBuilder errorRegistry(ErrorRegistry errorRegistry) {
            this.errorRegistry = errorRegistry;
            return this;
        }

        public FromCuratorBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.namespace, this.serviceName, this.environment, this.objectMapper, this.curator, this.refreshTimeMs, this.errorRegistry, this.disableWatchers);
        }

        public String toString() {
            return "ServiceDiscoveryClient.FromCuratorBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", objectMapper=" + this.objectMapper + ", curator=" + this.curator + ", refreshTimeMs=" + this.refreshTimeMs + ", errorRegistry=" + this.errorRegistry + ", disableWatchers=" + this.disableWatchers + ")";
        }
    }
}

