/*
 * Decompiled with CFR 0.152.
 */
package io.durg.tsaheylu.registry;

import io.durg.tsaheylu.registry.SigmoidHealthMetricFunction;
import io.durg.tsaheylu.registry.metrics.MetricMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class HealthMetricManager {
    private final List<MetricMonitor> monitors;
    private final Function<List<MetricMonitor>, Double> healthMetricFunction = new SigmoidHealthMetricFunction();

    public double getMetricValue() {
        return this.healthMetricFunction.apply(this.monitors);
    }

    HealthMetricManager(List<MetricMonitor> monitors) {
        this.monitors = monitors;
    }

    public static HealthMetricManagerBuilder builder() {
        return new HealthMetricManagerBuilder();
    }

    public List<MetricMonitor> getMonitors() {
        return this.monitors;
    }

    public Function<List<MetricMonitor>, Double> getHealthMetricFunction() {
        return this.healthMetricFunction;
    }

    public static class HealthMetricManagerBuilder {
        private ArrayList<MetricMonitor> monitors;

        HealthMetricManagerBuilder() {
        }

        public HealthMetricManagerBuilder monitor(MetricMonitor monitor) {
            if (this.monitors == null) {
                this.monitors = new ArrayList();
            }
            this.monitors.add(monitor);
            return this;
        }

        public HealthMetricManagerBuilder monitors(Collection<? extends MetricMonitor> monitors) {
            if (this.monitors == null) {
                this.monitors = new ArrayList();
            }
            this.monitors.addAll(monitors);
            return this;
        }

        public HealthMetricManagerBuilder clearMonitors() {
            if (this.monitors != null) {
                this.monitors.clear();
            }
            return this;
        }

        public HealthMetricManager build() {
            List<MetricMonitor> monitors;
            switch (this.monitors == null ? 0 : this.monitors.size()) {
                case 0: {
                    monitors = Collections.emptyList();
                    break;
                }
                case 1: {
                    monitors = Collections.singletonList(this.monitors.get(0));
                    break;
                }
                default: {
                    monitors = Collections.unmodifiableList(new ArrayList<MetricMonitor>(this.monitors));
                }
            }
            return new HealthMetricManager(monitors);
        }

        public String toString() {
            return "HealthMetricManager.HealthMetricManagerBuilder(monitors=" + this.monitors + ")";
        }
    }
}

