/*
 * Decompiled with CFR 0.152.
 */
package io.durg.tsaheylu.metered;

import io.durg.tsaheylu.metered.ErrorRegistry;
import io.durg.tsaheylu.metered.SuccessPredicate;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Response;

public class ErrorEventListener
extends EventListener {
    private final ErrorRegistry errorRegistry;
    private final SuccessPredicate predicate;

    public ErrorEventListener(ErrorRegistry errorRegistry, SuccessPredicate predicate) {
        this.errorRegistry = errorRegistry;
        this.predicate = predicate;
    }

    public void callFailed(Call call, IOException ioe) {
        this.errorRegistry.recordHttpCall(call.request().url());
        this.errorRegistry.recordError(call.request().url());
    }

    public void responseHeadersEnd(Call call, Response response) {
        this.errorRegistry.recordHttpCall(call.request().url());
        if (!this.predicate.isSuccess(response)) {
            this.errorRegistry.recordError(call.request().url());
        }
    }
}

