/*
 * Decompiled with CFR 0.152.
 */
package io.durg.tsaheylu.metered;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.durg.tsaheylu.metered.Configuration;
import io.durg.tsaheylu.metered.ServiceEndpoint;
import io.durg.tsaheylu.metered.ServiceEndpointWithScore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;

public class ErrorRegistry {
    final Cache<ServiceEndpoint, ConcurrentMap<Long, CountPair>> requestsCount;
    private final int window;
    private final TimeUnit timeUnit;
    private final double threshold;

    public ErrorRegistry(Configuration configuration) {
        this.timeUnit = configuration.getTimeUnit();
        this.window = configuration.getWindow();
        this.threshold = configuration.getErrorPercentageThreshold();
        this.requestsCount = CacheBuilder.newBuilder().build();
    }

    public void recordError(HttpUrl url) {
        long timeKey = this.getTimeKey();
        ServiceEndpoint key = this.getErrorKey(url);
        this.requestsCount.asMap().computeIfAbsent(key, errKey -> new ConcurrentHashMap()).computeIfAbsent(timeKey, timestampInSeconds -> new CountPair(0, 0)).incrementErrorCount();
    }

    public void recordHttpCall(HttpUrl url) {
        ServiceEndpoint key = this.getErrorKey(url);
        long timeKey = this.getTimeKey();
        this.requestsCount.asMap().computeIfAbsent(key, errKey -> new ConcurrentHashMap()).computeIfAbsent(timeKey, timestampInSeconds -> new CountPair(0, 0)).incrementTotalCount();
    }

    private long getTimeKey() {
        long currentTime = Instant.now().getEpochSecond();
        return this.timeUnit.equals((Object)TimeUnit.MINUTES) ? currentTime / 60L : currentTime;
    }

    private ServiceEndpoint getErrorKey(HttpUrl url) {
        return new ServiceEndpoint(url);
    }

    public List<ServiceEndpointWithScore> filter(List<ServiceEndpoint> endpoints) {
        return endpoints.stream().map(endpoint -> {
            double percentage = this.getScore((ServiceEndpoint)endpoint);
            return new ServiceEndpointWithScore((ServiceEndpoint)endpoint, percentage);
        }).sorted(Comparator.comparingDouble(o -> o.score)).filter((? super T endpointWithScore) -> endpointWithScore.score < this.threshold).collect(Collectors.toList());
    }

    public double getScore(ServiceEndpoint endpoint) {
        long currentTime = this.getTimeKey();
        if (!this.requestsCount.asMap().containsKey(endpoint)) {
            System.out.println("key not found");
            return 0.0;
        }
        CountPair sum = ((ConcurrentMap)this.requestsCount.asMap().get(endpoint)).entrySet().stream().filter((? super T entry) -> currentTime - (Long)entry.getKey() <= (long)this.window).reduce(new CountPair(0, 0), (accumulator, entry) -> accumulator.add((CountPair)entry.getValue()), CountPair::add);
        if (sum.getTotalCount() == 0) {
            return 0.0;
        }
        double errorPercentageInLastTimeWindow = (double)sum.getErrorCount() * 1.0 / (double)sum.getTotalCount();
        this.cleanupOldEntries(endpoint, currentTime - (long)(2 * this.window));
        return errorPercentageInLastTimeWindow;
    }

    private void cleanupOldEntries(ServiceEndpoint errorKey, long lessThanTimestamp) {
        ((ConcurrentMap)this.requestsCount.asMap().get(errorKey)).entrySet().removeIf(entry -> (Long)entry.getKey() <= lessThanTimestamp);
    }

    public void inspectCache() {
        this.requestsCount.asMap().forEach((k, v) -> {
            ServiceEndpoint k1 = k;
            System.out.println(k1.getHost() + k1.getPort() + k1.getScheme());
            ArrayList list = new ArrayList(v.entrySet());
            list.sort(Map.Entry.comparingByKey());
            list.forEach(entry -> System.out.println(entry.getKey() + " " + entry.getValue()));
        });
    }

    private static class CountPair {
        private final AtomicInteger errorCount;
        private final AtomicInteger totalCount;

        public CountPair(int errorCount, int totalCount) {
            this.errorCount = new AtomicInteger(errorCount);
            this.totalCount = new AtomicInteger(totalCount);
        }

        public int getErrorCount() {
            return this.errorCount.get();
        }

        public int getTotalCount() {
            return this.totalCount.get();
        }

        long incrementErrorCount() {
            return this.errorCount.addAndGet(1);
        }

        long incrementTotalCount() {
            return this.totalCount.addAndGet(1);
        }

        CountPair add(CountPair other) {
            return new CountPair(this.errorCount.addAndGet(other.getErrorCount()), this.totalCount.addAndGet(other.getTotalCount()));
        }

        public String toString() {
            return "errorCount=" + this.errorCount.get() + ", totalCount=" + this.totalCount.get() + '}';
        }
    }
}

