/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.healthcheck;

import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.serviceprovider.ServiceProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecker<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HealthChecker.class);
    private List<Healthcheck> healthchecks;
    private ServiceProvider<T> serviceProvider;
    private HealthcheckStatus lastHealthcheckStatus;
    private long lastUpdatedTime;

    public HealthChecker(List<Healthcheck> healthchecks, ServiceProvider<T> serviceProvider) {
        this.healthchecks = healthchecks;
        this.serviceProvider = serviceProvider;
    }

    @Override
    public void run() {
        HealthcheckStatus healthcheckStatus = HealthcheckStatus.unhealthy;
        for (Healthcheck healthcheck : this.healthchecks) {
            try {
                healthcheckStatus = healthcheck.check();
            }
            catch (Throwable t) {
                logger.error("Error running healthcheck. Setting node to unhealthy", t);
                healthcheckStatus = HealthcheckStatus.unhealthy;
            }
            if (HealthcheckStatus.unhealthy != healthcheckStatus) continue;
            break;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastHealthcheckStatus == null || currentTime - this.lastUpdatedTime > (long)this.serviceProvider.getStaleUpdateThreshold() || this.lastHealthcheckStatus != healthcheckStatus) {
            this.lastUpdatedTime = currentTime;
            ServiceNode<T> serviceNode = this.serviceProvider.getServiceNode();
            serviceNode.setHealthMetric(this.serviceProvider.getHealthMetricSupplier().get());
            serviceNode.setHealthcheckStatus(healthcheckStatus);
            serviceNode.setLastUpdatedTimeStamp(this.lastUpdatedTime);
            try {
                this.serviceProvider.updateState(serviceNode);
                logger.debug("Node is {} for ({}, {})", new Object[]{healthcheckStatus.name(), serviceNode.getHost(), serviceNode.getPort()});
            }
            catch (Exception e) {
                logger.error("Error updating health state in zookeeper: ", (Throwable)e);
            }
        }
        this.lastHealthcheckStatus = healthcheckStatus;
    }
}

