/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.healthservice;

import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.healthservice.HealthService;
import com.flipkart.ranger.healthservice.monitor.IsolatedHealthMonitor;
import com.flipkart.ranger.healthservice.monitor.Monitor;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHealthAggregator
implements HealthService<HealthcheckStatus>,
Healthcheck {
    private static final Logger logger = LoggerFactory.getLogger(ServiceHealthAggregator.class);
    private AtomicReference<HealthcheckStatus> healthcheckStatusAtomicReference = new AtomicReference();
    private List<ScheduledFuture<?>> scheduledFutureList;
    private List<Monitor<HealthcheckStatus>> inlineHealthMonitorList;
    private List<IsolatedHealthMonitor> isolatedHealthMonitorList = Lists.newArrayList();
    private AtomicBoolean running;

    public ServiceHealthAggregator() {
        this.inlineHealthMonitorList = Lists.newArrayList();
        this.running = new AtomicBoolean(false);
    }

    @Override
    public void addIsolatedMonitor(IsolatedHealthMonitor monitor) {
        if (this.running.get()) {
            throw new UnsupportedOperationException("Cannot add a monitor when Aggregator is running");
        }
        this.isolatedHealthMonitorList.add(monitor);
    }

    @Override
    public void addInlineMonitor(Monitor<HealthcheckStatus> monitor) {
        if (this.running.get()) {
            throw new UnsupportedOperationException("Cannot add a monitor when Aggregator is running");
        }
        this.inlineHealthMonitorList.add(monitor);
    }

    @Override
    public void start() {
        if (this.running.get()) {
            logger.info("Service aggregator is already running");
            return;
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(this.isolatedHealthMonitorList.size());
        this.scheduledFutureList = Lists.newArrayListWithCapacity((int)this.isolatedHealthMonitorList.size());
        for (IsolatedHealthMonitor isolatedHealthMonitor : this.isolatedHealthMonitorList) {
            ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(isolatedHealthMonitor, isolatedHealthMonitor.getRunInterval().getInitialDelay(), isolatedHealthMonitor.getRunInterval().getTimeInterval(), isolatedHealthMonitor.getRunInterval().getTimeUnit());
            this.scheduledFutureList.add(scheduledFuture);
        }
        this.running.set(true);
    }

    @Override
    public synchronized void stop() {
        if (this.running.get()) {
            logger.error("Service aggregator is currently not running, cannot stop..");
            return;
        }
        for (ScheduledFuture<?> scheduledFuture : this.scheduledFutureList) {
            scheduledFuture.cancel(true);
        }
        this.running.set(false);
    }

    @Override
    public HealthcheckStatus getServiceHealth() {
        if (!this.running.get()) {
            throw new UnsupportedOperationException("Cannot get HealthStatus, when Aggregator isnt running. Please start the aggregator before trying to get health");
        }
        this.healthcheckStatusAtomicReference.set(HealthcheckStatus.healthy);
        Date currentTime = new Date();
        boolean hasUnhealthyMonitor = this.isolatedHealthMonitorList.stream().filter(isolatedHealthMonitor -> !isolatedHealthMonitor.isDisabled()).anyMatch(isolatedHealthMonitor -> this.isIsolatedMonitorHealthy((IsolatedHealthMonitor)isolatedHealthMonitor, currentTime));
        if (hasUnhealthyMonitor) {
            this.healthcheckStatusAtomicReference.set(HealthcheckStatus.unhealthy);
        }
        this.processMonitors();
        return this.healthcheckStatusAtomicReference.get();
    }

    @Override
    public HealthcheckStatus check() {
        return this.getServiceHealth();
    }

    private boolean isIsolatedMonitorHealthy(IsolatedHealthMonitor isolatedHealthMonitor, Date currentTime) {
        boolean hasValidUpdateTime;
        if (HealthcheckStatus.unhealthy == isolatedHealthMonitor.getHealthStatus()) {
            return true;
        }
        boolean bl = hasValidUpdateTime = null != isolatedHealthMonitor.getLastStatusUpdateTime() && this.hasValidUpdatedTime(isolatedHealthMonitor, currentTime);
        if (!hasValidUpdateTime) {
            logger.error("Monitor: {} is stuck and its status is stale. Marking service as unhealthy", (Object)isolatedHealthMonitor.getName());
            return true;
        }
        return false;
    }

    private boolean hasValidUpdatedTime(IsolatedHealthMonitor isolatedHealthMonitor, Date currentTime) {
        long timeDifferenceMillis = currentTime.getTime() - isolatedHealthMonitor.getLastStatusUpdateTime().getTime();
        return timeDifferenceMillis <= isolatedHealthMonitor.getStalenessAllowedInMillis();
    }

    private void processMonitors() {
        for (Monitor<HealthcheckStatus> healthMonitor : this.inlineHealthMonitorList) {
            HealthcheckStatus monitorStatus;
            if (healthMonitor.isDisabled() || HealthcheckStatus.unhealthy != (monitorStatus = healthMonitor.monitor())) continue;
            this.healthcheckStatusAtomicReference.set(HealthcheckStatus.unhealthy);
        }
    }
}

