/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.healthservice.monitor;

import com.flipkart.ranger.healthservice.TimeEntity;
import com.flipkart.ranger.healthservice.monitor.Monitor;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class IsolatedHealthMonitor<T>
implements Runnable,
Monitor<T> {
    protected String name;
    private AtomicReference<T> healthStatus;
    private Date lastStatusUpdateTime;
    private TimeEntity runInterval;
    private final AtomicBoolean disabled = new AtomicBoolean(false);
    private long stalenessAllowedInMillis;

    public IsolatedHealthMonitor(String name, TimeEntity runInterval) {
        this(name, runInterval, 60000L);
    }

    public IsolatedHealthMonitor(String name, TimeEntity runInterval, long stalenessAllowedInMillis) {
        this.name = name;
        this.stalenessAllowedInMillis = stalenessAllowedInMillis;
        this.healthStatus = new AtomicReference();
        this.runInterval = runInterval;
        this.disabled.set(false);
    }

    @Override
    public void run() {
        this.healthStatus.set(this.monitor());
        this.lastStatusUpdateTime = new Date();
    }

    public void disable() {
        this.disabled.set(true);
    }

    public void enable() {
        this.disabled.set(false);
    }

    public TimeEntity getRunInterval() {
        return this.runInterval;
    }

    public T getHealthStatus() {
        return this.healthStatus.get();
    }

    public Date getLastStatusUpdateTime() {
        return null != this.lastStatusUpdateTime ? new Date(this.lastStatusUpdateTime.getTime()) : null;
    }

    public String getName() {
        return this.name;
    }

    public long getStalenessAllowedInMillis() {
        return this.stalenessAllowedInMillis;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled.get();
    }
}

