/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.serviceprovider;

import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthservice.ServiceHealthAggregator;
import com.flipkart.ranger.healthservice.monitor.IsolatedHealthMonitor;
import com.flipkart.ranger.model.Serializer;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.serviceprovider.ServiceProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProviderBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProviderBuilder.class);
    private String namespace;
    private String serviceName;
    private CuratorFramework curatorFramework;
    private String connectionString;
    private Serializer<T> serializer;
    private String hostname;
    private int port;
    private T nodeData;
    private Supplier<Double> healthMetricSupplier;
    private int healthUpdateIntervalMs;
    private int staleUpdateThresholdMs;
    private List<Healthcheck> healthchecks = Lists.newArrayList();
    private List<IsolatedHealthMonitor> isolatedMonitors = Lists.newArrayList();

    public ServiceProviderBuilder<T> withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ServiceProviderBuilder<T> withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public ServiceProviderBuilder<T> withCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
        return this;
    }

    public ServiceProviderBuilder<T> withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public ServiceProviderBuilder<T> withSerializer(Serializer<T> deserializer) {
        this.serializer = deserializer;
        return this;
    }

    public ServiceProviderBuilder<T> withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public ServiceProviderBuilder<T> withPort(int port) {
        this.port = port;
        return this;
    }

    public ServiceProviderBuilder<T> withNodeData(T nodeData) {
        this.nodeData = nodeData;
        return this;
    }

    public ServiceProviderBuilder<T> withHealthMetricSupplier(Supplier<Double> healthMetricSupplier) {
        this.healthMetricSupplier = healthMetricSupplier;
        return this;
    }

    public ServiceProviderBuilder<T> withHealthcheck(Healthcheck healthcheck) {
        this.healthchecks.add(healthcheck);
        return this;
    }

    public ServiceProviderBuilder<T> withHealthUpdateIntervalMs(int healthUpdateIntervalMs) {
        this.healthUpdateIntervalMs = healthUpdateIntervalMs;
        return this;
    }

    public ServiceProviderBuilder<T> withStaleUpdateThresholdMs(int staleUpdateThresholdMs) {
        this.staleUpdateThresholdMs = staleUpdateThresholdMs;
        return this;
    }

    public ServiceProviderBuilder<T> withIsolatedHealthMonitor(IsolatedHealthMonitor monitor) {
        this.isolatedMonitors.add(monitor);
        return this;
    }

    public ServiceProvider<T> buildServiceDiscovery() {
        Preconditions.checkNotNull((Object)this.namespace);
        Preconditions.checkNotNull((Object)this.serviceName);
        Preconditions.checkNotNull(this.serializer);
        Preconditions.checkNotNull((Object)this.hostname);
        Preconditions.checkArgument((this.port > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.healthchecks.isEmpty() || !this.isolatedMonitors.isEmpty() ? 1 : 0) != 0);
        if (null == this.curatorFramework) {
            Preconditions.checkNotNull((Object)this.connectionString);
            this.curatorFramework = CuratorFrameworkFactory.builder().namespace(this.namespace).connectString(this.connectionString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 100)).build();
            this.curatorFramework.start();
        }
        if (this.healthUpdateIntervalMs < 1000 || this.healthUpdateIntervalMs > 20000) {
            LOGGER.warn("Health update interval for {} should be between 1000ms and 20000ms. Current value: {} ms. Being set to 1000ms", (Object)this.serviceName, (Object)this.healthUpdateIntervalMs);
            this.healthUpdateIntervalMs = 1000;
        }
        if (this.staleUpdateThresholdMs < 5000 || this.staleUpdateThresholdMs > 20000) {
            LOGGER.warn("Stale update threshold for {} should be between 5000ms and 20000ms. Current value: {} ms. Being set to 5000ms", (Object)this.serviceName, (Object)this.staleUpdateThresholdMs);
            this.staleUpdateThresholdMs = 5000;
        }
        ServiceHealthAggregator serviceHealthAggregator = new ServiceHealthAggregator();
        for (IsolatedHealthMonitor isolatedMonitor : this.isolatedMonitors) {
            serviceHealthAggregator.addIsolatedMonitor(isolatedMonitor);
        }
        this.healthchecks.add(serviceHealthAggregator);
        return new ServiceProvider<T>(this.serviceName, this.serializer, this.curatorFramework, new ServiceNode<T>(this.hostname, this.port, this.nodeData), this.healthchecks, this.healthMetricSupplier, this.healthUpdateIntervalMs, this.staleUpdateThresholdMs, serviceHealthAggregator);
    }
}

