/*
 * Decompiled with CFR 0.152.
 */
package io.exo.csrestrictions;

import com.cloud.exception.InvalidParameterValueException;
import com.cloud.utils.PropertiesUtil;
import io.exo.csrestrictions.Restriction;
import io.exo.csrestrictions.RestrictionList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictionListManager {
    private static RestrictionList _restrictionList = null;
    private static Boolean _loaded = false;

    private static void _loadFromYaml(String data) {
        Constructor ctor = new Constructor(RestrictionList.class);
        TypeDescription tdesc = new TypeDescription(RestrictionList.class);
        tdesc.putMapPropertyType("restrictions", Restriction.class, Object.class);
        ctor.addTypeDescription(tdesc);
        Yaml parser = new Yaml((BaseConstructor)ctor);
        _restrictionList = (RestrictionList)parser.load(data);
    }

    private static void _loadRestrictionList() throws IOException {
        Path path = PropertiesUtil.findConfigFile((String)"restrictions.yaml").toPath();
        byte[] ba = Files.readAllBytes(path);
        String data = new String(ba, "UTF-8");
        RestrictionListManager._loadFromYaml(data);
        _loaded = true;
    }

    public static void enforceRestrictions(String serviceOfferingId, String templateName, Long templateSize) throws InvalidParameterValueException {
        if (serviceOfferingId == null) {
            return;
        }
        try {
            List<Restriction> restrictions = RestrictionListManager.getRestrictions();
            for (Restriction restriction : restrictions) {
                if (restriction.getTemplateNamePattern() != null && templateName != null && serviceOfferingId.equals(restriction.getServiceOfferingId()) && restriction.getTemplateNamePattern().matcher(templateName).find()) {
                    throw new InvalidParameterValueException("Template is restricted for this service offering.");
                }
                if (restriction.getMaxTemplateSize() == null || !serviceOfferingId.equals(restriction.getServiceOfferingId()) || restriction.getMaxTemplateSize() >= templateSize) continue;
                throw new InvalidParameterValueException("The required disk size is restricted for this template");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List<Restriction> getRestrictions() throws IOException {
        if (!_loaded.booleanValue()) {
            RestrictionListManager._loadRestrictionList();
        }
        return _restrictionList.getRestrictions();
    }
}

