// Compiled by ClojureScript 0.0-2727 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string.StringBuffer');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-2727";
cljs.core._STAR_unchecked_if_STAR_ = false;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
* Each runtime environment provides a different way to print output.
* Whatever function *print-fn* is bound to will be passed any
* Strings which should be printed.
*/
cljs.core._STAR_print_fn_STAR_ = (function _STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
* Set *print-fn* to f.
*/
cljs.core.set_print_fn_BANG_ = (function set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
* Set *print-fn* to console.log
*/
cljs.core.enable_console_print_BANG_ = (function enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__7478__delegate = function (args){
return console.log.apply(console,(function (){var G__7477 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__7477) : cljs.core.into_array.call(null,G__7477));
})());
};
var G__7478 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7479__i = 0, G__7479__a = new Array(arguments.length -  0);
while (G__7479__i < G__7479__a.length) {G__7479__a[G__7479__i] = arguments[G__7479__i + 0]; ++G__7479__i;}
  args = new cljs.core.IndexedSeq(G__7479__a,0);
} 
return G__7478__delegate.call(this,args);};
G__7478.cljs$lang$maxFixedArity = 0;
G__7478.cljs$lang$applyTo = (function (arglist__7480){
var args = cljs.core.seq(arglist__7480);
return G__7478__delegate(args);
});
G__7478.cljs$core$IFn$_invoke$arity$variadic = G__7478__delegate;
return G__7478;
})()
;
});
/**
* Internal - do not use!
*/
cljs.core.truth_ = (function truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
* Tests if 2 arguments are the same object
*/
cljs.core.identical_QMARK_ = (function identical_QMARK_(x,y){
return (x === y);
});
/**
* Returns true if x is nil, false otherwise.
*/
cljs.core.nil_QMARK_ = (function nil_QMARK_(x){
return (x == null);
});
cljs.core.array_QMARK_ = (function array_QMARK_(x){
return x instanceof Array;
});
cljs.core.number_QMARK_ = (function number_QMARK_(n){
return typeof n === 'number';
});
/**
* Returns true if x is logical false, false otherwise.
*/
cljs.core.not = (function not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
* Returns true if x is not nil, false otherwise.
*/
cljs.core.some_QMARK_ = (function some_QMARK_(x){
return !((x == null));
});
cljs.core.object_QMARK_ = (function object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
cljs.core.string_QMARK_ = (function string_QMARK_(x){
var G__7482 = x;
return goog.isString(G__7482);
});
/**
* Internal - do not use!
*/
cljs.core.native_satisfies_QMARK_ = (function native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__7484 = x__$1;
return goog.typeOf(G__7484);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function is_proto_(x){
return (x.constructor.prototype === x);
});
/**
* When compiled for a command-line target, whatever
* function *main-fn* is set to will be called with the command-line
* argv as arguments
*/
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = (function type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__3746__auto__ = ty;
if(cljs.core.truth_(and__3746__auto__)){
return ty.cljs$lang$type;
} else {
return and__3746__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__7486 = obj;
return goog.typeOf(G__7486);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function type__GT_str(ty){
var temp__4124__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4124__auto__)){
var s = temp__4124__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.importScript_(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__7488 = Symbol;
return goog.typeOf(G__7488);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.make_array = (function() {
var make_array = null;
var make_array__1 = (function (size){
return (new Array(size));
});
var make_array__2 = (function (type,size){
return make_array.cljs$core$IFn$_invoke$arity$1(size);
});
make_array = function(type,size){
switch(arguments.length){
case 1:
return make_array__1.call(this,type);
case 2:
return make_array__2.call(this,type,size);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
make_array.cljs$core$IFn$_invoke$arity$1 = make_array__1;
make_array.cljs$core$IFn$_invoke$arity$2 = make_array__2;
return make_array;
})()
;
/**
* Returns a javascript array, cloned from the passed in array
*/
cljs.core.aclone = (function aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4645__auto___7490 = len;
var i_7491 = (0);
while(true){
if((i_7491 < n__4645__auto___7490)){
(new_arr[i_7491] = (arr[i_7491]));

var G__7492 = (i_7491 + (1));
i_7491 = G__7492;
continue;
} else {
}
break;
}

return new_arr;
});
/**
* Creates a new javascript array.
* @param {...*} var_args
*/
cljs.core.array = (function array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__7493 = (i + (1));
i = G__7493;
continue;
} else {
return a;
}
break;
}
});
/**
* Returns the value at the index.
* @param {...*} var_args
*/
cljs.core.aget = (function() {
var aget = null;
var aget__2 = (function (array,i){
return (array[i]);
});
var aget__3 = (function() { 
var G__7502__delegate = function (array,i,idxs){
var G__7499 = aget;
var G__7500 = aget.cljs$core$IFn$_invoke$arity$2(array,i);
var G__7501 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__7499,G__7500,G__7501) : cljs.core.apply.call(null,G__7499,G__7500,G__7501));
};
var G__7502 = function (array,i,var_args){
var idxs = null;
if (arguments.length > 2) {
var G__7503__i = 0, G__7503__a = new Array(arguments.length -  2);
while (G__7503__i < G__7503__a.length) {G__7503__a[G__7503__i] = arguments[G__7503__i + 2]; ++G__7503__i;}
  idxs = new cljs.core.IndexedSeq(G__7503__a,0);
} 
return G__7502__delegate.call(this,array,i,idxs);};
G__7502.cljs$lang$maxFixedArity = 2;
G__7502.cljs$lang$applyTo = (function (arglist__7504){
var array = cljs.core.first(arglist__7504);
arglist__7504 = cljs.core.next(arglist__7504);
var i = cljs.core.first(arglist__7504);
var idxs = cljs.core.rest(arglist__7504);
return G__7502__delegate(array,i,idxs);
});
G__7502.cljs$core$IFn$_invoke$arity$variadic = G__7502__delegate;
return G__7502;
})()
;
aget = function(array,i,var_args){
var idxs = var_args;
switch(arguments.length){
case 2:
return aget__2.call(this,array,i);
default:
var G__7505 = null;
if (arguments.length > 2) {
var G__7506__i = 0, G__7506__a = new Array(arguments.length -  2);
while (G__7506__i < G__7506__a.length) {G__7506__a[G__7506__i] = arguments[G__7506__i + 2]; ++G__7506__i;}
G__7505 = new cljs.core.IndexedSeq(G__7506__a,0);
}
return aget__3.cljs$core$IFn$_invoke$arity$variadic(array,i, G__7505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
aget.cljs$lang$maxFixedArity = 2;
aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
aget.cljs$core$IFn$_invoke$arity$2 = aget__2;
aget.cljs$core$IFn$_invoke$arity$variadic = aget__3.cljs$core$IFn$_invoke$arity$variadic;
return aget;
})()
;
/**
* Sets the value at the index.
* @param {...*} var_args
*/
cljs.core.aset = (function() {
var aset = null;
var aset__3 = (function (array,i,val){
return (array[i] = val);
});
var aset__4 = (function() { 
var G__7515__delegate = function (array,idx,idx2,idxv){
var G__7511 = aset;
var G__7512 = (array[idx]);
var G__7513 = idx2;
var G__7514 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__7511,G__7512,G__7513,G__7514) : cljs.core.apply.call(null,G__7511,G__7512,G__7513,G__7514));
};
var G__7515 = function (array,idx,idx2,var_args){
var idxv = null;
if (arguments.length > 3) {
var G__7516__i = 0, G__7516__a = new Array(arguments.length -  3);
while (G__7516__i < G__7516__a.length) {G__7516__a[G__7516__i] = arguments[G__7516__i + 3]; ++G__7516__i;}
  idxv = new cljs.core.IndexedSeq(G__7516__a,0);
} 
return G__7515__delegate.call(this,array,idx,idx2,idxv);};
G__7515.cljs$lang$maxFixedArity = 3;
G__7515.cljs$lang$applyTo = (function (arglist__7517){
var array = cljs.core.first(arglist__7517);
arglist__7517 = cljs.core.next(arglist__7517);
var idx = cljs.core.first(arglist__7517);
arglist__7517 = cljs.core.next(arglist__7517);
var idx2 = cljs.core.first(arglist__7517);
var idxv = cljs.core.rest(arglist__7517);
return G__7515__delegate(array,idx,idx2,idxv);
});
G__7515.cljs$core$IFn$_invoke$arity$variadic = G__7515__delegate;
return G__7515;
})()
;
aset = function(array,idx,idx2,var_args){
var idxv = var_args;
switch(arguments.length){
case 3:
return aset__3.call(this,array,idx,idx2);
default:
var G__7518 = null;
if (arguments.length > 3) {
var G__7519__i = 0, G__7519__a = new Array(arguments.length -  3);
while (G__7519__i < G__7519__a.length) {G__7519__a[G__7519__i] = arguments[G__7519__i + 3]; ++G__7519__i;}
G__7518 = new cljs.core.IndexedSeq(G__7519__a,0);
}
return aset__4.cljs$core$IFn$_invoke$arity$variadic(array,idx,idx2, G__7518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
aset.cljs$lang$maxFixedArity = 3;
aset.cljs$lang$applyTo = aset__4.cljs$lang$applyTo;
aset.cljs$core$IFn$_invoke$arity$3 = aset__3;
aset.cljs$core$IFn$_invoke$arity$variadic = aset__4.cljs$core$IFn$_invoke$arity$variadic;
return aset;
})()
;
/**
* Returns the length of the array. Works on arrays of all types.
*/
cljs.core.alength = (function alength(array){
return array.length;
});
cljs.core.into_array = (function() {
var into_array = null;
var into_array__1 = (function (aseq){
return into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});
var into_array__2 = (function (type,aseq){
var G__7525 = (function (a,x){
a.push(x);

return a;
});
var G__7526 = [];
var G__7527 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__7525,G__7526,G__7527) : cljs.core.reduce.call(null,G__7525,G__7526,G__7527));
});
into_array = function(type,aseq){
switch(arguments.length){
case 1:
return into_array__1.call(this,type);
case 2:
return into_array__2.call(this,type,aseq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
into_array.cljs$core$IFn$_invoke$arity$1 = into_array__1;
into_array.cljs$core$IFn$_invoke$arity$2 = into_array__2;
return into_array;
})()
;
/**
* Invoke JavaScript object method via string. Needed when the
* string is not a valid unquoted property name.
* @param {...*} var_args
*/
cljs.core.js_invoke = (function() { 
var js_invoke__delegate = function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
var js_invoke = function (obj,s,var_args){
var args = null;
if (arguments.length > 2) {
var G__7528__i = 0, G__7528__a = new Array(arguments.length -  2);
while (G__7528__i < G__7528__a.length) {G__7528__a[G__7528__i] = arguments[G__7528__i + 2]; ++G__7528__i;}
  args = new cljs.core.IndexedSeq(G__7528__a,0);
} 
return js_invoke__delegate.call(this,obj,s,args);};
js_invoke.cljs$lang$maxFixedArity = 2;
js_invoke.cljs$lang$applyTo = (function (arglist__7529){
var obj = cljs.core.first(arglist__7529);
arglist__7529 = cljs.core.next(arglist__7529);
var s = cljs.core.first(arglist__7529);
var args = cljs.core.rest(arglist__7529);
return js_invoke__delegate(obj,s,args);
});
js_invoke.cljs$core$IFn$_invoke$arity$variadic = js_invoke__delegate;
return js_invoke;
})()
;

cljs.core.Fn = (function (){var obj7531 = {};
return obj7531;
})();


cljs.core.IFn = (function (){var obj7533 = {};
return obj7533;
})();

cljs.core._invoke = (function() {
var _invoke = null;
var _invoke__1 = (function (this$){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7579 = x__4402__auto__;
return goog.typeOf(G__7579);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});
var _invoke__2 = (function (this$,a){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7581 = x__4402__auto__;
return goog.typeOf(G__7581);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});
var _invoke__3 = (function (this$,a,b){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7583 = x__4402__auto__;
return goog.typeOf(G__7583);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});
var _invoke__4 = (function (this$,a,b,c){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7585 = x__4402__auto__;
return goog.typeOf(G__7585);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});
var _invoke__5 = (function (this$,a,b,c,d){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7587 = x__4402__auto__;
return goog.typeOf(G__7587);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});
var _invoke__6 = (function (this$,a,b,c,d,e){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7589 = x__4402__auto__;
return goog.typeOf(G__7589);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});
var _invoke__7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7591 = x__4402__auto__;
return goog.typeOf(G__7591);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});
var _invoke__8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7593 = x__4402__auto__;
return goog.typeOf(G__7593);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});
var _invoke__9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7595 = x__4402__auto__;
return goog.typeOf(G__7595);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});
var _invoke__10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7597 = x__4402__auto__;
return goog.typeOf(G__7597);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});
var _invoke__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7599 = x__4402__auto__;
return goog.typeOf(G__7599);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});
var _invoke__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7601 = x__4402__auto__;
return goog.typeOf(G__7601);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});
var _invoke__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7603 = x__4402__auto__;
return goog.typeOf(G__7603);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});
var _invoke__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7605 = x__4402__auto__;
return goog.typeOf(G__7605);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});
var _invoke__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7607 = x__4402__auto__;
return goog.typeOf(G__7607);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});
var _invoke__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7609 = x__4402__auto__;
return goog.typeOf(G__7609);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});
var _invoke__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7611 = x__4402__auto__;
return goog.typeOf(G__7611);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});
var _invoke__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7613 = x__4402__auto__;
return goog.typeOf(G__7613);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});
var _invoke__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7615 = x__4402__auto__;
return goog.typeOf(G__7615);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});
var _invoke__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7617 = x__4402__auto__;
return goog.typeOf(G__7617);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});
var _invoke__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7619 = x__4402__auto__;
return goog.typeOf(G__7619);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});
var _invoke__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._invoke[(function (){var G__7621 = x__4402__auto__;
return goog.typeOf(G__7621);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._invoke["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});
_invoke = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return _invoke__1.call(this,this$);
case 2:
return _invoke__2.call(this,this$,a);
case 3:
return _invoke__3.call(this,this$,a,b);
case 4:
return _invoke__4.call(this,this$,a,b,c);
case 5:
return _invoke__5.call(this,this$,a,b,c,d);
case 6:
return _invoke__6.call(this,this$,a,b,c,d,e);
case 7:
return _invoke__7.call(this,this$,a,b,c,d,e,f);
case 8:
return _invoke__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return _invoke__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return _invoke__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return _invoke__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return _invoke__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return _invoke__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return _invoke__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return _invoke__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return _invoke__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return _invoke__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return _invoke__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return _invoke__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return _invoke__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return _invoke__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return _invoke__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_invoke.cljs$core$IFn$_invoke$arity$1 = _invoke__1;
_invoke.cljs$core$IFn$_invoke$arity$2 = _invoke__2;
_invoke.cljs$core$IFn$_invoke$arity$3 = _invoke__3;
_invoke.cljs$core$IFn$_invoke$arity$4 = _invoke__4;
_invoke.cljs$core$IFn$_invoke$arity$5 = _invoke__5;
_invoke.cljs$core$IFn$_invoke$arity$6 = _invoke__6;
_invoke.cljs$core$IFn$_invoke$arity$7 = _invoke__7;
_invoke.cljs$core$IFn$_invoke$arity$8 = _invoke__8;
_invoke.cljs$core$IFn$_invoke$arity$9 = _invoke__9;
_invoke.cljs$core$IFn$_invoke$arity$10 = _invoke__10;
_invoke.cljs$core$IFn$_invoke$arity$11 = _invoke__11;
_invoke.cljs$core$IFn$_invoke$arity$12 = _invoke__12;
_invoke.cljs$core$IFn$_invoke$arity$13 = _invoke__13;
_invoke.cljs$core$IFn$_invoke$arity$14 = _invoke__14;
_invoke.cljs$core$IFn$_invoke$arity$15 = _invoke__15;
_invoke.cljs$core$IFn$_invoke$arity$16 = _invoke__16;
_invoke.cljs$core$IFn$_invoke$arity$17 = _invoke__17;
_invoke.cljs$core$IFn$_invoke$arity$18 = _invoke__18;
_invoke.cljs$core$IFn$_invoke$arity$19 = _invoke__19;
_invoke.cljs$core$IFn$_invoke$arity$20 = _invoke__20;
_invoke.cljs$core$IFn$_invoke$arity$21 = _invoke__21;
_invoke.cljs$core$IFn$_invoke$arity$22 = _invoke__22;
return _invoke;
})()
;


cljs.core.ICloneable = (function (){var obj7623 = {};
return obj7623;
})();

cljs.core._clone = (function _clone(value){
if((function (){var and__3746__auto__ = value;
if(and__3746__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__3746__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4402__auto__ = (((value == null))?null:value);
return (function (){var or__3758__auto__ = (cljs.core._clone[(function (){var G__7627 = x__4402__auto__;
return goog.typeOf(G__7627);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._clone["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


cljs.core.ICounted = (function (){var obj7629 = {};
return obj7629;
})();

cljs.core._count = (function _count(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._count[(function (){var G__7633 = x__4402__auto__;
return goog.typeOf(G__7633);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._count["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IEmptyableCollection = (function (){var obj7635 = {};
return obj7635;
})();

cljs.core._empty = (function _empty(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._empty[(function (){var G__7639 = x__4402__auto__;
return goog.typeOf(G__7639);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._empty["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ICollection = (function (){var obj7641 = {};
return obj7641;
})();

cljs.core._conj = (function _conj(coll,o){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._conj[(function (){var G__7645 = x__4402__auto__;
return goog.typeOf(G__7645);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._conj["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


cljs.core.IIndexed = (function (){var obj7647 = {};
return obj7647;
})();

cljs.core._nth = (function() {
var _nth = null;
var _nth__2 = (function (coll,n){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._nth[(function (){var G__7653 = x__4402__auto__;
return goog.typeOf(G__7653);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._nth["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});
var _nth__3 = (function (coll,n,not_found){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._nth[(function (){var G__7655 = x__4402__auto__;
return goog.typeOf(G__7655);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._nth["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});
_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return _nth__2.call(this,coll,n);
case 3:
return _nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_nth.cljs$core$IFn$_invoke$arity$2 = _nth__2;
_nth.cljs$core$IFn$_invoke$arity$3 = _nth__3;
return _nth;
})()
;


cljs.core.ASeq = (function (){var obj7657 = {};
return obj7657;
})();


cljs.core.ISeq = (function (){var obj7659 = {};
return obj7659;
})();

cljs.core._first = (function _first(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._first[(function (){var G__7663 = x__4402__auto__;
return goog.typeOf(G__7663);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._first["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

cljs.core._rest = (function _rest(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._rest[(function (){var G__7667 = x__4402__auto__;
return goog.typeOf(G__7667);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._rest["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


cljs.core.INext = (function (){var obj7669 = {};
return obj7669;
})();

cljs.core._next = (function _next(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._next[(function (){var G__7673 = x__4402__auto__;
return goog.typeOf(G__7673);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._next["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ILookup = (function (){var obj7675 = {};
return obj7675;
})();

cljs.core._lookup = (function() {
var _lookup = null;
var _lookup__2 = (function (o,k){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._lookup[(function (){var G__7681 = x__4402__auto__;
return goog.typeOf(G__7681);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._lookup["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});
var _lookup__3 = (function (o,k,not_found){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._lookup[(function (){var G__7683 = x__4402__auto__;
return goog.typeOf(G__7683);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._lookup["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});
_lookup = function(o,k,not_found){
switch(arguments.length){
case 2:
return _lookup__2.call(this,o,k);
case 3:
return _lookup__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_lookup.cljs$core$IFn$_invoke$arity$2 = _lookup__2;
_lookup.cljs$core$IFn$_invoke$arity$3 = _lookup__3;
return _lookup;
})()
;


cljs.core.IAssociative = (function (){var obj7685 = {};
return obj7685;
})();

cljs.core._contains_key_QMARK_ = (function _contains_key_QMARK_(coll,k){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__7689 = x__4402__auto__;
return goog.typeOf(G__7689);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

cljs.core._assoc = (function _assoc(coll,k,v){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._assoc[(function (){var G__7693 = x__4402__auto__;
return goog.typeOf(G__7693);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


cljs.core.IMap = (function (){var obj7695 = {};
return obj7695;
})();

cljs.core._dissoc = (function _dissoc(coll,k){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._dissoc[(function (){var G__7699 = x__4402__auto__;
return goog.typeOf(G__7699);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._dissoc["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


cljs.core.IMapEntry = (function (){var obj7701 = {};
return obj7701;
})();

cljs.core._key = (function _key(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._key[(function (){var G__7705 = x__4402__auto__;
return goog.typeOf(G__7705);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._key["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

cljs.core._val = (function _val(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._val[(function (){var G__7709 = x__4402__auto__;
return goog.typeOf(G__7709);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._val["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ISet = (function (){var obj7711 = {};
return obj7711;
})();

cljs.core._disjoin = (function _disjoin(coll,v){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._disjoin[(function (){var G__7715 = x__4402__auto__;
return goog.typeOf(G__7715);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._disjoin["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


cljs.core.IStack = (function (){var obj7717 = {};
return obj7717;
})();

cljs.core._peek = (function _peek(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._peek[(function (){var G__7721 = x__4402__auto__;
return goog.typeOf(G__7721);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._peek["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

cljs.core._pop = (function _pop(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._pop[(function (){var G__7725 = x__4402__auto__;
return goog.typeOf(G__7725);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._pop["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IVector = (function (){var obj7727 = {};
return obj7727;
})();

cljs.core._assoc_n = (function _assoc_n(coll,n,val){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._assoc_n[(function (){var G__7731 = x__4402__auto__;
return goog.typeOf(G__7731);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


cljs.core.IDeref = (function (){var obj7733 = {};
return obj7733;
})();

cljs.core._deref = (function _deref(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._deref[(function (){var G__7737 = x__4402__auto__;
return goog.typeOf(G__7737);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._deref["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj7739 = {};
return obj7739;
})();

cljs.core._deref_with_timeout = (function _deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._deref_with_timeout[(function (){var G__7743 = x__4402__auto__;
return goog.typeOf(G__7743);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


cljs.core.IMeta = (function (){var obj7745 = {};
return obj7745;
})();

cljs.core._meta = (function _meta(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._meta[(function (){var G__7749 = x__4402__auto__;
return goog.typeOf(G__7749);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._meta["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


cljs.core.IWithMeta = (function (){var obj7751 = {};
return obj7751;
})();

cljs.core._with_meta = (function _with_meta(o,meta){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._with_meta[(function (){var G__7755 = x__4402__auto__;
return goog.typeOf(G__7755);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._with_meta["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


cljs.core.IReduce = (function (){var obj7757 = {};
return obj7757;
})();

cljs.core._reduce = (function() {
var _reduce = null;
var _reduce__2 = (function (coll,f){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._reduce[(function (){var G__7763 = x__4402__auto__;
return goog.typeOf(G__7763);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reduce["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});
var _reduce__3 = (function (coll,f,start){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._reduce[(function (){var G__7765 = x__4402__auto__;
return goog.typeOf(G__7765);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reduce["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});
_reduce = function(coll,f,start){
switch(arguments.length){
case 2:
return _reduce__2.call(this,coll,f);
case 3:
return _reduce__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_reduce.cljs$core$IFn$_invoke$arity$2 = _reduce__2;
_reduce.cljs$core$IFn$_invoke$arity$3 = _reduce__3;
return _reduce;
})()
;


cljs.core.IKVReduce = (function (){var obj7767 = {};
return obj7767;
})();

cljs.core._kv_reduce = (function _kv_reduce(coll,f,init){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._kv_reduce[(function (){var G__7771 = x__4402__auto__;
return goog.typeOf(G__7771);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


cljs.core.IEquiv = (function (){var obj7773 = {};
return obj7773;
})();

cljs.core._equiv = (function _equiv(o,other){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._equiv[(function (){var G__7777 = x__4402__auto__;
return goog.typeOf(G__7777);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._equiv["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


cljs.core.IHash = (function (){var obj7779 = {};
return obj7779;
})();

cljs.core._hash = (function _hash(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._hash[(function (){var G__7783 = x__4402__auto__;
return goog.typeOf(G__7783);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._hash["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


cljs.core.ISeqable = (function (){var obj7785 = {};
return obj7785;
})();

cljs.core._seq = (function _seq(o){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._seq[(function (){var G__7789 = x__4402__auto__;
return goog.typeOf(G__7789);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._seq["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


cljs.core.ISequential = (function (){var obj7791 = {};
return obj7791;
})();


cljs.core.IList = (function (){var obj7793 = {};
return obj7793;
})();


cljs.core.IRecord = (function (){var obj7795 = {};
return obj7795;
})();


cljs.core.IReversible = (function (){var obj7797 = {};
return obj7797;
})();

cljs.core._rseq = (function _rseq(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._rseq[(function (){var G__7801 = x__4402__auto__;
return goog.typeOf(G__7801);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._rseq["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ISorted = (function (){var obj7803 = {};
return obj7803;
})();

cljs.core._sorted_seq = (function _sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._sorted_seq[(function (){var G__7807 = x__4402__auto__;
return goog.typeOf(G__7807);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

cljs.core._sorted_seq_from = (function _sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._sorted_seq_from[(function (){var G__7811 = x__4402__auto__;
return goog.typeOf(G__7811);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

cljs.core._entry_key = (function _entry_key(coll,entry){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._entry_key[(function (){var G__7815 = x__4402__auto__;
return goog.typeOf(G__7815);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._entry_key["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

cljs.core._comparator = (function _comparator(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._comparator[(function (){var G__7819 = x__4402__auto__;
return goog.typeOf(G__7819);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._comparator["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IWriter = (function (){var obj7821 = {};
return obj7821;
})();

cljs.core._write = (function _write(writer,s){
if((function (){var and__3746__auto__ = writer;
if(and__3746__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__3746__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4402__auto__ = (((writer == null))?null:writer);
return (function (){var or__3758__auto__ = (cljs.core._write[(function (){var G__7825 = x__4402__auto__;
return goog.typeOf(G__7825);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._write["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

cljs.core._flush = (function _flush(writer){
if((function (){var and__3746__auto__ = writer;
if(and__3746__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__3746__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4402__auto__ = (((writer == null))?null:writer);
return (function (){var or__3758__auto__ = (cljs.core._flush[(function (){var G__7829 = x__4402__auto__;
return goog.typeOf(G__7829);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._flush["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


cljs.core.IPrintWithWriter = (function (){var obj7831 = {};
return obj7831;
})();

cljs.core._pr_writer = (function _pr_writer(o,writer,opts){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._pr_writer[(function (){var G__7835 = x__4402__auto__;
return goog.typeOf(G__7835);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


cljs.core.IPending = (function (){var obj7837 = {};
return obj7837;
})();

cljs.core._realized_QMARK_ = (function _realized_QMARK_(d){
if((function (){var and__3746__auto__ = d;
if(and__3746__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4402__auto__ = (((d == null))?null:d);
return (function (){var or__3758__auto__ = (cljs.core._realized_QMARK_[(function (){var G__7841 = x__4402__auto__;
return goog.typeOf(G__7841);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


cljs.core.IWatchable = (function (){var obj7843 = {};
return obj7843;
})();

cljs.core._notify_watches = (function _notify_watches(this$,oldval,newval){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._notify_watches[(function (){var G__7847 = x__4402__auto__;
return goog.typeOf(G__7847);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

cljs.core._add_watch = (function _add_watch(this$,key,f){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._add_watch[(function (){var G__7851 = x__4402__auto__;
return goog.typeOf(G__7851);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._add_watch["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

cljs.core._remove_watch = (function _remove_watch(this$,key){
if((function (){var and__3746__auto__ = this$;
if(and__3746__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__3746__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4402__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3758__auto__ = (cljs.core._remove_watch[(function (){var G__7855 = x__4402__auto__;
return goog.typeOf(G__7855);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


cljs.core.IEditableCollection = (function (){var obj7857 = {};
return obj7857;
})();

cljs.core._as_transient = (function _as_transient(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._as_transient[(function (){var G__7861 = x__4402__auto__;
return goog.typeOf(G__7861);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._as_transient["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


cljs.core.ITransientCollection = (function (){var obj7863 = {};
return obj7863;
})();

cljs.core._conj_BANG_ = (function _conj_BANG_(tcoll,val){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._conj_BANG_[(function (){var G__7867 = x__4402__auto__;
return goog.typeOf(G__7867);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

cljs.core._persistent_BANG_ = (function _persistent_BANG_(tcoll){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._persistent_BANG_[(function (){var G__7871 = x__4402__auto__;
return goog.typeOf(G__7871);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


cljs.core.ITransientAssociative = (function (){var obj7873 = {};
return obj7873;
})();

cljs.core._assoc_BANG_ = (function _assoc_BANG_(tcoll,key,val){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._assoc_BANG_[(function (){var G__7877 = x__4402__auto__;
return goog.typeOf(G__7877);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


cljs.core.ITransientMap = (function (){var obj7879 = {};
return obj7879;
})();

cljs.core._dissoc_BANG_ = (function _dissoc_BANG_(tcoll,key){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__7883 = x__4402__auto__;
return goog.typeOf(G__7883);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


cljs.core.ITransientVector = (function (){var obj7885 = {};
return obj7885;
})();

cljs.core._assoc_n_BANG_ = (function _assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__7889 = x__4402__auto__;
return goog.typeOf(G__7889);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

cljs.core._pop_BANG_ = (function _pop_BANG_(tcoll){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._pop_BANG_[(function (){var G__7893 = x__4402__auto__;
return goog.typeOf(G__7893);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


cljs.core.ITransientSet = (function (){var obj7895 = {};
return obj7895;
})();

cljs.core._disjoin_BANG_ = (function _disjoin_BANG_(tcoll,v){
if((function (){var and__3746__auto__ = tcoll;
if(and__3746__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4402__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3758__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__7899 = x__4402__auto__;
return goog.typeOf(G__7899);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


cljs.core.IComparable = (function (){var obj7901 = {};
return obj7901;
})();

cljs.core._compare = (function _compare(x,y){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._compare[(function (){var G__7905 = x__4402__auto__;
return goog.typeOf(G__7905);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._compare["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


cljs.core.IChunk = (function (){var obj7907 = {};
return obj7907;
})();

cljs.core._drop_first = (function _drop_first(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._drop_first[(function (){var G__7911 = x__4402__auto__;
return goog.typeOf(G__7911);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._drop_first["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IChunkedSeq = (function (){var obj7913 = {};
return obj7913;
})();

cljs.core._chunked_first = (function _chunked_first(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._chunked_first[(function (){var G__7917 = x__4402__auto__;
return goog.typeOf(G__7917);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

cljs.core._chunked_rest = (function _chunked_rest(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._chunked_rest[(function (){var G__7921 = x__4402__auto__;
return goog.typeOf(G__7921);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


cljs.core.IChunkedNext = (function (){var obj7923 = {};
return obj7923;
})();

cljs.core._chunked_next = (function _chunked_next(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._chunked_next[(function (){var G__7927 = x__4402__auto__;
return goog.typeOf(G__7927);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


cljs.core.INamed = (function (){var obj7929 = {};
return obj7929;
})();

cljs.core._name = (function _name(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._name[(function (){var G__7933 = x__4402__auto__;
return goog.typeOf(G__7933);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._name["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

cljs.core._namespace = (function _namespace(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._namespace[(function (){var G__7937 = x__4402__auto__;
return goog.typeOf(G__7937);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._namespace["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


cljs.core.IAtom = (function (){var obj7939 = {};
return obj7939;
})();


cljs.core.IReset = (function (){var obj7941 = {};
return obj7941;
})();

cljs.core._reset_BANG_ = (function _reset_BANG_(o,new_value){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._reset_BANG_[(function (){var G__7945 = x__4402__auto__;
return goog.typeOf(G__7945);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


cljs.core.ISwap = (function (){var obj7947 = {};
return obj7947;
})();

cljs.core._swap_BANG_ = (function() {
var _swap_BANG_ = null;
var _swap_BANG___2 = (function (o,f){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7957 = x__4402__auto__;
return goog.typeOf(G__7957);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});
var _swap_BANG___3 = (function (o,f,a){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7959 = x__4402__auto__;
return goog.typeOf(G__7959);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});
var _swap_BANG___4 = (function (o,f,a,b){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7961 = x__4402__auto__;
return goog.typeOf(G__7961);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});
var _swap_BANG___5 = (function (o,f,a,b,xs){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._swap_BANG_[(function (){var G__7963 = x__4402__auto__;
return goog.typeOf(G__7963);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});
_swap_BANG_ = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return _swap_BANG___2.call(this,o,f);
case 3:
return _swap_BANG___3.call(this,o,f,a);
case 4:
return _swap_BANG___4.call(this,o,f,a,b);
case 5:
return _swap_BANG___5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = _swap_BANG___2;
_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = _swap_BANG___3;
_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = _swap_BANG___4;
_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = _swap_BANG___5;
return _swap_BANG_;
})()
;


cljs.core.IVolatile = (function (){var obj7965 = {};
return obj7965;
})();

cljs.core._vreset_BANG_ = (function _vreset_BANG_(o,new_value){
if((function (){var and__3746__auto__ = o;
if(and__3746__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4402__auto__ = (((o == null))?null:o);
return (function (){var or__3758__auto__ = (cljs.core._vreset_BANG_[(function (){var G__7969 = x__4402__auto__;
return goog.typeOf(G__7969);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


cljs.core.IIterable = (function (){var obj7971 = {};
return obj7971;
})();

cljs.core._iterator = (function _iterator(coll){
if((function (){var and__3746__auto__ = coll;
if(and__3746__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__3746__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4402__auto__ = (((coll == null))?null:coll);
return (function (){var or__3758__auto__ = (cljs.core._iterator[(function (){var G__7975 = x__4402__auto__;
return goog.typeOf(G__7975);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._iterator["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function __GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
* Support so that collections can implement toString without
* loading all the printing machinery.
*/
cljs.core.pr_str_STAR_ = (function pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__7978 = (4294967295);
var G__7979 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__7978,G__7979) : Math.imul.call(null,G__7978,G__7979));
})() === (0))))){
cljs.core.imul = (function imul(a,b){
var G__7982 = a;
var G__7983 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__7982,G__7983) : Math.imul.call(null,G__7982,G__7983));
});
} else {
cljs.core.imul = (function imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = (3432918353);
cljs.core.m3_C2 = (461845907);
cljs.core.m3_mix_K1 = (function m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1,cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function m3_mix_H1(h1,k1){
return (cljs.core.imul(cljs.core.int_rotate_left((h1 ^ k1),(13)),(5)) + (3864292196));
});
cljs.core.m3_fmix = (function m3_fmix(h1,len){
var h1__$1 = h1;
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,(2246822507));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,(3266489909));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__7984 = (i + (2));
var G__7985 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__7984;
h1 = G__7985;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj7987 = {};
return obj7987;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__7988 = (i + (1));
var G__7989 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__7988;
hash = G__7989;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj7993 = {};
return obj7993;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
cljs.core.hash = (function hash(o){
if((function (){var G__7996 = o;
if(G__7996){
var bit__4432__auto__ = (G__7996.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4432__auto__) || (G__7996.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__7997 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__7997) : Math.floor.call(null,G__7997));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
cljs.core.instance_QMARK_ = (function instance_QMARK_(t,o){
return (o instanceof t);
});
cljs.core.symbol_QMARK_ = (function symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3746__auto__ = cljs.core.not(a.ns);
if(and__3746__auto__){
return b.ns;
} else {
return and__3746__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__8004 = a.ns;
var G__8005 = b.ns;
return goog.array.defaultCompare(G__8004,G__8005);
})();
if(((0) === nsc)){
var G__8006 = a.name;
var G__8007 = b.name;
return goog.array.defaultCompare(G__8006,G__8007);
} else {
return nsc;
}
}
} else {
var G__8008 = a.name;
var G__8009 = b.name;
return goog.array.defaultCompare(G__8008,G__8009);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4179__auto__ = self__._hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.call = (function() {
var G__8011 = null;
var G__8011__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__8011__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__8011 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__8011__2.call(this,self__,coll);
case 3:
return G__8011__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8011.cljs$core$IFn$_invoke$arity$2 = G__8011__2;
G__8011.cljs$core$IFn$_invoke$arity$3 = G__8011__3;
return G__8011;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args8010){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args8010)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function __GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function() {
var symbol = null;
var symbol__1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});
var symbol__2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});
symbol = function(ns,name){
switch(arguments.length){
case 1:
return symbol__1.call(this,ns);
case 2:
return symbol__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
symbol.cljs$core$IFn$_invoke$arity$1 = symbol__1;
symbol.cljs$core$IFn$_invoke$arity$2 = symbol__2;
return symbol;
})()
;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 163841;
})
cljs.core.Var.prototype.call = (function() {
var G__8059 = null;
var G__8059__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__8059__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__8059__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__8059__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__8059__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__8059__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__8059__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__8059__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__8059__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__8059__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__8059__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__8059__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__8059__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__8059__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__8059__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__8059__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__8059__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__8059__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__8059__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__8059__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__8059__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__8059__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8015 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__8016 = a;
var G__8017 = b;
var G__8018 = c;
var G__8019 = d;
var G__8020 = e;
var G__8021 = f;
var G__8022 = g;
var G__8023 = h;
var G__8024 = i;
var G__8025 = j;
var G__8026 = k;
var G__8027 = l;
var G__8028 = m;
var G__8029 = n;
var G__8030 = o;
var G__8031 = p;
var G__8032 = q;
var G__8033 = r;
var G__8034 = s;
var G__8035 = t;
var G__8036 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8015,G__8016,G__8017,G__8018,G__8019,G__8020,G__8021,G__8022,G__8023,G__8024,G__8025,G__8026,G__8027,G__8028,G__8029,G__8030,G__8031,G__8032,G__8033,G__8034,G__8035,G__8036) : cljs.core.apply.call(null,G__8015,G__8016,G__8017,G__8018,G__8019,G__8020,G__8021,G__8022,G__8023,G__8024,G__8025,G__8026,G__8027,G__8028,G__8029,G__8030,G__8031,G__8032,G__8033,G__8034,G__8035,G__8036));
});
G__8059 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__8059__1.call(this,self__);
case 2:
return G__8059__2.call(this,self__,a);
case 3:
return G__8059__3.call(this,self__,a,b);
case 4:
return G__8059__4.call(this,self__,a,b,c);
case 5:
return G__8059__5.call(this,self__,a,b,c,d);
case 6:
return G__8059__6.call(this,self__,a,b,c,d,e);
case 7:
return G__8059__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__8059__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__8059__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__8059__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__8059__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__8059__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__8059__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__8059__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__8059__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__8059__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__8059__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__8059__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__8059__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__8059__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__8059__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__8059__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8059.cljs$core$IFn$_invoke$arity$1 = G__8059__1;
G__8059.cljs$core$IFn$_invoke$arity$2 = G__8059__2;
G__8059.cljs$core$IFn$_invoke$arity$3 = G__8059__3;
G__8059.cljs$core$IFn$_invoke$arity$4 = G__8059__4;
G__8059.cljs$core$IFn$_invoke$arity$5 = G__8059__5;
G__8059.cljs$core$IFn$_invoke$arity$6 = G__8059__6;
G__8059.cljs$core$IFn$_invoke$arity$7 = G__8059__7;
G__8059.cljs$core$IFn$_invoke$arity$8 = G__8059__8;
G__8059.cljs$core$IFn$_invoke$arity$9 = G__8059__9;
G__8059.cljs$core$IFn$_invoke$arity$10 = G__8059__10;
G__8059.cljs$core$IFn$_invoke$arity$11 = G__8059__11;
G__8059.cljs$core$IFn$_invoke$arity$12 = G__8059__12;
G__8059.cljs$core$IFn$_invoke$arity$13 = G__8059__13;
G__8059.cljs$core$IFn$_invoke$arity$14 = G__8059__14;
G__8059.cljs$core$IFn$_invoke$arity$15 = G__8059__15;
G__8059.cljs$core$IFn$_invoke$arity$16 = G__8059__16;
G__8059.cljs$core$IFn$_invoke$arity$17 = G__8059__17;
G__8059.cljs$core$IFn$_invoke$arity$18 = G__8059__18;
G__8059.cljs$core$IFn$_invoke$arity$19 = G__8059__19;
G__8059.cljs$core$IFn$_invoke$arity$20 = G__8059__20;
G__8059.cljs$core$IFn$_invoke$arity$21 = G__8059__21;
G__8059.cljs$core$IFn$_invoke$arity$22 = G__8059__22;
return G__8059;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args8014){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args8014)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__8037 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__8038 = a;
var G__8039 = b;
var G__8040 = c;
var G__8041 = d;
var G__8042 = e;
var G__8043 = f;
var G__8044 = g;
var G__8045 = h;
var G__8046 = i;
var G__8047 = j;
var G__8048 = k;
var G__8049 = l;
var G__8050 = m;
var G__8051 = n;
var G__8052 = o;
var G__8053 = p;
var G__8054 = q;
var G__8055 = r;
var G__8056 = s;
var G__8057 = t;
var G__8058 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8037,G__8038,G__8039,G__8040,G__8041,G__8042,G__8043,G__8044,G__8045,G__8046,G__8047,G__8048,G__8049,G__8050,G__8051,G__8052,G__8053,G__8054,G__8055,G__8056,G__8057,G__8058) : cljs.core.apply.call(null,G__8037,G__8038,G__8039,G__8040,G__8041,G__8042,G__8043,G__8044,G__8045,G__8046,G__8047,G__8048,G__8049,G__8050,G__8051,G__8052,G__8053,G__8054,G__8055,G__8056,G__8057,G__8058));
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function __GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



cljs.core.iterable_QMARK_ = (function iterable_QMARK_(x){
var G__8061 = x;
if(G__8061){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__8061.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__8061.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__8061);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__8061);
}
});
cljs.core.clone = (function clone(value){
return cljs.core._clone(value);
});
cljs.core.cloneable_QMARK_ = (function cloneable_QMARK_(value){
var G__8063 = value;
if(G__8063){
var bit__4439__auto__ = (G__8063.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4439__auto__) || (G__8063.cljs$core$ICloneable$)){
return true;
} else {
if((!G__8063.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__8063);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__8063);
}
});
/**
* Returns a seq on the collection. If the collection is
* empty, returns nil.  (seq nil) returns nil. seq also works on
* Strings.
*/
cljs.core.seq = (function seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__8065 = coll;
if(G__8065){
var bit__4432__auto__ = (G__8065.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4432__auto__) || (G__8065.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(coll instanceof Array){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
* Returns the first item in the collection. Calls seq on its
* argument. If coll is nil, returns nil.
*/
cljs.core.first = (function first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__8067 = coll;
if(G__8067){
var bit__4432__auto__ = (G__8067.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4432__auto__) || (G__8067.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
* Returns a possibly empty seq of the items after the first. Calls seq on its
* argument.
*/
cljs.core.rest = (function rest(coll){
if(!((coll == null))){
if((function (){var G__8069 = coll;
if(G__8069){
var bit__4432__auto__ = (G__8069.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4432__auto__) || (G__8069.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
* Returns a seq of the items after the first. Calls seq on its
* argument.  If there are no more items, returns nil
*/
cljs.core.next = (function next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__8071 = coll;
if(G__8071){
var bit__4432__auto__ = (G__8071.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4432__auto__) || (G__8071.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
* Equality. Returns true if x equals y, false if not. Compares
* numbers and collections in a type-independent manner.  Clojure's immutable data
* structures define -equiv (and thus =) as a value, not an identity,
* comparison.
* @param {...*} var_args
*/
cljs.core._EQ_ = (function() {
var _EQ_ = null;
var _EQ___1 = (function (x){
return true;
});
var _EQ___2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});
var _EQ___3 = (function() { 
var G__8076__delegate = function (x,y,more){
while(true){
if(_EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__8077 = y;
var G__8078 = cljs.core.first(more);
var G__8079 = cljs.core.next(more);
x = G__8077;
y = G__8078;
more = G__8079;
continue;
} else {
return _EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8076 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8080__i = 0, G__8080__a = new Array(arguments.length -  2);
while (G__8080__i < G__8080__a.length) {G__8080__a[G__8080__i] = arguments[G__8080__i + 2]; ++G__8080__i;}
  more = new cljs.core.IndexedSeq(G__8080__a,0);
} 
return G__8076__delegate.call(this,x,y,more);};
G__8076.cljs$lang$maxFixedArity = 2;
G__8076.cljs$lang$applyTo = (function (arglist__8081){
var x = cljs.core.first(arglist__8081);
arglist__8081 = cljs.core.next(arglist__8081);
var y = cljs.core.first(arglist__8081);
var more = cljs.core.rest(arglist__8081);
return G__8076__delegate(x,y,more);
});
G__8076.cljs$core$IFn$_invoke$arity$variadic = G__8076__delegate;
return G__8076;
})()
;
_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ___1.call(this,x);
case 2:
return _EQ___2.call(this,x,y);
default:
var G__8082 = null;
if (arguments.length > 2) {
var G__8083__i = 0, G__8083__a = new Array(arguments.length -  2);
while (G__8083__i < G__8083__a.length) {G__8083__a[G__8083__i] = arguments[G__8083__i + 2]; ++G__8083__i;}
G__8082 = new cljs.core.IndexedSeq(G__8083__a,0);
}
return _EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_EQ_.cljs$lang$maxFixedArity = 2;
_EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
_EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ___1;
_EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ___2;
_EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _EQ_;
})()
;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": x};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function __GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

cljs.core.es6_iterator = (function es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__8084 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__8084) : cljs.core.es6_iterator_seq.call(null,G__8084));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function __GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

cljs.core.es6_iterator_seq = (function es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
* Mix final collection hash for ordered or unordered collections.
* hash-basis is the combined collection hash, count is the number
* of elements included in the basis. Note this is the hash code
* consistent with =, different from .hashCode.
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.mix_collection_hash = (function mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
* Returns the hash code, consistent with =, for an external ordered
* collection implementing Iterable.
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.hash_ordered_coll = (function hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__8085 = (n + (1));
var G__8086 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__8087 = cljs.core.next(coll__$1);
n = G__8085;
hash_code = G__8086;
coll__$1 = G__8087;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
* Returns the hash code, consistent with =, for an external unordered
* collection implementing Iterable. For maps, the iterator should
* return map entries whose hash is computed as
* (hash-ordered-coll [k v]).
* See http://clojure.org/data_structures#hash for full algorithms.
*/
cljs.core.hash_unordered_coll = (function hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__8088 = (n + (1));
var G__8089 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__8090 = cljs.core.next(coll__$1);
n = G__8088;
hash_code = G__8089;
coll__$1 = G__8090;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.toString() === other.toString()));
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));

(cljs.core.Fn["function"] = true);
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__8091 = o;
return goog.getUid(G__8091);
}));
/**
* Returns a number one greater than num.
*/
cljs.core.inc = (function inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function __GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
* Wraps x in a way such that a reduce will terminate with the value x
*/
cljs.core.reduced = (function reduced(x){
return (new cljs.core.Reduced(x));
});
/**
* Returns true if x is the result of a call to reduced
*/
cljs.core.reduced_QMARK_ = (function reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
* If x is already reduced?, returns it, else returns (reduced x)
*/
cljs.core.ensure_reduced = (function ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
* If x is reduced?, returns (deref x), else returns x
*/
cljs.core.unreduced = (function unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__8093 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__8093) : cljs.core.deref.call(null,G__8093));
} else {
return x;
}
});
cljs.core.deref = (function deref(o){
return cljs.core._deref(o);
});
/**
* Accepts any collection which satisfies the ICount and IIndexed protocols and
* reduces them without incurring seq initialization
*/
cljs.core.ci_reduce = (function() {
var ci_reduce = null;
var ci_reduce__2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__8100 = val;
var G__8101 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8100,G__8101) : f.call(null,G__8100,G__8101));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8106 = nval;
var G__8107 = (n + (1));
val = G__8106;
n = G__8107;
continue;
}
} else {
return val;
}
break;
}
}
});
var ci_reduce__3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__8102 = val__$1;
var G__8103 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8102,G__8103) : f.call(null,G__8102,G__8103));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8108 = nval;
var G__8109 = (n + (1));
val__$1 = G__8108;
n = G__8109;
continue;
}
} else {
return val__$1;
}
break;
}
});
var ci_reduce__4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__8104 = val__$1;
var G__8105 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8104,G__8105) : f.call(null,G__8104,G__8105));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8110 = nval;
var G__8111 = (n + (1));
val__$1 = G__8110;
n = G__8111;
continue;
}
} else {
return val__$1;
}
break;
}
});
ci_reduce = function(cicoll,f,val,idx){
switch(arguments.length){
case 2:
return ci_reduce__2.call(this,cicoll,f);
case 3:
return ci_reduce__3.call(this,cicoll,f,val);
case 4:
return ci_reduce__4.call(this,cicoll,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ci_reduce.cljs$core$IFn$_invoke$arity$2 = ci_reduce__2;
ci_reduce.cljs$core$IFn$_invoke$arity$3 = ci_reduce__3;
ci_reduce.cljs$core$IFn$_invoke$arity$4 = ci_reduce__4;
return ci_reduce;
})()
;
cljs.core.array_reduce = (function() {
var array_reduce = null;
var array_reduce__2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__8118 = val;
var G__8119 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8118,G__8119) : f.call(null,G__8118,G__8119));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8124 = nval;
var G__8125 = (n + (1));
val = G__8124;
n = G__8125;
continue;
}
} else {
return val;
}
break;
}
}
});
var array_reduce__3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__8120 = val__$1;
var G__8121 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8120,G__8121) : f.call(null,G__8120,G__8121));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8126 = nval;
var G__8127 = (n + (1));
val__$1 = G__8126;
n = G__8127;
continue;
}
} else {
return val__$1;
}
break;
}
});
var array_reduce__4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__8122 = val__$1;
var G__8123 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8122,G__8123) : f.call(null,G__8122,G__8123));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8128 = nval;
var G__8129 = (n + (1));
val__$1 = G__8128;
n = G__8129;
continue;
}
} else {
return val__$1;
}
break;
}
});
array_reduce = function(arr,f,val,idx){
switch(arguments.length){
case 2:
return array_reduce__2.call(this,arr,f);
case 3:
return array_reduce__3.call(this,arr,f,val);
case 4:
return array_reduce__4.call(this,arr,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_reduce.cljs$core$IFn$_invoke$arity$2 = array_reduce__2;
array_reduce.cljs$core$IFn$_invoke$arity$3 = array_reduce__3;
array_reduce.cljs$core$IFn$_invoke$arity$4 = array_reduce__4;
return array_reduce;
})()
;



/**
* Returns true if coll implements count in constant time
*/
cljs.core.counted_QMARK_ = (function counted_QMARK_(x){
var G__8131 = x;
if(G__8131){
var bit__4439__auto__ = (G__8131.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4439__auto__) || (G__8131.cljs$core$ICounted$)){
return true;
} else {
if((!G__8131.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__8131);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__8131);
}
});
/**
* Returns true if coll implements nth in constant time
*/
cljs.core.indexed_QMARK_ = (function indexed_QMARK_(x){
var G__8133 = x;
if(G__8133){
var bit__4439__auto__ = (G__8133.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4439__auto__) || (G__8133.cljs$core$IIndexed$)){
return true;
} else {
if((!G__8133.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__8133);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__8133);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function __GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__8134 = coll__$1;
var G__8135 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__8134,G__8135) : cljs.core.equiv_sequential.call(null,G__8134,G__8135));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__8136 = o;
var G__8137 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__8136,G__8137) : cljs.core.cons.call(null,G__8136,G__8137));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function __GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.prim_seq = (function() {
var prim_seq = null;
var prim_seq__1 = (function (prim){
return prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});
var prim_seq__2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});
prim_seq = function(prim,i){
switch(arguments.length){
case 1:
return prim_seq__1.call(this,prim);
case 2:
return prim_seq__2.call(this,prim,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
prim_seq.cljs$core$IFn$_invoke$arity$1 = prim_seq__1;
prim_seq.cljs$core$IFn$_invoke$arity$2 = prim_seq__2;
return prim_seq;
})()
;
cljs.core.array_seq = (function() {
var array_seq = null;
var array_seq__1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});
var array_seq__2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});
array_seq = function(array,i){
switch(arguments.length){
case 1:
return array_seq__1.call(this,array);
case 2:
return array_seq__2.call(this,array,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_seq.cljs$core$IFn$_invoke$arity$1 = array_seq__1;
array_seq.cljs$core$IFn$_invoke$arity$2 = array_seq__2;
return array_seq;
})()
;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__8140 = coll__$1;
var G__8141 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__8140,G__8141) : cljs.core.equiv_sequential.call(null,G__8140,G__8141));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__8142 = cljs.core.List.EMPTY;
var G__8143 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__8142,G__8143) : cljs.core.with_meta.call(null,G__8142,G__8143));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__8144 = f;
var G__8145 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__8144,G__8145) : cljs.core.seq_reduce.call(null,G__8144,G__8145));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__8146 = f;
var G__8147 = start;
var G__8148 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__8146,G__8147,G__8148) : cljs.core.seq_reduce.call(null,G__8146,G__8147,G__8148));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__8149 = o;
var G__8150 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__8149,G__8150) : cljs.core.cons.call(null,G__8149,G__8150));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function __GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Same as (first (next x))
*/
cljs.core.second = (function second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
* Same as (first (first x))
*/
cljs.core.ffirst = (function ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
* Same as (next (first x))
*/
cljs.core.nfirst = (function nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
* Same as (first (next x))
*/
cljs.core.fnext = (function fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
* Same as (next (next x))
*/
cljs.core.nnext = (function nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
* Return the last item in coll, in linear time
*/
cljs.core.last = (function last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__8151 = sn;
s = G__8151;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
* conj[oin]. Returns a new collection with the xs
* 'added'. (conj nil item) returns (item).  The 'addition' may
* happen at different 'places' depending on the concrete type.
* @param {...*} var_args
*/
cljs.core.conj = (function() {
var conj = null;
var conj__0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});
var conj__1 = (function (coll){
return coll;
});
var conj__2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});
var conj__3 = (function() { 
var G__8156__delegate = function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__8157 = conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__8158 = cljs.core.first(xs);
var G__8159 = cljs.core.next(xs);
coll = G__8157;
x = G__8158;
xs = G__8159;
continue;
} else {
return conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
};
var G__8156 = function (coll,x,var_args){
var xs = null;
if (arguments.length > 2) {
var G__8160__i = 0, G__8160__a = new Array(arguments.length -  2);
while (G__8160__i < G__8160__a.length) {G__8160__a[G__8160__i] = arguments[G__8160__i + 2]; ++G__8160__i;}
  xs = new cljs.core.IndexedSeq(G__8160__a,0);
} 
return G__8156__delegate.call(this,coll,x,xs);};
G__8156.cljs$lang$maxFixedArity = 2;
G__8156.cljs$lang$applyTo = (function (arglist__8161){
var coll = cljs.core.first(arglist__8161);
arglist__8161 = cljs.core.next(arglist__8161);
var x = cljs.core.first(arglist__8161);
var xs = cljs.core.rest(arglist__8161);
return G__8156__delegate(coll,x,xs);
});
G__8156.cljs$core$IFn$_invoke$arity$variadic = G__8156__delegate;
return G__8156;
})()
;
conj = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 0:
return conj__0.call(this);
case 1:
return conj__1.call(this,coll);
case 2:
return conj__2.call(this,coll,x);
default:
var G__8162 = null;
if (arguments.length > 2) {
var G__8163__i = 0, G__8163__a = new Array(arguments.length -  2);
while (G__8163__i < G__8163__a.length) {G__8163__a[G__8163__i] = arguments[G__8163__i + 2]; ++G__8163__i;}
G__8162 = new cljs.core.IndexedSeq(G__8163__a,0);
}
return conj__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, G__8162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj.cljs$lang$maxFixedArity = 2;
conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
conj.cljs$core$IFn$_invoke$arity$0 = conj__0;
conj.cljs$core$IFn$_invoke$arity$1 = conj__1;
conj.cljs$core$IFn$_invoke$arity$2 = conj__2;
conj.cljs$core$IFn$_invoke$arity$variadic = conj__3.cljs$core$IFn$_invoke$arity$variadic;
return conj;
})()
;
/**
* Returns an empty collection of the same category as coll, or nil
*/
cljs.core.empty = (function empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__8164 = cljs.core.next(s);
var G__8165 = (acc + (1));
s = G__8164;
acc = G__8165;
continue;
}
break;
}
});
/**
* Returns the number of items in the collection. (count nil) returns
* 0.  Also works on strings, arrays, and Maps
*/
cljs.core.count = (function count(coll){
if(!((coll == null))){
if((function (){var G__8167 = coll;
if(G__8167){
var bit__4432__auto__ = (G__8167.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4432__auto__) || (G__8167.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(coll instanceof Array){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function() {
var linear_traversal_nth = null;
var linear_traversal_nth__2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__8168 = cljs.core.next(coll);
var G__8169 = (n - (1));
coll = G__8168;
n = G__8169;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});
var linear_traversal_nth__3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__8170 = cljs.core.next(coll);
var G__8171 = (n - (1));
var G__8172 = not_found;
coll = G__8170;
n = G__8171;
not_found = G__8172;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});
linear_traversal_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return linear_traversal_nth__2.call(this,coll,n);
case 3:
return linear_traversal_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = linear_traversal_nth__2;
linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = linear_traversal_nth__3;
return linear_traversal_nth;
})()
;
/**
* Returns the value at the index. get returns nil if index out of
* bounds, nth throws an exception unless not-found is supplied.  nth
* also works for strings, arrays, regex Matchers and Lists, and,
* in O(n) time, for sequences.
*/
cljs.core.nth = (function() {
var nth = null;
var nth__2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__8177 = coll;
if(G__8177){
var bit__4432__auto__ = (G__8177.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4432__auto__) || (G__8177.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(coll instanceof Array){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__8178 = coll;
if(G__8178){
var bit__4439__auto__ = (G__8178.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4439__auto__) || (G__8178.cljs$core$ISeq$)){
return true;
} else {
if((!G__8178.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8178);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8178);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
var nth__3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__8179 = coll;
if(G__8179){
var bit__4432__auto__ = (G__8179.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4432__auto__) || (G__8179.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(coll instanceof Array){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__8180 = coll;
if(G__8180){
var bit__4439__auto__ = (G__8180.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4439__auto__) || (G__8180.cljs$core$ISeq$)){
return true;
} else {
if((!G__8180.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8180);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8180);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return nth__2.call(this,coll,n);
case 3:
return nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
nth.cljs$core$IFn$_invoke$arity$2 = nth__2;
nth.cljs$core$IFn$_invoke$arity$3 = nth__3;
return nth;
})()
;
/**
* Returns the nth rest of coll, coll when n is 0.
*/
cljs.core.nthrest = (function nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__8181 = (n__$1 - (1));
var G__8182 = cljs.core.rest(xs);
n__$1 = G__8181;
xs = G__8182;
continue;
} else {
return xs;
}
break;
}
});
/**
* Returns the value mapped to key, not-found or nil if key not present.
*/
cljs.core.get = (function() {
var get = null;
var get__2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__8185 = o;
if(G__8185){
var bit__4432__auto__ = (G__8185.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4432__auto__) || (G__8185.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(o instanceof Array){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});
var get__3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__8186 = o;
if(G__8186){
var bit__4432__auto__ = (G__8186.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4432__auto__) || (G__8186.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(o instanceof Array){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});
get = function(o,k,not_found){
switch(arguments.length){
case 2:
return get__2.call(this,o,k);
case 3:
return get__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
get.cljs$core$IFn$_invoke$arity$2 = get__2;
get.cljs$core$IFn$_invoke$arity$3 = get__3;
return get;
})()
;
/**
* assoc[iate]. When applied to a map, returns a new map of the
* same (hashed/sorted) type, that contains the mapping of key(s) to
* val(s). When applied to a vector, returns a new vector that
* contains val at index.
* @param {...*} var_args
*/
cljs.core.assoc = (function() {
var assoc = null;
var assoc__3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});
var assoc__4 = (function() { 
var G__8190__delegate = function (coll,k,v,kvs){
while(true){
var ret = assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__8191 = ret;
var G__8192 = cljs.core.first(kvs);
var G__8193 = cljs.core.second(kvs);
var G__8194 = cljs.core.nnext(kvs);
coll = G__8191;
k = G__8192;
v = G__8193;
kvs = G__8194;
continue;
} else {
return ret;
}
break;
}
};
var G__8190 = function (coll,k,v,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__8195__i = 0, G__8195__a = new Array(arguments.length -  3);
while (G__8195__i < G__8195__a.length) {G__8195__a[G__8195__i] = arguments[G__8195__i + 3]; ++G__8195__i;}
  kvs = new cljs.core.IndexedSeq(G__8195__a,0);
} 
return G__8190__delegate.call(this,coll,k,v,kvs);};
G__8190.cljs$lang$maxFixedArity = 3;
G__8190.cljs$lang$applyTo = (function (arglist__8196){
var coll = cljs.core.first(arglist__8196);
arglist__8196 = cljs.core.next(arglist__8196);
var k = cljs.core.first(arglist__8196);
arglist__8196 = cljs.core.next(arglist__8196);
var v = cljs.core.first(arglist__8196);
var kvs = cljs.core.rest(arglist__8196);
return G__8190__delegate(coll,k,v,kvs);
});
G__8190.cljs$core$IFn$_invoke$arity$variadic = G__8190__delegate;
return G__8190;
})()
;
assoc = function(coll,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return assoc__3.call(this,coll,k,v);
default:
var G__8197 = null;
if (arguments.length > 3) {
var G__8198__i = 0, G__8198__a = new Array(arguments.length -  3);
while (G__8198__i < G__8198__a.length) {G__8198__a[G__8198__i] = arguments[G__8198__i + 3]; ++G__8198__i;}
G__8197 = new cljs.core.IndexedSeq(G__8198__a,0);
}
return assoc__4.cljs$core$IFn$_invoke$arity$variadic(coll,k,v, G__8197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
assoc.cljs$lang$maxFixedArity = 3;
assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
assoc.cljs$core$IFn$_invoke$arity$3 = assoc__3;
assoc.cljs$core$IFn$_invoke$arity$variadic = assoc__4.cljs$core$IFn$_invoke$arity$variadic;
return assoc;
})()
;
/**
* dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
* that does not contain a mapping for key(s).
* @param {...*} var_args
*/
cljs.core.dissoc = (function() {
var dissoc = null;
var dissoc__1 = (function (coll){
return coll;
});
var dissoc__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});
var dissoc__3 = (function() { 
var G__8201__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__8202 = ret;
var G__8203 = cljs.core.first(ks);
var G__8204 = cljs.core.next(ks);
coll = G__8202;
k = G__8203;
ks = G__8204;
continue;
} else {
return ret;
}
}
break;
}
};
var G__8201 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__8205__i = 0, G__8205__a = new Array(arguments.length -  2);
while (G__8205__i < G__8205__a.length) {G__8205__a[G__8205__i] = arguments[G__8205__i + 2]; ++G__8205__i;}
  ks = new cljs.core.IndexedSeq(G__8205__a,0);
} 
return G__8201__delegate.call(this,coll,k,ks);};
G__8201.cljs$lang$maxFixedArity = 2;
G__8201.cljs$lang$applyTo = (function (arglist__8206){
var coll = cljs.core.first(arglist__8206);
arglist__8206 = cljs.core.next(arglist__8206);
var k = cljs.core.first(arglist__8206);
var ks = cljs.core.rest(arglist__8206);
return G__8201__delegate(coll,k,ks);
});
G__8201.cljs$core$IFn$_invoke$arity$variadic = G__8201__delegate;
return G__8201;
})()
;
dissoc = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return dissoc__1.call(this,coll);
case 2:
return dissoc__2.call(this,coll,k);
default:
var G__8207 = null;
if (arguments.length > 2) {
var G__8208__i = 0, G__8208__a = new Array(arguments.length -  2);
while (G__8208__i < G__8208__a.length) {G__8208__a[G__8208__i] = arguments[G__8208__i + 2]; ++G__8208__i;}
G__8207 = new cljs.core.IndexedSeq(G__8208__a,0);
}
return dissoc__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__8207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dissoc.cljs$lang$maxFixedArity = 2;
dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
dissoc.cljs$core$IFn$_invoke$arity$1 = dissoc__1;
dissoc.cljs$core$IFn$_invoke$arity$2 = dissoc__2;
dissoc.cljs$core$IFn$_invoke$arity$variadic = dissoc__3.cljs$core$IFn$_invoke$arity$variadic;
return dissoc;
})()
;
cljs.core.fn_QMARK_ = (function fn_QMARK_(f){
var or__3758__auto__ = (function (){var G__8213 = f;
return goog.isFunction(G__8213);
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__8214 = f;
if(G__8214){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto____$1 = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
return G__8214.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__8214.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__8214);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__8214);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393217;
})
cljs.core.MetaFn.prototype.call = (function() {
var G__8680 = null;
var G__8680__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__8680__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8216 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__8216) : self__.afn.call(null,G__8216));
});
var G__8680__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8217 = a;
var G__8218 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__8217,G__8218) : self__.afn.call(null,G__8217,G__8218));
});
var G__8680__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8219 = a;
var G__8220 = b;
var G__8221 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__8219,G__8220,G__8221) : self__.afn.call(null,G__8219,G__8220,G__8221));
});
var G__8680__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8222 = a;
var G__8223 = b;
var G__8224 = c;
var G__8225 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__8222,G__8223,G__8224,G__8225) : self__.afn.call(null,G__8222,G__8223,G__8224,G__8225));
});
var G__8680__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8226 = a;
var G__8227 = b;
var G__8228 = c;
var G__8229 = d;
var G__8230 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__8226,G__8227,G__8228,G__8229,G__8230) : self__.afn.call(null,G__8226,G__8227,G__8228,G__8229,G__8230));
});
var G__8680__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8231 = a;
var G__8232 = b;
var G__8233 = c;
var G__8234 = d;
var G__8235 = e;
var G__8236 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__8231,G__8232,G__8233,G__8234,G__8235,G__8236) : self__.afn.call(null,G__8231,G__8232,G__8233,G__8234,G__8235,G__8236));
});
var G__8680__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8237 = a;
var G__8238 = b;
var G__8239 = c;
var G__8240 = d;
var G__8241 = e;
var G__8242 = f;
var G__8243 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__8237,G__8238,G__8239,G__8240,G__8241,G__8242,G__8243) : self__.afn.call(null,G__8237,G__8238,G__8239,G__8240,G__8241,G__8242,G__8243));
});
var G__8680__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8244 = a;
var G__8245 = b;
var G__8246 = c;
var G__8247 = d;
var G__8248 = e;
var G__8249 = f;
var G__8250 = g;
var G__8251 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__8244,G__8245,G__8246,G__8247,G__8248,G__8249,G__8250,G__8251) : self__.afn.call(null,G__8244,G__8245,G__8246,G__8247,G__8248,G__8249,G__8250,G__8251));
});
var G__8680__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8252 = a;
var G__8253 = b;
var G__8254 = c;
var G__8255 = d;
var G__8256 = e;
var G__8257 = f;
var G__8258 = g;
var G__8259 = h;
var G__8260 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__8252,G__8253,G__8254,G__8255,G__8256,G__8257,G__8258,G__8259,G__8260) : self__.afn.call(null,G__8252,G__8253,G__8254,G__8255,G__8256,G__8257,G__8258,G__8259,G__8260));
});
var G__8680__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8261 = a;
var G__8262 = b;
var G__8263 = c;
var G__8264 = d;
var G__8265 = e;
var G__8266 = f;
var G__8267 = g;
var G__8268 = h;
var G__8269 = i;
var G__8270 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__8261,G__8262,G__8263,G__8264,G__8265,G__8266,G__8267,G__8268,G__8269,G__8270) : self__.afn.call(null,G__8261,G__8262,G__8263,G__8264,G__8265,G__8266,G__8267,G__8268,G__8269,G__8270));
});
var G__8680__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8271 = a;
var G__8272 = b;
var G__8273 = c;
var G__8274 = d;
var G__8275 = e;
var G__8276 = f;
var G__8277 = g;
var G__8278 = h;
var G__8279 = i;
var G__8280 = j;
var G__8281 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__8271,G__8272,G__8273,G__8274,G__8275,G__8276,G__8277,G__8278,G__8279,G__8280,G__8281) : self__.afn.call(null,G__8271,G__8272,G__8273,G__8274,G__8275,G__8276,G__8277,G__8278,G__8279,G__8280,G__8281));
});
var G__8680__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8282 = a;
var G__8283 = b;
var G__8284 = c;
var G__8285 = d;
var G__8286 = e;
var G__8287 = f;
var G__8288 = g;
var G__8289 = h;
var G__8290 = i;
var G__8291 = j;
var G__8292 = k;
var G__8293 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__8282,G__8283,G__8284,G__8285,G__8286,G__8287,G__8288,G__8289,G__8290,G__8291,G__8292,G__8293) : self__.afn.call(null,G__8282,G__8283,G__8284,G__8285,G__8286,G__8287,G__8288,G__8289,G__8290,G__8291,G__8292,G__8293));
});
var G__8680__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8294 = a;
var G__8295 = b;
var G__8296 = c;
var G__8297 = d;
var G__8298 = e;
var G__8299 = f;
var G__8300 = g;
var G__8301 = h;
var G__8302 = i;
var G__8303 = j;
var G__8304 = k;
var G__8305 = l;
var G__8306 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__8294,G__8295,G__8296,G__8297,G__8298,G__8299,G__8300,G__8301,G__8302,G__8303,G__8304,G__8305,G__8306) : self__.afn.call(null,G__8294,G__8295,G__8296,G__8297,G__8298,G__8299,G__8300,G__8301,G__8302,G__8303,G__8304,G__8305,G__8306));
});
var G__8680__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8307 = a;
var G__8308 = b;
var G__8309 = c;
var G__8310 = d;
var G__8311 = e;
var G__8312 = f;
var G__8313 = g;
var G__8314 = h;
var G__8315 = i;
var G__8316 = j;
var G__8317 = k;
var G__8318 = l;
var G__8319 = m;
var G__8320 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__8307,G__8308,G__8309,G__8310,G__8311,G__8312,G__8313,G__8314,G__8315,G__8316,G__8317,G__8318,G__8319,G__8320) : self__.afn.call(null,G__8307,G__8308,G__8309,G__8310,G__8311,G__8312,G__8313,G__8314,G__8315,G__8316,G__8317,G__8318,G__8319,G__8320));
});
var G__8680__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8321 = a;
var G__8322 = b;
var G__8323 = c;
var G__8324 = d;
var G__8325 = e;
var G__8326 = f;
var G__8327 = g;
var G__8328 = h;
var G__8329 = i;
var G__8330 = j;
var G__8331 = k;
var G__8332 = l;
var G__8333 = m;
var G__8334 = n;
var G__8335 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__8321,G__8322,G__8323,G__8324,G__8325,G__8326,G__8327,G__8328,G__8329,G__8330,G__8331,G__8332,G__8333,G__8334,G__8335) : self__.afn.call(null,G__8321,G__8322,G__8323,G__8324,G__8325,G__8326,G__8327,G__8328,G__8329,G__8330,G__8331,G__8332,G__8333,G__8334,G__8335));
});
var G__8680__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8336 = a;
var G__8337 = b;
var G__8338 = c;
var G__8339 = d;
var G__8340 = e;
var G__8341 = f;
var G__8342 = g;
var G__8343 = h;
var G__8344 = i;
var G__8345 = j;
var G__8346 = k;
var G__8347 = l;
var G__8348 = m;
var G__8349 = n;
var G__8350 = o;
var G__8351 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__8336,G__8337,G__8338,G__8339,G__8340,G__8341,G__8342,G__8343,G__8344,G__8345,G__8346,G__8347,G__8348,G__8349,G__8350,G__8351) : self__.afn.call(null,G__8336,G__8337,G__8338,G__8339,G__8340,G__8341,G__8342,G__8343,G__8344,G__8345,G__8346,G__8347,G__8348,G__8349,G__8350,G__8351));
});
var G__8680__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8352 = a;
var G__8353 = b;
var G__8354 = c;
var G__8355 = d;
var G__8356 = e;
var G__8357 = f;
var G__8358 = g;
var G__8359 = h;
var G__8360 = i;
var G__8361 = j;
var G__8362 = k;
var G__8363 = l;
var G__8364 = m;
var G__8365 = n;
var G__8366 = o;
var G__8367 = p;
var G__8368 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__8352,G__8353,G__8354,G__8355,G__8356,G__8357,G__8358,G__8359,G__8360,G__8361,G__8362,G__8363,G__8364,G__8365,G__8366,G__8367,G__8368) : self__.afn.call(null,G__8352,G__8353,G__8354,G__8355,G__8356,G__8357,G__8358,G__8359,G__8360,G__8361,G__8362,G__8363,G__8364,G__8365,G__8366,G__8367,G__8368));
});
var G__8680__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8369 = a;
var G__8370 = b;
var G__8371 = c;
var G__8372 = d;
var G__8373 = e;
var G__8374 = f;
var G__8375 = g;
var G__8376 = h;
var G__8377 = i;
var G__8378 = j;
var G__8379 = k;
var G__8380 = l;
var G__8381 = m;
var G__8382 = n;
var G__8383 = o;
var G__8384 = p;
var G__8385 = q;
var G__8386 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__8369,G__8370,G__8371,G__8372,G__8373,G__8374,G__8375,G__8376,G__8377,G__8378,G__8379,G__8380,G__8381,G__8382,G__8383,G__8384,G__8385,G__8386) : self__.afn.call(null,G__8369,G__8370,G__8371,G__8372,G__8373,G__8374,G__8375,G__8376,G__8377,G__8378,G__8379,G__8380,G__8381,G__8382,G__8383,G__8384,G__8385,G__8386));
});
var G__8680__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8387 = a;
var G__8388 = b;
var G__8389 = c;
var G__8390 = d;
var G__8391 = e;
var G__8392 = f;
var G__8393 = g;
var G__8394 = h;
var G__8395 = i;
var G__8396 = j;
var G__8397 = k;
var G__8398 = l;
var G__8399 = m;
var G__8400 = n;
var G__8401 = o;
var G__8402 = p;
var G__8403 = q;
var G__8404 = r;
var G__8405 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__8387,G__8388,G__8389,G__8390,G__8391,G__8392,G__8393,G__8394,G__8395,G__8396,G__8397,G__8398,G__8399,G__8400,G__8401,G__8402,G__8403,G__8404,G__8405) : self__.afn.call(null,G__8387,G__8388,G__8389,G__8390,G__8391,G__8392,G__8393,G__8394,G__8395,G__8396,G__8397,G__8398,G__8399,G__8400,G__8401,G__8402,G__8403,G__8404,G__8405));
});
var G__8680__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8406 = a;
var G__8407 = b;
var G__8408 = c;
var G__8409 = d;
var G__8410 = e;
var G__8411 = f;
var G__8412 = g;
var G__8413 = h;
var G__8414 = i;
var G__8415 = j;
var G__8416 = k;
var G__8417 = l;
var G__8418 = m;
var G__8419 = n;
var G__8420 = o;
var G__8421 = p;
var G__8422 = q;
var G__8423 = r;
var G__8424 = s;
var G__8425 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__8406,G__8407,G__8408,G__8409,G__8410,G__8411,G__8412,G__8413,G__8414,G__8415,G__8416,G__8417,G__8418,G__8419,G__8420,G__8421,G__8422,G__8423,G__8424,G__8425) : self__.afn.call(null,G__8406,G__8407,G__8408,G__8409,G__8410,G__8411,G__8412,G__8413,G__8414,G__8415,G__8416,G__8417,G__8418,G__8419,G__8420,G__8421,G__8422,G__8423,G__8424,G__8425));
});
var G__8680__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__8426 = self__.afn;
var G__8427 = a;
var G__8428 = b;
var G__8429 = c;
var G__8430 = d;
var G__8431 = e;
var G__8432 = f;
var G__8433 = g;
var G__8434 = h;
var G__8435 = i;
var G__8436 = j;
var G__8437 = k;
var G__8438 = l;
var G__8439 = m;
var G__8440 = n;
var G__8441 = o;
var G__8442 = p;
var G__8443 = q;
var G__8444 = r;
var G__8445 = s;
var G__8446 = t;
var G__8447 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8426,G__8427,G__8428,G__8429,G__8430,G__8431,G__8432,G__8433,G__8434,G__8435,G__8436,G__8437,G__8438,G__8439,G__8440,G__8441,G__8442,G__8443,G__8444,G__8445,G__8446,G__8447) : cljs.core.apply.call(null,G__8426,G__8427,G__8428,G__8429,G__8430,G__8431,G__8432,G__8433,G__8434,G__8435,G__8436,G__8437,G__8438,G__8439,G__8440,G__8441,G__8442,G__8443,G__8444,G__8445,G__8446,G__8447));
});
G__8680 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__8680__1.call(this,self__);
case 2:
return G__8680__2.call(this,self__,a);
case 3:
return G__8680__3.call(this,self__,a,b);
case 4:
return G__8680__4.call(this,self__,a,b,c);
case 5:
return G__8680__5.call(this,self__,a,b,c,d);
case 6:
return G__8680__6.call(this,self__,a,b,c,d,e);
case 7:
return G__8680__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__8680__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__8680__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__8680__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__8680__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__8680__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__8680__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__8680__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__8680__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__8680__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__8680__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__8680__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__8680__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__8680__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__8680__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__8680__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8680.cljs$core$IFn$_invoke$arity$1 = G__8680__1;
G__8680.cljs$core$IFn$_invoke$arity$2 = G__8680__2;
G__8680.cljs$core$IFn$_invoke$arity$3 = G__8680__3;
G__8680.cljs$core$IFn$_invoke$arity$4 = G__8680__4;
G__8680.cljs$core$IFn$_invoke$arity$5 = G__8680__5;
G__8680.cljs$core$IFn$_invoke$arity$6 = G__8680__6;
G__8680.cljs$core$IFn$_invoke$arity$7 = G__8680__7;
G__8680.cljs$core$IFn$_invoke$arity$8 = G__8680__8;
G__8680.cljs$core$IFn$_invoke$arity$9 = G__8680__9;
G__8680.cljs$core$IFn$_invoke$arity$10 = G__8680__10;
G__8680.cljs$core$IFn$_invoke$arity$11 = G__8680__11;
G__8680.cljs$core$IFn$_invoke$arity$12 = G__8680__12;
G__8680.cljs$core$IFn$_invoke$arity$13 = G__8680__13;
G__8680.cljs$core$IFn$_invoke$arity$14 = G__8680__14;
G__8680.cljs$core$IFn$_invoke$arity$15 = G__8680__15;
G__8680.cljs$core$IFn$_invoke$arity$16 = G__8680__16;
G__8680.cljs$core$IFn$_invoke$arity$17 = G__8680__17;
G__8680.cljs$core$IFn$_invoke$arity$18 = G__8680__18;
G__8680.cljs$core$IFn$_invoke$arity$19 = G__8680__19;
G__8680.cljs$core$IFn$_invoke$arity$20 = G__8680__20;
G__8680.cljs$core$IFn$_invoke$arity$21 = G__8680__21;
G__8680.cljs$core$IFn$_invoke$arity$22 = G__8680__22;
return G__8680;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args8215){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args8215)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__8448 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__8448) : self__.afn.call(null,G__8448));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__8449 = a;
var G__8450 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__8449,G__8450) : self__.afn.call(null,G__8449,G__8450));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__8451 = a;
var G__8452 = b;
var G__8453 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__8451,G__8452,G__8453) : self__.afn.call(null,G__8451,G__8452,G__8453));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__8454 = a;
var G__8455 = b;
var G__8456 = c;
var G__8457 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__8454,G__8455,G__8456,G__8457) : self__.afn.call(null,G__8454,G__8455,G__8456,G__8457));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__8458 = a;
var G__8459 = b;
var G__8460 = c;
var G__8461 = d;
var G__8462 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__8458,G__8459,G__8460,G__8461,G__8462) : self__.afn.call(null,G__8458,G__8459,G__8460,G__8461,G__8462));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__8463 = a;
var G__8464 = b;
var G__8465 = c;
var G__8466 = d;
var G__8467 = e;
var G__8468 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__8463,G__8464,G__8465,G__8466,G__8467,G__8468) : self__.afn.call(null,G__8463,G__8464,G__8465,G__8466,G__8467,G__8468));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__8469 = a;
var G__8470 = b;
var G__8471 = c;
var G__8472 = d;
var G__8473 = e;
var G__8474 = f;
var G__8475 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__8469,G__8470,G__8471,G__8472,G__8473,G__8474,G__8475) : self__.afn.call(null,G__8469,G__8470,G__8471,G__8472,G__8473,G__8474,G__8475));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__8476 = a;
var G__8477 = b;
var G__8478 = c;
var G__8479 = d;
var G__8480 = e;
var G__8481 = f;
var G__8482 = g;
var G__8483 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__8476,G__8477,G__8478,G__8479,G__8480,G__8481,G__8482,G__8483) : self__.afn.call(null,G__8476,G__8477,G__8478,G__8479,G__8480,G__8481,G__8482,G__8483));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__8484 = a;
var G__8485 = b;
var G__8486 = c;
var G__8487 = d;
var G__8488 = e;
var G__8489 = f;
var G__8490 = g;
var G__8491 = h;
var G__8492 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__8484,G__8485,G__8486,G__8487,G__8488,G__8489,G__8490,G__8491,G__8492) : self__.afn.call(null,G__8484,G__8485,G__8486,G__8487,G__8488,G__8489,G__8490,G__8491,G__8492));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__8493 = a;
var G__8494 = b;
var G__8495 = c;
var G__8496 = d;
var G__8497 = e;
var G__8498 = f;
var G__8499 = g;
var G__8500 = h;
var G__8501 = i;
var G__8502 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__8493,G__8494,G__8495,G__8496,G__8497,G__8498,G__8499,G__8500,G__8501,G__8502) : self__.afn.call(null,G__8493,G__8494,G__8495,G__8496,G__8497,G__8498,G__8499,G__8500,G__8501,G__8502));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__8503 = a;
var G__8504 = b;
var G__8505 = c;
var G__8506 = d;
var G__8507 = e;
var G__8508 = f;
var G__8509 = g;
var G__8510 = h;
var G__8511 = i;
var G__8512 = j;
var G__8513 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__8503,G__8504,G__8505,G__8506,G__8507,G__8508,G__8509,G__8510,G__8511,G__8512,G__8513) : self__.afn.call(null,G__8503,G__8504,G__8505,G__8506,G__8507,G__8508,G__8509,G__8510,G__8511,G__8512,G__8513));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__8514 = a;
var G__8515 = b;
var G__8516 = c;
var G__8517 = d;
var G__8518 = e;
var G__8519 = f;
var G__8520 = g;
var G__8521 = h;
var G__8522 = i;
var G__8523 = j;
var G__8524 = k;
var G__8525 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__8514,G__8515,G__8516,G__8517,G__8518,G__8519,G__8520,G__8521,G__8522,G__8523,G__8524,G__8525) : self__.afn.call(null,G__8514,G__8515,G__8516,G__8517,G__8518,G__8519,G__8520,G__8521,G__8522,G__8523,G__8524,G__8525));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__8526 = a;
var G__8527 = b;
var G__8528 = c;
var G__8529 = d;
var G__8530 = e;
var G__8531 = f;
var G__8532 = g;
var G__8533 = h;
var G__8534 = i;
var G__8535 = j;
var G__8536 = k;
var G__8537 = l;
var G__8538 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__8526,G__8527,G__8528,G__8529,G__8530,G__8531,G__8532,G__8533,G__8534,G__8535,G__8536,G__8537,G__8538) : self__.afn.call(null,G__8526,G__8527,G__8528,G__8529,G__8530,G__8531,G__8532,G__8533,G__8534,G__8535,G__8536,G__8537,G__8538));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__8539 = a;
var G__8540 = b;
var G__8541 = c;
var G__8542 = d;
var G__8543 = e;
var G__8544 = f;
var G__8545 = g;
var G__8546 = h;
var G__8547 = i;
var G__8548 = j;
var G__8549 = k;
var G__8550 = l;
var G__8551 = m;
var G__8552 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__8539,G__8540,G__8541,G__8542,G__8543,G__8544,G__8545,G__8546,G__8547,G__8548,G__8549,G__8550,G__8551,G__8552) : self__.afn.call(null,G__8539,G__8540,G__8541,G__8542,G__8543,G__8544,G__8545,G__8546,G__8547,G__8548,G__8549,G__8550,G__8551,G__8552));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__8553 = a;
var G__8554 = b;
var G__8555 = c;
var G__8556 = d;
var G__8557 = e;
var G__8558 = f;
var G__8559 = g;
var G__8560 = h;
var G__8561 = i;
var G__8562 = j;
var G__8563 = k;
var G__8564 = l;
var G__8565 = m;
var G__8566 = n;
var G__8567 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__8553,G__8554,G__8555,G__8556,G__8557,G__8558,G__8559,G__8560,G__8561,G__8562,G__8563,G__8564,G__8565,G__8566,G__8567) : self__.afn.call(null,G__8553,G__8554,G__8555,G__8556,G__8557,G__8558,G__8559,G__8560,G__8561,G__8562,G__8563,G__8564,G__8565,G__8566,G__8567));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__8568 = a;
var G__8569 = b;
var G__8570 = c;
var G__8571 = d;
var G__8572 = e;
var G__8573 = f;
var G__8574 = g;
var G__8575 = h;
var G__8576 = i;
var G__8577 = j;
var G__8578 = k;
var G__8579 = l;
var G__8580 = m;
var G__8581 = n;
var G__8582 = o;
var G__8583 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__8568,G__8569,G__8570,G__8571,G__8572,G__8573,G__8574,G__8575,G__8576,G__8577,G__8578,G__8579,G__8580,G__8581,G__8582,G__8583) : self__.afn.call(null,G__8568,G__8569,G__8570,G__8571,G__8572,G__8573,G__8574,G__8575,G__8576,G__8577,G__8578,G__8579,G__8580,G__8581,G__8582,G__8583));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__8584 = a;
var G__8585 = b;
var G__8586 = c;
var G__8587 = d;
var G__8588 = e;
var G__8589 = f;
var G__8590 = g;
var G__8591 = h;
var G__8592 = i;
var G__8593 = j;
var G__8594 = k;
var G__8595 = l;
var G__8596 = m;
var G__8597 = n;
var G__8598 = o;
var G__8599 = p;
var G__8600 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__8584,G__8585,G__8586,G__8587,G__8588,G__8589,G__8590,G__8591,G__8592,G__8593,G__8594,G__8595,G__8596,G__8597,G__8598,G__8599,G__8600) : self__.afn.call(null,G__8584,G__8585,G__8586,G__8587,G__8588,G__8589,G__8590,G__8591,G__8592,G__8593,G__8594,G__8595,G__8596,G__8597,G__8598,G__8599,G__8600));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__8601 = a;
var G__8602 = b;
var G__8603 = c;
var G__8604 = d;
var G__8605 = e;
var G__8606 = f;
var G__8607 = g;
var G__8608 = h;
var G__8609 = i;
var G__8610 = j;
var G__8611 = k;
var G__8612 = l;
var G__8613 = m;
var G__8614 = n;
var G__8615 = o;
var G__8616 = p;
var G__8617 = q;
var G__8618 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__8601,G__8602,G__8603,G__8604,G__8605,G__8606,G__8607,G__8608,G__8609,G__8610,G__8611,G__8612,G__8613,G__8614,G__8615,G__8616,G__8617,G__8618) : self__.afn.call(null,G__8601,G__8602,G__8603,G__8604,G__8605,G__8606,G__8607,G__8608,G__8609,G__8610,G__8611,G__8612,G__8613,G__8614,G__8615,G__8616,G__8617,G__8618));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__8619 = a;
var G__8620 = b;
var G__8621 = c;
var G__8622 = d;
var G__8623 = e;
var G__8624 = f;
var G__8625 = g;
var G__8626 = h;
var G__8627 = i;
var G__8628 = j;
var G__8629 = k;
var G__8630 = l;
var G__8631 = m;
var G__8632 = n;
var G__8633 = o;
var G__8634 = p;
var G__8635 = q;
var G__8636 = r;
var G__8637 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__8619,G__8620,G__8621,G__8622,G__8623,G__8624,G__8625,G__8626,G__8627,G__8628,G__8629,G__8630,G__8631,G__8632,G__8633,G__8634,G__8635,G__8636,G__8637) : self__.afn.call(null,G__8619,G__8620,G__8621,G__8622,G__8623,G__8624,G__8625,G__8626,G__8627,G__8628,G__8629,G__8630,G__8631,G__8632,G__8633,G__8634,G__8635,G__8636,G__8637));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__8638 = a;
var G__8639 = b;
var G__8640 = c;
var G__8641 = d;
var G__8642 = e;
var G__8643 = f;
var G__8644 = g;
var G__8645 = h;
var G__8646 = i;
var G__8647 = j;
var G__8648 = k;
var G__8649 = l;
var G__8650 = m;
var G__8651 = n;
var G__8652 = o;
var G__8653 = p;
var G__8654 = q;
var G__8655 = r;
var G__8656 = s;
var G__8657 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__8638,G__8639,G__8640,G__8641,G__8642,G__8643,G__8644,G__8645,G__8646,G__8647,G__8648,G__8649,G__8650,G__8651,G__8652,G__8653,G__8654,G__8655,G__8656,G__8657) : self__.afn.call(null,G__8638,G__8639,G__8640,G__8641,G__8642,G__8643,G__8644,G__8645,G__8646,G__8647,G__8648,G__8649,G__8650,G__8651,G__8652,G__8653,G__8654,G__8655,G__8656,G__8657));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__8658 = self__.afn;
var G__8659 = a;
var G__8660 = b;
var G__8661 = c;
var G__8662 = d;
var G__8663 = e;
var G__8664 = f;
var G__8665 = g;
var G__8666 = h;
var G__8667 = i;
var G__8668 = j;
var G__8669 = k;
var G__8670 = l;
var G__8671 = m;
var G__8672 = n;
var G__8673 = o;
var G__8674 = p;
var G__8675 = q;
var G__8676 = r;
var G__8677 = s;
var G__8678 = t;
var G__8679 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__8658,G__8659,G__8660,G__8661,G__8662,G__8663,G__8664,G__8665,G__8666,G__8667,G__8668,G__8669,G__8670,G__8671,G__8672,G__8673,G__8674,G__8675,G__8676,G__8677,G__8678,G__8679) : cljs.core.apply.call(null,G__8658,G__8659,G__8660,G__8661,G__8662,G__8663,G__8664,G__8665,G__8666,G__8667,G__8668,G__8669,G__8670,G__8671,G__8672,G__8673,G__8674,G__8675,G__8676,G__8677,G__8678,G__8679));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function __GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
* Returns an object of the same type and value as obj, with
* map m as its metadata.
*/
cljs.core.with_meta = (function with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__8684 = o;
if(G__8684){
var bit__4439__auto__ = (G__8684.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4439__auto__) || (G__8684.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__8684.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__8684);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__8684);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
* Returns the metadata of obj, returns nil if there is no metadata.
*/
cljs.core.meta = (function meta(o){
if((function (){var and__3746__auto__ = !((o == null));
if(and__3746__auto__){
var G__8688 = o;
if(G__8688){
var bit__4439__auto__ = (G__8688.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4439__auto__) || (G__8688.cljs$core$IMeta$)){
return true;
} else {
if((!G__8688.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__8688);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__8688);
}
} else {
return and__3746__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
* For a list or queue, same as first, for a vector, same as, but much
* more efficient than, last. If the collection is empty, returns nil.
*/
cljs.core.peek = (function peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
* For a list or queue, returns a new list/queue without the first
* item, for a vector, returns a new vector without the last item.
* Note - not the same as next/butlast.
*/
cljs.core.pop = (function pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
* disj[oin]. Returns a new set of the same (hashed/sorted) type, that
* does not contain key(s).
* @param {...*} var_args
*/
cljs.core.disj = (function() {
var disj = null;
var disj__1 = (function (coll){
return coll;
});
var disj__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});
var disj__3 = (function() { 
var G__8691__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__8692 = ret;
var G__8693 = cljs.core.first(ks);
var G__8694 = cljs.core.next(ks);
coll = G__8692;
k = G__8693;
ks = G__8694;
continue;
} else {
return ret;
}
}
break;
}
};
var G__8691 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__8695__i = 0, G__8695__a = new Array(arguments.length -  2);
while (G__8695__i < G__8695__a.length) {G__8695__a[G__8695__i] = arguments[G__8695__i + 2]; ++G__8695__i;}
  ks = new cljs.core.IndexedSeq(G__8695__a,0);
} 
return G__8691__delegate.call(this,coll,k,ks);};
G__8691.cljs$lang$maxFixedArity = 2;
G__8691.cljs$lang$applyTo = (function (arglist__8696){
var coll = cljs.core.first(arglist__8696);
arglist__8696 = cljs.core.next(arglist__8696);
var k = cljs.core.first(arglist__8696);
var ks = cljs.core.rest(arglist__8696);
return G__8691__delegate(coll,k,ks);
});
G__8691.cljs$core$IFn$_invoke$arity$variadic = G__8691__delegate;
return G__8691;
})()
;
disj = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return disj__1.call(this,coll);
case 2:
return disj__2.call(this,coll,k);
default:
var G__8697 = null;
if (arguments.length > 2) {
var G__8698__i = 0, G__8698__a = new Array(arguments.length -  2);
while (G__8698__i < G__8698__a.length) {G__8698__a[G__8698__i] = arguments[G__8698__i + 2]; ++G__8698__i;}
G__8697 = new cljs.core.IndexedSeq(G__8698__a,0);
}
return disj__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__8697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
disj.cljs$lang$maxFixedArity = 2;
disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
disj.cljs$core$IFn$_invoke$arity$1 = disj__1;
disj.cljs$core$IFn$_invoke$arity$2 = disj__2;
disj.cljs$core$IFn$_invoke$arity$variadic = disj__3.cljs$core$IFn$_invoke$arity$variadic;
return disj;
})()
;
/**
* Returns true if coll has no items - same as (not (seq coll)).
* Please use the idiom (seq x) rather than (not (empty? x))
*/
cljs.core.empty_QMARK_ = (function empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
* Returns true if x satisfies ICollection
*/
cljs.core.coll_QMARK_ = (function coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__8700 = x;
if(G__8700){
var bit__4439__auto__ = (G__8700.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4439__auto__) || (G__8700.cljs$core$ICollection$)){
return true;
} else {
if((!G__8700.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__8700);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__8700);
}
}
});
/**
* Returns true if x satisfies ISet
*/
cljs.core.set_QMARK_ = (function set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__8702 = x;
if(G__8702){
var bit__4439__auto__ = (G__8702.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4439__auto__) || (G__8702.cljs$core$ISet$)){
return true;
} else {
if((!G__8702.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__8702);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__8702);
}
}
});
/**
* Returns true if coll implements Associative
*/
cljs.core.associative_QMARK_ = (function associative_QMARK_(x){
var G__8704 = x;
if(G__8704){
var bit__4439__auto__ = (G__8704.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4439__auto__) || (G__8704.cljs$core$IAssociative$)){
return true;
} else {
if((!G__8704.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__8704);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__8704);
}
});
/**
* Returns true if coll satisfies ISequential
*/
cljs.core.sequential_QMARK_ = (function sequential_QMARK_(x){
var G__8706 = x;
if(G__8706){
var bit__4439__auto__ = (G__8706.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4439__auto__) || (G__8706.cljs$core$ISequential$)){
return true;
} else {
if((!G__8706.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__8706);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__8706);
}
});
/**
* Returns true if coll satisfies ISorted
*/
cljs.core.sorted_QMARK_ = (function sorted_QMARK_(x){
var G__8708 = x;
if(G__8708){
var bit__4439__auto__ = (G__8708.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4439__auto__) || (G__8708.cljs$core$ISorted$)){
return true;
} else {
if((!G__8708.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__8708);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__8708);
}
});
/**
* Returns true if coll satisfies IReduce
*/
cljs.core.reduceable_QMARK_ = (function reduceable_QMARK_(x){
var G__8710 = x;
if(G__8710){
var bit__4439__auto__ = (G__8710.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4439__auto__) || (G__8710.cljs$core$IReduce$)){
return true;
} else {
if((!G__8710.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__8710);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__8710);
}
});
/**
* Return true if x satisfies IMap
*/
cljs.core.map_QMARK_ = (function map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__8712 = x;
if(G__8712){
var bit__4439__auto__ = (G__8712.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4439__auto__) || (G__8712.cljs$core$IMap$)){
return true;
} else {
if((!G__8712.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__8712);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__8712);
}
}
});
/**
* Return true if x satisfies IVector
*/
cljs.core.vector_QMARK_ = (function vector_QMARK_(x){
var G__8714 = x;
if(G__8714){
var bit__4439__auto__ = (G__8714.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4439__auto__) || (G__8714.cljs$core$IVector$)){
return true;
} else {
if((!G__8714.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__8714);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__8714);
}
});

cljs.core.chunked_seq_QMARK_ = (function chunked_seq_QMARK_(x){
var G__8716 = x;
if(G__8716){
var bit__4432__auto__ = (G__8716.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4432__auto__) || (G__8716.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
* @param {...*} var_args
*/
cljs.core.js_obj = (function() {
var js_obj = null;
var js_obj__0 = (function (){
var obj8722 = {};
return obj8722;
});
var js_obj__1 = (function() { 
var G__8725__delegate = function (keyvals){
var G__8723 = goog.object.create;
var G__8724 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__8723,G__8724) : cljs.core.apply.call(null,G__8723,G__8724));
};
var G__8725 = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__8726__i = 0, G__8726__a = new Array(arguments.length -  0);
while (G__8726__i < G__8726__a.length) {G__8726__a[G__8726__i] = arguments[G__8726__i + 0]; ++G__8726__i;}
  keyvals = new cljs.core.IndexedSeq(G__8726__a,0);
} 
return G__8725__delegate.call(this,keyvals);};
G__8725.cljs$lang$maxFixedArity = 0;
G__8725.cljs$lang$applyTo = (function (arglist__8727){
var keyvals = cljs.core.seq(arglist__8727);
return G__8725__delegate(keyvals);
});
G__8725.cljs$core$IFn$_invoke$arity$variadic = G__8725__delegate;
return G__8725;
})()
;
js_obj = function(var_args){
var keyvals = var_args;
switch(arguments.length){
case 0:
return js_obj__0.call(this);
default:
var G__8728 = null;
if (arguments.length > 0) {
var G__8729__i = 0, G__8729__a = new Array(arguments.length -  0);
while (G__8729__i < G__8729__a.length) {G__8729__a[G__8729__i] = arguments[G__8729__i + 0]; ++G__8729__i;}
G__8728 = new cljs.core.IndexedSeq(G__8729__a,0);
}
return js_obj__1.cljs$core$IFn$_invoke$arity$variadic(G__8728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
js_obj.cljs$lang$maxFixedArity = 0;
js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
js_obj.cljs$core$IFn$_invoke$arity$0 = js_obj__0;
js_obj.cljs$core$IFn$_invoke$arity$variadic = js_obj__1.cljs$core$IFn$_invoke$arity$variadic;
return js_obj;
})()
;
cljs.core.js_keys = (function js_keys(obj){
var keys = [];
var G__8732_8734 = obj;
var G__8733_8735 = ((function (G__8732_8734,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__8732_8734,keys))
;
goog.object.forEach(G__8732_8734,G__8733_8735);

return keys;
});
cljs.core.js_delete = (function js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__8736 = (i__$1 + (1));
var G__8737 = (j__$1 + (1));
var G__8738 = (len__$1 - (1));
i__$1 = G__8736;
j__$1 = G__8737;
len__$1 = G__8738;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__8739 = (i__$1 - (1));
var G__8740 = (j__$1 - (1));
var G__8741 = (len__$1 - (1));
i__$1 = G__8739;
j__$1 = G__8740;
len__$1 = G__8741;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj8743 = {};
return obj8743;
})();
/**
* Returns true if x is the value false, false otherwise.
*/
cljs.core.false_QMARK_ = (function false_QMARK_(x){
return x === false;
});
/**
* Returns true if x is the value true, false otherwise.
*/
cljs.core.true_QMARK_ = (function true_QMARK_(x){
return x === true;
});
cljs.core.undefined_QMARK_ = (function undefined_QMARK_(x){
return (void 0 === x);
});
/**
* Return true if s satisfies ISeq
*/
cljs.core.seq_QMARK_ = (function seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__8745 = s;
if(G__8745){
var bit__4439__auto__ = (G__8745.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4439__auto__) || (G__8745.cljs$core$ISeq$)){
return true;
} else {
if((!G__8745.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8745);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__8745);
}
}
});
/**
* Return true if s satisfies ISeqable
*/
cljs.core.seqable_QMARK_ = (function seqable_QMARK_(s){
var G__8747 = s;
if(G__8747){
var bit__4439__auto__ = (G__8747.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4439__auto__) || (G__8747.cljs$core$ISeqable$)){
return true;
} else {
if((!G__8747.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__8747);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__8747);
}
});
cljs.core.boolean$ = (function boolean$(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
cljs.core.ifn_QMARK_ = (function ifn_QMARK_(f){
var or__3758__auto__ = cljs.core.fn_QMARK_(f);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var G__8751 = f;
if(G__8751){
var bit__4439__auto__ = (G__8751.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4439__auto__) || (G__8751.cljs$core$IFn$)){
return true;
} else {
if((!G__8751.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__8751);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__8751);
}
}
});
/**
* Returns true if n is an integer.
*/
cljs.core.integer_QMARK_ = (function integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__8764 = n;
return isNaN(G__8764);
})())) && (!((n === Infinity))) && (((function (){var G__8765 = n;
return parseFloat(G__8765);
})() === (function (){var G__8766 = n;
var G__8767 = (10);
return parseInt(G__8766,G__8767);
})()));
});
/**
* Returns true if key is present in the given collection, otherwise
* returns false.  Note that for numerically indexed collections like
* vectors and arrays, this tests if the numeric key is within the
* range of indexes. 'contains?' operates constant or logarithmic time;
* it will not perform a linear search for a value.  See also 'some'.
*/
cljs.core.contains_QMARK_ = (function contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
* Returns the map entry for key, or nil if key not present.
*/
cljs.core.find = (function find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
* Returns true if no two of the arguments are =
* @param {...*} var_args
*/
cljs.core.distinct_QMARK_ = (function() {
var distinct_QMARK_ = null;
var distinct_QMARK___1 = (function (x){
return true;
});
var distinct_QMARK___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var distinct_QMARK___3 = (function() { 
var G__8768__delegate = function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__8769 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__8770 = etc;
s = G__8769;
xs = G__8770;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
};
var G__8768 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8771__i = 0, G__8771__a = new Array(arguments.length -  2);
while (G__8771__i < G__8771__a.length) {G__8771__a[G__8771__i] = arguments[G__8771__i + 2]; ++G__8771__i;}
  more = new cljs.core.IndexedSeq(G__8771__a,0);
} 
return G__8768__delegate.call(this,x,y,more);};
G__8768.cljs$lang$maxFixedArity = 2;
G__8768.cljs$lang$applyTo = (function (arglist__8772){
var x = cljs.core.first(arglist__8772);
arglist__8772 = cljs.core.next(arglist__8772);
var y = cljs.core.first(arglist__8772);
var more = cljs.core.rest(arglist__8772);
return G__8768__delegate(x,y,more);
});
G__8768.cljs$core$IFn$_invoke$arity$variadic = G__8768__delegate;
return G__8768;
})()
;
distinct_QMARK_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return distinct_QMARK___1.call(this,x);
case 2:
return distinct_QMARK___2.call(this,x,y);
default:
var G__8773 = null;
if (arguments.length > 2) {
var G__8774__i = 0, G__8774__a = new Array(arguments.length -  2);
while (G__8774__i < G__8774__a.length) {G__8774__a[G__8774__i] = arguments[G__8774__i + 2]; ++G__8774__i;}
G__8773 = new cljs.core.IndexedSeq(G__8774__a,0);
}
return distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
distinct_QMARK_.cljs$lang$maxFixedArity = 2;
distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = distinct_QMARK___1;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = distinct_QMARK___2;
distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic;
return distinct_QMARK_;
})()
;
/**
* Comparator. Returns a negative number, zero, or a positive number
* when x is logically 'less than', 'equal to', or 'greater than'
* y. Uses IComparable if available and google.array.defaultCompare for objects
* of the same type and special-cases nil to be less than any other object.
*/
cljs.core.compare = (function compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__8778 = x;
if(G__8778){
var bit__4432__auto__ = (G__8778.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4432__auto__) || (G__8778.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__8779 = x;
var G__8780 = y;
return goog.array.defaultCompare(G__8779,G__8780);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
* Compare indexed collection.
*/
cljs.core.compare_indexed = (function() {
var compare_indexed = null;
var compare_indexed__2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
return compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
});
var compare_indexed__4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__8785 = xs;
var G__8786 = ys;
var G__8787 = len;
var G__8788 = (n + (1));
xs = G__8785;
ys = G__8786;
len = G__8787;
n = G__8788;
continue;
} else {
return d;
}
break;
}
});
compare_indexed = function(xs,ys,len,n){
switch(arguments.length){
case 2:
return compare_indexed__2.call(this,xs,ys);
case 4:
return compare_indexed__4.call(this,xs,ys,len,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
compare_indexed.cljs$core$IFn$_invoke$arity$2 = compare_indexed__2;
compare_indexed.cljs$core$IFn$_invoke$arity$4 = compare_indexed__4;
return compare_indexed;
})()
;
/**
* Given a fn that might be boolean valued or a comparator,
* return a fn that is a comparator.
*/
cljs.core.fn__GT_comparator = (function fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__8793 = x;
var G__8794 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8793,G__8794) : f.call(null,G__8793,G__8794));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__8795 = y;
var G__8796 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8795,G__8796) : f.call(null,G__8795,G__8796));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
* Returns a sorted sequence of the items in coll. Comp can be
* boolean-valued comparison function, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort = (function() {
var sort = null;
var sort__1 = (function (coll){
return sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});
var sort__2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__8802 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__8802) : cljs.core.to_array.call(null,G__8802));
})();
var G__8803_8805 = a;
var G__8804_8806 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__8803_8805,G__8804_8806);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});
sort = function(comp,coll){
switch(arguments.length){
case 1:
return sort__1.call(this,comp);
case 2:
return sort__2.call(this,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sort.cljs$core$IFn$_invoke$arity$1 = sort__1;
sort.cljs$core$IFn$_invoke$arity$2 = sort__2;
return sort;
})()
;
/**
* Returns a sorted sequence of the items in coll, where the sort
* order is determined by comparing (keyfn item).  Comp can be
* boolean-valued comparison funcion, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort_by = (function() {
var sort_by = null;
var sort_by__2 = (function (keyfn,coll){
return sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});
var sort_by__3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__8812 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__8812) : keyfn.call(null,G__8812));
})(),(function (){var G__8813 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__8813) : keyfn.call(null,G__8813));
})());
}),coll);
});
sort_by = function(keyfn,comp,coll){
switch(arguments.length){
case 2:
return sort_by__2.call(this,keyfn,comp);
case 3:
return sort_by__3.call(this,keyfn,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sort_by.cljs$core$IFn$_invoke$arity$2 = sort_by__2;
sort_by.cljs$core$IFn$_invoke$arity$3 = sort_by__3;
return sort_by;
})()
;
cljs.core.seq_reduce = (function() {
var seq_reduce = null;
var seq_reduce__2 = (function (f,coll){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
var G__8819 = f;
var G__8820 = cljs.core.first(s);
var G__8821 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__8819,G__8820,G__8821) : cljs.core.reduce.call(null,G__8819,G__8820,G__8821));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});
var seq_reduce__3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__8822 = val__$1;
var G__8823 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8822,G__8823) : f.call(null,G__8822,G__8823));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__8824 = nval;
var G__8825 = cljs.core.next(coll__$1);
val__$1 = G__8824;
coll__$1 = G__8825;
continue;
}
} else {
return val__$1;
}
break;
}
});
seq_reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return seq_reduce__2.call(this,f,val);
case 3:
return seq_reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
seq_reduce.cljs$core$IFn$_invoke$arity$2 = seq_reduce__2;
seq_reduce.cljs$core$IFn$_invoke$arity$3 = seq_reduce__3;
return seq_reduce;
})()
;
/**
* Return a random permutation of coll
*/
cljs.core.shuffle = (function shuffle(coll){
var a = (function (){var G__8829 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__8829) : cljs.core.to_array.call(null,G__8829));
})();
var G__8830_8832 = a;
goog.array.shuffle(G__8830_8832);

var G__8831 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__8831) : cljs.core.vec.call(null,G__8831));
});
/**
* f should be a function of 2 arguments. If val is not supplied,
* returns the result of applying f to the first 2 items in coll, then
* applying f to that result and the 3rd item, etc. If coll contains no
* items, f must accept no arguments as well, and reduce returns the
* result of calling f with no arguments.  If coll has only 1 item, it
* is returned and f is not called.  If val is supplied, returns the
* result of applying f to val and the first item in coll, then
* applying f to that result and the 2nd item, etc. If coll contains no
* items, returns val and f is not called.
*/
cljs.core.reduce = (function() {
var reduce = null;
var reduce__2 = (function (f,coll){
if((function (){var G__8835 = coll;
if(G__8835){
var bit__4432__auto__ = (G__8835.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4432__auto__) || (G__8835.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(coll instanceof Array){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});
var reduce__3 = (function (f,val,coll){
if((function (){var G__8836 = coll;
if(G__8836){
var bit__4432__auto__ = (G__8836.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4432__auto__) || (G__8836.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(coll instanceof Array){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});
reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return reduce__2.call(this,f,val);
case 3:
return reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
reduce.cljs$core$IFn$_invoke$arity$2 = reduce__2;
reduce.cljs$core$IFn$_invoke$arity$3 = reduce__3;
return reduce;
})()
;
/**
* Reduces an associative collection. f should be a function of 3
* arguments. Returns the result of applying f to init, the first key
* and the first value in coll, then applying f to that result and the
* 2nd key and value, etc. If coll contains no entries, returns init
* and f is not called. Note that reduce-kv is supported on vectors,
* where the keys will be the ordinals.
*/
cljs.core.reduce_kv = (function reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
cljs.core.identity = (function identity(x){
return x;
});
cljs.core.completing = (function() {
var completing = null;
var completing__1 = (function (f){
return completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});
var completing__2 = (function (f,cf){
return (function() {
var G__8845 = null;
var G__8845__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__8845__1 = (function (x){
var G__8842 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__8842) : cf.call(null,G__8842));
});
var G__8845__2 = (function (x,y){
var G__8843 = x;
var G__8844 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8843,G__8844) : f.call(null,G__8843,G__8844));
});
G__8845 = function(x,y){
switch(arguments.length){
case 0:
return G__8845__0.call(this);
case 1:
return G__8845__1.call(this,x);
case 2:
return G__8845__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8845.cljs$core$IFn$_invoke$arity$0 = G__8845__0;
G__8845.cljs$core$IFn$_invoke$arity$1 = G__8845__1;
G__8845.cljs$core$IFn$_invoke$arity$2 = G__8845__2;
return G__8845;
})()
});
completing = function(f,cf){
switch(arguments.length){
case 1:
return completing__1.call(this,f);
case 2:
return completing__2.call(this,f,cf);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
completing.cljs$core$IFn$_invoke$arity$1 = completing__1;
completing.cljs$core$IFn$_invoke$arity$2 = completing__2;
return completing;
})()
;
/**
* reduce with a transformation of f (xf). If init is not
* supplied, (f) will be called to produce it. f should be a reducing
* step function that accepts both 1 and 2 arguments, if it accepts
* only 2 you can add the arity-1 with 'completing'. Returns the result
* of applying (the transformed) xf to init and the first item in coll,
* then applying xf to that result and the 2nd item, etc. If coll
* contains no items, returns init and f is not called. Note that
* certain transforms may inject or skip items.
*/
cljs.core.transduce = (function() {
var transduce = null;
var transduce__3 = (function (xform,f,coll){
return transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});
var transduce__4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__8852 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8852) : xform.call(null,G__8852));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__8853 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__8853) : f__$1.call(null,G__8853));
});
transduce = function(xform,f,init,coll){
switch(arguments.length){
case 3:
return transduce__3.call(this,xform,f,init);
case 4:
return transduce__4.call(this,xform,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
transduce.cljs$core$IFn$_invoke$arity$3 = transduce__3;
transduce.cljs$core$IFn$_invoke$arity$4 = transduce__4;
return transduce;
})()
;
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core._PLUS_ = (function() {
var _PLUS_ = null;
var _PLUS___0 = (function (){
return (0);
});
var _PLUS___1 = (function (x){
return x;
});
var _PLUS___2 = (function (x,y){
return (x + y);
});
var _PLUS___3 = (function() { 
var G__8854__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_PLUS_,(x + y),more);
};
var G__8854 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8855__i = 0, G__8855__a = new Array(arguments.length -  2);
while (G__8855__i < G__8855__a.length) {G__8855__a[G__8855__i] = arguments[G__8855__i + 2]; ++G__8855__i;}
  more = new cljs.core.IndexedSeq(G__8855__a,0);
} 
return G__8854__delegate.call(this,x,y,more);};
G__8854.cljs$lang$maxFixedArity = 2;
G__8854.cljs$lang$applyTo = (function (arglist__8856){
var x = cljs.core.first(arglist__8856);
arglist__8856 = cljs.core.next(arglist__8856);
var y = cljs.core.first(arglist__8856);
var more = cljs.core.rest(arglist__8856);
return G__8854__delegate(x,y,more);
});
G__8854.cljs$core$IFn$_invoke$arity$variadic = G__8854__delegate;
return G__8854;
})()
;
_PLUS_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _PLUS___0.call(this);
case 1:
return _PLUS___1.call(this,x);
case 2:
return _PLUS___2.call(this,x,y);
default:
var G__8857 = null;
if (arguments.length > 2) {
var G__8858__i = 0, G__8858__a = new Array(arguments.length -  2);
while (G__8858__i < G__8858__a.length) {G__8858__a[G__8858__i] = arguments[G__8858__i + 2]; ++G__8858__i;}
G__8857 = new cljs.core.IndexedSeq(G__8858__a,0);
}
return _PLUS___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_PLUS_.cljs$lang$maxFixedArity = 2;
_PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
_PLUS_.cljs$core$IFn$_invoke$arity$0 = _PLUS___0;
_PLUS_.cljs$core$IFn$_invoke$arity$1 = _PLUS___1;
_PLUS_.cljs$core$IFn$_invoke$arity$2 = _PLUS___2;
_PLUS_.cljs$core$IFn$_invoke$arity$variadic = _PLUS___3.cljs$core$IFn$_invoke$arity$variadic;
return _PLUS_;
})()
;
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core._ = (function() {
var _ = null;
var ___1 = (function (x){
return (- x);
});
var ___2 = (function (x,y){
return (x - y);
});
var ___3 = (function() { 
var G__8859__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_,(x - y),more);
};
var G__8859 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8860__i = 0, G__8860__a = new Array(arguments.length -  2);
while (G__8860__i < G__8860__a.length) {G__8860__a[G__8860__i] = arguments[G__8860__i + 2]; ++G__8860__i;}
  more = new cljs.core.IndexedSeq(G__8860__a,0);
} 
return G__8859__delegate.call(this,x,y,more);};
G__8859.cljs$lang$maxFixedArity = 2;
G__8859.cljs$lang$applyTo = (function (arglist__8861){
var x = cljs.core.first(arglist__8861);
arglist__8861 = cljs.core.next(arglist__8861);
var y = cljs.core.first(arglist__8861);
var more = cljs.core.rest(arglist__8861);
return G__8859__delegate(x,y,more);
});
G__8859.cljs$core$IFn$_invoke$arity$variadic = G__8859__delegate;
return G__8859;
})()
;
_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return ___1.call(this,x);
case 2:
return ___2.call(this,x,y);
default:
var G__8862 = null;
if (arguments.length > 2) {
var G__8863__i = 0, G__8863__a = new Array(arguments.length -  2);
while (G__8863__i < G__8863__a.length) {G__8863__a[G__8863__i] = arguments[G__8863__i + 2]; ++G__8863__i;}
G__8862 = new cljs.core.IndexedSeq(G__8863__a,0);
}
return ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_.cljs$lang$maxFixedArity = 2;
_.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
_.cljs$core$IFn$_invoke$arity$1 = ___1;
_.cljs$core$IFn$_invoke$arity$2 = ___2;
_.cljs$core$IFn$_invoke$arity$variadic = ___3.cljs$core$IFn$_invoke$arity$variadic;
return _;
})()
;
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core._STAR_ = (function() {
var _STAR_ = null;
var _STAR___0 = (function (){
return (1);
});
var _STAR___1 = (function (x){
return x;
});
var _STAR___2 = (function (x,y){
return (x * y);
});
var _STAR___3 = (function() { 
var G__8864__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_STAR_,(x * y),more);
};
var G__8864 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8865__i = 0, G__8865__a = new Array(arguments.length -  2);
while (G__8865__i < G__8865__a.length) {G__8865__a[G__8865__i] = arguments[G__8865__i + 2]; ++G__8865__i;}
  more = new cljs.core.IndexedSeq(G__8865__a,0);
} 
return G__8864__delegate.call(this,x,y,more);};
G__8864.cljs$lang$maxFixedArity = 2;
G__8864.cljs$lang$applyTo = (function (arglist__8866){
var x = cljs.core.first(arglist__8866);
arglist__8866 = cljs.core.next(arglist__8866);
var y = cljs.core.first(arglist__8866);
var more = cljs.core.rest(arglist__8866);
return G__8864__delegate(x,y,more);
});
G__8864.cljs$core$IFn$_invoke$arity$variadic = G__8864__delegate;
return G__8864;
})()
;
_STAR_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _STAR___0.call(this);
case 1:
return _STAR___1.call(this,x);
case 2:
return _STAR___2.call(this,x,y);
default:
var G__8867 = null;
if (arguments.length > 2) {
var G__8868__i = 0, G__8868__a = new Array(arguments.length -  2);
while (G__8868__i < G__8868__a.length) {G__8868__a[G__8868__i] = arguments[G__8868__i + 2]; ++G__8868__i;}
G__8867 = new cljs.core.IndexedSeq(G__8868__a,0);
}
return _STAR___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_STAR_.cljs$lang$maxFixedArity = 2;
_STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
_STAR_.cljs$core$IFn$_invoke$arity$0 = _STAR___0;
_STAR_.cljs$core$IFn$_invoke$arity$1 = _STAR___1;
_STAR_.cljs$core$IFn$_invoke$arity$2 = _STAR___2;
_STAR_.cljs$core$IFn$_invoke$arity$variadic = _STAR___3.cljs$core$IFn$_invoke$arity$variadic;
return _STAR_;
})()
;
/**
* If no denominators are supplied, returns 1/numerator,
* else returns numerator divided by all of the denominators.
* @param {...*} var_args
*/
cljs.core._SLASH_ = (function() {
var _SLASH_ = null;
var _SLASH___1 = (function (x){
return _SLASH_.cljs$core$IFn$_invoke$arity$2((1),x);
});
var _SLASH___2 = (function (x,y){
return (x / y);
});
var _SLASH___3 = (function() { 
var G__8873__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(_SLASH_,_SLASH_.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__8873 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8874__i = 0, G__8874__a = new Array(arguments.length -  2);
while (G__8874__i < G__8874__a.length) {G__8874__a[G__8874__i] = arguments[G__8874__i + 2]; ++G__8874__i;}
  more = new cljs.core.IndexedSeq(G__8874__a,0);
} 
return G__8873__delegate.call(this,x,y,more);};
G__8873.cljs$lang$maxFixedArity = 2;
G__8873.cljs$lang$applyTo = (function (arglist__8875){
var x = cljs.core.first(arglist__8875);
arglist__8875 = cljs.core.next(arglist__8875);
var y = cljs.core.first(arglist__8875);
var more = cljs.core.rest(arglist__8875);
return G__8873__delegate(x,y,more);
});
G__8873.cljs$core$IFn$_invoke$arity$variadic = G__8873__delegate;
return G__8873;
})()
;
_SLASH_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _SLASH___1.call(this,x);
case 2:
return _SLASH___2.call(this,x,y);
default:
var G__8876 = null;
if (arguments.length > 2) {
var G__8877__i = 0, G__8877__a = new Array(arguments.length -  2);
while (G__8877__i < G__8877__a.length) {G__8877__a[G__8877__i] = arguments[G__8877__i + 2]; ++G__8877__i;}
G__8876 = new cljs.core.IndexedSeq(G__8877__a,0);
}
return _SLASH___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_SLASH_.cljs$lang$maxFixedArity = 2;
_SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
_SLASH_.cljs$core$IFn$_invoke$arity$1 = _SLASH___1;
_SLASH_.cljs$core$IFn$_invoke$arity$2 = _SLASH___2;
_SLASH_.cljs$core$IFn$_invoke$arity$variadic = _SLASH___3.cljs$core$IFn$_invoke$arity$variadic;
return _SLASH_;
})()
;
/**
* Returns non-nil if nums are in monotonically increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT_ = (function() {
var _LT_ = null;
var _LT___1 = (function (x){
return true;
});
var _LT___2 = (function (x,y){
return (x < y);
});
var _LT___3 = (function() { 
var G__8878__delegate = function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__8879 = y;
var G__8880 = cljs.core.first(more);
var G__8881 = cljs.core.next(more);
x = G__8879;
y = G__8880;
more = G__8881;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8878 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8882__i = 0, G__8882__a = new Array(arguments.length -  2);
while (G__8882__i < G__8882__a.length) {G__8882__a[G__8882__i] = arguments[G__8882__i + 2]; ++G__8882__i;}
  more = new cljs.core.IndexedSeq(G__8882__a,0);
} 
return G__8878__delegate.call(this,x,y,more);};
G__8878.cljs$lang$maxFixedArity = 2;
G__8878.cljs$lang$applyTo = (function (arglist__8883){
var x = cljs.core.first(arglist__8883);
arglist__8883 = cljs.core.next(arglist__8883);
var y = cljs.core.first(arglist__8883);
var more = cljs.core.rest(arglist__8883);
return G__8878__delegate(x,y,more);
});
G__8878.cljs$core$IFn$_invoke$arity$variadic = G__8878__delegate;
return G__8878;
})()
;
_LT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT___1.call(this,x);
case 2:
return _LT___2.call(this,x,y);
default:
var G__8884 = null;
if (arguments.length > 2) {
var G__8885__i = 0, G__8885__a = new Array(arguments.length -  2);
while (G__8885__i < G__8885__a.length) {G__8885__a[G__8885__i] = arguments[G__8885__i + 2]; ++G__8885__i;}
G__8884 = new cljs.core.IndexedSeq(G__8885__a,0);
}
return _LT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_LT_.cljs$lang$maxFixedArity = 2;
_LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
_LT_.cljs$core$IFn$_invoke$arity$1 = _LT___1;
_LT_.cljs$core$IFn$_invoke$arity$2 = _LT___2;
_LT_.cljs$core$IFn$_invoke$arity$variadic = _LT___3.cljs$core$IFn$_invoke$arity$variadic;
return _LT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT__EQ_ = (function() {
var _LT__EQ_ = null;
var _LT__EQ___1 = (function (x){
return true;
});
var _LT__EQ___2 = (function (x,y){
return (x <= y);
});
var _LT__EQ___3 = (function() { 
var G__8886__delegate = function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__8887 = y;
var G__8888 = cljs.core.first(more);
var G__8889 = cljs.core.next(more);
x = G__8887;
y = G__8888;
more = G__8889;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8886 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8890__i = 0, G__8890__a = new Array(arguments.length -  2);
while (G__8890__i < G__8890__a.length) {G__8890__a[G__8890__i] = arguments[G__8890__i + 2]; ++G__8890__i;}
  more = new cljs.core.IndexedSeq(G__8890__a,0);
} 
return G__8886__delegate.call(this,x,y,more);};
G__8886.cljs$lang$maxFixedArity = 2;
G__8886.cljs$lang$applyTo = (function (arglist__8891){
var x = cljs.core.first(arglist__8891);
arglist__8891 = cljs.core.next(arglist__8891);
var y = cljs.core.first(arglist__8891);
var more = cljs.core.rest(arglist__8891);
return G__8886__delegate(x,y,more);
});
G__8886.cljs$core$IFn$_invoke$arity$variadic = G__8886__delegate;
return G__8886;
})()
;
_LT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT__EQ___1.call(this,x);
case 2:
return _LT__EQ___2.call(this,x,y);
default:
var G__8892 = null;
if (arguments.length > 2) {
var G__8893__i = 0, G__8893__a = new Array(arguments.length -  2);
while (G__8893__i < G__8893__a.length) {G__8893__a[G__8893__i] = arguments[G__8893__i + 2]; ++G__8893__i;}
G__8892 = new cljs.core.IndexedSeq(G__8893__a,0);
}
return _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_LT__EQ_.cljs$lang$maxFixedArity = 2;
_LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
_LT__EQ_.cljs$core$IFn$_invoke$arity$1 = _LT__EQ___1;
_LT__EQ_.cljs$core$IFn$_invoke$arity$2 = _LT__EQ___2;
_LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _LT__EQ_;
})()
;
/**
* Returns non-nil if nums are in monotonically decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT_ = (function() {
var _GT_ = null;
var _GT___1 = (function (x){
return true;
});
var _GT___2 = (function (x,y){
return (x > y);
});
var _GT___3 = (function() { 
var G__8894__delegate = function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__8895 = y;
var G__8896 = cljs.core.first(more);
var G__8897 = cljs.core.next(more);
x = G__8895;
y = G__8896;
more = G__8897;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8894 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8898__i = 0, G__8898__a = new Array(arguments.length -  2);
while (G__8898__i < G__8898__a.length) {G__8898__a[G__8898__i] = arguments[G__8898__i + 2]; ++G__8898__i;}
  more = new cljs.core.IndexedSeq(G__8898__a,0);
} 
return G__8894__delegate.call(this,x,y,more);};
G__8894.cljs$lang$maxFixedArity = 2;
G__8894.cljs$lang$applyTo = (function (arglist__8899){
var x = cljs.core.first(arglist__8899);
arglist__8899 = cljs.core.next(arglist__8899);
var y = cljs.core.first(arglist__8899);
var more = cljs.core.rest(arglist__8899);
return G__8894__delegate(x,y,more);
});
G__8894.cljs$core$IFn$_invoke$arity$variadic = G__8894__delegate;
return G__8894;
})()
;
_GT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT___1.call(this,x);
case 2:
return _GT___2.call(this,x,y);
default:
var G__8900 = null;
if (arguments.length > 2) {
var G__8901__i = 0, G__8901__a = new Array(arguments.length -  2);
while (G__8901__i < G__8901__a.length) {G__8901__a[G__8901__i] = arguments[G__8901__i + 2]; ++G__8901__i;}
G__8900 = new cljs.core.IndexedSeq(G__8901__a,0);
}
return _GT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_GT_.cljs$lang$maxFixedArity = 2;
_GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
_GT_.cljs$core$IFn$_invoke$arity$1 = _GT___1;
_GT_.cljs$core$IFn$_invoke$arity$2 = _GT___2;
_GT_.cljs$core$IFn$_invoke$arity$variadic = _GT___3.cljs$core$IFn$_invoke$arity$variadic;
return _GT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT__EQ_ = (function() {
var _GT__EQ_ = null;
var _GT__EQ___1 = (function (x){
return true;
});
var _GT__EQ___2 = (function (x,y){
return (x >= y);
});
var _GT__EQ___3 = (function() { 
var G__8902__delegate = function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__8903 = y;
var G__8904 = cljs.core.first(more);
var G__8905 = cljs.core.next(more);
x = G__8903;
y = G__8904;
more = G__8905;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8902 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8906__i = 0, G__8906__a = new Array(arguments.length -  2);
while (G__8906__i < G__8906__a.length) {G__8906__a[G__8906__i] = arguments[G__8906__i + 2]; ++G__8906__i;}
  more = new cljs.core.IndexedSeq(G__8906__a,0);
} 
return G__8902__delegate.call(this,x,y,more);};
G__8902.cljs$lang$maxFixedArity = 2;
G__8902.cljs$lang$applyTo = (function (arglist__8907){
var x = cljs.core.first(arglist__8907);
arglist__8907 = cljs.core.next(arglist__8907);
var y = cljs.core.first(arglist__8907);
var more = cljs.core.rest(arglist__8907);
return G__8902__delegate(x,y,more);
});
G__8902.cljs$core$IFn$_invoke$arity$variadic = G__8902__delegate;
return G__8902;
})()
;
_GT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT__EQ___1.call(this,x);
case 2:
return _GT__EQ___2.call(this,x,y);
default:
var G__8908 = null;
if (arguments.length > 2) {
var G__8909__i = 0, G__8909__a = new Array(arguments.length -  2);
while (G__8909__i < G__8909__a.length) {G__8909__a[G__8909__i] = arguments[G__8909__i + 2]; ++G__8909__i;}
G__8908 = new cljs.core.IndexedSeq(G__8909__a,0);
}
return _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_GT__EQ_.cljs$lang$maxFixedArity = 2;
_GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
_GT__EQ_.cljs$core$IFn$_invoke$arity$1 = _GT__EQ___1;
_GT__EQ_.cljs$core$IFn$_invoke$arity$2 = _GT__EQ___2;
_GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = _GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _GT__EQ_;
})()
;
/**
* Returns a number one less than num.
*/
cljs.core.dec = (function dec(x){
return (x - (1));
});
/**
* Returns the greatest of the nums.
* @param {...*} var_args
*/
cljs.core.max = (function() {
var max = null;
var max__1 = (function (x){
return x;
});
var max__2 = (function (x,y){
var x__4075__auto__ = x;
var y__4076__auto__ = y;
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
});
var max__3 = (function() { 
var G__8910__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(max,(function (){var x__4075__auto__ = x;
var y__4076__auto__ = y;
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
})(),more);
};
var G__8910 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8911__i = 0, G__8911__a = new Array(arguments.length -  2);
while (G__8911__i < G__8911__a.length) {G__8911__a[G__8911__i] = arguments[G__8911__i + 2]; ++G__8911__i;}
  more = new cljs.core.IndexedSeq(G__8911__a,0);
} 
return G__8910__delegate.call(this,x,y,more);};
G__8910.cljs$lang$maxFixedArity = 2;
G__8910.cljs$lang$applyTo = (function (arglist__8912){
var x = cljs.core.first(arglist__8912);
arglist__8912 = cljs.core.next(arglist__8912);
var y = cljs.core.first(arglist__8912);
var more = cljs.core.rest(arglist__8912);
return G__8910__delegate(x,y,more);
});
G__8910.cljs$core$IFn$_invoke$arity$variadic = G__8910__delegate;
return G__8910;
})()
;
max = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return max__1.call(this,x);
case 2:
return max__2.call(this,x,y);
default:
var G__8913 = null;
if (arguments.length > 2) {
var G__8914__i = 0, G__8914__a = new Array(arguments.length -  2);
while (G__8914__i < G__8914__a.length) {G__8914__a[G__8914__i] = arguments[G__8914__i + 2]; ++G__8914__i;}
G__8913 = new cljs.core.IndexedSeq(G__8914__a,0);
}
return max__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
max.cljs$lang$maxFixedArity = 2;
max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
max.cljs$core$IFn$_invoke$arity$1 = max__1;
max.cljs$core$IFn$_invoke$arity$2 = max__2;
max.cljs$core$IFn$_invoke$arity$variadic = max__3.cljs$core$IFn$_invoke$arity$variadic;
return max;
})()
;
/**
* Returns the least of the nums.
* @param {...*} var_args
*/
cljs.core.min = (function() {
var min = null;
var min__1 = (function (x){
return x;
});
var min__2 = (function (x,y){
var x__4082__auto__ = x;
var y__4083__auto__ = y;
return ((x__4082__auto__ < y__4083__auto__) ? x__4082__auto__ : y__4083__auto__);
});
var min__3 = (function() { 
var G__8915__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(min,(function (){var x__4082__auto__ = x;
var y__4083__auto__ = y;
return ((x__4082__auto__ < y__4083__auto__) ? x__4082__auto__ : y__4083__auto__);
})(),more);
};
var G__8915 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8916__i = 0, G__8916__a = new Array(arguments.length -  2);
while (G__8916__i < G__8916__a.length) {G__8916__a[G__8916__i] = arguments[G__8916__i + 2]; ++G__8916__i;}
  more = new cljs.core.IndexedSeq(G__8916__a,0);
} 
return G__8915__delegate.call(this,x,y,more);};
G__8915.cljs$lang$maxFixedArity = 2;
G__8915.cljs$lang$applyTo = (function (arglist__8917){
var x = cljs.core.first(arglist__8917);
arglist__8917 = cljs.core.next(arglist__8917);
var y = cljs.core.first(arglist__8917);
var more = cljs.core.rest(arglist__8917);
return G__8915__delegate(x,y,more);
});
G__8915.cljs$core$IFn$_invoke$arity$variadic = G__8915__delegate;
return G__8915;
})()
;
min = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return min__1.call(this,x);
case 2:
return min__2.call(this,x,y);
default:
var G__8918 = null;
if (arguments.length > 2) {
var G__8919__i = 0, G__8919__a = new Array(arguments.length -  2);
while (G__8919__i < G__8919__a.length) {G__8919__a[G__8919__i] = arguments[G__8919__i + 2]; ++G__8919__i;}
G__8918 = new cljs.core.IndexedSeq(G__8919__a,0);
}
return min__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
min.cljs$lang$maxFixedArity = 2;
min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
min.cljs$core$IFn$_invoke$arity$1 = min__1;
min.cljs$core$IFn$_invoke$arity$2 = min__2;
min.cljs$core$IFn$_invoke$arity$variadic = min__3.cljs$core$IFn$_invoke$arity$variadic;
return min;
})()
;
cljs.core.byte$ = (function byte$(x){
return x;
});
/**
* Coerce to char
*/
cljs.core.char$ = (function char$(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function short$(x){
return x;
});
cljs.core.float$ = (function float$(x){
return x;
});
cljs.core.double$ = (function double$(x){
return x;
});
cljs.core.unchecked_byte = (function unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function unchecked_double(x){
return x;
});
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core.unchecked_add = (function() {
var unchecked_add = null;
var unchecked_add__0 = (function (){
return (0);
});
var unchecked_add__1 = (function (x){
return x;
});
var unchecked_add__2 = (function (x,y){
return (x + y);
});
var unchecked_add__3 = (function() { 
var G__8920__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_add,(x + y),more);
};
var G__8920 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8921__i = 0, G__8921__a = new Array(arguments.length -  2);
while (G__8921__i < G__8921__a.length) {G__8921__a[G__8921__i] = arguments[G__8921__i + 2]; ++G__8921__i;}
  more = new cljs.core.IndexedSeq(G__8921__a,0);
} 
return G__8920__delegate.call(this,x,y,more);};
G__8920.cljs$lang$maxFixedArity = 2;
G__8920.cljs$lang$applyTo = (function (arglist__8922){
var x = cljs.core.first(arglist__8922);
arglist__8922 = cljs.core.next(arglist__8922);
var y = cljs.core.first(arglist__8922);
var more = cljs.core.rest(arglist__8922);
return G__8920__delegate(x,y,more);
});
G__8920.cljs$core$IFn$_invoke$arity$variadic = G__8920__delegate;
return G__8920;
})()
;
unchecked_add = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_add__0.call(this);
case 1:
return unchecked_add__1.call(this,x);
case 2:
return unchecked_add__2.call(this,x,y);
default:
var G__8923 = null;
if (arguments.length > 2) {
var G__8924__i = 0, G__8924__a = new Array(arguments.length -  2);
while (G__8924__i < G__8924__a.length) {G__8924__a[G__8924__i] = arguments[G__8924__i + 2]; ++G__8924__i;}
G__8923 = new cljs.core.IndexedSeq(G__8924__a,0);
}
return unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_add.cljs$lang$maxFixedArity = 2;
unchecked_add.cljs$lang$applyTo = unchecked_add__3.cljs$lang$applyTo;
unchecked_add.cljs$core$IFn$_invoke$arity$0 = unchecked_add__0;
unchecked_add.cljs$core$IFn$_invoke$arity$1 = unchecked_add__1;
unchecked_add.cljs$core$IFn$_invoke$arity$2 = unchecked_add__2;
unchecked_add.cljs$core$IFn$_invoke$arity$variadic = unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_add;
})()
;
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core.unchecked_add_int = (function() {
var unchecked_add_int = null;
var unchecked_add_int__0 = (function (){
return (0);
});
var unchecked_add_int__1 = (function (x){
return x;
});
var unchecked_add_int__2 = (function (x,y){
return (x + y);
});
var unchecked_add_int__3 = (function() { 
var G__8925__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_add_int,(x + y),more);
};
var G__8925 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8926__i = 0, G__8926__a = new Array(arguments.length -  2);
while (G__8926__i < G__8926__a.length) {G__8926__a[G__8926__i] = arguments[G__8926__i + 2]; ++G__8926__i;}
  more = new cljs.core.IndexedSeq(G__8926__a,0);
} 
return G__8925__delegate.call(this,x,y,more);};
G__8925.cljs$lang$maxFixedArity = 2;
G__8925.cljs$lang$applyTo = (function (arglist__8927){
var x = cljs.core.first(arglist__8927);
arglist__8927 = cljs.core.next(arglist__8927);
var y = cljs.core.first(arglist__8927);
var more = cljs.core.rest(arglist__8927);
return G__8925__delegate(x,y,more);
});
G__8925.cljs$core$IFn$_invoke$arity$variadic = G__8925__delegate;
return G__8925;
})()
;
unchecked_add_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_add_int__0.call(this);
case 1:
return unchecked_add_int__1.call(this,x);
case 2:
return unchecked_add_int__2.call(this,x,y);
default:
var G__8928 = null;
if (arguments.length > 2) {
var G__8929__i = 0, G__8929__a = new Array(arguments.length -  2);
while (G__8929__i < G__8929__a.length) {G__8929__a[G__8929__i] = arguments[G__8929__i + 2]; ++G__8929__i;}
G__8928 = new cljs.core.IndexedSeq(G__8929__a,0);
}
return unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_add_int.cljs$lang$maxFixedArity = 2;
unchecked_add_int.cljs$lang$applyTo = unchecked_add_int__3.cljs$lang$applyTo;
unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = unchecked_add_int__0;
unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = unchecked_add_int__1;
unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = unchecked_add_int__2;
unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_add_int;
})()
;
cljs.core.unchecked_dec = (function unchecked_dec(x){
return (x - (1));
});
cljs.core.unchecked_dec_int = (function unchecked_dec_int(x){
return (x - (1));
});
/**
* If no denominators are supplied, returns 1/numerator,
* else returns numerator divided by all of the denominators.
* @param {...*} var_args
*/
cljs.core.unchecked_divide_int = (function() {
var unchecked_divide_int = null;
var unchecked_divide_int__1 = (function (x){
return unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((1),x);
});
var unchecked_divide_int__2 = (function (x,y){
return (x / y);
});
var unchecked_divide_int__3 = (function() { 
var G__8934__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_divide_int,unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__8934 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8935__i = 0, G__8935__a = new Array(arguments.length -  2);
while (G__8935__i < G__8935__a.length) {G__8935__a[G__8935__i] = arguments[G__8935__i + 2]; ++G__8935__i;}
  more = new cljs.core.IndexedSeq(G__8935__a,0);
} 
return G__8934__delegate.call(this,x,y,more);};
G__8934.cljs$lang$maxFixedArity = 2;
G__8934.cljs$lang$applyTo = (function (arglist__8936){
var x = cljs.core.first(arglist__8936);
arglist__8936 = cljs.core.next(arglist__8936);
var y = cljs.core.first(arglist__8936);
var more = cljs.core.rest(arglist__8936);
return G__8934__delegate(x,y,more);
});
G__8934.cljs$core$IFn$_invoke$arity$variadic = G__8934__delegate;
return G__8934;
})()
;
unchecked_divide_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_divide_int__1.call(this,x);
case 2:
return unchecked_divide_int__2.call(this,x,y);
default:
var G__8937 = null;
if (arguments.length > 2) {
var G__8938__i = 0, G__8938__a = new Array(arguments.length -  2);
while (G__8938__i < G__8938__a.length) {G__8938__a[G__8938__i] = arguments[G__8938__i + 2]; ++G__8938__i;}
G__8937 = new cljs.core.IndexedSeq(G__8938__a,0);
}
return unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_divide_int.cljs$lang$maxFixedArity = 2;
unchecked_divide_int.cljs$lang$applyTo = unchecked_divide_int__3.cljs$lang$applyTo;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = unchecked_divide_int__1;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = unchecked_divide_int__2;
unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_divide_int;
})()
;
cljs.core.unchecked_inc = (function unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function unchecked_inc_int(x){
return (x + (1));
});
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core.unchecked_multiply = (function() {
var unchecked_multiply = null;
var unchecked_multiply__0 = (function (){
return (1);
});
var unchecked_multiply__1 = (function (x){
return x;
});
var unchecked_multiply__2 = (function (x,y){
return (x * y);
});
var unchecked_multiply__3 = (function() { 
var G__8939__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_multiply,(x * y),more);
};
var G__8939 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8940__i = 0, G__8940__a = new Array(arguments.length -  2);
while (G__8940__i < G__8940__a.length) {G__8940__a[G__8940__i] = arguments[G__8940__i + 2]; ++G__8940__i;}
  more = new cljs.core.IndexedSeq(G__8940__a,0);
} 
return G__8939__delegate.call(this,x,y,more);};
G__8939.cljs$lang$maxFixedArity = 2;
G__8939.cljs$lang$applyTo = (function (arglist__8941){
var x = cljs.core.first(arglist__8941);
arglist__8941 = cljs.core.next(arglist__8941);
var y = cljs.core.first(arglist__8941);
var more = cljs.core.rest(arglist__8941);
return G__8939__delegate(x,y,more);
});
G__8939.cljs$core$IFn$_invoke$arity$variadic = G__8939__delegate;
return G__8939;
})()
;
unchecked_multiply = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_multiply__0.call(this);
case 1:
return unchecked_multiply__1.call(this,x);
case 2:
return unchecked_multiply__2.call(this,x,y);
default:
var G__8942 = null;
if (arguments.length > 2) {
var G__8943__i = 0, G__8943__a = new Array(arguments.length -  2);
while (G__8943__i < G__8943__a.length) {G__8943__a[G__8943__i] = arguments[G__8943__i + 2]; ++G__8943__i;}
G__8942 = new cljs.core.IndexedSeq(G__8943__a,0);
}
return unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_multiply.cljs$lang$maxFixedArity = 2;
unchecked_multiply.cljs$lang$applyTo = unchecked_multiply__3.cljs$lang$applyTo;
unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply__0;
unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply__1;
unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply__2;
unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_multiply;
})()
;
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core.unchecked_multiply_int = (function() {
var unchecked_multiply_int = null;
var unchecked_multiply_int__0 = (function (){
return (1);
});
var unchecked_multiply_int__1 = (function (x){
return x;
});
var unchecked_multiply_int__2 = (function (x,y){
return (x * y);
});
var unchecked_multiply_int__3 = (function() { 
var G__8944__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_multiply_int,(x * y),more);
};
var G__8944 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8945__i = 0, G__8945__a = new Array(arguments.length -  2);
while (G__8945__i < G__8945__a.length) {G__8945__a[G__8945__i] = arguments[G__8945__i + 2]; ++G__8945__i;}
  more = new cljs.core.IndexedSeq(G__8945__a,0);
} 
return G__8944__delegate.call(this,x,y,more);};
G__8944.cljs$lang$maxFixedArity = 2;
G__8944.cljs$lang$applyTo = (function (arglist__8946){
var x = cljs.core.first(arglist__8946);
arglist__8946 = cljs.core.next(arglist__8946);
var y = cljs.core.first(arglist__8946);
var more = cljs.core.rest(arglist__8946);
return G__8944__delegate(x,y,more);
});
G__8944.cljs$core$IFn$_invoke$arity$variadic = G__8944__delegate;
return G__8944;
})()
;
unchecked_multiply_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return unchecked_multiply_int__0.call(this);
case 1:
return unchecked_multiply_int__1.call(this,x);
case 2:
return unchecked_multiply_int__2.call(this,x,y);
default:
var G__8947 = null;
if (arguments.length > 2) {
var G__8948__i = 0, G__8948__a = new Array(arguments.length -  2);
while (G__8948__i < G__8948__a.length) {G__8948__a[G__8948__i] = arguments[G__8948__i + 2]; ++G__8948__i;}
G__8947 = new cljs.core.IndexedSeq(G__8948__a,0);
}
return unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
unchecked_multiply_int.cljs$lang$applyTo = unchecked_multiply_int__3.cljs$lang$applyTo;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = unchecked_multiply_int__0;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = unchecked_multiply_int__1;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = unchecked_multiply_int__2;
unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_multiply_int;
})()
;
cljs.core.unchecked_negate = (function unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function unchecked_remainder_int(x,n){
var G__8951 = x;
var G__8952 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__8951,G__8952) : cljs.core.mod.call(null,G__8951,G__8952));
});
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core.unchecked_subtract = (function() {
var unchecked_subtract = null;
var unchecked_subtract__1 = (function (x){
return (- x);
});
var unchecked_subtract__2 = (function (x,y){
return (x - y);
});
var unchecked_subtract__3 = (function() { 
var G__8953__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_subtract,(x - y),more);
};
var G__8953 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8954__i = 0, G__8954__a = new Array(arguments.length -  2);
while (G__8954__i < G__8954__a.length) {G__8954__a[G__8954__i] = arguments[G__8954__i + 2]; ++G__8954__i;}
  more = new cljs.core.IndexedSeq(G__8954__a,0);
} 
return G__8953__delegate.call(this,x,y,more);};
G__8953.cljs$lang$maxFixedArity = 2;
G__8953.cljs$lang$applyTo = (function (arglist__8955){
var x = cljs.core.first(arglist__8955);
arglist__8955 = cljs.core.next(arglist__8955);
var y = cljs.core.first(arglist__8955);
var more = cljs.core.rest(arglist__8955);
return G__8953__delegate(x,y,more);
});
G__8953.cljs$core$IFn$_invoke$arity$variadic = G__8953__delegate;
return G__8953;
})()
;
unchecked_subtract = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_subtract__1.call(this,x);
case 2:
return unchecked_subtract__2.call(this,x,y);
default:
var G__8956 = null;
if (arguments.length > 2) {
var G__8957__i = 0, G__8957__a = new Array(arguments.length -  2);
while (G__8957__i < G__8957__a.length) {G__8957__a[G__8957__i] = arguments[G__8957__i + 2]; ++G__8957__i;}
G__8956 = new cljs.core.IndexedSeq(G__8957__a,0);
}
return unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_subtract.cljs$lang$maxFixedArity = 2;
unchecked_subtract.cljs$lang$applyTo = unchecked_subtract__3.cljs$lang$applyTo;
unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract__1;
unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract__2;
unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_subtract;
})()
;
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core.unchecked_subtract_int = (function() {
var unchecked_subtract_int = null;
var unchecked_subtract_int__1 = (function (x){
return (- x);
});
var unchecked_subtract_int__2 = (function (x,y){
return (x - y);
});
var unchecked_subtract_int__3 = (function() { 
var G__8958__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(unchecked_subtract_int,(x - y),more);
};
var G__8958 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8959__i = 0, G__8959__a = new Array(arguments.length -  2);
while (G__8959__i < G__8959__a.length) {G__8959__a[G__8959__i] = arguments[G__8959__i + 2]; ++G__8959__i;}
  more = new cljs.core.IndexedSeq(G__8959__a,0);
} 
return G__8958__delegate.call(this,x,y,more);};
G__8958.cljs$lang$maxFixedArity = 2;
G__8958.cljs$lang$applyTo = (function (arglist__8960){
var x = cljs.core.first(arglist__8960);
arglist__8960 = cljs.core.next(arglist__8960);
var y = cljs.core.first(arglist__8960);
var more = cljs.core.rest(arglist__8960);
return G__8958__delegate(x,y,more);
});
G__8958.cljs$core$IFn$_invoke$arity$variadic = G__8958__delegate;
return G__8958;
})()
;
unchecked_subtract_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return unchecked_subtract_int__1.call(this,x);
case 2:
return unchecked_subtract_int__2.call(this,x,y);
default:
var G__8961 = null;
if (arguments.length > 2) {
var G__8962__i = 0, G__8962__a = new Array(arguments.length -  2);
while (G__8962__i < G__8962__a.length) {G__8962__a[G__8962__i] = arguments[G__8962__i + 2]; ++G__8962__i;}
G__8961 = new cljs.core.IndexedSeq(G__8962__a,0);
}
return unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
unchecked_subtract_int.cljs$lang$applyTo = unchecked_subtract_int__3.cljs$lang$applyTo;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = unchecked_subtract_int__1;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = unchecked_subtract_int__2;
unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic;
return unchecked_subtract_int;
})()
;
cljs.core.fix = (function fix(q){
if((q >= (0))){
var G__8965 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__8965) : Math.floor.call(null,G__8965));
} else {
var G__8966 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__8966) : Math.ceil.call(null,G__8966));
}
});
/**
* Coerce to int by stripping decimal places.
*/
cljs.core.int$ = (function int$(x){
return (x | (0));
});
/**
* Coerce to int by stripping decimal places.
*/
cljs.core.unchecked_int = (function unchecked_int(x){
return cljs.core.fix(x);
});
/**
* Coerce to long by stripping decimal places. Identical to `int'.
*/
cljs.core.long$ = (function long$(x){
return cljs.core.fix(x);
});
/**
* Coerce to long by stripping decimal places. Identical to `int'.
*/
cljs.core.unchecked_long = (function unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function booleans(x){
return x;
});
cljs.core.bytes = (function bytes(x){
return x;
});
cljs.core.chars = (function chars(x){
return x;
});
cljs.core.shorts = (function shorts(x){
return x;
});
cljs.core.ints = (function ints(x){
return x;
});
cljs.core.floats = (function floats(x){
return x;
});
cljs.core.doubles = (function doubles(x){
return x;
});
cljs.core.longs = (function longs(x){
return x;
});
/**
* Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
*/
cljs.core.js_mod = (function js_mod(n,d){
return (n % d);
});
/**
* Modulus of num and div. Truncates toward negative infinity.
*/
cljs.core.mod = (function mod(n,d){
return (((n % d) + d) % d);
});
/**
* quot[ient] of dividing numerator by denominator.
*/
cljs.core.quot = (function quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
* remainder of dividing numerator by denominator.
*/
cljs.core.rem = (function rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
* Bitwise exclusive or
* @param {...*} var_args
*/
cljs.core.bit_xor = (function() {
var bit_xor = null;
var bit_xor__2 = (function (x,y){
return (x ^ y);
});
var bit_xor__3 = (function() { 
var G__8967__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_xor,(x ^ y),more);
};
var G__8967 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8968__i = 0, G__8968__a = new Array(arguments.length -  2);
while (G__8968__i < G__8968__a.length) {G__8968__a[G__8968__i] = arguments[G__8968__i + 2]; ++G__8968__i;}
  more = new cljs.core.IndexedSeq(G__8968__a,0);
} 
return G__8967__delegate.call(this,x,y,more);};
G__8967.cljs$lang$maxFixedArity = 2;
G__8967.cljs$lang$applyTo = (function (arglist__8969){
var x = cljs.core.first(arglist__8969);
arglist__8969 = cljs.core.next(arglist__8969);
var y = cljs.core.first(arglist__8969);
var more = cljs.core.rest(arglist__8969);
return G__8967__delegate(x,y,more);
});
G__8967.cljs$core$IFn$_invoke$arity$variadic = G__8967__delegate;
return G__8967;
})()
;
bit_xor = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_xor__2.call(this,x,y);
default:
var G__8970 = null;
if (arguments.length > 2) {
var G__8971__i = 0, G__8971__a = new Array(arguments.length -  2);
while (G__8971__i < G__8971__a.length) {G__8971__a[G__8971__i] = arguments[G__8971__i + 2]; ++G__8971__i;}
G__8970 = new cljs.core.IndexedSeq(G__8971__a,0);
}
return bit_xor__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_xor.cljs$lang$maxFixedArity = 2;
bit_xor.cljs$lang$applyTo = bit_xor__3.cljs$lang$applyTo;
bit_xor.cljs$core$IFn$_invoke$arity$2 = bit_xor__2;
bit_xor.cljs$core$IFn$_invoke$arity$variadic = bit_xor__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_xor;
})()
;
/**
* Bitwise and
* @param {...*} var_args
*/
cljs.core.bit_and = (function() {
var bit_and = null;
var bit_and__2 = (function (x,y){
return (x & y);
});
var bit_and__3 = (function() { 
var G__8972__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_and,(x & y),more);
};
var G__8972 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8973__i = 0, G__8973__a = new Array(arguments.length -  2);
while (G__8973__i < G__8973__a.length) {G__8973__a[G__8973__i] = arguments[G__8973__i + 2]; ++G__8973__i;}
  more = new cljs.core.IndexedSeq(G__8973__a,0);
} 
return G__8972__delegate.call(this,x,y,more);};
G__8972.cljs$lang$maxFixedArity = 2;
G__8972.cljs$lang$applyTo = (function (arglist__8974){
var x = cljs.core.first(arglist__8974);
arglist__8974 = cljs.core.next(arglist__8974);
var y = cljs.core.first(arglist__8974);
var more = cljs.core.rest(arglist__8974);
return G__8972__delegate(x,y,more);
});
G__8972.cljs$core$IFn$_invoke$arity$variadic = G__8972__delegate;
return G__8972;
})()
;
bit_and = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_and__2.call(this,x,y);
default:
var G__8975 = null;
if (arguments.length > 2) {
var G__8976__i = 0, G__8976__a = new Array(arguments.length -  2);
while (G__8976__i < G__8976__a.length) {G__8976__a[G__8976__i] = arguments[G__8976__i + 2]; ++G__8976__i;}
G__8975 = new cljs.core.IndexedSeq(G__8976__a,0);
}
return bit_and__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_and.cljs$lang$maxFixedArity = 2;
bit_and.cljs$lang$applyTo = bit_and__3.cljs$lang$applyTo;
bit_and.cljs$core$IFn$_invoke$arity$2 = bit_and__2;
bit_and.cljs$core$IFn$_invoke$arity$variadic = bit_and__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_and;
})()
;
/**
* Bitwise or
* @param {...*} var_args
*/
cljs.core.bit_or = (function() {
var bit_or = null;
var bit_or__2 = (function (x,y){
return (x | y);
});
var bit_or__3 = (function() { 
var G__8977__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_or,(x | y),more);
};
var G__8977 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8978__i = 0, G__8978__a = new Array(arguments.length -  2);
while (G__8978__i < G__8978__a.length) {G__8978__a[G__8978__i] = arguments[G__8978__i + 2]; ++G__8978__i;}
  more = new cljs.core.IndexedSeq(G__8978__a,0);
} 
return G__8977__delegate.call(this,x,y,more);};
G__8977.cljs$lang$maxFixedArity = 2;
G__8977.cljs$lang$applyTo = (function (arglist__8979){
var x = cljs.core.first(arglist__8979);
arglist__8979 = cljs.core.next(arglist__8979);
var y = cljs.core.first(arglist__8979);
var more = cljs.core.rest(arglist__8979);
return G__8977__delegate(x,y,more);
});
G__8977.cljs$core$IFn$_invoke$arity$variadic = G__8977__delegate;
return G__8977;
})()
;
bit_or = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_or__2.call(this,x,y);
default:
var G__8980 = null;
if (arguments.length > 2) {
var G__8981__i = 0, G__8981__a = new Array(arguments.length -  2);
while (G__8981__i < G__8981__a.length) {G__8981__a[G__8981__i] = arguments[G__8981__i + 2]; ++G__8981__i;}
G__8980 = new cljs.core.IndexedSeq(G__8981__a,0);
}
return bit_or__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_or.cljs$lang$maxFixedArity = 2;
bit_or.cljs$lang$applyTo = bit_or__3.cljs$lang$applyTo;
bit_or.cljs$core$IFn$_invoke$arity$2 = bit_or__2;
bit_or.cljs$core$IFn$_invoke$arity$variadic = bit_or__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_or;
})()
;
/**
* Bitwise and
* @param {...*} var_args
*/
cljs.core.bit_and_not = (function() {
var bit_and_not = null;
var bit_and_not__2 = (function (x,y){
return (x & ~y);
});
var bit_and_not__3 = (function() { 
var G__8982__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(bit_and_not,(x & ~y),more);
};
var G__8982 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8983__i = 0, G__8983__a = new Array(arguments.length -  2);
while (G__8983__i < G__8983__a.length) {G__8983__a[G__8983__i] = arguments[G__8983__i + 2]; ++G__8983__i;}
  more = new cljs.core.IndexedSeq(G__8983__a,0);
} 
return G__8982__delegate.call(this,x,y,more);};
G__8982.cljs$lang$maxFixedArity = 2;
G__8982.cljs$lang$applyTo = (function (arglist__8984){
var x = cljs.core.first(arglist__8984);
arglist__8984 = cljs.core.next(arglist__8984);
var y = cljs.core.first(arglist__8984);
var more = cljs.core.rest(arglist__8984);
return G__8982__delegate(x,y,more);
});
G__8982.cljs$core$IFn$_invoke$arity$variadic = G__8982__delegate;
return G__8982;
})()
;
bit_and_not = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return bit_and_not__2.call(this,x,y);
default:
var G__8985 = null;
if (arguments.length > 2) {
var G__8986__i = 0, G__8986__a = new Array(arguments.length -  2);
while (G__8986__i < G__8986__a.length) {G__8986__a[G__8986__i] = arguments[G__8986__i + 2]; ++G__8986__i;}
G__8985 = new cljs.core.IndexedSeq(G__8986__a,0);
}
return bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bit_and_not.cljs$lang$maxFixedArity = 2;
bit_and_not.cljs$lang$applyTo = bit_and_not__3.cljs$lang$applyTo;
bit_and_not.cljs$core$IFn$_invoke$arity$2 = bit_and_not__2;
bit_and_not.cljs$core$IFn$_invoke$arity$variadic = bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic;
return bit_and_not;
})()
;
/**
* Clear bit at index n
*/
cljs.core.bit_clear = (function bit_clear(x,n){
return (x & ~(1 << n));
});
/**
* Flip bit at index n
*/
cljs.core.bit_flip = (function bit_flip(x,n){
return (x ^ (1 << n));
});
/**
* Bitwise complement
*/
cljs.core.bit_not = (function bit_not(x){
return (~ x);
});
/**
* Set bit at index n
*/
cljs.core.bit_set = (function bit_set(x,n){
return (x | (1 << n));
});
/**
* Test bit at index n
*/
cljs.core.bit_test = (function bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
* Bitwise shift left
*/
cljs.core.bit_shift_left = (function bit_shift_left(x,n){
return (x << n);
});
/**
* Bitwise shift right
*/
cljs.core.bit_shift_right = (function bit_shift_right(x,n){
return (x >> n);
});
/**
* DEPRECATED: Bitwise shift right with zero fill
*/
cljs.core.bit_shift_right_zero_fill = (function bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
* Bitwise shift right with zero fill
*/
cljs.core.unsigned_bit_shift_right = (function unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
* Counts the number of bits set in n
*/
cljs.core.bit_count = (function bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
* Returns non-nil if nums all have the equivalent
* value, otherwise false. Behavior on non nums is
* undefined.
* @param {...*} var_args
*/
cljs.core._EQ__EQ_ = (function() {
var _EQ__EQ_ = null;
var _EQ__EQ___1 = (function (x){
return true;
});
var _EQ__EQ___2 = (function (x,y){
return cljs.core._equiv(x,y);
});
var _EQ__EQ___3 = (function() { 
var G__8991__delegate = function (x,y,more){
while(true){
if(_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__8992 = y;
var G__8993 = cljs.core.first(more);
var G__8994 = cljs.core.next(more);
x = G__8992;
y = G__8993;
more = G__8994;
continue;
} else {
return _EQ__EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__8991 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__8995__i = 0, G__8995__a = new Array(arguments.length -  2);
while (G__8995__i < G__8995__a.length) {G__8995__a[G__8995__i] = arguments[G__8995__i + 2]; ++G__8995__i;}
  more = new cljs.core.IndexedSeq(G__8995__a,0);
} 
return G__8991__delegate.call(this,x,y,more);};
G__8991.cljs$lang$maxFixedArity = 2;
G__8991.cljs$lang$applyTo = (function (arglist__8996){
var x = cljs.core.first(arglist__8996);
arglist__8996 = cljs.core.next(arglist__8996);
var y = cljs.core.first(arglist__8996);
var more = cljs.core.rest(arglist__8996);
return G__8991__delegate(x,y,more);
});
G__8991.cljs$core$IFn$_invoke$arity$variadic = G__8991__delegate;
return G__8991;
})()
;
_EQ__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ__EQ___1.call(this,x);
case 2:
return _EQ__EQ___2.call(this,x,y);
default:
var G__8997 = null;
if (arguments.length > 2) {
var G__8998__i = 0, G__8998__a = new Array(arguments.length -  2);
while (G__8998__i < G__8998__a.length) {G__8998__a[G__8998__i] = arguments[G__8998__i + 2]; ++G__8998__i;}
G__8997 = new cljs.core.IndexedSeq(G__8998__a,0);
}
return _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
_EQ__EQ_.cljs$lang$maxFixedArity = 2;
_EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = _EQ__EQ___1;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = _EQ__EQ___2;
_EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = _EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return _EQ__EQ_;
})()
;
/**
* Returns true if num is greater than zero, else false
*/
cljs.core.pos_QMARK_ = (function pos_QMARK_(n){
return (n > (0));
});
cljs.core.zero_QMARK_ = (function zero_QMARK_(n){
return (n === (0));
});
/**
* Returns true if num is less than zero, else false
*/
cljs.core.neg_QMARK_ = (function neg_QMARK_(x){
return (x < (0));
});
/**
* Returns the nth next of coll, (seq coll) when n is 0.
*/
cljs.core.nthnext = (function nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__8999 = (n__$1 - (1));
var G__9000 = cljs.core.next(xs);
n__$1 = G__8999;
xs = G__9000;
continue;
} else {
return xs;
}
break;
}
});
/**
* With no args, returns the empty string. With one arg x, returns
* x.toString().  (str nil) returns the empty string. With more than
* one arg, returns the concatenation of the str values of the args.
* @param {...*} var_args
*/
cljs.core.str = (function() {
var str = null;
var str__0 = (function (){
return "";
});
var str__1 = (function (x){
if((x == null)){
return "";
} else {
var G__9004 = x;
return goog.string.buildString(G__9004);
}
});
var str__2 = (function() { 
var G__9005__delegate = function (x,ys){
var sb = (new goog.string.StringBuffer(str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__9006 = sb.append(str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__9007 = cljs.core.next(more);
sb = G__9006;
more = G__9007;
continue;
} else {
return sb.toString();
}
break;
}
};
var G__9005 = function (x,var_args){
var ys = null;
if (arguments.length > 1) {
var G__9008__i = 0, G__9008__a = new Array(arguments.length -  1);
while (G__9008__i < G__9008__a.length) {G__9008__a[G__9008__i] = arguments[G__9008__i + 1]; ++G__9008__i;}
  ys = new cljs.core.IndexedSeq(G__9008__a,0);
} 
return G__9005__delegate.call(this,x,ys);};
G__9005.cljs$lang$maxFixedArity = 1;
G__9005.cljs$lang$applyTo = (function (arglist__9009){
var x = cljs.core.first(arglist__9009);
var ys = cljs.core.rest(arglist__9009);
return G__9005__delegate(x,ys);
});
G__9005.cljs$core$IFn$_invoke$arity$variadic = G__9005__delegate;
return G__9005;
})()
;
str = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return str__0.call(this);
case 1:
return str__1.call(this,x);
default:
var G__9010 = null;
if (arguments.length > 1) {
var G__9011__i = 0, G__9011__a = new Array(arguments.length -  1);
while (G__9011__i < G__9011__a.length) {G__9011__a[G__9011__i] = arguments[G__9011__i + 1]; ++G__9011__i;}
G__9010 = new cljs.core.IndexedSeq(G__9011__a,0);
}
return str__2.cljs$core$IFn$_invoke$arity$variadic(x, G__9010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
str.cljs$lang$maxFixedArity = 1;
str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
str.cljs$core$IFn$_invoke$arity$0 = str__0;
str.cljs$core$IFn$_invoke$arity$1 = str__1;
str.cljs$core$IFn$_invoke$arity$variadic = str__2.cljs$core$IFn$_invoke$arity$variadic;
return str;
})()
;
/**
* Returns the substring of s beginning at start inclusive, and ending
* at end (defaults to length of string), exclusive.
*/
cljs.core.subs = (function() {
var subs = null;
var subs__2 = (function (s,start){
return s.substring(start);
});
var subs__3 = (function (s,start,end){
return s.substring(start,end);
});
subs = function(s,start,end){
switch(arguments.length){
case 2:
return subs__2.call(this,s,start);
case 3:
return subs__3.call(this,s,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subs.cljs$core$IFn$_invoke$arity$2 = subs__2;
subs.cljs$core$IFn$_invoke$arity$3 = subs__3;
return subs;
})()
;

/**
* Assumes x is sequential. Returns true if x equals y, otherwise
* returns false.
*/
cljs.core.equiv_sequential = (function equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__9012 = cljs.core.next(xs);
var G__9013 = cljs.core.next(ys);
xs = G__9012;
ys = G__9013;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__9014 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__9015 = cljs.core.next(s);
res = G__9014;
s = G__9015;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__9020 = ((h + (cljs.core.hash((function (){var G__9018 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9018) : cljs.core.key.call(null,G__9018));
})()) ^ cljs.core.hash((function (){var G__9019 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9019) : cljs.core.val.call(null,G__9019));
})()))) % (4503599627370496));
var G__9021 = cljs.core.next(s);
h = G__9020;
s = G__9021;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__9022 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__9023 = cljs.core.next(s__$1);
h = G__9022;
s__$1 = G__9023;
continue;
} else {
return h;
}
break;
}
});


/**
* Takes a JavaScript object and a map of names to functions and
* attaches said functions as methods on the object.  Any references to
* JavaScript's implicit this (via the this-as macro) will resolve to the
* object that the function is attached.
*/
cljs.core.extend_object_BANG_ = (function extend_object_BANG_(obj,fn_map){
var seq__9034_9044 = cljs.core.seq(fn_map);
var chunk__9035_9045 = null;
var count__9036_9046 = (0);
var i__9037_9047 = (0);
while(true){
if((i__9037_9047 < count__9036_9046)){
var vec__9038_9048 = chunk__9035_9045.cljs$core$IIndexed$_nth$arity$2(null,i__9037_9047);
var key_name_9049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9038_9048,(0),null);
var f_9050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9038_9048,(1),null);
var str_name_9051 = (function (){var G__9039 = key_name_9049;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__9039) : cljs.core.name.call(null,G__9039));
})();
(obj[str_name_9051] = f_9050);

var G__9052 = seq__9034_9044;
var G__9053 = chunk__9035_9045;
var G__9054 = count__9036_9046;
var G__9055 = (i__9037_9047 + (1));
seq__9034_9044 = G__9052;
chunk__9035_9045 = G__9053;
count__9036_9046 = G__9054;
i__9037_9047 = G__9055;
continue;
} else {
var temp__4126__auto___9056 = cljs.core.seq(seq__9034_9044);
if(temp__4126__auto___9056){
var seq__9034_9057__$1 = temp__4126__auto___9056;
if(cljs.core.chunked_seq_QMARK_(seq__9034_9057__$1)){
var c__4545__auto___9058 = (function (){var G__9040 = seq__9034_9057__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__9040) : cljs.core.chunk_first.call(null,G__9040));
})();
var G__9059 = (function (){var G__9041 = seq__9034_9057__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__9041) : cljs.core.chunk_rest.call(null,G__9041));
})();
var G__9060 = c__4545__auto___9058;
var G__9061 = cljs.core.count(c__4545__auto___9058);
var G__9062 = (0);
seq__9034_9044 = G__9059;
chunk__9035_9045 = G__9060;
count__9036_9046 = G__9061;
i__9037_9047 = G__9062;
continue;
} else {
var vec__9042_9063 = cljs.core.first(seq__9034_9057__$1);
var key_name_9064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9042_9063,(0),null);
var f_9065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9042_9063,(1),null);
var str_name_9066 = (function (){var G__9043 = key_name_9064;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__9043) : cljs.core.name.call(null,G__9043));
})();
(obj[str_name_9066] = f_9065);

var G__9067 = cljs.core.next(seq__9034_9057__$1);
var G__9068 = null;
var G__9069 = (0);
var G__9070 = (0);
seq__9034_9044 = G__9067;
chunk__9035_9045 = G__9068;
count__9036_9046 = G__9069;
i__9037_9047 = G__9070;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function __GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function __GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.reversible_QMARK_ = (function reversible_QMARK_(coll){
var G__9072 = coll;
if(G__9072){
var bit__4439__auto__ = (G__9072.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4439__auto__) || (G__9072.cljs$core$IReversible$)){
return true;
} else {
if((!G__9072.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__9072);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__9072);
}
});
cljs.core.rseq = (function rseq(coll){
return cljs.core._rseq(coll);
});
/**
* Returns a seq of the items in coll in reverse order. Not lazy.
*/
cljs.core.reverse = (function reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
* @param {...*} var_args
*/
cljs.core.list = (function() { 
var list__delegate = function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__9073 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__9073;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__9074 = (i - (1));
var G__9075 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__9074;
r = G__9075;
continue;
} else {
return r;
}
break;
}
};
var list = function (var_args){
var xs = null;
if (arguments.length > 0) {
var G__9076__i = 0, G__9076__a = new Array(arguments.length -  0);
while (G__9076__i < G__9076__a.length) {G__9076__a[G__9076__i] = arguments[G__9076__i + 0]; ++G__9076__i;}
  xs = new cljs.core.IndexedSeq(G__9076__a,0);
} 
return list__delegate.call(this,xs);};
list.cljs$lang$maxFixedArity = 0;
list.cljs$lang$applyTo = (function (arglist__9077){
var xs = cljs.core.seq(arglist__9077);
return list__delegate(xs);
});
list.cljs$core$IFn$_invoke$arity$variadic = list__delegate;
return list;
})()
;

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function __GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a new seq where x is the first element and seq is the rest.
*/
cljs.core.cons = (function cons(x,coll){
if((function (){var or__3758__auto__ = (coll == null);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var G__9081 = coll;
if(G__9081){
var bit__4432__auto__ = (G__9081.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4432__auto__) || (G__9081.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.list_QMARK_ = (function list_QMARK_(x){
var G__9083 = x;
if(G__9083){
var bit__4439__auto__ = (G__9083.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4439__auto__) || (G__9083.cljs$core$IList$)){
return true;
} else {
if((!G__9083.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__9083);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__9083);
}
});
cljs.core.hash_keyword = (function hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3746__auto__ = cljs.core.not(a.ns);
if(and__3746__auto__){
return b.ns;
} else {
return and__3746__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__9090 = a.ns;
var G__9091 = b.ns;
return goog.array.defaultCompare(G__9090,G__9091);
})();
if(((0) === nsc)){
var G__9092 = a.name;
var G__9093 = b.name;
return goog.array.defaultCompare(G__9092,G__9093);
} else {
return nsc;
}
}
} else {
var G__9094 = a.name;
var G__9095 = b.name;
return goog.array.defaultCompare(G__9094,G__9095);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4179__auto__ = self__._hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__9097 = null;
var G__9097__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__9097__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__9097 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__9097__2.call(this,self__,coll);
case 3:
return G__9097__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9097.cljs$core$IFn$_invoke$arity$2 = G__9097__2;
G__9097.cljs$core$IFn$_invoke$arity$3 = G__9097__3;
return G__9097;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args9096){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9096)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function __GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

cljs.core.keyword_QMARK_ = (function keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
cljs.core.keyword_identical_QMARK_ = (function keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
* Returns the namespace String of a symbol or keyword, or nil if not present.
*/
cljs.core.namespace = (function namespace(x){
if((function (){var G__9099 = x;
if(G__9099){
var bit__4432__auto__ = (G__9099.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4432__auto__) || (G__9099.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
* Returns a Keyword with the given namespace and name.  Do not use :
* in the keyword strings, it will be added automatically.
*/
cljs.core.keyword = (function() {
var keyword = null;
var keyword__1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__9101 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__9101) : cljs.core.name.call(null,G__9101));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});
var keyword__2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});
keyword = function(ns,name){
switch(arguments.length){
case 1:
return keyword__1.call(this,ns);
case 2:
return keyword__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keyword.cljs$core$IFn$_invoke$arity$1 = keyword__1;
keyword.cljs$core$IFn$_invoke$arity$2 = keyword__2;
return keyword;
})()
;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__9102 = ls.sval();
ls = G__9102;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function __GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function __GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function __GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function() {
var array_chunk = null;
var array_chunk__1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});
var array_chunk__2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});
var array_chunk__3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});
array_chunk = function(arr,off,end){
switch(arguments.length){
case 1:
return array_chunk__1.call(this,arr);
case 2:
return array_chunk__2.call(this,arr,off);
case 3:
return array_chunk__3.call(this,arr,off,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
array_chunk.cljs$core$IFn$_invoke$arity$1 = array_chunk__1;
array_chunk.cljs$core$IFn$_invoke$arity$2 = array_chunk__2;
array_chunk.cljs$core$IFn$_invoke$arity$3 = array_chunk__3;
return array_chunk;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function __GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.chunk_cons = (function chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function chunk_next(s){
if((function (){var G__9104 = s;
if(G__9104){
var bit__4432__auto__ = (G__9104.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4432__auto__) || (G__9104.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
* Naive impl of to-array as a start.
*/
cljs.core.to_array = (function to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__9105 = cljs.core.next(s__$1);
s__$1 = G__9105;
continue;
} else {
return ary;
}
break;
}
});
/**
* Returns a (potentially-ragged) 2-dimensional array
* containing the contents of coll.
*/
cljs.core.to_array_2d = (function to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_9106 = (0);
var xs_9107 = cljs.core.seq(coll);
while(true){
if(xs_9107){
(ret[i_9106] = cljs.core.to_array(cljs.core.first(xs_9107)));

var G__9108 = (i_9106 + (1));
var G__9109 = cljs.core.next(xs_9107);
i_9106 = G__9108;
xs_9107 = G__9109;
continue;
} else {
}
break;
}

return ret;
});
cljs.core.int_array = (function() {
var int_array = null;
var int_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var int_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9112 = (i + (1));
var G__9113 = cljs.core.next(s__$1);
i = G__9112;
s__$1 = G__9113;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9114 = size;
var i_9115 = (0);
while(true){
if((i_9115 < n__4645__auto___9114)){
(a[i_9115] = init_val_or_seq);

var G__9116 = (i_9115 + (1));
i_9115 = G__9116;
continue;
} else {
}
break;
}

return a;
}
});
int_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return int_array__1.call(this,size);
case 2:
return int_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
int_array.cljs$core$IFn$_invoke$arity$1 = int_array__1;
int_array.cljs$core$IFn$_invoke$arity$2 = int_array__2;
return int_array;
})()
;
cljs.core.long_array = (function() {
var long_array = null;
var long_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var long_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9119 = (i + (1));
var G__9120 = cljs.core.next(s__$1);
i = G__9119;
s__$1 = G__9120;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9121 = size;
var i_9122 = (0);
while(true){
if((i_9122 < n__4645__auto___9121)){
(a[i_9122] = init_val_or_seq);

var G__9123 = (i_9122 + (1));
i_9122 = G__9123;
continue;
} else {
}
break;
}

return a;
}
});
long_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return long_array__1.call(this,size);
case 2:
return long_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
long_array.cljs$core$IFn$_invoke$arity$1 = long_array__1;
long_array.cljs$core$IFn$_invoke$arity$2 = long_array__2;
return long_array;
})()
;
cljs.core.double_array = (function() {
var double_array = null;
var double_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var double_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9126 = (i + (1));
var G__9127 = cljs.core.next(s__$1);
i = G__9126;
s__$1 = G__9127;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9128 = size;
var i_9129 = (0);
while(true){
if((i_9129 < n__4645__auto___9128)){
(a[i_9129] = init_val_or_seq);

var G__9130 = (i_9129 + (1));
i_9129 = G__9130;
continue;
} else {
}
break;
}

return a;
}
});
double_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return double_array__1.call(this,size);
case 2:
return double_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
double_array.cljs$core$IFn$_invoke$arity$1 = double_array__1;
double_array.cljs$core$IFn$_invoke$arity$2 = double_array__2;
return double_array;
})()
;
cljs.core.object_array = (function() {
var object_array = null;
var object_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var object_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__9133 = (i + (1));
var G__9134 = cljs.core.next(s__$1);
i = G__9133;
s__$1 = G__9134;
continue;
} else {
return a;
}
break;
}
} else {
var n__4645__auto___9135 = size;
var i_9136 = (0);
while(true){
if((i_9136 < n__4645__auto___9135)){
(a[i_9136] = init_val_or_seq);

var G__9137 = (i_9136 + (1));
i_9136 = G__9137;
continue;
} else {
}
break;
}

return a;
}
});
object_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return object_array__1.call(this,size);
case 2:
return object_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
object_array.cljs$core$IFn$_invoke$arity$1 = object_array__1;
object_array.cljs$core$IFn$_invoke$arity$2 = object_array__2;
return object_array;
})()
;
cljs.core.bounded_count = (function bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__9138 = cljs.core.next(s__$1);
var G__9139 = (i - (1));
var G__9140 = (sum + (1));
s__$1 = G__9138;
i = G__9139;
sum = G__9140;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),spread(cljs.core.next(arglist)));

}
}
});
/**
* Returns a lazy seq representing the concatenation of the elements in the supplied colls.
* @param {...*} var_args
*/
cljs.core.concat = (function() {
var concat = null;
var concat__0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});
var concat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});
var concat__2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});
var concat__3 = (function() { 
var G__9160__delegate = function (x,y,zs){
var cat = (function cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
};
var G__9160 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__9161__i = 0, G__9161__a = new Array(arguments.length -  2);
while (G__9161__i < G__9161__a.length) {G__9161__a[G__9161__i] = arguments[G__9161__i + 2]; ++G__9161__i;}
  zs = new cljs.core.IndexedSeq(G__9161__a,0);
} 
return G__9160__delegate.call(this,x,y,zs);};
G__9160.cljs$lang$maxFixedArity = 2;
G__9160.cljs$lang$applyTo = (function (arglist__9162){
var x = cljs.core.first(arglist__9162);
arglist__9162 = cljs.core.next(arglist__9162);
var y = cljs.core.first(arglist__9162);
var zs = cljs.core.rest(arglist__9162);
return G__9160__delegate(x,y,zs);
});
G__9160.cljs$core$IFn$_invoke$arity$variadic = G__9160__delegate;
return G__9160;
})()
;
concat = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return concat__0.call(this);
case 1:
return concat__1.call(this,x);
case 2:
return concat__2.call(this,x,y);
default:
var G__9163 = null;
if (arguments.length > 2) {
var G__9164__i = 0, G__9164__a = new Array(arguments.length -  2);
while (G__9164__i < G__9164__a.length) {G__9164__a[G__9164__i] = arguments[G__9164__i + 2]; ++G__9164__i;}
G__9163 = new cljs.core.IndexedSeq(G__9164__a,0);
}
return concat__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__9163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
concat.cljs$lang$maxFixedArity = 2;
concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
concat.cljs$core$IFn$_invoke$arity$0 = concat__0;
concat.cljs$core$IFn$_invoke$arity$1 = concat__1;
concat.cljs$core$IFn$_invoke$arity$2 = concat__2;
concat.cljs$core$IFn$_invoke$arity$variadic = concat__3.cljs$core$IFn$_invoke$arity$variadic;
return concat;
})()
;
/**
* Creates a new list containing the items prepended to the rest, the
* last of which will be treated as a sequence.
* @param {...*} var_args
*/
cljs.core.list_STAR_ = (function() {
var list_STAR_ = null;
var list_STAR___1 = (function (args){
return cljs.core.seq(args);
});
var list_STAR___2 = (function (a,args){
return cljs.core.cons(a,args);
});
var list_STAR___3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});
var list_STAR___4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});
var list_STAR___5 = (function() { 
var G__9165__delegate = function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
};
var G__9165 = function (a,b,c,d,var_args){
var more = null;
if (arguments.length > 4) {
var G__9166__i = 0, G__9166__a = new Array(arguments.length -  4);
while (G__9166__i < G__9166__a.length) {G__9166__a[G__9166__i] = arguments[G__9166__i + 4]; ++G__9166__i;}
  more = new cljs.core.IndexedSeq(G__9166__a,0);
} 
return G__9165__delegate.call(this,a,b,c,d,more);};
G__9165.cljs$lang$maxFixedArity = 4;
G__9165.cljs$lang$applyTo = (function (arglist__9167){
var a = cljs.core.first(arglist__9167);
arglist__9167 = cljs.core.next(arglist__9167);
var b = cljs.core.first(arglist__9167);
arglist__9167 = cljs.core.next(arglist__9167);
var c = cljs.core.first(arglist__9167);
arglist__9167 = cljs.core.next(arglist__9167);
var d = cljs.core.first(arglist__9167);
var more = cljs.core.rest(arglist__9167);
return G__9165__delegate(a,b,c,d,more);
});
G__9165.cljs$core$IFn$_invoke$arity$variadic = G__9165__delegate;
return G__9165;
})()
;
list_STAR_ = function(a,b,c,d,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return list_STAR___1.call(this,a);
case 2:
return list_STAR___2.call(this,a,b);
case 3:
return list_STAR___3.call(this,a,b,c);
case 4:
return list_STAR___4.call(this,a,b,c,d);
default:
var G__9168 = null;
if (arguments.length > 4) {
var G__9169__i = 0, G__9169__a = new Array(arguments.length -  4);
while (G__9169__i < G__9169__a.length) {G__9169__a[G__9169__i] = arguments[G__9169__i + 4]; ++G__9169__i;}
G__9168 = new cljs.core.IndexedSeq(G__9169__a,0);
}
return list_STAR___5.cljs$core$IFn$_invoke$arity$variadic(a,b,c,d, G__9168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
list_STAR_.cljs$lang$maxFixedArity = 4;
list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
list_STAR_.cljs$core$IFn$_invoke$arity$1 = list_STAR___1;
list_STAR_.cljs$core$IFn$_invoke$arity$2 = list_STAR___2;
list_STAR_.cljs$core$IFn$_invoke$arity$3 = list_STAR___3;
list_STAR_.cljs$core$IFn$_invoke$arity$4 = list_STAR___4;
list_STAR_.cljs$core$IFn$_invoke$arity$variadic = list_STAR___5.cljs$core$IFn$_invoke$arity$variadic;
return list_STAR_;
})()
;
/**
* Returns a new, transient version of the collection, in constant time.
*/
cljs.core.transient$ = (function transient$(coll){
return cljs.core._as_transient(coll);
});
/**
* Returns a new, persistent version of the transient collection, in
* constant time. The transient collection cannot be used after this
* call, any such use will throw an exception.
*/
cljs.core.persistent_BANG_ = (function persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
* Adds x to the transient collection, and return coll. The 'addition'
* may happen at different 'places' depending on the concrete type.
* @param {...*} var_args
*/
cljs.core.conj_BANG_ = (function() {
var conj_BANG_ = null;
var conj_BANG___0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});
var conj_BANG___1 = (function (coll){
return coll;
});
var conj_BANG___2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});
var conj_BANG___3 = (function() { 
var G__9170__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__9171 = ntcoll;
var G__9172 = cljs.core.first(vals);
var G__9173 = cljs.core.next(vals);
tcoll = G__9171;
val = G__9172;
vals = G__9173;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9170 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__9174__i = 0, G__9174__a = new Array(arguments.length -  2);
while (G__9174__i < G__9174__a.length) {G__9174__a[G__9174__i] = arguments[G__9174__i + 2]; ++G__9174__i;}
  vals = new cljs.core.IndexedSeq(G__9174__a,0);
} 
return G__9170__delegate.call(this,tcoll,val,vals);};
G__9170.cljs$lang$maxFixedArity = 2;
G__9170.cljs$lang$applyTo = (function (arglist__9175){
var tcoll = cljs.core.first(arglist__9175);
arglist__9175 = cljs.core.next(arglist__9175);
var val = cljs.core.first(arglist__9175);
var vals = cljs.core.rest(arglist__9175);
return G__9170__delegate(tcoll,val,vals);
});
G__9170.cljs$core$IFn$_invoke$arity$variadic = G__9170__delegate;
return G__9170;
})()
;
conj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 0:
return conj_BANG___0.call(this);
case 1:
return conj_BANG___1.call(this,tcoll);
case 2:
return conj_BANG___2.call(this,tcoll,val);
default:
var G__9176 = null;
if (arguments.length > 2) {
var G__9177__i = 0, G__9177__a = new Array(arguments.length -  2);
while (G__9177__i < G__9177__a.length) {G__9177__a[G__9177__i] = arguments[G__9177__i + 2]; ++G__9177__i;}
G__9176 = new cljs.core.IndexedSeq(G__9177__a,0);
}
return conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__9176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
conj_BANG_.cljs$lang$maxFixedArity = 2;
conj_BANG_.cljs$lang$applyTo = conj_BANG___3.cljs$lang$applyTo;
conj_BANG_.cljs$core$IFn$_invoke$arity$0 = conj_BANG___0;
conj_BANG_.cljs$core$IFn$_invoke$arity$1 = conj_BANG___1;
conj_BANG_.cljs$core$IFn$_invoke$arity$2 = conj_BANG___2;
conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return conj_BANG_;
})()
;
/**
* When applied to a transient map, adds mapping of key(s) to
* val(s). When applied to a transient vector, sets the val at index.
* Note - index must be <= (count vector). Returns coll.
* @param {...*} var_args
*/
cljs.core.assoc_BANG_ = (function() {
var assoc_BANG_ = null;
var assoc_BANG___3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});
var assoc_BANG___4 = (function() { 
var G__9178__delegate = function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__9179 = ntcoll;
var G__9180 = cljs.core.first(kvs);
var G__9181 = cljs.core.second(kvs);
var G__9182 = cljs.core.nnext(kvs);
tcoll = G__9179;
key = G__9180;
val = G__9181;
kvs = G__9182;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9178 = function (tcoll,key,val,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__9183__i = 0, G__9183__a = new Array(arguments.length -  3);
while (G__9183__i < G__9183__a.length) {G__9183__a[G__9183__i] = arguments[G__9183__i + 3]; ++G__9183__i;}
  kvs = new cljs.core.IndexedSeq(G__9183__a,0);
} 
return G__9178__delegate.call(this,tcoll,key,val,kvs);};
G__9178.cljs$lang$maxFixedArity = 3;
G__9178.cljs$lang$applyTo = (function (arglist__9184){
var tcoll = cljs.core.first(arglist__9184);
arglist__9184 = cljs.core.next(arglist__9184);
var key = cljs.core.first(arglist__9184);
arglist__9184 = cljs.core.next(arglist__9184);
var val = cljs.core.first(arglist__9184);
var kvs = cljs.core.rest(arglist__9184);
return G__9178__delegate(tcoll,key,val,kvs);
});
G__9178.cljs$core$IFn$_invoke$arity$variadic = G__9178__delegate;
return G__9178;
})()
;
assoc_BANG_ = function(tcoll,key,val,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return assoc_BANG___3.call(this,tcoll,key,val);
default:
var G__9185 = null;
if (arguments.length > 3) {
var G__9186__i = 0, G__9186__a = new Array(arguments.length -  3);
while (G__9186__i < G__9186__a.length) {G__9186__a[G__9186__i] = arguments[G__9186__i + 3]; ++G__9186__i;}
G__9185 = new cljs.core.IndexedSeq(G__9186__a,0);
}
return assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic(tcoll,key,val, G__9185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
assoc_BANG_.cljs$lang$maxFixedArity = 3;
assoc_BANG_.cljs$lang$applyTo = assoc_BANG___4.cljs$lang$applyTo;
assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = assoc_BANG___3;
assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return assoc_BANG_;
})()
;
/**
* Returns a transient map that doesn't contain a mapping for key(s).
* @param {...*} var_args
*/
cljs.core.dissoc_BANG_ = (function() {
var dissoc_BANG_ = null;
var dissoc_BANG___2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});
var dissoc_BANG___3 = (function() { 
var G__9187__delegate = function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__9188 = ntcoll;
var G__9189 = cljs.core.first(ks);
var G__9190 = cljs.core.next(ks);
tcoll = G__9188;
key = G__9189;
ks = G__9190;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9187 = function (tcoll,key,var_args){
var ks = null;
if (arguments.length > 2) {
var G__9191__i = 0, G__9191__a = new Array(arguments.length -  2);
while (G__9191__i < G__9191__a.length) {G__9191__a[G__9191__i] = arguments[G__9191__i + 2]; ++G__9191__i;}
  ks = new cljs.core.IndexedSeq(G__9191__a,0);
} 
return G__9187__delegate.call(this,tcoll,key,ks);};
G__9187.cljs$lang$maxFixedArity = 2;
G__9187.cljs$lang$applyTo = (function (arglist__9192){
var tcoll = cljs.core.first(arglist__9192);
arglist__9192 = cljs.core.next(arglist__9192);
var key = cljs.core.first(arglist__9192);
var ks = cljs.core.rest(arglist__9192);
return G__9187__delegate(tcoll,key,ks);
});
G__9187.cljs$core$IFn$_invoke$arity$variadic = G__9187__delegate;
return G__9187;
})()
;
dissoc_BANG_ = function(tcoll,key,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return dissoc_BANG___2.call(this,tcoll,key);
default:
var G__9193 = null;
if (arguments.length > 2) {
var G__9194__i = 0, G__9194__a = new Array(arguments.length -  2);
while (G__9194__i < G__9194__a.length) {G__9194__a[G__9194__i] = arguments[G__9194__i + 2]; ++G__9194__i;}
G__9193 = new cljs.core.IndexedSeq(G__9194__a,0);
}
return dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,key, G__9193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dissoc_BANG_.cljs$lang$maxFixedArity = 2;
dissoc_BANG_.cljs$lang$applyTo = dissoc_BANG___3.cljs$lang$applyTo;
dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = dissoc_BANG___2;
dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return dissoc_BANG_;
})()
;
/**
* Removes the last item from a transient vector. If
* the collection is empty, throws an exception. Returns coll
*/
cljs.core.pop_BANG_ = (function pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
* disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
* does not contain key(s).
* @param {...*} var_args
*/
cljs.core.disj_BANG_ = (function() {
var disj_BANG_ = null;
var disj_BANG___2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});
var disj_BANG___3 = (function() { 
var G__9195__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__9196 = ntcoll;
var G__9197 = cljs.core.first(vals);
var G__9198 = cljs.core.next(vals);
tcoll = G__9196;
val = G__9197;
vals = G__9198;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__9195 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__9199__i = 0, G__9199__a = new Array(arguments.length -  2);
while (G__9199__i < G__9199__a.length) {G__9199__a[G__9199__i] = arguments[G__9199__i + 2]; ++G__9199__i;}
  vals = new cljs.core.IndexedSeq(G__9199__a,0);
} 
return G__9195__delegate.call(this,tcoll,val,vals);};
G__9195.cljs$lang$maxFixedArity = 2;
G__9195.cljs$lang$applyTo = (function (arglist__9200){
var tcoll = cljs.core.first(arglist__9200);
arglist__9200 = cljs.core.next(arglist__9200);
var val = cljs.core.first(arglist__9200);
var vals = cljs.core.rest(arglist__9200);
return G__9195__delegate(tcoll,val,vals);
});
G__9195.cljs$core$IFn$_invoke$arity$variadic = G__9195__delegate;
return G__9195;
})()
;
disj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 2:
return disj_BANG___2.call(this,tcoll,val);
default:
var G__9201 = null;
if (arguments.length > 2) {
var G__9202__i = 0, G__9202__a = new Array(arguments.length -  2);
while (G__9202__i < G__9202__a.length) {G__9202__a[G__9202__i] = arguments[G__9202__i + 2]; ++G__9202__i;}
G__9201 = new cljs.core.IndexedSeq(G__9202__a,0);
}
return disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__9201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
disj_BANG_.cljs$lang$maxFixedArity = 2;
disj_BANG_.cljs$lang$applyTo = disj_BANG___3.cljs$lang$applyTo;
disj_BANG_.cljs$core$IFn$_invoke$arity$2 = disj_BANG___2;
disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return disj_BANG_;
})()
;

cljs.core.apply_to = (function apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a4689 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a4689);
} else {
var G__9413 = a4689;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9413) : f.call(null,G__9413));
}
} else {
var b4690 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a4689,b4690);
} else {
var G__9414 = a4689;
var G__9415 = b4690;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9414,G__9415) : f.call(null,G__9414,G__9415));
}
} else {
var c4691 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a4689,b4690,c4691);
} else {
var G__9416 = a4689;
var G__9417 = b4690;
var G__9418 = c4691;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9416,G__9417,G__9418) : f.call(null,G__9416,G__9417,G__9418));
}
} else {
var d4692 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a4689,b4690,c4691,d4692);
} else {
var G__9419 = a4689;
var G__9420 = b4690;
var G__9421 = c4691;
var G__9422 = d4692;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9419,G__9420,G__9421,G__9422) : f.call(null,G__9419,G__9420,G__9421,G__9422));
}
} else {
var e4693 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a4689,b4690,c4691,d4692,e4693);
} else {
var G__9423 = a4689;
var G__9424 = b4690;
var G__9425 = c4691;
var G__9426 = d4692;
var G__9427 = e4693;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9423,G__9424,G__9425,G__9426,G__9427) : f.call(null,G__9423,G__9424,G__9425,G__9426,G__9427));
}
} else {
var f4694 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a4689,b4690,c4691,d4692,e4693,f4694);
} else {
var G__9428 = a4689;
var G__9429 = b4690;
var G__9430 = c4691;
var G__9431 = d4692;
var G__9432 = e4693;
var G__9433 = f4694;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__9428,G__9429,G__9430,G__9431,G__9432,G__9433) : f.call(null,G__9428,G__9429,G__9430,G__9431,G__9432,G__9433));
}
} else {
var g4695 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a4689,b4690,c4691,d4692,e4693,f4694,g4695);
} else {
var G__9434 = a4689;
var G__9435 = b4690;
var G__9436 = c4691;
var G__9437 = d4692;
var G__9438 = e4693;
var G__9439 = f4694;
var G__9440 = g4695;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__9434,G__9435,G__9436,G__9437,G__9438,G__9439,G__9440) : f.call(null,G__9434,G__9435,G__9436,G__9437,G__9438,G__9439,G__9440));
}
} else {
var h4696 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696);
} else {
var G__9441 = a4689;
var G__9442 = b4690;
var G__9443 = c4691;
var G__9444 = d4692;
var G__9445 = e4693;
var G__9446 = f4694;
var G__9447 = g4695;
var G__9448 = h4696;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__9441,G__9442,G__9443,G__9444,G__9445,G__9446,G__9447,G__9448) : f.call(null,G__9441,G__9442,G__9443,G__9444,G__9445,G__9446,G__9447,G__9448));
}
} else {
var i4697 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697);
} else {
var G__9449 = a4689;
var G__9450 = b4690;
var G__9451 = c4691;
var G__9452 = d4692;
var G__9453 = e4693;
var G__9454 = f4694;
var G__9455 = g4695;
var G__9456 = h4696;
var G__9457 = i4697;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__9449,G__9450,G__9451,G__9452,G__9453,G__9454,G__9455,G__9456,G__9457) : f.call(null,G__9449,G__9450,G__9451,G__9452,G__9453,G__9454,G__9455,G__9456,G__9457));
}
} else {
var j4698 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698);
} else {
var G__9458 = a4689;
var G__9459 = b4690;
var G__9460 = c4691;
var G__9461 = d4692;
var G__9462 = e4693;
var G__9463 = f4694;
var G__9464 = g4695;
var G__9465 = h4696;
var G__9466 = i4697;
var G__9467 = j4698;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__9458,G__9459,G__9460,G__9461,G__9462,G__9463,G__9464,G__9465,G__9466,G__9467) : f.call(null,G__9458,G__9459,G__9460,G__9461,G__9462,G__9463,G__9464,G__9465,G__9466,G__9467));
}
} else {
var k4699 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699);
} else {
var G__9468 = a4689;
var G__9469 = b4690;
var G__9470 = c4691;
var G__9471 = d4692;
var G__9472 = e4693;
var G__9473 = f4694;
var G__9474 = g4695;
var G__9475 = h4696;
var G__9476 = i4697;
var G__9477 = j4698;
var G__9478 = k4699;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__9468,G__9469,G__9470,G__9471,G__9472,G__9473,G__9474,G__9475,G__9476,G__9477,G__9478) : f.call(null,G__9468,G__9469,G__9470,G__9471,G__9472,G__9473,G__9474,G__9475,G__9476,G__9477,G__9478));
}
} else {
var l4700 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700);
} else {
var G__9479 = a4689;
var G__9480 = b4690;
var G__9481 = c4691;
var G__9482 = d4692;
var G__9483 = e4693;
var G__9484 = f4694;
var G__9485 = g4695;
var G__9486 = h4696;
var G__9487 = i4697;
var G__9488 = j4698;
var G__9489 = k4699;
var G__9490 = l4700;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__9479,G__9480,G__9481,G__9482,G__9483,G__9484,G__9485,G__9486,G__9487,G__9488,G__9489,G__9490) : f.call(null,G__9479,G__9480,G__9481,G__9482,G__9483,G__9484,G__9485,G__9486,G__9487,G__9488,G__9489,G__9490));
}
} else {
var m4701 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701);
} else {
var G__9491 = a4689;
var G__9492 = b4690;
var G__9493 = c4691;
var G__9494 = d4692;
var G__9495 = e4693;
var G__9496 = f4694;
var G__9497 = g4695;
var G__9498 = h4696;
var G__9499 = i4697;
var G__9500 = j4698;
var G__9501 = k4699;
var G__9502 = l4700;
var G__9503 = m4701;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__9491,G__9492,G__9493,G__9494,G__9495,G__9496,G__9497,G__9498,G__9499,G__9500,G__9501,G__9502,G__9503) : f.call(null,G__9491,G__9492,G__9493,G__9494,G__9495,G__9496,G__9497,G__9498,G__9499,G__9500,G__9501,G__9502,G__9503));
}
} else {
var n4702 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702);
} else {
var G__9504 = a4689;
var G__9505 = b4690;
var G__9506 = c4691;
var G__9507 = d4692;
var G__9508 = e4693;
var G__9509 = f4694;
var G__9510 = g4695;
var G__9511 = h4696;
var G__9512 = i4697;
var G__9513 = j4698;
var G__9514 = k4699;
var G__9515 = l4700;
var G__9516 = m4701;
var G__9517 = n4702;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__9504,G__9505,G__9506,G__9507,G__9508,G__9509,G__9510,G__9511,G__9512,G__9513,G__9514,G__9515,G__9516,G__9517) : f.call(null,G__9504,G__9505,G__9506,G__9507,G__9508,G__9509,G__9510,G__9511,G__9512,G__9513,G__9514,G__9515,G__9516,G__9517));
}
} else {
var o4703 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703);
} else {
var G__9518 = a4689;
var G__9519 = b4690;
var G__9520 = c4691;
var G__9521 = d4692;
var G__9522 = e4693;
var G__9523 = f4694;
var G__9524 = g4695;
var G__9525 = h4696;
var G__9526 = i4697;
var G__9527 = j4698;
var G__9528 = k4699;
var G__9529 = l4700;
var G__9530 = m4701;
var G__9531 = n4702;
var G__9532 = o4703;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__9518,G__9519,G__9520,G__9521,G__9522,G__9523,G__9524,G__9525,G__9526,G__9527,G__9528,G__9529,G__9530,G__9531,G__9532) : f.call(null,G__9518,G__9519,G__9520,G__9521,G__9522,G__9523,G__9524,G__9525,G__9526,G__9527,G__9528,G__9529,G__9530,G__9531,G__9532));
}
} else {
var p4704 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704);
} else {
var G__9533 = a4689;
var G__9534 = b4690;
var G__9535 = c4691;
var G__9536 = d4692;
var G__9537 = e4693;
var G__9538 = f4694;
var G__9539 = g4695;
var G__9540 = h4696;
var G__9541 = i4697;
var G__9542 = j4698;
var G__9543 = k4699;
var G__9544 = l4700;
var G__9545 = m4701;
var G__9546 = n4702;
var G__9547 = o4703;
var G__9548 = p4704;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__9533,G__9534,G__9535,G__9536,G__9537,G__9538,G__9539,G__9540,G__9541,G__9542,G__9543,G__9544,G__9545,G__9546,G__9547,G__9548) : f.call(null,G__9533,G__9534,G__9535,G__9536,G__9537,G__9538,G__9539,G__9540,G__9541,G__9542,G__9543,G__9544,G__9545,G__9546,G__9547,G__9548));
}
} else {
var q4705 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705);
} else {
var G__9549 = a4689;
var G__9550 = b4690;
var G__9551 = c4691;
var G__9552 = d4692;
var G__9553 = e4693;
var G__9554 = f4694;
var G__9555 = g4695;
var G__9556 = h4696;
var G__9557 = i4697;
var G__9558 = j4698;
var G__9559 = k4699;
var G__9560 = l4700;
var G__9561 = m4701;
var G__9562 = n4702;
var G__9563 = o4703;
var G__9564 = p4704;
var G__9565 = q4705;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__9549,G__9550,G__9551,G__9552,G__9553,G__9554,G__9555,G__9556,G__9557,G__9558,G__9559,G__9560,G__9561,G__9562,G__9563,G__9564,G__9565) : f.call(null,G__9549,G__9550,G__9551,G__9552,G__9553,G__9554,G__9555,G__9556,G__9557,G__9558,G__9559,G__9560,G__9561,G__9562,G__9563,G__9564,G__9565));
}
} else {
var r4706 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705,r4706);
} else {
var G__9566 = a4689;
var G__9567 = b4690;
var G__9568 = c4691;
var G__9569 = d4692;
var G__9570 = e4693;
var G__9571 = f4694;
var G__9572 = g4695;
var G__9573 = h4696;
var G__9574 = i4697;
var G__9575 = j4698;
var G__9576 = k4699;
var G__9577 = l4700;
var G__9578 = m4701;
var G__9579 = n4702;
var G__9580 = o4703;
var G__9581 = p4704;
var G__9582 = q4705;
var G__9583 = r4706;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__9566,G__9567,G__9568,G__9569,G__9570,G__9571,G__9572,G__9573,G__9574,G__9575,G__9576,G__9577,G__9578,G__9579,G__9580,G__9581,G__9582,G__9583) : f.call(null,G__9566,G__9567,G__9568,G__9569,G__9570,G__9571,G__9572,G__9573,G__9574,G__9575,G__9576,G__9577,G__9578,G__9579,G__9580,G__9581,G__9582,G__9583));
}
} else {
var s4707 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705,r4706,s4707);
} else {
var G__9584 = a4689;
var G__9585 = b4690;
var G__9586 = c4691;
var G__9587 = d4692;
var G__9588 = e4693;
var G__9589 = f4694;
var G__9590 = g4695;
var G__9591 = h4696;
var G__9592 = i4697;
var G__9593 = j4698;
var G__9594 = k4699;
var G__9595 = l4700;
var G__9596 = m4701;
var G__9597 = n4702;
var G__9598 = o4703;
var G__9599 = p4704;
var G__9600 = q4705;
var G__9601 = r4706;
var G__9602 = s4707;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__9584,G__9585,G__9586,G__9587,G__9588,G__9589,G__9590,G__9591,G__9592,G__9593,G__9594,G__9595,G__9596,G__9597,G__9598,G__9599,G__9600,G__9601,G__9602) : f.call(null,G__9584,G__9585,G__9586,G__9587,G__9588,G__9589,G__9590,G__9591,G__9592,G__9593,G__9594,G__9595,G__9596,G__9597,G__9598,G__9599,G__9600,G__9601,G__9602));
}
} else {
var t4708 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a4689,b4690,c4691,d4692,e4693,f4694,g4695,h4696,i4697,j4698,k4699,l4700,m4701,n4702,o4703,p4704,q4705,r4706,s4707,t4708);
} else {
var G__9603 = a4689;
var G__9604 = b4690;
var G__9605 = c4691;
var G__9606 = d4692;
var G__9607 = e4693;
var G__9608 = f4694;
var G__9609 = g4695;
var G__9610 = h4696;
var G__9611 = i4697;
var G__9612 = j4698;
var G__9613 = k4699;
var G__9614 = l4700;
var G__9615 = m4701;
var G__9616 = n4702;
var G__9617 = o4703;
var G__9618 = p4704;
var G__9619 = q4705;
var G__9620 = r4706;
var G__9621 = s4707;
var G__9622 = t4708;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__9603,G__9604,G__9605,G__9606,G__9607,G__9608,G__9609,G__9610,G__9611,G__9612,G__9613,G__9614,G__9615,G__9616,G__9617,G__9618,G__9619,G__9620,G__9621,G__9622) : f.call(null,G__9603,G__9604,G__9605,G__9606,G__9607,G__9608,G__9609,G__9610,G__9611,G__9612,G__9613,G__9614,G__9615,G__9616,G__9617,G__9618,G__9619,G__9620,G__9621,G__9622));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
* Applies fn f to the argument list formed by prepending intervening arguments to args.
* First cut.  Not lazy.  Needs to use emitted toApply.
* @param {...*} var_args
*/
cljs.core.apply = (function() {
var apply = null;
var apply__2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});
var apply__3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var apply__6 = (function() { 
var G__9623__delegate = function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
};
var G__9623 = function (f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 5) {
var G__9624__i = 0, G__9624__a = new Array(arguments.length -  5);
while (G__9624__i < G__9624__a.length) {G__9624__a[G__9624__i] = arguments[G__9624__i + 5]; ++G__9624__i;}
  args = new cljs.core.IndexedSeq(G__9624__a,0);
} 
return G__9623__delegate.call(this,f,a,b,c,d,args);};
G__9623.cljs$lang$maxFixedArity = 5;
G__9623.cljs$lang$applyTo = (function (arglist__9625){
var f = cljs.core.first(arglist__9625);
arglist__9625 = cljs.core.next(arglist__9625);
var a = cljs.core.first(arglist__9625);
arglist__9625 = cljs.core.next(arglist__9625);
var b = cljs.core.first(arglist__9625);
arglist__9625 = cljs.core.next(arglist__9625);
var c = cljs.core.first(arglist__9625);
arglist__9625 = cljs.core.next(arglist__9625);
var d = cljs.core.first(arglist__9625);
var args = cljs.core.rest(arglist__9625);
return G__9623__delegate(f,a,b,c,d,args);
});
G__9623.cljs$core$IFn$_invoke$arity$variadic = G__9623__delegate;
return G__9623;
})()
;
apply = function(f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return apply__2.call(this,f,a);
case 3:
return apply__3.call(this,f,a,b);
case 4:
return apply__4.call(this,f,a,b,c);
case 5:
return apply__5.call(this,f,a,b,c,d);
default:
var G__9626 = null;
if (arguments.length > 5) {
var G__9627__i = 0, G__9627__a = new Array(arguments.length -  5);
while (G__9627__i < G__9627__a.length) {G__9627__a[G__9627__i] = arguments[G__9627__i + 5]; ++G__9627__i;}
G__9626 = new cljs.core.IndexedSeq(G__9627__a,0);
}
return apply__6.cljs$core$IFn$_invoke$arity$variadic(f,a,b,c,d, G__9626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
apply.cljs$lang$maxFixedArity = 5;
apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
apply.cljs$core$IFn$_invoke$arity$2 = apply__2;
apply.cljs$core$IFn$_invoke$arity$3 = apply__3;
apply.cljs$core$IFn$_invoke$arity$4 = apply__4;
apply.cljs$core$IFn$_invoke$arity$5 = apply__5;
apply.cljs$core$IFn$_invoke$arity$variadic = apply__6.cljs$core$IFn$_invoke$arity$variadic;
return apply;
})()
;
/**
* Returns an object of the same type and value as obj, with
* (apply f (meta obj) args) as its metadata.
* @param {...*} var_args
*/
cljs.core.vary_meta = (function() {
var vary_meta = null;
var vary_meta__2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__9643 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9643) : f.call(null,G__9643));
})());
});
var vary_meta__3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__9644 = cljs.core.meta(obj);
var G__9645 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9644,G__9645) : f.call(null,G__9644,G__9645));
})());
});
var vary_meta__4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__9646 = cljs.core.meta(obj);
var G__9647 = a;
var G__9648 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9646,G__9647,G__9648) : f.call(null,G__9646,G__9647,G__9648));
})());
});
var vary_meta__5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__9649 = cljs.core.meta(obj);
var G__9650 = a;
var G__9651 = b;
var G__9652 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9649,G__9650,G__9651,G__9652) : f.call(null,G__9649,G__9650,G__9651,G__9652));
})());
});
var vary_meta__6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__9653 = cljs.core.meta(obj);
var G__9654 = a;
var G__9655 = b;
var G__9656 = c;
var G__9657 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9653,G__9654,G__9655,G__9656,G__9657) : f.call(null,G__9653,G__9654,G__9655,G__9656,G__9657));
})());
});
var vary_meta__7 = (function() { 
var G__9658__delegate = function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
};
var G__9658 = function (obj,f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 6) {
var G__9659__i = 0, G__9659__a = new Array(arguments.length -  6);
while (G__9659__i < G__9659__a.length) {G__9659__a[G__9659__i] = arguments[G__9659__i + 6]; ++G__9659__i;}
  args = new cljs.core.IndexedSeq(G__9659__a,0);
} 
return G__9658__delegate.call(this,obj,f,a,b,c,d,args);};
G__9658.cljs$lang$maxFixedArity = 6;
G__9658.cljs$lang$applyTo = (function (arglist__9660){
var obj = cljs.core.first(arglist__9660);
arglist__9660 = cljs.core.next(arglist__9660);
var f = cljs.core.first(arglist__9660);
arglist__9660 = cljs.core.next(arglist__9660);
var a = cljs.core.first(arglist__9660);
arglist__9660 = cljs.core.next(arglist__9660);
var b = cljs.core.first(arglist__9660);
arglist__9660 = cljs.core.next(arglist__9660);
var c = cljs.core.first(arglist__9660);
arglist__9660 = cljs.core.next(arglist__9660);
var d = cljs.core.first(arglist__9660);
var args = cljs.core.rest(arglist__9660);
return G__9658__delegate(obj,f,a,b,c,d,args);
});
G__9658.cljs$core$IFn$_invoke$arity$variadic = G__9658__delegate;
return G__9658;
})()
;
vary_meta = function(obj,f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return vary_meta__2.call(this,obj,f);
case 3:
return vary_meta__3.call(this,obj,f,a);
case 4:
return vary_meta__4.call(this,obj,f,a,b);
case 5:
return vary_meta__5.call(this,obj,f,a,b,c);
case 6:
return vary_meta__6.call(this,obj,f,a,b,c,d);
default:
var G__9661 = null;
if (arguments.length > 6) {
var G__9662__i = 0, G__9662__a = new Array(arguments.length -  6);
while (G__9662__i < G__9662__a.length) {G__9662__a[G__9662__i] = arguments[G__9662__i + 6]; ++G__9662__i;}
G__9661 = new cljs.core.IndexedSeq(G__9662__a,0);
}
return vary_meta__7.cljs$core$IFn$_invoke$arity$variadic(obj,f,a,b,c,d, G__9661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
vary_meta.cljs$lang$maxFixedArity = 6;
vary_meta.cljs$lang$applyTo = vary_meta__7.cljs$lang$applyTo;
vary_meta.cljs$core$IFn$_invoke$arity$2 = vary_meta__2;
vary_meta.cljs$core$IFn$_invoke$arity$3 = vary_meta__3;
vary_meta.cljs$core$IFn$_invoke$arity$4 = vary_meta__4;
vary_meta.cljs$core$IFn$_invoke$arity$5 = vary_meta__5;
vary_meta.cljs$core$IFn$_invoke$arity$6 = vary_meta__6;
vary_meta.cljs$core$IFn$_invoke$arity$variadic = vary_meta__7.cljs$core$IFn$_invoke$arity$variadic;
return vary_meta;
})()
;
/**
* Same as (not (= obj1 obj2))
* @param {...*} var_args
*/
cljs.core.not_EQ_ = (function() {
var not_EQ_ = null;
var not_EQ___1 = (function (x){
return false;
});
var not_EQ___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var not_EQ___3 = (function() { 
var G__9663__delegate = function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
};
var G__9663 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__9664__i = 0, G__9664__a = new Array(arguments.length -  2);
while (G__9664__i < G__9664__a.length) {G__9664__a[G__9664__i] = arguments[G__9664__i + 2]; ++G__9664__i;}
  more = new cljs.core.IndexedSeq(G__9664__a,0);
} 
return G__9663__delegate.call(this,x,y,more);};
G__9663.cljs$lang$maxFixedArity = 2;
G__9663.cljs$lang$applyTo = (function (arglist__9665){
var x = cljs.core.first(arglist__9665);
arglist__9665 = cljs.core.next(arglist__9665);
var y = cljs.core.first(arglist__9665);
var more = cljs.core.rest(arglist__9665);
return G__9663__delegate(x,y,more);
});
G__9663.cljs$core$IFn$_invoke$arity$variadic = G__9663__delegate;
return G__9663;
})()
;
not_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return not_EQ___1.call(this,x);
case 2:
return not_EQ___2.call(this,x,y);
default:
var G__9666 = null;
if (arguments.length > 2) {
var G__9667__i = 0, G__9667__a = new Array(arguments.length -  2);
while (G__9667__i < G__9667__a.length) {G__9667__a[G__9667__i] = arguments[G__9667__i + 2]; ++G__9667__i;}
G__9666 = new cljs.core.IndexedSeq(G__9667__a,0);
}
return not_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__9666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
not_EQ_.cljs$lang$maxFixedArity = 2;
not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
not_EQ_.cljs$core$IFn$_invoke$arity$1 = not_EQ___1;
not_EQ_.cljs$core$IFn$_invoke$arity$2 = not_EQ___2;
not_EQ_.cljs$core$IFn$_invoke$arity$variadic = not_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return not_EQ_;
})()
;
/**
* If coll is empty, returns nil, else coll
*/
cljs.core.not_empty = (function not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function nil_iter(){
if(typeof cljs.core.t9671 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t9671 = (function (nil_iter,meta9672){
this.nil_iter = nil_iter;
this.meta9672 = meta9672;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.t9671.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t9671.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t9671.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t9671.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9673){
var self__ = this;
var _9673__$1 = this;
return self__.meta9672;
});

cljs.core.t9671.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9673,meta9672__$1){
var self__ = this;
var _9673__$1 = this;
return (new cljs.core.t9671(self__.nil_iter,meta9672__$1));
});

cljs.core.t9671.cljs$lang$type = true;

cljs.core.t9671.cljs$lang$ctorStr = "cljs.core/t9671";

cljs.core.t9671.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/t9671");
});

cljs.core.__GT_t9671 = (function __GT_t9671(nil_iter__$1,meta9672){
return (new cljs.core.t9671(nil_iter__$1,meta9672));
});

}

return (new cljs.core.t9671(nil_iter,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),54,new cljs.core.Keyword(null,"end-line","end-line",1837326455),3063,new cljs.core.Keyword(null,"column","column",2078222095),3,new cljs.core.Keyword(null,"line","line",212345235),3059,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core.cljs"], null)));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function __GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function __GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function __GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(coll instanceof Array){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3746__auto__ = !((lt.stepper == null));
if(and__3746__auto__){
return self__.iter.hasNext();
} else {
return and__3746__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__9674 = lt;
var G__9675 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__9674,G__9675) : self__.xform.call(null,G__9674,G__9675));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__9676 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__9676) : self__.xform.call(null,G__9676));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function __GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function stepper(xform,iter){
var stepfn = (function() {
var stepfn = null;
var stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
stepfn = function(result,input){
switch(arguments.length){
case 1:
return stepfn__1.call(this,result);
case 2:
return stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;
stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;
return stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__9678 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__9678) : xform.call(null,G__9678));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__9680 = cljs.core.next(iters__$1);
iters__$1 = G__9680;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__4645__auto___9681 = self__.iters.length;
var i_9682 = (0);
while(true){
if((i_9682 < n__4645__auto___9681)){
(self__.nexts[i_9682] = (self__.iters[i_9682]).next());

var G__9683 = (i_9682 + (1));
i_9682 = G__9683;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3746__auto__ = !((lt.stepper == null));
if(and__3746__auto__){
return this$.hasNext();
} else {
return and__3746__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__9679 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__9679) : self__.xform.call(null,G__9679));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function __GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function() {
var multi_stepper = null;
var multi_stepper__2 = (function (xform,iters){
return multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});
var multi_stepper__3 = (function (xform,iters,nexts){
var stepfn = (function() {
var stepfn = null;
var stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
stepfn = function(result,input){
switch(arguments.length){
case 1:
return stepfn__1.call(this,result);
case 2:
return stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
stepfn.cljs$core$IFn$_invoke$arity$1 = stepfn__1;
stepfn.cljs$core$IFn$_invoke$arity$2 = stepfn__2;
return stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__9688 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__9688) : xform.call(null,G__9688));
})(),iters,nexts));
});
multi_stepper = function(xform,iters,nexts){
switch(arguments.length){
case 2:
return multi_stepper__2.call(this,xform,iters);
case 3:
return multi_stepper__3.call(this,xform,iters,nexts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
multi_stepper.cljs$core$IFn$_invoke$arity$2 = multi_stepper__2;
multi_stepper.cljs$core$IFn$_invoke$arity$3 = multi_stepper__3;
return multi_stepper;
})()
;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
})
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function __GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__9689_9693 = cljs.core.seq(colls);
var chunk__9690_9694 = null;
var count__9691_9695 = (0);
var i__9692_9696 = (0);
while(true){
if((i__9692_9696 < count__9691_9695)){
var coll_9697 = chunk__9690_9694.cljs$core$IIndexed$_nth$arity$2(null,i__9692_9696);
iters.push(cljs.core.iter(coll_9697));

var G__9698 = seq__9689_9693;
var G__9699 = chunk__9690_9694;
var G__9700 = count__9691_9695;
var G__9701 = (i__9692_9696 + (1));
seq__9689_9693 = G__9698;
chunk__9690_9694 = G__9699;
count__9691_9695 = G__9700;
i__9692_9696 = G__9701;
continue;
} else {
var temp__4126__auto___9702 = cljs.core.seq(seq__9689_9693);
if(temp__4126__auto___9702){
var seq__9689_9703__$1 = temp__4126__auto___9702;
if(cljs.core.chunked_seq_QMARK_(seq__9689_9703__$1)){
var c__4545__auto___9704 = cljs.core.chunk_first(seq__9689_9703__$1);
var G__9705 = cljs.core.chunk_rest(seq__9689_9703__$1);
var G__9706 = c__4545__auto___9704;
var G__9707 = cljs.core.count(c__4545__auto___9704);
var G__9708 = (0);
seq__9689_9693 = G__9705;
chunk__9690_9694 = G__9706;
count__9691_9695 = G__9707;
i__9692_9696 = G__9708;
continue;
} else {
var coll_9709 = cljs.core.first(seq__9689_9703__$1);
iters.push(cljs.core.iter(coll_9709));

var G__9710 = cljs.core.next(seq__9689_9703__$1);
var G__9711 = null;
var G__9712 = (0);
var G__9713 = (0);
seq__9689_9693 = G__9710;
chunk__9690_9694 = G__9711;
count__9691_9695 = G__9712;
i__9692_9696 = G__9713;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
* Coerces coll to a (possibly empty) sequence, if it is not already
* one. Will not force a lazy seq. (sequence nil) yields (), When a
* transducer is supplied, returns a lazy sequence of applications of
* the transform to the items in coll(s), i.e. to the set of first
* items of each coll, followed by the set of second
* items in each coll, until any one of the colls is exhausted.  Any
* remaining items in other colls are ignored. The transform should accept
* number-of-colls arguments
* @param {...*} var_args
*/
cljs.core.sequence = (function() {
var sequence = null;
var sequence__1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__3758__auto__ = cljs.core.seq(coll);
if(or__3758__auto__){
return or__3758__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});
var sequence__2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});
var sequence__3 = (function() { 
var G__9714__delegate = function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
};
var G__9714 = function (xform,coll,var_args){
var colls = null;
if (arguments.length > 2) {
var G__9715__i = 0, G__9715__a = new Array(arguments.length -  2);
while (G__9715__i < G__9715__a.length) {G__9715__a[G__9715__i] = arguments[G__9715__i + 2]; ++G__9715__i;}
  colls = new cljs.core.IndexedSeq(G__9715__a,0);
} 
return G__9714__delegate.call(this,xform,coll,colls);};
G__9714.cljs$lang$maxFixedArity = 2;
G__9714.cljs$lang$applyTo = (function (arglist__9716){
var xform = cljs.core.first(arglist__9716);
arglist__9716 = cljs.core.next(arglist__9716);
var coll = cljs.core.first(arglist__9716);
var colls = cljs.core.rest(arglist__9716);
return G__9714__delegate(xform,coll,colls);
});
G__9714.cljs$core$IFn$_invoke$arity$variadic = G__9714__delegate;
return G__9714;
})()
;
sequence = function(xform,coll,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return sequence__1.call(this,xform);
case 2:
return sequence__2.call(this,xform,coll);
default:
var G__9717 = null;
if (arguments.length > 2) {
var G__9718__i = 0, G__9718__a = new Array(arguments.length -  2);
while (G__9718__i < G__9718__a.length) {G__9718__a[G__9718__i] = arguments[G__9718__i + 2]; ++G__9718__i;}
G__9717 = new cljs.core.IndexedSeq(G__9718__a,0);
}
return sequence__3.cljs$core$IFn$_invoke$arity$variadic(xform,coll, G__9717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sequence.cljs$lang$maxFixedArity = 2;
sequence.cljs$lang$applyTo = sequence__3.cljs$lang$applyTo;
sequence.cljs$core$IFn$_invoke$arity$1 = sequence__1;
sequence.cljs$core$IFn$_invoke$arity$2 = sequence__2;
sequence.cljs$core$IFn$_invoke$arity$variadic = sequence__3.cljs$core$IFn$_invoke$arity$variadic;
return sequence;
})()
;
/**
* Returns true if (pred x) is logical true for every x in coll, else
* false.
*/
cljs.core.every_QMARK_ = (function every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__9720 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9720) : pred.call(null,G__9720));
})())){
var G__9721 = pred;
var G__9722 = cljs.core.next(coll);
pred = G__9721;
coll = G__9722;
continue;
} else {
return false;

}
}
break;
}
});
/**
* Returns false if (pred x) is logical true for every x in
* coll, else true.
*/
cljs.core.not_every_QMARK_ = (function not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
* Returns the first logical true value of (pred x) for any x in coll,
* else nil.  One common idiom is to use a set as pred, for example
* this will return :fred if :fred is in the sequence, otherwise nil:
* (some #{:fred} coll)
*/
cljs.core.some = (function some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__3758__auto__ = (function (){var G__9726 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9726) : pred.call(null,G__9726));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__9727 = pred;
var G__9728 = cljs.core.next(coll);
pred = G__9727;
coll = G__9728;
continue;
}
} else {
return null;
}
break;
}
});
/**
* Returns false if (pred x) is logical true for any x in coll,
* else true.
*/
cljs.core.not_any_QMARK_ = (function not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
* Returns true if n is even, throws an exception if n is not an integer
*/
cljs.core.even_QMARK_ = (function even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
* Returns true if n is odd, throws an exception if n is not an integer
*/
cljs.core.odd_QMARK_ = (function odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
* Takes a fn f and returns a fn that takes the same arguments as f,
* has the same effects, if any, and returns the opposite truth value.
*/
cljs.core.complement = (function complement(f){
return (function() {
var G__9735 = null;
var G__9735__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__9735__1 = (function (x){
return cljs.core.not((function (){var G__9732 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9732) : f.call(null,G__9732));
})());
});
var G__9735__2 = (function (x,y){
return cljs.core.not((function (){var G__9733 = x;
var G__9734 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9733,G__9734) : f.call(null,G__9733,G__9734));
})());
});
var G__9735__3 = (function() { 
var G__9736__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__9736 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__9737__i = 0, G__9737__a = new Array(arguments.length -  2);
while (G__9737__i < G__9737__a.length) {G__9737__a[G__9737__i] = arguments[G__9737__i + 2]; ++G__9737__i;}
  zs = new cljs.core.IndexedSeq(G__9737__a,0);
} 
return G__9736__delegate.call(this,x,y,zs);};
G__9736.cljs$lang$maxFixedArity = 2;
G__9736.cljs$lang$applyTo = (function (arglist__9738){
var x = cljs.core.first(arglist__9738);
arglist__9738 = cljs.core.next(arglist__9738);
var y = cljs.core.first(arglist__9738);
var zs = cljs.core.rest(arglist__9738);
return G__9736__delegate(x,y,zs);
});
G__9736.cljs$core$IFn$_invoke$arity$variadic = G__9736__delegate;
return G__9736;
})()
;
G__9735 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__9735__0.call(this);
case 1:
return G__9735__1.call(this,x);
case 2:
return G__9735__2.call(this,x,y);
default:
var G__9739 = null;
if (arguments.length > 2) {
var G__9740__i = 0, G__9740__a = new Array(arguments.length -  2);
while (G__9740__i < G__9740__a.length) {G__9740__a[G__9740__i] = arguments[G__9740__i + 2]; ++G__9740__i;}
G__9739 = new cljs.core.IndexedSeq(G__9740__a,0);
}
return G__9735__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__9739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9735.cljs$lang$maxFixedArity = 2;
G__9735.cljs$lang$applyTo = G__9735__3.cljs$lang$applyTo;
G__9735.cljs$core$IFn$_invoke$arity$0 = G__9735__0;
G__9735.cljs$core$IFn$_invoke$arity$1 = G__9735__1;
G__9735.cljs$core$IFn$_invoke$arity$2 = G__9735__2;
G__9735.cljs$core$IFn$_invoke$arity$variadic = G__9735__3.cljs$core$IFn$_invoke$arity$variadic;
return G__9735;
})()
});
/**
* Returns a function that takes any number of arguments and returns x.
*/
cljs.core.constantly = (function constantly(x){
return (function() { 
var G__9741__delegate = function (args){
return x;
};
var G__9741 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9742__i = 0, G__9742__a = new Array(arguments.length -  0);
while (G__9742__i < G__9742__a.length) {G__9742__a[G__9742__i] = arguments[G__9742__i + 0]; ++G__9742__i;}
  args = new cljs.core.IndexedSeq(G__9742__a,0);
} 
return G__9741__delegate.call(this,args);};
G__9741.cljs$lang$maxFixedArity = 0;
G__9741.cljs$lang$applyTo = (function (arglist__9743){
var args = cljs.core.seq(arglist__9743);
return G__9741__delegate(args);
});
G__9741.cljs$core$IFn$_invoke$arity$variadic = G__9741__delegate;
return G__9741;
})()
;
});
/**
* Takes a set of functions and returns a fn that is the composition
* of those fns.  The returned fn takes a variable number of args,
* applies the rightmost of fns to the args, the next
* fn (right-to-left) to the result, etc.
* @param {...*} var_args
*/
cljs.core.comp = (function() {
var comp = null;
var comp__0 = (function (){
return cljs.core.identity;
});
var comp__1 = (function (f){
return f;
});
var comp__2 = (function (f,g){
return (function() {
var G__9798 = null;
var G__9798__0 = (function (){
var G__9771 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9771) : f.call(null,G__9771));
});
var G__9798__1 = (function (x){
var G__9772 = (function (){var G__9773 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9773) : g.call(null,G__9773));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9772) : f.call(null,G__9772));
});
var G__9798__2 = (function (x,y){
var G__9774 = (function (){var G__9775 = x;
var G__9776 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9775,G__9776) : g.call(null,G__9775,G__9776));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9774) : f.call(null,G__9774));
});
var G__9798__3 = (function (x,y,z){
var G__9777 = (function (){var G__9778 = x;
var G__9779 = y;
var G__9780 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9778,G__9779,G__9780) : g.call(null,G__9778,G__9779,G__9780));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9777) : f.call(null,G__9777));
});
var G__9798__4 = (function() { 
var G__9799__delegate = function (x,y,z,args){
var G__9781 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9781) : f.call(null,G__9781));
};
var G__9799 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9800__i = 0, G__9800__a = new Array(arguments.length -  3);
while (G__9800__i < G__9800__a.length) {G__9800__a[G__9800__i] = arguments[G__9800__i + 3]; ++G__9800__i;}
  args = new cljs.core.IndexedSeq(G__9800__a,0);
} 
return G__9799__delegate.call(this,x,y,z,args);};
G__9799.cljs$lang$maxFixedArity = 3;
G__9799.cljs$lang$applyTo = (function (arglist__9801){
var x = cljs.core.first(arglist__9801);
arglist__9801 = cljs.core.next(arglist__9801);
var y = cljs.core.first(arglist__9801);
arglist__9801 = cljs.core.next(arglist__9801);
var z = cljs.core.first(arglist__9801);
var args = cljs.core.rest(arglist__9801);
return G__9799__delegate(x,y,z,args);
});
G__9799.cljs$core$IFn$_invoke$arity$variadic = G__9799__delegate;
return G__9799;
})()
;
G__9798 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9798__0.call(this);
case 1:
return G__9798__1.call(this,x);
case 2:
return G__9798__2.call(this,x,y);
case 3:
return G__9798__3.call(this,x,y,z);
default:
var G__9802 = null;
if (arguments.length > 3) {
var G__9803__i = 0, G__9803__a = new Array(arguments.length -  3);
while (G__9803__i < G__9803__a.length) {G__9803__a[G__9803__i] = arguments[G__9803__i + 3]; ++G__9803__i;}
G__9802 = new cljs.core.IndexedSeq(G__9803__a,0);
}
return G__9798__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9798.cljs$lang$maxFixedArity = 3;
G__9798.cljs$lang$applyTo = G__9798__4.cljs$lang$applyTo;
G__9798.cljs$core$IFn$_invoke$arity$0 = G__9798__0;
G__9798.cljs$core$IFn$_invoke$arity$1 = G__9798__1;
G__9798.cljs$core$IFn$_invoke$arity$2 = G__9798__2;
G__9798.cljs$core$IFn$_invoke$arity$3 = G__9798__3;
G__9798.cljs$core$IFn$_invoke$arity$variadic = G__9798__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9798;
})()
});
var comp__3 = (function (f,g,h){
return (function() {
var G__9804 = null;
var G__9804__0 = (function (){
var G__9782 = (function (){var G__9783 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9783) : g.call(null,G__9783));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9782) : f.call(null,G__9782));
});
var G__9804__1 = (function (x){
var G__9784 = (function (){var G__9785 = (function (){var G__9786 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__9786) : h.call(null,G__9786));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9785) : g.call(null,G__9785));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9784) : f.call(null,G__9784));
});
var G__9804__2 = (function (x,y){
var G__9787 = (function (){var G__9788 = (function (){var G__9789 = x;
var G__9790 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__9789,G__9790) : h.call(null,G__9789,G__9790));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9788) : g.call(null,G__9788));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9787) : f.call(null,G__9787));
});
var G__9804__3 = (function (x,y,z){
var G__9791 = (function (){var G__9792 = (function (){var G__9793 = x;
var G__9794 = y;
var G__9795 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__9793,G__9794,G__9795) : h.call(null,G__9793,G__9794,G__9795));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9792) : g.call(null,G__9792));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9791) : f.call(null,G__9791));
});
var G__9804__4 = (function() { 
var G__9805__delegate = function (x,y,z,args){
var G__9796 = (function (){var G__9797 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9797) : g.call(null,G__9797));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9796) : f.call(null,G__9796));
};
var G__9805 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9806__i = 0, G__9806__a = new Array(arguments.length -  3);
while (G__9806__i < G__9806__a.length) {G__9806__a[G__9806__i] = arguments[G__9806__i + 3]; ++G__9806__i;}
  args = new cljs.core.IndexedSeq(G__9806__a,0);
} 
return G__9805__delegate.call(this,x,y,z,args);};
G__9805.cljs$lang$maxFixedArity = 3;
G__9805.cljs$lang$applyTo = (function (arglist__9807){
var x = cljs.core.first(arglist__9807);
arglist__9807 = cljs.core.next(arglist__9807);
var y = cljs.core.first(arglist__9807);
arglist__9807 = cljs.core.next(arglist__9807);
var z = cljs.core.first(arglist__9807);
var args = cljs.core.rest(arglist__9807);
return G__9805__delegate(x,y,z,args);
});
G__9805.cljs$core$IFn$_invoke$arity$variadic = G__9805__delegate;
return G__9805;
})()
;
G__9804 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9804__0.call(this);
case 1:
return G__9804__1.call(this,x);
case 2:
return G__9804__2.call(this,x,y);
case 3:
return G__9804__3.call(this,x,y,z);
default:
var G__9808 = null;
if (arguments.length > 3) {
var G__9809__i = 0, G__9809__a = new Array(arguments.length -  3);
while (G__9809__i < G__9809__a.length) {G__9809__a[G__9809__i] = arguments[G__9809__i + 3]; ++G__9809__i;}
G__9808 = new cljs.core.IndexedSeq(G__9809__a,0);
}
return G__9804__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9804.cljs$lang$maxFixedArity = 3;
G__9804.cljs$lang$applyTo = G__9804__4.cljs$lang$applyTo;
G__9804.cljs$core$IFn$_invoke$arity$0 = G__9804__0;
G__9804.cljs$core$IFn$_invoke$arity$1 = G__9804__1;
G__9804.cljs$core$IFn$_invoke$arity$2 = G__9804__2;
G__9804.cljs$core$IFn$_invoke$arity$3 = G__9804__3;
G__9804.cljs$core$IFn$_invoke$arity$variadic = G__9804__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9804;
})()
});
var comp__4 = (function() { 
var G__9810__delegate = function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__9811__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__9812 = cljs.core.first(fs__$2).call(null,ret);
var G__9813 = cljs.core.next(fs__$2);
ret = G__9812;
fs__$2 = G__9813;
continue;
} else {
return ret;
}
break;
}
};
var G__9811 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9814__i = 0, G__9814__a = new Array(arguments.length -  0);
while (G__9814__i < G__9814__a.length) {G__9814__a[G__9814__i] = arguments[G__9814__i + 0]; ++G__9814__i;}
  args = new cljs.core.IndexedSeq(G__9814__a,0);
} 
return G__9811__delegate.call(this,args);};
G__9811.cljs$lang$maxFixedArity = 0;
G__9811.cljs$lang$applyTo = (function (arglist__9815){
var args = cljs.core.seq(arglist__9815);
return G__9811__delegate(args);
});
G__9811.cljs$core$IFn$_invoke$arity$variadic = G__9811__delegate;
return G__9811;
})()
;
;})(fs__$1))
};
var G__9810 = function (f1,f2,f3,var_args){
var fs = null;
if (arguments.length > 3) {
var G__9816__i = 0, G__9816__a = new Array(arguments.length -  3);
while (G__9816__i < G__9816__a.length) {G__9816__a[G__9816__i] = arguments[G__9816__i + 3]; ++G__9816__i;}
  fs = new cljs.core.IndexedSeq(G__9816__a,0);
} 
return G__9810__delegate.call(this,f1,f2,f3,fs);};
G__9810.cljs$lang$maxFixedArity = 3;
G__9810.cljs$lang$applyTo = (function (arglist__9817){
var f1 = cljs.core.first(arglist__9817);
arglist__9817 = cljs.core.next(arglist__9817);
var f2 = cljs.core.first(arglist__9817);
arglist__9817 = cljs.core.next(arglist__9817);
var f3 = cljs.core.first(arglist__9817);
var fs = cljs.core.rest(arglist__9817);
return G__9810__delegate(f1,f2,f3,fs);
});
G__9810.cljs$core$IFn$_invoke$arity$variadic = G__9810__delegate;
return G__9810;
})()
;
comp = function(f1,f2,f3,var_args){
var fs = var_args;
switch(arguments.length){
case 0:
return comp__0.call(this);
case 1:
return comp__1.call(this,f1);
case 2:
return comp__2.call(this,f1,f2);
case 3:
return comp__3.call(this,f1,f2,f3);
default:
var G__9818 = null;
if (arguments.length > 3) {
var G__9819__i = 0, G__9819__a = new Array(arguments.length -  3);
while (G__9819__i < G__9819__a.length) {G__9819__a[G__9819__i] = arguments[G__9819__i + 3]; ++G__9819__i;}
G__9818 = new cljs.core.IndexedSeq(G__9819__a,0);
}
return comp__4.cljs$core$IFn$_invoke$arity$variadic(f1,f2,f3, G__9818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
comp.cljs$lang$maxFixedArity = 3;
comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
comp.cljs$core$IFn$_invoke$arity$0 = comp__0;
comp.cljs$core$IFn$_invoke$arity$1 = comp__1;
comp.cljs$core$IFn$_invoke$arity$2 = comp__2;
comp.cljs$core$IFn$_invoke$arity$3 = comp__3;
comp.cljs$core$IFn$_invoke$arity$variadic = comp__4.cljs$core$IFn$_invoke$arity$variadic;
return comp;
})()
;
/**
* Takes a function f and fewer than the normal arguments to f, and
* returns a fn that takes a variable number of additional args. When
* called, the returned function calls f with args + additional args.
* @param {...*} var_args
*/
cljs.core.partial = (function() {
var partial = null;
var partial__1 = (function (f){
return f;
});
var partial__2 = (function (f,arg1){
return (function() {
var G__9904 = null;
var G__9904__0 = (function (){
var G__9862 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9862) : f.call(null,G__9862));
});
var G__9904__1 = (function (x){
var G__9863 = arg1;
var G__9864 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9863,G__9864) : f.call(null,G__9863,G__9864));
});
var G__9904__2 = (function (x,y){
var G__9865 = arg1;
var G__9866 = x;
var G__9867 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9865,G__9866,G__9867) : f.call(null,G__9865,G__9866,G__9867));
});
var G__9904__3 = (function (x,y,z){
var G__9868 = arg1;
var G__9869 = x;
var G__9870 = y;
var G__9871 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9868,G__9869,G__9870,G__9871) : f.call(null,G__9868,G__9869,G__9870,G__9871));
});
var G__9904__4 = (function() { 
var G__9905__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__9905 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9906__i = 0, G__9906__a = new Array(arguments.length -  3);
while (G__9906__i < G__9906__a.length) {G__9906__a[G__9906__i] = arguments[G__9906__i + 3]; ++G__9906__i;}
  args = new cljs.core.IndexedSeq(G__9906__a,0);
} 
return G__9905__delegate.call(this,x,y,z,args);};
G__9905.cljs$lang$maxFixedArity = 3;
G__9905.cljs$lang$applyTo = (function (arglist__9907){
var x = cljs.core.first(arglist__9907);
arglist__9907 = cljs.core.next(arglist__9907);
var y = cljs.core.first(arglist__9907);
arglist__9907 = cljs.core.next(arglist__9907);
var z = cljs.core.first(arglist__9907);
var args = cljs.core.rest(arglist__9907);
return G__9905__delegate(x,y,z,args);
});
G__9905.cljs$core$IFn$_invoke$arity$variadic = G__9905__delegate;
return G__9905;
})()
;
G__9904 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9904__0.call(this);
case 1:
return G__9904__1.call(this,x);
case 2:
return G__9904__2.call(this,x,y);
case 3:
return G__9904__3.call(this,x,y,z);
default:
var G__9908 = null;
if (arguments.length > 3) {
var G__9909__i = 0, G__9909__a = new Array(arguments.length -  3);
while (G__9909__i < G__9909__a.length) {G__9909__a[G__9909__i] = arguments[G__9909__i + 3]; ++G__9909__i;}
G__9908 = new cljs.core.IndexedSeq(G__9909__a,0);
}
return G__9904__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9904.cljs$lang$maxFixedArity = 3;
G__9904.cljs$lang$applyTo = G__9904__4.cljs$lang$applyTo;
G__9904.cljs$core$IFn$_invoke$arity$0 = G__9904__0;
G__9904.cljs$core$IFn$_invoke$arity$1 = G__9904__1;
G__9904.cljs$core$IFn$_invoke$arity$2 = G__9904__2;
G__9904.cljs$core$IFn$_invoke$arity$3 = G__9904__3;
G__9904.cljs$core$IFn$_invoke$arity$variadic = G__9904__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9904;
})()
});
var partial__3 = (function (f,arg1,arg2){
return (function() {
var G__9910 = null;
var G__9910__0 = (function (){
var G__9872 = arg1;
var G__9873 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9872,G__9873) : f.call(null,G__9872,G__9873));
});
var G__9910__1 = (function (x){
var G__9874 = arg1;
var G__9875 = arg2;
var G__9876 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9874,G__9875,G__9876) : f.call(null,G__9874,G__9875,G__9876));
});
var G__9910__2 = (function (x,y){
var G__9877 = arg1;
var G__9878 = arg2;
var G__9879 = x;
var G__9880 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9877,G__9878,G__9879,G__9880) : f.call(null,G__9877,G__9878,G__9879,G__9880));
});
var G__9910__3 = (function (x,y,z){
var G__9881 = arg1;
var G__9882 = arg2;
var G__9883 = x;
var G__9884 = y;
var G__9885 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9881,G__9882,G__9883,G__9884,G__9885) : f.call(null,G__9881,G__9882,G__9883,G__9884,G__9885));
});
var G__9910__4 = (function() { 
var G__9911__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__9911 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9912__i = 0, G__9912__a = new Array(arguments.length -  3);
while (G__9912__i < G__9912__a.length) {G__9912__a[G__9912__i] = arguments[G__9912__i + 3]; ++G__9912__i;}
  args = new cljs.core.IndexedSeq(G__9912__a,0);
} 
return G__9911__delegate.call(this,x,y,z,args);};
G__9911.cljs$lang$maxFixedArity = 3;
G__9911.cljs$lang$applyTo = (function (arglist__9913){
var x = cljs.core.first(arglist__9913);
arglist__9913 = cljs.core.next(arglist__9913);
var y = cljs.core.first(arglist__9913);
arglist__9913 = cljs.core.next(arglist__9913);
var z = cljs.core.first(arglist__9913);
var args = cljs.core.rest(arglist__9913);
return G__9911__delegate(x,y,z,args);
});
G__9911.cljs$core$IFn$_invoke$arity$variadic = G__9911__delegate;
return G__9911;
})()
;
G__9910 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9910__0.call(this);
case 1:
return G__9910__1.call(this,x);
case 2:
return G__9910__2.call(this,x,y);
case 3:
return G__9910__3.call(this,x,y,z);
default:
var G__9914 = null;
if (arguments.length > 3) {
var G__9915__i = 0, G__9915__a = new Array(arguments.length -  3);
while (G__9915__i < G__9915__a.length) {G__9915__a[G__9915__i] = arguments[G__9915__i + 3]; ++G__9915__i;}
G__9914 = new cljs.core.IndexedSeq(G__9915__a,0);
}
return G__9910__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9910.cljs$lang$maxFixedArity = 3;
G__9910.cljs$lang$applyTo = G__9910__4.cljs$lang$applyTo;
G__9910.cljs$core$IFn$_invoke$arity$0 = G__9910__0;
G__9910.cljs$core$IFn$_invoke$arity$1 = G__9910__1;
G__9910.cljs$core$IFn$_invoke$arity$2 = G__9910__2;
G__9910.cljs$core$IFn$_invoke$arity$3 = G__9910__3;
G__9910.cljs$core$IFn$_invoke$arity$variadic = G__9910__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9910;
})()
});
var partial__4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__9916 = null;
var G__9916__0 = (function (){
var G__9886 = arg1;
var G__9887 = arg2;
var G__9888 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9886,G__9887,G__9888) : f.call(null,G__9886,G__9887,G__9888));
});
var G__9916__1 = (function (x){
var G__9889 = arg1;
var G__9890 = arg2;
var G__9891 = arg3;
var G__9892 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9889,G__9890,G__9891,G__9892) : f.call(null,G__9889,G__9890,G__9891,G__9892));
});
var G__9916__2 = (function (x,y){
var G__9893 = arg1;
var G__9894 = arg2;
var G__9895 = arg3;
var G__9896 = x;
var G__9897 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__9893,G__9894,G__9895,G__9896,G__9897) : f.call(null,G__9893,G__9894,G__9895,G__9896,G__9897));
});
var G__9916__3 = (function (x,y,z){
var G__9898 = arg1;
var G__9899 = arg2;
var G__9900 = arg3;
var G__9901 = x;
var G__9902 = y;
var G__9903 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__9898,G__9899,G__9900,G__9901,G__9902,G__9903) : f.call(null,G__9898,G__9899,G__9900,G__9901,G__9902,G__9903));
});
var G__9916__4 = (function() { 
var G__9917__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__9917 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9918__i = 0, G__9918__a = new Array(arguments.length -  3);
while (G__9918__i < G__9918__a.length) {G__9918__a[G__9918__i] = arguments[G__9918__i + 3]; ++G__9918__i;}
  args = new cljs.core.IndexedSeq(G__9918__a,0);
} 
return G__9917__delegate.call(this,x,y,z,args);};
G__9917.cljs$lang$maxFixedArity = 3;
G__9917.cljs$lang$applyTo = (function (arglist__9919){
var x = cljs.core.first(arglist__9919);
arglist__9919 = cljs.core.next(arglist__9919);
var y = cljs.core.first(arglist__9919);
arglist__9919 = cljs.core.next(arglist__9919);
var z = cljs.core.first(arglist__9919);
var args = cljs.core.rest(arglist__9919);
return G__9917__delegate(x,y,z,args);
});
G__9917.cljs$core$IFn$_invoke$arity$variadic = G__9917__delegate;
return G__9917;
})()
;
G__9916 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9916__0.call(this);
case 1:
return G__9916__1.call(this,x);
case 2:
return G__9916__2.call(this,x,y);
case 3:
return G__9916__3.call(this,x,y,z);
default:
var G__9920 = null;
if (arguments.length > 3) {
var G__9921__i = 0, G__9921__a = new Array(arguments.length -  3);
while (G__9921__i < G__9921__a.length) {G__9921__a[G__9921__i] = arguments[G__9921__i + 3]; ++G__9921__i;}
G__9920 = new cljs.core.IndexedSeq(G__9921__a,0);
}
return G__9916__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9916.cljs$lang$maxFixedArity = 3;
G__9916.cljs$lang$applyTo = G__9916__4.cljs$lang$applyTo;
G__9916.cljs$core$IFn$_invoke$arity$0 = G__9916__0;
G__9916.cljs$core$IFn$_invoke$arity$1 = G__9916__1;
G__9916.cljs$core$IFn$_invoke$arity$2 = G__9916__2;
G__9916.cljs$core$IFn$_invoke$arity$3 = G__9916__3;
G__9916.cljs$core$IFn$_invoke$arity$variadic = G__9916__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9916;
})()
});
var partial__5 = (function() { 
var G__9922__delegate = function (f,arg1,arg2,arg3,more){
return (function() { 
var G__9923__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__9923 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9924__i = 0, G__9924__a = new Array(arguments.length -  0);
while (G__9924__i < G__9924__a.length) {G__9924__a[G__9924__i] = arguments[G__9924__i + 0]; ++G__9924__i;}
  args = new cljs.core.IndexedSeq(G__9924__a,0);
} 
return G__9923__delegate.call(this,args);};
G__9923.cljs$lang$maxFixedArity = 0;
G__9923.cljs$lang$applyTo = (function (arglist__9925){
var args = cljs.core.seq(arglist__9925);
return G__9923__delegate(args);
});
G__9923.cljs$core$IFn$_invoke$arity$variadic = G__9923__delegate;
return G__9923;
})()
;
};
var G__9922 = function (f,arg1,arg2,arg3,var_args){
var more = null;
if (arguments.length > 4) {
var G__9926__i = 0, G__9926__a = new Array(arguments.length -  4);
while (G__9926__i < G__9926__a.length) {G__9926__a[G__9926__i] = arguments[G__9926__i + 4]; ++G__9926__i;}
  more = new cljs.core.IndexedSeq(G__9926__a,0);
} 
return G__9922__delegate.call(this,f,arg1,arg2,arg3,more);};
G__9922.cljs$lang$maxFixedArity = 4;
G__9922.cljs$lang$applyTo = (function (arglist__9927){
var f = cljs.core.first(arglist__9927);
arglist__9927 = cljs.core.next(arglist__9927);
var arg1 = cljs.core.first(arglist__9927);
arglist__9927 = cljs.core.next(arglist__9927);
var arg2 = cljs.core.first(arglist__9927);
arglist__9927 = cljs.core.next(arglist__9927);
var arg3 = cljs.core.first(arglist__9927);
var more = cljs.core.rest(arglist__9927);
return G__9922__delegate(f,arg1,arg2,arg3,more);
});
G__9922.cljs$core$IFn$_invoke$arity$variadic = G__9922__delegate;
return G__9922;
})()
;
partial = function(f,arg1,arg2,arg3,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return partial__1.call(this,f);
case 2:
return partial__2.call(this,f,arg1);
case 3:
return partial__3.call(this,f,arg1,arg2);
case 4:
return partial__4.call(this,f,arg1,arg2,arg3);
default:
var G__9928 = null;
if (arguments.length > 4) {
var G__9929__i = 0, G__9929__a = new Array(arguments.length -  4);
while (G__9929__i < G__9929__a.length) {G__9929__a[G__9929__i] = arguments[G__9929__i + 4]; ++G__9929__i;}
G__9928 = new cljs.core.IndexedSeq(G__9929__a,0);
}
return partial__5.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3, G__9928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partial.cljs$lang$maxFixedArity = 4;
partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
partial.cljs$core$IFn$_invoke$arity$1 = partial__1;
partial.cljs$core$IFn$_invoke$arity$2 = partial__2;
partial.cljs$core$IFn$_invoke$arity$3 = partial__3;
partial.cljs$core$IFn$_invoke$arity$4 = partial__4;
partial.cljs$core$IFn$_invoke$arity$variadic = partial__5.cljs$core$IFn$_invoke$arity$variadic;
return partial;
})()
;
/**
* Takes a function f, and returns a function that calls f, replacing
* a nil first argument to f with the supplied value x. Higher arity
* versions can replace arguments in the second and third
* positions (y, z). Note that the function f can take any number of
* arguments, not just the one(s) being nil-patched.
*/
cljs.core.fnil = (function() {
var fnil = null;
var fnil__2 = (function (f,x){
return (function() {
var G__9962 = null;
var G__9962__1 = (function (a){
var G__9946 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9946) : f.call(null,G__9946));
});
var G__9962__2 = (function (a,b){
var G__9947 = (((a == null))?x:a);
var G__9948 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9947,G__9948) : f.call(null,G__9947,G__9948));
});
var G__9962__3 = (function (a,b,c){
var G__9949 = (((a == null))?x:a);
var G__9950 = b;
var G__9951 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9949,G__9950,G__9951) : f.call(null,G__9949,G__9950,G__9951));
});
var G__9962__4 = (function() { 
var G__9963__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__9963 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9964__i = 0, G__9964__a = new Array(arguments.length -  3);
while (G__9964__i < G__9964__a.length) {G__9964__a[G__9964__i] = arguments[G__9964__i + 3]; ++G__9964__i;}
  ds = new cljs.core.IndexedSeq(G__9964__a,0);
} 
return G__9963__delegate.call(this,a,b,c,ds);};
G__9963.cljs$lang$maxFixedArity = 3;
G__9963.cljs$lang$applyTo = (function (arglist__9965){
var a = cljs.core.first(arglist__9965);
arglist__9965 = cljs.core.next(arglist__9965);
var b = cljs.core.first(arglist__9965);
arglist__9965 = cljs.core.next(arglist__9965);
var c = cljs.core.first(arglist__9965);
var ds = cljs.core.rest(arglist__9965);
return G__9963__delegate(a,b,c,ds);
});
G__9963.cljs$core$IFn$_invoke$arity$variadic = G__9963__delegate;
return G__9963;
})()
;
G__9962 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__9962__1.call(this,a);
case 2:
return G__9962__2.call(this,a,b);
case 3:
return G__9962__3.call(this,a,b,c);
default:
var G__9966 = null;
if (arguments.length > 3) {
var G__9967__i = 0, G__9967__a = new Array(arguments.length -  3);
while (G__9967__i < G__9967__a.length) {G__9967__a[G__9967__i] = arguments[G__9967__i + 3]; ++G__9967__i;}
G__9966 = new cljs.core.IndexedSeq(G__9967__a,0);
}
return G__9962__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9962.cljs$lang$maxFixedArity = 3;
G__9962.cljs$lang$applyTo = G__9962__4.cljs$lang$applyTo;
G__9962.cljs$core$IFn$_invoke$arity$1 = G__9962__1;
G__9962.cljs$core$IFn$_invoke$arity$2 = G__9962__2;
G__9962.cljs$core$IFn$_invoke$arity$3 = G__9962__3;
G__9962.cljs$core$IFn$_invoke$arity$variadic = G__9962__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9962;
})()
});
var fnil__3 = (function (f,x,y){
return (function() {
var G__9968 = null;
var G__9968__2 = (function (a,b){
var G__9952 = (((a == null))?x:a);
var G__9953 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9952,G__9953) : f.call(null,G__9952,G__9953));
});
var G__9968__3 = (function (a,b,c){
var G__9954 = (((a == null))?x:a);
var G__9955 = (((b == null))?y:b);
var G__9956 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9954,G__9955,G__9956) : f.call(null,G__9954,G__9955,G__9956));
});
var G__9968__4 = (function() { 
var G__9969__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__9969 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9970__i = 0, G__9970__a = new Array(arguments.length -  3);
while (G__9970__i < G__9970__a.length) {G__9970__a[G__9970__i] = arguments[G__9970__i + 3]; ++G__9970__i;}
  ds = new cljs.core.IndexedSeq(G__9970__a,0);
} 
return G__9969__delegate.call(this,a,b,c,ds);};
G__9969.cljs$lang$maxFixedArity = 3;
G__9969.cljs$lang$applyTo = (function (arglist__9971){
var a = cljs.core.first(arglist__9971);
arglist__9971 = cljs.core.next(arglist__9971);
var b = cljs.core.first(arglist__9971);
arglist__9971 = cljs.core.next(arglist__9971);
var c = cljs.core.first(arglist__9971);
var ds = cljs.core.rest(arglist__9971);
return G__9969__delegate(a,b,c,ds);
});
G__9969.cljs$core$IFn$_invoke$arity$variadic = G__9969__delegate;
return G__9969;
})()
;
G__9968 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__9968__2.call(this,a,b);
case 3:
return G__9968__3.call(this,a,b,c);
default:
var G__9972 = null;
if (arguments.length > 3) {
var G__9973__i = 0, G__9973__a = new Array(arguments.length -  3);
while (G__9973__i < G__9973__a.length) {G__9973__a[G__9973__i] = arguments[G__9973__i + 3]; ++G__9973__i;}
G__9972 = new cljs.core.IndexedSeq(G__9973__a,0);
}
return G__9968__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9968.cljs$lang$maxFixedArity = 3;
G__9968.cljs$lang$applyTo = G__9968__4.cljs$lang$applyTo;
G__9968.cljs$core$IFn$_invoke$arity$2 = G__9968__2;
G__9968.cljs$core$IFn$_invoke$arity$3 = G__9968__3;
G__9968.cljs$core$IFn$_invoke$arity$variadic = G__9968__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9968;
})()
});
var fnil__4 = (function (f,x,y,z){
return (function() {
var G__9974 = null;
var G__9974__2 = (function (a,b){
var G__9957 = (((a == null))?x:a);
var G__9958 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9957,G__9958) : f.call(null,G__9957,G__9958));
});
var G__9974__3 = (function (a,b,c){
var G__9959 = (((a == null))?x:a);
var G__9960 = (((b == null))?y:b);
var G__9961 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9959,G__9960,G__9961) : f.call(null,G__9959,G__9960,G__9961));
});
var G__9974__4 = (function() { 
var G__9975__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__9975 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__9976__i = 0, G__9976__a = new Array(arguments.length -  3);
while (G__9976__i < G__9976__a.length) {G__9976__a[G__9976__i] = arguments[G__9976__i + 3]; ++G__9976__i;}
  ds = new cljs.core.IndexedSeq(G__9976__a,0);
} 
return G__9975__delegate.call(this,a,b,c,ds);};
G__9975.cljs$lang$maxFixedArity = 3;
G__9975.cljs$lang$applyTo = (function (arglist__9977){
var a = cljs.core.first(arglist__9977);
arglist__9977 = cljs.core.next(arglist__9977);
var b = cljs.core.first(arglist__9977);
arglist__9977 = cljs.core.next(arglist__9977);
var c = cljs.core.first(arglist__9977);
var ds = cljs.core.rest(arglist__9977);
return G__9975__delegate(a,b,c,ds);
});
G__9975.cljs$core$IFn$_invoke$arity$variadic = G__9975__delegate;
return G__9975;
})()
;
G__9974 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__9974__2.call(this,a,b);
case 3:
return G__9974__3.call(this,a,b,c);
default:
var G__9978 = null;
if (arguments.length > 3) {
var G__9979__i = 0, G__9979__a = new Array(arguments.length -  3);
while (G__9979__i < G__9979__a.length) {G__9979__a[G__9979__i] = arguments[G__9979__i + 3]; ++G__9979__i;}
G__9978 = new cljs.core.IndexedSeq(G__9979__a,0);
}
return G__9974__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__9978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9974.cljs$lang$maxFixedArity = 3;
G__9974.cljs$lang$applyTo = G__9974__4.cljs$lang$applyTo;
G__9974.cljs$core$IFn$_invoke$arity$2 = G__9974__2;
G__9974.cljs$core$IFn$_invoke$arity$3 = G__9974__3;
G__9974.cljs$core$IFn$_invoke$arity$variadic = G__9974__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9974;
})()
});
fnil = function(f,x,y,z){
switch(arguments.length){
case 2:
return fnil__2.call(this,f,x);
case 3:
return fnil__3.call(this,f,x,y);
case 4:
return fnil__4.call(this,f,x,y,z);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fnil.cljs$core$IFn$_invoke$arity$2 = fnil__2;
fnil.cljs$core$IFn$_invoke$arity$3 = fnil__3;
fnil.cljs$core$IFn$_invoke$arity$4 = fnil__4;
return fnil;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to 0
* and the first item of coll, followed by applying f to 1 and the second
* item in coll, etc, until coll is exhausted. Thus function f should
* accept 2 arguments, index and item.
*/
cljs.core.map_indexed = (function() {
var map_indexed = null;
var map_indexed__1 = (function (f){
return (function (rf){
var i = (function (){var G__10010 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__10010) : cljs.core.volatile_BANG_.call(null,G__10010));
})();
return ((function (i){
return (function() {
var G__10040 = null;
var G__10040__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10040__1 = (function (result){
var G__10011 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10011) : rf.call(null,G__10011));
});
var G__10040__2 = (function (result,input){
var G__10012 = result;
var G__10013 = (function (){var G__10014 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__10015 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10014,G__10015) : f.call(null,G__10014,G__10015));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10012,G__10013) : rf.call(null,G__10012,G__10013));
});
G__10040 = function(result,input){
switch(arguments.length){
case 0:
return G__10040__0.call(this);
case 1:
return G__10040__1.call(this,result);
case 2:
return G__10040__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10040.cljs$core$IFn$_invoke$arity$0 = G__10040__0;
G__10040.cljs$core$IFn$_invoke$arity$1 = G__10040__1;
G__10040.cljs$core$IFn$_invoke$arity$2 = G__10040__2;
return G__10040;
})()
;})(i))
});
});
var map_indexed__2 = (function (f,coll){
var mapi = (function mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___10041 = size;
var i_10042 = (0);
while(true){
if((i_10042 < n__4645__auto___10041)){
cljs.core.chunk_append(b,(function (){var G__10036 = (idx + i_10042);
var G__10037 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10042);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10036,G__10037) : f.call(null,G__10036,G__10037));
})());

var G__10043 = (i_10042 + (1));
i_10042 = G__10043;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__10038 = idx;
var G__10039 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10038,G__10039) : f.call(null,G__10038,G__10039));
})(),mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});
map_indexed = function(f,coll){
switch(arguments.length){
case 1:
return map_indexed__1.call(this,f);
case 2:
return map_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map_indexed.cljs$core$IFn$_invoke$arity$1 = map_indexed__1;
map_indexed.cljs$core$IFn$_invoke$arity$2 = map_indexed__2;
return map_indexed;
})()
;
/**
* Returns a lazy sequence of the non-nil results of (f item). Note,
* this means false return values will be included.  f must be free of
* side-effects.  Returns a transducer when no collection is provided.
*/
cljs.core.keep = (function() {
var keep = null;
var keep__1 = (function (f){
return (function (rf){
return (function() {
var G__10062 = null;
var G__10062__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10062__1 = (function (result){
var G__10056 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10056) : rf.call(null,G__10056));
});
var G__10062__2 = (function (result,input){
var v = (function (){var G__10057 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10057) : f.call(null,G__10057));
})();
if((v == null)){
return result;
} else {
var G__10058 = result;
var G__10059 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10058,G__10059) : rf.call(null,G__10058,G__10059));
}
});
G__10062 = function(result,input){
switch(arguments.length){
case 0:
return G__10062__0.call(this);
case 1:
return G__10062__1.call(this,result);
case 2:
return G__10062__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10062.cljs$core$IFn$_invoke$arity$0 = G__10062__0;
G__10062.cljs$core$IFn$_invoke$arity$1 = G__10062__1;
G__10062.cljs$core$IFn$_invoke$arity$2 = G__10062__2;
return G__10062;
})()
});
});
var keep__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___10063 = size;
var i_10064 = (0);
while(true){
if((i_10064 < n__4645__auto___10063)){
var x_10065 = (function (){var G__10060 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10064);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10060) : f.call(null,G__10060));
})();
if((x_10065 == null)){
} else {
cljs.core.chunk_append(b,x_10065);
}

var G__10066 = (i_10064 + (1));
i_10064 = G__10066;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__10061 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10061) : f.call(null,G__10061));
})();
if((x == null)){
return keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
keep = function(f,coll){
switch(arguments.length){
case 1:
return keep__1.call(this,f);
case 2:
return keep__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keep.cljs$core$IFn$_invoke$arity$1 = keep__1;
keep.cljs$core$IFn$_invoke$arity$2 = keep__2;
return keep;
})()
;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
this.cljs$lang$protocol_mask$partition1$ = 16386;
})
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__10067 = this$__$1;
return goog.getUid(G__10067);
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__10068 = cljs.core.seq(self__.watches);
var chunk__10069 = null;
var count__10070 = (0);
var i__10071 = (0);
while(true){
if((i__10071 < count__10070)){
var vec__10072 = chunk__10069.cljs$core$IIndexed$_nth$arity$2(null,i__10071);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10072,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10072,(1),null);
var G__10073_10082 = key;
var G__10074_10083 = this$__$1;
var G__10075_10084 = oldval;
var G__10076_10085 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10073_10082,G__10074_10083,G__10075_10084,G__10076_10085) : f.call(null,G__10073_10082,G__10074_10083,G__10075_10084,G__10076_10085));

var G__10086 = seq__10068;
var G__10087 = chunk__10069;
var G__10088 = count__10070;
var G__10089 = (i__10071 + (1));
seq__10068 = G__10086;
chunk__10069 = G__10087;
count__10070 = G__10088;
i__10071 = G__10089;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10068);
if(temp__4126__auto__){
var seq__10068__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10068__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__10068__$1);
var G__10090 = cljs.core.chunk_rest(seq__10068__$1);
var G__10091 = c__4545__auto__;
var G__10092 = cljs.core.count(c__4545__auto__);
var G__10093 = (0);
seq__10068 = G__10090;
chunk__10069 = G__10091;
count__10070 = G__10092;
i__10071 = G__10093;
continue;
} else {
var vec__10077 = cljs.core.first(seq__10068__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10077,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10077,(1),null);
var G__10078_10094 = key;
var G__10079_10095 = this$__$1;
var G__10080_10096 = oldval;
var G__10081_10097 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__10078_10094,G__10079_10095,G__10080_10096,G__10081_10097) : f.call(null,G__10078_10094,G__10079_10095,G__10080_10096,G__10081_10097));

var G__10098 = cljs.core.next(seq__10068__$1);
var G__10099 = null;
var G__10100 = (0);
var G__10101 = (0);
seq__10068 = G__10098;
chunk__10069 = G__10099;
count__10070 = G__10100;
i__10071 = G__10101;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function __GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
* Creates and returns an Atom with an initial value of x and zero or
* more options (in any order):
* 
* :meta metadata-map
* 
* :validator validate-fn
* 
* If metadata-map is supplied, it will be come the metadata on the
* atom. validate-fn must be nil or a side-effect-free fn of one
* argument, which will be passed the intended new state on any state
* change. If the new state is unacceptable, the validate-fn should
* return false or throw an Error.  If either of these error conditions
* occur, then the value of the atom will not change.
* @param {...*} var_args
*/
cljs.core.atom = (function() {
var atom = null;
var atom__1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});
var atom__2 = (function() { 
var G__10105__delegate = function (x,p__10102){
var map__10104 = p__10102;
var map__10104__$1 = ((cljs.core.seq_QMARK_(map__10104))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10104):map__10104);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10104__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10104__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
return (new cljs.core.Atom(x,meta,validator,null));
};
var G__10105 = function (x,var_args){
var p__10102 = null;
if (arguments.length > 1) {
var G__10106__i = 0, G__10106__a = new Array(arguments.length -  1);
while (G__10106__i < G__10106__a.length) {G__10106__a[G__10106__i] = arguments[G__10106__i + 1]; ++G__10106__i;}
  p__10102 = new cljs.core.IndexedSeq(G__10106__a,0);
} 
return G__10105__delegate.call(this,x,p__10102);};
G__10105.cljs$lang$maxFixedArity = 1;
G__10105.cljs$lang$applyTo = (function (arglist__10107){
var x = cljs.core.first(arglist__10107);
var p__10102 = cljs.core.rest(arglist__10107);
return G__10105__delegate(x,p__10102);
});
G__10105.cljs$core$IFn$_invoke$arity$variadic = G__10105__delegate;
return G__10105;
})()
;
atom = function(x,var_args){
var p__10102 = var_args;
switch(arguments.length){
case 1:
return atom__1.call(this,x);
default:
var G__10108 = null;
if (arguments.length > 1) {
var G__10109__i = 0, G__10109__a = new Array(arguments.length -  1);
while (G__10109__i < G__10109__a.length) {G__10109__a[G__10109__i] = arguments[G__10109__i + 1]; ++G__10109__i;}
G__10108 = new cljs.core.IndexedSeq(G__10109__a,0);
}
return atom__2.cljs$core$IFn$_invoke$arity$variadic(x, G__10108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
atom.cljs$lang$maxFixedArity = 1;
atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
atom.cljs$core$IFn$_invoke$arity$1 = atom__1;
atom.cljs$core$IFn$_invoke$arity$variadic = atom__2.cljs$core$IFn$_invoke$arity$variadic;
return atom;
})()
;
/**
* Sets the value of atom to newval without regard for the
* current value. Returns newval.
*/
cljs.core.reset_BANG_ = (function reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__10112 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__10112) : validate.call(null,G__10112));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__10113 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__10113) : cljs.core.pr_str.call(null,G__10113));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
* Atomically swaps the value of atom to be:
* (apply f current-value-of-atom args). Note that f may be called
* multiple times, and thus should be free of side effects.  Returns
* the value that was swapped in.
* @param {...*} var_args
*/
cljs.core.swap_BANG_ = (function() {
var swap_BANG_ = null;
var swap_BANG___2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__10120 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10120) : f.call(null,G__10120));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});
var swap_BANG___3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__10121 = a.state;
var G__10122 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10121,G__10122) : f.call(null,G__10121,G__10122));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});
var swap_BANG___4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__10123 = a.state;
var G__10124 = x;
var G__10125 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__10123,G__10124,G__10125) : f.call(null,G__10123,G__10124,G__10125));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});
var swap_BANG___5 = (function() { 
var G__10126__delegate = function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
};
var G__10126 = function (a,f,x,y,var_args){
var more = null;
if (arguments.length > 4) {
var G__10127__i = 0, G__10127__a = new Array(arguments.length -  4);
while (G__10127__i < G__10127__a.length) {G__10127__a[G__10127__i] = arguments[G__10127__i + 4]; ++G__10127__i;}
  more = new cljs.core.IndexedSeq(G__10127__a,0);
} 
return G__10126__delegate.call(this,a,f,x,y,more);};
G__10126.cljs$lang$maxFixedArity = 4;
G__10126.cljs$lang$applyTo = (function (arglist__10128){
var a = cljs.core.first(arglist__10128);
arglist__10128 = cljs.core.next(arglist__10128);
var f = cljs.core.first(arglist__10128);
arglist__10128 = cljs.core.next(arglist__10128);
var x = cljs.core.first(arglist__10128);
arglist__10128 = cljs.core.next(arglist__10128);
var y = cljs.core.first(arglist__10128);
var more = cljs.core.rest(arglist__10128);
return G__10126__delegate(a,f,x,y,more);
});
G__10126.cljs$core$IFn$_invoke$arity$variadic = G__10126__delegate;
return G__10126;
})()
;
swap_BANG_ = function(a,f,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return swap_BANG___2.call(this,a,f);
case 3:
return swap_BANG___3.call(this,a,f,x);
case 4:
return swap_BANG___4.call(this,a,f,x,y);
default:
var G__10129 = null;
if (arguments.length > 4) {
var G__10130__i = 0, G__10130__a = new Array(arguments.length -  4);
while (G__10130__i < G__10130__a.length) {G__10130__a[G__10130__i] = arguments[G__10130__i + 4]; ++G__10130__i;}
G__10129 = new cljs.core.IndexedSeq(G__10130__a,0);
}
return swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic(a,f,x,y, G__10129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
swap_BANG_.cljs$lang$maxFixedArity = 4;
swap_BANG_.cljs$lang$applyTo = swap_BANG___5.cljs$lang$applyTo;
swap_BANG_.cljs$core$IFn$_invoke$arity$2 = swap_BANG___2;
swap_BANG_.cljs$core$IFn$_invoke$arity$3 = swap_BANG___3;
swap_BANG_.cljs$core$IFn$_invoke$arity$4 = swap_BANG___4;
swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic;
return swap_BANG_;
})()
;
/**
* Atomically sets the value of atom to newval if and only if the
* current value of the atom is equal to oldval. Returns true if
* set happened, else false.
*/
cljs.core.compare_and_set_BANG_ = (function compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
* Sets the validator-fn for an atom. validator-fn must be nil or a
* side-effect-free fn of one argument, which will be passed the intended
* new state on any state change. If the new state is unacceptable, the
* validator-fn should return false or throw an Error. If the current state
* is not acceptable to the new validator, an Error will be thrown and the
* validator will not be changed.
*/
cljs.core.set_validator_BANG_ = (function set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
* Gets the validator-fn for a var/ref/agent/atom.
*/
cljs.core.get_validator = (function get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function __GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
* Creates and returns a Volatile with an initial value of val.
*/
cljs.core.volatile_BANG_ = (function volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
* Returns true if x is a volatile.
*/
cljs.core.volatile_QMARK_ = (function volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
* Sets the value of volatile to newval without regard for the
* current value. Returns newval.
*/
cljs.core.vreset_BANG_ = (function vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
* Returns a lazy sequence of the non-nil results of (f index item). Note,
* this means false return values will be included.  f must be free of
* side-effects.  Returns a stateful transducer when no collection is
* provided.
*/
cljs.core.keep_indexed = (function() {
var keep_indexed = null;
var keep_indexed__1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__10197 = null;
var G__10197__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10197__1 = (function (result){
var G__10164 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10164) : rf.call(null,G__10164));
});
var G__10197__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (function (){var G__10165 = i;
var G__10166 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10165,G__10166) : f.call(null,G__10165,G__10166));
})();
if((v == null)){
return result;
} else {
var G__10167 = result;
var G__10168 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10167,G__10168) : rf.call(null,G__10167,G__10168));
}
});
G__10197 = function(result,input){
switch(arguments.length){
case 0:
return G__10197__0.call(this);
case 1:
return G__10197__1.call(this,result);
case 2:
return G__10197__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10197.cljs$core$IFn$_invoke$arity$0 = G__10197__0;
G__10197.cljs$core$IFn$_invoke$arity$1 = G__10197__1;
G__10197.cljs$core$IFn$_invoke$arity$2 = G__10197__2;
return G__10197;
})()
;})(ia))
});
});
var keep_indexed__2 = (function (f,coll){
var keepi = (function keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___10198 = size;
var i_10199 = (0);
while(true){
if((i_10199 < n__4645__auto___10198)){
var x_10200 = (function (){var G__10193 = (idx + i_10199);
var G__10194 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10199);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10193,G__10194) : f.call(null,G__10193,G__10194));
})();
if((x_10200 == null)){
} else {
cljs.core.chunk_append(b,x_10200);
}

var G__10201 = (i_10199 + (1));
i_10199 = G__10201;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__10195 = idx;
var G__10196 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10195,G__10196) : f.call(null,G__10195,G__10196));
})();
if((x == null)){
return keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});
keep_indexed = function(f,coll){
switch(arguments.length){
case 1:
return keep_indexed__1.call(this,f);
case 2:
return keep_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
keep_indexed.cljs$core$IFn$_invoke$arity$1 = keep_indexed__1;
keep_indexed.cljs$core$IFn$_invoke$arity$2 = keep_indexed__2;
return keep_indexed;
})()
;
/**
* Takes a set of predicates and returns a function f that returns true if all of its
* composing predicates return a logical true value against all of its arguments, else it returns
* false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical false result against the original predicates.
* @param {...*} var_args
*/
cljs.core.every_pred = (function() {
var every_pred = null;
var every_pred__1 = (function (p){
return (function() {
var ep1 = null;
var ep1__0 = (function (){
return true;
});
var ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__10415 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10415) : p.call(null,G__10415));
})());
});
var ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10417 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10417) : p.call(null,G__10417));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10418 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10418) : p.call(null,G__10418));
} else {
return and__3746__auto__;
}
})());
});
var ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10420 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10420) : p.call(null,G__10420));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10422 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10422) : p.call(null,G__10422));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10423 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10423) : p.call(null,G__10423));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep1__4 = (function() { 
var G__10592__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep1.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(p,args)));
};
var G__10592 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10593__i = 0, G__10593__a = new Array(arguments.length -  3);
while (G__10593__i < G__10593__a.length) {G__10593__a[G__10593__i] = arguments[G__10593__i + 3]; ++G__10593__i;}
  args = new cljs.core.IndexedSeq(G__10593__a,0);
} 
return G__10592__delegate.call(this,x,y,z,args);};
G__10592.cljs$lang$maxFixedArity = 3;
G__10592.cljs$lang$applyTo = (function (arglist__10594){
var x = cljs.core.first(arglist__10594);
arglist__10594 = cljs.core.next(arglist__10594);
var y = cljs.core.first(arglist__10594);
arglist__10594 = cljs.core.next(arglist__10594);
var z = cljs.core.first(arglist__10594);
var args = cljs.core.rest(arglist__10594);
return G__10592__delegate(x,y,z,args);
});
G__10592.cljs$core$IFn$_invoke$arity$variadic = G__10592__delegate;
return G__10592;
})()
;
ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep1__0.call(this);
case 1:
return ep1__1.call(this,x);
case 2:
return ep1__2.call(this,x,y);
case 3:
return ep1__3.call(this,x,y,z);
default:
var G__10595 = null;
if (arguments.length > 3) {
var G__10596__i = 0, G__10596__a = new Array(arguments.length -  3);
while (G__10596__i < G__10596__a.length) {G__10596__a[G__10596__i] = arguments[G__10596__i + 3]; ++G__10596__i;}
G__10595 = new cljs.core.IndexedSeq(G__10596__a,0);
}
return ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep1.cljs$lang$maxFixedArity = 3;
ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
ep1.cljs$core$IFn$_invoke$arity$0 = ep1__0;
ep1.cljs$core$IFn$_invoke$arity$1 = ep1__1;
ep1.cljs$core$IFn$_invoke$arity$2 = ep1__2;
ep1.cljs$core$IFn$_invoke$arity$3 = ep1__3;
ep1.cljs$core$IFn$_invoke$arity$variadic = ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return ep1;
})()
});
var every_pred__2 = (function (p1,p2){
return (function() {
var ep2 = null;
var ep2__0 = (function (){
return true;
});
var ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10455 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10455) : p1.call(null,G__10455));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10456 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10456) : p2.call(null,G__10456));
} else {
return and__3746__auto__;
}
})());
});
var ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10458 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10458) : p1.call(null,G__10458));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10460 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10460) : p1.call(null,G__10460));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10462 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10462) : p2.call(null,G__10462));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var G__10463 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10463) : p2.call(null,G__10463));
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10465 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10465) : p1.call(null,G__10465));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10467 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10467) : p1.call(null,G__10467));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10469 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10469) : p1.call(null,G__10469));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var and__3746__auto____$3 = (function (){var G__10471 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10471) : p2.call(null,G__10471));
})();
if(cljs.core.truth_(and__3746__auto____$3)){
var and__3746__auto____$4 = (function (){var G__10473 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10473) : p2.call(null,G__10473));
})();
if(cljs.core.truth_(and__3746__auto____$4)){
var G__10474 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10474) : p2.call(null,G__10474));
} else {
return and__3746__auto____$4;
}
} else {
return and__3746__auto____$3;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep2__4 = (function() { 
var G__10597__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep2.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__10202_SHARP_){
var and__3746__auto__ = (function (){var G__10479 = p1__10202_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10479) : p1.call(null,G__10479));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10480 = p1__10202_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10480) : p2.call(null,G__10480));
} else {
return and__3746__auto__;
}
}),args)));
};
var G__10597 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10598__i = 0, G__10598__a = new Array(arguments.length -  3);
while (G__10598__i < G__10598__a.length) {G__10598__a[G__10598__i] = arguments[G__10598__i + 3]; ++G__10598__i;}
  args = new cljs.core.IndexedSeq(G__10598__a,0);
} 
return G__10597__delegate.call(this,x,y,z,args);};
G__10597.cljs$lang$maxFixedArity = 3;
G__10597.cljs$lang$applyTo = (function (arglist__10599){
var x = cljs.core.first(arglist__10599);
arglist__10599 = cljs.core.next(arglist__10599);
var y = cljs.core.first(arglist__10599);
arglist__10599 = cljs.core.next(arglist__10599);
var z = cljs.core.first(arglist__10599);
var args = cljs.core.rest(arglist__10599);
return G__10597__delegate(x,y,z,args);
});
G__10597.cljs$core$IFn$_invoke$arity$variadic = G__10597__delegate;
return G__10597;
})()
;
ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep2__0.call(this);
case 1:
return ep2__1.call(this,x);
case 2:
return ep2__2.call(this,x,y);
case 3:
return ep2__3.call(this,x,y,z);
default:
var G__10600 = null;
if (arguments.length > 3) {
var G__10601__i = 0, G__10601__a = new Array(arguments.length -  3);
while (G__10601__i < G__10601__a.length) {G__10601__a[G__10601__i] = arguments[G__10601__i + 3]; ++G__10601__i;}
G__10600 = new cljs.core.IndexedSeq(G__10601__a,0);
}
return ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep2.cljs$lang$maxFixedArity = 3;
ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
ep2.cljs$core$IFn$_invoke$arity$0 = ep2__0;
ep2.cljs$core$IFn$_invoke$arity$1 = ep2__1;
ep2.cljs$core$IFn$_invoke$arity$2 = ep2__2;
ep2.cljs$core$IFn$_invoke$arity$3 = ep2__3;
ep2.cljs$core$IFn$_invoke$arity$variadic = ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return ep2;
})()
});
var every_pred__3 = (function (p1,p2,p3){
return (function() {
var ep3 = null;
var ep3__0 = (function (){
return true;
});
var ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10526 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10526) : p1.call(null,G__10526));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10528 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10528) : p2.call(null,G__10528));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10529 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10529) : p3.call(null,G__10529));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10531 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10531) : p1.call(null,G__10531));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10533 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10533) : p2.call(null,G__10533));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10535 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10535) : p3.call(null,G__10535));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var and__3746__auto____$3 = (function (){var G__10537 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10537) : p1.call(null,G__10537));
})();
if(cljs.core.truth_(and__3746__auto____$3)){
var and__3746__auto____$4 = (function (){var G__10539 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10539) : p2.call(null,G__10539));
})();
if(cljs.core.truth_(and__3746__auto____$4)){
var G__10540 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10540) : p3.call(null,G__10540));
} else {
return and__3746__auto____$4;
}
} else {
return and__3746__auto____$3;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3746__auto__ = (function (){var G__10542 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10542) : p1.call(null,G__10542));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10544 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10544) : p2.call(null,G__10544));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var and__3746__auto____$2 = (function (){var G__10546 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10546) : p3.call(null,G__10546));
})();
if(cljs.core.truth_(and__3746__auto____$2)){
var and__3746__auto____$3 = (function (){var G__10548 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10548) : p1.call(null,G__10548));
})();
if(cljs.core.truth_(and__3746__auto____$3)){
var and__3746__auto____$4 = (function (){var G__10550 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10550) : p2.call(null,G__10550));
})();
if(cljs.core.truth_(and__3746__auto____$4)){
var and__3746__auto____$5 = (function (){var G__10552 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10552) : p3.call(null,G__10552));
})();
if(cljs.core.truth_(and__3746__auto____$5)){
var and__3746__auto____$6 = (function (){var G__10554 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10554) : p1.call(null,G__10554));
})();
if(cljs.core.truth_(and__3746__auto____$6)){
var and__3746__auto____$7 = (function (){var G__10556 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10556) : p2.call(null,G__10556));
})();
if(cljs.core.truth_(and__3746__auto____$7)){
var G__10557 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10557) : p3.call(null,G__10557));
} else {
return and__3746__auto____$7;
}
} else {
return and__3746__auto____$6;
}
} else {
return and__3746__auto____$5;
}
} else {
return and__3746__auto____$4;
}
} else {
return and__3746__auto____$3;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})());
});
var ep3__4 = (function() { 
var G__10602__delegate = function (x,y,z,args){
return cljs.core.boolean$((ep3.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__10203_SHARP_){
var and__3746__auto__ = (function (){var G__10564 = p1__10203_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10564) : p1.call(null,G__10564));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10566 = p1__10203_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10566) : p2.call(null,G__10566));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10567 = p1__10203_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10567) : p3.call(null,G__10567));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
}),args)));
};
var G__10602 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10603__i = 0, G__10603__a = new Array(arguments.length -  3);
while (G__10603__i < G__10603__a.length) {G__10603__a[G__10603__i] = arguments[G__10603__i + 3]; ++G__10603__i;}
  args = new cljs.core.IndexedSeq(G__10603__a,0);
} 
return G__10602__delegate.call(this,x,y,z,args);};
G__10602.cljs$lang$maxFixedArity = 3;
G__10602.cljs$lang$applyTo = (function (arglist__10604){
var x = cljs.core.first(arglist__10604);
arglist__10604 = cljs.core.next(arglist__10604);
var y = cljs.core.first(arglist__10604);
arglist__10604 = cljs.core.next(arglist__10604);
var z = cljs.core.first(arglist__10604);
var args = cljs.core.rest(arglist__10604);
return G__10602__delegate(x,y,z,args);
});
G__10602.cljs$core$IFn$_invoke$arity$variadic = G__10602__delegate;
return G__10602;
})()
;
ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep3__0.call(this);
case 1:
return ep3__1.call(this,x);
case 2:
return ep3__2.call(this,x,y);
case 3:
return ep3__3.call(this,x,y,z);
default:
var G__10605 = null;
if (arguments.length > 3) {
var G__10606__i = 0, G__10606__a = new Array(arguments.length -  3);
while (G__10606__i < G__10606__a.length) {G__10606__a[G__10606__i] = arguments[G__10606__i + 3]; ++G__10606__i;}
G__10605 = new cljs.core.IndexedSeq(G__10606__a,0);
}
return ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ep3.cljs$lang$maxFixedArity = 3;
ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
ep3.cljs$core$IFn$_invoke$arity$0 = ep3__0;
ep3.cljs$core$IFn$_invoke$arity$1 = ep3__1;
ep3.cljs$core$IFn$_invoke$arity$2 = ep3__2;
ep3.cljs$core$IFn$_invoke$arity$3 = ep3__3;
ep3.cljs$core$IFn$_invoke$arity$variadic = ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return ep3;
})()
});
var every_pred__4 = (function() { 
var G__10607__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var epn = null;
var epn__0 = (function (){
return true;
});
var epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10204_SHARP_){
var G__10583 = x;
return (p1__10204_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10204_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10583) : p1__10204_SHARP_.call(null,G__10583));
});})(ps__$1))
,ps__$1);
});
var epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10205_SHARP_){
var and__3746__auto__ = (function (){var G__10585 = x;
return (p1__10205_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10205_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10585) : p1__10205_SHARP_.call(null,G__10585));
})();
if(cljs.core.truth_(and__3746__auto__)){
var G__10586 = y;
return (p1__10205_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10205_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10586) : p1__10205_SHARP_.call(null,G__10586));
} else {
return and__3746__auto__;
}
});})(ps__$1))
,ps__$1);
});
var epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10206_SHARP_){
var and__3746__auto__ = (function (){var G__10588 = x;
return (p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10588) : p1__10206_SHARP_.call(null,G__10588));
})();
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__10590 = y;
return (p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10590) : p1__10206_SHARP_.call(null,G__10590));
})();
if(cljs.core.truth_(and__3746__auto____$1)){
var G__10591 = z;
return (p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10206_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10591) : p1__10206_SHARP_.call(null,G__10591));
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
});})(ps__$1))
,ps__$1);
});
var epn__4 = (function() { 
var G__10608__delegate = function (x,y,z,args){
return cljs.core.boolean$((epn.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__10207_SHARP_){
return cljs.core.every_QMARK_(p1__10207_SHARP_,args);
});})(ps__$1))
,ps__$1)));
};
var G__10608 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10609__i = 0, G__10609__a = new Array(arguments.length -  3);
while (G__10609__i < G__10609__a.length) {G__10609__a[G__10609__i] = arguments[G__10609__i + 3]; ++G__10609__i;}
  args = new cljs.core.IndexedSeq(G__10609__a,0);
} 
return G__10608__delegate.call(this,x,y,z,args);};
G__10608.cljs$lang$maxFixedArity = 3;
G__10608.cljs$lang$applyTo = (function (arglist__10610){
var x = cljs.core.first(arglist__10610);
arglist__10610 = cljs.core.next(arglist__10610);
var y = cljs.core.first(arglist__10610);
arglist__10610 = cljs.core.next(arglist__10610);
var z = cljs.core.first(arglist__10610);
var args = cljs.core.rest(arglist__10610);
return G__10608__delegate(x,y,z,args);
});
G__10608.cljs$core$IFn$_invoke$arity$variadic = G__10608__delegate;
return G__10608;
})()
;
epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return epn__0.call(this);
case 1:
return epn__1.call(this,x);
case 2:
return epn__2.call(this,x,y);
case 3:
return epn__3.call(this,x,y,z);
default:
var G__10611 = null;
if (arguments.length > 3) {
var G__10612__i = 0, G__10612__a = new Array(arguments.length -  3);
while (G__10612__i < G__10612__a.length) {G__10612__a[G__10612__i] = arguments[G__10612__i + 3]; ++G__10612__i;}
G__10611 = new cljs.core.IndexedSeq(G__10612__a,0);
}
return epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
epn.cljs$lang$maxFixedArity = 3;
epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
epn.cljs$core$IFn$_invoke$arity$0 = epn__0;
epn.cljs$core$IFn$_invoke$arity$1 = epn__1;
epn.cljs$core$IFn$_invoke$arity$2 = epn__2;
epn.cljs$core$IFn$_invoke$arity$3 = epn__3;
epn.cljs$core$IFn$_invoke$arity$variadic = epn__4.cljs$core$IFn$_invoke$arity$variadic;
return epn;
})()
;})(ps__$1))
};
var G__10607 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__10613__i = 0, G__10613__a = new Array(arguments.length -  3);
while (G__10613__i < G__10613__a.length) {G__10613__a[G__10613__i] = arguments[G__10613__i + 3]; ++G__10613__i;}
  ps = new cljs.core.IndexedSeq(G__10613__a,0);
} 
return G__10607__delegate.call(this,p1,p2,p3,ps);};
G__10607.cljs$lang$maxFixedArity = 3;
G__10607.cljs$lang$applyTo = (function (arglist__10614){
var p1 = cljs.core.first(arglist__10614);
arglist__10614 = cljs.core.next(arglist__10614);
var p2 = cljs.core.first(arglist__10614);
arglist__10614 = cljs.core.next(arglist__10614);
var p3 = cljs.core.first(arglist__10614);
var ps = cljs.core.rest(arglist__10614);
return G__10607__delegate(p1,p2,p3,ps);
});
G__10607.cljs$core$IFn$_invoke$arity$variadic = G__10607__delegate;
return G__10607;
})()
;
every_pred = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return every_pred__1.call(this,p1);
case 2:
return every_pred__2.call(this,p1,p2);
case 3:
return every_pred__3.call(this,p1,p2,p3);
default:
var G__10615 = null;
if (arguments.length > 3) {
var G__10616__i = 0, G__10616__a = new Array(arguments.length -  3);
while (G__10616__i < G__10616__a.length) {G__10616__a[G__10616__i] = arguments[G__10616__i + 3]; ++G__10616__i;}
G__10615 = new cljs.core.IndexedSeq(G__10616__a,0);
}
return every_pred__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__10615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
every_pred.cljs$lang$maxFixedArity = 3;
every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
every_pred.cljs$core$IFn$_invoke$arity$1 = every_pred__1;
every_pred.cljs$core$IFn$_invoke$arity$2 = every_pred__2;
every_pred.cljs$core$IFn$_invoke$arity$3 = every_pred__3;
every_pred.cljs$core$IFn$_invoke$arity$variadic = every_pred__4.cljs$core$IFn$_invoke$arity$variadic;
return every_pred;
})()
;
/**
* Takes a set of predicates and returns a function f that returns the first logical true value
* returned by one of its composing predicates against any of its arguments, else it returns
* logical false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical true result against the original predicates.
* @param {...*} var_args
*/
cljs.core.some_fn = (function() {
var some_fn = null;
var some_fn__1 = (function (p){
return (function() {
var sp1 = null;
var sp1__0 = (function (){
return null;
});
var sp1__1 = (function (x){
var G__10822 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10822) : p.call(null,G__10822));
});
var sp1__2 = (function (x,y){
var or__3758__auto__ = (function (){var G__10824 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10824) : p.call(null,G__10824));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__10825 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10825) : p.call(null,G__10825));
}
});
var sp1__3 = (function (x,y,z){
var or__3758__auto__ = (function (){var G__10827 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10827) : p.call(null,G__10827));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10829 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10829) : p.call(null,G__10829));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10830 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__10830) : p.call(null,G__10830));
}
}
});
var sp1__4 = (function() { 
var G__10991__delegate = function (x,y,z,args){
var or__3758__auto__ = sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__10991 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10992__i = 0, G__10992__a = new Array(arguments.length -  3);
while (G__10992__i < G__10992__a.length) {G__10992__a[G__10992__i] = arguments[G__10992__i + 3]; ++G__10992__i;}
  args = new cljs.core.IndexedSeq(G__10992__a,0);
} 
return G__10991__delegate.call(this,x,y,z,args);};
G__10991.cljs$lang$maxFixedArity = 3;
G__10991.cljs$lang$applyTo = (function (arglist__10993){
var x = cljs.core.first(arglist__10993);
arglist__10993 = cljs.core.next(arglist__10993);
var y = cljs.core.first(arglist__10993);
arglist__10993 = cljs.core.next(arglist__10993);
var z = cljs.core.first(arglist__10993);
var args = cljs.core.rest(arglist__10993);
return G__10991__delegate(x,y,z,args);
});
G__10991.cljs$core$IFn$_invoke$arity$variadic = G__10991__delegate;
return G__10991;
})()
;
sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp1__0.call(this);
case 1:
return sp1__1.call(this,x);
case 2:
return sp1__2.call(this,x,y);
case 3:
return sp1__3.call(this,x,y,z);
default:
var G__10994 = null;
if (arguments.length > 3) {
var G__10995__i = 0, G__10995__a = new Array(arguments.length -  3);
while (G__10995__i < G__10995__a.length) {G__10995__a[G__10995__i] = arguments[G__10995__i + 3]; ++G__10995__i;}
G__10994 = new cljs.core.IndexedSeq(G__10995__a,0);
}
return sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp1.cljs$lang$maxFixedArity = 3;
sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
sp1.cljs$core$IFn$_invoke$arity$0 = sp1__0;
sp1.cljs$core$IFn$_invoke$arity$1 = sp1__1;
sp1.cljs$core$IFn$_invoke$arity$2 = sp1__2;
sp1.cljs$core$IFn$_invoke$arity$3 = sp1__3;
sp1.cljs$core$IFn$_invoke$arity$variadic = sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return sp1;
})()
});
var some_fn__2 = (function (p1,p2){
return (function() {
var sp2 = null;
var sp2__0 = (function (){
return null;
});
var sp2__1 = (function (x){
var or__3758__auto__ = (function (){var G__10862 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10862) : p1.call(null,G__10862));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__10863 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10863) : p2.call(null,G__10863));
}
});
var sp2__2 = (function (x,y){
var or__3758__auto__ = (function (){var G__10865 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10865) : p1.call(null,G__10865));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10867 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10867) : p1.call(null,G__10867));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10869 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10869) : p2.call(null,G__10869));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var G__10870 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10870) : p2.call(null,G__10870));
}
}
}
});
var sp2__3 = (function (x,y,z){
var or__3758__auto__ = (function (){var G__10872 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10872) : p1.call(null,G__10872));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10874 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10874) : p1.call(null,G__10874));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10876 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10876) : p1.call(null,G__10876));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var or__3758__auto____$3 = (function (){var G__10878 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10878) : p2.call(null,G__10878));
})();
if(cljs.core.truth_(or__3758__auto____$3)){
return or__3758__auto____$3;
} else {
var or__3758__auto____$4 = (function (){var G__10880 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10880) : p2.call(null,G__10880));
})();
if(cljs.core.truth_(or__3758__auto____$4)){
return or__3758__auto____$4;
} else {
var G__10881 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10881) : p2.call(null,G__10881));
}
}
}
}
}
});
var sp2__4 = (function() { 
var G__10996__delegate = function (x,y,z,args){
var or__3758__auto__ = sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(((function (or__3758__auto__){
return (function (p1__10617_SHARP_){
var or__3758__auto____$1 = (function (){var G__10883 = p1__10617_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10883) : p1.call(null,G__10883));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10884 = p1__10617_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10884) : p2.call(null,G__10884));
}
});})(or__3758__auto__))
,args);
}
};
var G__10996 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__10997__i = 0, G__10997__a = new Array(arguments.length -  3);
while (G__10997__i < G__10997__a.length) {G__10997__a[G__10997__i] = arguments[G__10997__i + 3]; ++G__10997__i;}
  args = new cljs.core.IndexedSeq(G__10997__a,0);
} 
return G__10996__delegate.call(this,x,y,z,args);};
G__10996.cljs$lang$maxFixedArity = 3;
G__10996.cljs$lang$applyTo = (function (arglist__10998){
var x = cljs.core.first(arglist__10998);
arglist__10998 = cljs.core.next(arglist__10998);
var y = cljs.core.first(arglist__10998);
arglist__10998 = cljs.core.next(arglist__10998);
var z = cljs.core.first(arglist__10998);
var args = cljs.core.rest(arglist__10998);
return G__10996__delegate(x,y,z,args);
});
G__10996.cljs$core$IFn$_invoke$arity$variadic = G__10996__delegate;
return G__10996;
})()
;
sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp2__0.call(this);
case 1:
return sp2__1.call(this,x);
case 2:
return sp2__2.call(this,x,y);
case 3:
return sp2__3.call(this,x,y,z);
default:
var G__10999 = null;
if (arguments.length > 3) {
var G__11000__i = 0, G__11000__a = new Array(arguments.length -  3);
while (G__11000__i < G__11000__a.length) {G__11000__a[G__11000__i] = arguments[G__11000__i + 3]; ++G__11000__i;}
G__10999 = new cljs.core.IndexedSeq(G__11000__a,0);
}
return sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp2.cljs$lang$maxFixedArity = 3;
sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
sp2.cljs$core$IFn$_invoke$arity$0 = sp2__0;
sp2.cljs$core$IFn$_invoke$arity$1 = sp2__1;
sp2.cljs$core$IFn$_invoke$arity$2 = sp2__2;
sp2.cljs$core$IFn$_invoke$arity$3 = sp2__3;
sp2.cljs$core$IFn$_invoke$arity$variadic = sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return sp2;
})()
});
var some_fn__3 = (function (p1,p2,p3){
return (function() {
var sp3 = null;
var sp3__0 = (function (){
return null;
});
var sp3__1 = (function (x){
var or__3758__auto__ = (function (){var G__10930 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10930) : p1.call(null,G__10930));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10932 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10932) : p2.call(null,G__10932));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10933 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10933) : p3.call(null,G__10933));
}
}
});
var sp3__2 = (function (x,y){
var or__3758__auto__ = (function (){var G__10935 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10935) : p1.call(null,G__10935));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10937 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10937) : p2.call(null,G__10937));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10939 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10939) : p3.call(null,G__10939));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var or__3758__auto____$3 = (function (){var G__10941 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10941) : p1.call(null,G__10941));
})();
if(cljs.core.truth_(or__3758__auto____$3)){
return or__3758__auto____$3;
} else {
var or__3758__auto____$4 = (function (){var G__10943 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10943) : p2.call(null,G__10943));
})();
if(cljs.core.truth_(or__3758__auto____$4)){
return or__3758__auto____$4;
} else {
var G__10944 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10944) : p3.call(null,G__10944));
}
}
}
}
}
});
var sp3__3 = (function (x,y,z){
var or__3758__auto__ = (function (){var G__10946 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10946) : p1.call(null,G__10946));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10948 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10948) : p2.call(null,G__10948));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10950 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10950) : p3.call(null,G__10950));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var or__3758__auto____$3 = (function (){var G__10952 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10952) : p1.call(null,G__10952));
})();
if(cljs.core.truth_(or__3758__auto____$3)){
return or__3758__auto____$3;
} else {
var or__3758__auto____$4 = (function (){var G__10954 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10954) : p2.call(null,G__10954));
})();
if(cljs.core.truth_(or__3758__auto____$4)){
return or__3758__auto____$4;
} else {
var or__3758__auto____$5 = (function (){var G__10956 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10956) : p3.call(null,G__10956));
})();
if(cljs.core.truth_(or__3758__auto____$5)){
return or__3758__auto____$5;
} else {
var or__3758__auto____$6 = (function (){var G__10958 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10958) : p1.call(null,G__10958));
})();
if(cljs.core.truth_(or__3758__auto____$6)){
return or__3758__auto____$6;
} else {
var or__3758__auto____$7 = (function (){var G__10960 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10960) : p2.call(null,G__10960));
})();
if(cljs.core.truth_(or__3758__auto____$7)){
return or__3758__auto____$7;
} else {
var G__10961 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10961) : p3.call(null,G__10961));
}
}
}
}
}
}
}
}
});
var sp3__4 = (function() { 
var G__11001__delegate = function (x,y,z,args){
var or__3758__auto__ = sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(((function (or__3758__auto__){
return (function (p1__10618_SHARP_){
var or__3758__auto____$1 = (function (){var G__10963 = p1__10618_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__10963) : p1.call(null,G__10963));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var G__10965 = p1__10618_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__10965) : p2.call(null,G__10965));
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
var G__10966 = p1__10618_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__10966) : p3.call(null,G__10966));
}
}
});})(or__3758__auto__))
,args);
}
};
var G__11001 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11002__i = 0, G__11002__a = new Array(arguments.length -  3);
while (G__11002__i < G__11002__a.length) {G__11002__a[G__11002__i] = arguments[G__11002__i + 3]; ++G__11002__i;}
  args = new cljs.core.IndexedSeq(G__11002__a,0);
} 
return G__11001__delegate.call(this,x,y,z,args);};
G__11001.cljs$lang$maxFixedArity = 3;
G__11001.cljs$lang$applyTo = (function (arglist__11003){
var x = cljs.core.first(arglist__11003);
arglist__11003 = cljs.core.next(arglist__11003);
var y = cljs.core.first(arglist__11003);
arglist__11003 = cljs.core.next(arglist__11003);
var z = cljs.core.first(arglist__11003);
var args = cljs.core.rest(arglist__11003);
return G__11001__delegate(x,y,z,args);
});
G__11001.cljs$core$IFn$_invoke$arity$variadic = G__11001__delegate;
return G__11001;
})()
;
sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp3__0.call(this);
case 1:
return sp3__1.call(this,x);
case 2:
return sp3__2.call(this,x,y);
case 3:
return sp3__3.call(this,x,y,z);
default:
var G__11004 = null;
if (arguments.length > 3) {
var G__11005__i = 0, G__11005__a = new Array(arguments.length -  3);
while (G__11005__i < G__11005__a.length) {G__11005__a[G__11005__i] = arguments[G__11005__i + 3]; ++G__11005__i;}
G__11004 = new cljs.core.IndexedSeq(G__11005__a,0);
}
return sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sp3.cljs$lang$maxFixedArity = 3;
sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
sp3.cljs$core$IFn$_invoke$arity$0 = sp3__0;
sp3.cljs$core$IFn$_invoke$arity$1 = sp3__1;
sp3.cljs$core$IFn$_invoke$arity$2 = sp3__2;
sp3.cljs$core$IFn$_invoke$arity$3 = sp3__3;
sp3.cljs$core$IFn$_invoke$arity$variadic = sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return sp3;
})()
});
var some_fn__4 = (function() { 
var G__11006__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var spn = null;
var spn__0 = (function (){
return null;
});
var spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__10619_SHARP_){
var G__10982 = x;
return (p1__10619_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10619_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10982) : p1__10619_SHARP_.call(null,G__10982));
});})(ps__$1))
,ps__$1);
});
var spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__10620_SHARP_){
var or__3758__auto__ = (function (){var G__10984 = x;
return (p1__10620_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10620_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10984) : p1__10620_SHARP_.call(null,G__10984));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var G__10985 = y;
return (p1__10620_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10620_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10985) : p1__10620_SHARP_.call(null,G__10985));
}
});})(ps__$1))
,ps__$1);
});
var spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__10621_SHARP_){
var or__3758__auto__ = (function (){var G__10987 = x;
return (p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10987) : p1__10621_SHARP_.call(null,G__10987));
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var G__10989 = y;
return (p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10989) : p1__10621_SHARP_.call(null,G__10989));
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var G__10990 = z;
return (p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__10621_SHARP_.cljs$core$IFn$_invoke$arity$1(G__10990) : p1__10621_SHARP_.call(null,G__10990));
}
}
});})(ps__$1))
,ps__$1);
});
var spn__4 = (function() { 
var G__11007__delegate = function (x,y,z,args){
var or__3758__auto__ = spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.some(((function (or__3758__auto__,ps__$1){
return (function (p1__10622_SHARP_){
return cljs.core.some(p1__10622_SHARP_,args);
});})(or__3758__auto__,ps__$1))
,ps__$1);
}
};
var G__11007 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11008__i = 0, G__11008__a = new Array(arguments.length -  3);
while (G__11008__i < G__11008__a.length) {G__11008__a[G__11008__i] = arguments[G__11008__i + 3]; ++G__11008__i;}
  args = new cljs.core.IndexedSeq(G__11008__a,0);
} 
return G__11007__delegate.call(this,x,y,z,args);};
G__11007.cljs$lang$maxFixedArity = 3;
G__11007.cljs$lang$applyTo = (function (arglist__11009){
var x = cljs.core.first(arglist__11009);
arglist__11009 = cljs.core.next(arglist__11009);
var y = cljs.core.first(arglist__11009);
arglist__11009 = cljs.core.next(arglist__11009);
var z = cljs.core.first(arglist__11009);
var args = cljs.core.rest(arglist__11009);
return G__11007__delegate(x,y,z,args);
});
G__11007.cljs$core$IFn$_invoke$arity$variadic = G__11007__delegate;
return G__11007;
})()
;
spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return spn__0.call(this);
case 1:
return spn__1.call(this,x);
case 2:
return spn__2.call(this,x,y);
case 3:
return spn__3.call(this,x,y,z);
default:
var G__11010 = null;
if (arguments.length > 3) {
var G__11011__i = 0, G__11011__a = new Array(arguments.length -  3);
while (G__11011__i < G__11011__a.length) {G__11011__a[G__11011__i] = arguments[G__11011__i + 3]; ++G__11011__i;}
G__11010 = new cljs.core.IndexedSeq(G__11011__a,0);
}
return spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
spn.cljs$lang$maxFixedArity = 3;
spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
spn.cljs$core$IFn$_invoke$arity$0 = spn__0;
spn.cljs$core$IFn$_invoke$arity$1 = spn__1;
spn.cljs$core$IFn$_invoke$arity$2 = spn__2;
spn.cljs$core$IFn$_invoke$arity$3 = spn__3;
spn.cljs$core$IFn$_invoke$arity$variadic = spn__4.cljs$core$IFn$_invoke$arity$variadic;
return spn;
})()
;})(ps__$1))
};
var G__11006 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__11012__i = 0, G__11012__a = new Array(arguments.length -  3);
while (G__11012__i < G__11012__a.length) {G__11012__a[G__11012__i] = arguments[G__11012__i + 3]; ++G__11012__i;}
  ps = new cljs.core.IndexedSeq(G__11012__a,0);
} 
return G__11006__delegate.call(this,p1,p2,p3,ps);};
G__11006.cljs$lang$maxFixedArity = 3;
G__11006.cljs$lang$applyTo = (function (arglist__11013){
var p1 = cljs.core.first(arglist__11013);
arglist__11013 = cljs.core.next(arglist__11013);
var p2 = cljs.core.first(arglist__11013);
arglist__11013 = cljs.core.next(arglist__11013);
var p3 = cljs.core.first(arglist__11013);
var ps = cljs.core.rest(arglist__11013);
return G__11006__delegate(p1,p2,p3,ps);
});
G__11006.cljs$core$IFn$_invoke$arity$variadic = G__11006__delegate;
return G__11006;
})()
;
some_fn = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return some_fn__1.call(this,p1);
case 2:
return some_fn__2.call(this,p1,p2);
case 3:
return some_fn__3.call(this,p1,p2,p3);
default:
var G__11014 = null;
if (arguments.length > 3) {
var G__11015__i = 0, G__11015__a = new Array(arguments.length -  3);
while (G__11015__i < G__11015__a.length) {G__11015__a[G__11015__i] = arguments[G__11015__i + 3]; ++G__11015__i;}
G__11014 = new cljs.core.IndexedSeq(G__11015__a,0);
}
return some_fn__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__11014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
some_fn.cljs$lang$maxFixedArity = 3;
some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
some_fn.cljs$core$IFn$_invoke$arity$1 = some_fn__1;
some_fn.cljs$core$IFn$_invoke$arity$2 = some_fn__2;
some_fn.cljs$core$IFn$_invoke$arity$3 = some_fn__3;
some_fn.cljs$core$IFn$_invoke$arity$variadic = some_fn__4.cljs$core$IFn$_invoke$arity$variadic;
return some_fn;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to
* the set of first items of each coll, followed by applying f to the
* set of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments. Returns a transducer when
* no collection is provided.
* @param {...*} var_args
*/
cljs.core.map = (function() {
var map = null;
var map__1 = (function (f){
return (function (rf){
return (function() {
var G__11070 = null;
var G__11070__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11070__1 = (function (result){
var G__11056 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11056) : rf.call(null,G__11056));
});
var G__11070__2 = (function (result,input){
var G__11057 = result;
var G__11058 = (function (){var G__11059 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11059) : f.call(null,G__11059));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11057,G__11058) : rf.call(null,G__11057,G__11058));
});
var G__11070__3 = (function() { 
var G__11071__delegate = function (result,input,inputs){
var G__11060 = result;
var G__11061 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11060,G__11061) : rf.call(null,G__11060,G__11061));
};
var G__11071 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__11072__i = 0, G__11072__a = new Array(arguments.length -  2);
while (G__11072__i < G__11072__a.length) {G__11072__a[G__11072__i] = arguments[G__11072__i + 2]; ++G__11072__i;}
  inputs = new cljs.core.IndexedSeq(G__11072__a,0);
} 
return G__11071__delegate.call(this,result,input,inputs);};
G__11071.cljs$lang$maxFixedArity = 2;
G__11071.cljs$lang$applyTo = (function (arglist__11073){
var result = cljs.core.first(arglist__11073);
arglist__11073 = cljs.core.next(arglist__11073);
var input = cljs.core.first(arglist__11073);
var inputs = cljs.core.rest(arglist__11073);
return G__11071__delegate(result,input,inputs);
});
G__11071.cljs$core$IFn$_invoke$arity$variadic = G__11071__delegate;
return G__11071;
})()
;
G__11070 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__11070__0.call(this);
case 1:
return G__11070__1.call(this,result);
case 2:
return G__11070__2.call(this,result,input);
default:
var G__11074 = null;
if (arguments.length > 2) {
var G__11075__i = 0, G__11075__a = new Array(arguments.length -  2);
while (G__11075__i < G__11075__a.length) {G__11075__a[G__11075__i] = arguments[G__11075__i + 2]; ++G__11075__i;}
G__11074 = new cljs.core.IndexedSeq(G__11075__a,0);
}
return G__11070__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__11074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11070.cljs$lang$maxFixedArity = 2;
G__11070.cljs$lang$applyTo = G__11070__3.cljs$lang$applyTo;
G__11070.cljs$core$IFn$_invoke$arity$0 = G__11070__0;
G__11070.cljs$core$IFn$_invoke$arity$1 = G__11070__1;
G__11070.cljs$core$IFn$_invoke$arity$2 = G__11070__2;
G__11070.cljs$core$IFn$_invoke$arity$variadic = G__11070__3.cljs$core$IFn$_invoke$arity$variadic;
return G__11070;
})()
});
});
var map__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___11076 = size;
var i_11077 = (0);
while(true){
if((i_11077 < n__4645__auto___11076)){
cljs.core.chunk_append(b,(function (){var G__11062 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11077);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11062) : f.call(null,G__11062));
})());

var G__11078 = (i_11077 + (1));
i_11077 = G__11078;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__11063 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11063) : f.call(null,G__11063));
})(),map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
var map__3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__11064 = cljs.core.first(s1);
var G__11065 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11064,G__11065) : f.call(null,G__11064,G__11065));
})(),map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});
var map__4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__11066 = cljs.core.first(s1);
var G__11067 = cljs.core.first(s2);
var G__11068 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11066,G__11067,G__11068) : f.call(null,G__11066,G__11067,G__11068));
})(),map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});
var map__5 = (function() { 
var G__11079__delegate = function (f,c1,c2,c3,colls){
var step = (function step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),step(map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__11016_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__11016_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
};
var G__11079 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__11080__i = 0, G__11080__a = new Array(arguments.length -  4);
while (G__11080__i < G__11080__a.length) {G__11080__a[G__11080__i] = arguments[G__11080__i + 4]; ++G__11080__i;}
  colls = new cljs.core.IndexedSeq(G__11080__a,0);
} 
return G__11079__delegate.call(this,f,c1,c2,c3,colls);};
G__11079.cljs$lang$maxFixedArity = 4;
G__11079.cljs$lang$applyTo = (function (arglist__11081){
var f = cljs.core.first(arglist__11081);
arglist__11081 = cljs.core.next(arglist__11081);
var c1 = cljs.core.first(arglist__11081);
arglist__11081 = cljs.core.next(arglist__11081);
var c2 = cljs.core.first(arglist__11081);
arglist__11081 = cljs.core.next(arglist__11081);
var c3 = cljs.core.first(arglist__11081);
var colls = cljs.core.rest(arglist__11081);
return G__11079__delegate(f,c1,c2,c3,colls);
});
G__11079.cljs$core$IFn$_invoke$arity$variadic = G__11079__delegate;
return G__11079;
})()
;
map = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return map__1.call(this,f);
case 2:
return map__2.call(this,f,c1);
case 3:
return map__3.call(this,f,c1,c2);
case 4:
return map__4.call(this,f,c1,c2,c3);
default:
var G__11082 = null;
if (arguments.length > 4) {
var G__11083__i = 0, G__11083__a = new Array(arguments.length -  4);
while (G__11083__i < G__11083__a.length) {G__11083__a[G__11083__i] = arguments[G__11083__i + 4]; ++G__11083__i;}
G__11082 = new cljs.core.IndexedSeq(G__11083__a,0);
}
return map__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__11082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$lang$maxFixedArity = 4;
map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
map.cljs$core$IFn$_invoke$arity$1 = map__1;
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
map.cljs$core$IFn$_invoke$arity$4 = map__4;
map.cljs$core$IFn$_invoke$arity$variadic = map__5.cljs$core$IFn$_invoke$arity$variadic;
return map;
})()
;
/**
* Returns a lazy sequence of the first n items in coll, or all items if
* there are fewer than n.  Returns a stateful transducer when
* no collection is provided.
*/
cljs.core.take = (function() {
var take = null;
var take__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__11092 = null;
var G__11092__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11092__1 = (function (result){
var G__11089 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11089) : rf.call(null,G__11089));
});
var G__11092__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__11090 = result;
var G__11091 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11090,G__11091) : rf.call(null,G__11090,G__11091));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__11092 = function(result,input){
switch(arguments.length){
case 0:
return G__11092__0.call(this);
case 1:
return G__11092__1.call(this,result);
case 2:
return G__11092__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11092.cljs$core$IFn$_invoke$arity$0 = G__11092__0;
G__11092.cljs$core$IFn$_invoke$arity$1 = G__11092__1;
G__11092.cljs$core$IFn$_invoke$arity$2 = G__11092__2;
return G__11092;
})()
;})(na))
});
});
var take__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
take = function(n,coll){
switch(arguments.length){
case 1:
return take__1.call(this,n);
case 2:
return take__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$1 = take__1;
take.cljs$core$IFn$_invoke$arity$2 = take__2;
return take;
})()
;
/**
* Returns a lazy sequence of all but the first n items in coll.
* Returns a stateful transducer when no collection is provided.
*/
cljs.core.drop = (function() {
var drop = null;
var drop__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__11099 = null;
var G__11099__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11099__1 = (function (result){
var G__11096 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11096) : rf.call(null,G__11096));
});
var G__11099__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__11097 = result;
var G__11098 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11097,G__11098) : rf.call(null,G__11097,G__11098));
}
});
G__11099 = function(result,input){
switch(arguments.length){
case 0:
return G__11099__0.call(this);
case 1:
return G__11099__1.call(this,result);
case 2:
return G__11099__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11099.cljs$core$IFn$_invoke$arity$0 = G__11099__0;
G__11099.cljs$core$IFn$_invoke$arity$1 = G__11099__1;
G__11099.cljs$core$IFn$_invoke$arity$2 = G__11099__2;
return G__11099;
})()
;})(na))
});
});
var drop__2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__11100 = (n__$1 - (1));
var G__11101 = cljs.core.rest(s);
n__$1 = G__11100;
coll__$1 = G__11101;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});
drop = function(n,coll){
switch(arguments.length){
case 1:
return drop__1.call(this,n);
case 2:
return drop__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop.cljs$core$IFn$_invoke$arity$1 = drop__1;
drop.cljs$core$IFn$_invoke$arity$2 = drop__2;
return drop;
})()
;
/**
* Return a lazy sequence of all but the last n (default 1) items in coll
*/
cljs.core.drop_last = (function() {
var drop_last = null;
var drop_last__1 = (function (s){
return drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});
var drop_last__2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});
drop_last = function(n,s){
switch(arguments.length){
case 1:
return drop_last__1.call(this,n);
case 2:
return drop_last__2.call(this,n,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_last.cljs$core$IFn$_invoke$arity$1 = drop_last__1;
drop_last.cljs$core$IFn$_invoke$arity$2 = drop_last__2;
return drop_last;
})()
;
/**
* Returns a seq of the last n items in coll.  Depending on the type
* of coll may be no better than linear time.  For vectors, see also subvec.
*/
cljs.core.take_last = (function take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__11104 = cljs.core.next(s);
var G__11105 = cljs.core.next(lead);
s = G__11104;
lead = G__11105;
continue;
} else {
return s;
}
break;
}
});
/**
* Returns a lazy sequence of the items in coll starting from the
* first item for which (pred item) returns logical false.  Returns a
* stateful transducer when no collection is provided.
*/
cljs.core.drop_while = (function() {
var drop_while = null;
var drop_while__1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__11118 = null;
var G__11118__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11118__1 = (function (result){
var G__11112 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11112) : rf.call(null,G__11112));
});
var G__11118__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__3746__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__3746__auto__)){
var G__11113 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11113) : pred.call(null,G__11113));
} else {
return and__3746__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__11114 = result;
var G__11115 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11114,G__11115) : rf.call(null,G__11114,G__11115));
}
});
G__11118 = function(result,input){
switch(arguments.length){
case 0:
return G__11118__0.call(this);
case 1:
return G__11118__1.call(this,result);
case 2:
return G__11118__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11118.cljs$core$IFn$_invoke$arity$0 = G__11118__0;
G__11118.cljs$core$IFn$_invoke$arity$1 = G__11118__1;
G__11118.cljs$core$IFn$_invoke$arity$2 = G__11118__2;
return G__11118;
})()
;})(da))
});
});
var drop_while__2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__3746__auto__ = s;
if(and__3746__auto__){
var G__11117 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__11117) : pred__$1.call(null,G__11117));
} else {
return and__3746__auto__;
}
})())){
var G__11119 = pred__$1;
var G__11120 = cljs.core.rest(s);
pred__$1 = G__11119;
coll__$1 = G__11120;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});
drop_while = function(pred,coll){
switch(arguments.length){
case 1:
return drop_while__1.call(this,pred);
case 2:
return drop_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_while.cljs$core$IFn$_invoke$arity$1 = drop_while__1;
drop_while.cljs$core$IFn$_invoke$arity$2 = drop_while__2;
return drop_while;
})()
;
/**
* Returns a lazy (infinite!) sequence of repetitions of the items in coll.
*/
cljs.core.cycle = (function cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cycle(s));
} else {
return null;
}
}),null,null));
});
/**
* Returns a vector of [(take n coll) (drop n coll)]
*/
cljs.core.split_at = (function split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
* Returns a lazy (infinite!, or length n if supplied) sequence of xs.
*/
cljs.core.repeat = (function() {
var repeat = null;
var repeat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});
var repeat__2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,repeat.cljs$core$IFn$_invoke$arity$1(x));
});
repeat = function(n,x){
switch(arguments.length){
case 1:
return repeat__1.call(this,n);
case 2:
return repeat__2.call(this,n,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
repeat.cljs$core$IFn$_invoke$arity$1 = repeat__1;
repeat.cljs$core$IFn$_invoke$arity$2 = repeat__2;
return repeat;
})()
;
/**
* Returns a lazy seq of n xs.
*/
cljs.core.replicate = (function replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
* Takes a function of no args, presumably with side effects, and
* returns an infinite (or length n if supplied) lazy sequence of calls
* to it
*/
cljs.core.repeatedly = (function() {
var repeatedly = null;
var repeatedly__1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});
var repeatedly__2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});
repeatedly = function(n,f){
switch(arguments.length){
case 1:
return repeatedly__1.call(this,n);
case 2:
return repeatedly__2.call(this,n,f);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
repeatedly.cljs$core$IFn$_invoke$arity$1 = repeatedly__1;
repeatedly.cljs$core$IFn$_invoke$arity$2 = repeatedly__2;
return repeatedly;
})()
;
/**
* Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
*/
cljs.core.iterate = (function iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return iterate(f,(function (){var G__11129 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11129) : f.call(null,G__11129));
})());
}),null,null)));
});
/**
* Returns a lazy seq of the first item in each coll, then the second etc.
* @param {...*} var_args
*/
cljs.core.interleave = (function() {
var interleave = null;
var interleave__2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});
var interleave__3 = (function() { 
var G__11132__delegate = function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
};
var G__11132 = function (c1,c2,var_args){
var colls = null;
if (arguments.length > 2) {
var G__11133__i = 0, G__11133__a = new Array(arguments.length -  2);
while (G__11133__i < G__11133__a.length) {G__11133__a[G__11133__i] = arguments[G__11133__i + 2]; ++G__11133__i;}
  colls = new cljs.core.IndexedSeq(G__11133__a,0);
} 
return G__11132__delegate.call(this,c1,c2,colls);};
G__11132.cljs$lang$maxFixedArity = 2;
G__11132.cljs$lang$applyTo = (function (arglist__11134){
var c1 = cljs.core.first(arglist__11134);
arglist__11134 = cljs.core.next(arglist__11134);
var c2 = cljs.core.first(arglist__11134);
var colls = cljs.core.rest(arglist__11134);
return G__11132__delegate(c1,c2,colls);
});
G__11132.cljs$core$IFn$_invoke$arity$variadic = G__11132__delegate;
return G__11132;
})()
;
interleave = function(c1,c2,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return interleave__2.call(this,c1,c2);
default:
var G__11135 = null;
if (arguments.length > 2) {
var G__11136__i = 0, G__11136__a = new Array(arguments.length -  2);
while (G__11136__i < G__11136__a.length) {G__11136__a[G__11136__i] = arguments[G__11136__i + 2]; ++G__11136__i;}
G__11135 = new cljs.core.IndexedSeq(G__11136__a,0);
}
return interleave__3.cljs$core$IFn$_invoke$arity$variadic(c1,c2, G__11135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
interleave.cljs$lang$maxFixedArity = 2;
interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
interleave.cljs$core$IFn$_invoke$arity$2 = interleave__2;
interleave.cljs$core$IFn$_invoke$arity$variadic = interleave__3.cljs$core$IFn$_invoke$arity$variadic;
return interleave;
})()
;
/**
* Returns a lazy seq of the elements of coll separated by sep
*/
cljs.core.interpose = (function() {
var interpose = null;
var interpose__1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__11151 = null;
var G__11151__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11151__1 = (function (result){
var G__11144 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11144) : rf.call(null,G__11144));
});
var G__11151__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__11145 = result;
var G__11146 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11145,G__11146) : rf.call(null,G__11145,G__11146));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__11147 = sepr;
var G__11148 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11147,G__11148) : rf.call(null,G__11147,G__11148));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__11149 = result;
var G__11150 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11149,G__11150) : rf.call(null,G__11149,G__11150));
}
});
G__11151 = function(result,input){
switch(arguments.length){
case 0:
return G__11151__0.call(this);
case 1:
return G__11151__1.call(this,result);
case 2:
return G__11151__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11151.cljs$core$IFn$_invoke$arity$0 = G__11151__0;
G__11151.cljs$core$IFn$_invoke$arity$1 = G__11151__1;
G__11151.cljs$core$IFn$_invoke$arity$2 = G__11151__2;
return G__11151;
})()
;})(started))
});
});
var interpose__2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});
interpose = function(sep,coll){
switch(arguments.length){
case 1:
return interpose__1.call(this,sep);
case 2:
return interpose__2.call(this,sep,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
interpose.cljs$core$IFn$_invoke$arity$1 = interpose__1;
interpose.cljs$core$IFn$_invoke$arity$2 = interpose__2;
return interpose;
})()
;
/**
* Take a collection of collections, and return a lazy seq
* of items from the inner collection
*/
cljs.core.flatten1 = (function flatten1(colls){
var cat = (function cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var coll__$1 = temp__4124__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
* Returns the result of applying concat to the result of applying map
* to f and colls.  Thus function f should return a collection. Returns
* a transducer when no collections are provided
* @param {...*} var_args
*/
cljs.core.mapcat = (function() {
var mapcat = null;
var mapcat__1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});
var mapcat__2 = (function() { 
var G__11160__delegate = function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
};
var G__11160 = function (f,var_args){
var colls = null;
if (arguments.length > 1) {
var G__11161__i = 0, G__11161__a = new Array(arguments.length -  1);
while (G__11161__i < G__11161__a.length) {G__11161__a[G__11161__i] = arguments[G__11161__i + 1]; ++G__11161__i;}
  colls = new cljs.core.IndexedSeq(G__11161__a,0);
} 
return G__11160__delegate.call(this,f,colls);};
G__11160.cljs$lang$maxFixedArity = 1;
G__11160.cljs$lang$applyTo = (function (arglist__11162){
var f = cljs.core.first(arglist__11162);
var colls = cljs.core.rest(arglist__11162);
return G__11160__delegate(f,colls);
});
G__11160.cljs$core$IFn$_invoke$arity$variadic = G__11160__delegate;
return G__11160;
})()
;
mapcat = function(f,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return mapcat__1.call(this,f);
default:
var G__11163 = null;
if (arguments.length > 1) {
var G__11164__i = 0, G__11164__a = new Array(arguments.length -  1);
while (G__11164__i < G__11164__a.length) {G__11164__a[G__11164__i] = arguments[G__11164__i + 1]; ++G__11164__i;}
G__11163 = new cljs.core.IndexedSeq(G__11164__a,0);
}
return mapcat__2.cljs$core$IFn$_invoke$arity$variadic(f, G__11163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat.cljs$lang$maxFixedArity = 1;
mapcat.cljs$lang$applyTo = mapcat__2.cljs$lang$applyTo;
mapcat.cljs$core$IFn$_invoke$arity$1 = mapcat__1;
mapcat.cljs$core$IFn$_invoke$arity$variadic = mapcat__2.cljs$core$IFn$_invoke$arity$variadic;
return mapcat;
})()
;
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.filter = (function() {
var filter = null;
var filter__1 = (function (pred){
return (function (rf){
return (function() {
var G__11183 = null;
var G__11183__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11183__1 = (function (result){
var G__11177 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11177) : rf.call(null,G__11177));
});
var G__11183__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__11178 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11178) : pred.call(null,G__11178));
})())){
var G__11179 = result;
var G__11180 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11179,G__11180) : rf.call(null,G__11179,G__11180));
} else {
return result;
}
});
G__11183 = function(result,input){
switch(arguments.length){
case 0:
return G__11183__0.call(this);
case 1:
return G__11183__1.call(this,result);
case 2:
return G__11183__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11183.cljs$core$IFn$_invoke$arity$0 = G__11183__0;
G__11183.cljs$core$IFn$_invoke$arity$1 = G__11183__1;
G__11183.cljs$core$IFn$_invoke$arity$2 = G__11183__2;
return G__11183;
})()
});
});
var filter__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4645__auto___11184 = size;
var i_11185 = (0);
while(true){
if((i_11185 < n__4645__auto___11184)){
if(cljs.core.truth_((function (){var G__11181 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11185);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11181) : pred.call(null,G__11181));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11185));
} else {
}

var G__11186 = (i_11185 + (1));
i_11185 = G__11186;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__11182 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11182) : pred.call(null,G__11182));
})())){
return cljs.core.cons(f,filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});
filter = function(pred,coll){
switch(arguments.length){
case 1:
return filter__1.call(this,pred);
case 2:
return filter__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter.cljs$core$IFn$_invoke$arity$1 = filter__1;
filter.cljs$core$IFn$_invoke$arity$2 = filter__2;
return filter;
})()
;
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns false. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.remove = (function() {
var remove = null;
var remove__1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});
var remove__2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});
remove = function(pred,coll){
switch(arguments.length){
case 1:
return remove__1.call(this,pred);
case 2:
return remove__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove.cljs$core$IFn$_invoke$arity$1 = remove__1;
remove.cljs$core$IFn$_invoke$arity$2 = remove__2;
return remove;
})()
;
/**
* Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
* branch? must be a fn of one arg that returns true if passed a node
* that can have children (but may not).  children must be a fn of one
* arg that returns a sequence of the children. Will only be called on
* nodes for which branch? returns true. Root is the root node of the
* tree.
*/
cljs.core.tree_seq = (function tree_seq(branch_QMARK_,children,root){
var walk = (function walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__11193 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__11193) : branch_QMARK_.call(null,G__11193));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(walk,cljs.core.array_seq([(function (){var G__11194 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__11194) : children.call(null,G__11194));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
* Takes any nested combination of sequential things (lists, vectors,
* etc.) and returns their contents as a single, flat sequence.
* (flatten nil) returns nil.
*/
cljs.core.flatten = (function flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__11195_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__11195_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
* Returns a new coll consisting of to-coll with all of the items of
* from-coll conjoined. A transducer may be supplied.
*/
cljs.core.into = (function() {
var into = null;
var into__2 = (function (to,from){
if(!((to == null))){
if((function (){var G__11198 = to;
if(G__11198){
var bit__4432__auto__ = (G__11198.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4432__auto__) || (G__11198.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});
var into__3 = (function (to,xform,from){
if((function (){var G__11199 = to;
if(G__11199){
var bit__4432__auto__ = (G__11199.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4432__auto__) || (G__11199.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});
into = function(to,xform,from){
switch(arguments.length){
case 2:
return into__2.call(this,to,xform);
case 3:
return into__3.call(this,to,xform,from);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
into.cljs$core$IFn$_invoke$arity$2 = into__2;
into.cljs$core$IFn$_invoke$arity$3 = into__3;
return into;
})()
;
/**
* Returns a vector consisting of the result of applying f to the
* set of first items of each coll, followed by applying f to the set
* of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments.
* @param {...*} var_args
*/
cljs.core.mapv = (function() {
var mapv = null;
var mapv__2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__11201 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11201) : f.call(null,G__11201));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
var mapv__3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});
var mapv__4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});
var mapv__5 = (function() { 
var G__11202__delegate = function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
};
var G__11202 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__11203__i = 0, G__11203__a = new Array(arguments.length -  4);
while (G__11203__i < G__11203__a.length) {G__11203__a[G__11203__i] = arguments[G__11203__i + 4]; ++G__11203__i;}
  colls = new cljs.core.IndexedSeq(G__11203__a,0);
} 
return G__11202__delegate.call(this,f,c1,c2,c3,colls);};
G__11202.cljs$lang$maxFixedArity = 4;
G__11202.cljs$lang$applyTo = (function (arglist__11204){
var f = cljs.core.first(arglist__11204);
arglist__11204 = cljs.core.next(arglist__11204);
var c1 = cljs.core.first(arglist__11204);
arglist__11204 = cljs.core.next(arglist__11204);
var c2 = cljs.core.first(arglist__11204);
arglist__11204 = cljs.core.next(arglist__11204);
var c3 = cljs.core.first(arglist__11204);
var colls = cljs.core.rest(arglist__11204);
return G__11202__delegate(f,c1,c2,c3,colls);
});
G__11202.cljs$core$IFn$_invoke$arity$variadic = G__11202__delegate;
return G__11202;
})()
;
mapv = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return mapv__2.call(this,f,c1);
case 3:
return mapv__3.call(this,f,c1,c2);
case 4:
return mapv__4.call(this,f,c1,c2,c3);
default:
var G__11205 = null;
if (arguments.length > 4) {
var G__11206__i = 0, G__11206__a = new Array(arguments.length -  4);
while (G__11206__i < G__11206__a.length) {G__11206__a[G__11206__i] = arguments[G__11206__i + 4]; ++G__11206__i;}
G__11205 = new cljs.core.IndexedSeq(G__11206__a,0);
}
return mapv__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__11205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapv.cljs$lang$maxFixedArity = 4;
mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
mapv.cljs$core$IFn$_invoke$arity$2 = mapv__2;
mapv.cljs$core$IFn$_invoke$arity$3 = mapv__3;
mapv.cljs$core$IFn$_invoke$arity$4 = mapv__4;
mapv.cljs$core$IFn$_invoke$arity$variadic = mapv__5.cljs$core$IFn$_invoke$arity$variadic;
return mapv;
})()
;
/**
* Returns a vector of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
*/
cljs.core.filterv = (function filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__11208 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11208) : pred.call(null,G__11208));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
* Returns a lazy sequence of lists of n items each, at offsets step
* apart. If step is not supplied, defaults to n, i.e. the partitions
* do not overlap. If a pad collection is supplied, use its elements as
* necessary to complete last partition up to n items. In case there are
* not enough padding elements, return a partition with less than n items.
*/
cljs.core.partition = (function() {
var partition = null;
var partition__2 = (function (n,coll){
return partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var partition__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
var partition__4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});
partition = function(n,step,pad,coll){
switch(arguments.length){
case 2:
return partition__2.call(this,n,step);
case 3:
return partition__3.call(this,n,step,pad);
case 4:
return partition__4.call(this,n,step,pad,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
partition.cljs$core$IFn$_invoke$arity$4 = partition__4;
return partition;
})()
;
/**
* Returns the value in a nested associative structure,
* where ks is a sequence of keys. Returns nil if the key is not present,
* or the not-found value if supplied.
*/
cljs.core.get_in = (function() {
var get_in = null;
var get_in__2 = (function (m,ks){
return get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});
var get_in__3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__11223 = m__$1;
if(G__11223){
var bit__4439__auto__ = (G__11223.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4439__auto__) || (G__11223.cljs$core$ILookup$)){
return true;
} else {
if((!G__11223.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__11223);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__11223);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__11224 = sentinel;
var G__11225 = m__$2;
var G__11226 = cljs.core.next(ks__$1);
sentinel = G__11224;
m__$1 = G__11225;
ks__$1 = G__11226;
continue;
}
}
} else {
return m__$1;
}
break;
}
});
get_in = function(m,ks,not_found){
switch(arguments.length){
case 2:
return get_in__2.call(this,m,ks);
case 3:
return get_in__3.call(this,m,ks,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
get_in.cljs$core$IFn$_invoke$arity$2 = get_in__2;
get_in.cljs$core$IFn$_invoke$arity$3 = get_in__3;
return get_in;
})()
;
/**
* Associates a value in a nested associative structure, where ks is a
* sequence of keys and v is the new value and returns a new nested structure.
* If any levels do not exist, hash-maps will be created.
*/
cljs.core.assoc_in = (function assoc_in(m,p__11227,v){
var vec__11232 = p__11227;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11232,(0),null);
var ks = cljs.core.nthnext(vec__11232,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
* 'Updates' a value in a nested associative structure, where ks is a
* sequence of keys and f is a function that will take the old value
* and any supplied args and return the new value, and returns a new
* nested structure.  If any levels do not exist, hash-maps will be
* created.
* @param {...*} var_args
*/
cljs.core.update_in = (function() {
var update_in = null;
var update_in__3 = (function (m,p__11233,f){
var vec__11271 = p__11233;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11271,(0),null);
var ks = cljs.core.nthnext(vec__11271,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11272 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11272) : f.call(null,G__11272));
})());
}
});
var update_in__4 = (function (m,p__11234,f,a){
var vec__11273 = p__11234;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11273,(0),null);
var ks = cljs.core.nthnext(vec__11273,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11275 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11274,G__11275) : f.call(null,G__11274,G__11275));
})());
}
});
var update_in__5 = (function (m,p__11235,f,a,b){
var vec__11276 = p__11235;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11276,(0),null);
var ks = cljs.core.nthnext(vec__11276,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11278 = a;
var G__11279 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11277,G__11278,G__11279) : f.call(null,G__11277,G__11278,G__11279));
})());
}
});
var update_in__6 = (function (m,p__11236,f,a,b,c){
var vec__11280 = p__11236;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11280,(0),null);
var ks = cljs.core.nthnext(vec__11280,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11282 = a;
var G__11283 = b;
var G__11284 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11281,G__11282,G__11283,G__11284) : f.call(null,G__11281,G__11282,G__11283,G__11284));
})());
}
});
var update_in__7 = (function() { 
var G__11286__delegate = function (m,p__11237,f,a,b,c,args){
var vec__11285 = p__11237;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11285,(0),null);
var ks = cljs.core.nthnext(vec__11285,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
};
var G__11286 = function (m,p__11237,f,a,b,c,var_args){
var args = null;
if (arguments.length > 6) {
var G__11287__i = 0, G__11287__a = new Array(arguments.length -  6);
while (G__11287__i < G__11287__a.length) {G__11287__a[G__11287__i] = arguments[G__11287__i + 6]; ++G__11287__i;}
  args = new cljs.core.IndexedSeq(G__11287__a,0);
} 
return G__11286__delegate.call(this,m,p__11237,f,a,b,c,args);};
G__11286.cljs$lang$maxFixedArity = 6;
G__11286.cljs$lang$applyTo = (function (arglist__11288){
var m = cljs.core.first(arglist__11288);
arglist__11288 = cljs.core.next(arglist__11288);
var p__11237 = cljs.core.first(arglist__11288);
arglist__11288 = cljs.core.next(arglist__11288);
var f = cljs.core.first(arglist__11288);
arglist__11288 = cljs.core.next(arglist__11288);
var a = cljs.core.first(arglist__11288);
arglist__11288 = cljs.core.next(arglist__11288);
var b = cljs.core.first(arglist__11288);
arglist__11288 = cljs.core.next(arglist__11288);
var c = cljs.core.first(arglist__11288);
var args = cljs.core.rest(arglist__11288);
return G__11286__delegate(m,p__11237,f,a,b,c,args);
});
G__11286.cljs$core$IFn$_invoke$arity$variadic = G__11286__delegate;
return G__11286;
})()
;
update_in = function(m,p__11237,f,a,b,c,var_args){
var args = var_args;
switch(arguments.length){
case 3:
return update_in__3.call(this,m,p__11237,f);
case 4:
return update_in__4.call(this,m,p__11237,f,a);
case 5:
return update_in__5.call(this,m,p__11237,f,a,b);
case 6:
return update_in__6.call(this,m,p__11237,f,a,b,c);
default:
var G__11289 = null;
if (arguments.length > 6) {
var G__11290__i = 0, G__11290__a = new Array(arguments.length -  6);
while (G__11290__i < G__11290__a.length) {G__11290__a[G__11290__i] = arguments[G__11290__i + 6]; ++G__11290__i;}
G__11289 = new cljs.core.IndexedSeq(G__11290__a,0);
}
return update_in__7.cljs$core$IFn$_invoke$arity$variadic(m,p__11237,f,a,b,c, G__11289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update_in.cljs$lang$maxFixedArity = 6;
update_in.cljs$lang$applyTo = update_in__7.cljs$lang$applyTo;
update_in.cljs$core$IFn$_invoke$arity$3 = update_in__3;
update_in.cljs$core$IFn$_invoke$arity$4 = update_in__4;
update_in.cljs$core$IFn$_invoke$arity$5 = update_in__5;
update_in.cljs$core$IFn$_invoke$arity$6 = update_in__6;
update_in.cljs$core$IFn$_invoke$arity$variadic = update_in__7.cljs$core$IFn$_invoke$arity$variadic;
return update_in;
})()
;
/**
* 'Updates' a value in an associative structure, where k is a
* key and f is a function that will take the old value
* and any supplied args and return the new value, and returns a new
* structure.  If the key does not exist, nil is passed as the old value.
* @param {...*} var_args
*/
cljs.core.update = (function() {
var update = null;
var update__3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11301 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11301) : f.call(null,G__11301));
})());
});
var update__4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11302 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11303 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11302,G__11303) : f.call(null,G__11302,G__11303));
})());
});
var update__5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11304 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11305 = x;
var G__11306 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11304,G__11305,G__11306) : f.call(null,G__11304,G__11305,G__11306));
})());
});
var update__6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11307 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11308 = x;
var G__11309 = y;
var G__11310 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11307,G__11308,G__11309,G__11310) : f.call(null,G__11307,G__11308,G__11309,G__11310));
})());
});
var update__7 = (function() { 
var G__11311__delegate = function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
};
var G__11311 = function (m,k,f,x,y,z,var_args){
var more = null;
if (arguments.length > 6) {
var G__11312__i = 0, G__11312__a = new Array(arguments.length -  6);
while (G__11312__i < G__11312__a.length) {G__11312__a[G__11312__i] = arguments[G__11312__i + 6]; ++G__11312__i;}
  more = new cljs.core.IndexedSeq(G__11312__a,0);
} 
return G__11311__delegate.call(this,m,k,f,x,y,z,more);};
G__11311.cljs$lang$maxFixedArity = 6;
G__11311.cljs$lang$applyTo = (function (arglist__11313){
var m = cljs.core.first(arglist__11313);
arglist__11313 = cljs.core.next(arglist__11313);
var k = cljs.core.first(arglist__11313);
arglist__11313 = cljs.core.next(arglist__11313);
var f = cljs.core.first(arglist__11313);
arglist__11313 = cljs.core.next(arglist__11313);
var x = cljs.core.first(arglist__11313);
arglist__11313 = cljs.core.next(arglist__11313);
var y = cljs.core.first(arglist__11313);
arglist__11313 = cljs.core.next(arglist__11313);
var z = cljs.core.first(arglist__11313);
var more = cljs.core.rest(arglist__11313);
return G__11311__delegate(m,k,f,x,y,z,more);
});
G__11311.cljs$core$IFn$_invoke$arity$variadic = G__11311__delegate;
return G__11311;
})()
;
update = function(m,k,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 3:
return update__3.call(this,m,k,f);
case 4:
return update__4.call(this,m,k,f,x);
case 5:
return update__5.call(this,m,k,f,x,y);
case 6:
return update__6.call(this,m,k,f,x,y,z);
default:
var G__11314 = null;
if (arguments.length > 6) {
var G__11315__i = 0, G__11315__a = new Array(arguments.length -  6);
while (G__11315__i < G__11315__a.length) {G__11315__a[G__11315__i] = arguments[G__11315__i + 6]; ++G__11315__i;}
G__11314 = new cljs.core.IndexedSeq(G__11315__a,0);
}
return update__7.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x,y,z, G__11314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
update.cljs$lang$maxFixedArity = 6;
update.cljs$lang$applyTo = update__7.cljs$lang$applyTo;
update.cljs$core$IFn$_invoke$arity$3 = update__3;
update.cljs$core$IFn$_invoke$arity$4 = update__4;
update.cljs$core$IFn$_invoke$arity$5 = update__5;
update.cljs$core$IFn$_invoke$arity$6 = update__6;
update.cljs$core$IFn$_invoke$arity$variadic = update__7.cljs$core$IFn$_invoke$arity$variadic;
return update;
})()
;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function __GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__11316 = (ll - (5));
var G__11317 = r;
ll = G__11316;
ret = G__11317;
continue;
}
break;
}
});
cljs.core.push_tail = (function push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__11322 = cljs.core.pv_aget(node,(0));
var G__11323 = (level - (5));
node = G__11322;
level = G__11323;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__11324 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__11325 = (level - (5));
node = G__11324;
level = G__11325;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function __GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__11335 = init__$2;
var G__11336 = (j + i);
var G__11337 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11335,G__11336,G__11337) : f.call(null,G__11335,G__11336,G__11337));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__11348 = (j + (1));
var G__11349 = init__$3;
j = G__11348;
init__$2 = G__11349;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11338 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11338) : cljs.core.deref.call(null,G__11338));
} else {
var G__11350 = (i + len);
var G__11351 = init__$2;
i = G__11350;
init__$1 = G__11351;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__11339 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__11339) : cljs.core.tv_editable_root.call(null,G__11339));
})(),(function (){var G__11340 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__11340) : cljs.core.tv_editable_tail.call(null,G__11340));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__11341 = init__$2;
var G__11342 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11341,G__11342) : f.call(null,G__11341,G__11342));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__11352 = (j + (1));
var G__11353 = init__$3;
j = G__11352;
init__$2 = G__11353;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11343 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11343) : cljs.core.deref.call(null,G__11343));
} else {
var G__11354 = (i + len);
var G__11355 = init__$2;
i = G__11354;
init__$1 = G__11355;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__11344 = coll__$1;
var G__11345 = cljs.core.first_array_for_longvec(coll__$1);
var G__11346 = (0);
var G__11347 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11344,G__11345,G__11346,G__11347) : cljs.core.chunked_seq.call(null,G__11344,G__11345,G__11346,G__11347));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4645__auto___11356 = len;
var i_11357 = (0);
while(true){
if((i_11357 < n__4645__auto___11356)){
(new_tail[i_11357] = (self__.tail[i_11357]));

var G__11358 = (i_11357 + (1));
i_11357 = G__11358;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__11359 = null;
var G__11359__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__11359__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__11359 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11359__2.call(this,self__,k);
case 3:
return G__11359__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11359.cljs$core$IFn$_invoke$arity$2 = G__11359__2;
G__11359.cljs$core$IFn$_invoke$arity$3 = G__11359__3;
return G__11359;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args11334){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11334)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function __GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__11360 = (i + (1));
var G__11361 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__11360;
out = G__11361;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.vec = (function vec(coll){
if(coll instanceof Array){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
* @param {...*} var_args
*/
cljs.core.vector = (function() { 
var vector__delegate = function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
};
var vector = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11362__i = 0, G__11362__a = new Array(arguments.length -  0);
while (G__11362__i < G__11362__a.length) {G__11362__a[G__11362__i] = arguments[G__11362__i + 0]; ++G__11362__i;}
  args = new cljs.core.IndexedSeq(G__11362__a,0);
} 
return vector__delegate.call(this,args);};
vector.cljs$lang$maxFixedArity = 0;
vector.cljs$lang$applyTo = (function (arglist__11363){
var args = cljs.core.seq(arglist__11363);
return vector__delegate(args);
});
vector.cljs$core$IFn$_invoke$arity$variadic = vector__delegate;
return vector;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__11364 = self__.vec;
var G__11365 = self__.node;
var G__11366 = self__.i;
var G__11367 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11364,G__11365,G__11366,G__11367) : cljs.core.chunked_seq.call(null,G__11364,G__11365,G__11366,G__11367));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__11368 = self__.vec;
var G__11369 = (self__.i + self__.off);
var G__11370 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11368,G__11369,G__11370) : cljs.core.subvec.call(null,G__11368,G__11369,G__11370));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__11371 = self__.vec;
var G__11372 = (self__.i + self__.off);
var G__11373 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__11371,G__11372,G__11373) : cljs.core.subvec.call(null,G__11371,G__11372,G__11373));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__11374 = self__.vec;
var G__11375 = self__.node;
var G__11376 = self__.i;
var G__11377 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11374,G__11375,G__11376,G__11377) : cljs.core.chunked_seq.call(null,G__11374,G__11375,G__11376,G__11377));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__11378 = self__.vec;
var G__11379 = cljs.core.unchecked_array_for(self__.vec,end);
var G__11380 = end;
var G__11381 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11378,G__11379,G__11380,G__11381) : cljs.core.chunked_seq.call(null,G__11378,G__11379,G__11380,G__11381));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__11382 = self__.vec;
var G__11383 = self__.node;
var G__11384 = self__.i;
var G__11385 = self__.off;
var G__11386 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__11382,G__11383,G__11384,G__11385,G__11386) : cljs.core.chunked_seq.call(null,G__11382,G__11383,G__11384,G__11385,G__11386));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__11387 = self__.vec;
var G__11388 = cljs.core.unchecked_array_for(self__.vec,end);
var G__11389 = end;
var G__11390 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__11387,G__11388,G__11389,G__11390) : cljs.core.chunked_seq.call(null,G__11387,G__11388,G__11389,G__11390));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function __GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.chunked_seq = (function() {
var chunked_seq = null;
var chunked_seq__3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});
var chunked_seq__4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});
var chunked_seq__5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});
chunked_seq = function(vec,node,i,off,meta){
switch(arguments.length){
case 3:
return chunked_seq__3.call(this,vec,node,i);
case 4:
return chunked_seq__4.call(this,vec,node,i,off);
case 5:
return chunked_seq__5.call(this,vec,node,i,off,meta);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chunked_seq.cljs$core$IFn$_invoke$arity$3 = chunked_seq__3;
chunked_seq.cljs$core$IFn$_invoke$arity$4 = chunked_seq__4;
chunked_seq.cljs$core$IFn$_invoke$arity$5 = chunked_seq__5;
return chunked_seq;
})()
;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166617887;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__11392 = self__.meta;
var G__11393 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__11394 = self__.start;
var G__11395 = (function (){var x__4075__auto__ = self__.end;
var y__4076__auto__ = (v_pos + (1));
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
})();
var G__11396 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11392,G__11393,G__11394,G__11395,G__11396) : cljs.core.build_subvec.call(null,G__11392,G__11393,G__11394,G__11395,G__11396));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__11397 = self__.meta;
var G__11398 = self__.v;
var G__11399 = self__.start;
var G__11400 = (self__.end - (1));
var G__11401 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11397,G__11398,G__11399,G__11400,G__11401) : cljs.core.build_subvec.call(null,G__11397,G__11398,G__11399,G__11400,G__11401));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__11403 = meta__$1;
var G__11404 = self__.v;
var G__11405 = self__.start;
var G__11406 = self__.end;
var G__11407 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11403,G__11404,G__11405,G__11406,G__11407) : cljs.core.build_subvec.call(null,G__11403,G__11404,G__11405,G__11406,G__11407));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__11408 = self__.meta;
var G__11409 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__11410 = self__.start;
var G__11411 = (self__.end + (1));
var G__11412 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__11408,G__11409,G__11410,G__11411,G__11412) : cljs.core.build_subvec.call(null,G__11408,G__11409,G__11410,G__11411,G__11412));
});

cljs.core.Subvec.prototype.call = (function() {
var G__11413 = null;
var G__11413__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__11413__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__11413 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11413__2.call(this,self__,k);
case 3:
return G__11413__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11413.cljs$core$IFn$_invoke$arity$2 = G__11413__2;
G__11413.cljs$core$IFn$_invoke$arity$3 = G__11413__3;
return G__11413;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args11391){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11391)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function __GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.build_subvec = (function build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__11414 = meta;
var G__11415 = v.v;
var G__11416 = (v.start + start);
var G__11417 = (v.start + end);
var G__11418 = __hash;
meta = G__11414;
v = G__11415;
start = G__11416;
end = G__11417;
__hash = G__11418;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
* Returns a persistent vector of the items in vector from
* start (inclusive) to end (exclusive).  If end is not supplied,
* defaults to (count vector). This operation is O(1) and very fast, as
* the resulting vector shares structure with the original and no
* trimming is done.
*/
cljs.core.subvec = (function() {
var subvec = null;
var subvec__2 = (function (v,start){
return subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});
var subvec__3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});
subvec = function(v,start,end){
switch(arguments.length){
case 2:
return subvec__2.call(this,v,start);
case 3:
return subvec__3.call(this,v,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subvec.cljs$core$IFn$_invoke$arity$2 = subvec__2;
subvec.cljs$core$IFn$_invoke$arity$3 = subvec__3;
return subvec;
})()
;
cljs.core.tv_ensure_editable = (function tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj11425 = {};
return obj11425;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__11433 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__11434 = (level - (5));
node = G__11433;
level = G__11434;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 88;
})
cljs.core.TransientVector.prototype.call = (function() {
var G__11438 = null;
var G__11438__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11438__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11438 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11438__2.call(this,self__,k);
case 3:
return G__11438__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11438.cljs$core$IFn$_invoke$arity$2 = G__11438__2;
G__11438.cljs$core$IFn$_invoke$arity$3 = G__11438__3;
return G__11438;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args11435){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11435)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function __GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function __GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__3758__auto__ = self__.front;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3758__auto__ = self__.rear;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function __GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function __GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
* Assumes y is a map. Returns true if x equals y, otherwise returns
* false.
*/
cljs.core.equiv_map = (function equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__11439 = (i + incr);
i = G__11439;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__11440 = (i + (1));
var G__11441 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__11440;
out = G__11441;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function obj_clone(obj,ks){
var new_obj = (function (){var obj11445 = {};
return obj11445;
})();
var l = ks.length;
var i_11446 = (0);
while(true){
if((i_11446 < l)){
var k_11447 = (ks[i_11446]);
(new_obj[k_11447] = (obj[k_11447]));

var G__11448 = (i_11446 + (1));
i_11446 = G__11448;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3746__auto__ = (function (){var G__11452 = k;
return goog.isString(G__11452);
})();
if(cljs.core.truth_(and__3746__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3746__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__11453 = init__$1;
var G__11454 = k;
var G__11455 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11453,G__11454,G__11455) : f.call(null,G__11453,G__11454,G__11455));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11456 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11456) : cljs.core.deref.call(null,G__11456));
} else {
var G__11462 = cljs.core.rest(keys__$1);
var G__11463 = init__$2;
keys__$1 = G__11462;
init__$1 = G__11463;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3746__auto__ = (function (){var G__11458 = k;
return goog.isString(G__11458);
})();
if(cljs.core.truth_(and__3746__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3746__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__11459 = k;
return goog.isString(G__11459);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3746__auto__ = (function (){var G__11461 = k;
return goog.isString(G__11461);
})();
if(cljs.core.truth_(and__3746__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3746__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__11449_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__11449_SHARP_,(self__.strobj[p1__11449_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__11464 = null;
var G__11464__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11464__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11464 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11464__2.call(this,self__,k);
case 3:
return G__11464__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11464.cljs$core$IFn$_invoke$arity$2 = G__11464__2;
G__11464.cljs$core$IFn$_invoke$arity$3 = G__11464__3;
return G__11464;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args11450){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11450)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function __GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj11466 = {};
return obj11466;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__11467 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11467,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11467,(1),null);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [k,v]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function __GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [x,x]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function __GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_map_index_of_nil_QMARK_ = (function array_map_index_of_nil_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__11468 = (i + (2));
i = G__11468;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_keyword_QMARK_ = (function array_map_index_of_keyword_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__11469 = (i + (2));
i = G__11469;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_symbol_QMARK_ = (function array_map_index_of_symbol_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__11470 = (i + (2));
i = G__11470;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_identical_QMARK_ = (function array_map_index_of_identical_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__11471 = (i + (2));
i = G__11471;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_equiv_QMARK_ = (function array_map_index_of_equiv_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__11472 = (i + (2));
i = G__11472;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of = (function array_map_index_of(m,k){
var arr = m.arr;
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_map_index_of_keyword_QMARK_(arr,m,k);
} else {
if(cljs.core.truth_((function (){var or__3758__auto__ = (function (){var G__11476 = k;
return goog.isString(G__11476);
})();
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_map_index_of_identical_QMARK_(arr,m,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_map_index_of_symbol_QMARK_(arr,m,k);
} else {
if((k == null)){
return cljs.core.array_map_index_of_nil_QMARK_(arr,m,k);
} else {
return cljs.core.array_map_index_of_equiv_QMARK_(arr,m,k);

}
}
}
}
});
cljs.core.array_map_extend_kv = (function array_map_extend_kv(m,k,v){
var arr = m.arr;
var l = arr.length;
var narr = (new Array((l + (2))));
var i_11477 = (0);
while(true){
if((i_11477 < l)){
(narr[i_11477] = (arr[i_11477]));

var G__11478 = (i_11477 + (1));
i_11477 = G__11478;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function __GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.persistent_array_map_seq = (function persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function __GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11480 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__11480) : cljs.core.keys.call(null,G__11480));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11481 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__11481) : cljs.core.vals.call(null,G__11481));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11482 = cljs.core.seq(coll);
var chunk__11483 = null;
var count__11484 = (0);
var i__11485 = (0);
while(true){
if((i__11485 < count__11484)){
var vec__11486 = chunk__11483.cljs$core$IIndexed$_nth$arity$2(null,i__11485);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11486,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11486,(1),null);
var G__11487_11500 = v;
var G__11488_11501 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11487_11500,G__11488_11501) : f.call(null,G__11487_11500,G__11488_11501));

var G__11502 = seq__11482;
var G__11503 = chunk__11483;
var G__11504 = count__11484;
var G__11505 = (i__11485 + (1));
seq__11482 = G__11502;
chunk__11483 = G__11503;
count__11484 = G__11504;
i__11485 = G__11505;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11482);
if(temp__4126__auto__){
var seq__11482__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11482__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11482__$1);
var G__11506 = cljs.core.chunk_rest(seq__11482__$1);
var G__11507 = c__4545__auto__;
var G__11508 = cljs.core.count(c__4545__auto__);
var G__11509 = (0);
seq__11482 = G__11506;
chunk__11483 = G__11507;
count__11484 = G__11508;
i__11485 = G__11509;
continue;
} else {
var vec__11489 = cljs.core.first(seq__11482__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11489,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11489,(1),null);
var G__11490_11510 = v;
var G__11491_11511 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11490_11510,G__11491_11511) : f.call(null,G__11490_11510,G__11491_11511));

var G__11512 = cljs.core.next(seq__11482__$1);
var G__11513 = null;
var G__11514 = (0);
var G__11515 = (0);
seq__11482 = G__11512;
chunk__11483 = G__11513;
count__11484 = G__11514;
i__11485 = G__11515;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__11492 = init__$1;
var G__11493 = (self__.arr[i]);
var G__11494 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11492,G__11493,G__11494) : f.call(null,G__11492,G__11493,G__11494));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11495 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11495) : cljs.core.deref.call(null,G__11495));
} else {
var G__11516 = (i + (2));
var G__11517 = init__$2;
i = G__11516;
init__$1 = G__11517;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__11496 = other;
if(G__11496){
var bit__4432__auto__ = (G__11496.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4432__auto__) || (G__11496.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__11518 = (i + (2));
i = G__11518;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj11498 = {};
return obj11498;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__11519 = (s + (2));
var G__11520 = d;
s = G__11519;
d = G__11520;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__11521 = (s + (2));
var G__11522 = (d + (2));
s = G__11521;
d = G__11522;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__11499 = cljs.core.aclone(self__.arr);
(G__11499[(idx + (1))] = v);

return G__11499;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__11523 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__11524 = cljs.core.next(es);
ret = G__11523;
es = G__11524;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__11525 = null;
var G__11525__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11525__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11525 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11525__2.call(this,self__,k);
case 3:
return G__11525__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11525.cljs$core$IFn$_invoke$arity$2 = G__11525__2;
G__11525.cljs$core$IFn$_invoke$arity$3 = G__11525__3;
return G__11525;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args11479){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11479)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function __GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
if(no_check){
var cnt = (arr__$1.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$1,null));
} else {
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__11526 = (i + (2));
var G__11527 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__11526;
ret = G__11527;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__11528_11536 = self__.arr;
G__11528_11536.pop();

G__11528_11536.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__11529 = self__.len;
var G__11530 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__11529,G__11530) : cljs.core.array__GT_transient_hash_map.call(null,G__11529,G__11530));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__11531 = o;
if(G__11531){
var bit__4439__auto__ = (G__11531.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4439__auto__) || (G__11531.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__11531.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11531);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11531);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__11532 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11532) : cljs.core.key.call(null,G__11532));
})(),(function (){var G__11533 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11533) : cljs.core.val.call(null,G__11533));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__11537 = cljs.core.next(es);
var G__11538 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__11534 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11534) : cljs.core.key.call(null,G__11534));
})(),(function (){var G__11535 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11535) : cljs.core.val.call(null,G__11535));
})());
es = G__11537;
tcoll__$2 = G__11538;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function __GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__11539 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__11540 = (i + (2));
out = G__11539;
i = G__11540;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function __GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function() {
var clone_and_set = null;
var clone_and_set__3 = (function (arr,i,a){
var G__11543 = cljs.core.aclone(arr);
(G__11543[i] = a);

return G__11543;
});
var clone_and_set__5 = (function (arr,i,a,j,b){
var G__11544 = cljs.core.aclone(arr);
(G__11544[i] = a);

(G__11544[j] = b);

return G__11544;
});
clone_and_set = function(arr,i,a,j,b){
switch(arguments.length){
case 3:
return clone_and_set__3.call(this,arr,i,a);
case 5:
return clone_and_set__5.call(this,arr,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
clone_and_set.cljs$core$IFn$_invoke$arity$3 = clone_and_set__3;
clone_and_set.cljs$core$IFn$_invoke$arity$5 = clone_and_set__5;
return clone_and_set;
})()
;
cljs.core.remove_pair = (function remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function() {
var edit_and_set = null;
var edit_and_set__4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});
var edit_and_set__6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});
edit_and_set = function(inode,edit,i,a,j,b){
switch(arguments.length){
case 4:
return edit_and_set__4.call(this,inode,edit,i,a);
case 6:
return edit_and_set__6.call(this,inode,edit,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
edit_and_set.cljs$core$IFn$_invoke$arity$4 = edit_and_set__4;
edit_and_set.cljs$core$IFn$_invoke$arity$6 = edit_and_set__6;
return edit_and_set;
})()
;
cljs.core.inode_kv_reduce = (function inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__11549 = init__$1;
var G__11550 = k;
var G__11551 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11549,G__11550,G__11551) : f.call(null,G__11549,G__11550,G__11551));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11552 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11552) : cljs.core.deref.call(null,G__11552));
} else {
var G__11553 = (i + (2));
var G__11554 = init__$2;
i = G__11553;
init__$1 = G__11554;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__11555 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__11555) : cljs.core.create_inode_seq.call(null,G__11555));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_11569 = (0);
var j_11570 = (0);
while(true){
if((i_11569 < (32))){
if((((self__.bitmap >>> i_11569) & (1)) === (0))){
var G__11571 = (i_11569 + (1));
var G__11572 = j_11570;
i_11569 = G__11571;
j_11570 = G__11572;
continue;
} else {
(nodes[i_11569] = ((!(((self__.arr[j_11570]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_11570])),(self__.arr[j_11570]),(self__.arr[(j_11570 + (1))]),added_leaf_QMARK_):(self__.arr[(j_11570 + (1))])));

var G__11573 = (i_11569 + (1));
var G__11574 = (j_11570 + (2));
i_11569 = G__11573;
j_11570 = G__11574;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__11556 = edit__$1;
var G__11557 = (shift + (5));
var G__11558 = key_or_nil;
var G__11559 = val_or_node;
var G__11560 = hash;
var G__11561 = key;
var G__11562 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__11556,G__11557,G__11558,G__11559,G__11560,G__11561,G__11562) : cljs.core.create_node.call(null,G__11556,G__11557,G__11558,G__11559,G__11560,G__11561,G__11562));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_11575 = (0);
var j_11576 = (0);
while(true){
if((i_11575 < (32))){
if((((self__.bitmap >>> i_11575) & (1)) === (0))){
var G__11577 = (i_11575 + (1));
var G__11578 = j_11576;
i_11575 = G__11577;
j_11576 = G__11578;
continue;
} else {
(nodes[i_11575] = ((!(((self__.arr[j_11576]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_11576])),(self__.arr[j_11576]),(self__.arr[(j_11576 + (1))]),added_leaf_QMARK_):(self__.arr[(j_11576 + (1))])));

var G__11579 = (i_11575 + (1));
var G__11580 = (j_11576 + (2));
i_11575 = G__11579;
j_11576 = G__11580;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__11563 = (shift + (5));
var G__11564 = key_or_nil;
var G__11565 = val_or_node;
var G__11566 = hash;
var G__11567 = key;
var G__11568 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__11563,G__11564,G__11565,G__11566,G__11567,G__11568) : cljs.core.create_node.call(null,G__11563,G__11564,G__11565,G__11566,G__11567,G__11568));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function __GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__11581 = (i + (1));
var G__11582 = (j + (2));
var G__11583 = (bitmap | ((1) << i));
i = G__11581;
j = G__11582;
bitmap = G__11583;
continue;
} else {
var G__11584 = (i + (1));
var G__11585 = j;
var G__11586 = bitmap;
i = G__11584;
j = G__11585;
bitmap = G__11586;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__11587 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__11587) : cljs.core.create_array_node_seq.call(null,G__11587));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11588 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11588) : cljs.core.deref.call(null,G__11588));
} else {
var G__11589 = (i + (1));
var G__11590 = init__$2;
i = G__11589;
init__$1 = G__11590;
continue;
}
} else {
var G__11591 = (i + (1));
var G__11592 = init__$1;
i = G__11591;
init__$1 = G__11592;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function __GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__11593 = (i + (2));
i = G__11593;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__11594 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__11594) : cljs.core.create_inode_seq.call(null,G__11594));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function __GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function() {
var create_node = null;
var create_node__6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
var create_node__7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
create_node = function(edit,shift,key1,val1,key2hash,key2,val2){
switch(arguments.length){
case 6:
return create_node__6.call(this,edit,shift,key1,val1,key2hash,key2);
case 7:
return create_node__7.call(this,edit,shift,key1,val1,key2hash,key2,val2);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_node.cljs$core$IFn$_invoke$arity$6 = create_node__6;
create_node.cljs$core$IFn$_invoke$arity$7 = create_node__7;
return create_node;
})()
;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__11595 = self__.nodes;
var G__11596 = (self__.i + (2));
var G__11597 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__11595,G__11596,G__11597) : cljs.core.create_inode_seq.call(null,G__11595,G__11596,G__11597));
} else {
var G__11598 = self__.nodes;
var G__11599 = self__.i;
var G__11600 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__11598,G__11599,G__11600) : cljs.core.create_inode_seq.call(null,G__11598,G__11599,G__11600));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function __GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.create_inode_seq = (function() {
var create_inode_seq = null;
var create_inode_seq__1 = (function (nodes){
return create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});
var create_inode_seq__3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4124__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4124__auto__)){
var node = temp__4124__auto__;
var temp__4124__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var node_seq = temp__4124__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__11604 = (j + (2));
j = G__11604;
continue;
}
} else {
var G__11605 = (j + (2));
j = G__11605;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});
create_inode_seq = function(nodes,i,s){
switch(arguments.length){
case 1:
return create_inode_seq__1.call(this,nodes);
case 3:
return create_inode_seq__3.call(this,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_inode_seq.cljs$core$IFn$_invoke$arity$1 = create_inode_seq__1;
create_inode_seq.cljs$core$IFn$_invoke$arity$3 = create_inode_seq__3;
return create_inode_seq;
})()
;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__11606 = null;
var G__11607 = self__.nodes;
var G__11608 = self__.i;
var G__11609 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__11606,G__11607,G__11608,G__11609) : cljs.core.create_array_node_seq.call(null,G__11606,G__11607,G__11608,G__11609));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function __GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.create_array_node_seq = (function() {
var create_array_node_seq = null;
var create_array_node_seq__1 = (function (nodes){
return create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});
var create_array_node_seq__4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4124__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4124__auto__)){
var nj = temp__4124__auto__;
var temp__4124__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var ns = temp__4124__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__11614 = (j + (1));
j = G__11614;
continue;
}
} else {
var G__11615 = (j + (1));
j = G__11615;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});
create_array_node_seq = function(meta,nodes,i,s){
switch(arguments.length){
case 1:
return create_array_node_seq__1.call(this,meta);
case 4:
return create_array_node_seq__4.call(this,meta,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = create_array_node_seq__1;
create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = create_array_node_seq__4;
return create_array_node_seq;
})()
;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11617 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__11617) : cljs.core.keys.call(null,G__11617));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11618 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__11618) : cljs.core.vals.call(null,G__11618));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11619 = cljs.core.seq(coll);
var chunk__11620 = null;
var count__11621 = (0);
var i__11622 = (0);
while(true){
if((i__11622 < count__11621)){
var vec__11623 = chunk__11620.cljs$core$IIndexed$_nth$arity$2(null,i__11622);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11623,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11623,(1),null);
var G__11624_11635 = v;
var G__11625_11636 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11624_11635,G__11625_11636) : f.call(null,G__11624_11635,G__11625_11636));

var G__11637 = seq__11619;
var G__11638 = chunk__11620;
var G__11639 = count__11621;
var G__11640 = (i__11622 + (1));
seq__11619 = G__11637;
chunk__11620 = G__11638;
count__11621 = G__11639;
i__11622 = G__11640;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11619);
if(temp__4126__auto__){
var seq__11619__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11619__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11619__$1);
var G__11641 = cljs.core.chunk_rest(seq__11619__$1);
var G__11642 = c__4545__auto__;
var G__11643 = cljs.core.count(c__4545__auto__);
var G__11644 = (0);
seq__11619 = G__11641;
chunk__11620 = G__11642;
count__11621 = G__11643;
i__11622 = G__11644;
continue;
} else {
var vec__11626 = cljs.core.first(seq__11619__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11626,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11626,(1),null);
var G__11627_11645 = v;
var G__11628_11646 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11627_11645,G__11628_11646) : f.call(null,G__11627_11645,G__11628_11646));

var G__11647 = cljs.core.next(seq__11619__$1);
var G__11648 = null;
var G__11649 = (0);
var G__11650 = (0);
seq__11619 = G__11647;
chunk__11620 = G__11648;
count__11621 = G__11649;
i__11622 = G__11650;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__11629 = init;
var G__11630 = null;
var G__11631 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11629,G__11630,G__11631) : f.call(null,G__11629,G__11630,G__11631));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__11632 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11632) : cljs.core.deref.call(null,G__11632));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj11634 = {};
return obj11634;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__11651 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__11652 = cljs.core.next(es);
ret = G__11651;
es = G__11652;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__11653 = null;
var G__11653__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11653__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11653 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11653__2.call(this,self__,k);
case 3:
return G__11653__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11653.cljs$core$IFn$_invoke$arity$2 = G__11653__2;
G__11653.cljs$core$IFn$_invoke$arity$3 = G__11653__3;
return G__11653;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args11616){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11616)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function __GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__11654 = (i + (2));
var G__11655 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__11654;
ret = G__11655;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__11656 = (i + (1));
var G__11657 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__11656;
out = G__11657;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__11658 = o;
if(G__11658){
var bit__4439__auto__ = (G__11658.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4439__auto__) || (G__11658.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__11658.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11658);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__11658);
}
})()){
return tcoll.assoc_BANG_((function (){var G__11659 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11659) : cljs.core.key.call(null,G__11659));
})(),(function (){var G__11660 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11660) : cljs.core.val.call(null,G__11660));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__11663 = cljs.core.next(es);
var G__11664 = tcoll__$1.assoc_BANG_((function (){var G__11661 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11661) : cljs.core.key.call(null,G__11661));
})(),(function (){var G__11662 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__11662) : cljs.core.val.call(null,G__11662));
})());
es = G__11663;
tcoll__$1 = G__11664;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function __GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__11665 = ((ascending_QMARK_)?t.left:t.right);
var G__11666 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__11665;
stack__$1 = G__11666;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function __GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.create_tree_map_seq = (function create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__11679 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11679) : cljs.core.deref.call(null,G__11679));
} else {
var init__$2 = (function (){var G__11680 = init__$1;
var G__11681 = node.key;
var G__11682 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11680,G__11681,G__11682) : f.call(null,G__11680,G__11681,G__11682));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__11683 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11683) : cljs.core.deref.call(null,G__11683));
} else {
var init__$3 = ((!((node.right == null)))?tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__11684 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11684) : cljs.core.deref.call(null,G__11684));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__11686 = null;
var G__11686__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11686__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11686 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11686__2.call(this,self__,k);
case 3:
return G__11686__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11686.cljs$core$IFn$_invoke$arity$2 = G__11686__2;
G__11686.cljs$core$IFn$_invoke$arity$3 = G__11686__3;
return G__11686;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args11685){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11685)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function __GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__11688 = null;
var G__11688__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11688__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11688 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11688__2.call(this,self__,k);
case 3:
return G__11688__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11688.cljs$core$IFn$_invoke$arity$2 = G__11688__2;
G__11688.cljs$core$IFn$_invoke$arity$3 = G__11688__3;
return G__11688;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args11687){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11687)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function __GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.tree_map_add = (function tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__11701 = k;
var G__11702 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11701,G__11702) : comp.call(null,G__11701,G__11702));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,tree_map_append(left,right.left),right.right,null));
} else {
var app = tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__11721 = k;
var G__11722 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11721,G__11722) : comp.call(null,G__11721,G__11722));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__11733 = k;
var G__11734 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11733,G__11734) : comp.call(null,G__11733,G__11734));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11736 = cljs.core.seq(coll);
var chunk__11737 = null;
var count__11738 = (0);
var i__11739 = (0);
while(true){
if((i__11739 < count__11738)){
var vec__11740 = chunk__11737.cljs$core$IIndexed$_nth$arity$2(null,i__11739);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11740,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11740,(1),null);
var G__11741_11753 = v;
var G__11742_11754 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11741_11753,G__11742_11754) : f.call(null,G__11741_11753,G__11742_11754));

var G__11755 = seq__11736;
var G__11756 = chunk__11737;
var G__11757 = count__11738;
var G__11758 = (i__11739 + (1));
seq__11736 = G__11755;
chunk__11737 = G__11756;
count__11738 = G__11757;
i__11739 = G__11758;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11736);
if(temp__4126__auto__){
var seq__11736__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11736__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11736__$1);
var G__11759 = cljs.core.chunk_rest(seq__11736__$1);
var G__11760 = c__4545__auto__;
var G__11761 = cljs.core.count(c__4545__auto__);
var G__11762 = (0);
seq__11736 = G__11759;
chunk__11737 = G__11760;
count__11738 = G__11761;
i__11739 = G__11762;
continue;
} else {
var vec__11743 = cljs.core.first(seq__11736__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11743,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11743,(1),null);
var G__11744_11763 = v;
var G__11745_11764 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11744_11763,G__11745_11764) : f.call(null,G__11744_11763,G__11745_11764));

var G__11765 = cljs.core.next(seq__11736__$1);
var G__11766 = null;
var G__11767 = (0);
var G__11768 = (0);
seq__11736 = G__11765;
chunk__11737 = G__11766;
count__11738 = G__11767;
i__11739 = G__11768;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11746 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__11746) : cljs.core.keys.call(null,G__11746));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__11747 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__11747) : cljs.core.vals.call(null,G__11747));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__11748 = k;
var G__11749 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__11748,G__11749) : self__.comp.call(null,G__11748,G__11749));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__11769 = t.left;
t = G__11769;
continue;
} else {
var G__11770 = t.right;
t = G__11770;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__11771 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__11772 = cljs.core.next(es);
ret = G__11771;
es = G__11772;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__11773 = null;
var G__11773__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11773__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11773 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11773__2.call(this,self__,k);
case 3:
return G__11773__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11773.cljs$core$IFn$_invoke$arity$2 = G__11773__2;
G__11773.cljs$core$IFn$_invoke$arity$3 = G__11773__3;
return G__11773;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args11735){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11735)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__11750 = k;
var G__11751 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__11750,G__11751) : self__.comp.call(null,G__11750,G__11751));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__11774 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__11775 = t.left;
stack = G__11774;
t = G__11775;
continue;
} else {
var G__11776 = stack;
var G__11777 = t.right;
stack = G__11776;
t = G__11777;
continue;
}
} else {
if((c > (0))){
var G__11778 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__11779 = t.right;
stack = G__11778;
t = G__11779;
continue;
} else {
var G__11780 = stack;
var G__11781 = t.left;
stack = G__11780;
t = G__11781;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__11752 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__11752) : cljs.core.key.call(null,G__11752));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function __GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* keyval => key val
* Returns a new hash map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.hash_map = (function() { 
var hash_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__11782 = cljs.core.nnext(in$);
var G__11783 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__11782;
out = G__11783;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
};
var hash_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11784__i = 0, G__11784__a = new Array(arguments.length -  0);
while (G__11784__i < G__11784__a.length) {G__11784__a[G__11784__i] = arguments[G__11784__i + 0]; ++G__11784__i;}
  keyvals = new cljs.core.IndexedSeq(G__11784__a,0);
} 
return hash_map__delegate.call(this,keyvals);};
hash_map.cljs$lang$maxFixedArity = 0;
hash_map.cljs$lang$applyTo = (function (arglist__11785){
var keyvals = cljs.core.seq(arglist__11785);
return hash_map__delegate(keyvals);
});
hash_map.cljs$core$IFn$_invoke$arity$variadic = hash_map__delegate;
return hash_map;
})()
;
/**
* keyval => key val
* Returns a new array map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.array_map = (function() { 
var array_map__delegate = function (keyvals){
return cljs.core.PersistentArrayMap.fromArray(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array,keyvals),true,false);
};
var array_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11786__i = 0, G__11786__a = new Array(arguments.length -  0);
while (G__11786__i < G__11786__a.length) {G__11786__a[G__11786__i] = arguments[G__11786__i + 0]; ++G__11786__i;}
  keyvals = new cljs.core.IndexedSeq(G__11786__a,0);
} 
return array_map__delegate.call(this,keyvals);};
array_map.cljs$lang$maxFixedArity = 0;
array_map.cljs$lang$applyTo = (function (arglist__11787){
var keyvals = cljs.core.seq(arglist__11787);
return array_map__delegate(keyvals);
});
array_map.cljs$core$IFn$_invoke$arity$variadic = array_map__delegate;
return array_map;
})()
;
/**
* keyval => key val
* Returns a new object map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.obj_map = (function() { 
var obj_map__delegate = function (keyvals){
var ks = [];
var obj = (function (){var obj11791 = {};
return obj11791;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__11792 = cljs.core.nnext(kvs);
kvs = G__11792;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
};
var obj_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11793__i = 0, G__11793__a = new Array(arguments.length -  0);
while (G__11793__i < G__11793__a.length) {G__11793__a[G__11793__i] = arguments[G__11793__i + 0]; ++G__11793__i;}
  keyvals = new cljs.core.IndexedSeq(G__11793__a,0);
} 
return obj_map__delegate.call(this,keyvals);};
obj_map.cljs$lang$maxFixedArity = 0;
obj_map.cljs$lang$applyTo = (function (arglist__11794){
var keyvals = cljs.core.seq(arglist__11794);
return obj_map__delegate(keyvals);
});
obj_map.cljs$core$IFn$_invoke$arity$variadic = obj_map__delegate;
return obj_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.sorted_map = (function() { 
var sorted_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__11795 = cljs.core.nnext(in$);
var G__11796 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__11795;
out = G__11796;
continue;
} else {
return out;
}
break;
}
};
var sorted_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__11797__i = 0, G__11797__a = new Array(arguments.length -  0);
while (G__11797__i < G__11797__a.length) {G__11797__a[G__11797__i] = arguments[G__11797__i + 0]; ++G__11797__i;}
  keyvals = new cljs.core.IndexedSeq(G__11797__a,0);
} 
return sorted_map__delegate.call(this,keyvals);};
sorted_map.cljs$lang$maxFixedArity = 0;
sorted_map.cljs$lang$applyTo = (function (arglist__11798){
var keyvals = cljs.core.seq(arglist__11798);
return sorted_map__delegate(keyvals);
});
sorted_map.cljs$core$IFn$_invoke$arity$variadic = sorted_map__delegate;
return sorted_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_map_by = (function() { 
var sorted_map_by__delegate = function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__11799 = cljs.core.nnext(in$);
var G__11800 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__11799;
out = G__11800;
continue;
} else {
return out;
}
break;
}
};
var sorted_map_by = function (comparator,var_args){
var keyvals = null;
if (arguments.length > 1) {
var G__11801__i = 0, G__11801__a = new Array(arguments.length -  1);
while (G__11801__i < G__11801__a.length) {G__11801__a[G__11801__i] = arguments[G__11801__i + 1]; ++G__11801__i;}
  keyvals = new cljs.core.IndexedSeq(G__11801__a,0);
} 
return sorted_map_by__delegate.call(this,comparator,keyvals);};
sorted_map_by.cljs$lang$maxFixedArity = 1;
sorted_map_by.cljs$lang$applyTo = (function (arglist__11802){
var comparator = cljs.core.first(arglist__11802);
var keyvals = cljs.core.rest(arglist__11802);
return sorted_map_by__delegate(comparator,keyvals);
});
sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = sorted_map_by__delegate;
return sorted_map_by;
})()
;

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11803 = self__.mseq;
if(G__11803){
var bit__4439__auto__ = (G__11803.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11803.cljs$core$INext$)){
return true;
} else {
if((!G__11803.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11803);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11803);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11804 = self__.mseq;
if(G__11804){
var bit__4439__auto__ = (G__11804.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11804.cljs$core$INext$)){
return true;
} else {
if((!G__11804.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11804);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11804);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function __GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a sequence of the map's keys.
*/
cljs.core.keys = (function keys(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
* Returns the key of the map entry.
*/
cljs.core.key = (function key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11805 = self__.mseq;
if(G__11805){
var bit__4439__auto__ = (G__11805.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11805.cljs$core$INext$)){
return true;
} else {
if((!G__11805.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11805);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11805);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__11806 = self__.mseq;
if(G__11806){
var bit__4439__auto__ = (G__11806.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4439__auto__) || (G__11806.cljs$core$INext$)){
return true;
} else {
if((!G__11806.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11806);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__11806);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function __GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a sequence of the map's values.
*/
cljs.core.vals = (function vals(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
* Returns the value in the map entry.
*/
cljs.core.val = (function val(map_entry){
return cljs.core._val(map_entry);
});
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping from
* the latter (left-to-right) will be the mapping in the result.
* @param {...*} var_args
*/
cljs.core.merge = (function() { 
var merge__delegate = function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__11807_SHARP_,p2__11808_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3758__auto__ = p1__11807_SHARP_;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__11808_SHARP_);
}),maps);
} else {
return null;
}
};
var merge = function (var_args){
var maps = null;
if (arguments.length > 0) {
var G__11809__i = 0, G__11809__a = new Array(arguments.length -  0);
while (G__11809__i < G__11809__a.length) {G__11809__a[G__11809__i] = arguments[G__11809__i + 0]; ++G__11809__i;}
  maps = new cljs.core.IndexedSeq(G__11809__a,0);
} 
return merge__delegate.call(this,maps);};
merge.cljs$lang$maxFixedArity = 0;
merge.cljs$lang$applyTo = (function (arglist__11810){
var maps = cljs.core.seq(arglist__11810);
return merge__delegate(maps);
});
merge.cljs$core$IFn$_invoke$arity$variadic = merge__delegate;
return merge;
})()
;
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping(s)
* from the latter (left-to-right) will be combined with the mapping in
* the result by calling (f val-in-result val-in-latter).
* @param {...*} var_args
*/
cljs.core.merge_with = (function() { 
var merge_with__delegate = function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11813 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11814 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11813,G__11814) : f.call(null,G__11813,G__11814));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__3758__auto__ = m1;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
};
var merge_with = function (f,var_args){
var maps = null;
if (arguments.length > 1) {
var G__11815__i = 0, G__11815__a = new Array(arguments.length -  1);
while (G__11815__i < G__11815__a.length) {G__11815__a[G__11815__i] = arguments[G__11815__i + 1]; ++G__11815__i;}
  maps = new cljs.core.IndexedSeq(G__11815__a,0);
} 
return merge_with__delegate.call(this,f,maps);};
merge_with.cljs$lang$maxFixedArity = 1;
merge_with.cljs$lang$applyTo = (function (arglist__11816){
var f = cljs.core.first(arglist__11816);
var maps = cljs.core.rest(arglist__11816);
return merge_with__delegate(f,maps);
});
merge_with.cljs$core$IFn$_invoke$arity$variadic = merge_with__delegate;
return merge_with;
})()
;
/**
* Returns a map containing only those entries in map whose key is in keys
*/
cljs.core.select_keys = (function select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__11817 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__11818 = cljs.core.next(keys);
ret = G__11817;
keys = G__11818;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11821 = cljs.core.seq(coll);
var chunk__11822 = null;
var count__11823 = (0);
var i__11824 = (0);
while(true){
if((i__11824 < count__11823)){
var vec__11825 = chunk__11822.cljs$core$IIndexed$_nth$arity$2(null,i__11824);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11825,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11825,(1),null);
var G__11826_11831 = v;
var G__11827_11832 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11826_11831,G__11827_11832) : f.call(null,G__11826_11831,G__11827_11832));

var G__11833 = seq__11821;
var G__11834 = chunk__11822;
var G__11835 = count__11823;
var G__11836 = (i__11824 + (1));
seq__11821 = G__11833;
chunk__11822 = G__11834;
count__11823 = G__11835;
i__11824 = G__11836;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11821);
if(temp__4126__auto__){
var seq__11821__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11821__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11821__$1);
var G__11837 = cljs.core.chunk_rest(seq__11821__$1);
var G__11838 = c__4545__auto__;
var G__11839 = cljs.core.count(c__4545__auto__);
var G__11840 = (0);
seq__11821 = G__11837;
chunk__11822 = G__11838;
count__11823 = G__11839;
i__11824 = G__11840;
continue;
} else {
var vec__11828 = cljs.core.first(seq__11821__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11828,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11828,(1),null);
var G__11829_11841 = v;
var G__11830_11842 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11829_11841,G__11830_11842) : f.call(null,G__11829_11841,G__11830_11842));

var G__11843 = cljs.core.next(seq__11821__$1);
var G__11844 = null;
var G__11845 = (0);
var G__11846 = (0);
seq__11821 = G__11843;
chunk__11822 = G__11844;
count__11823 = G__11845;
i__11824 = G__11846;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__11819_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__11819_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__11847 = null;
var G__11847__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11847__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11847 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11847__2.call(this,self__,k);
case 3:
return G__11847__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11847.cljs$core$IFn$_invoke$arity$2 = G__11847__2;
G__11847.cljs$core$IFn$_invoke$arity$3 = G__11847__3;
return G__11847;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args11820){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11820)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function __GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__11848 = (i + (1));
var G__11849 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__11848;
out = G__11849;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__11850 = (i + (1));
var G__11851 = cljs.core._conj_BANG_(out,(items[i]));
i = G__11850;
out = G__11851;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 136;
})
cljs.core.TransientHashSet.prototype.call = (function() {
var G__11853 = null;
var G__11853__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__11853__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__11853 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11853__2.call(this,self__,k);
case 3:
return G__11853__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11853.cljs$core$IFn$_invoke$arity$2 = G__11853__2;
G__11853.cljs$core$IFn$_invoke$arity$3 = G__11853__3;
return G__11853;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args11852){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11852)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function __GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__11856 = cljs.core.seq(coll);
var chunk__11857 = null;
var count__11858 = (0);
var i__11859 = (0);
while(true){
if((i__11859 < count__11858)){
var vec__11860 = chunk__11857.cljs$core$IIndexed$_nth$arity$2(null,i__11859);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11860,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11860,(1),null);
var G__11861_11866 = v;
var G__11862_11867 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11861_11866,G__11862_11867) : f.call(null,G__11861_11866,G__11862_11867));

var G__11868 = seq__11856;
var G__11869 = chunk__11857;
var G__11870 = count__11858;
var G__11871 = (i__11859 + (1));
seq__11856 = G__11868;
chunk__11857 = G__11869;
count__11858 = G__11870;
i__11859 = G__11871;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__11856);
if(temp__4126__auto__){
var seq__11856__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11856__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__11856__$1);
var G__11872 = cljs.core.chunk_rest(seq__11856__$1);
var G__11873 = c__4545__auto__;
var G__11874 = cljs.core.count(c__4545__auto__);
var G__11875 = (0);
seq__11856 = G__11872;
chunk__11857 = G__11873;
count__11858 = G__11874;
i__11859 = G__11875;
continue;
} else {
var vec__11863 = cljs.core.first(seq__11856__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11863,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11863,(1),null);
var G__11864_11876 = v;
var G__11865_11877 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11864_11876,G__11865_11877) : f.call(null,G__11864_11876,G__11865_11877));

var G__11878 = cljs.core.next(seq__11856__$1);
var G__11879 = null;
var G__11880 = (0);
var G__11881 = (0);
seq__11856 = G__11878;
chunk__11857 = G__11879;
count__11858 = G__11880;
i__11859 = G__11881;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__11854_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__11854_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__11882 = null;
var G__11882__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__11882__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__11882 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__11882__2.call(this,self__,k);
case 3:
return G__11882__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11882.cljs$core$IFn$_invoke$arity$2 = G__11882__2;
G__11882.cljs$core$IFn$_invoke$arity$3 = G__11882__3;
return G__11882;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args11855){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11855)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function __GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
cljs.core.set_from_indexed_seq = (function set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4639__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__4639__auto__.length)){
var G__11883 = (i + (1));
var G__11884 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__11883;
res = G__11884;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
* Returns a set of the distinct elements of coll.
*/
cljs.core.set = (function set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__11885 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__11886 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__11885;
out = G__11886;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
* @param {...*} var_args
*/
cljs.core.hash_set = (function() {
var hash_set = null;
var hash_set__0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});
var hash_set__1 = (function() { 
var G__11887__delegate = function (keys){
return cljs.core.set(keys);
};
var G__11887 = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__11888__i = 0, G__11888__a = new Array(arguments.length -  0);
while (G__11888__i < G__11888__a.length) {G__11888__a[G__11888__i] = arguments[G__11888__i + 0]; ++G__11888__i;}
  keys = new cljs.core.IndexedSeq(G__11888__a,0);
} 
return G__11887__delegate.call(this,keys);};
G__11887.cljs$lang$maxFixedArity = 0;
G__11887.cljs$lang$applyTo = (function (arglist__11889){
var keys = cljs.core.seq(arglist__11889);
return G__11887__delegate(keys);
});
G__11887.cljs$core$IFn$_invoke$arity$variadic = G__11887__delegate;
return G__11887;
})()
;
hash_set = function(var_args){
var keys = var_args;
switch(arguments.length){
case 0:
return hash_set__0.call(this);
default:
var G__11890 = null;
if (arguments.length > 0) {
var G__11891__i = 0, G__11891__a = new Array(arguments.length -  0);
while (G__11891__i < G__11891__a.length) {G__11891__a[G__11891__i] = arguments[G__11891__i + 0]; ++G__11891__i;}
G__11890 = new cljs.core.IndexedSeq(G__11891__a,0);
}
return hash_set__1.cljs$core$IFn$_invoke$arity$variadic(G__11890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hash_set.cljs$lang$maxFixedArity = 0;
hash_set.cljs$lang$applyTo = hash_set__1.cljs$lang$applyTo;
hash_set.cljs$core$IFn$_invoke$arity$0 = hash_set__0;
hash_set.cljs$core$IFn$_invoke$arity$variadic = hash_set__1.cljs$core$IFn$_invoke$arity$variadic;
return hash_set;
})()
;
/**
* Returns a new sorted set with supplied keys.
* @param {...*} var_args
*/
cljs.core.sorted_set = (function() { 
var sorted_set__delegate = function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
};
var sorted_set = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__11892__i = 0, G__11892__a = new Array(arguments.length -  0);
while (G__11892__i < G__11892__a.length) {G__11892__a[G__11892__i] = arguments[G__11892__i + 0]; ++G__11892__i;}
  keys = new cljs.core.IndexedSeq(G__11892__a,0);
} 
return sorted_set__delegate.call(this,keys);};
sorted_set.cljs$lang$maxFixedArity = 0;
sorted_set.cljs$lang$applyTo = (function (arglist__11893){
var keys = cljs.core.seq(arglist__11893);
return sorted_set__delegate(keys);
});
sorted_set.cljs$core$IFn$_invoke$arity$variadic = sorted_set__delegate;
return sorted_set;
})()
;
/**
* Returns a new sorted set with supplied keys, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_set_by = (function() { 
var sorted_set_by__delegate = function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
};
var sorted_set_by = function (comparator,var_args){
var keys = null;
if (arguments.length > 1) {
var G__11894__i = 0, G__11894__a = new Array(arguments.length -  1);
while (G__11894__i < G__11894__a.length) {G__11894__a[G__11894__i] = arguments[G__11894__i + 1]; ++G__11894__i;}
  keys = new cljs.core.IndexedSeq(G__11894__a,0);
} 
return sorted_set_by__delegate.call(this,comparator,keys);};
sorted_set_by.cljs$lang$maxFixedArity = 1;
sorted_set_by.cljs$lang$applyTo = (function (arglist__11895){
var comparator = cljs.core.first(arglist__11895);
var keys = cljs.core.rest(arglist__11895);
return sorted_set_by__delegate(comparator,keys);
});
sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = sorted_set_by__delegate;
return sorted_set_by;
})()
;
/**
* Given a map of replacement pairs and a vector/collection, returns a
* vector/seq with any elements = a key in smap replaced with the
* corresponding val in smap.  Returns a transducer when no collection
* is provided.
*/
cljs.core.replace = (function() {
var replace = null;
var replace__1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__11896_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__11896_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.val(e);
} else {
return p1__11896_SHARP_;
}
}));
});
var replace__2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4124__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11897_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__11897_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.second(e);
} else {
return p1__11897_SHARP_;
}
}),coll);
}
});
replace = function(smap,coll){
switch(arguments.length){
case 1:
return replace__1.call(this,smap);
case 2:
return replace__2.call(this,smap,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
replace.cljs$core$IFn$_invoke$arity$1 = replace__1;
replace.cljs$core$IFn$_invoke$arity$2 = replace__2;
return replace;
})()
;
/**
* Returns a lazy sequence of the elements of coll with duplicates removed
*/
cljs.core.distinct = (function() {
var distinct = null;
var distinct__0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__11918 = null;
var G__11918__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11918__1 = (function (result){
var G__11908 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11908) : rf.call(null,G__11908));
});
var G__11918__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__11909 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__11909) : cljs.core.deref.call(null,G__11909));
})(),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

var G__11910 = result;
var G__11911 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11910,G__11911) : rf.call(null,G__11910,G__11911));
}
});
G__11918 = function(result,input){
switch(arguments.length){
case 0:
return G__11918__0.call(this);
case 1:
return G__11918__1.call(this,result);
case 2:
return G__11918__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11918.cljs$core$IFn$_invoke$arity$0 = G__11918__0;
G__11918.cljs$core$IFn$_invoke$arity$1 = G__11918__1;
G__11918.cljs$core$IFn$_invoke$arity$2 = G__11918__2;
return G__11918;
})()
;})(seen))
});
});
var distinct__1 = (function (coll){
var step = (function step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__11916,seen__$1){
while(true){
var vec__11917 = p__11916;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11917,(0),null);
var xs__$1 = vec__11917;
var temp__4126__auto__ = cljs.core.seq(xs__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__11919 = cljs.core.rest(s);
var G__11920 = seen__$1;
p__11916 = G__11919;
seen__$1 = G__11920;
continue;
} else {
return cljs.core.cons(f,step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
distinct = function(coll){
switch(arguments.length){
case 0:
return distinct__0.call(this);
case 1:
return distinct__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
distinct.cljs$core$IFn$_invoke$arity$0 = distinct__0;
distinct.cljs$core$IFn$_invoke$arity$1 = distinct__1;
return distinct;
})()
;
cljs.core.butlast = (function butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__11921 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__11922 = cljs.core.next(s__$1);
ret = G__11921;
s__$1 = G__11922;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
* Returns the name String of a string, symbol or keyword.
*/
cljs.core.name = (function name(x){
if((function (){var G__11924 = x;
if(G__11924){
var bit__4432__auto__ = (G__11924.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4432__auto__) || (G__11924.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
* Returns a map with the keys mapped to the corresponding vals.
*/
cljs.core.zipmap = (function zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__11925 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__11926 = cljs.core.next(ks);
var G__11927 = cljs.core.next(vs);
map = G__11925;
ks = G__11926;
vs = G__11927;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
* Returns the x for which (k x), a number, is greatest.
* @param {...*} var_args
*/
cljs.core.max_key = (function() {
var max_key = null;
var max_key__2 = (function (k,x){
return x;
});
var max_key__3 = (function (k,x,y){
if(((function (){var G__11938 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11938) : k.call(null,G__11938));
})() > (function (){var G__11939 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11939) : k.call(null,G__11939));
})())){
return x;
} else {
return y;
}
});
var max_key__4 = (function() { 
var G__11940__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__11928_SHARP_,p2__11929_SHARP_){
return max_key.cljs$core$IFn$_invoke$arity$3(k,p1__11928_SHARP_,p2__11929_SHARP_);
}),max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__11940 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__11941__i = 0, G__11941__a = new Array(arguments.length -  3);
while (G__11941__i < G__11941__a.length) {G__11941__a[G__11941__i] = arguments[G__11941__i + 3]; ++G__11941__i;}
  more = new cljs.core.IndexedSeq(G__11941__a,0);
} 
return G__11940__delegate.call(this,k,x,y,more);};
G__11940.cljs$lang$maxFixedArity = 3;
G__11940.cljs$lang$applyTo = (function (arglist__11942){
var k = cljs.core.first(arglist__11942);
arglist__11942 = cljs.core.next(arglist__11942);
var x = cljs.core.first(arglist__11942);
arglist__11942 = cljs.core.next(arglist__11942);
var y = cljs.core.first(arglist__11942);
var more = cljs.core.rest(arglist__11942);
return G__11940__delegate(k,x,y,more);
});
G__11940.cljs$core$IFn$_invoke$arity$variadic = G__11940__delegate;
return G__11940;
})()
;
max_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return max_key__2.call(this,k,x);
case 3:
return max_key__3.call(this,k,x,y);
default:
var G__11943 = null;
if (arguments.length > 3) {
var G__11944__i = 0, G__11944__a = new Array(arguments.length -  3);
while (G__11944__i < G__11944__a.length) {G__11944__a[G__11944__i] = arguments[G__11944__i + 3]; ++G__11944__i;}
G__11943 = new cljs.core.IndexedSeq(G__11944__a,0);
}
return max_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__11943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
max_key.cljs$lang$maxFixedArity = 3;
max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
max_key.cljs$core$IFn$_invoke$arity$2 = max_key__2;
max_key.cljs$core$IFn$_invoke$arity$3 = max_key__3;
max_key.cljs$core$IFn$_invoke$arity$variadic = max_key__4.cljs$core$IFn$_invoke$arity$variadic;
return max_key;
})()
;
/**
* Returns the x for which (k x), a number, is least.
* @param {...*} var_args
*/
cljs.core.min_key = (function() {
var min_key = null;
var min_key__2 = (function (k,x){
return x;
});
var min_key__3 = (function (k,x,y){
if(((function (){var G__11955 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11955) : k.call(null,G__11955));
})() < (function (){var G__11956 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__11956) : k.call(null,G__11956));
})())){
return x;
} else {
return y;
}
});
var min_key__4 = (function() { 
var G__11957__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__11945_SHARP_,p2__11946_SHARP_){
return min_key.cljs$core$IFn$_invoke$arity$3(k,p1__11945_SHARP_,p2__11946_SHARP_);
}),min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__11957 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__11958__i = 0, G__11958__a = new Array(arguments.length -  3);
while (G__11958__i < G__11958__a.length) {G__11958__a[G__11958__i] = arguments[G__11958__i + 3]; ++G__11958__i;}
  more = new cljs.core.IndexedSeq(G__11958__a,0);
} 
return G__11957__delegate.call(this,k,x,y,more);};
G__11957.cljs$lang$maxFixedArity = 3;
G__11957.cljs$lang$applyTo = (function (arglist__11959){
var k = cljs.core.first(arglist__11959);
arglist__11959 = cljs.core.next(arglist__11959);
var x = cljs.core.first(arglist__11959);
arglist__11959 = cljs.core.next(arglist__11959);
var y = cljs.core.first(arglist__11959);
var more = cljs.core.rest(arglist__11959);
return G__11957__delegate(k,x,y,more);
});
G__11957.cljs$core$IFn$_invoke$arity$variadic = G__11957__delegate;
return G__11957;
})()
;
min_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return min_key__2.call(this,k,x);
case 3:
return min_key__3.call(this,k,x,y);
default:
var G__11960 = null;
if (arguments.length > 3) {
var G__11961__i = 0, G__11961__a = new Array(arguments.length -  3);
while (G__11961__i < G__11961__a.length) {G__11961__a[G__11961__i] = arguments[G__11961__i + 3]; ++G__11961__i;}
G__11960 = new cljs.core.IndexedSeq(G__11961__a,0);
}
return min_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__11960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
min_key.cljs$lang$maxFixedArity = 3;
min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
min_key.cljs$core$IFn$_invoke$arity$2 = min_key__2;
min_key.cljs$core$IFn$_invoke$arity$3 = min_key__3;
min_key.cljs$core$IFn$_invoke$arity$variadic = min_key__4.cljs$core$IFn$_invoke$arity$variadic;
return min_key;
})()
;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function __GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function array_list(){
return (new cljs.core.ArrayList([]));
});
/**
* Returns a lazy sequence of lists like partition, but may include
* partitions with fewer than n items at the end.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.partition_all = (function() {
var partition_all = null;
var partition_all__1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__11978 = null;
var G__11978__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11978__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__11973 = result;
var G__11974 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11973,G__11974) : rf.call(null,G__11973,G__11974));
})());
})());
var G__11975 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11975) : rf.call(null,G__11975));
});
var G__11978__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__11976 = result;
var G__11977 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11976,G__11977) : rf.call(null,G__11976,G__11977));
} else {
return result;
}
});
G__11978 = function(result,input){
switch(arguments.length){
case 0:
return G__11978__0.call(this);
case 1:
return G__11978__1.call(this,result);
case 2:
return G__11978__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11978.cljs$core$IFn$_invoke$arity$0 = G__11978__0;
G__11978.cljs$core$IFn$_invoke$arity$1 = G__11978__1;
G__11978.cljs$core$IFn$_invoke$arity$2 = G__11978__2;
return G__11978;
})()
;})(a))
});
});
var partition_all__2 = (function (n,coll){
return partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var partition_all__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});
partition_all = function(n,step,coll){
switch(arguments.length){
case 1:
return partition_all__1.call(this,n);
case 2:
return partition_all__2.call(this,n,step);
case 3:
return partition_all__3.call(this,n,step,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_all.cljs$core$IFn$_invoke$arity$1 = partition_all__1;
partition_all.cljs$core$IFn$_invoke$arity$2 = partition_all__2;
partition_all.cljs$core$IFn$_invoke$arity$3 = partition_all__3;
return partition_all;
})()
;
/**
* Returns a lazy sequence of successive items from coll while
* (pred item) returns true. pred must be free of side-effects.
* Returns a transducer when no collection is provided.
*/
cljs.core.take_while = (function() {
var take_while = null;
var take_while__1 = (function (pred){
return (function (rf){
return (function() {
var G__11991 = null;
var G__11991__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11991__1 = (function (result){
var G__11986 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__11986) : rf.call(null,G__11986));
});
var G__11991__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__11987 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11987) : pred.call(null,G__11987));
})())){
var G__11988 = result;
var G__11989 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11988,G__11989) : rf.call(null,G__11988,G__11989));
} else {
return cljs.core.reduced(result);
}
});
G__11991 = function(result,input){
switch(arguments.length){
case 0:
return G__11991__0.call(this);
case 1:
return G__11991__1.call(this,result);
case 2:
return G__11991__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11991.cljs$core$IFn$_invoke$arity$0 = G__11991__0;
G__11991.cljs$core$IFn$_invoke$arity$1 = G__11991__1;
G__11991.cljs$core$IFn$_invoke$arity$2 = G__11991__2;
return G__11991;
})()
});
});
var take_while__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.truth_((function (){var G__11990 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11990) : pred.call(null,G__11990));
})())){
return cljs.core.cons(cljs.core.first(s),take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
take_while = function(pred,coll){
switch(arguments.length){
case 1:
return take_while__1.call(this,pred);
case 2:
return take_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_while.cljs$core$IFn$_invoke$arity$1 = take_while__1;
take_while.cljs$core$IFn$_invoke$arity$2 = take_while__2;
return take_while;
})()
;
cljs.core.mk_bound_fn = (function mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__11996 = (function (){var G__11998 = cljs.core._entry_key(sc,e);
var G__11999 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__11998,G__11999) : comp.call(null,G__11998,G__11999));
})();
var G__11997 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__11996,G__11997) : test.call(null,G__11996,G__11997));
});
});
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.subseq = (function() {
var subseq = null;
var subseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12003 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12003,(0),null);
var s = vec__12003;
if(cljs.core.truth_((function (){var G__12004 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__12004) : include.call(null,G__12004));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});
var subseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12005 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12005,(0),null);
var s = vec__12005;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
subseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return subseq__3.call(this,sc,start_test,start_key);
case 5:
return subseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
subseq.cljs$core$IFn$_invoke$arity$3 = subseq__3;
subseq.cljs$core$IFn$_invoke$arity$5 = subseq__5;
return subseq;
})()
;
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a reverse seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.rsubseq = (function() {
var rsubseq = null;
var rsubseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12009 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12009,(0),null);
var s = vec__12009;
if(cljs.core.truth_((function (){var G__12010 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__12010) : include.call(null,G__12010));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});
var rsubseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__12011 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12011,(0),null);
var s = vec__12011;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
rsubseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return rsubseq__3.call(this,sc,start_test,start_key);
case 5:
return rsubseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
rsubseq.cljs$core$IFn$_invoke$arity$3 = rsubseq__3;
rsubseq.cljs$core$IFn$_invoke$arity$5 = rsubseq__5;
return rsubseq;
})()
;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function __GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__12012 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__12012) : Math.ceil.call(null,G__12012));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__12013 = ret;
var G__12014 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12013,G__12014) : f.call(null,G__12013,G__12014));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__12015 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12015) : cljs.core.deref.call(null,G__12015));
} else {
var G__12016 = (i + self__.step);
var G__12017 = ret__$1;
i = G__12016;
ret = G__12017;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function __GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a lazy seq of nums from start (inclusive) to end
* (exclusive), by step, where start defaults to 0, step to 1,
* and end to infinity.
*/
cljs.core.range = (function() {
var range = null;
var range__0 = (function (){
return range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});
var range__1 = (function (end){
return range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});
var range__2 = (function (start,end){
return range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});
var range__3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});
range = function(start,end,step){
switch(arguments.length){
case 0:
return range__0.call(this);
case 1:
return range__1.call(this,start);
case 2:
return range__2.call(this,start,end);
case 3:
return range__3.call(this,start,end,step);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
range.cljs$core$IFn$_invoke$arity$0 = range__0;
range.cljs$core$IFn$_invoke$arity$1 = range__1;
range.cljs$core$IFn$_invoke$arity$2 = range__2;
range.cljs$core$IFn$_invoke$arity$3 = range__3;
return range;
})()
;
/**
* Returns a lazy seq of every nth item in coll.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.take_nth = (function() {
var take_nth = null;
var take_nth__1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__12035 = null;
var G__12035__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12035__1 = (function (result){
var G__12032 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12032) : rf.call(null,G__12032));
});
var G__12035__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__12033 = result;
var G__12034 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12033,G__12034) : rf.call(null,G__12033,G__12034));
} else {
return result;
}
});
G__12035 = function(result,input){
switch(arguments.length){
case 0:
return G__12035__0.call(this);
case 1:
return G__12035__1.call(this,result);
case 2:
return G__12035__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12035.cljs$core$IFn$_invoke$arity$0 = G__12035__0;
G__12035.cljs$core$IFn$_invoke$arity$1 = G__12035__1;
G__12035.cljs$core$IFn$_invoke$arity$2 = G__12035__2;
return G__12035;
})()
;})(ia))
});
});
var take_nth__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});
take_nth = function(n,coll){
switch(arguments.length){
case 1:
return take_nth__1.call(this,n);
case 2:
return take_nth__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_nth.cljs$core$IFn$_invoke$arity$1 = take_nth__1;
take_nth.cljs$core$IFn$_invoke$arity$2 = take_nth__2;
return take_nth;
})()
;
/**
* Returns a vector of [(take-while pred coll) (drop-while pred coll)]
*/
cljs.core.split_with = (function split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
* Applies f to each value in coll, splitting it each time f returns a
* new value.  Returns a lazy seq of partitions.  Returns a stateful
* transducer when no collection is provided.
*/
cljs.core.partition_by = (function() {
var partition_by = null;
var partition_by__1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__12057 = null;
var G__12057__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12057__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__12048 = result;
var G__12049 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12048,G__12049) : rf.call(null,G__12048,G__12049));
})());
})());
var G__12050 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12050) : rf.call(null,G__12050));
});
var G__12057__2 = (function (result,input){
var pval = (function (){var G__12051 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12051) : cljs.core.deref.call(null,G__12051));
})();
var val = (function (){var G__12052 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12052) : f.call(null,G__12052));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__12053 = result;
var G__12054 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12053,G__12054) : rf.call(null,G__12053,G__12054));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__12057 = function(result,input){
switch(arguments.length){
case 0:
return G__12057__0.call(this);
case 1:
return G__12057__1.call(this,result);
case 2:
return G__12057__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12057.cljs$core$IFn$_invoke$arity$0 = G__12057__0;
G__12057.cljs$core$IFn$_invoke$arity$1 = G__12057__1;
G__12057.cljs$core$IFn$_invoke$arity$2 = G__12057__2;
return G__12057;
})()
;})(a,pa))
});
});
var partition_by__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__12055 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12055) : f.call(null,G__12055));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4126__auto__){
return (function (p1__12036_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__12056 = p1__12036_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12056) : f.call(null,G__12056));
})());
});})(fst,fv,s,temp__4126__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});
partition_by = function(f,coll){
switch(arguments.length){
case 1:
return partition_by__1.call(this,f);
case 2:
return partition_by__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$1 = partition_by__1;
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
return partition_by;
})()
;
/**
* Returns a map from distinct items in coll to the number of times
* they appear.
*/
cljs.core.frequencies = (function frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Returns a lazy seq of the intermediate values of the reduction (as
* per reduce) of coll by f, starting with init.
*/
cljs.core.reductions = (function() {
var reductions = null;
var reductions__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
return reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});
var reductions__3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__12066 = init;
var G__12067 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12066,G__12067) : f.call(null,G__12066,G__12067));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});
reductions = function(f,init,coll){
switch(arguments.length){
case 2:
return reductions__2.call(this,f,init);
case 3:
return reductions__3.call(this,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
reductions.cljs$core$IFn$_invoke$arity$2 = reductions__2;
reductions.cljs$core$IFn$_invoke$arity$3 = reductions__3;
return reductions;
})()
;
/**
* Takes a set of functions and returns a fn that is the juxtaposition
* of those fns.  The returned fn takes a variable number of args, and
* returns a vector containing the result of applying each fn to the
* args (left-to-right).
* ((juxt a b c) x) => [(a x) (b x) (c x)]
* @param {...*} var_args
*/
cljs.core.juxt = (function() {
var juxt = null;
var juxt__1 = (function (f){
return (function() {
var G__12162 = null;
var G__12162__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__12162__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12120 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12120) : f.call(null,G__12120));
})()],null));
});
var G__12162__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12121 = x;
var G__12122 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12121,G__12122) : f.call(null,G__12121,G__12122));
})()],null));
});
var G__12162__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12123 = x;
var G__12124 = y;
var G__12125 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12123,G__12124,G__12125) : f.call(null,G__12123,G__12124,G__12125));
})()],null));
});
var G__12162__4 = (function() { 
var G__12163__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__12163 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12164__i = 0, G__12164__a = new Array(arguments.length -  3);
while (G__12164__i < G__12164__a.length) {G__12164__a[G__12164__i] = arguments[G__12164__i + 3]; ++G__12164__i;}
  args = new cljs.core.IndexedSeq(G__12164__a,0);
} 
return G__12163__delegate.call(this,x,y,z,args);};
G__12163.cljs$lang$maxFixedArity = 3;
G__12163.cljs$lang$applyTo = (function (arglist__12165){
var x = cljs.core.first(arglist__12165);
arglist__12165 = cljs.core.next(arglist__12165);
var y = cljs.core.first(arglist__12165);
arglist__12165 = cljs.core.next(arglist__12165);
var z = cljs.core.first(arglist__12165);
var args = cljs.core.rest(arglist__12165);
return G__12163__delegate(x,y,z,args);
});
G__12163.cljs$core$IFn$_invoke$arity$variadic = G__12163__delegate;
return G__12163;
})()
;
G__12162 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12162__0.call(this);
case 1:
return G__12162__1.call(this,x);
case 2:
return G__12162__2.call(this,x,y);
case 3:
return G__12162__3.call(this,x,y,z);
default:
var G__12166 = null;
if (arguments.length > 3) {
var G__12167__i = 0, G__12167__a = new Array(arguments.length -  3);
while (G__12167__i < G__12167__a.length) {G__12167__a[G__12167__i] = arguments[G__12167__i + 3]; ++G__12167__i;}
G__12166 = new cljs.core.IndexedSeq(G__12167__a,0);
}
return G__12162__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12162.cljs$lang$maxFixedArity = 3;
G__12162.cljs$lang$applyTo = G__12162__4.cljs$lang$applyTo;
G__12162.cljs$core$IFn$_invoke$arity$0 = G__12162__0;
G__12162.cljs$core$IFn$_invoke$arity$1 = G__12162__1;
G__12162.cljs$core$IFn$_invoke$arity$2 = G__12162__2;
G__12162.cljs$core$IFn$_invoke$arity$3 = G__12162__3;
G__12162.cljs$core$IFn$_invoke$arity$variadic = G__12162__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12162;
})()
});
var juxt__2 = (function (f,g){
return (function() {
var G__12168 = null;
var G__12168__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__12168__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12126 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12126) : f.call(null,G__12126));
})(),(function (){var G__12127 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__12127) : g.call(null,G__12127));
})()],null));
});
var G__12168__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12128 = x;
var G__12129 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12128,G__12129) : f.call(null,G__12128,G__12129));
})(),(function (){var G__12130 = x;
var G__12131 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__12130,G__12131) : g.call(null,G__12130,G__12131));
})()],null));
});
var G__12168__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12132 = x;
var G__12133 = y;
var G__12134 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12132,G__12133,G__12134) : f.call(null,G__12132,G__12133,G__12134));
})(),(function (){var G__12135 = x;
var G__12136 = y;
var G__12137 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__12135,G__12136,G__12137) : g.call(null,G__12135,G__12136,G__12137));
})()],null));
});
var G__12168__4 = (function() { 
var G__12169__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__12169 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12170__i = 0, G__12170__a = new Array(arguments.length -  3);
while (G__12170__i < G__12170__a.length) {G__12170__a[G__12170__i] = arguments[G__12170__i + 3]; ++G__12170__i;}
  args = new cljs.core.IndexedSeq(G__12170__a,0);
} 
return G__12169__delegate.call(this,x,y,z,args);};
G__12169.cljs$lang$maxFixedArity = 3;
G__12169.cljs$lang$applyTo = (function (arglist__12171){
var x = cljs.core.first(arglist__12171);
arglist__12171 = cljs.core.next(arglist__12171);
var y = cljs.core.first(arglist__12171);
arglist__12171 = cljs.core.next(arglist__12171);
var z = cljs.core.first(arglist__12171);
var args = cljs.core.rest(arglist__12171);
return G__12169__delegate(x,y,z,args);
});
G__12169.cljs$core$IFn$_invoke$arity$variadic = G__12169__delegate;
return G__12169;
})()
;
G__12168 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12168__0.call(this);
case 1:
return G__12168__1.call(this,x);
case 2:
return G__12168__2.call(this,x,y);
case 3:
return G__12168__3.call(this,x,y,z);
default:
var G__12172 = null;
if (arguments.length > 3) {
var G__12173__i = 0, G__12173__a = new Array(arguments.length -  3);
while (G__12173__i < G__12173__a.length) {G__12173__a[G__12173__i] = arguments[G__12173__i + 3]; ++G__12173__i;}
G__12172 = new cljs.core.IndexedSeq(G__12173__a,0);
}
return G__12168__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12168.cljs$lang$maxFixedArity = 3;
G__12168.cljs$lang$applyTo = G__12168__4.cljs$lang$applyTo;
G__12168.cljs$core$IFn$_invoke$arity$0 = G__12168__0;
G__12168.cljs$core$IFn$_invoke$arity$1 = G__12168__1;
G__12168.cljs$core$IFn$_invoke$arity$2 = G__12168__2;
G__12168.cljs$core$IFn$_invoke$arity$3 = G__12168__3;
G__12168.cljs$core$IFn$_invoke$arity$variadic = G__12168__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12168;
})()
});
var juxt__3 = (function (f,g,h){
return (function() {
var G__12174 = null;
var G__12174__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__12174__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12138 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12138) : f.call(null,G__12138));
})(),(function (){var G__12139 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__12139) : g.call(null,G__12139));
})(),(function (){var G__12140 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__12140) : h.call(null,G__12140));
})()],null));
});
var G__12174__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12141 = x;
var G__12142 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12141,G__12142) : f.call(null,G__12141,G__12142));
})(),(function (){var G__12143 = x;
var G__12144 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__12143,G__12144) : g.call(null,G__12143,G__12144));
})(),(function (){var G__12145 = x;
var G__12146 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__12145,G__12146) : h.call(null,G__12145,G__12146));
})()],null));
});
var G__12174__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__12147 = x;
var G__12148 = y;
var G__12149 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12147,G__12148,G__12149) : f.call(null,G__12147,G__12148,G__12149));
})(),(function (){var G__12150 = x;
var G__12151 = y;
var G__12152 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__12150,G__12151,G__12152) : g.call(null,G__12150,G__12151,G__12152));
})(),(function (){var G__12153 = x;
var G__12154 = y;
var G__12155 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__12153,G__12154,G__12155) : h.call(null,G__12153,G__12154,G__12155));
})()],null));
});
var G__12174__4 = (function() { 
var G__12175__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__12175 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12176__i = 0, G__12176__a = new Array(arguments.length -  3);
while (G__12176__i < G__12176__a.length) {G__12176__a[G__12176__i] = arguments[G__12176__i + 3]; ++G__12176__i;}
  args = new cljs.core.IndexedSeq(G__12176__a,0);
} 
return G__12175__delegate.call(this,x,y,z,args);};
G__12175.cljs$lang$maxFixedArity = 3;
G__12175.cljs$lang$applyTo = (function (arglist__12177){
var x = cljs.core.first(arglist__12177);
arglist__12177 = cljs.core.next(arglist__12177);
var y = cljs.core.first(arglist__12177);
arglist__12177 = cljs.core.next(arglist__12177);
var z = cljs.core.first(arglist__12177);
var args = cljs.core.rest(arglist__12177);
return G__12175__delegate(x,y,z,args);
});
G__12175.cljs$core$IFn$_invoke$arity$variadic = G__12175__delegate;
return G__12175;
})()
;
G__12174 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12174__0.call(this);
case 1:
return G__12174__1.call(this,x);
case 2:
return G__12174__2.call(this,x,y);
case 3:
return G__12174__3.call(this,x,y,z);
default:
var G__12178 = null;
if (arguments.length > 3) {
var G__12179__i = 0, G__12179__a = new Array(arguments.length -  3);
while (G__12179__i < G__12179__a.length) {G__12179__a[G__12179__i] = arguments[G__12179__i + 3]; ++G__12179__i;}
G__12178 = new cljs.core.IndexedSeq(G__12179__a,0);
}
return G__12174__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12174.cljs$lang$maxFixedArity = 3;
G__12174.cljs$lang$applyTo = G__12174__4.cljs$lang$applyTo;
G__12174.cljs$core$IFn$_invoke$arity$0 = G__12174__0;
G__12174.cljs$core$IFn$_invoke$arity$1 = G__12174__1;
G__12174.cljs$core$IFn$_invoke$arity$2 = G__12174__2;
G__12174.cljs$core$IFn$_invoke$arity$3 = G__12174__3;
G__12174.cljs$core$IFn$_invoke$arity$variadic = G__12174__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12174;
})()
});
var juxt__4 = (function() { 
var G__12180__delegate = function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__12181 = null;
var G__12181__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12068_SHARP_,p2__12069_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12068_SHARP_,(function (){return (p2__12069_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__12069_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__12069_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12181__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12070_SHARP_,p2__12071_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12070_SHARP_,(function (){var G__12156 = x;
return (p2__12071_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__12071_SHARP_.cljs$core$IFn$_invoke$arity$1(G__12156) : p2__12071_SHARP_.call(null,G__12156));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12181__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12072_SHARP_,p2__12073_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12072_SHARP_,(function (){var G__12157 = x;
var G__12158 = y;
return (p2__12073_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__12073_SHARP_.cljs$core$IFn$_invoke$arity$2(G__12157,G__12158) : p2__12073_SHARP_.call(null,G__12157,G__12158));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12181__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12074_SHARP_,p2__12075_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12074_SHARP_,(function (){var G__12159 = x;
var G__12160 = y;
var G__12161 = z;
return (p2__12075_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__12075_SHARP_.cljs$core$IFn$_invoke$arity$3(G__12159,G__12160,G__12161) : p2__12075_SHARP_.call(null,G__12159,G__12160,G__12161));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__12181__4 = (function() { 
var G__12182__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__12076_SHARP_,p2__12077_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12076_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__12077_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__12182 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12183__i = 0, G__12183__a = new Array(arguments.length -  3);
while (G__12183__i < G__12183__a.length) {G__12183__a[G__12183__i] = arguments[G__12183__i + 3]; ++G__12183__i;}
  args = new cljs.core.IndexedSeq(G__12183__a,0);
} 
return G__12182__delegate.call(this,x,y,z,args);};
G__12182.cljs$lang$maxFixedArity = 3;
G__12182.cljs$lang$applyTo = (function (arglist__12184){
var x = cljs.core.first(arglist__12184);
arglist__12184 = cljs.core.next(arglist__12184);
var y = cljs.core.first(arglist__12184);
arglist__12184 = cljs.core.next(arglist__12184);
var z = cljs.core.first(arglist__12184);
var args = cljs.core.rest(arglist__12184);
return G__12182__delegate(x,y,z,args);
});
G__12182.cljs$core$IFn$_invoke$arity$variadic = G__12182__delegate;
return G__12182;
})()
;
G__12181 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12181__0.call(this);
case 1:
return G__12181__1.call(this,x);
case 2:
return G__12181__2.call(this,x,y);
case 3:
return G__12181__3.call(this,x,y,z);
default:
var G__12185 = null;
if (arguments.length > 3) {
var G__12186__i = 0, G__12186__a = new Array(arguments.length -  3);
while (G__12186__i < G__12186__a.length) {G__12186__a[G__12186__i] = arguments[G__12186__i + 3]; ++G__12186__i;}
G__12185 = new cljs.core.IndexedSeq(G__12186__a,0);
}
return G__12181__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12181.cljs$lang$maxFixedArity = 3;
G__12181.cljs$lang$applyTo = G__12181__4.cljs$lang$applyTo;
G__12181.cljs$core$IFn$_invoke$arity$0 = G__12181__0;
G__12181.cljs$core$IFn$_invoke$arity$1 = G__12181__1;
G__12181.cljs$core$IFn$_invoke$arity$2 = G__12181__2;
G__12181.cljs$core$IFn$_invoke$arity$3 = G__12181__3;
G__12181.cljs$core$IFn$_invoke$arity$variadic = G__12181__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12181;
})()
;})(fs__$1))
};
var G__12180 = function (f,g,h,var_args){
var fs = null;
if (arguments.length > 3) {
var G__12187__i = 0, G__12187__a = new Array(arguments.length -  3);
while (G__12187__i < G__12187__a.length) {G__12187__a[G__12187__i] = arguments[G__12187__i + 3]; ++G__12187__i;}
  fs = new cljs.core.IndexedSeq(G__12187__a,0);
} 
return G__12180__delegate.call(this,f,g,h,fs);};
G__12180.cljs$lang$maxFixedArity = 3;
G__12180.cljs$lang$applyTo = (function (arglist__12188){
var f = cljs.core.first(arglist__12188);
arglist__12188 = cljs.core.next(arglist__12188);
var g = cljs.core.first(arglist__12188);
arglist__12188 = cljs.core.next(arglist__12188);
var h = cljs.core.first(arglist__12188);
var fs = cljs.core.rest(arglist__12188);
return G__12180__delegate(f,g,h,fs);
});
G__12180.cljs$core$IFn$_invoke$arity$variadic = G__12180__delegate;
return G__12180;
})()
;
juxt = function(f,g,h,var_args){
var fs = var_args;
switch(arguments.length){
case 1:
return juxt__1.call(this,f);
case 2:
return juxt__2.call(this,f,g);
case 3:
return juxt__3.call(this,f,g,h);
default:
var G__12189 = null;
if (arguments.length > 3) {
var G__12190__i = 0, G__12190__a = new Array(arguments.length -  3);
while (G__12190__i < G__12190__a.length) {G__12190__a[G__12190__i] = arguments[G__12190__i + 3]; ++G__12190__i;}
G__12189 = new cljs.core.IndexedSeq(G__12190__a,0);
}
return juxt__4.cljs$core$IFn$_invoke$arity$variadic(f,g,h, G__12189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
juxt.cljs$lang$maxFixedArity = 3;
juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
juxt.cljs$core$IFn$_invoke$arity$1 = juxt__1;
juxt.cljs$core$IFn$_invoke$arity$2 = juxt__2;
juxt.cljs$core$IFn$_invoke$arity$3 = juxt__3;
juxt.cljs$core$IFn$_invoke$arity$variadic = juxt__4.cljs$core$IFn$_invoke$arity$variadic;
return juxt;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. dorun can
* be used to force any effects. Walks through the successive nexts of
* the seq, does not retain the head and returns nil.
*/
cljs.core.dorun = (function() {
var dorun = null;
var dorun__1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__12191 = cljs.core.next(coll);
coll = G__12191;
continue;
} else {
return null;
}
break;
}
});
var dorun__2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__12192 = (n - (1));
var G__12193 = cljs.core.next(coll);
n = G__12192;
coll = G__12193;
continue;
} else {
return null;
}
break;
}
});
dorun = function(n,coll){
switch(arguments.length){
case 1:
return dorun__1.call(this,n);
case 2:
return dorun__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dorun.cljs$core$IFn$_invoke$arity$1 = dorun__1;
dorun.cljs$core$IFn$_invoke$arity$2 = dorun__2;
return dorun;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. doall can
* be used to force any effects. Walks through the successive nexts of
* the seq, retains the head and returns it, thus causing the entire
* seq to reside in memory at one time.
*/
cljs.core.doall = (function() {
var doall = null;
var doall__1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});
var doall__2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});
doall = function(n,coll){
switch(arguments.length){
case 1:
return doall__1.call(this,n);
case 2:
return doall__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
doall.cljs$core$IFn$_invoke$arity$1 = doall__1;
doall.cljs$core$IFn$_invoke$arity$2 = doall__2;
return doall;
})()
;
cljs.core.regexp_QMARK_ = (function regexp_QMARK_(o){
return (o instanceof RegExp);
});
/**
* Returns the result of (re-find re s) if re fully matches s.
*/
cljs.core.re_matches = (function re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
* Returns the first regex match, if any, of s to re, using
* re.exec(s). Returns a vector, containing first the matching
* substring, then any capturing groups if the regular expression contains
* capturing groups.
*/
cljs.core.re_find = (function re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
* Returns a lazy sequence of successive matches of re in s.
*/
cljs.core.re_seq = (function re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
* Returns an instance of RegExp which has compiled the provided string.
*/
cljs.core.re_pattern = (function re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__12197 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,s);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12197,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12197,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12197,(2),null);
return (new RegExp(pattern,flags));
}
});
cljs.core.pr_sequential_writer = (function pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_12205 = cljs.core._STAR_print_level_STAR_;
try{cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if(cljs.core.seq(coll)){
var G__12206_12212 = cljs.core.first(coll);
var G__12207_12213 = writer;
var G__12208_12214 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12206_12212,G__12207_12213,G__12208_12214) : print_one.call(null,G__12206_12212,G__12207_12213,G__12208_12214));
} else {
}

var coll_12215__$1 = cljs.core.next(coll);
var n_12216 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_12215__$1) && (((n_12216 == null)) || (!((n_12216 === (0)))))){
cljs.core._write(writer,sep);

var G__12209_12217 = cljs.core.first(coll_12215__$1);
var G__12210_12218 = writer;
var G__12211_12219 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12209_12217,G__12210_12218,G__12211_12219) : print_one.call(null,G__12209_12217,G__12210_12218,G__12211_12219));

var G__12220 = cljs.core.next(coll_12215__$1);
var G__12221 = (n_12216 - (1));
coll_12215__$1 = G__12220;
n_12216 = G__12221;
continue;
} else {
if((cljs.core.seq(coll_12215__$1)) && ((n_12216 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,"...");
} else {
}
}
break;
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_12205;
}});
/**
* @param {...*} var_args
*/
cljs.core.write_all = (function() { 
var write_all__delegate = function (writer,ss){
var seq__12226 = cljs.core.seq(ss);
var chunk__12227 = null;
var count__12228 = (0);
var i__12229 = (0);
while(true){
if((i__12229 < count__12228)){
var s = chunk__12227.cljs$core$IIndexed$_nth$arity$2(null,i__12229);
cljs.core._write(writer,s);

var G__12230 = seq__12226;
var G__12231 = chunk__12227;
var G__12232 = count__12228;
var G__12233 = (i__12229 + (1));
seq__12226 = G__12230;
chunk__12227 = G__12231;
count__12228 = G__12232;
i__12229 = G__12233;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__12226);
if(temp__4126__auto__){
var seq__12226__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12226__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__12226__$1);
var G__12234 = cljs.core.chunk_rest(seq__12226__$1);
var G__12235 = c__4545__auto__;
var G__12236 = cljs.core.count(c__4545__auto__);
var G__12237 = (0);
seq__12226 = G__12234;
chunk__12227 = G__12235;
count__12228 = G__12236;
i__12229 = G__12237;
continue;
} else {
var s = cljs.core.first(seq__12226__$1);
cljs.core._write(writer,s);

var G__12238 = cljs.core.next(seq__12226__$1);
var G__12239 = null;
var G__12240 = (0);
var G__12241 = (0);
seq__12226 = G__12238;
chunk__12227 = G__12239;
count__12228 = G__12240;
i__12229 = G__12241;
continue;
}
} else {
return null;
}
}
break;
}
};
var write_all = function (writer,var_args){
var ss = null;
if (arguments.length > 1) {
var G__12242__i = 0, G__12242__a = new Array(arguments.length -  1);
while (G__12242__i < G__12242__a.length) {G__12242__a[G__12242__i] = arguments[G__12242__i + 1]; ++G__12242__i;}
  ss = new cljs.core.IndexedSeq(G__12242__a,0);
} 
return write_all__delegate.call(this,writer,ss);};
write_all.cljs$lang$maxFixedArity = 1;
write_all.cljs$lang$applyTo = (function (arglist__12243){
var writer = cljs.core.first(arglist__12243);
var ss = cljs.core.rest(arglist__12243);
return write_all__delegate(writer,ss);
});
write_all.cljs$core$IFn$_invoke$arity$variadic = write_all__delegate;
return write_all;
})()
;
cljs.core.string_print = (function string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj12245 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj12245;
})();
cljs.core.quote_string = (function quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__12248 = "[\\\\\"\b\f\n\r\t]";
var G__12249 = "g";
return RegExp(G__12248,G__12249);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
/**
* Prefer this to pr-seq, because it makes the printing function
* configurable, allowing efficient implementations such as appending
* to a StringBuffer.
*/
cljs.core.pr_writer = (function pr_writer(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__3746__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__3746__auto__)){
var and__3746__auto____$1 = (function (){var G__12263 = obj;
if(G__12263){
var bit__4439__auto__ = (G__12263.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4439__auto__) || (G__12263.cljs$core$IMeta$)){
return true;
} else {
if((!G__12263.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__12263);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__12263);
}
})();
if(and__3746__auto____$1){
return cljs.core.meta(obj);
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
})())){
cljs.core._write(writer,"^");

pr_writer(cljs.core.meta(obj),writer,opts);

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__12264 = obj;
if(G__12264){
var bit__4432__auto__ = (G__12264.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4432__auto__) || (G__12264.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__12265 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__12266 = pr_writer;
var G__12267 = writer;
var G__12268 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__12265,G__12266,G__12267,G__12268) : cljs.core.print_map.call(null,G__12265,G__12266,G__12267,G__12268));
} else {
if(obj instanceof Array){
return cljs.core.pr_sequential_writer(writer,pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__12269 = obj;
return goog.isString(G__12269);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__12271 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__12271;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__12270 = obj;
if(G__12270){
var bit__4439__auto__ = (G__12270.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4439__auto__) || (G__12270.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__12270.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__12270);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__12270);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
cljs.core.pr_seq_writer = (function pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__12276 = cljs.core.seq(cljs.core.next(objs));
var chunk__12277 = null;
var count__12278 = (0);
var i__12279 = (0);
while(true){
if((i__12279 < count__12278)){
var obj = chunk__12277.cljs$core$IIndexed$_nth$arity$2(null,i__12279);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__12280 = seq__12276;
var G__12281 = chunk__12277;
var G__12282 = count__12278;
var G__12283 = (i__12279 + (1));
seq__12276 = G__12280;
chunk__12277 = G__12281;
count__12278 = G__12282;
i__12279 = G__12283;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__12276);
if(temp__4126__auto__){
var seq__12276__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12276__$1)){
var c__4545__auto__ = cljs.core.chunk_first(seq__12276__$1);
var G__12284 = cljs.core.chunk_rest(seq__12276__$1);
var G__12285 = c__4545__auto__;
var G__12286 = cljs.core.count(c__4545__auto__);
var G__12287 = (0);
seq__12276 = G__12284;
chunk__12277 = G__12285;
count__12278 = G__12286;
i__12279 = G__12287;
continue;
} else {
var obj = cljs.core.first(seq__12276__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__12288 = cljs.core.next(seq__12276__$1);
var G__12289 = null;
var G__12290 = (0);
var G__12291 = (0);
seq__12276 = G__12288;
chunk__12277 = G__12289;
count__12278 = G__12290;
i__12279 = G__12291;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
* Prints a sequence of objects to a string, observing all the
* options given in opts
*/
cljs.core.pr_str_with_opts = (function pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
* Same as pr-str-with-opts followed by (newline)
*/
cljs.core.prn_str_with_opts = (function prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
* Prints a sequence of objects using string-print, observing all
* the options given in opts
*/
cljs.core.pr_with_opts = (function pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
* pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
* @param {...*} var_args
*/
cljs.core.pr_str = (function() { 
var pr_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
};
var pr_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12292__i = 0, G__12292__a = new Array(arguments.length -  0);
while (G__12292__i < G__12292__a.length) {G__12292__a[G__12292__i] = arguments[G__12292__i + 0]; ++G__12292__i;}
  objs = new cljs.core.IndexedSeq(G__12292__a,0);
} 
return pr_str__delegate.call(this,objs);};
pr_str.cljs$lang$maxFixedArity = 0;
pr_str.cljs$lang$applyTo = (function (arglist__12293){
var objs = cljs.core.seq(arglist__12293);
return pr_str__delegate(objs);
});
pr_str.cljs$core$IFn$_invoke$arity$variadic = pr_str__delegate;
return pr_str;
})()
;
/**
* Same as pr-str followed by (newline)
* @param {...*} var_args
*/
cljs.core.prn_str = (function() { 
var prn_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
};
var prn_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12294__i = 0, G__12294__a = new Array(arguments.length -  0);
while (G__12294__i < G__12294__a.length) {G__12294__a[G__12294__i] = arguments[G__12294__i + 0]; ++G__12294__i;}
  objs = new cljs.core.IndexedSeq(G__12294__a,0);
} 
return prn_str__delegate.call(this,objs);};
prn_str.cljs$lang$maxFixedArity = 0;
prn_str.cljs$lang$applyTo = (function (arglist__12295){
var objs = cljs.core.seq(arglist__12295);
return prn_str__delegate(objs);
});
prn_str.cljs$core$IFn$_invoke$arity$variadic = prn_str__delegate;
return prn_str;
})()
;
/**
* Prints the object(s) using string-print.  Prints the
* object(s), separated by spaces if there is more than one.
* By default, pr and prn print in a way that objects can be
* read by the reader
* @param {...*} var_args
*/
cljs.core.pr = (function() { 
var pr__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
};
var pr = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12296__i = 0, G__12296__a = new Array(arguments.length -  0);
while (G__12296__i < G__12296__a.length) {G__12296__a[G__12296__i] = arguments[G__12296__i + 0]; ++G__12296__i;}
  objs = new cljs.core.IndexedSeq(G__12296__a,0);
} 
return pr__delegate.call(this,objs);};
pr.cljs$lang$maxFixedArity = 0;
pr.cljs$lang$applyTo = (function (arglist__12297){
var objs = cljs.core.seq(arglist__12297);
return pr__delegate(objs);
});
pr.cljs$core$IFn$_invoke$arity$variadic = pr__delegate;
return pr;
})()
;
/**
* Prints the object(s) using string-print.
* print and println produce output for human consumption.
* @param {...*} var_args
*/
cljs.core.print = (function() { 
var cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12298__i = 0, G__12298__a = new Array(arguments.length -  0);
while (G__12298__i < G__12298__a.length) {G__12298__a[G__12298__i] = arguments[G__12298__i + 0]; ++G__12298__i;}
  objs = new cljs.core.IndexedSeq(G__12298__a,0);
} 
return cljs_core_print__delegate.call(this,objs);};
cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs_core_print.cljs$lang$applyTo = (function (arglist__12299){
var objs = cljs.core.seq(arglist__12299);
return cljs_core_print__delegate(objs);
});
cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs_core_print__delegate;
return cljs_core_print;
})()
;
/**
* print to a string, returning it
* @param {...*} var_args
*/
cljs.core.print_str = (function() { 
var print_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var print_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12300__i = 0, G__12300__a = new Array(arguments.length -  0);
while (G__12300__i < G__12300__a.length) {G__12300__a[G__12300__i] = arguments[G__12300__i + 0]; ++G__12300__i;}
  objs = new cljs.core.IndexedSeq(G__12300__a,0);
} 
return print_str__delegate.call(this,objs);};
print_str.cljs$lang$maxFixedArity = 0;
print_str.cljs$lang$applyTo = (function (arglist__12301){
var objs = cljs.core.seq(arglist__12301);
return print_str__delegate(objs);
});
print_str.cljs$core$IFn$_invoke$arity$variadic = print_str__delegate;
return print_str;
})()
;
/**
* Same as print followed by (newline)
* @param {...*} var_args
*/
cljs.core.println = (function() { 
var println__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var println = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12302__i = 0, G__12302__a = new Array(arguments.length -  0);
while (G__12302__i < G__12302__a.length) {G__12302__a[G__12302__i] = arguments[G__12302__i + 0]; ++G__12302__i;}
  objs = new cljs.core.IndexedSeq(G__12302__a,0);
} 
return println__delegate.call(this,objs);};
println.cljs$lang$maxFixedArity = 0;
println.cljs$lang$applyTo = (function (arglist__12303){
var objs = cljs.core.seq(arglist__12303);
return println__delegate(objs);
});
println.cljs$core$IFn$_invoke$arity$variadic = println__delegate;
return println;
})()
;
/**
* println to a string, returning it
* @param {...*} var_args
*/
cljs.core.println_str = (function() { 
var println_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var println_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12304__i = 0, G__12304__a = new Array(arguments.length -  0);
while (G__12304__i < G__12304__a.length) {G__12304__a[G__12304__i] = arguments[G__12304__i + 0]; ++G__12304__i;}
  objs = new cljs.core.IndexedSeq(G__12304__a,0);
} 
return println_str__delegate.call(this,objs);};
println_str.cljs$lang$maxFixedArity = 0;
println_str.cljs$lang$applyTo = (function (arglist__12305){
var objs = cljs.core.seq(arglist__12305);
return println_str__delegate(objs);
});
println_str.cljs$core$IFn$_invoke$arity$variadic = println_str__delegate;
return println_str;
})()
;
/**
* Same as pr followed by (newline).
* @param {...*} var_args
*/
cljs.core.prn = (function() { 
var prn__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var prn = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__12306__i = 0, G__12306__a = new Array(arguments.length -  0);
while (G__12306__i < G__12306__a.length) {G__12306__a[G__12306__i] = arguments[G__12306__i + 0]; ++G__12306__i;}
  objs = new cljs.core.IndexedSeq(G__12306__a,0);
} 
return prn__delegate.call(this,objs);};
prn.cljs$lang$maxFixedArity = 0;
prn.cljs$lang$applyTo = (function (arglist__12307){
var objs = cljs.core.seq(arglist__12307);
return prn__delegate(objs);
});
prn.cljs$core$IFn$_invoke$arity$variadic = prn__delegate;
return prn;
})()
;
cljs.core.print_map = (function print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__12314_12320 = cljs.core.key(e);
var G__12315_12321 = w;
var G__12316_12322 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12314_12320,G__12315_12321,G__12316_12322) : print_one.call(null,G__12314_12320,G__12315_12321,G__12316_12322));

cljs.core._write(w," ");

var G__12317 = cljs.core.val(e);
var G__12318 = w;
var G__12319 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__12317,G__12318,G__12319) : print_one.call(null,G__12317,G__12318,G__12319));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});
/**
* Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
* 
* (apply f its-current-meta args)
* 
* f must be free of side-effects
* @param {...*} var_args
*/
cljs.core.alter_meta_BANG_ = (function() { 
var alter_meta_BANG___delegate = function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
};
var alter_meta_BANG_ = function (iref,f,var_args){
var args = null;
if (arguments.length > 2) {
var G__12323__i = 0, G__12323__a = new Array(arguments.length -  2);
while (G__12323__i < G__12323__a.length) {G__12323__a[G__12323__i] = arguments[G__12323__i + 2]; ++G__12323__i;}
  args = new cljs.core.IndexedSeq(G__12323__a,0);
} 
return alter_meta_BANG___delegate.call(this,iref,f,args);};
alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
alter_meta_BANG_.cljs$lang$applyTo = (function (arglist__12324){
var iref = cljs.core.first(arglist__12324);
arglist__12324 = cljs.core.next(arglist__12324);
var f = cljs.core.first(arglist__12324);
var args = cljs.core.rest(arglist__12324);
return alter_meta_BANG___delegate(iref,f,args);
});
alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = alter_meta_BANG___delegate;
return alter_meta_BANG_;
})()
;
/**
* Atomically resets the metadata for an atom
*/
cljs.core.reset_meta_BANG_ = (function reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
* Alpha - subject to change.
* 
* Adds a watch function to an atom reference. The watch fn must be a
* fn of 4 args: a key, the reference, its old-state, its
* new-state. Whenever the reference's state might have been changed,
* any registered watches will have their functions called. The watch
* fn will be called synchronously. Note that an atom's state
* may have changed again prior to the fn call, so use old/new-state
* rather than derefing the reference. Keys must be unique per
* reference, and can be used to remove the watch with remove-watch,
* but are otherwise considered opaque by the watch mechanism.  Bear in
* mind that regardless of the result or action of the watch fns the
* atom's value will change.  Example:
* 
* (def a (atom 0))
* (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
* (swap! a inc)
* ;; Assertion Error
* (deref a)
* ;=> 1
*/
cljs.core.add_watch = (function add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
* Alpha - subject to change.
* 
* Removes a watch (set by add-watch) from a reference
*/
cljs.core.remove_watch = (function remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
* Returns a new symbol with a unique name. If a prefix string is
* supplied, the name is prefix# where # is some unique number. If
* prefix is not supplied, the prefix is 'G__'.
*/
cljs.core.gensym = (function() {
var gensym = null;
var gensym__0 = (function (){
return gensym.cljs$core$IFn$_invoke$arity$1("G__");
});
var gensym__1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__12327 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__12327) : cljs.core.atom.call(null,G__12327));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});
gensym = function(prefix_string){
switch(arguments.length){
case 0:
return gensym__0.call(this);
case 1:
return gensym__1.call(this,prefix_string);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
gensym.cljs$core$IFn$_invoke$arity$0 = gensym__0;
gensym.cljs$core$IFn$_invoke$arity$1 = gensym__1;
return gensym;
})()
;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function __GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
* returns true if x is a Delay created with delay
*/
cljs.core.delay_QMARK_ = (function delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
* If x is a Delay, returns the (possibly cached) value of its expression, else returns x
*/
cljs.core.force = (function force(x){
if(cljs.core.delay_QMARK_(x)){
var G__12329 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12329) : cljs.core.deref.call(null,G__12329));
} else {
return x;
}
});
/**
* Returns true if a value has been produced for a promise, delay, future or lazy sequence.
*/
cljs.core.realized_QMARK_ = (function realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function preserving_reduced(rf){
return (function (p1__12330_SHARP_,p2__12331_SHARP_){
var ret = (function (){var G__12334 = p1__12330_SHARP_;
var G__12335 = p2__12331_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12334,G__12335) : rf.call(null,G__12334,G__12335));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
* A transducer which concatenates the contents of each input, which must be a
* collection, into the reduction.
*/
cljs.core.cat = (function cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__12338 = null;
var G__12338__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12338__1 = (function (result){
var G__12337 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12337) : rf.call(null,G__12337));
});
var G__12338__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__12338 = function(result,input){
switch(arguments.length){
case 0:
return G__12338__0.call(this);
case 1:
return G__12338__1.call(this,result);
case 2:
return G__12338__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12338.cljs$core$IFn$_invoke$arity$0 = G__12338__0;
G__12338.cljs$core$IFn$_invoke$arity$1 = G__12338__1;
G__12338.cljs$core$IFn$_invoke$arity$2 = G__12338__2;
return G__12338;
})()
;})(rf1))
});
/**
* Returns a lazy sequence removing consecutive duplicates in coll.
* Returns a transducer when no collection is provided.
*/
cljs.core.dedupe = (function() {
var dedupe = null;
var dedupe__0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__12347 = null;
var G__12347__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12347__1 = (function (result){
var G__12343 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__12343) : rf.call(null,G__12343));
});
var G__12347__2 = (function (result,input){
var prior = (function (){var G__12344 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12344) : cljs.core.deref.call(null,G__12344));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__12345 = result;
var G__12346 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__12345,G__12346) : rf.call(null,G__12345,G__12346));
}
});
G__12347 = function(result,input){
switch(arguments.length){
case 0:
return G__12347__0.call(this);
case 1:
return G__12347__1.call(this,result);
case 2:
return G__12347__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12347.cljs$core$IFn$_invoke$arity$0 = G__12347__0;
G__12347.cljs$core$IFn$_invoke$arity$1 = G__12347__1;
G__12347.cljs$core$IFn$_invoke$arity$2 = G__12347__2;
return G__12347;
})()
;})(pa))
});
});
var dedupe__1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});
dedupe = function(coll){
switch(arguments.length){
case 0:
return dedupe__0.call(this);
case 1:
return dedupe__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
dedupe.cljs$core$IFn$_invoke$arity$0 = dedupe__0;
dedupe.cljs$core$IFn$_invoke$arity$1 = dedupe__1;
return dedupe;
})()
;
/**
* Returns items from coll with random probability of prob (0.0 -
* 1.0).  Returns a transducer when no collection is provided.
*/
cljs.core.random_sample = (function() {
var random_sample = null;
var random_sample__1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});
var random_sample__2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});
random_sample = function(prob,coll){
switch(arguments.length){
case 1:
return random_sample__1.call(this,prob);
case 2:
return random_sample__2.call(this,prob,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
random_sample.cljs$core$IFn$_invoke$arity$1 = random_sample__1;
random_sample.cljs$core$IFn$_invoke$arity$2 = random_sample__2;
return random_sample;
})()
;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
})
cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write(writer__4346__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function __GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4736__auto__ = this;
return cljs.core.es6_iterator(this__4736__auto__);
}));
/**
* Returns a reducible/iterable/seqable application of
* the transducer to the items in coll. Note that these applications
* will be performed every time iterator/seq/reduce is called.
*/
cljs.core.eduction = (function eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
* Runs the supplied procedure (via reduce), for purposes of side
* effects, on successive items in the collection. Returns nil
*/
cljs.core.run_BANG_ = (function run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__12349_SHARP_,p2__12348_SHARP_){
var G__12351 = p2__12348_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__12351) : proc.call(null,G__12351));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj12353 = {};
return obj12353;
})();

cljs.core._clj__GT_js = (function _clj__GT_js(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._clj__GT_js[(function (){var G__12357 = x__4402__auto__;
return goog.typeOf(G__12357);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

cljs.core._key__GT_js = (function _key__GT_js(x){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._key__GT_js[(function (){var G__12361 = x__4402__auto__;
return goog.typeOf(G__12361);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function key__GT_js(k){
if((function (){var G__12364 = k;
if(G__12364){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__12364.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__12364.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12364);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12364);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__12365 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__12365) : cljs.core.clj__GT_js.call(null,G__12365));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
* Recursively transforms ClojureScript values to JavaScript.
* sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
* Maps become Objects. Arbitrary keys are encoded to by key->js.
*/
cljs.core.clj__GT_js = (function clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__12381 = x;
if(G__12381){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__12381.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__12381.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12381);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__12381);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj12383 = {};
return obj12383;
})();
var seq__12384_12394 = cljs.core.seq(x);
var chunk__12385_12395 = null;
var count__12386_12396 = (0);
var i__12387_12397 = (0);
while(true){
if((i__12387_12397 < count__12386_12396)){
var vec__12388_12398 = chunk__12385_12395.cljs$core$IIndexed$_nth$arity$2(null,i__12387_12397);
var k_12399 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12388_12398,(0),null);
var v_12400 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12388_12398,(1),null);
(m[cljs.core.key__GT_js(k_12399)] = clj__GT_js(v_12400));

var G__12401 = seq__12384_12394;
var G__12402 = chunk__12385_12395;
var G__12403 = count__12386_12396;
var G__12404 = (i__12387_12397 + (1));
seq__12384_12394 = G__12401;
chunk__12385_12395 = G__12402;
count__12386_12396 = G__12403;
i__12387_12397 = G__12404;
continue;
} else {
var temp__4126__auto___12405 = cljs.core.seq(seq__12384_12394);
if(temp__4126__auto___12405){
var seq__12384_12406__$1 = temp__4126__auto___12405;
if(cljs.core.chunked_seq_QMARK_(seq__12384_12406__$1)){
var c__4545__auto___12407 = cljs.core.chunk_first(seq__12384_12406__$1);
var G__12408 = cljs.core.chunk_rest(seq__12384_12406__$1);
var G__12409 = c__4545__auto___12407;
var G__12410 = cljs.core.count(c__4545__auto___12407);
var G__12411 = (0);
seq__12384_12394 = G__12408;
chunk__12385_12395 = G__12409;
count__12386_12396 = G__12410;
i__12387_12397 = G__12411;
continue;
} else {
var vec__12389_12412 = cljs.core.first(seq__12384_12406__$1);
var k_12413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12389_12412,(0),null);
var v_12414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12389_12412,(1),null);
(m[cljs.core.key__GT_js(k_12413)] = clj__GT_js(v_12414));

var G__12415 = cljs.core.next(seq__12384_12406__$1);
var G__12416 = null;
var G__12417 = (0);
var G__12418 = (0);
seq__12384_12394 = G__12415;
chunk__12385_12395 = G__12416;
count__12386_12396 = G__12417;
i__12387_12397 = G__12418;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__12390_12419 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clj__GT_js,x));
var chunk__12391_12420 = null;
var count__12392_12421 = (0);
var i__12393_12422 = (0);
while(true){
if((i__12393_12422 < count__12392_12421)){
var x_12423__$1 = chunk__12391_12420.cljs$core$IIndexed$_nth$arity$2(null,i__12393_12422);
arr.push(x_12423__$1);

var G__12424 = seq__12390_12419;
var G__12425 = chunk__12391_12420;
var G__12426 = count__12392_12421;
var G__12427 = (i__12393_12422 + (1));
seq__12390_12419 = G__12424;
chunk__12391_12420 = G__12425;
count__12392_12421 = G__12426;
i__12393_12422 = G__12427;
continue;
} else {
var temp__4126__auto___12428 = cljs.core.seq(seq__12390_12419);
if(temp__4126__auto___12428){
var seq__12390_12429__$1 = temp__4126__auto___12428;
if(cljs.core.chunked_seq_QMARK_(seq__12390_12429__$1)){
var c__4545__auto___12430 = cljs.core.chunk_first(seq__12390_12429__$1);
var G__12431 = cljs.core.chunk_rest(seq__12390_12429__$1);
var G__12432 = c__4545__auto___12430;
var G__12433 = cljs.core.count(c__4545__auto___12430);
var G__12434 = (0);
seq__12390_12419 = G__12431;
chunk__12391_12420 = G__12432;
count__12392_12421 = G__12433;
i__12393_12422 = G__12434;
continue;
} else {
var x_12435__$1 = cljs.core.first(seq__12390_12429__$1);
arr.push(x_12435__$1);

var G__12436 = cljs.core.next(seq__12390_12429__$1);
var G__12437 = null;
var G__12438 = (0);
var G__12439 = (0);
seq__12390_12419 = G__12436;
chunk__12391_12420 = G__12437;
count__12392_12421 = G__12438;
i__12393_12422 = G__12439;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj12441 = {};
return obj12441;
})();

cljs.core._js__GT_clj = (function _js__GT_clj(x,options){
if((function (){var and__3746__auto__ = x;
if(and__3746__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__3746__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4402__auto__ = (((x == null))?null:x);
return (function (){var or__3758__auto__ = (cljs.core._js__GT_clj[(function (){var G__12445 = x__4402__auto__;
return goog.typeOf(G__12445);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
* Recursively transforms JavaScript arrays into ClojureScript
* vectors, and JavaScript objects into ClojureScript maps.  With
* option ':keywordize-keys true' will convert object fields from
* strings to keywords.
* @param {...*} var_args
*/
cljs.core.js__GT_clj = (function() {
var js__GT_clj = null;
var js__GT_clj__1 = (function (x){
return js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});
var js__GT_clj__2 = (function() { 
var G__12502__delegate = function (x,opts){
var map__12475 = opts;
var map__12475__$1 = ((cljs.core.seq_QMARK_(map__12475))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12475):map__12475);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12475__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__12475,map__12475__$1,keywordize_keys,keyfn){
return (function thisfn(x__$1){
if((function (){var G__12491 = x__$1;
if(G__12491){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__12491.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__12491.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__12491);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__12491);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if(x__$1 instanceof Array){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4514__auto__ = ((function (map__12475,map__12475__$1,keywordize_keys,keyfn){
return (function iter__12492(s__12493){
return (new cljs.core.LazySeq(null,((function (map__12475,map__12475__$1,keywordize_keys,keyfn){
return (function (){
var s__12493__$1 = s__12493;
while(true){
var temp__4126__auto__ = cljs.core.seq(s__12493__$1);
if(temp__4126__auto__){
var s__12493__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12493__$2)){
var c__4512__auto__ = cljs.core.chunk_first(s__12493__$2);
var size__4513__auto__ = cljs.core.count(c__4512__auto__);
var b__12495 = cljs.core.chunk_buffer(size__4513__auto__);
if((function (){var i__12494 = (0);
while(true){
if((i__12494 < size__4513__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4512__auto__,i__12494);
cljs.core.chunk_append(b__12495,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__12500 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__12500) : keyfn.call(null,G__12500));
})(),thisfn((x__$1[k]))], null));

var G__12503 = (i__12494 + (1));
i__12494 = G__12503;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12495),iter__12492(cljs.core.chunk_rest(s__12493__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12495),null);
}
} else {
var k = cljs.core.first(s__12493__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__12501 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__12501) : keyfn.call(null,G__12501));
})(),thisfn((x__$1[k]))], null),iter__12492(cljs.core.rest(s__12493__$2)));
}
} else {
return null;
}
break;
}
});})(map__12475,map__12475__$1,keywordize_keys,keyfn))
,null,null));
});})(map__12475,map__12475__$1,keywordize_keys,keyfn))
;
return iter__4514__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__12475,map__12475__$1,keywordize_keys,keyfn))
;
return f(x);
};
var G__12502 = function (x,var_args){
var opts = null;
if (arguments.length > 1) {
var G__12504__i = 0, G__12504__a = new Array(arguments.length -  1);
while (G__12504__i < G__12504__a.length) {G__12504__a[G__12504__i] = arguments[G__12504__i + 1]; ++G__12504__i;}
  opts = new cljs.core.IndexedSeq(G__12504__a,0);
} 
return G__12502__delegate.call(this,x,opts);};
G__12502.cljs$lang$maxFixedArity = 1;
G__12502.cljs$lang$applyTo = (function (arglist__12505){
var x = cljs.core.first(arglist__12505);
var opts = cljs.core.rest(arglist__12505);
return G__12502__delegate(x,opts);
});
G__12502.cljs$core$IFn$_invoke$arity$variadic = G__12502__delegate;
return G__12502;
})()
;
js__GT_clj = function(x,var_args){
var opts = var_args;
switch(arguments.length){
case 1:
return js__GT_clj__1.call(this,x);
default:
var G__12506 = null;
if (arguments.length > 1) {
var G__12507__i = 0, G__12507__a = new Array(arguments.length -  1);
while (G__12507__i < G__12507__a.length) {G__12507__a[G__12507__i] = arguments[G__12507__i + 1]; ++G__12507__i;}
G__12506 = new cljs.core.IndexedSeq(G__12507__a,0);
}
return js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic(x, G__12506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
js__GT_clj.cljs$lang$maxFixedArity = 1;
js__GT_clj.cljs$lang$applyTo = js__GT_clj__2.cljs$lang$applyTo;
js__GT_clj.cljs$core$IFn$_invoke$arity$1 = js__GT_clj__1;
js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic;
return js__GT_clj;
})()
;
/**
* Returns a memoized version of a referentially transparent function. The
* memoized version of the function keeps a cache of the mapping from arguments
* to results and, when calls with the same arguments are repeated often, has
* higher performance at the expense of higher memory use.
*/
cljs.core.memoize = (function memoize(f){
var mem = (function (){var G__12510 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__12510) : cljs.core.atom.call(null,G__12510));
})();
return ((function (mem){
return (function() { 
var G__12512__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__12511 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12511) : cljs.core.deref.call(null,G__12511));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__12512 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__12513__i = 0, G__12513__a = new Array(arguments.length -  0);
while (G__12513__i < G__12513__a.length) {G__12513__a[G__12513__i] = arguments[G__12513__i + 0]; ++G__12513__i;}
  args = new cljs.core.IndexedSeq(G__12513__a,0);
} 
return G__12512__delegate.call(this,args);};
G__12512.cljs$lang$maxFixedArity = 0;
G__12512.cljs$lang$applyTo = (function (arglist__12514){
var args = cljs.core.seq(arglist__12514);
return G__12512__delegate(args);
});
G__12512.cljs$core$IFn$_invoke$arity$variadic = G__12512__delegate;
return G__12512;
})()
;
;})(mem))
});
/**
* trampoline can be used to convert algorithms requiring mutual
* recursion without stack consumption. Calls f with supplied args, if
* any. If f returns a fn, calls that fn with no arguments, and
* continues to repeat, until the return value is not a fn, then
* returns that non-fn value. Note that if you want to return a fn as a
* final value, you must wrap it in some data structure and unpack it
* after trampoline returns.
* @param {...*} var_args
*/
cljs.core.trampoline = (function() {
var trampoline = null;
var trampoline__1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__12516 = ret;
f = G__12516;
continue;
} else {
return ret;
}
break;
}
});
var trampoline__2 = (function() { 
var G__12517__delegate = function (f,args){
return trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
};
var G__12517 = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__12518__i = 0, G__12518__a = new Array(arguments.length -  1);
while (G__12518__i < G__12518__a.length) {G__12518__a[G__12518__i] = arguments[G__12518__i + 1]; ++G__12518__i;}
  args = new cljs.core.IndexedSeq(G__12518__a,0);
} 
return G__12517__delegate.call(this,f,args);};
G__12517.cljs$lang$maxFixedArity = 1;
G__12517.cljs$lang$applyTo = (function (arglist__12519){
var f = cljs.core.first(arglist__12519);
var args = cljs.core.rest(arglist__12519);
return G__12517__delegate(f,args);
});
G__12517.cljs$core$IFn$_invoke$arity$variadic = G__12517__delegate;
return G__12517;
})()
;
trampoline = function(f,var_args){
var args = var_args;
switch(arguments.length){
case 1:
return trampoline__1.call(this,f);
default:
var G__12520 = null;
if (arguments.length > 1) {
var G__12521__i = 0, G__12521__a = new Array(arguments.length -  1);
while (G__12521__i < G__12521__a.length) {G__12521__a[G__12521__i] = arguments[G__12521__i + 1]; ++G__12521__i;}
G__12520 = new cljs.core.IndexedSeq(G__12521__a,0);
}
return trampoline__2.cljs$core$IFn$_invoke$arity$variadic(f, G__12520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
trampoline.cljs$lang$maxFixedArity = 1;
trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
trampoline.cljs$core$IFn$_invoke$arity$1 = trampoline__1;
trampoline.cljs$core$IFn$_invoke$arity$variadic = trampoline__2.cljs$core$IFn$_invoke$arity$variadic;
return trampoline;
})()
;
/**
* Returns a random floating point number between 0 (inclusive) and
* n (default 1) (exclusive).
*/
cljs.core.rand = (function() {
var rand = null;
var rand__0 = (function (){
return rand.cljs$core$IFn$_invoke$arity$1((1));
});
var rand__1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});
rand = function(n){
switch(arguments.length){
case 0:
return rand__0.call(this);
case 1:
return rand__1.call(this,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
rand.cljs$core$IFn$_invoke$arity$0 = rand__0;
rand.cljs$core$IFn$_invoke$arity$1 = rand__1;
return rand;
})()
;
/**
* Returns a random integer between 0 (inclusive) and n (exclusive).
*/
cljs.core.rand_int = (function rand_int(n){
var G__12524 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__12524) : Math.floor.call(null,G__12524));
});
/**
* Return a random element of the (sequential) collection. Will have
* the same performance characteristics as nth for the given
* collection.
*/
cljs.core.rand_nth = (function rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
* Returns a map of the elements of coll keyed by the result of
* f on each element. The value at each key will be a vector of the
* corresponding elements, in the order they appeared in coll.
*/
cljs.core.group_by = (function group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__12526 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__12526) : f.call(null,G__12526));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
* Creates a hierarchy object for use with derive, isa? etc.
*/
cljs.core.make_hierarchy = (function make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__12528 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__12528) : cljs.core.atom.call(null,G__12528));
})();
} else {
}

return cljs.core._global_hierarchy;
});
/**
* @param {...*} var_args
*/
cljs.core.swap_global_hierarchy_BANG_ = (function() { 
var swap_global_hierarchy_BANG___delegate = function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
};
var swap_global_hierarchy_BANG_ = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__12529__i = 0, G__12529__a = new Array(arguments.length -  1);
while (G__12529__i < G__12529__a.length) {G__12529__a[G__12529__i] = arguments[G__12529__i + 1]; ++G__12529__i;}
  args = new cljs.core.IndexedSeq(G__12529__a,0);
} 
return swap_global_hierarchy_BANG___delegate.call(this,f,args);};
swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = 1;
swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (arglist__12530){
var f = cljs.core.first(arglist__12530);
var args = cljs.core.rest(arglist__12530);
return swap_global_hierarchy_BANG___delegate(f,args);
});
swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = swap_global_hierarchy_BANG___delegate;
return swap_global_hierarchy_BANG_;
})()
;
/**
* Returns true if (= child parent), or child is directly or indirectly derived from
* parent, either via a JavaScript type inheritance relationship or a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy
*/
cljs.core.isa_QMARK_ = (function() {
var isa_QMARK_ = null;
var isa_QMARK___2 = (function (child,parent){
return isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__12595 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12595) : cljs.core.deref.call(null,G__12595));
})(),child,parent);
});
var isa_QMARK___3 = (function (h,child,parent){
var or__3758__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
var and__3746__auto__ = cljs.core.vector_QMARK_(parent);
if(and__3746__auto__){
var and__3746__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__3746__auto____$1){
var and__3746__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__3746__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__12620 = isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__12618 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__12618) : child.call(null,G__12618));
})(),(function (){var G__12619 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__12619) : parent.call(null,G__12619));
})());
var G__12621 = (i + (1));
ret = G__12620;
i = G__12621;
continue;
}
break;
}
} else {
return and__3746__auto____$2;
}
} else {
return and__3746__auto____$1;
}
} else {
return and__3746__auto__;
}
}
}
});
isa_QMARK_ = function(h,child,parent){
switch(arguments.length){
case 2:
return isa_QMARK___2.call(this,h,child);
case 3:
return isa_QMARK___3.call(this,h,child,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = isa_QMARK___2;
isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = isa_QMARK___3;
return isa_QMARK_;
})()
;
/**
* Returns the immediate parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.parents = (function() {
var parents = null;
var parents__1 = (function (tag){
return parents.cljs$core$IFn$_invoke$arity$2((function (){var G__12625 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12625) : cljs.core.deref.call(null,G__12625));
})(),tag);
});
var parents__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});
parents = function(h,tag){
switch(arguments.length){
case 1:
return parents__1.call(this,h);
case 2:
return parents__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
parents.cljs$core$IFn$_invoke$arity$1 = parents__1;
parents.cljs$core$IFn$_invoke$arity$2 = parents__2;
return parents;
})()
;
/**
* Returns the immediate and indirect parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.ancestors = (function() {
var ancestors = null;
var ancestors__1 = (function (tag){
return ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__12629 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12629) : cljs.core.deref.call(null,G__12629));
})(),tag);
});
var ancestors__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});
ancestors = function(h,tag){
switch(arguments.length){
case 1:
return ancestors__1.call(this,h);
case 2:
return ancestors__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ancestors.cljs$core$IFn$_invoke$arity$1 = ancestors__1;
ancestors.cljs$core$IFn$_invoke$arity$2 = ancestors__2;
return ancestors;
})()
;
/**
* Returns the immediate and indirect children of tag, through a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy. Note: does not work on JavaScript type inheritance
* relationships.
*/
cljs.core.descendants = (function() {
var descendants = null;
var descendants__1 = (function (tag){
return descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__12633 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12633) : cljs.core.deref.call(null,G__12633));
})(),tag);
});
var descendants__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});
descendants = function(h,tag){
switch(arguments.length){
case 1:
return descendants__1.call(this,h);
case 2:
return descendants__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
descendants.cljs$core$IFn$_invoke$arity$1 = descendants__1;
descendants.cljs$core$IFn$_invoke$arity$2 = descendants__2;
return descendants;
})()
;
/**
* Establishes a parent/child relationship between parent and
* tag. Parent must be a namespace-qualified symbol or keyword and
* child can be either a namespace-qualified symbol or keyword or a
* class. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.derive = (function() {
var derive = null;
var derive__2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(derive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var derive__3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__12642 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__12642) : targets.call(null,G__12642));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__12643 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__12643) : sources.call(null,G__12643));
})()));
});})(tp,td,ta))
;
var or__3758__auto__ = ((cljs.core.contains_QMARK_((function (){var G__12647 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__12647) : tp.call(null,G__12647));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__12648 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__12648) : ta.call(null,G__12648));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__12649 = parent;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__12649) : ta.call(null,G__12649));
})(),tag)){
throw (new Error([cljs.core.str("Cyclic derivation:"),cljs.core.str(parent),cljs.core.str("has"),cljs.core.str(tag),cljs.core.str("as ancestor")].join('')));
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(tp,tag,cljs.core.PersistentHashSet.EMPTY),parent)),new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),tf(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag,td,parent,ta),new cljs.core.Keyword(null,"descendants","descendants",1824886031),tf(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),parent,ta,tag,td)], null);
})()
);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return h;
}
});
derive = function(h,tag,parent){
switch(arguments.length){
case 2:
return derive__2.call(this,h,tag);
case 3:
return derive__3.call(this,h,tag,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
derive.cljs$core$IFn$_invoke$arity$2 = derive__2;
derive.cljs$core$IFn$_invoke$arity$3 = derive__3;
return derive;
})()
;
/**
* Removes a parent/child relationship between parent and
* tag. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.underive = (function() {
var underive = null;
var underive__2 = (function (tag,parent){
cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(underive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var underive__3 = (function (h,tag,parent){
var parentMap = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var childsParents = (cljs.core.truth_((function (){var G__12656 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__12656) : parentMap.call(null,G__12656));
})())?cljs.core.disj.cljs$core$IFn$_invoke$arity$2((function (){var G__12657 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__12657) : parentMap.call(null,G__12657));
})(),parent):cljs.core.PersistentHashSet.EMPTY);
var newParents = (cljs.core.truth_(cljs.core.not_empty(childsParents))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parentMap,tag,childsParents):cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(parentMap,tag));
var deriv_seq = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (parentMap,childsParents,newParents){
return (function (p1__12650_SHARP_){
return cljs.core.cons(cljs.core.first(p1__12650_SHARP_),cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.first(p1__12650_SHARP_),cljs.core.second(p1__12650_SHARP_)));
});})(parentMap,childsParents,newParents))
,cljs.core.seq(newParents)));
if(cljs.core.contains_QMARK_((function (){var G__12658 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__12658) : parentMap.call(null,G__12658));
})(),parent)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (parentMap,childsParents,newParents,deriv_seq){
return (function (p1__12651_SHARP_,p2__12652_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.derive,p1__12651_SHARP_,p2__12652_SHARP_);
});})(parentMap,childsParents,newParents,deriv_seq))
,cljs.core.make_hierarchy(),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),deriv_seq));
} else {
return h;
}
});
underive = function(h,tag,parent){
switch(arguments.length){
case 2:
return underive__2.call(this,h,tag);
case 3:
return underive__3.call(this,h,tag,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
underive.cljs$core$IFn$_invoke$arity$2 = underive__2;
underive.cljs$core$IFn$_invoke$arity$3 = underive__3;
return underive;
})()
;
cljs.core.reset_cache = (function reset_cache(method_cache,method_table,cached_hierarchy,hierarchy){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(method_cache,(function (_){
var G__12661 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12661) : cljs.core.deref.call(null,G__12661));
}));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cached_hierarchy,(function (_){
var G__12662 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12662) : cljs.core.deref.call(null,G__12662));
}));
});
cljs.core.prefers_STAR_ = (function prefers_STAR_(x,y,prefer_table){
var xprefs = (function (){var G__12678 = prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12678) : cljs.core.deref.call(null,G__12678));
})().call(null,x);
var or__3758__auto__ = (cljs.core.truth_((function (){var and__3746__auto__ = xprefs;
if(cljs.core.truth_(and__3746__auto__)){
var G__12680 = y;
return (xprefs.cljs$core$IFn$_invoke$arity$1 ? xprefs.cljs$core$IFn$_invoke$arity$1(G__12680) : xprefs.call(null,G__12680));
} else {
return and__3746__auto__;
}
})())?true:null);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(y);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(prefers_STAR_(x,cljs.core.first(ps),prefer_table))){
} else {
}

var G__12681 = cljs.core.rest(ps);
ps = G__12681;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3758__auto____$1)){
return or__3758__auto____$1;
} else {
var or__3758__auto____$2 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(prefers_STAR_(cljs.core.first(ps),y,prefer_table))){
} else {
}

var G__12682 = cljs.core.rest(ps);
ps = G__12682;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3758__auto____$2)){
return or__3758__auto____$2;
} else {
return false;
}
}
}
});
cljs.core.dominates = (function dominates(x,y,prefer_table){
var or__3758__auto__ = cljs.core.prefers_STAR_(x,y,prefer_table);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2(x,y);
}
});
cljs.core.find_and_cache_best_method = (function find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
var best_entry = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (be,p__12696){
var vec__12697 = p__12696;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12697,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12697,(1),null);
var e = vec__12697;
if(cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__12698 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12698) : cljs.core.deref.call(null,G__12698));
})(),dispatch_val,k)){
var be2 = (cljs.core.truth_((function (){var or__3758__auto__ = (be == null);
if(or__3758__auto__){
return or__3758__auto__;
} else {
return cljs.core.dominates(k,cljs.core.first(be),prefer_table);
}
})())?e:be);
if(cljs.core.truth_(cljs.core.dominates(cljs.core.first(be2),k,prefer_table))){
} else {
throw (new Error([cljs.core.str("Multiple methods in multimethod '"),cljs.core.str(name),cljs.core.str("' match dispatch value: "),cljs.core.str(dispatch_val),cljs.core.str(" -> "),cljs.core.str(k),cljs.core.str(" and "),cljs.core.str(cljs.core.first(be2)),cljs.core.str(", and neither is preferred")].join('')));
}

return be2;
} else {
return be;
}
}),null,(function (){var G__12699 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12699) : cljs.core.deref.call(null,G__12699));
})());
if(cljs.core.truth_(best_entry)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__12700 = cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12700) : cljs.core.deref.call(null,G__12700));
})(),(function (){var G__12701 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12701) : cljs.core.deref.call(null,G__12701));
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(method_cache,cljs.core.assoc,dispatch_val,cljs.core.second(best_entry));

return cljs.core.second(best_entry);
} else {
cljs.core.reset_cache(method_cache,method_table,cached_hierarchy,hierarchy);

return find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy);
}
} else {
return null;
}
});

cljs.core.IMultiFn = (function (){var obj12703 = {};
return obj12703;
})();

cljs.core._reset = (function _reset(mf){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_reset$arity$1;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_reset$arity$1(mf);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._reset[(function (){var G__12707 = x__4402__auto__;
return goog.typeOf(G__12707);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._reset["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-reset",mf);
}
}
})().call(null,mf);
}
});

cljs.core._add_method = (function _add_method(mf,dispatch_val,method){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_add_method$arity$3;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_add_method$arity$3(mf,dispatch_val,method);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._add_method[(function (){var G__12711 = x__4402__auto__;
return goog.typeOf(G__12711);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._add_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-add-method",mf);
}
}
})().call(null,mf,dispatch_val,method);
}
});

cljs.core._remove_method = (function _remove_method(mf,dispatch_val){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_remove_method$arity$2;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf,dispatch_val);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._remove_method[(function (){var G__12715 = x__4402__auto__;
return goog.typeOf(G__12715);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._remove_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-remove-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._prefer_method = (function _prefer_method(mf,dispatch_val,dispatch_val_y){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf,dispatch_val,dispatch_val_y);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._prefer_method[(function (){var G__12719 = x__4402__auto__;
return goog.typeOf(G__12719);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._prefer_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefer-method",mf);
}
}
})().call(null,mf,dispatch_val,dispatch_val_y);
}
});

cljs.core._get_method = (function _get_method(mf,dispatch_val){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_get_method$arity$2;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_get_method$arity$2(mf,dispatch_val);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._get_method[(function (){var G__12723 = x__4402__auto__;
return goog.typeOf(G__12723);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._get_method["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-get-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._methods = (function _methods(mf){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_methods$arity$1;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_methods$arity$1(mf);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._methods[(function (){var G__12727 = x__4402__auto__;
return goog.typeOf(G__12727);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._methods["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-methods",mf);
}
}
})().call(null,mf);
}
});

cljs.core._prefers = (function _prefers(mf){
if((function (){var and__3746__auto__ = mf;
if(and__3746__auto__){
return mf.cljs$core$IMultiFn$_prefers$arity$1;
} else {
return and__3746__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefers$arity$1(mf);
} else {
var x__4402__auto__ = (((mf == null))?null:mf);
return (function (){var or__3758__auto__ = (cljs.core._prefers[(function (){var G__12731 = x__4402__auto__;
return goog.typeOf(G__12731);
})()]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core._prefers["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefers",mf);
}
}
})().call(null,mf);
}
});

cljs.core.throw_no_method_error = (function throw_no_method_error(name,dispatch_val){
throw (new Error([cljs.core.str("No method in multimethod '"),cljs.core.str(name),cljs.core.str("' for dispatch value: "),cljs.core.str(dispatch_val)].join('')));
});

/**
* @constructor
*/
cljs.core.MultiFn = (function (name,dispatch_fn,default_dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
this.name = name;
this.dispatch_fn = dispatch_fn;
this.default_dispatch_val = default_dispatch_val;
this.hierarchy = hierarchy;
this.method_table = method_table;
this.prefer_table = prefer_table;
this.method_cache = method_cache;
this.cached_hierarchy = cached_hierarchy;
this.cljs$lang$protocol_mask$partition0$ = 4194305;
this.cljs$lang$protocol_mask$partition1$ = 4352;
})
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__12733 = this$__$1;
return goog.getUid(G__12733);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_name$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._name(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_namespace$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._namespace(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_cache,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.cached_hierarchy,((function (mf__$1){
return (function (mf__$2){
return null;
});})(mf__$1))
);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = (function (mf,dispatch_val,method){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.method_table,cljs.core.assoc,dispatch_val,method);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.method_table,cljs.core.dissoc,dispatch_val);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__12734 = self__.cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12734) : cljs.core.deref.call(null,G__12734));
})(),(function (){var G__12735 = self__.hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12735) : cljs.core.deref.call(null,G__12735));
})())){
} else {
cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
}

var temp__4124__auto__ = (function (){var G__12736 = self__.method_cache;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12736) : cljs.core.deref.call(null,G__12736));
})().call(null,dispatch_val);
if(cljs.core.truth_(temp__4124__auto__)){
var target_fn = temp__4124__auto__;
return target_fn;
} else {
var temp__4124__auto____$1 = cljs.core.find_and_cache_best_method(self__.name,dispatch_val,self__.hierarchy,self__.method_table,self__.prefer_table,self__.method_cache,self__.cached_hierarchy);
if(cljs.core.truth_(temp__4124__auto____$1)){
var target_fn = temp__4124__auto____$1;
return target_fn;
} else {
return (function (){var G__12737 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12737) : cljs.core.deref.call(null,G__12737));
})().call(null,self__.default_dispatch_val);
}
}
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = (function (mf,dispatch_val_x,dispatch_val_y){
var self__ = this;
var mf__$1 = this;
if(cljs.core.truth_(cljs.core.prefers_STAR_(dispatch_val_x,dispatch_val_y,self__.prefer_table))){
throw (new Error([cljs.core.str("Preference conflict in multimethod '"),cljs.core.str(self__.name),cljs.core.str("': "),cljs.core.str(dispatch_val_y),cljs.core.str(" is already preferred to "),cljs.core.str(dispatch_val_x)].join('')));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (old){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.PersistentHashSet.EMPTY),dispatch_val_y));
});})(mf__$1))
);

return cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__12738 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12738) : cljs.core.deref.call(null,G__12738));
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__12739 = self__.prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__12739) : cljs.core.deref.call(null,G__12739));
});

cljs.core.MultiFn.prototype.call = (function() {
var G__13580 = null;
var G__13580__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0() : self__.dispatch_fn.call(null));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return (target_fn.cljs$core$IFn$_invoke$arity$0 ? target_fn.cljs$core$IFn$_invoke$arity$0() : target_fn.call(null));
});
var G__13580__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12740 = a;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__12740) : self__.dispatch_fn.call(null,G__12740));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12741 = a;
return (target_fn.cljs$core$IFn$_invoke$arity$1 ? target_fn.cljs$core$IFn$_invoke$arity$1(G__12741) : target_fn.call(null,G__12741));
});
var G__13580__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12742 = a;
var G__12743 = b;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2(G__12742,G__12743) : self__.dispatch_fn.call(null,G__12742,G__12743));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12744 = a;
var G__12745 = b;
return (target_fn.cljs$core$IFn$_invoke$arity$2 ? target_fn.cljs$core$IFn$_invoke$arity$2(G__12744,G__12745) : target_fn.call(null,G__12744,G__12745));
});
var G__13580__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12746 = a;
var G__12747 = b;
var G__12748 = c;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3(G__12746,G__12747,G__12748) : self__.dispatch_fn.call(null,G__12746,G__12747,G__12748));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12749 = a;
var G__12750 = b;
var G__12751 = c;
return (target_fn.cljs$core$IFn$_invoke$arity$3 ? target_fn.cljs$core$IFn$_invoke$arity$3(G__12749,G__12750,G__12751) : target_fn.call(null,G__12749,G__12750,G__12751));
});
var G__13580__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12752 = a;
var G__12753 = b;
var G__12754 = c;
var G__12755 = d;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4(G__12752,G__12753,G__12754,G__12755) : self__.dispatch_fn.call(null,G__12752,G__12753,G__12754,G__12755));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12756 = a;
var G__12757 = b;
var G__12758 = c;
var G__12759 = d;
return (target_fn.cljs$core$IFn$_invoke$arity$4 ? target_fn.cljs$core$IFn$_invoke$arity$4(G__12756,G__12757,G__12758,G__12759) : target_fn.call(null,G__12756,G__12757,G__12758,G__12759));
});
var G__13580__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12760 = a;
var G__12761 = b;
var G__12762 = c;
var G__12763 = d;
var G__12764 = e;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5(G__12760,G__12761,G__12762,G__12763,G__12764) : self__.dispatch_fn.call(null,G__12760,G__12761,G__12762,G__12763,G__12764));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12765 = a;
var G__12766 = b;
var G__12767 = c;
var G__12768 = d;
var G__12769 = e;
return (target_fn.cljs$core$IFn$_invoke$arity$5 ? target_fn.cljs$core$IFn$_invoke$arity$5(G__12765,G__12766,G__12767,G__12768,G__12769) : target_fn.call(null,G__12765,G__12766,G__12767,G__12768,G__12769));
});
var G__13580__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12770 = a;
var G__12771 = b;
var G__12772 = c;
var G__12773 = d;
var G__12774 = e;
var G__12775 = f;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6(G__12770,G__12771,G__12772,G__12773,G__12774,G__12775) : self__.dispatch_fn.call(null,G__12770,G__12771,G__12772,G__12773,G__12774,G__12775));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12776 = a;
var G__12777 = b;
var G__12778 = c;
var G__12779 = d;
var G__12780 = e;
var G__12781 = f;
return (target_fn.cljs$core$IFn$_invoke$arity$6 ? target_fn.cljs$core$IFn$_invoke$arity$6(G__12776,G__12777,G__12778,G__12779,G__12780,G__12781) : target_fn.call(null,G__12776,G__12777,G__12778,G__12779,G__12780,G__12781));
});
var G__13580__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12782 = a;
var G__12783 = b;
var G__12784 = c;
var G__12785 = d;
var G__12786 = e;
var G__12787 = f;
var G__12788 = g;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7(G__12782,G__12783,G__12784,G__12785,G__12786,G__12787,G__12788) : self__.dispatch_fn.call(null,G__12782,G__12783,G__12784,G__12785,G__12786,G__12787,G__12788));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12789 = a;
var G__12790 = b;
var G__12791 = c;
var G__12792 = d;
var G__12793 = e;
var G__12794 = f;
var G__12795 = g;
return (target_fn.cljs$core$IFn$_invoke$arity$7 ? target_fn.cljs$core$IFn$_invoke$arity$7(G__12789,G__12790,G__12791,G__12792,G__12793,G__12794,G__12795) : target_fn.call(null,G__12789,G__12790,G__12791,G__12792,G__12793,G__12794,G__12795));
});
var G__13580__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12796 = a;
var G__12797 = b;
var G__12798 = c;
var G__12799 = d;
var G__12800 = e;
var G__12801 = f;
var G__12802 = g;
var G__12803 = h;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8(G__12796,G__12797,G__12798,G__12799,G__12800,G__12801,G__12802,G__12803) : self__.dispatch_fn.call(null,G__12796,G__12797,G__12798,G__12799,G__12800,G__12801,G__12802,G__12803));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12804 = a;
var G__12805 = b;
var G__12806 = c;
var G__12807 = d;
var G__12808 = e;
var G__12809 = f;
var G__12810 = g;
var G__12811 = h;
return (target_fn.cljs$core$IFn$_invoke$arity$8 ? target_fn.cljs$core$IFn$_invoke$arity$8(G__12804,G__12805,G__12806,G__12807,G__12808,G__12809,G__12810,G__12811) : target_fn.call(null,G__12804,G__12805,G__12806,G__12807,G__12808,G__12809,G__12810,G__12811));
});
var G__13580__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12812 = a;
var G__12813 = b;
var G__12814 = c;
var G__12815 = d;
var G__12816 = e;
var G__12817 = f;
var G__12818 = g;
var G__12819 = h;
var G__12820 = i;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9(G__12812,G__12813,G__12814,G__12815,G__12816,G__12817,G__12818,G__12819,G__12820) : self__.dispatch_fn.call(null,G__12812,G__12813,G__12814,G__12815,G__12816,G__12817,G__12818,G__12819,G__12820));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12821 = a;
var G__12822 = b;
var G__12823 = c;
var G__12824 = d;
var G__12825 = e;
var G__12826 = f;
var G__12827 = g;
var G__12828 = h;
var G__12829 = i;
return (target_fn.cljs$core$IFn$_invoke$arity$9 ? target_fn.cljs$core$IFn$_invoke$arity$9(G__12821,G__12822,G__12823,G__12824,G__12825,G__12826,G__12827,G__12828,G__12829) : target_fn.call(null,G__12821,G__12822,G__12823,G__12824,G__12825,G__12826,G__12827,G__12828,G__12829));
});
var G__13580__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12830 = a;
var G__12831 = b;
var G__12832 = c;
var G__12833 = d;
var G__12834 = e;
var G__12835 = f;
var G__12836 = g;
var G__12837 = h;
var G__12838 = i;
var G__12839 = j;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10(G__12830,G__12831,G__12832,G__12833,G__12834,G__12835,G__12836,G__12837,G__12838,G__12839) : self__.dispatch_fn.call(null,G__12830,G__12831,G__12832,G__12833,G__12834,G__12835,G__12836,G__12837,G__12838,G__12839));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12840 = a;
var G__12841 = b;
var G__12842 = c;
var G__12843 = d;
var G__12844 = e;
var G__12845 = f;
var G__12846 = g;
var G__12847 = h;
var G__12848 = i;
var G__12849 = j;
return (target_fn.cljs$core$IFn$_invoke$arity$10 ? target_fn.cljs$core$IFn$_invoke$arity$10(G__12840,G__12841,G__12842,G__12843,G__12844,G__12845,G__12846,G__12847,G__12848,G__12849) : target_fn.call(null,G__12840,G__12841,G__12842,G__12843,G__12844,G__12845,G__12846,G__12847,G__12848,G__12849));
});
var G__13580__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12850 = a;
var G__12851 = b;
var G__12852 = c;
var G__12853 = d;
var G__12854 = e;
var G__12855 = f;
var G__12856 = g;
var G__12857 = h;
var G__12858 = i;
var G__12859 = j;
var G__12860 = k;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11(G__12850,G__12851,G__12852,G__12853,G__12854,G__12855,G__12856,G__12857,G__12858,G__12859,G__12860) : self__.dispatch_fn.call(null,G__12850,G__12851,G__12852,G__12853,G__12854,G__12855,G__12856,G__12857,G__12858,G__12859,G__12860));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12861 = a;
var G__12862 = b;
var G__12863 = c;
var G__12864 = d;
var G__12865 = e;
var G__12866 = f;
var G__12867 = g;
var G__12868 = h;
var G__12869 = i;
var G__12870 = j;
var G__12871 = k;
return (target_fn.cljs$core$IFn$_invoke$arity$11 ? target_fn.cljs$core$IFn$_invoke$arity$11(G__12861,G__12862,G__12863,G__12864,G__12865,G__12866,G__12867,G__12868,G__12869,G__12870,G__12871) : target_fn.call(null,G__12861,G__12862,G__12863,G__12864,G__12865,G__12866,G__12867,G__12868,G__12869,G__12870,G__12871));
});
var G__13580__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12872 = a;
var G__12873 = b;
var G__12874 = c;
var G__12875 = d;
var G__12876 = e;
var G__12877 = f;
var G__12878 = g;
var G__12879 = h;
var G__12880 = i;
var G__12881 = j;
var G__12882 = k;
var G__12883 = l;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12(G__12872,G__12873,G__12874,G__12875,G__12876,G__12877,G__12878,G__12879,G__12880,G__12881,G__12882,G__12883) : self__.dispatch_fn.call(null,G__12872,G__12873,G__12874,G__12875,G__12876,G__12877,G__12878,G__12879,G__12880,G__12881,G__12882,G__12883));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12884 = a;
var G__12885 = b;
var G__12886 = c;
var G__12887 = d;
var G__12888 = e;
var G__12889 = f;
var G__12890 = g;
var G__12891 = h;
var G__12892 = i;
var G__12893 = j;
var G__12894 = k;
var G__12895 = l;
return (target_fn.cljs$core$IFn$_invoke$arity$12 ? target_fn.cljs$core$IFn$_invoke$arity$12(G__12884,G__12885,G__12886,G__12887,G__12888,G__12889,G__12890,G__12891,G__12892,G__12893,G__12894,G__12895) : target_fn.call(null,G__12884,G__12885,G__12886,G__12887,G__12888,G__12889,G__12890,G__12891,G__12892,G__12893,G__12894,G__12895));
});
var G__13580__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12896 = a;
var G__12897 = b;
var G__12898 = c;
var G__12899 = d;
var G__12900 = e;
var G__12901 = f;
var G__12902 = g;
var G__12903 = h;
var G__12904 = i;
var G__12905 = j;
var G__12906 = k;
var G__12907 = l;
var G__12908 = m;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13(G__12896,G__12897,G__12898,G__12899,G__12900,G__12901,G__12902,G__12903,G__12904,G__12905,G__12906,G__12907,G__12908) : self__.dispatch_fn.call(null,G__12896,G__12897,G__12898,G__12899,G__12900,G__12901,G__12902,G__12903,G__12904,G__12905,G__12906,G__12907,G__12908));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12909 = a;
var G__12910 = b;
var G__12911 = c;
var G__12912 = d;
var G__12913 = e;
var G__12914 = f;
var G__12915 = g;
var G__12916 = h;
var G__12917 = i;
var G__12918 = j;
var G__12919 = k;
var G__12920 = l;
var G__12921 = m;
return (target_fn.cljs$core$IFn$_invoke$arity$13 ? target_fn.cljs$core$IFn$_invoke$arity$13(G__12909,G__12910,G__12911,G__12912,G__12913,G__12914,G__12915,G__12916,G__12917,G__12918,G__12919,G__12920,G__12921) : target_fn.call(null,G__12909,G__12910,G__12911,G__12912,G__12913,G__12914,G__12915,G__12916,G__12917,G__12918,G__12919,G__12920,G__12921));
});
var G__13580__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12922 = a;
var G__12923 = b;
var G__12924 = c;
var G__12925 = d;
var G__12926 = e;
var G__12927 = f;
var G__12928 = g;
var G__12929 = h;
var G__12930 = i;
var G__12931 = j;
var G__12932 = k;
var G__12933 = l;
var G__12934 = m;
var G__12935 = n;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14(G__12922,G__12923,G__12924,G__12925,G__12926,G__12927,G__12928,G__12929,G__12930,G__12931,G__12932,G__12933,G__12934,G__12935) : self__.dispatch_fn.call(null,G__12922,G__12923,G__12924,G__12925,G__12926,G__12927,G__12928,G__12929,G__12930,G__12931,G__12932,G__12933,G__12934,G__12935));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12936 = a;
var G__12937 = b;
var G__12938 = c;
var G__12939 = d;
var G__12940 = e;
var G__12941 = f;
var G__12942 = g;
var G__12943 = h;
var G__12944 = i;
var G__12945 = j;
var G__12946 = k;
var G__12947 = l;
var G__12948 = m;
var G__12949 = n;
return (target_fn.cljs$core$IFn$_invoke$arity$14 ? target_fn.cljs$core$IFn$_invoke$arity$14(G__12936,G__12937,G__12938,G__12939,G__12940,G__12941,G__12942,G__12943,G__12944,G__12945,G__12946,G__12947,G__12948,G__12949) : target_fn.call(null,G__12936,G__12937,G__12938,G__12939,G__12940,G__12941,G__12942,G__12943,G__12944,G__12945,G__12946,G__12947,G__12948,G__12949));
});
var G__13580__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12950 = a;
var G__12951 = b;
var G__12952 = c;
var G__12953 = d;
var G__12954 = e;
var G__12955 = f;
var G__12956 = g;
var G__12957 = h;
var G__12958 = i;
var G__12959 = j;
var G__12960 = k;
var G__12961 = l;
var G__12962 = m;
var G__12963 = n;
var G__12964 = o;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15(G__12950,G__12951,G__12952,G__12953,G__12954,G__12955,G__12956,G__12957,G__12958,G__12959,G__12960,G__12961,G__12962,G__12963,G__12964) : self__.dispatch_fn.call(null,G__12950,G__12951,G__12952,G__12953,G__12954,G__12955,G__12956,G__12957,G__12958,G__12959,G__12960,G__12961,G__12962,G__12963,G__12964));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12965 = a;
var G__12966 = b;
var G__12967 = c;
var G__12968 = d;
var G__12969 = e;
var G__12970 = f;
var G__12971 = g;
var G__12972 = h;
var G__12973 = i;
var G__12974 = j;
var G__12975 = k;
var G__12976 = l;
var G__12977 = m;
var G__12978 = n;
var G__12979 = o;
return (target_fn.cljs$core$IFn$_invoke$arity$15 ? target_fn.cljs$core$IFn$_invoke$arity$15(G__12965,G__12966,G__12967,G__12968,G__12969,G__12970,G__12971,G__12972,G__12973,G__12974,G__12975,G__12976,G__12977,G__12978,G__12979) : target_fn.call(null,G__12965,G__12966,G__12967,G__12968,G__12969,G__12970,G__12971,G__12972,G__12973,G__12974,G__12975,G__12976,G__12977,G__12978,G__12979));
});
var G__13580__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__12980 = a;
var G__12981 = b;
var G__12982 = c;
var G__12983 = d;
var G__12984 = e;
var G__12985 = f;
var G__12986 = g;
var G__12987 = h;
var G__12988 = i;
var G__12989 = j;
var G__12990 = k;
var G__12991 = l;
var G__12992 = m;
var G__12993 = n;
var G__12994 = o;
var G__12995 = p;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16(G__12980,G__12981,G__12982,G__12983,G__12984,G__12985,G__12986,G__12987,G__12988,G__12989,G__12990,G__12991,G__12992,G__12993,G__12994,G__12995) : self__.dispatch_fn.call(null,G__12980,G__12981,G__12982,G__12983,G__12984,G__12985,G__12986,G__12987,G__12988,G__12989,G__12990,G__12991,G__12992,G__12993,G__12994,G__12995));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__12996 = a;
var G__12997 = b;
var G__12998 = c;
var G__12999 = d;
var G__13000 = e;
var G__13001 = f;
var G__13002 = g;
var G__13003 = h;
var G__13004 = i;
var G__13005 = j;
var G__13006 = k;
var G__13007 = l;
var G__13008 = m;
var G__13009 = n;
var G__13010 = o;
var G__13011 = p;
return (target_fn.cljs$core$IFn$_invoke$arity$16 ? target_fn.cljs$core$IFn$_invoke$arity$16(G__12996,G__12997,G__12998,G__12999,G__13000,G__13001,G__13002,G__13003,G__13004,G__13005,G__13006,G__13007,G__13008,G__13009,G__13010,G__13011) : target_fn.call(null,G__12996,G__12997,G__12998,G__12999,G__13000,G__13001,G__13002,G__13003,G__13004,G__13005,G__13006,G__13007,G__13008,G__13009,G__13010,G__13011));
});
var G__13580__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13012 = a;
var G__13013 = b;
var G__13014 = c;
var G__13015 = d;
var G__13016 = e;
var G__13017 = f;
var G__13018 = g;
var G__13019 = h;
var G__13020 = i;
var G__13021 = j;
var G__13022 = k;
var G__13023 = l;
var G__13024 = m;
var G__13025 = n;
var G__13026 = o;
var G__13027 = p;
var G__13028 = q;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17(G__13012,G__13013,G__13014,G__13015,G__13016,G__13017,G__13018,G__13019,G__13020,G__13021,G__13022,G__13023,G__13024,G__13025,G__13026,G__13027,G__13028) : self__.dispatch_fn.call(null,G__13012,G__13013,G__13014,G__13015,G__13016,G__13017,G__13018,G__13019,G__13020,G__13021,G__13022,G__13023,G__13024,G__13025,G__13026,G__13027,G__13028));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13029 = a;
var G__13030 = b;
var G__13031 = c;
var G__13032 = d;
var G__13033 = e;
var G__13034 = f;
var G__13035 = g;
var G__13036 = h;
var G__13037 = i;
var G__13038 = j;
var G__13039 = k;
var G__13040 = l;
var G__13041 = m;
var G__13042 = n;
var G__13043 = o;
var G__13044 = p;
var G__13045 = q;
return (target_fn.cljs$core$IFn$_invoke$arity$17 ? target_fn.cljs$core$IFn$_invoke$arity$17(G__13029,G__13030,G__13031,G__13032,G__13033,G__13034,G__13035,G__13036,G__13037,G__13038,G__13039,G__13040,G__13041,G__13042,G__13043,G__13044,G__13045) : target_fn.call(null,G__13029,G__13030,G__13031,G__13032,G__13033,G__13034,G__13035,G__13036,G__13037,G__13038,G__13039,G__13040,G__13041,G__13042,G__13043,G__13044,G__13045));
});
var G__13580__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13046 = a;
var G__13047 = b;
var G__13048 = c;
var G__13049 = d;
var G__13050 = e;
var G__13051 = f;
var G__13052 = g;
var G__13053 = h;
var G__13054 = i;
var G__13055 = j;
var G__13056 = k;
var G__13057 = l;
var G__13058 = m;
var G__13059 = n;
var G__13060 = o;
var G__13061 = p;
var G__13062 = q;
var G__13063 = r;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18(G__13046,G__13047,G__13048,G__13049,G__13050,G__13051,G__13052,G__13053,G__13054,G__13055,G__13056,G__13057,G__13058,G__13059,G__13060,G__13061,G__13062,G__13063) : self__.dispatch_fn.call(null,G__13046,G__13047,G__13048,G__13049,G__13050,G__13051,G__13052,G__13053,G__13054,G__13055,G__13056,G__13057,G__13058,G__13059,G__13060,G__13061,G__13062,G__13063));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13064 = a;
var G__13065 = b;
var G__13066 = c;
var G__13067 = d;
var G__13068 = e;
var G__13069 = f;
var G__13070 = g;
var G__13071 = h;
var G__13072 = i;
var G__13073 = j;
var G__13074 = k;
var G__13075 = l;
var G__13076 = m;
var G__13077 = n;
var G__13078 = o;
var G__13079 = p;
var G__13080 = q;
var G__13081 = r;
return (target_fn.cljs$core$IFn$_invoke$arity$18 ? target_fn.cljs$core$IFn$_invoke$arity$18(G__13064,G__13065,G__13066,G__13067,G__13068,G__13069,G__13070,G__13071,G__13072,G__13073,G__13074,G__13075,G__13076,G__13077,G__13078,G__13079,G__13080,G__13081) : target_fn.call(null,G__13064,G__13065,G__13066,G__13067,G__13068,G__13069,G__13070,G__13071,G__13072,G__13073,G__13074,G__13075,G__13076,G__13077,G__13078,G__13079,G__13080,G__13081));
});
var G__13580__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13082 = a;
var G__13083 = b;
var G__13084 = c;
var G__13085 = d;
var G__13086 = e;
var G__13087 = f;
var G__13088 = g;
var G__13089 = h;
var G__13090 = i;
var G__13091 = j;
var G__13092 = k;
var G__13093 = l;
var G__13094 = m;
var G__13095 = n;
var G__13096 = o;
var G__13097 = p;
var G__13098 = q;
var G__13099 = r;
var G__13100 = s;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19(G__13082,G__13083,G__13084,G__13085,G__13086,G__13087,G__13088,G__13089,G__13090,G__13091,G__13092,G__13093,G__13094,G__13095,G__13096,G__13097,G__13098,G__13099,G__13100) : self__.dispatch_fn.call(null,G__13082,G__13083,G__13084,G__13085,G__13086,G__13087,G__13088,G__13089,G__13090,G__13091,G__13092,G__13093,G__13094,G__13095,G__13096,G__13097,G__13098,G__13099,G__13100));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13101 = a;
var G__13102 = b;
var G__13103 = c;
var G__13104 = d;
var G__13105 = e;
var G__13106 = f;
var G__13107 = g;
var G__13108 = h;
var G__13109 = i;
var G__13110 = j;
var G__13111 = k;
var G__13112 = l;
var G__13113 = m;
var G__13114 = n;
var G__13115 = o;
var G__13116 = p;
var G__13117 = q;
var G__13118 = r;
var G__13119 = s;
return (target_fn.cljs$core$IFn$_invoke$arity$19 ? target_fn.cljs$core$IFn$_invoke$arity$19(G__13101,G__13102,G__13103,G__13104,G__13105,G__13106,G__13107,G__13108,G__13109,G__13110,G__13111,G__13112,G__13113,G__13114,G__13115,G__13116,G__13117,G__13118,G__13119) : target_fn.call(null,G__13101,G__13102,G__13103,G__13104,G__13105,G__13106,G__13107,G__13108,G__13109,G__13110,G__13111,G__13112,G__13113,G__13114,G__13115,G__13116,G__13117,G__13118,G__13119));
});
var G__13580__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__13120 = a;
var G__13121 = b;
var G__13122 = c;
var G__13123 = d;
var G__13124 = e;
var G__13125 = f;
var G__13126 = g;
var G__13127 = h;
var G__13128 = i;
var G__13129 = j;
var G__13130 = k;
var G__13131 = l;
var G__13132 = m;
var G__13133 = n;
var G__13134 = o;
var G__13135 = p;
var G__13136 = q;
var G__13137 = r;
var G__13138 = s;
var G__13139 = t;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20(G__13120,G__13121,G__13122,G__13123,G__13124,G__13125,G__13126,G__13127,G__13128,G__13129,G__13130,G__13131,G__13132,G__13133,G__13134,G__13135,G__13136,G__13137,G__13138,G__13139) : self__.dispatch_fn.call(null,G__13120,G__13121,G__13122,G__13123,G__13124,G__13125,G__13126,G__13127,G__13128,G__13129,G__13130,G__13131,G__13132,G__13133,G__13134,G__13135,G__13136,G__13137,G__13138,G__13139));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__13140 = a;
var G__13141 = b;
var G__13142 = c;
var G__13143 = d;
var G__13144 = e;
var G__13145 = f;
var G__13146 = g;
var G__13147 = h;
var G__13148 = i;
var G__13149 = j;
var G__13150 = k;
var G__13151 = l;
var G__13152 = m;
var G__13153 = n;
var G__13154 = o;
var G__13155 = p;
var G__13156 = q;
var G__13157 = r;
var G__13158 = s;
var G__13159 = t;
return (target_fn.cljs$core$IFn$_invoke$arity$20 ? target_fn.cljs$core$IFn$_invoke$arity$20(G__13140,G__13141,G__13142,G__13143,G__13144,G__13145,G__13146,G__13147,G__13148,G__13149,G__13150,G__13151,G__13152,G__13153,G__13154,G__13155,G__13156,G__13157,