// Compiled by ClojureScript 0.0-2727 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function fn_handler(f){
if(typeof cljs.core.async.t12108 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12108 = (function (f,fn_handler,meta12109){
this.f = f;
this.fn_handler = fn_handler;
this.meta12109 = meta12109;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12108.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12108.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t12108.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t12108.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12110){
var self__ = this;
var _12110__$1 = this;
return self__.meta12109;
});

cljs.core.async.t12108.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12110,meta12109__$1){
var self__ = this;
var _12110__$1 = this;
return (new cljs.core.async.t12108(self__.f,self__.fn_handler,meta12109__$1));
});

cljs.core.async.t12108.cljs$lang$type = true;

cljs.core.async.t12108.cljs$lang$ctorStr = "cljs.core.async/t12108";

cljs.core.async.t12108.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t12108");
});

cljs.core.async.__GT_t12108 = (function __GT_t12108(f__$1,fn_handler__$1,meta12109){
return (new cljs.core.async.t12108(f__$1,fn_handler__$1,meta12109));
});

}

return (new cljs.core.async.t12108(f,fn_handler,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),20,new cljs.core.Keyword(null,"end-line","end-line",1837326455),16,new cljs.core.Keyword(null,"column","column",2078222095),3,new cljs.core.Keyword(null,"line","line",212345235),13,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
});
/**
* Returns a fixed buffer of size n. When full, puts will block/park.
*/
cljs.core.async.buffer = (function buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete but
* val will be dropped (no transfer).
*/
cljs.core.async.dropping_buffer = (function dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
* Returns a buffer of size n. When full, puts will complete, and be
* buffered, but oldest elements in buffer will be dropped (not
* transferred).
*/
cljs.core.async.sliding_buffer = (function sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
* Returns true if a channel created with buff will never block. That is to say,
* puts into this buffer will never cause the buffer to be full.
*/
cljs.core.async.unblocking_buffer_QMARK_ = (function unblocking_buffer_QMARK_(buff){
var G__12112 = buff;
if(G__12112){
var bit__4439__auto__ = null;
if(cljs.core.truth_((function (){var or__3758__auto__ = bit__4439__auto__;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return G__12112.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__12112.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12112);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12112);
}
});
/**
* Creates a channel with an optional buffer, an optional transducer (like (map f),
* (filter p) etc or a composition thereof), and an optional exception handler.
* If buf-or-n is a number, will create and use a fixed buffer of that size. If a
* transducer is supplied a buffer must be specified. ex-handler must be a
* fn of one argument - if an exception occurs during transformation it will be called
* with the thrown value as an argument, and any non-nil return value will be placed
* in the channel.
*/
cljs.core.async.chan = (function() {
var chan = null;
var chan__0 = (function (){
return chan.call(null,null);
});
var chan__1 = (function (buf_or_n){
return chan.call(null,buf_or_n,null,null);
});
var chan__2 = (function (buf_or_n,xform){
return chan.call(null,buf_or_n,xform,null);
});
var chan__3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});
chan = function(buf_or_n,xform,ex_handler){
switch(arguments.length){
case 0:
return chan__0.call(this);
case 1:
return chan__1.call(this,buf_or_n);
case 2:
return chan__2.call(this,buf_or_n,xform);
case 3:
return chan__3.call(this,buf_or_n,xform,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chan.cljs$core$IFn$_invoke$arity$0 = chan__0;
chan.cljs$core$IFn$_invoke$arity$1 = chan__1;
chan.cljs$core$IFn$_invoke$arity$2 = chan__2;
chan.cljs$core$IFn$_invoke$arity$3 = chan__3;
return chan;
})()
;
/**
* Returns a channel that will close after msecs
*/
cljs.core.async.timeout = (function timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
* takes a val from port. Must be called inside a (go ...) block. Will
* return nil if closed. Will park if nothing is available.
* Returns true unless port is already closed
*/
cljs.core.async._LT__BANG_ = (function _LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
* Asynchronously takes a val from port, passing to fn1. Will pass nil
* if closed. If on-caller? (default true) is true, and value is
* immediately available, will call fn1 on calling thread.
* Returns nil.
*/
cljs.core.async.take_BANG_ = (function() {
var take_BANG_ = null;
var take_BANG___2 = (function (port,fn1){
return take_BANG_.call(null,port,fn1,true);
});
var take_BANG___3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12113 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12113);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12113,ret){
return (function (){
return fn1.call(null,val_12113);
});})(val_12113,ret))
);
}
} else {
}

return null;
});
take_BANG_ = function(port,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return take_BANG___2.call(this,port,fn1);
case 3:
return take_BANG___3.call(this,port,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take_BANG_.cljs$core$IFn$_invoke$arity$2 = take_BANG___2;
take_BANG_.cljs$core$IFn$_invoke$arity$3 = take_BANG___3;
return take_BANG_;
})()
;
cljs.core.async.nop = (function nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
* puts a val into port. nil values are not allowed. Must be called
* inside a (go ...) block. Will park if no buffer space is available.
* Returns true unless port is already closed.
*/
cljs.core.async._GT__BANG_ = (function _GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
* Asynchronously puts a val into port, calling fn0 (if supplied) when
* complete. nil values are not allowed. Will throw if closed. If
* on-caller? (default true) is true, and the put is immediately
* accepted, will call fn0 on calling thread.  Returns nil.
*/
cljs.core.async.put_BANG_ = (function() {
var put_BANG_ = null;
var put_BANG___2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});
var put_BANG___3 = (function (port,val,fn1){
return put_BANG_.call(null,port,val,fn1,true);
});
var put_BANG___4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});
put_BANG_ = function(port,val,fn1,on_caller_QMARK_){
switch(arguments.length){
case 2:
return put_BANG___2.call(this,port,val);
case 3:
return put_BANG___3.call(this,port,val,fn1);
case 4:
return put_BANG___4.call(this,port,val,fn1,on_caller_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
put_BANG_.cljs$core$IFn$_invoke$arity$2 = put_BANG___2;
put_BANG_.cljs$core$IFn$_invoke$arity$3 = put_BANG___3;
put_BANG_.cljs$core$IFn$_invoke$arity$4 = put_BANG___4;
return put_BANG_;
})()
;
cljs.core.async.close_BANG_ = (function close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function random_array(n){
var a = (new Array(n));
var n__4645__auto___12114 = n;
var x_12115 = (0);
while(true){
if((x_12115 < n__4645__auto___12114)){
(a[x_12115] = (0));

var G__12116 = (x_12115 + (1));
x_12115 = G__12116;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12117 = (i + (1));
i = G__12117;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t12121 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12121 = (function (flag,alt_flag,meta12122){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta12122 = meta12122;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12121.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12121.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t12121.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t12121.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12123){
var self__ = this;
var _12123__$1 = this;
return self__.meta12122;
});})(flag))
;

cljs.core.async.t12121.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12123,meta12122__$1){
var self__ = this;
var _12123__$1 = this;
return (new cljs.core.async.t12121(self__.flag,self__.alt_flag,meta12122__$1));
});})(flag))
;

cljs.core.async.t12121.cljs$lang$type = true;

cljs.core.async.t12121.cljs$lang$ctorStr = "cljs.core.async/t12121";

cljs.core.async.t12121.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t12121");
});})(flag))
;

cljs.core.async.__GT_t12121 = ((function (flag){
return (function __GT_t12121(flag__$1,alt_flag__$1,meta12122){
return (new cljs.core.async.t12121(flag__$1,alt_flag__$1,meta12122));
});})(flag))
;

}

return (new cljs.core.async.t12121(flag,alt_flag,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),15,new cljs.core.Keyword(null,"end-line","end-line",1837326455),146,new cljs.core.Keyword(null,"column","column",2078222095),5,new cljs.core.Keyword(null,"line","line",212345235),141,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
});
cljs.core.async.alt_handler = (function alt_handler(flag,cb){
if(typeof cljs.core.async.t12127 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12127 = (function (cb,flag,alt_handler,meta12128){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta12128 = meta12128;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12127.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12127.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t12127.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t12127.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12129){
var self__ = this;
var _12129__$1 = this;
return self__.meta12128;
});

cljs.core.async.t12127.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12129,meta12128__$1){
var self__ = this;
var _12129__$1 = this;
return (new cljs.core.async.t12127(self__.cb,self__.flag,self__.alt_handler,meta12128__$1));
});

cljs.core.async.t12127.cljs$lang$type = true;

cljs.core.async.t12127.cljs$lang$ctorStr = "cljs.core.async/t12127";

cljs.core.async.t12127.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t12127");
});

cljs.core.async.__GT_t12127 = (function __GT_t12127(cb__$1,flag__$1,alt_handler__$1,meta12128){
return (new cljs.core.async.t12127(cb__$1,flag__$1,alt_handler__$1,meta12128));
});

}

return (new cljs.core.async.t12127(cb,flag,alt_handler,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),154,new cljs.core.Keyword(null,"column","column",2078222095),3,new cljs.core.Keyword(null,"line","line",212345235),149,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
});
/**
* returns derefable [val port] if immediate, nil if enqueued
*/
cljs.core.async.do_alts = (function do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12130_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12130_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12131_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12131_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3758__auto__ = wport;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12132 = (i + (1));
i = G__12132;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3758__auto__ = ret;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4126__auto__ = (function (){var and__3746__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3746__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3746__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
* Completes at most one of several channel operations. Must be called
* inside a (go ...) block. ports is a vector of channel endpoints,
* which can be either a channel to take from or a vector of
* [channel-to-put-to val-to-put], in any combination. Takes will be
* made as if by <!, and puts will be made as if by >!. Unless
* the :priority option is true, if more than one port operation is
* ready a non-deterministic choice will be made. If no operation is
* ready and a :default value is supplied, [default-val :default] will
* be returned, otherwise alts! will park until the first operation to
* become ready completes. Returns [val port] of the completed
* operation, where val is the value taken for takes, and a
* boolean (true unless already closed, as per put!) for puts.
* 
* opts are passed as :key val ... Supported options:
* 
* :default val - the value to use if none of the operations are immediately ready
* :priority true - (default nil) when true, the operations will be tried in order.
* 
* Note: there is no guarantee that the port exps or val exprs will be
* used, nor in what order should they be, so they should not be
* depended upon for side effects.
* @param {...*} var_args
*/
cljs.core.async.alts_BANG_ = (function() { 
var alts_BANG___delegate = function (ports,p__12133){
var map__12135 = p__12133;
var map__12135__$1 = ((cljs.core.seq_QMARK_.call(null,map__12135))?cljs.core.apply.call(null,cljs.core.hash_map,map__12135):map__12135);
var opts = map__12135__$1;
throw (new Error("alts! used not in (go ...) block"));
};
var alts_BANG_ = function (ports,var_args){
var p__12133 = null;
if (arguments.length > 1) {
var G__12136__i = 0, G__12136__a = new Array(arguments.length -  1);
while (G__12136__i < G__12136__a.length) {G__12136__a[G__12136__i] = arguments[G__12136__i + 1]; ++G__12136__i;}
  p__12133 = new cljs.core.IndexedSeq(G__12136__a,0);
} 
return alts_BANG___delegate.call(this,ports,p__12133);};
alts_BANG_.cljs$lang$maxFixedArity = 1;
alts_BANG_.cljs$lang$applyTo = (function (arglist__12137){
var ports = cljs.core.first(arglist__12137);
var p__12133 = cljs.core.rest(arglist__12137);
return alts_BANG___delegate(ports,p__12133);
});
alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = alts_BANG___delegate;
return alts_BANG_;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes
*/
cljs.core.async.pipe = (function() {
var pipe = null;
var pipe__2 = (function (from,to){
return pipe.call(null,from,to,true);
});
var pipe__3 = (function (from,to,close_QMARK_){
var c__8178__auto___12232 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___12232){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___12232){
return (function (state_12208){
var state_val_12209 = (state_12208[(1)]);
if((state_val_12209 === (7))){
var inst_12204 = (state_12208[(2)]);
var state_12208__$1 = state_12208;
var statearr_12210_12233 = state_12208__$1;
(statearr_12210_12233[(2)] = inst_12204);

(statearr_12210_12233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (1))){
var state_12208__$1 = state_12208;
var statearr_12211_12234 = state_12208__$1;
(statearr_12211_12234[(2)] = null);

(statearr_12211_12234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (4))){
var inst_12187 = (state_12208[(7)]);
var inst_12187__$1 = (state_12208[(2)]);
var inst_12188 = (inst_12187__$1 == null);
var state_12208__$1 = (function (){var statearr_12212 = state_12208;
(statearr_12212[(7)] = inst_12187__$1);

return statearr_12212;
})();
if(cljs.core.truth_(inst_12188)){
var statearr_12213_12235 = state_12208__$1;
(statearr_12213_12235[(1)] = (5));

} else {
var statearr_12214_12236 = state_12208__$1;
(statearr_12214_12236[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (13))){
var state_12208__$1 = state_12208;
var statearr_12215_12237 = state_12208__$1;
(statearr_12215_12237[(2)] = null);

(statearr_12215_12237[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (6))){
var inst_12187 = (state_12208[(7)]);
var state_12208__$1 = state_12208;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12208__$1,(11),to,inst_12187);
} else {
if((state_val_12209 === (3))){
var inst_12206 = (state_12208[(2)]);
var state_12208__$1 = state_12208;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12208__$1,inst_12206);
} else {
if((state_val_12209 === (12))){
var state_12208__$1 = state_12208;
var statearr_12216_12238 = state_12208__$1;
(statearr_12216_12238[(2)] = null);

(statearr_12216_12238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (2))){
var state_12208__$1 = state_12208;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12208__$1,(4),from);
} else {
if((state_val_12209 === (11))){
var inst_12197 = (state_12208[(2)]);
var state_12208__$1 = state_12208;
if(cljs.core.truth_(inst_12197)){
var statearr_12217_12239 = state_12208__$1;
(statearr_12217_12239[(1)] = (12));

} else {
var statearr_12218_12240 = state_12208__$1;
(statearr_12218_12240[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (9))){
var state_12208__$1 = state_12208;
var statearr_12219_12241 = state_12208__$1;
(statearr_12219_12241[(2)] = null);

(statearr_12219_12241[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (5))){
var state_12208__$1 = state_12208;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12220_12242 = state_12208__$1;
(statearr_12220_12242[(1)] = (8));

} else {
var statearr_12221_12243 = state_12208__$1;
(statearr_12221_12243[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (14))){
var inst_12202 = (state_12208[(2)]);
var state_12208__$1 = state_12208;
var statearr_12222_12244 = state_12208__$1;
(statearr_12222_12244[(2)] = inst_12202);

(statearr_12222_12244[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (10))){
var inst_12194 = (state_12208[(2)]);
var state_12208__$1 = state_12208;
var statearr_12223_12245 = state_12208__$1;
(statearr_12223_12245[(2)] = inst_12194);

(statearr_12223_12245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12209 === (8))){
var inst_12191 = cljs.core.async.close_BANG_.call(null,to);
var state_12208__$1 = state_12208;
var statearr_12224_12246 = state_12208__$1;
(statearr_12224_12246[(2)] = inst_12191);

(statearr_12224_12246[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___12232))
;
return ((function (switch__8163__auto__,c__8178__auto___12232){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12228 = [null,null,null,null,null,null,null,null];
(statearr_12228[(0)] = state_machine__8164__auto__);

(statearr_12228[(1)] = (1));

return statearr_12228;
});
var state_machine__8164__auto____1 = (function (state_12208){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12208);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12229){if((e12229 instanceof Object)){
var ex__8167__auto__ = e12229;
var statearr_12230_12247 = state_12208;
(statearr_12230_12247[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12208);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12229;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12248 = state_12208;
state_12208 = G__12248;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12208){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___12232))
})();
var state__8180__auto__ = (function (){var statearr_12231 = f__8179__auto__.call(null);
(statearr_12231[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___12232);

return statearr_12231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___12232))
);


return to;
});
pipe = function(from,to,close_QMARK_){
switch(arguments.length){
case 2:
return pipe__2.call(this,from,to);
case 3:
return pipe__3.call(this,from,to,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipe.cljs$core$IFn$_invoke$arity$2 = pipe__2;
pipe.cljs$core$IFn$_invoke$arity$3 = pipe__3;
return pipe;
})()
;
cljs.core.async.pipeline_STAR_ = (function pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12432){
var vec__12433 = p__12432;
var v = cljs.core.nth.call(null,vec__12433,(0),null);
var p = cljs.core.nth.call(null,vec__12433,(1),null);
var job = vec__12433;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8178__auto___12615 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___12615,res,vec__12433,v,p,job,jobs,results){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___12615,res,vec__12433,v,p,job,jobs,results){
return (function (state_12438){
var state_val_12439 = (state_12438[(1)]);
if((state_val_12439 === (2))){
var inst_12435 = (state_12438[(2)]);
var inst_12436 = cljs.core.async.close_BANG_.call(null,res);
var state_12438__$1 = (function (){var statearr_12440 = state_12438;
(statearr_12440[(7)] = inst_12435);

return statearr_12440;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12438__$1,inst_12436);
} else {
if((state_val_12439 === (1))){
var state_12438__$1 = state_12438;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12438__$1,(2),res,v);
} else {
return null;
}
}
});})(c__8178__auto___12615,res,vec__12433,v,p,job,jobs,results))
;
return ((function (switch__8163__auto__,c__8178__auto___12615,res,vec__12433,v,p,job,jobs,results){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12444 = [null,null,null,null,null,null,null,null];
(statearr_12444[(0)] = state_machine__8164__auto__);

(statearr_12444[(1)] = (1));

return statearr_12444;
});
var state_machine__8164__auto____1 = (function (state_12438){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12438);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12445){if((e12445 instanceof Object)){
var ex__8167__auto__ = e12445;
var statearr_12446_12616 = state_12438;
(statearr_12446_12616[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12438);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12445;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12617 = state_12438;
state_12438 = G__12617;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12438){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___12615,res,vec__12433,v,p,job,jobs,results))
})();
var state__8180__auto__ = (function (){var statearr_12447 = f__8179__auto__.call(null);
(statearr_12447[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___12615);

return statearr_12447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___12615,res,vec__12433,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12448){
var vec__12449 = p__12448;
var v = cljs.core.nth.call(null,vec__12449,(0),null);
var p = cljs.core.nth.call(null,vec__12449,(1),null);
var job = vec__12449;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4645__auto___12618 = n;
var __12619 = (0);
while(true){
if((__12619 < n__4645__auto___12618)){
var G__12450_12620 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12450_12620) {
case "async":
var c__8178__auto___12622 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12619,c__8178__auto___12622,G__12450_12620,n__4645__auto___12618,jobs,results,process,async){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (__12619,c__8178__auto___12622,G__12450_12620,n__4645__auto___12618,jobs,results,process,async){
return (function (state_12463){
var state_val_12464 = (state_12463[(1)]);
if((state_val_12464 === (7))){
var inst_12459 = (state_12463[(2)]);
var state_12463__$1 = state_12463;
var statearr_12465_12623 = state_12463__$1;
(statearr_12465_12623[(2)] = inst_12459);

(statearr_12465_12623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12464 === (6))){
var state_12463__$1 = state_12463;
var statearr_12466_12624 = state_12463__$1;
(statearr_12466_12624[(2)] = null);

(statearr_12466_12624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12464 === (5))){
var state_12463__$1 = state_12463;
var statearr_12467_12625 = state_12463__$1;
(statearr_12467_12625[(2)] = null);

(statearr_12467_12625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12464 === (4))){
var inst_12453 = (state_12463[(2)]);
var inst_12454 = async.call(null,inst_12453);
var state_12463__$1 = state_12463;
if(cljs.core.truth_(inst_12454)){
var statearr_12468_12626 = state_12463__$1;
(statearr_12468_12626[(1)] = (5));

} else {
var statearr_12469_12627 = state_12463__$1;
(statearr_12469_12627[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12464 === (3))){
var inst_12461 = (state_12463[(2)]);
var state_12463__$1 = state_12463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12463__$1,inst_12461);
} else {
if((state_val_12464 === (2))){
var state_12463__$1 = state_12463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12463__$1,(4),jobs);
} else {
if((state_val_12464 === (1))){
var state_12463__$1 = state_12463;
var statearr_12470_12628 = state_12463__$1;
(statearr_12470_12628[(2)] = null);

(statearr_12470_12628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12619,c__8178__auto___12622,G__12450_12620,n__4645__auto___12618,jobs,results,process,async))
;
return ((function (__12619,switch__8163__auto__,c__8178__auto___12622,G__12450_12620,n__4645__auto___12618,jobs,results,process,async){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12474 = [null,null,null,null,null,null,null];
(statearr_12474[(0)] = state_machine__8164__auto__);

(statearr_12474[(1)] = (1));

return statearr_12474;
});
var state_machine__8164__auto____1 = (function (state_12463){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12475){if((e12475 instanceof Object)){
var ex__8167__auto__ = e12475;
var statearr_12476_12629 = state_12463;
(statearr_12476_12629[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12475;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12630 = state_12463;
state_12463 = G__12630;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12463){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(__12619,switch__8163__auto__,c__8178__auto___12622,G__12450_12620,n__4645__auto___12618,jobs,results,process,async))
})();
var state__8180__auto__ = (function (){var statearr_12477 = f__8179__auto__.call(null);
(statearr_12477[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___12622);

return statearr_12477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(__12619,c__8178__auto___12622,G__12450_12620,n__4645__auto___12618,jobs,results,process,async))
);


break;
case "compute":
var c__8178__auto___12631 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12619,c__8178__auto___12631,G__12450_12620,n__4645__auto___12618,jobs,results,process,async){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (__12619,c__8178__auto___12631,G__12450_12620,n__4645__auto___12618,jobs,results,process,async){
return (function (state_12490){
var state_val_12491 = (state_12490[(1)]);
if((state_val_12491 === (7))){
var inst_12486 = (state_12490[(2)]);
var state_12490__$1 = state_12490;
var statearr_12492_12632 = state_12490__$1;
(statearr_12492_12632[(2)] = inst_12486);

(statearr_12492_12632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12491 === (6))){
var state_12490__$1 = state_12490;
var statearr_12493_12633 = state_12490__$1;
(statearr_12493_12633[(2)] = null);

(statearr_12493_12633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12491 === (5))){
var state_12490__$1 = state_12490;
var statearr_12494_12634 = state_12490__$1;
(statearr_12494_12634[(2)] = null);

(statearr_12494_12634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12491 === (4))){
var inst_12480 = (state_12490[(2)]);
var inst_12481 = process.call(null,inst_12480);
var state_12490__$1 = state_12490;
if(cljs.core.truth_(inst_12481)){
var statearr_12495_12635 = state_12490__$1;
(statearr_12495_12635[(1)] = (5));

} else {
var statearr_12496_12636 = state_12490__$1;
(statearr_12496_12636[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12491 === (3))){
var inst_12488 = (state_12490[(2)]);
var state_12490__$1 = state_12490;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12490__$1,inst_12488);
} else {
if((state_val_12491 === (2))){
var state_12490__$1 = state_12490;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12490__$1,(4),jobs);
} else {
if((state_val_12491 === (1))){
var state_12490__$1 = state_12490;
var statearr_12497_12637 = state_12490__$1;
(statearr_12497_12637[(2)] = null);

(statearr_12497_12637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12619,c__8178__auto___12631,G__12450_12620,n__4645__auto___12618,jobs,results,process,async))
;
return ((function (__12619,switch__8163__auto__,c__8178__auto___12631,G__12450_12620,n__4645__auto___12618,jobs,results,process,async){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12501 = [null,null,null,null,null,null,null];
(statearr_12501[(0)] = state_machine__8164__auto__);

(statearr_12501[(1)] = (1));

return statearr_12501;
});
var state_machine__8164__auto____1 = (function (state_12490){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12490);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12502){if((e12502 instanceof Object)){
var ex__8167__auto__ = e12502;
var statearr_12503_12638 = state_12490;
(statearr_12503_12638[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12490);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12639 = state_12490;
state_12490 = G__12639;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12490){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(__12619,switch__8163__auto__,c__8178__auto___12631,G__12450_12620,n__4645__auto___12618,jobs,results,process,async))
})();
var state__8180__auto__ = (function (){var statearr_12504 = f__8179__auto__.call(null);
(statearr_12504[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___12631);

return statearr_12504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(__12619,c__8178__auto___12631,G__12450_12620,n__4645__auto___12618,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12640 = (__12619 + (1));
__12619 = G__12640;
continue;
} else {
}
break;
}

var c__8178__auto___12641 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___12641,jobs,results,process,async){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___12641,jobs,results,process,async){
return (function (state_12526){
var state_val_12527 = (state_12526[(1)]);
if((state_val_12527 === (9))){
var inst_12519 = (state_12526[(2)]);
var state_12526__$1 = (function (){var statearr_12528 = state_12526;
(statearr_12528[(7)] = inst_12519);

return statearr_12528;
})();
var statearr_12529_12642 = state_12526__$1;
(statearr_12529_12642[(2)] = null);

(statearr_12529_12642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (8))){
var inst_12512 = (state_12526[(8)]);
var inst_12517 = (state_12526[(2)]);
var state_12526__$1 = (function (){var statearr_12530 = state_12526;
(statearr_12530[(9)] = inst_12517);

return statearr_12530;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12526__$1,(9),results,inst_12512);
} else {
if((state_val_12527 === (7))){
var inst_12522 = (state_12526[(2)]);
var state_12526__$1 = state_12526;
var statearr_12531_12643 = state_12526__$1;
(statearr_12531_12643[(2)] = inst_12522);

(statearr_12531_12643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (6))){
var inst_12507 = (state_12526[(10)]);
var inst_12512 = (state_12526[(8)]);
var inst_12512__$1 = cljs.core.async.chan.call(null,(1));
var inst_12513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12514 = [inst_12507,inst_12512__$1];
var inst_12515 = (new cljs.core.PersistentVector(null,2,(5),inst_12513,inst_12514,null));
var state_12526__$1 = (function (){var statearr_12532 = state_12526;
(statearr_12532[(8)] = inst_12512__$1);

return statearr_12532;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12526__$1,(8),jobs,inst_12515);
} else {
if((state_val_12527 === (5))){
var inst_12510 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12526__$1 = state_12526;
var statearr_12533_12644 = state_12526__$1;
(statearr_12533_12644[(2)] = inst_12510);

(statearr_12533_12644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (4))){
var inst_12507 = (state_12526[(10)]);
var inst_12507__$1 = (state_12526[(2)]);
var inst_12508 = (inst_12507__$1 == null);
var state_12526__$1 = (function (){var statearr_12534 = state_12526;
(statearr_12534[(10)] = inst_12507__$1);

return statearr_12534;
})();
if(cljs.core.truth_(inst_12508)){
var statearr_12535_12645 = state_12526__$1;
(statearr_12535_12645[(1)] = (5));

} else {
var statearr_12536_12646 = state_12526__$1;
(statearr_12536_12646[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12527 === (3))){
var inst_12524 = (state_12526[(2)]);
var state_12526__$1 = state_12526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12526__$1,inst_12524);
} else {
if((state_val_12527 === (2))){
var state_12526__$1 = state_12526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12526__$1,(4),from);
} else {
if((state_val_12527 === (1))){
var state_12526__$1 = state_12526;
var statearr_12537_12647 = state_12526__$1;
(statearr_12537_12647[(2)] = null);

(statearr_12537_12647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___12641,jobs,results,process,async))
;
return ((function (switch__8163__auto__,c__8178__auto___12641,jobs,results,process,async){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12541 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12541[(0)] = state_machine__8164__auto__);

(statearr_12541[(1)] = (1));

return statearr_12541;
});
var state_machine__8164__auto____1 = (function (state_12526){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12542){if((e12542 instanceof Object)){
var ex__8167__auto__ = e12542;
var statearr_12543_12648 = state_12526;
(statearr_12543_12648[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12526);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12542;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12649 = state_12526;
state_12526 = G__12649;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12526){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___12641,jobs,results,process,async))
})();
var state__8180__auto__ = (function (){var statearr_12544 = f__8179__auto__.call(null);
(statearr_12544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___12641);

return statearr_12544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___12641,jobs,results,process,async))
);


var c__8178__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto__,jobs,results,process,async){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto__,jobs,results,process,async){
return (function (state_12582){
var state_val_12583 = (state_12582[(1)]);
if((state_val_12583 === (7))){
var inst_12578 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12584_12650 = state_12582__$1;
(statearr_12584_12650[(2)] = inst_12578);

(statearr_12584_12650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (20))){
var state_12582__$1 = state_12582;
var statearr_12585_12651 = state_12582__$1;
(statearr_12585_12651[(2)] = null);

(statearr_12585_12651[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (1))){
var state_12582__$1 = state_12582;
var statearr_12586_12652 = state_12582__$1;
(statearr_12586_12652[(2)] = null);

(statearr_12586_12652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (4))){
var inst_12547 = (state_12582[(7)]);
var inst_12547__$1 = (state_12582[(2)]);
var inst_12548 = (inst_12547__$1 == null);
var state_12582__$1 = (function (){var statearr_12587 = state_12582;
(statearr_12587[(7)] = inst_12547__$1);

return statearr_12587;
})();
if(cljs.core.truth_(inst_12548)){
var statearr_12588_12653 = state_12582__$1;
(statearr_12588_12653[(1)] = (5));

} else {
var statearr_12589_12654 = state_12582__$1;
(statearr_12589_12654[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (15))){
var inst_12560 = (state_12582[(8)]);
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12582__$1,(18),to,inst_12560);
} else {
if((state_val_12583 === (21))){
var inst_12573 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12590_12655 = state_12582__$1;
(statearr_12590_12655[(2)] = inst_12573);

(statearr_12590_12655[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (13))){
var inst_12575 = (state_12582[(2)]);
var state_12582__$1 = (function (){var statearr_12591 = state_12582;
(statearr_12591[(9)] = inst_12575);

return statearr_12591;
})();
var statearr_12592_12656 = state_12582__$1;
(statearr_12592_12656[(2)] = null);

(statearr_12592_12656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (6))){
var inst_12547 = (state_12582[(7)]);
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12582__$1,(11),inst_12547);
} else {
if((state_val_12583 === (17))){
var inst_12568 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
if(cljs.core.truth_(inst_12568)){
var statearr_12593_12657 = state_12582__$1;
(statearr_12593_12657[(1)] = (19));

} else {
var statearr_12594_12658 = state_12582__$1;
(statearr_12594_12658[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (3))){
var inst_12580 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12582__$1,inst_12580);
} else {
if((state_val_12583 === (12))){
var inst_12557 = (state_12582[(10)]);
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12582__$1,(14),inst_12557);
} else {
if((state_val_12583 === (2))){
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12582__$1,(4),results);
} else {
if((state_val_12583 === (19))){
var state_12582__$1 = state_12582;
var statearr_12595_12659 = state_12582__$1;
(statearr_12595_12659[(2)] = null);

(statearr_12595_12659[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (11))){
var inst_12557 = (state_12582[(2)]);
var state_12582__$1 = (function (){var statearr_12596 = state_12582;
(statearr_12596[(10)] = inst_12557);

return statearr_12596;
})();
var statearr_12597_12660 = state_12582__$1;
(statearr_12597_12660[(2)] = null);

(statearr_12597_12660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (9))){
var state_12582__$1 = state_12582;
var statearr_12598_12661 = state_12582__$1;
(statearr_12598_12661[(2)] = null);

(statearr_12598_12661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (5))){
var state_12582__$1 = state_12582;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12599_12662 = state_12582__$1;
(statearr_12599_12662[(1)] = (8));

} else {
var statearr_12600_12663 = state_12582__$1;
(statearr_12600_12663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (14))){
var inst_12562 = (state_12582[(11)]);
var inst_12560 = (state_12582[(8)]);
var inst_12560__$1 = (state_12582[(2)]);
var inst_12561 = (inst_12560__$1 == null);
var inst_12562__$1 = cljs.core.not.call(null,inst_12561);
var state_12582__$1 = (function (){var statearr_12601 = state_12582;
(statearr_12601[(11)] = inst_12562__$1);

(statearr_12601[(8)] = inst_12560__$1);

return statearr_12601;
})();
if(inst_12562__$1){
var statearr_12602_12664 = state_12582__$1;
(statearr_12602_12664[(1)] = (15));

} else {
var statearr_12603_12665 = state_12582__$1;
(statearr_12603_12665[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (16))){
var inst_12562 = (state_12582[(11)]);
var state_12582__$1 = state_12582;
var statearr_12604_12666 = state_12582__$1;
(statearr_12604_12666[(2)] = inst_12562);

(statearr_12604_12666[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (10))){
var inst_12554 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12605_12667 = state_12582__$1;
(statearr_12605_12667[(2)] = inst_12554);

(statearr_12605_12667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (18))){
var inst_12565 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12606_12668 = state_12582__$1;
(statearr_12606_12668[(2)] = inst_12565);

(statearr_12606_12668[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (8))){
var inst_12551 = cljs.core.async.close_BANG_.call(null,to);
var state_12582__$1 = state_12582;
var statearr_12607_12669 = state_12582__$1;
(statearr_12607_12669[(2)] = inst_12551);

(statearr_12607_12669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto__,jobs,results,process,async))
;
return ((function (switch__8163__auto__,c__8178__auto__,jobs,results,process,async){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12611 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12611[(0)] = state_machine__8164__auto__);

(statearr_12611[(1)] = (1));

return statearr_12611;
});
var state_machine__8164__auto____1 = (function (state_12582){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12612){if((e12612 instanceof Object)){
var ex__8167__auto__ = e12612;
var statearr_12613_12670 = state_12582;
(statearr_12613_12670[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12582);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12612;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12671 = state_12582;
state_12582 = G__12671;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12582){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto__,jobs,results,process,async))
})();
var state__8180__auto__ = (function (){var statearr_12614 = f__8179__auto__.call(null);
(statearr_12614[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto__);

return statearr_12614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto__,jobs,results,process,async))
);

return c__8178__auto__;
});
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the async function af, with parallelism n. af
* must be a function of two arguments, the first an input value and
* the second a channel on which to place the result(s). af must close!
* the channel before returning.  The presumption is that af will
* return immediately, having launched some asynchronous operation
* whose completion/callback will manipulate the result channel. Outputs
* will be returned in order relative to  the inputs. By default, the to
* channel will be closed when the from channel closes, but can be
* determined by the close?  parameter. Will stop consuming the from
* channel if the to channel closes.
*/
cljs.core.async.pipeline_async = (function() {
var pipeline_async = null;
var pipeline_async__4 = (function (n,to,af,from){
return pipeline_async.call(null,n,to,af,from,true);
});
var pipeline_async__5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});
pipeline_async = function(n,to,af,from,close_QMARK_){
switch(arguments.length){
case 4:
return pipeline_async__4.call(this,n,to,af,from);
case 5:
return pipeline_async__5.call(this,n,to,af,from,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline_async.cljs$core$IFn$_invoke$arity$4 = pipeline_async__4;
pipeline_async.cljs$core$IFn$_invoke$arity$5 = pipeline_async__5;
return pipeline_async;
})()
;
/**
* Takes elements from the from channel and supplies them to the to
* channel, subject to the transducer xf, with parallelism n. Because
* it is parallel, the transducer will be applied independently to each
* element, not across elements, and may produce zero or more outputs
* per input.  Outputs will be returned in order relative to the
* inputs. By default, the to channel will be closed when the from
* channel closes, but can be determined by the close?  parameter. Will
* stop consuming the from channel if the to channel closes.
* 
* Note this is supplied for API compatibility with the Clojure version.
* Values of N > 1 will not result in actual concurrency in a
* single-threaded runtime.
*/
cljs.core.async.pipeline = (function() {
var pipeline = null;
var pipeline__4 = (function (n,to,xf,from){
return pipeline.call(null,n,to,xf,from,true);
});
var pipeline__5 = (function (n,to,xf,from,close_QMARK_){
return pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});
var pipeline__6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});
pipeline = function(n,to,xf,from,close_QMARK_,ex_handler){
switch(arguments.length){
case 4:
return pipeline__4.call(this,n,to,xf,from);
case 5:
return pipeline__5.call(this,n,to,xf,from,close_QMARK_);
case 6:
return pipeline__6.call(this,n,to,xf,from,close_QMARK_,ex_handler);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pipeline.cljs$core$IFn$_invoke$arity$4 = pipeline__4;
pipeline.cljs$core$IFn$_invoke$arity$5 = pipeline__5;
pipeline.cljs$core$IFn$_invoke$arity$6 = pipeline__6;
return pipeline;
})()
;
/**
* Takes a predicate and a source channel and returns a vector of two
* channels, the first of which will contain the values for which the
* predicate returned true, the second those for which it returned
* false.
* 
* The out channels will be unbuffered by default, or two buf-or-ns can
* be supplied. The channels will close after the source channel has
* closed.
*/
cljs.core.async.split = (function() {
var split = null;
var split__2 = (function (p,ch){
return split.call(null,p,ch,null,null);
});
var split__4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8178__auto___12772 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___12772,tc,fc){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___12772,tc,fc){
return (function (state_12747){
var state_val_12748 = (state_12747[(1)]);
if((state_val_12748 === (7))){
var inst_12743 = (state_12747[(2)]);
var state_12747__$1 = state_12747;
var statearr_12749_12773 = state_12747__$1;
(statearr_12749_12773[(2)] = inst_12743);

(statearr_12749_12773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (1))){
var state_12747__$1 = state_12747;
var statearr_12750_12774 = state_12747__$1;
(statearr_12750_12774[(2)] = null);

(statearr_12750_12774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (4))){
var inst_12724 = (state_12747[(7)]);
var inst_12724__$1 = (state_12747[(2)]);
var inst_12725 = (inst_12724__$1 == null);
var state_12747__$1 = (function (){var statearr_12751 = state_12747;
(statearr_12751[(7)] = inst_12724__$1);

return statearr_12751;
})();
if(cljs.core.truth_(inst_12725)){
var statearr_12752_12775 = state_12747__$1;
(statearr_12752_12775[(1)] = (5));

} else {
var statearr_12753_12776 = state_12747__$1;
(statearr_12753_12776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (13))){
var state_12747__$1 = state_12747;
var statearr_12754_12777 = state_12747__$1;
(statearr_12754_12777[(2)] = null);

(statearr_12754_12777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (6))){
var inst_12724 = (state_12747[(7)]);
var inst_12730 = p.call(null,inst_12724);
var state_12747__$1 = state_12747;
if(cljs.core.truth_(inst_12730)){
var statearr_12755_12778 = state_12747__$1;
(statearr_12755_12778[(1)] = (9));

} else {
var statearr_12756_12779 = state_12747__$1;
(statearr_12756_12779[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (3))){
var inst_12745 = (state_12747[(2)]);
var state_12747__$1 = state_12747;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12747__$1,inst_12745);
} else {
if((state_val_12748 === (12))){
var state_12747__$1 = state_12747;
var statearr_12757_12780 = state_12747__$1;
(statearr_12757_12780[(2)] = null);

(statearr_12757_12780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (2))){
var state_12747__$1 = state_12747;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12747__$1,(4),ch);
} else {
if((state_val_12748 === (11))){
var inst_12724 = (state_12747[(7)]);
var inst_12734 = (state_12747[(2)]);
var state_12747__$1 = state_12747;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12747__$1,(8),inst_12734,inst_12724);
} else {
if((state_val_12748 === (9))){
var state_12747__$1 = state_12747;
var statearr_12758_12781 = state_12747__$1;
(statearr_12758_12781[(2)] = tc);

(statearr_12758_12781[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (5))){
var inst_12727 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12728 = cljs.core.async.close_BANG_.call(null,fc);
var state_12747__$1 = (function (){var statearr_12759 = state_12747;
(statearr_12759[(8)] = inst_12727);

return statearr_12759;
})();
var statearr_12760_12782 = state_12747__$1;
(statearr_12760_12782[(2)] = inst_12728);

(statearr_12760_12782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (14))){
var inst_12741 = (state_12747[(2)]);
var state_12747__$1 = state_12747;
var statearr_12761_12783 = state_12747__$1;
(statearr_12761_12783[(2)] = inst_12741);

(statearr_12761_12783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (10))){
var state_12747__$1 = state_12747;
var statearr_12762_12784 = state_12747__$1;
(statearr_12762_12784[(2)] = fc);

(statearr_12762_12784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12748 === (8))){
var inst_12736 = (state_12747[(2)]);
var state_12747__$1 = state_12747;
if(cljs.core.truth_(inst_12736)){
var statearr_12763_12785 = state_12747__$1;
(statearr_12763_12785[(1)] = (12));

} else {
var statearr_12764_12786 = state_12747__$1;
(statearr_12764_12786[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___12772,tc,fc))
;
return ((function (switch__8163__auto__,c__8178__auto___12772,tc,fc){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12768 = [null,null,null,null,null,null,null,null,null];
(statearr_12768[(0)] = state_machine__8164__auto__);

(statearr_12768[(1)] = (1));

return statearr_12768;
});
var state_machine__8164__auto____1 = (function (state_12747){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12747);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12769){if((e12769 instanceof Object)){
var ex__8167__auto__ = e12769;
var statearr_12770_12787 = state_12747;
(statearr_12770_12787[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12747);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12769;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12788 = state_12747;
state_12747 = G__12788;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12747){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___12772,tc,fc))
})();
var state__8180__auto__ = (function (){var statearr_12771 = f__8179__auto__.call(null);
(statearr_12771[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___12772);

return statearr_12771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___12772,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});
split = function(p,ch,t_buf_or_n,f_buf_or_n){
switch(arguments.length){
case 2:
return split__2.call(this,p,ch);
case 4:
return split__4.call(this,p,ch,t_buf_or_n,f_buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
split.cljs$core$IFn$_invoke$arity$2 = split__2;
split.cljs$core$IFn$_invoke$arity$4 = split__4;
return split;
})()
;
/**
* f should be a function of 2 arguments. Returns a channel containing
* the single result of applying f to init and the first item from the
* channel, then applying f to that result and the 2nd item, etc. If
* the channel closes without yielding items, returns init and f is not
* called. ch must close before reduce produces a result.
*/
cljs.core.async.reduce = (function reduce(f,init,ch){
var c__8178__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto__){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto__){
return (function (state_12835){
var state_val_12836 = (state_12835[(1)]);
if((state_val_12836 === (7))){
var inst_12831 = (state_12835[(2)]);
var state_12835__$1 = state_12835;
var statearr_12837_12853 = state_12835__$1;
(statearr_12837_12853[(2)] = inst_12831);

(statearr_12837_12853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12836 === (6))){
var inst_12821 = (state_12835[(7)]);
var inst_12824 = (state_12835[(8)]);
var inst_12828 = f.call(null,inst_12821,inst_12824);
var inst_12821__$1 = inst_12828;
var state_12835__$1 = (function (){var statearr_12838 = state_12835;
(statearr_12838[(7)] = inst_12821__$1);

return statearr_12838;
})();
var statearr_12839_12854 = state_12835__$1;
(statearr_12839_12854[(2)] = null);

(statearr_12839_12854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12836 === (5))){
var inst_12821 = (state_12835[(7)]);
var state_12835__$1 = state_12835;
var statearr_12840_12855 = state_12835__$1;
(statearr_12840_12855[(2)] = inst_12821);

(statearr_12840_12855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12836 === (4))){
var inst_12824 = (state_12835[(8)]);
var inst_12824__$1 = (state_12835[(2)]);
var inst_12825 = (inst_12824__$1 == null);
var state_12835__$1 = (function (){var statearr_12841 = state_12835;
(statearr_12841[(8)] = inst_12824__$1);

return statearr_12841;
})();
if(cljs.core.truth_(inst_12825)){
var statearr_12842_12856 = state_12835__$1;
(statearr_12842_12856[(1)] = (5));

} else {
var statearr_12843_12857 = state_12835__$1;
(statearr_12843_12857[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12836 === (3))){
var inst_12833 = (state_12835[(2)]);
var state_12835__$1 = state_12835;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12835__$1,inst_12833);
} else {
if((state_val_12836 === (2))){
var state_12835__$1 = state_12835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12835__$1,(4),ch);
} else {
if((state_val_12836 === (1))){
var inst_12821 = init;
var state_12835__$1 = (function (){var statearr_12844 = state_12835;
(statearr_12844[(7)] = inst_12821);

return statearr_12844;
})();
var statearr_12845_12858 = state_12835__$1;
(statearr_12845_12858[(2)] = null);

(statearr_12845_12858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__8178__auto__))
;
return ((function (switch__8163__auto__,c__8178__auto__){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12849 = [null,null,null,null,null,null,null,null,null];
(statearr_12849[(0)] = state_machine__8164__auto__);

(statearr_12849[(1)] = (1));

return statearr_12849;
});
var state_machine__8164__auto____1 = (function (state_12835){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12850){if((e12850 instanceof Object)){
var ex__8167__auto__ = e12850;
var statearr_12851_12859 = state_12835;
(statearr_12851_12859[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12835);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12850;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12860 = state_12835;
state_12835 = G__12860;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12835){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto__))
})();
var state__8180__auto__ = (function (){var statearr_12852 = f__8179__auto__.call(null);
(statearr_12852[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto__);

return statearr_12852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto__))
);

return c__8178__auto__;
});
/**
* Puts the contents of coll into the supplied channel.
* 
* By default the channel will be closed after the items are copied,
* but can be determined by the close? parameter.
* 
* Returns a channel which will close after the items are copied.
*/
cljs.core.async.onto_chan = (function() {
var onto_chan = null;
var onto_chan__2 = (function (ch,coll){
return onto_chan.call(null,ch,coll,true);
});
var onto_chan__3 = (function (ch,coll,close_QMARK_){
var c__8178__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto__){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto__){
return (function (state_12934){
var state_val_12935 = (state_12934[(1)]);
if((state_val_12935 === (7))){
var inst_12916 = (state_12934[(2)]);
var state_12934__$1 = state_12934;
var statearr_12936_12959 = state_12934__$1;
(statearr_12936_12959[(2)] = inst_12916);

(statearr_12936_12959[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (1))){
var inst_12910 = cljs.core.seq.call(null,coll);
var inst_12911 = inst_12910;
var state_12934__$1 = (function (){var statearr_12937 = state_12934;
(statearr_12937[(7)] = inst_12911);

return statearr_12937;
})();
var statearr_12938_12960 = state_12934__$1;
(statearr_12938_12960[(2)] = null);

(statearr_12938_12960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (4))){
var inst_12911 = (state_12934[(7)]);
var inst_12914 = cljs.core.first.call(null,inst_12911);
var state_12934__$1 = state_12934;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12934__$1,(7),ch,inst_12914);
} else {
if((state_val_12935 === (13))){
var inst_12928 = (state_12934[(2)]);
var state_12934__$1 = state_12934;
var statearr_12939_12961 = state_12934__$1;
(statearr_12939_12961[(2)] = inst_12928);

(statearr_12939_12961[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (6))){
var inst_12919 = (state_12934[(2)]);
var state_12934__$1 = state_12934;
if(cljs.core.truth_(inst_12919)){
var statearr_12940_12962 = state_12934__$1;
(statearr_12940_12962[(1)] = (8));

} else {
var statearr_12941_12963 = state_12934__$1;
(statearr_12941_12963[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (3))){
var inst_12932 = (state_12934[(2)]);
var state_12934__$1 = state_12934;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12934__$1,inst_12932);
} else {
if((state_val_12935 === (12))){
var state_12934__$1 = state_12934;
var statearr_12942_12964 = state_12934__$1;
(statearr_12942_12964[(2)] = null);

(statearr_12942_12964[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (2))){
var inst_12911 = (state_12934[(7)]);
var state_12934__$1 = state_12934;
if(cljs.core.truth_(inst_12911)){
var statearr_12943_12965 = state_12934__$1;
(statearr_12943_12965[(1)] = (4));

} else {
var statearr_12944_12966 = state_12934__$1;
(statearr_12944_12966[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (11))){
var inst_12925 = cljs.core.async.close_BANG_.call(null,ch);
var state_12934__$1 = state_12934;
var statearr_12945_12967 = state_12934__$1;
(statearr_12945_12967[(2)] = inst_12925);

(statearr_12945_12967[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (9))){
var state_12934__$1 = state_12934;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12946_12968 = state_12934__$1;
(statearr_12946_12968[(1)] = (11));

} else {
var statearr_12947_12969 = state_12934__$1;
(statearr_12947_12969[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (5))){
var inst_12911 = (state_12934[(7)]);
var state_12934__$1 = state_12934;
var statearr_12948_12970 = state_12934__$1;
(statearr_12948_12970[(2)] = inst_12911);

(statearr_12948_12970[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (10))){
var inst_12930 = (state_12934[(2)]);
var state_12934__$1 = state_12934;
var statearr_12949_12971 = state_12934__$1;
(statearr_12949_12971[(2)] = inst_12930);

(statearr_12949_12971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12935 === (8))){
var inst_12911 = (state_12934[(7)]);
var inst_12921 = cljs.core.next.call(null,inst_12911);
var inst_12911__$1 = inst_12921;
var state_12934__$1 = (function (){var statearr_12950 = state_12934;
(statearr_12950[(7)] = inst_12911__$1);

return statearr_12950;
})();
var statearr_12951_12972 = state_12934__$1;
(statearr_12951_12972[(2)] = null);

(statearr_12951_12972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto__))
;
return ((function (switch__8163__auto__,c__8178__auto__){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_12955 = [null,null,null,null,null,null,null,null];
(statearr_12955[(0)] = state_machine__8164__auto__);

(statearr_12955[(1)] = (1));

return statearr_12955;
});
var state_machine__8164__auto____1 = (function (state_12934){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_12934);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e12956){if((e12956 instanceof Object)){
var ex__8167__auto__ = e12956;
var statearr_12957_12973 = state_12934;
(statearr_12957_12973[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12934);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12956;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12974 = state_12934;
state_12934 = G__12974;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_12934){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_12934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto__))
})();
var state__8180__auto__ = (function (){var statearr_12958 = f__8179__auto__.call(null);
(statearr_12958[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto__);

return statearr_12958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto__))
);

return c__8178__auto__;
});
onto_chan = function(ch,coll,close_QMARK_){
switch(arguments.length){
case 2:
return onto_chan__2.call(this,ch,coll);
case 3:
return onto_chan__3.call(this,ch,coll,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
onto_chan.cljs$core$IFn$_invoke$arity$2 = onto_chan__2;
onto_chan.cljs$core$IFn$_invoke$arity$3 = onto_chan__3;
return onto_chan;
})()
;
/**
* Creates and returns a channel which contains the contents of coll,
* closing when exhausted.
*/
cljs.core.async.to_chan = (function to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj12976 = {};
return obj12976;
})();

cljs.core.async.muxch_STAR_ = (function muxch_STAR_(_){
if((function (){var and__3746__auto__ = _;
if(and__3746__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4402__auto__ = (((_ == null))?null:_);
return (function (){var or__3758__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj12978 = {};
return obj12978;
})();

cljs.core.async.tap_STAR_ = (function tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function untap_STAR_(m,ch){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function untap_all_STAR_(m){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
* Creates and returns a mult(iple) of the supplied channel. Channels
* containing copies of the channel can be created with 'tap', and
* detached with 'untap'.
* 
* Each item is distributed to all taps in parallel and synchronously,
* i.e. each tap must accept before the next item is distributed. Use
* buffering/windowing to prevent slow taps from holding up the mult.
* 
* Items received when there are no taps get dropped.
* 
* If a tap puts to a closed channel, it will be removed from the mult.
*/
cljs.core.async.mult = (function mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t13200 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13200 = (function (cs,ch,mult,meta13201){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta13201 = meta13201;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13200.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t13200.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t13200.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t13200.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t13200.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13200.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t13200.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13202){
var self__ = this;
var _13202__$1 = this;
return self__.meta13201;
});})(cs))
;

cljs.core.async.t13200.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13202,meta13201__$1){
var self__ = this;
var _13202__$1 = this;
return (new cljs.core.async.t13200(self__.cs,self__.ch,self__.mult,meta13201__$1));
});})(cs))
;

cljs.core.async.t13200.cljs$lang$type = true;

cljs.core.async.t13200.cljs$lang$ctorStr = "cljs.core.async/t13200";

cljs.core.async.t13200.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t13200");
});})(cs))
;

cljs.core.async.__GT_t13200 = ((function (cs){
return (function __GT_t13200(cs__$1,ch__$1,mult__$1,meta13201){
return (new cljs.core.async.t13200(cs__$1,ch__$1,mult__$1,meta13201));
});})(cs))
;

}

return (new cljs.core.async.t13200(cs,ch,mult,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),48,new cljs.core.Keyword(null,"end-line","end-line",1837326455),397,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"line","line",212345235),390,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8178__auto___13421 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___13421,cs,m,dchan,dctr,done){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___13421,cs,m,dchan,dctr,done){
return (function (state_13333){
var state_val_13334 = (state_13333[(1)]);
if((state_val_13334 === (7))){
var inst_13329 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13335_13422 = state_13333__$1;
(statearr_13335_13422[(2)] = inst_13329);

(statearr_13335_13422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (20))){
var inst_13234 = (state_13333[(7)]);
var inst_13244 = cljs.core.first.call(null,inst_13234);
var inst_13245 = cljs.core.nth.call(null,inst_13244,(0),null);
var inst_13246 = cljs.core.nth.call(null,inst_13244,(1),null);
var state_13333__$1 = (function (){var statearr_13336 = state_13333;
(statearr_13336[(8)] = inst_13245);

return statearr_13336;
})();
if(cljs.core.truth_(inst_13246)){
var statearr_13337_13423 = state_13333__$1;
(statearr_13337_13423[(1)] = (22));

} else {
var statearr_13338_13424 = state_13333__$1;
(statearr_13338_13424[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (27))){
var inst_13276 = (state_13333[(9)]);
var inst_13281 = (state_13333[(10)]);
var inst_13274 = (state_13333[(11)]);
var inst_13205 = (state_13333[(12)]);
var inst_13281__$1 = cljs.core._nth.call(null,inst_13274,inst_13276);
var inst_13282 = cljs.core.async.put_BANG_.call(null,inst_13281__$1,inst_13205,done);
var state_13333__$1 = (function (){var statearr_13339 = state_13333;
(statearr_13339[(10)] = inst_13281__$1);

return statearr_13339;
})();
if(cljs.core.truth_(inst_13282)){
var statearr_13340_13425 = state_13333__$1;
(statearr_13340_13425[(1)] = (30));

} else {
var statearr_13341_13426 = state_13333__$1;
(statearr_13341_13426[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (1))){
var state_13333__$1 = state_13333;
var statearr_13342_13427 = state_13333__$1;
(statearr_13342_13427[(2)] = null);

(statearr_13342_13427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (24))){
var inst_13234 = (state_13333[(7)]);
var inst_13251 = (state_13333[(2)]);
var inst_13252 = cljs.core.next.call(null,inst_13234);
var inst_13214 = inst_13252;
var inst_13215 = null;
var inst_13216 = (0);
var inst_13217 = (0);
var state_13333__$1 = (function (){var statearr_13343 = state_13333;
(statearr_13343[(13)] = inst_13216);

(statearr_13343[(14)] = inst_13251);

(statearr_13343[(15)] = inst_13215);

(statearr_13343[(16)] = inst_13217);

(statearr_13343[(17)] = inst_13214);

return statearr_13343;
})();
var statearr_13344_13428 = state_13333__$1;
(statearr_13344_13428[(2)] = null);

(statearr_13344_13428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (39))){
var state_13333__$1 = state_13333;
var statearr_13348_13429 = state_13333__$1;
(statearr_13348_13429[(2)] = null);

(statearr_13348_13429[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (4))){
var inst_13205 = (state_13333[(12)]);
var inst_13205__$1 = (state_13333[(2)]);
var inst_13206 = (inst_13205__$1 == null);
var state_13333__$1 = (function (){var statearr_13349 = state_13333;
(statearr_13349[(12)] = inst_13205__$1);

return statearr_13349;
})();
if(cljs.core.truth_(inst_13206)){
var statearr_13350_13430 = state_13333__$1;
(statearr_13350_13430[(1)] = (5));

} else {
var statearr_13351_13431 = state_13333__$1;
(statearr_13351_13431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (15))){
var inst_13216 = (state_13333[(13)]);
var inst_13215 = (state_13333[(15)]);
var inst_13217 = (state_13333[(16)]);
var inst_13214 = (state_13333[(17)]);
var inst_13230 = (state_13333[(2)]);
var inst_13231 = (inst_13217 + (1));
var tmp13345 = inst_13216;
var tmp13346 = inst_13215;
var tmp13347 = inst_13214;
var inst_13214__$1 = tmp13347;
var inst_13215__$1 = tmp13346;
var inst_13216__$1 = tmp13345;
var inst_13217__$1 = inst_13231;
var state_13333__$1 = (function (){var statearr_13352 = state_13333;
(statearr_13352[(13)] = inst_13216__$1);

(statearr_13352[(15)] = inst_13215__$1);

(statearr_13352[(16)] = inst_13217__$1);

(statearr_13352[(17)] = inst_13214__$1);

(statearr_13352[(18)] = inst_13230);

return statearr_13352;
})();
var statearr_13353_13432 = state_13333__$1;
(statearr_13353_13432[(2)] = null);

(statearr_13353_13432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (21))){
var inst_13255 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13357_13433 = state_13333__$1;
(statearr_13357_13433[(2)] = inst_13255);

(statearr_13357_13433[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (31))){
var inst_13281 = (state_13333[(10)]);
var inst_13285 = done.call(null,null);
var inst_13286 = cljs.core.async.untap_STAR_.call(null,m,inst_13281);
var state_13333__$1 = (function (){var statearr_13358 = state_13333;
(statearr_13358[(19)] = inst_13285);

return statearr_13358;
})();
var statearr_13359_13434 = state_13333__$1;
(statearr_13359_13434[(2)] = inst_13286);

(statearr_13359_13434[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (32))){
var inst_13276 = (state_13333[(9)]);
var inst_13275 = (state_13333[(20)]);
var inst_13274 = (state_13333[(11)]);
var inst_13273 = (state_13333[(21)]);
var inst_13288 = (state_13333[(2)]);
var inst_13289 = (inst_13276 + (1));
var tmp13354 = inst_13275;
var tmp13355 = inst_13274;
var tmp13356 = inst_13273;
var inst_13273__$1 = tmp13356;
var inst_13274__$1 = tmp13355;
var inst_13275__$1 = tmp13354;
var inst_13276__$1 = inst_13289;
var state_13333__$1 = (function (){var statearr_13360 = state_13333;
(statearr_13360[(9)] = inst_13276__$1);

(statearr_13360[(20)] = inst_13275__$1);

(statearr_13360[(11)] = inst_13274__$1);

(statearr_13360[(21)] = inst_13273__$1);

(statearr_13360[(22)] = inst_13288);

return statearr_13360;
})();
var statearr_13361_13435 = state_13333__$1;
(statearr_13361_13435[(2)] = null);

(statearr_13361_13435[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (40))){
var inst_13301 = (state_13333[(23)]);
var inst_13305 = done.call(null,null);
var inst_13306 = cljs.core.async.untap_STAR_.call(null,m,inst_13301);
var state_13333__$1 = (function (){var statearr_13362 = state_13333;
(statearr_13362[(24)] = inst_13305);

return statearr_13362;
})();
var statearr_13363_13436 = state_13333__$1;
(statearr_13363_13436[(2)] = inst_13306);

(statearr_13363_13436[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (33))){
var inst_13292 = (state_13333[(25)]);
var inst_13294 = cljs.core.chunked_seq_QMARK_.call(null,inst_13292);
var state_13333__$1 = state_13333;
if(inst_13294){
var statearr_13364_13437 = state_13333__$1;
(statearr_13364_13437[(1)] = (36));

} else {
var statearr_13365_13438 = state_13333__$1;
(statearr_13365_13438[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (13))){
var inst_13224 = (state_13333[(26)]);
var inst_13227 = cljs.core.async.close_BANG_.call(null,inst_13224);
var state_13333__$1 = state_13333;
var statearr_13366_13439 = state_13333__$1;
(statearr_13366_13439[(2)] = inst_13227);

(statearr_13366_13439[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (22))){
var inst_13245 = (state_13333[(8)]);
var inst_13248 = cljs.core.async.close_BANG_.call(null,inst_13245);
var state_13333__$1 = state_13333;
var statearr_13367_13440 = state_13333__$1;
(statearr_13367_13440[(2)] = inst_13248);

(statearr_13367_13440[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (36))){
var inst_13292 = (state_13333[(25)]);
var inst_13296 = cljs.core.chunk_first.call(null,inst_13292);
var inst_13297 = cljs.core.chunk_rest.call(null,inst_13292);
var inst_13298 = cljs.core.count.call(null,inst_13296);
var inst_13273 = inst_13297;
var inst_13274 = inst_13296;
var inst_13275 = inst_13298;
var inst_13276 = (0);
var state_13333__$1 = (function (){var statearr_13368 = state_13333;
(statearr_13368[(9)] = inst_13276);

(statearr_13368[(20)] = inst_13275);

(statearr_13368[(11)] = inst_13274);

(statearr_13368[(21)] = inst_13273);

return statearr_13368;
})();
var statearr_13369_13441 = state_13333__$1;
(statearr_13369_13441[(2)] = null);

(statearr_13369_13441[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (41))){
var inst_13292 = (state_13333[(25)]);
var inst_13308 = (state_13333[(2)]);
var inst_13309 = cljs.core.next.call(null,inst_13292);
var inst_13273 = inst_13309;
var inst_13274 = null;
var inst_13275 = (0);
var inst_13276 = (0);
var state_13333__$1 = (function (){var statearr_13370 = state_13333;
(statearr_13370[(9)] = inst_13276);

(statearr_13370[(20)] = inst_13275);

(statearr_13370[(11)] = inst_13274);

(statearr_13370[(21)] = inst_13273);

(statearr_13370[(27)] = inst_13308);

return statearr_13370;
})();
var statearr_13371_13442 = state_13333__$1;
(statearr_13371_13442[(2)] = null);

(statearr_13371_13442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (43))){
var state_13333__$1 = state_13333;
var statearr_13372_13443 = state_13333__$1;
(statearr_13372_13443[(2)] = null);

(statearr_13372_13443[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (29))){
var inst_13317 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13373_13444 = state_13333__$1;
(statearr_13373_13444[(2)] = inst_13317);

(statearr_13373_13444[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (44))){
var inst_13326 = (state_13333[(2)]);
var state_13333__$1 = (function (){var statearr_13374 = state_13333;
(statearr_13374[(28)] = inst_13326);

return statearr_13374;
})();
var statearr_13375_13445 = state_13333__$1;
(statearr_13375_13445[(2)] = null);

(statearr_13375_13445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (6))){
var inst_13265 = (state_13333[(29)]);
var inst_13264 = cljs.core.deref.call(null,cs);
var inst_13265__$1 = cljs.core.keys.call(null,inst_13264);
var inst_13266 = cljs.core.count.call(null,inst_13265__$1);
var inst_13267 = cljs.core.reset_BANG_.call(null,dctr,inst_13266);
var inst_13272 = cljs.core.seq.call(null,inst_13265__$1);
var inst_13273 = inst_13272;
var inst_13274 = null;
var inst_13275 = (0);
var inst_13276 = (0);
var state_13333__$1 = (function (){var statearr_13376 = state_13333;
(statearr_13376[(9)] = inst_13276);

(statearr_13376[(20)] = inst_13275);

(statearr_13376[(30)] = inst_13267);

(statearr_13376[(29)] = inst_13265__$1);

(statearr_13376[(11)] = inst_13274);

(statearr_13376[(21)] = inst_13273);

return statearr_13376;
})();
var statearr_13377_13446 = state_13333__$1;
(statearr_13377_13446[(2)] = null);

(statearr_13377_13446[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (28))){
var inst_13273 = (state_13333[(21)]);
var inst_13292 = (state_13333[(25)]);
var inst_13292__$1 = cljs.core.seq.call(null,inst_13273);
var state_13333__$1 = (function (){var statearr_13378 = state_13333;
(statearr_13378[(25)] = inst_13292__$1);

return statearr_13378;
})();
if(inst_13292__$1){
var statearr_13379_13447 = state_13333__$1;
(statearr_13379_13447[(1)] = (33));

} else {
var statearr_13380_13448 = state_13333__$1;
(statearr_13380_13448[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (25))){
var inst_13276 = (state_13333[(9)]);
var inst_13275 = (state_13333[(20)]);
var inst_13278 = (inst_13276 < inst_13275);
var inst_13279 = inst_13278;
var state_13333__$1 = state_13333;
if(cljs.core.truth_(inst_13279)){
var statearr_13381_13449 = state_13333__$1;
(statearr_13381_13449[(1)] = (27));

} else {
var statearr_13382_13450 = state_13333__$1;
(statearr_13382_13450[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (34))){
var state_13333__$1 = state_13333;
var statearr_13383_13451 = state_13333__$1;
(statearr_13383_13451[(2)] = null);

(statearr_13383_13451[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (17))){
var state_13333__$1 = state_13333;
var statearr_13384_13452 = state_13333__$1;
(statearr_13384_13452[(2)] = null);

(statearr_13384_13452[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (3))){
var inst_13331 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13333__$1,inst_13331);
} else {
if((state_val_13334 === (12))){
var inst_13260 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13385_13453 = state_13333__$1;
(statearr_13385_13453[(2)] = inst_13260);

(statearr_13385_13453[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (2))){
var state_13333__$1 = state_13333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13333__$1,(4),ch);
} else {
if((state_val_13334 === (23))){
var state_13333__$1 = state_13333;
var statearr_13386_13454 = state_13333__$1;
(statearr_13386_13454[(2)] = null);

(statearr_13386_13454[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (35))){
var inst_13315 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13387_13455 = state_13333__$1;
(statearr_13387_13455[(2)] = inst_13315);

(statearr_13387_13455[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (19))){
var inst_13234 = (state_13333[(7)]);
var inst_13238 = cljs.core.chunk_first.call(null,inst_13234);
var inst_13239 = cljs.core.chunk_rest.call(null,inst_13234);
var inst_13240 = cljs.core.count.call(null,inst_13238);
var inst_13214 = inst_13239;
var inst_13215 = inst_13238;
var inst_13216 = inst_13240;
var inst_13217 = (0);
var state_13333__$1 = (function (){var statearr_13388 = state_13333;
(statearr_13388[(13)] = inst_13216);

(statearr_13388[(15)] = inst_13215);

(statearr_13388[(16)] = inst_13217);

(statearr_13388[(17)] = inst_13214);

return statearr_13388;
})();
var statearr_13389_13456 = state_13333__$1;
(statearr_13389_13456[(2)] = null);

(statearr_13389_13456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (11))){
var inst_13234 = (state_13333[(7)]);
var inst_13214 = (state_13333[(17)]);
var inst_13234__$1 = cljs.core.seq.call(null,inst_13214);
var state_13333__$1 = (function (){var statearr_13390 = state_13333;
(statearr_13390[(7)] = inst_13234__$1);

return statearr_13390;
})();
if(inst_13234__$1){
var statearr_13391_13457 = state_13333__$1;
(statearr_13391_13457[(1)] = (16));

} else {
var statearr_13392_13458 = state_13333__$1;
(statearr_13392_13458[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (9))){
var inst_13262 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13393_13459 = state_13333__$1;
(statearr_13393_13459[(2)] = inst_13262);

(statearr_13393_13459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (5))){
var inst_13212 = cljs.core.deref.call(null,cs);
var inst_13213 = cljs.core.seq.call(null,inst_13212);
var inst_13214 = inst_13213;
var inst_13215 = null;
var inst_13216 = (0);
var inst_13217 = (0);
var state_13333__$1 = (function (){var statearr_13394 = state_13333;
(statearr_13394[(13)] = inst_13216);

(statearr_13394[(15)] = inst_13215);

(statearr_13394[(16)] = inst_13217);

(statearr_13394[(17)] = inst_13214);

return statearr_13394;
})();
var statearr_13395_13460 = state_13333__$1;
(statearr_13395_13460[(2)] = null);

(statearr_13395_13460[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (14))){
var state_13333__$1 = state_13333;
var statearr_13396_13461 = state_13333__$1;
(statearr_13396_13461[(2)] = null);

(statearr_13396_13461[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (45))){
var inst_13323 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13397_13462 = state_13333__$1;
(statearr_13397_13462[(2)] = inst_13323);

(statearr_13397_13462[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (26))){
var inst_13265 = (state_13333[(29)]);
var inst_13319 = (state_13333[(2)]);
var inst_13320 = cljs.core.seq.call(null,inst_13265);
var state_13333__$1 = (function (){var statearr_13398 = state_13333;
(statearr_13398[(31)] = inst_13319);

return statearr_13398;
})();
if(inst_13320){
var statearr_13399_13463 = state_13333__$1;
(statearr_13399_13463[(1)] = (42));

} else {
var statearr_13400_13464 = state_13333__$1;
(statearr_13400_13464[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (16))){
var inst_13234 = (state_13333[(7)]);
var inst_13236 = cljs.core.chunked_seq_QMARK_.call(null,inst_13234);
var state_13333__$1 = state_13333;
if(inst_13236){
var statearr_13401_13465 = state_13333__$1;
(statearr_13401_13465[(1)] = (19));

} else {
var statearr_13402_13466 = state_13333__$1;
(statearr_13402_13466[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (38))){
var inst_13312 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13403_13467 = state_13333__$1;
(statearr_13403_13467[(2)] = inst_13312);

(statearr_13403_13467[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (30))){
var state_13333__$1 = state_13333;
var statearr_13404_13468 = state_13333__$1;
(statearr_13404_13468[(2)] = null);

(statearr_13404_13468[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (10))){
var inst_13215 = (state_13333[(15)]);
var inst_13217 = (state_13333[(16)]);
var inst_13223 = cljs.core._nth.call(null,inst_13215,inst_13217);
var inst_13224 = cljs.core.nth.call(null,inst_13223,(0),null);
var inst_13225 = cljs.core.nth.call(null,inst_13223,(1),null);
var state_13333__$1 = (function (){var statearr_13405 = state_13333;
(statearr_13405[(26)] = inst_13224);

return statearr_13405;
})();
if(cljs.core.truth_(inst_13225)){
var statearr_13406_13469 = state_13333__$1;
(statearr_13406_13469[(1)] = (13));

} else {
var statearr_13407_13470 = state_13333__$1;
(statearr_13407_13470[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (18))){
var inst_13258 = (state_13333[(2)]);
var state_13333__$1 = state_13333;
var statearr_13408_13471 = state_13333__$1;
(statearr_13408_13471[(2)] = inst_13258);

(statearr_13408_13471[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (42))){
var state_13333__$1 = state_13333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13333__$1,(45),dchan);
} else {
if((state_val_13334 === (37))){
var inst_13301 = (state_13333[(23)]);
var inst_13205 = (state_13333[(12)]);
var inst_13292 = (state_13333[(25)]);
var inst_13301__$1 = cljs.core.first.call(null,inst_13292);
var inst_13302 = cljs.core.async.put_BANG_.call(null,inst_13301__$1,inst_13205,done);
var state_13333__$1 = (function (){var statearr_13409 = state_13333;
(statearr_13409[(23)] = inst_13301__$1);

return statearr_13409;
})();
if(cljs.core.truth_(inst_13302)){
var statearr_13410_13472 = state_13333__$1;
(statearr_13410_13472[(1)] = (39));

} else {
var statearr_13411_13473 = state_13333__$1;
(statearr_13411_13473[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13334 === (8))){
var inst_13216 = (state_13333[(13)]);
var inst_13217 = (state_13333[(16)]);
var inst_13219 = (inst_13217 < inst_13216);
var inst_13220 = inst_13219;
var state_13333__$1 = state_13333;
if(cljs.core.truth_(inst_13220)){
var statearr_13412_13474 = state_13333__$1;
(statearr_13412_13474[(1)] = (10));

} else {
var statearr_13413_13475 = state_13333__$1;
(statearr_13413_13475[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___13421,cs,m,dchan,dctr,done))
;
return ((function (switch__8163__auto__,c__8178__auto___13421,cs,m,dchan,dctr,done){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_13417 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13417[(0)] = state_machine__8164__auto__);

(statearr_13417[(1)] = (1));

return statearr_13417;
});
var state_machine__8164__auto____1 = (function (state_13333){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_13333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e13418){if((e13418 instanceof Object)){
var ex__8167__auto__ = e13418;
var statearr_13419_13476 = state_13333;
(statearr_13419_13476[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13418;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13477 = state_13333;
state_13333 = G__13477;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_13333){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_13333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___13421,cs,m,dchan,dctr,done))
})();
var state__8180__auto__ = (function (){var statearr_13420 = f__8179__auto__.call(null);
(statearr_13420[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___13421);

return statearr_13420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___13421,cs,m,dchan,dctr,done))
);


return m;
});
/**
* Copies the mult source onto the supplied channel.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.tap = (function() {
var tap = null;
var tap__2 = (function (mult,ch){
return tap.call(null,mult,ch,true);
});
var tap__3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});
tap = function(mult,ch,close_QMARK_){
switch(arguments.length){
case 2:
return tap__2.call(this,mult,ch);
case 3:
return tap__3.call(this,mult,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tap.cljs$core$IFn$_invoke$arity$2 = tap__2;
tap.cljs$core$IFn$_invoke$arity$3 = tap__3;
return tap;
})()
;
/**
* Disconnects a target channel from a mult
*/
cljs.core.async.untap = (function untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
* Disconnects all target channels from a mult
*/
cljs.core.async.untap_all = (function untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj13479 = {};
return obj13479;
})();

cljs.core.async.admix_STAR_ = (function admix_STAR_(m,ch){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function unmix_STAR_(m,ch){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function unmix_all_STAR_(m){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function toggle_STAR_(m,state_map){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function solo_mode_STAR_(m,mode){
if((function (){var and__3746__auto__ = m;
if(and__3746__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4402__auto__ = (((m == null))?null:m);
return (function (){var or__3758__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

/**
* @param {...*} var_args
*/
cljs.core.async.ioc_alts_BANG_ = (function() { 
var ioc_alts_BANG___delegate = function (state,cont_block,ports,p__13480){
var map__13485 = p__13480;
var map__13485__$1 = ((cljs.core.seq_QMARK_.call(null,map__13485))?cljs.core.apply.call(null,cljs.core.hash_map,map__13485):map__13485);
var opts = map__13485__$1;
var statearr_13486_13489 = state;
(statearr_13486_13489[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__13485,map__13485__$1,opts){
return (function (val){
var statearr_13487_13490 = state;
(statearr_13487_13490[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13485,map__13485__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_13488_13491 = state;
(statearr_13488_13491[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
};
var ioc_alts_BANG_ = function (state,cont_block,ports,var_args){
var p__13480 = null;
if (arguments.length > 3) {
var G__13492__i = 0, G__13492__a = new Array(arguments.length -  3);
while (G__13492__i < G__13492__a.length) {G__13492__a[G__13492__i] = arguments[G__13492__i + 3]; ++G__13492__i;}
  p__13480 = new cljs.core.IndexedSeq(G__13492__a,0);
} 
return ioc_alts_BANG___delegate.call(this,state,cont_block,ports,p__13480);};
ioc_alts_BANG_.cljs$lang$maxFixedArity = 3;
ioc_alts_BANG_.cljs$lang$applyTo = (function (arglist__13493){
var state = cljs.core.first(arglist__13493);
arglist__13493 = cljs.core.next(arglist__13493);
var cont_block = cljs.core.first(arglist__13493);
arglist__13493 = cljs.core.next(arglist__13493);
var ports = cljs.core.first(arglist__13493);
var p__13480 = cljs.core.rest(arglist__13493);
return ioc_alts_BANG___delegate(state,cont_block,ports,p__13480);
});
ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = ioc_alts_BANG___delegate;
return ioc_alts_BANG_;
})()
;
/**
* Creates and returns a mix of one or more input channels which will
* be put on the supplied out channel. Input sources can be added to
* the mix with 'admix', and removed with 'unmix'. A mix supports
* soloing, muting and pausing multiple inputs atomically using
* 'toggle', and can solo using either muting or pausing as determined
* by 'solo-mode'.
* 
* Each channel can have zero or more boolean modes set via 'toggle':
* 
* :solo - when true, only this (ond other soloed) channel(s) will appear
* in the mix output channel. :mute and :pause states of soloed
* channels are ignored. If solo-mode is :mute, non-soloed
* channels are muted, if :pause, non-soloed channels are
* paused.
* 
* :mute - muted channels will have their contents consumed but not included in the mix
* :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
*/
cljs.core.async.mix = (function mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t13613 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13613 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13614){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13614 = meta13614;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13613.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t13613.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13613.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13615){
var self__ = this;
var _13615__$1 = this;
return self__.meta13614;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13615,meta13614__$1){
var self__ = this;
var _13615__$1 = this;
return (new cljs.core.async.t13613(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13614__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13613.cljs$lang$type = true;

cljs.core.async.t13613.cljs$lang$ctorStr = "cljs.core.async/t13613";

cljs.core.async.t13613.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t13613");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t13613 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function __GT_t13613(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13614){
return (new cljs.core.async.t13613(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13614));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t13613(change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),25,new cljs.core.Keyword(null,"end-line","end-line",1837326455),510,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"line","line",212345235),499,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
})()
;
var c__8178__auto___13732 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___13732,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___13732,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13685){
var state_val_13686 = (state_13685[(1)]);
if((state_val_13686 === (7))){
var inst_13629 = (state_13685[(7)]);
var inst_13634 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13629);
var state_13685__$1 = state_13685;
var statearr_13687_13733 = state_13685__$1;
(statearr_13687_13733[(2)] = inst_13634);

(statearr_13687_13733[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (20))){
var inst_13644 = (state_13685[(8)]);
var state_13685__$1 = state_13685;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13685__$1,(23),out,inst_13644);
} else {
if((state_val_13686 === (1))){
var inst_13619 = (state_13685[(9)]);
var inst_13619__$1 = calc_state.call(null);
var inst_13620 = cljs.core.seq_QMARK_.call(null,inst_13619__$1);
var state_13685__$1 = (function (){var statearr_13688 = state_13685;
(statearr_13688[(9)] = inst_13619__$1);

return statearr_13688;
})();
if(inst_13620){
var statearr_13689_13734 = state_13685__$1;
(statearr_13689_13734[(1)] = (2));

} else {
var statearr_13690_13735 = state_13685__$1;
(statearr_13690_13735[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (24))){
var inst_13637 = (state_13685[(10)]);
var inst_13629 = inst_13637;
var state_13685__$1 = (function (){var statearr_13691 = state_13685;
(statearr_13691[(7)] = inst_13629);

return statearr_13691;
})();
var statearr_13692_13736 = state_13685__$1;
(statearr_13692_13736[(2)] = null);

(statearr_13692_13736[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (4))){
var inst_13619 = (state_13685[(9)]);
var inst_13625 = (state_13685[(2)]);
var inst_13626 = cljs.core.get.call(null,inst_13625,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13627 = cljs.core.get.call(null,inst_13625,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13628 = cljs.core.get.call(null,inst_13625,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13629 = inst_13619;
var state_13685__$1 = (function (){var statearr_13693 = state_13685;
(statearr_13693[(11)] = inst_13628);

(statearr_13693[(7)] = inst_13629);

(statearr_13693[(12)] = inst_13626);

(statearr_13693[(13)] = inst_13627);

return statearr_13693;
})();
var statearr_13694_13737 = state_13685__$1;
(statearr_13694_13737[(2)] = null);

(statearr_13694_13737[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (15))){
var state_13685__$1 = state_13685;
var statearr_13695_13738 = state_13685__$1;
(statearr_13695_13738[(2)] = null);

(statearr_13695_13738[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (21))){
var inst_13637 = (state_13685[(10)]);
var inst_13629 = inst_13637;
var state_13685__$1 = (function (){var statearr_13696 = state_13685;
(statearr_13696[(7)] = inst_13629);

return statearr_13696;
})();
var statearr_13697_13739 = state_13685__$1;
(statearr_13697_13739[(2)] = null);

(statearr_13697_13739[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (13))){
var inst_13681 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
var statearr_13698_13740 = state_13685__$1;
(statearr_13698_13740[(2)] = inst_13681);

(statearr_13698_13740[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (22))){
var inst_13679 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
var statearr_13699_13741 = state_13685__$1;
(statearr_13699_13741[(2)] = inst_13679);

(statearr_13699_13741[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (6))){
var inst_13683 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13685__$1,inst_13683);
} else {
if((state_val_13686 === (25))){
var state_13685__$1 = state_13685;
var statearr_13700_13742 = state_13685__$1;
(statearr_13700_13742[(2)] = null);

(statearr_13700_13742[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (17))){
var inst_13659 = (state_13685[(14)]);
var state_13685__$1 = state_13685;
var statearr_13701_13743 = state_13685__$1;
(statearr_13701_13743[(2)] = inst_13659);

(statearr_13701_13743[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (3))){
var inst_13619 = (state_13685[(9)]);
var state_13685__$1 = state_13685;
var statearr_13702_13744 = state_13685__$1;
(statearr_13702_13744[(2)] = inst_13619);

(statearr_13702_13744[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (12))){
var inst_13645 = (state_13685[(15)]);
var inst_13659 = (state_13685[(14)]);
var inst_13640 = (state_13685[(16)]);
var inst_13659__$1 = inst_13640.call(null,inst_13645);
var state_13685__$1 = (function (){var statearr_13703 = state_13685;
(statearr_13703[(14)] = inst_13659__$1);

return statearr_13703;
})();
if(cljs.core.truth_(inst_13659__$1)){
var statearr_13704_13745 = state_13685__$1;
(statearr_13704_13745[(1)] = (17));

} else {
var statearr_13705_13746 = state_13685__$1;
(statearr_13705_13746[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (2))){
var inst_13619 = (state_13685[(9)]);
var inst_13622 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13619);
var state_13685__$1 = state_13685;
var statearr_13706_13747 = state_13685__$1;
(statearr_13706_13747[(2)] = inst_13622);

(statearr_13706_13747[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (23))){
var inst_13670 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
if(cljs.core.truth_(inst_13670)){
var statearr_13707_13748 = state_13685__$1;
(statearr_13707_13748[(1)] = (24));

} else {
var statearr_13708_13749 = state_13685__$1;
(statearr_13708_13749[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (19))){
var inst_13667 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
if(cljs.core.truth_(inst_13667)){
var statearr_13709_13750 = state_13685__$1;
(statearr_13709_13750[(1)] = (20));

} else {
var statearr_13710_13751 = state_13685__$1;
(statearr_13710_13751[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (11))){
var inst_13644 = (state_13685[(8)]);
var inst_13650 = (inst_13644 == null);
var state_13685__$1 = state_13685;
if(cljs.core.truth_(inst_13650)){
var statearr_13711_13752 = state_13685__$1;
(statearr_13711_13752[(1)] = (14));

} else {
var statearr_13712_13753 = state_13685__$1;
(statearr_13712_13753[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (9))){
var inst_13637 = (state_13685[(10)]);
var inst_13637__$1 = (state_13685[(2)]);
var inst_13638 = cljs.core.get.call(null,inst_13637__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13639 = cljs.core.get.call(null,inst_13637__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13640 = cljs.core.get.call(null,inst_13637__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var state_13685__$1 = (function (){var statearr_13713 = state_13685;
(statearr_13713[(16)] = inst_13640);

(statearr_13713[(10)] = inst_13637__$1);

(statearr_13713[(17)] = inst_13639);

return statearr_13713;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13685__$1,(10),inst_13638);
} else {
if((state_val_13686 === (5))){
var inst_13629 = (state_13685[(7)]);
var inst_13632 = cljs.core.seq_QMARK_.call(null,inst_13629);
var state_13685__$1 = state_13685;
if(inst_13632){
var statearr_13714_13754 = state_13685__$1;
(statearr_13714_13754[(1)] = (7));

} else {
var statearr_13715_13755 = state_13685__$1;
(statearr_13715_13755[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (14))){
var inst_13645 = (state_13685[(15)]);
var inst_13652 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13645);
var state_13685__$1 = state_13685;
var statearr_13716_13756 = state_13685__$1;
(statearr_13716_13756[(2)] = inst_13652);

(statearr_13716_13756[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (26))){
var inst_13675 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
var statearr_13717_13757 = state_13685__$1;
(statearr_13717_13757[(2)] = inst_13675);

(statearr_13717_13757[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (16))){
var inst_13655 = (state_13685[(2)]);
var inst_13656 = calc_state.call(null);
var inst_13629 = inst_13656;
var state_13685__$1 = (function (){var statearr_13718 = state_13685;
(statearr_13718[(18)] = inst_13655);

(statearr_13718[(7)] = inst_13629);

return statearr_13718;
})();
var statearr_13719_13758 = state_13685__$1;
(statearr_13719_13758[(2)] = null);

(statearr_13719_13758[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (10))){
var inst_13645 = (state_13685[(15)]);
var inst_13644 = (state_13685[(8)]);
var inst_13643 = (state_13685[(2)]);
var inst_13644__$1 = cljs.core.nth.call(null,inst_13643,(0),null);
var inst_13645__$1 = cljs.core.nth.call(null,inst_13643,(1),null);
var inst_13646 = (inst_13644__$1 == null);
var inst_13647 = cljs.core._EQ_.call(null,inst_13645__$1,change);
var inst_13648 = (inst_13646) || (inst_13647);
var state_13685__$1 = (function (){var statearr_13720 = state_13685;
(statearr_13720[(15)] = inst_13645__$1);

(statearr_13720[(8)] = inst_13644__$1);

return statearr_13720;
})();
if(cljs.core.truth_(inst_13648)){
var statearr_13721_13759 = state_13685__$1;
(statearr_13721_13759[(1)] = (11));

} else {
var statearr_13722_13760 = state_13685__$1;
(statearr_13722_13760[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (18))){
var inst_13645 = (state_13685[(15)]);
var inst_13640 = (state_13685[(16)]);
var inst_13639 = (state_13685[(17)]);
var inst_13662 = cljs.core.empty_QMARK_.call(null,inst_13640);
var inst_13663 = inst_13639.call(null,inst_13645);
var inst_13664 = cljs.core.not.call(null,inst_13663);
var inst_13665 = (inst_13662) && (inst_13664);
var state_13685__$1 = state_13685;
var statearr_13723_13761 = state_13685__$1;
(statearr_13723_13761[(2)] = inst_13665);

(statearr_13723_13761[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (8))){
var inst_13629 = (state_13685[(7)]);
var state_13685__$1 = state_13685;
var statearr_13724_13762 = state_13685__$1;
(statearr_13724_13762[(2)] = inst_13629);

(statearr_13724_13762[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___13732,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8163__auto__,c__8178__auto___13732,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_13728 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13728[(0)] = state_machine__8164__auto__);

(statearr_13728[(1)] = (1));

return statearr_13728;
});
var state_machine__8164__auto____1 = (function (state_13685){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_13685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e13729){if((e13729 instanceof Object)){
var ex__8167__auto__ = e13729;
var statearr_13730_13763 = state_13685;
(statearr_13730_13763[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13729;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13764 = state_13685;
state_13685 = G__13764;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_13685){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_13685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___13732,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8180__auto__ = (function (){var statearr_13731 = f__8179__auto__.call(null);
(statearr_13731[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___13732);

return statearr_13731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___13732,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
* Adds ch as an input to the mix
*/
cljs.core.async.admix = (function admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
* Removes ch as an input to the mix
*/
cljs.core.async.unmix = (function unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
* removes all inputs from the mix
*/
cljs.core.async.unmix_all = (function unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
* Atomically sets the state(s) of one or more channels in a mix. The
* state map is a map of channels -> channel-state-map. A
* channel-state-map is a map of attrs -> boolean, where attr is one or
* more of :mute, :pause or :solo. Any states supplied are merged with
* the current state.
* 
* Note that channels can be added to a mix via toggle, which can be
* used to add channels in a particular (e.g. paused) state.
*/
cljs.core.async.toggle = (function toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
* Sets the solo mode of the mix. mode must be one of :mute or :pause
*/
cljs.core.async.solo_mode = (function solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj13766 = {};
return obj13766;
})();

cljs.core.async.sub_STAR_ = (function sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__3746__auto__ = p;
if(and__3746__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__3746__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4402__auto__ = (((p == null))?null:p);
return (function (){var or__3758__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function unsub_STAR_(p,v,ch){
if((function (){var and__3746__auto__ = p;
if(and__3746__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__3746__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4402__auto__ = (((p == null))?null:p);
return (function (){var or__3758__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function() {
var unsub_all_STAR_ = null;
var unsub_all_STAR___1 = (function (p){
if((function (){var and__3746__auto__ = p;
if(and__3746__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__3746__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4402__auto__ = (((p == null))?null:p);
return (function (){var or__3758__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});
var unsub_all_STAR___2 = (function (p,v){
if((function (){var and__3746__auto__ = p;
if(and__3746__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__3746__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4402__auto__ = (((p == null))?null:p);
return (function (){var or__3758__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4402__auto__)]);
if(or__3758__auto__){
return or__3758__auto__;
} else {
var or__3758__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__3758__auto____$1){
return or__3758__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});
unsub_all_STAR_ = function(p,v){
switch(arguments.length){
case 1:
return unsub_all_STAR___1.call(this,p);
case 2:
return unsub_all_STAR___2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = unsub_all_STAR___1;
unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = unsub_all_STAR___2;
return unsub_all_STAR_;
})()
;

/**
* Creates and returns a pub(lication) of the supplied channel,
* partitioned into topics by the topic-fn. topic-fn will be applied to
* each value on the channel and the result will determine the 'topic'
* on which that value will be put. Channels can be subscribed to
* receive copies of topics using 'sub', and unsubscribed using
* 'unsub'. Each topic will be handled by an internal mult on a
* dedicated channel. By default these internal channels are
* unbuffered, but a buf-fn can be supplied which, given a topic,
* creates a buffer with desired properties.
* 
* Each item is distributed to all subs in parallel and synchronously,
* i.e. each sub must accept before the next item is distributed. Use
* buffering/windowing to prevent slow subs from holding up the pub.
* 
* Items received when there are no matching subs get dropped.
* 
* Note that if buf-fns are used then each topic is handled
* asynchronously, i.e. if a channel is subscribed to more than one
* topic it should not expect them to be interleaved identically with
* the source.
*/
cljs.core.async.pub = (function() {
var pub = null;
var pub__2 = (function (ch,topic_fn){
return pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});
var pub__3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3758__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3758__auto__,mults){
return (function (p1__13767_SHARP_){
if(cljs.core.truth_(p1__13767_SHARP_.call(null,topic))){
return p1__13767_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13767_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3758__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t13890 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13890 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,pub,meta13891){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.pub = pub;
this.meta13891 = meta13891;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13890.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t13890.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t13890.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t13890.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t13890.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t13890.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13890.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t13890.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13892){
var self__ = this;
var _13892__$1 = this;
return self__.meta13891;
});})(mults,ensure_mult))
;

cljs.core.async.t13890.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13892,meta13891__$1){
var self__ = this;
var _13892__$1 = this;
return (new cljs.core.async.t13890(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,self__.pub,meta13891__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t13890.cljs$lang$type = true;

cljs.core.async.t13890.cljs$lang$ctorStr = "cljs.core.async/t13890";

cljs.core.async.t13890.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t13890");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t13890 = ((function (mults,ensure_mult){
return (function __GT_t13890(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta13891){
return (new cljs.core.async.t13890(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,pub__$1,meta13891));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t13890(ensure_mult,mults,buf_fn,topic_fn,ch,pub,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),65,new cljs.core.Keyword(null,"end-line","end-line",1837326455),603,new cljs.core.Keyword(null,"column","column",2078222095),14,new cljs.core.Keyword(null,"line","line",212345235),591,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
})()
;
var c__8178__auto___14012 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___14012,mults,ensure_mult,p){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___14012,mults,ensure_mult,p){
return (function (state_13964){
var state_val_13965 = (state_13964[(1)]);
if((state_val_13965 === (7))){
var inst_13960 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
var statearr_13966_14013 = state_13964__$1;
(statearr_13966_14013[(2)] = inst_13960);

(statearr_13966_14013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (20))){
var state_13964__$1 = state_13964;
var statearr_13967_14014 = state_13964__$1;
(statearr_13967_14014[(2)] = null);

(statearr_13967_14014[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (1))){
var state_13964__$1 = state_13964;
var statearr_13968_14015 = state_13964__$1;
(statearr_13968_14015[(2)] = null);

(statearr_13968_14015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (24))){
var inst_13943 = (state_13964[(7)]);
var inst_13952 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_13943);
var state_13964__$1 = state_13964;
var statearr_13969_14016 = state_13964__$1;
(statearr_13969_14016[(2)] = inst_13952);

(statearr_13969_14016[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (4))){
var inst_13895 = (state_13964[(8)]);
var inst_13895__$1 = (state_13964[(2)]);
var inst_13896 = (inst_13895__$1 == null);
var state_13964__$1 = (function (){var statearr_13970 = state_13964;
(statearr_13970[(8)] = inst_13895__$1);

return statearr_13970;
})();
if(cljs.core.truth_(inst_13896)){
var statearr_13971_14017 = state_13964__$1;
(statearr_13971_14017[(1)] = (5));

} else {
var statearr_13972_14018 = state_13964__$1;
(statearr_13972_14018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (15))){
var inst_13937 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
var statearr_13973_14019 = state_13964__$1;
(statearr_13973_14019[(2)] = inst_13937);

(statearr_13973_14019[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (21))){
var inst_13957 = (state_13964[(2)]);
var state_13964__$1 = (function (){var statearr_13974 = state_13964;
(statearr_13974[(9)] = inst_13957);

return statearr_13974;
})();
var statearr_13975_14020 = state_13964__$1;
(statearr_13975_14020[(2)] = null);

(statearr_13975_14020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (13))){
var inst_13919 = (state_13964[(10)]);
var inst_13921 = cljs.core.chunked_seq_QMARK_.call(null,inst_13919);
var state_13964__$1 = state_13964;
if(inst_13921){
var statearr_13976_14021 = state_13964__$1;
(statearr_13976_14021[(1)] = (16));

} else {
var statearr_13977_14022 = state_13964__$1;
(statearr_13977_14022[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (22))){
var inst_13949 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
if(cljs.core.truth_(inst_13949)){
var statearr_13978_14023 = state_13964__$1;
(statearr_13978_14023[(1)] = (23));

} else {
var statearr_13979_14024 = state_13964__$1;
(statearr_13979_14024[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (6))){
var inst_13945 = (state_13964[(11)]);
var inst_13895 = (state_13964[(8)]);
var inst_13943 = (state_13964[(7)]);
var inst_13943__$1 = topic_fn.call(null,inst_13895);
var inst_13944 = cljs.core.deref.call(null,mults);
var inst_13945__$1 = cljs.core.get.call(null,inst_13944,inst_13943__$1);
var state_13964__$1 = (function (){var statearr_13980 = state_13964;
(statearr_13980[(11)] = inst_13945__$1);

(statearr_13980[(7)] = inst_13943__$1);

return statearr_13980;
})();
if(cljs.core.truth_(inst_13945__$1)){
var statearr_13981_14025 = state_13964__$1;
(statearr_13981_14025[(1)] = (19));

} else {
var statearr_13982_14026 = state_13964__$1;
(statearr_13982_14026[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (25))){
var inst_13954 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
var statearr_13983_14027 = state_13964__$1;
(statearr_13983_14027[(2)] = inst_13954);

(statearr_13983_14027[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (17))){
var inst_13919 = (state_13964[(10)]);
var inst_13928 = cljs.core.first.call(null,inst_13919);
var inst_13929 = cljs.core.async.muxch_STAR_.call(null,inst_13928);
var inst_13930 = cljs.core.async.close_BANG_.call(null,inst_13929);
var inst_13931 = cljs.core.next.call(null,inst_13919);
var inst_13905 = inst_13931;
var inst_13906 = null;
var inst_13907 = (0);
var inst_13908 = (0);
var state_13964__$1 = (function (){var statearr_13984 = state_13964;
(statearr_13984[(12)] = inst_13906);

(statearr_13984[(13)] = inst_13905);

(statearr_13984[(14)] = inst_13930);

(statearr_13984[(15)] = inst_13908);

(statearr_13984[(16)] = inst_13907);

return statearr_13984;
})();
var statearr_13985_14028 = state_13964__$1;
(statearr_13985_14028[(2)] = null);

(statearr_13985_14028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (3))){
var inst_13962 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13964__$1,inst_13962);
} else {
if((state_val_13965 === (12))){
var inst_13939 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
var statearr_13986_14029 = state_13964__$1;
(statearr_13986_14029[(2)] = inst_13939);

(statearr_13986_14029[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (2))){
var state_13964__$1 = state_13964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13964__$1,(4),ch);
} else {
if((state_val_13965 === (23))){
var state_13964__$1 = state_13964;
var statearr_13987_14030 = state_13964__$1;
(statearr_13987_14030[(2)] = null);

(statearr_13987_14030[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (19))){
var inst_13945 = (state_13964[(11)]);
var inst_13895 = (state_13964[(8)]);
var inst_13947 = cljs.core.async.muxch_STAR_.call(null,inst_13945);
var state_13964__$1 = state_13964;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13964__$1,(22),inst_13947,inst_13895);
} else {
if((state_val_13965 === (11))){
var inst_13905 = (state_13964[(13)]);
var inst_13919 = (state_13964[(10)]);
var inst_13919__$1 = cljs.core.seq.call(null,inst_13905);
var state_13964__$1 = (function (){var statearr_13988 = state_13964;
(statearr_13988[(10)] = inst_13919__$1);

return statearr_13988;
})();
if(inst_13919__$1){
var statearr_13989_14031 = state_13964__$1;
(statearr_13989_14031[(1)] = (13));

} else {
var statearr_13990_14032 = state_13964__$1;
(statearr_13990_14032[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (9))){
var inst_13941 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
var statearr_13991_14033 = state_13964__$1;
(statearr_13991_14033[(2)] = inst_13941);

(statearr_13991_14033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (5))){
var inst_13902 = cljs.core.deref.call(null,mults);
var inst_13903 = cljs.core.vals.call(null,inst_13902);
var inst_13904 = cljs.core.seq.call(null,inst_13903);
var inst_13905 = inst_13904;
var inst_13906 = null;
var inst_13907 = (0);
var inst_13908 = (0);
var state_13964__$1 = (function (){var statearr_13992 = state_13964;
(statearr_13992[(12)] = inst_13906);

(statearr_13992[(13)] = inst_13905);

(statearr_13992[(15)] = inst_13908);

(statearr_13992[(16)] = inst_13907);

return statearr_13992;
})();
var statearr_13993_14034 = state_13964__$1;
(statearr_13993_14034[(2)] = null);

(statearr_13993_14034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (14))){
var state_13964__$1 = state_13964;
var statearr_13997_14035 = state_13964__$1;
(statearr_13997_14035[(2)] = null);

(statearr_13997_14035[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (16))){
var inst_13919 = (state_13964[(10)]);
var inst_13923 = cljs.core.chunk_first.call(null,inst_13919);
var inst_13924 = cljs.core.chunk_rest.call(null,inst_13919);
var inst_13925 = cljs.core.count.call(null,inst_13923);
var inst_13905 = inst_13924;
var inst_13906 = inst_13923;
var inst_13907 = inst_13925;
var inst_13908 = (0);
var state_13964__$1 = (function (){var statearr_13998 = state_13964;
(statearr_13998[(12)] = inst_13906);

(statearr_13998[(13)] = inst_13905);

(statearr_13998[(15)] = inst_13908);

(statearr_13998[(16)] = inst_13907);

return statearr_13998;
})();
var statearr_13999_14036 = state_13964__$1;
(statearr_13999_14036[(2)] = null);

(statearr_13999_14036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (10))){
var inst_13906 = (state_13964[(12)]);
var inst_13905 = (state_13964[(13)]);
var inst_13908 = (state_13964[(15)]);
var inst_13907 = (state_13964[(16)]);
var inst_13913 = cljs.core._nth.call(null,inst_13906,inst_13908);
var inst_13914 = cljs.core.async.muxch_STAR_.call(null,inst_13913);
var inst_13915 = cljs.core.async.close_BANG_.call(null,inst_13914);
var inst_13916 = (inst_13908 + (1));
var tmp13994 = inst_13906;
var tmp13995 = inst_13905;
var tmp13996 = inst_13907;
var inst_13905__$1 = tmp13995;
var inst_13906__$1 = tmp13994;
var inst_13907__$1 = tmp13996;
var inst_13908__$1 = inst_13916;
var state_13964__$1 = (function (){var statearr_14000 = state_13964;
(statearr_14000[(12)] = inst_13906__$1);

(statearr_14000[(13)] = inst_13905__$1);

(statearr_14000[(17)] = inst_13915);

(statearr_14000[(15)] = inst_13908__$1);

(statearr_14000[(16)] = inst_13907__$1);

return statearr_14000;
})();
var statearr_14001_14037 = state_13964__$1;
(statearr_14001_14037[(2)] = null);

(statearr_14001_14037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (18))){
var inst_13934 = (state_13964[(2)]);
var state_13964__$1 = state_13964;
var statearr_14002_14038 = state_13964__$1;
(statearr_14002_14038[(2)] = inst_13934);

(statearr_14002_14038[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13965 === (8))){
var inst_13908 = (state_13964[(15)]);
var inst_13907 = (state_13964[(16)]);
var inst_13910 = (inst_13908 < inst_13907);
var inst_13911 = inst_13910;
var state_13964__$1 = state_13964;
if(cljs.core.truth_(inst_13911)){
var statearr_14003_14039 = state_13964__$1;
(statearr_14003_14039[(1)] = (10));

} else {
var statearr_14004_14040 = state_13964__$1;
(statearr_14004_14040[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___14012,mults,ensure_mult,p))
;
return ((function (switch__8163__auto__,c__8178__auto___14012,mults,ensure_mult,p){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_14008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14008[(0)] = state_machine__8164__auto__);

(statearr_14008[(1)] = (1));

return statearr_14008;
});
var state_machine__8164__auto____1 = (function (state_13964){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_13964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e14009){if((e14009 instanceof Object)){
var ex__8167__auto__ = e14009;
var statearr_14010_14041 = state_13964;
(statearr_14010_14041[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13964);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14042 = state_13964;
state_13964 = G__14042;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_13964){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_13964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___14012,mults,ensure_mult,p))
})();
var state__8180__auto__ = (function (){var statearr_14011 = f__8179__auto__.call(null);
(statearr_14011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___14012);

return statearr_14011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___14012,mults,ensure_mult,p))
);


return p;
});
pub = function(ch,topic_fn,buf_fn){
switch(arguments.length){
case 2:
return pub__2.call(this,ch,topic_fn);
case 3:
return pub__3.call(this,ch,topic_fn,buf_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
pub.cljs$core$IFn$_invoke$arity$2 = pub__2;
pub.cljs$core$IFn$_invoke$arity$3 = pub__3;
return pub;
})()
;
/**
* Subscribes a channel to a topic of a pub.
* 
* By default the channel will be closed when the source closes,
* but can be determined by the close? parameter.
*/
cljs.core.async.sub = (function() {
var sub = null;
var sub__3 = (function (p,topic,ch){
return sub.call(null,p,topic,ch,true);
});
var sub__4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});
sub = function(p,topic,ch,close_QMARK_){
switch(arguments.length){
case 3:
return sub__3.call(this,p,topic,ch);
case 4:
return sub__4.call(this,p,topic,ch,close_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub.cljs$core$IFn$_invoke$arity$3 = sub__3;
sub.cljs$core$IFn$_invoke$arity$4 = sub__4;
return sub;
})()
;
/**
* Unsubscribes a channel from a topic of a pub
*/
cljs.core.async.unsub = (function unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
* Unsubscribes all channels from a pub, or a topic of a pub
*/
cljs.core.async.unsub_all = (function() {
var unsub_all = null;
var unsub_all__1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});
var unsub_all__2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});
unsub_all = function(p,topic){
switch(arguments.length){
case 1:
return unsub_all__1.call(this,p);
case 2:
return unsub_all__2.call(this,p,topic);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unsub_all.cljs$core$IFn$_invoke$arity$1 = unsub_all__1;
unsub_all.cljs$core$IFn$_invoke$arity$2 = unsub_all__2;
return unsub_all;
})()
;
/**
* Takes a function and a collection of source channels, and returns a
* channel which contains the values produced by applying f to the set
* of first items taken from each source channel, followed by applying
* f to the set of second items from each channel, until any one of the
* channels is closed, at which point the output channel will be
* closed. The returned channel will be unbuffered by default, or a
* buf-or-n can be supplied
*/
cljs.core.async.map = (function() {
var map = null;
var map__2 = (function (f,chs){
return map.call(null,f,chs,null);
});
var map__3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8178__auto___14179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___14179,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___14179,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14149){
var state_val_14150 = (state_14149[(1)]);
if((state_val_14150 === (7))){
var state_14149__$1 = state_14149;
var statearr_14151_14180 = state_14149__$1;
(statearr_14151_14180[(2)] = null);

(statearr_14151_14180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (1))){
var state_14149__$1 = state_14149;
var statearr_14152_14181 = state_14149__$1;
(statearr_14152_14181[(2)] = null);

(statearr_14152_14181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (4))){
var inst_14113 = (state_14149[(7)]);
var inst_14115 = (inst_14113 < cnt);
var state_14149__$1 = state_14149;
if(cljs.core.truth_(inst_14115)){
var statearr_14153_14182 = state_14149__$1;
(statearr_14153_14182[(1)] = (6));

} else {
var statearr_14154_14183 = state_14149__$1;
(statearr_14154_14183[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (15))){
var inst_14145 = (state_14149[(2)]);
var state_14149__$1 = state_14149;
var statearr_14155_14184 = state_14149__$1;
(statearr_14155_14184[(2)] = inst_14145);

(statearr_14155_14184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (13))){
var inst_14138 = cljs.core.async.close_BANG_.call(null,out);
var state_14149__$1 = state_14149;
var statearr_14156_14185 = state_14149__$1;
(statearr_14156_14185[(2)] = inst_14138);

(statearr_14156_14185[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (6))){
var state_14149__$1 = state_14149;
var statearr_14157_14186 = state_14149__$1;
(statearr_14157_14186[(2)] = null);

(statearr_14157_14186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (3))){
var inst_14147 = (state_14149[(2)]);
var state_14149__$1 = state_14149;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14149__$1,inst_14147);
} else {
if((state_val_14150 === (12))){
var inst_14135 = (state_14149[(8)]);
var inst_14135__$1 = (state_14149[(2)]);
var inst_14136 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14135__$1);
var state_14149__$1 = (function (){var statearr_14158 = state_14149;
(statearr_14158[(8)] = inst_14135__$1);

return statearr_14158;
})();
if(cljs.core.truth_(inst_14136)){
var statearr_14159_14187 = state_14149__$1;
(statearr_14159_14187[(1)] = (13));

} else {
var statearr_14160_14188 = state_14149__$1;
(statearr_14160_14188[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (2))){
var inst_14112 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14113 = (0);
var state_14149__$1 = (function (){var statearr_14161 = state_14149;
(statearr_14161[(9)] = inst_14112);

(statearr_14161[(7)] = inst_14113);

return statearr_14161;
})();
var statearr_14162_14189 = state_14149__$1;
(statearr_14162_14189[(2)] = null);

(statearr_14162_14189[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (11))){
var inst_14113 = (state_14149[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14149,(10),Object,null,(9));
var inst_14122 = chs__$1.call(null,inst_14113);
var inst_14123 = done.call(null,inst_14113);
var inst_14124 = cljs.core.async.take_BANG_.call(null,inst_14122,inst_14123);
var state_14149__$1 = state_14149;
var statearr_14163_14190 = state_14149__$1;
(statearr_14163_14190[(2)] = inst_14124);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14149__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (9))){
var inst_14113 = (state_14149[(7)]);
var inst_14126 = (state_14149[(2)]);
var inst_14127 = (inst_14113 + (1));
var inst_14113__$1 = inst_14127;
var state_14149__$1 = (function (){var statearr_14164 = state_14149;
(statearr_14164[(10)] = inst_14126);

(statearr_14164[(7)] = inst_14113__$1);

return statearr_14164;
})();
var statearr_14165_14191 = state_14149__$1;
(statearr_14165_14191[(2)] = null);

(statearr_14165_14191[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (5))){
var inst_14133 = (state_14149[(2)]);
var state_14149__$1 = (function (){var statearr_14166 = state_14149;
(statearr_14166[(11)] = inst_14133);

return statearr_14166;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14149__$1,(12),dchan);
} else {
if((state_val_14150 === (14))){
var inst_14135 = (state_14149[(8)]);
var inst_14140 = cljs.core.apply.call(null,f,inst_14135);
var state_14149__$1 = state_14149;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14149__$1,(16),out,inst_14140);
} else {
if((state_val_14150 === (16))){
var inst_14142 = (state_14149[(2)]);
var state_14149__$1 = (function (){var statearr_14167 = state_14149;
(statearr_14167[(12)] = inst_14142);

return statearr_14167;
})();
var statearr_14168_14192 = state_14149__$1;
(statearr_14168_14192[(2)] = null);

(statearr_14168_14192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (10))){
var inst_14117 = (state_14149[(2)]);
var inst_14118 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14149__$1 = (function (){var statearr_14169 = state_14149;
(statearr_14169[(13)] = inst_14117);

return statearr_14169;
})();
var statearr_14170_14193 = state_14149__$1;
(statearr_14170_14193[(2)] = inst_14118);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14149__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14150 === (8))){
var inst_14131 = (state_14149[(2)]);
var state_14149__$1 = state_14149;
var statearr_14171_14194 = state_14149__$1;
(statearr_14171_14194[(2)] = inst_14131);

(statearr_14171_14194[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___14179,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8163__auto__,c__8178__auto___14179,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_14175 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14175[(0)] = state_machine__8164__auto__);

(statearr_14175[(1)] = (1));

return statearr_14175;
});
var state_machine__8164__auto____1 = (function (state_14149){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_14149);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e14176){if((e14176 instanceof Object)){
var ex__8167__auto__ = e14176;
var statearr_14177_14195 = state_14149;
(statearr_14177_14195[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14149);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14176;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14196 = state_14149;
state_14149 = G__14196;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_14149){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_14149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___14179,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8180__auto__ = (function (){var statearr_14178 = f__8179__auto__.call(null);
(statearr_14178[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___14179);

return statearr_14178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___14179,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});
map = function(f,chs,buf_or_n){
switch(arguments.length){
case 2:
return map__2.call(this,f,chs);
case 3:
return map__3.call(this,f,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
map.cljs$core$IFn$_invoke$arity$2 = map__2;
map.cljs$core$IFn$_invoke$arity$3 = map__3;
return map;
})()
;
/**
* Takes a collection of source channels and returns a channel which
* contains all values taken from them. The returned channel will be
* unbuffered by default, or a buf-or-n can be supplied. The channel
* will close after all the source channels have closed.
*/
cljs.core.async.merge = (function() {
var merge = null;
var merge__1 = (function (chs){
return merge.call(null,chs,null);
});
var merge__2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8178__auto___14304 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___14304,out){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___14304,out){
return (function (state_14280){
var state_val_14281 = (state_14280[(1)]);
if((state_val_14281 === (7))){
var inst_14260 = (state_14280[(7)]);
var inst_14259 = (state_14280[(8)]);
var inst_14259__$1 = (state_14280[(2)]);
var inst_14260__$1 = cljs.core.nth.call(null,inst_14259__$1,(0),null);
var inst_14261 = cljs.core.nth.call(null,inst_14259__$1,(1),null);
var inst_14262 = (inst_14260__$1 == null);
var state_14280__$1 = (function (){var statearr_14282 = state_14280;
(statearr_14282[(7)] = inst_14260__$1);

(statearr_14282[(8)] = inst_14259__$1);

(statearr_14282[(9)] = inst_14261);

return statearr_14282;
})();
if(cljs.core.truth_(inst_14262)){
var statearr_14283_14305 = state_14280__$1;
(statearr_14283_14305[(1)] = (8));

} else {
var statearr_14284_14306 = state_14280__$1;
(statearr_14284_14306[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14281 === (1))){
var inst_14251 = cljs.core.vec.call(null,chs);
var inst_14252 = inst_14251;
var state_14280__$1 = (function (){var statearr_14285 = state_14280;
(statearr_14285[(10)] = inst_14252);

return statearr_14285;
})();
var statearr_14286_14307 = state_14280__$1;
(statearr_14286_14307[(2)] = null);

(statearr_14286_14307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14281 === (4))){
var inst_14252 = (state_14280[(10)]);
var state_14280__$1 = state_14280;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14280__$1,(7),inst_14252);
} else {
if((state_val_14281 === (6))){
var inst_14276 = (state_14280[(2)]);
var state_14280__$1 = state_14280;
var statearr_14287_14308 = state_14280__$1;
(statearr_14287_14308[(2)] = inst_14276);

(statearr_14287_14308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14281 === (3))){
var inst_14278 = (state_14280[(2)]);
var state_14280__$1 = state_14280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14280__$1,inst_14278);
} else {
if((state_val_14281 === (2))){
var inst_14252 = (state_14280[(10)]);
var inst_14254 = cljs.core.count.call(null,inst_14252);
var inst_14255 = (inst_14254 > (0));
var state_14280__$1 = state_14280;
if(cljs.core.truth_(inst_14255)){
var statearr_14289_14309 = state_14280__$1;
(statearr_14289_14309[(1)] = (4));

} else {
var statearr_14290_14310 = state_14280__$1;
(statearr_14290_14310[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14281 === (11))){
var inst_14252 = (state_14280[(10)]);
var inst_14269 = (state_14280[(2)]);
var tmp14288 = inst_14252;
var inst_14252__$1 = tmp14288;
var state_14280__$1 = (function (){var statearr_14291 = state_14280;
(statearr_14291[(10)] = inst_14252__$1);

(statearr_14291[(11)] = inst_14269);

return statearr_14291;
})();
var statearr_14292_14311 = state_14280__$1;
(statearr_14292_14311[(2)] = null);

(statearr_14292_14311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14281 === (9))){
var inst_14260 = (state_14280[(7)]);
var state_14280__$1 = state_14280;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14280__$1,(11),out,inst_14260);
} else {
if((state_val_14281 === (5))){
var inst_14274 = cljs.core.async.close_BANG_.call(null,out);
var state_14280__$1 = state_14280;
var statearr_14293_14312 = state_14280__$1;
(statearr_14293_14312[(2)] = inst_14274);

(statearr_14293_14312[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14281 === (10))){
var inst_14272 = (state_14280[(2)]);
var state_14280__$1 = state_14280;
var statearr_14294_14313 = state_14280__$1;
(statearr_14294_14313[(2)] = inst_14272);

(statearr_14294_14313[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14281 === (8))){
var inst_14252 = (state_14280[(10)]);
var inst_14260 = (state_14280[(7)]);
var inst_14259 = (state_14280[(8)]);
var inst_14261 = (state_14280[(9)]);
var inst_14264 = (function (){var c = inst_14261;
var v = inst_14260;
var vec__14257 = inst_14259;
var cs = inst_14252;
return ((function (c,v,vec__14257,cs,inst_14252,inst_14260,inst_14259,inst_14261,state_val_14281,c__8178__auto___14304,out){
return (function (p1__14197_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14197_SHARP_);
});
;})(c,v,vec__14257,cs,inst_14252,inst_14260,inst_14259,inst_14261,state_val_14281,c__8178__auto___14304,out))
})();
var inst_14265 = cljs.core.filterv.call(null,inst_14264,inst_14252);
var inst_14252__$1 = inst_14265;
var state_14280__$1 = (function (){var statearr_14295 = state_14280;
(statearr_14295[(10)] = inst_14252__$1);

return statearr_14295;
})();
var statearr_14296_14314 = state_14280__$1;
(statearr_14296_14314[(2)] = null);

(statearr_14296_14314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___14304,out))
;
return ((function (switch__8163__auto__,c__8178__auto___14304,out){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_14300 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14300[(0)] = state_machine__8164__auto__);

(statearr_14300[(1)] = (1));

return statearr_14300;
});
var state_machine__8164__auto____1 = (function (state_14280){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_14280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e14301){if((e14301 instanceof Object)){
var ex__8167__auto__ = e14301;
var statearr_14302_14315 = state_14280;
(statearr_14302_14315[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14280);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14301;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14316 = state_14280;
state_14280 = G__14316;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_14280){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_14280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___14304,out))
})();
var state__8180__auto__ = (function (){var statearr_14303 = f__8179__auto__.call(null);
(statearr_14303[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___14304);

return statearr_14303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___14304,out))
);


return out;
});
merge = function(chs,buf_or_n){
switch(arguments.length){
case 1:
return merge__1.call(this,chs);
case 2:
return merge__2.call(this,chs,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
merge.cljs$core$IFn$_invoke$arity$1 = merge__1;
merge.cljs$core$IFn$_invoke$arity$2 = merge__2;
return merge;
})()
;
/**
* Returns a channel containing the single (collection) result of the
* items taken from the channel conjoined to the supplied
* collection. ch must close before into produces a result.
*/
cljs.core.async.into = (function into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
* Returns a channel that will return, at most, n items from ch. After n items
* have been returned, or ch has been closed, the return chanel will close.
* 
* The output channel is unbuffered by default, unless buf-or-n is given.
*/
cljs.core.async.take = (function() {
var take = null;
var take__2 = (function (n,ch){
return take.call(null,n,ch,null);
});
var take__3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8178__auto___14409 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___14409,out){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___14409,out){
return (function (state_14386){
var state_val_14387 = (state_14386[(1)]);
if((state_val_14387 === (7))){
var inst_14368 = (state_14386[(7)]);
var inst_14368__$1 = (state_14386[(2)]);
var inst_14369 = (inst_14368__$1 == null);
var inst_14370 = cljs.core.not.call(null,inst_14369);
var state_14386__$1 = (function (){var statearr_14388 = state_14386;
(statearr_14388[(7)] = inst_14368__$1);

return statearr_14388;
})();
if(inst_14370){
var statearr_14389_14410 = state_14386__$1;
(statearr_14389_14410[(1)] = (8));

} else {
var statearr_14390_14411 = state_14386__$1;
(statearr_14390_14411[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (1))){
var inst_14363 = (0);
var state_14386__$1 = (function (){var statearr_14391 = state_14386;
(statearr_14391[(8)] = inst_14363);

return statearr_14391;
})();
var statearr_14392_14412 = state_14386__$1;
(statearr_14392_14412[(2)] = null);

(statearr_14392_14412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (4))){
var state_14386__$1 = state_14386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14386__$1,(7),ch);
} else {
if((state_val_14387 === (6))){
var inst_14381 = (state_14386[(2)]);
var state_14386__$1 = state_14386;
var statearr_14393_14413 = state_14386__$1;
(statearr_14393_14413[(2)] = inst_14381);

(statearr_14393_14413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (3))){
var inst_14383 = (state_14386[(2)]);
var inst_14384 = cljs.core.async.close_BANG_.call(null,out);
var state_14386__$1 = (function (){var statearr_14394 = state_14386;
(statearr_14394[(9)] = inst_14383);

return statearr_14394;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14386__$1,inst_14384);
} else {
if((state_val_14387 === (2))){
var inst_14363 = (state_14386[(8)]);
var inst_14365 = (inst_14363 < n);
var state_14386__$1 = state_14386;
if(cljs.core.truth_(inst_14365)){
var statearr_14395_14414 = state_14386__$1;
(statearr_14395_14414[(1)] = (4));

} else {
var statearr_14396_14415 = state_14386__$1;
(statearr_14396_14415[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (11))){
var inst_14363 = (state_14386[(8)]);
var inst_14373 = (state_14386[(2)]);
var inst_14374 = (inst_14363 + (1));
var inst_14363__$1 = inst_14374;
var state_14386__$1 = (function (){var statearr_14397 = state_14386;
(statearr_14397[(8)] = inst_14363__$1);

(statearr_14397[(10)] = inst_14373);

return statearr_14397;
})();
var statearr_14398_14416 = state_14386__$1;
(statearr_14398_14416[(2)] = null);

(statearr_14398_14416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (9))){
var state_14386__$1 = state_14386;
var statearr_14399_14417 = state_14386__$1;
(statearr_14399_14417[(2)] = null);

(statearr_14399_14417[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (5))){
var state_14386__$1 = state_14386;
var statearr_14400_14418 = state_14386__$1;
(statearr_14400_14418[(2)] = null);

(statearr_14400_14418[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (10))){
var inst_14378 = (state_14386[(2)]);
var state_14386__$1 = state_14386;
var statearr_14401_14419 = state_14386__$1;
(statearr_14401_14419[(2)] = inst_14378);

(statearr_14401_14419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14387 === (8))){
var inst_14368 = (state_14386[(7)]);
var state_14386__$1 = state_14386;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14386__$1,(11),out,inst_14368);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___14409,out))
;
return ((function (switch__8163__auto__,c__8178__auto___14409,out){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_14405 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14405[(0)] = state_machine__8164__auto__);

(statearr_14405[(1)] = (1));

return statearr_14405;
});
var state_machine__8164__auto____1 = (function (state_14386){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_14386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e14406){if((e14406 instanceof Object)){
var ex__8167__auto__ = e14406;
var statearr_14407_14420 = state_14386;
(statearr_14407_14420[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14406;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14421 = state_14386;
state_14386 = G__14421;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_14386){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_14386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___14409,out))
})();
var state__8180__auto__ = (function (){var statearr_14408 = f__8179__auto__.call(null);
(statearr_14408[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___14409);

return statearr_14408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___14409,out))
);


return out;
});
take = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return take__2.call(this,n,ch);
case 3:
return take__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
take.cljs$core$IFn$_invoke$arity$2 = take__2;
take.cljs$core$IFn$_invoke$arity$3 = take__3;
return take;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_LT_ = (function map_LT_(f,ch){
if(typeof cljs.core.async.t14429 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14429 = (function (ch,f,map_LT_,meta14430){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta14430 = meta14430;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14429.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14429.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t14429.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14429.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t14432 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14432 = (function (fn1,_,meta14430,map_LT_,f,ch,meta14433){
this.fn1 = fn1;
this._ = _;
this.meta14430 = meta14430;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14433 = meta14433;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14432.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t14432.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t14432.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14422_SHARP_){
return f1.call(null,(((p1__14422_SHARP_ == null))?null:self__.f.call(null,p1__14422_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t14432.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14434){
var self__ = this;
var _14434__$1 = this;
return self__.meta14433;
});})(___$1))
;

cljs.core.async.t14432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14434,meta14433__$1){
var self__ = this;
var _14434__$1 = this;
return (new cljs.core.async.t14432(self__.fn1,self__._,self__.meta14430,self__.map_LT_,self__.f,self__.ch,meta14433__$1));
});})(___$1))
;

cljs.core.async.t14432.cljs$lang$type = true;

cljs.core.async.t14432.cljs$lang$ctorStr = "cljs.core.async/t14432";

cljs.core.async.t14432.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t14432");
});})(___$1))
;

cljs.core.async.__GT_t14432 = ((function (___$1){
return (function __GT_t14432(fn1__$1,___$2,meta14430__$1,map_LT___$1,f__$1,ch__$1,meta14433){
return (new cljs.core.async.t14432(fn1__$1,___$2,meta14430__$1,map_LT___$1,f__$1,ch__$1,meta14433));
});})(___$1))
;

}

return (new cljs.core.async.t14432(fn1,___$1,self__.meta14430,self__.map_LT_,self__.f,self__.ch,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),46,new cljs.core.Keyword(null,"end-line","end-line",1837326455),737,new cljs.core.Keyword(null,"column","column",2078222095),10,new cljs.core.Keyword(null,"line","line",212345235),731,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
})()
);
if(cljs.core.truth_((function (){var and__3746__auto__ = ret;
if(cljs.core.truth_(and__3746__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3746__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t14429.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14429.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14429.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14431){
var self__ = this;
var _14431__$1 = this;
return self__.meta14430;
});

cljs.core.async.t14429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14431,meta14430__$1){
var self__ = this;
var _14431__$1 = this;
return (new cljs.core.async.t14429(self__.ch,self__.f,self__.map_LT_,meta14430__$1));
});

cljs.core.async.t14429.cljs$lang$type = true;

cljs.core.async.t14429.cljs$lang$ctorStr = "cljs.core.async/t14429";

cljs.core.async.t14429.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t14429");
});

cljs.core.async.__GT_t14429 = (function __GT_t14429(ch__$1,f__$1,map_LT___$1,meta14430){
return (new cljs.core.async.t14429(ch__$1,f__$1,map_LT___$1,meta14430));
});

}

return (new cljs.core.async.t14429(ch,f,map_LT_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),46,new cljs.core.Keyword(null,"end-line","end-line",1837326455),743,new cljs.core.Keyword(null,"column","column",2078222095),3,new cljs.core.Keyword(null,"line","line",212345235),722,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.map_GT_ = (function map_GT_(f,ch){
if(typeof cljs.core.async.t14438 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14438 = (function (ch,f,map_GT_,meta14439){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta14439 = meta14439;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14438.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14438.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t14438.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14438.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14438.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14438.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14438.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14440){
var self__ = this;
var _14440__$1 = this;
return self__.meta14439;
});

cljs.core.async.t14438.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14440,meta14439__$1){
var self__ = this;
var _14440__$1 = this;
return (new cljs.core.async.t14438(self__.ch,self__.f,self__.map_GT_,meta14439__$1));
});

cljs.core.async.t14438.cljs$lang$type = true;

cljs.core.async.t14438.cljs$lang$ctorStr = "cljs.core.async/t14438";

cljs.core.async.t14438.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t14438");
});

cljs.core.async.__GT_t14438 = (function __GT_t14438(ch__$1,f__$1,map_GT___$1,meta14439){
return (new cljs.core.async.t14438(ch__$1,f__$1,map_GT___$1,meta14439));
});

}

return (new cljs.core.async.t14438(ch,f,map_GT_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),34,new cljs.core.Keyword(null,"end-line","end-line",1837326455),757,new cljs.core.Keyword(null,"column","column",2078222095),3,new cljs.core.Keyword(null,"line","line",212345235),748,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_GT_ = (function filter_GT_(p,ch){
if(typeof cljs.core.async.t14444 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14444 = (function (ch,p,filter_GT_,meta14445){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta14445 = meta14445;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14444.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14444.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t14444.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14444.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14444.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14444.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14444.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14444.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14446){
var self__ = this;
var _14446__$1 = this;
return self__.meta14445;
});

cljs.core.async.t14444.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14446,meta14445__$1){
var self__ = this;
var _14446__$1 = this;
return (new cljs.core.async.t14444(self__.ch,self__.p,self__.filter_GT_,meta14445__$1));
});

cljs.core.async.t14444.cljs$lang$type = true;

cljs.core.async.t14444.cljs$lang$ctorStr = "cljs.core.async/t14444";

cljs.core.async.t14444.cljs$lang$ctorPrWriter = (function (this__4345__auto__,writer__4346__auto__,opt__4347__auto__){
return cljs.core._write.call(null,writer__4346__auto__,"cljs.core.async/t14444");
});

cljs.core.async.__GT_t14444 = (function __GT_t14444(ch__$1,p__$1,filter_GT___$1,meta14445){
return (new cljs.core.async.t14444(ch__$1,p__$1,filter_GT___$1,meta14445));
});

}

return (new cljs.core.async.t14444(ch,p,filter_GT_,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"end-column","end-column",1425389514),48,new cljs.core.Keyword(null,"end-line","end-line",1837326455),774,new cljs.core.Keyword(null,"column","column",2078222095),3,new cljs.core.Keyword(null,"line","line",212345235),762,new cljs.core.Keyword(null,"file","file",-1269645878),"/home/andrew/code/overseer/resources/static/js-out/out/cljs/core/async.cljs"], null)));
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_GT_ = (function remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.filter_LT_ = (function() {
var filter_LT_ = null;
var filter_LT___2 = (function (p,ch){
return filter_LT_.call(null,p,ch,null);
});
var filter_LT___3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8178__auto___14529 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___14529,out){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___14529,out){
return (function (state_14508){
var state_val_14509 = (state_14508[(1)]);
if((state_val_14509 === (7))){
var inst_14504 = (state_14508[(2)]);
var state_14508__$1 = state_14508;
var statearr_14510_14530 = state_14508__$1;
(statearr_14510_14530[(2)] = inst_14504);

(statearr_14510_14530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (1))){
var state_14508__$1 = state_14508;
var statearr_14511_14531 = state_14508__$1;
(statearr_14511_14531[(2)] = null);

(statearr_14511_14531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (4))){
var inst_14490 = (state_14508[(7)]);
var inst_14490__$1 = (state_14508[(2)]);
var inst_14491 = (inst_14490__$1 == null);
var state_14508__$1 = (function (){var statearr_14512 = state_14508;
(statearr_14512[(7)] = inst_14490__$1);

return statearr_14512;
})();
if(cljs.core.truth_(inst_14491)){
var statearr_14513_14532 = state_14508__$1;
(statearr_14513_14532[(1)] = (5));

} else {
var statearr_14514_14533 = state_14508__$1;
(statearr_14514_14533[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (6))){
var inst_14490 = (state_14508[(7)]);
var inst_14495 = p.call(null,inst_14490);
var state_14508__$1 = state_14508;
if(cljs.core.truth_(inst_14495)){
var statearr_14515_14534 = state_14508__$1;
(statearr_14515_14534[(1)] = (8));

} else {
var statearr_14516_14535 = state_14508__$1;
(statearr_14516_14535[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (3))){
var inst_14506 = (state_14508[(2)]);
var state_14508__$1 = state_14508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14508__$1,inst_14506);
} else {
if((state_val_14509 === (2))){
var state_14508__$1 = state_14508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14508__$1,(4),ch);
} else {
if((state_val_14509 === (11))){
var inst_14498 = (state_14508[(2)]);
var state_14508__$1 = state_14508;
var statearr_14517_14536 = state_14508__$1;
(statearr_14517_14536[(2)] = inst_14498);

(statearr_14517_14536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (9))){
var state_14508__$1 = state_14508;
var statearr_14518_14537 = state_14508__$1;
(statearr_14518_14537[(2)] = null);

(statearr_14518_14537[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (5))){
var inst_14493 = cljs.core.async.close_BANG_.call(null,out);
var state_14508__$1 = state_14508;
var statearr_14519_14538 = state_14508__$1;
(statearr_14519_14538[(2)] = inst_14493);

(statearr_14519_14538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (10))){
var inst_14501 = (state_14508[(2)]);
var state_14508__$1 = (function (){var statearr_14520 = state_14508;
(statearr_14520[(8)] = inst_14501);

return statearr_14520;
})();
var statearr_14521_14539 = state_14508__$1;
(statearr_14521_14539[(2)] = null);

(statearr_14521_14539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14509 === (8))){
var inst_14490 = (state_14508[(7)]);
var state_14508__$1 = state_14508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14508__$1,(11),out,inst_14490);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___14529,out))
;
return ((function (switch__8163__auto__,c__8178__auto___14529,out){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_14525 = [null,null,null,null,null,null,null,null,null];
(statearr_14525[(0)] = state_machine__8164__auto__);

(statearr_14525[(1)] = (1));

return statearr_14525;
});
var state_machine__8164__auto____1 = (function (state_14508){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_14508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e14526){if((e14526 instanceof Object)){
var ex__8167__auto__ = e14526;
var statearr_14527_14540 = state_14508;
(statearr_14527_14540[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14541 = state_14508;
state_14508 = G__14541;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_14508){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_14508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___14529,out))
})();
var state__8180__auto__ = (function (){var statearr_14528 = f__8179__auto__.call(null);
(statearr_14528[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___14529);

return statearr_14528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___14529,out))
);


return out;
});
filter_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return filter_LT___2.call(this,p,ch);
case 3:
return filter_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
filter_LT_.cljs$core$IFn$_invoke$arity$2 = filter_LT___2;
filter_LT_.cljs$core$IFn$_invoke$arity$3 = filter_LT___3;
return filter_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.remove_LT_ = (function() {
var remove_LT_ = null;
var remove_LT___2 = (function (p,ch){
return remove_LT_.call(null,p,ch,null);
});
var remove_LT___3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});
remove_LT_ = function(p,ch,buf_or_n){
switch(arguments.length){
case 2:
return remove_LT___2.call(this,p,ch);
case 3:
return remove_LT___3.call(this,p,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
remove_LT_.cljs$core$IFn$_invoke$arity$2 = remove_LT___2;
remove_LT_.cljs$core$IFn$_invoke$arity$3 = remove_LT___3;
return remove_LT_;
})()
;
cljs.core.async.mapcat_STAR_ = (function mapcat_STAR_(f,in$,out){
var c__8178__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto__){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto__){
return (function (state_14707){
var state_val_14708 = (state_14707[(1)]);
if((state_val_14708 === (7))){
var inst_14703 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14709_14750 = state_14707__$1;
(statearr_14709_14750[(2)] = inst_14703);

(statearr_14709_14750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (20))){
var inst_14673 = (state_14707[(7)]);
var inst_14684 = (state_14707[(2)]);
var inst_14685 = cljs.core.next.call(null,inst_14673);
var inst_14659 = inst_14685;
var inst_14660 = null;
var inst_14661 = (0);
var inst_14662 = (0);
var state_14707__$1 = (function (){var statearr_14710 = state_14707;
(statearr_14710[(8)] = inst_14662);

(statearr_14710[(9)] = inst_14661);

(statearr_14710[(10)] = inst_14659);

(statearr_14710[(11)] = inst_14684);

(statearr_14710[(12)] = inst_14660);

return statearr_14710;
})();
var statearr_14711_14751 = state_14707__$1;
(statearr_14711_14751[(2)] = null);

(statearr_14711_14751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (1))){
var state_14707__$1 = state_14707;
var statearr_14712_14752 = state_14707__$1;
(statearr_14712_14752[(2)] = null);

(statearr_14712_14752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (4))){
var inst_14648 = (state_14707[(13)]);
var inst_14648__$1 = (state_14707[(2)]);
var inst_14649 = (inst_14648__$1 == null);
var state_14707__$1 = (function (){var statearr_14713 = state_14707;
(statearr_14713[(13)] = inst_14648__$1);

return statearr_14713;
})();
if(cljs.core.truth_(inst_14649)){
var statearr_14714_14753 = state_14707__$1;
(statearr_14714_14753[(1)] = (5));

} else {
var statearr_14715_14754 = state_14707__$1;
(statearr_14715_14754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (15))){
var state_14707__$1 = state_14707;
var statearr_14719_14755 = state_14707__$1;
(statearr_14719_14755[(2)] = null);

(statearr_14719_14755[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (21))){
var state_14707__$1 = state_14707;
var statearr_14720_14756 = state_14707__$1;
(statearr_14720_14756[(2)] = null);

(statearr_14720_14756[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (13))){
var inst_14662 = (state_14707[(8)]);
var inst_14661 = (state_14707[(9)]);
var inst_14659 = (state_14707[(10)]);
var inst_14660 = (state_14707[(12)]);
var inst_14669 = (state_14707[(2)]);
var inst_14670 = (inst_14662 + (1));
var tmp14716 = inst_14661;
var tmp14717 = inst_14659;
var tmp14718 = inst_14660;
var inst_14659__$1 = tmp14717;
var inst_14660__$1 = tmp14718;
var inst_14661__$1 = tmp14716;
var inst_14662__$1 = inst_14670;
var state_14707__$1 = (function (){var statearr_14721 = state_14707;
(statearr_14721[(8)] = inst_14662__$1);

(statearr_14721[(9)] = inst_14661__$1);

(statearr_14721[(14)] = inst_14669);

(statearr_14721[(10)] = inst_14659__$1);

(statearr_14721[(12)] = inst_14660__$1);

return statearr_14721;
})();
var statearr_14722_14757 = state_14707__$1;
(statearr_14722_14757[(2)] = null);

(statearr_14722_14757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (22))){
var state_14707__$1 = state_14707;
var statearr_14723_14758 = state_14707__$1;
(statearr_14723_14758[(2)] = null);

(statearr_14723_14758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (6))){
var inst_14648 = (state_14707[(13)]);
var inst_14657 = f.call(null,inst_14648);
var inst_14658 = cljs.core.seq.call(null,inst_14657);
var inst_14659 = inst_14658;
var inst_14660 = null;
var inst_14661 = (0);
var inst_14662 = (0);
var state_14707__$1 = (function (){var statearr_14724 = state_14707;
(statearr_14724[(8)] = inst_14662);

(statearr_14724[(9)] = inst_14661);

(statearr_14724[(10)] = inst_14659);

(statearr_14724[(12)] = inst_14660);

return statearr_14724;
})();
var statearr_14725_14759 = state_14707__$1;
(statearr_14725_14759[(2)] = null);

(statearr_14725_14759[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (17))){
var inst_14673 = (state_14707[(7)]);
var inst_14677 = cljs.core.chunk_first.call(null,inst_14673);
var inst_14678 = cljs.core.chunk_rest.call(null,inst_14673);
var inst_14679 = cljs.core.count.call(null,inst_14677);
var inst_14659 = inst_14678;
var inst_14660 = inst_14677;
var inst_14661 = inst_14679;
var inst_14662 = (0);
var state_14707__$1 = (function (){var statearr_14726 = state_14707;
(statearr_14726[(8)] = inst_14662);

(statearr_14726[(9)] = inst_14661);

(statearr_14726[(10)] = inst_14659);

(statearr_14726[(12)] = inst_14660);

return statearr_14726;
})();
var statearr_14727_14760 = state_14707__$1;
(statearr_14727_14760[(2)] = null);

(statearr_14727_14760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (3))){
var inst_14705 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14707__$1,inst_14705);
} else {
if((state_val_14708 === (12))){
var inst_14693 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14728_14761 = state_14707__$1;
(statearr_14728_14761[(2)] = inst_14693);

(statearr_14728_14761[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (2))){
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14707__$1,(4),in$);
} else {
if((state_val_14708 === (23))){
var inst_14701 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14729_14762 = state_14707__$1;
(statearr_14729_14762[(2)] = inst_14701);

(statearr_14729_14762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (19))){
var inst_14688 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14730_14763 = state_14707__$1;
(statearr_14730_14763[(2)] = inst_14688);

(statearr_14730_14763[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (11))){
var inst_14659 = (state_14707[(10)]);
var inst_14673 = (state_14707[(7)]);
var inst_14673__$1 = cljs.core.seq.call(null,inst_14659);
var state_14707__$1 = (function (){var statearr_14731 = state_14707;
(statearr_14731[(7)] = inst_14673__$1);

return statearr_14731;
})();
if(inst_14673__$1){
var statearr_14732_14764 = state_14707__$1;
(statearr_14732_14764[(1)] = (14));

} else {
var statearr_14733_14765 = state_14707__$1;
(statearr_14733_14765[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (9))){
var inst_14695 = (state_14707[(2)]);
var inst_14696 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14707__$1 = (function (){var statearr_14734 = state_14707;
(statearr_14734[(15)] = inst_14695);

return statearr_14734;
})();
if(cljs.core.truth_(inst_14696)){
var statearr_14735_14766 = state_14707__$1;
(statearr_14735_14766[(1)] = (21));

} else {
var statearr_14736_14767 = state_14707__$1;
(statearr_14736_14767[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (5))){
var inst_14651 = cljs.core.async.close_BANG_.call(null,out);
var state_14707__$1 = state_14707;
var statearr_14737_14768 = state_14707__$1;
(statearr_14737_14768[(2)] = inst_14651);

(statearr_14737_14768[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (14))){
var inst_14673 = (state_14707[(7)]);
var inst_14675 = cljs.core.chunked_seq_QMARK_.call(null,inst_14673);
var state_14707__$1 = state_14707;
if(inst_14675){
var statearr_14738_14769 = state_14707__$1;
(statearr_14738_14769[(1)] = (17));

} else {
var statearr_14739_14770 = state_14707__$1;
(statearr_14739_14770[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (16))){
var inst_14691 = (state_14707[(2)]);
var state_14707__$1 = state_14707;
var statearr_14740_14771 = state_14707__$1;
(statearr_14740_14771[(2)] = inst_14691);

(statearr_14740_14771[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14708 === (10))){
var inst_14662 = (state_14707[(8)]);
var inst_14660 = (state_14707[(12)]);
var inst_14667 = cljs.core._nth.call(null,inst_14660,inst_14662);
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14707__$1,(13),out,inst_14667);
} else {
if((state_val_14708 === (18))){
var inst_14673 = (state_14707[(7)]);
var inst_14682 = cljs.core.first.call(null,inst_14673);
var state_14707__$1 = state_14707;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14707__$1,(20),out,inst_14682);
} else {
if((state_val_14708 === (8))){
var inst_14662 = (state_14707[(8)]);
var inst_14661 = (state_14707[(9)]);
var inst_14664 = (inst_14662 < inst_14661);
var inst_14665 = inst_14664;
var state_14707__$1 = state_14707;
if(cljs.core.truth_(inst_14665)){
var statearr_14741_14772 = state_14707__$1;
(statearr_14741_14772[(1)] = (10));

} else {
var statearr_14742_14773 = state_14707__$1;
(statearr_14742_14773[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto__))
;
return ((function (switch__8163__auto__,c__8178__auto__){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_14746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14746[(0)] = state_machine__8164__auto__);

(statearr_14746[(1)] = (1));

return statearr_14746;
});
var state_machine__8164__auto____1 = (function (state_14707){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_14707);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e14747){if((e14747 instanceof Object)){
var ex__8167__auto__ = e14747;
var statearr_14748_14774 = state_14707;
(statearr_14748_14774[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14707);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14775 = state_14707;
state_14707 = G__14775;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_14707){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_14707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto__))
})();
var state__8180__auto__ = (function (){var statearr_14749 = f__8179__auto__.call(null);
(statearr_14749[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto__);

return statearr_14749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto__))
);

return c__8178__auto__;
});
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_LT_ = (function() {
var mapcat_LT_ = null;
var mapcat_LT___2 = (function (f,in$){
return mapcat_LT_.call(null,f,in$,null);
});
var mapcat_LT___3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});
mapcat_LT_ = function(f,in$,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_LT___2.call(this,f,in$);
case 3:
return mapcat_LT___3.call(this,f,in$,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = mapcat_LT___2;
mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = mapcat_LT___3;
return mapcat_LT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.mapcat_GT_ = (function() {
var mapcat_GT_ = null;
var mapcat_GT___2 = (function (f,out){
return mapcat_GT_.call(null,f,out,null);
});
var mapcat_GT___3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});
mapcat_GT_ = function(f,out,buf_or_n){
switch(arguments.length){
case 2:
return mapcat_GT___2.call(this,f,out);
case 3:
return mapcat_GT___3.call(this,f,out,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = mapcat_GT___2;
mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = mapcat_GT___3;
return mapcat_GT_;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.unique = (function() {
var unique = null;
var unique__1 = (function (ch){
return unique.call(null,ch,null);
});
var unique__2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8178__auto___14872 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___14872,out){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___14872,out){
return (function (state_14847){
var state_val_14848 = (state_14847[(1)]);
if((state_val_14848 === (7))){
var inst_14842 = (state_14847[(2)]);
var state_14847__$1 = state_14847;
var statearr_14849_14873 = state_14847__$1;
(statearr_14849_14873[(2)] = inst_14842);

(statearr_14849_14873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (1))){
var inst_14824 = null;
var state_14847__$1 = (function (){var statearr_14850 = state_14847;
(statearr_14850[(7)] = inst_14824);

return statearr_14850;
})();
var statearr_14851_14874 = state_14847__$1;
(statearr_14851_14874[(2)] = null);

(statearr_14851_14874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (4))){
var inst_14827 = (state_14847[(8)]);
var inst_14827__$1 = (state_14847[(2)]);
var inst_14828 = (inst_14827__$1 == null);
var inst_14829 = cljs.core.not.call(null,inst_14828);
var state_14847__$1 = (function (){var statearr_14852 = state_14847;
(statearr_14852[(8)] = inst_14827__$1);

return statearr_14852;
})();
if(inst_14829){
var statearr_14853_14875 = state_14847__$1;
(statearr_14853_14875[(1)] = (5));

} else {
var statearr_14854_14876 = state_14847__$1;
(statearr_14854_14876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (6))){
var state_14847__$1 = state_14847;
var statearr_14855_14877 = state_14847__$1;
(statearr_14855_14877[(2)] = null);

(statearr_14855_14877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (3))){
var inst_14844 = (state_14847[(2)]);
var inst_14845 = cljs.core.async.close_BANG_.call(null,out);
var state_14847__$1 = (function (){var statearr_14856 = state_14847;
(statearr_14856[(9)] = inst_14844);

return statearr_14856;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14847__$1,inst_14845);
} else {
if((state_val_14848 === (2))){
var state_14847__$1 = state_14847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14847__$1,(4),ch);
} else {
if((state_val_14848 === (11))){
var inst_14827 = (state_14847[(8)]);
var inst_14836 = (state_14847[(2)]);
var inst_14824 = inst_14827;
var state_14847__$1 = (function (){var statearr_14857 = state_14847;
(statearr_14857[(10)] = inst_14836);

(statearr_14857[(7)] = inst_14824);

return statearr_14857;
})();
var statearr_14858_14878 = state_14847__$1;
(statearr_14858_14878[(2)] = null);

(statearr_14858_14878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (9))){
var inst_14827 = (state_14847[(8)]);
var state_14847__$1 = state_14847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14847__$1,(11),out,inst_14827);
} else {
if((state_val_14848 === (5))){
var inst_14827 = (state_14847[(8)]);
var inst_14824 = (state_14847[(7)]);
var inst_14831 = cljs.core._EQ_.call(null,inst_14827,inst_14824);
var state_14847__$1 = state_14847;
if(inst_14831){
var statearr_14860_14879 = state_14847__$1;
(statearr_14860_14879[(1)] = (8));

} else {
var statearr_14861_14880 = state_14847__$1;
(statearr_14861_14880[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (10))){
var inst_14839 = (state_14847[(2)]);
var state_14847__$1 = state_14847;
var statearr_14862_14881 = state_14847__$1;
(statearr_14862_14881[(2)] = inst_14839);

(statearr_14862_14881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14848 === (8))){
var inst_14824 = (state_14847[(7)]);
var tmp14859 = inst_14824;
var inst_14824__$1 = tmp14859;
var state_14847__$1 = (function (){var statearr_14863 = state_14847;
(statearr_14863[(7)] = inst_14824__$1);

return statearr_14863;
})();
var statearr_14864_14882 = state_14847__$1;
(statearr_14864_14882[(2)] = null);

(statearr_14864_14882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___14872,out))
;
return ((function (switch__8163__auto__,c__8178__auto___14872,out){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_14868 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14868[(0)] = state_machine__8164__auto__);

(statearr_14868[(1)] = (1));

return statearr_14868;
});
var state_machine__8164__auto____1 = (function (state_14847){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_14847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e14869){if((e14869 instanceof Object)){
var ex__8167__auto__ = e14869;
var statearr_14870_14883 = state_14847;
(statearr_14870_14883[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14884 = state_14847;
state_14847 = G__14884;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_14847){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_14847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___14872,out))
})();
var state__8180__auto__ = (function (){var statearr_14871 = f__8179__auto__.call(null);
(statearr_14871[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___14872);

return statearr_14871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___14872,out))
);


return out;
});
unique = function(ch,buf_or_n){
switch(arguments.length){
case 1:
return unique__1.call(this,ch);
case 2:
return unique__2.call(this,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
unique.cljs$core$IFn$_invoke$arity$1 = unique__1;
unique.cljs$core$IFn$_invoke$arity$2 = unique__2;
return unique;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition = (function() {
var partition = null;
var partition__2 = (function (n,ch){
return partition.call(null,n,ch,null);
});
var partition__3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8178__auto___15019 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___15019,out){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___15019,out){
return (function (state_14989){
var state_val_14990 = (state_14989[(1)]);
if((state_val_14990 === (7))){
var inst_14985 = (state_14989[(2)]);
var state_14989__$1 = state_14989;
var statearr_14991_15020 = state_14989__$1;
(statearr_14991_15020[(2)] = inst_14985);

(statearr_14991_15020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (1))){
var inst_14952 = (new Array(n));
var inst_14953 = inst_14952;
var inst_14954 = (0);
var state_14989__$1 = (function (){var statearr_14992 = state_14989;
(statearr_14992[(7)] = inst_14954);

(statearr_14992[(8)] = inst_14953);

return statearr_14992;
})();
var statearr_14993_15021 = state_14989__$1;
(statearr_14993_15021[(2)] = null);

(statearr_14993_15021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (4))){
var inst_14957 = (state_14989[(9)]);
var inst_14957__$1 = (state_14989[(2)]);
var inst_14958 = (inst_14957__$1 == null);
var inst_14959 = cljs.core.not.call(null,inst_14958);
var state_14989__$1 = (function (){var statearr_14994 = state_14989;
(statearr_14994[(9)] = inst_14957__$1);

return statearr_14994;
})();
if(inst_14959){
var statearr_14995_15022 = state_14989__$1;
(statearr_14995_15022[(1)] = (5));

} else {
var statearr_14996_15023 = state_14989__$1;
(statearr_14996_15023[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (15))){
var inst_14979 = (state_14989[(2)]);
var state_14989__$1 = state_14989;
var statearr_14997_15024 = state_14989__$1;
(statearr_14997_15024[(2)] = inst_14979);

(statearr_14997_15024[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (13))){
var state_14989__$1 = state_14989;
var statearr_14998_15025 = state_14989__$1;
(statearr_14998_15025[(2)] = null);

(statearr_14998_15025[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (6))){
var inst_14954 = (state_14989[(7)]);
var inst_14975 = (inst_14954 > (0));
var state_14989__$1 = state_14989;
if(cljs.core.truth_(inst_14975)){
var statearr_14999_15026 = state_14989__$1;
(statearr_14999_15026[(1)] = (12));

} else {
var statearr_15000_15027 = state_14989__$1;
(statearr_15000_15027[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (3))){
var inst_14987 = (state_14989[(2)]);
var state_14989__$1 = state_14989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14989__$1,inst_14987);
} else {
if((state_val_14990 === (12))){
var inst_14953 = (state_14989[(8)]);
var inst_14977 = cljs.core.vec.call(null,inst_14953);
var state_14989__$1 = state_14989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14989__$1,(15),out,inst_14977);
} else {
if((state_val_14990 === (2))){
var state_14989__$1 = state_14989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14989__$1,(4),ch);
} else {
if((state_val_14990 === (11))){
var inst_14969 = (state_14989[(2)]);
var inst_14970 = (new Array(n));
var inst_14953 = inst_14970;
var inst_14954 = (0);
var state_14989__$1 = (function (){var statearr_15001 = state_14989;
(statearr_15001[(7)] = inst_14954);

(statearr_15001[(10)] = inst_14969);

(statearr_15001[(8)] = inst_14953);

return statearr_15001;
})();
var statearr_15002_15028 = state_14989__$1;
(statearr_15002_15028[(2)] = null);

(statearr_15002_15028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (9))){
var inst_14953 = (state_14989[(8)]);
var inst_14967 = cljs.core.vec.call(null,inst_14953);
var state_14989__$1 = state_14989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14989__$1,(11),out,inst_14967);
} else {
if((state_val_14990 === (5))){
var inst_14962 = (state_14989[(11)]);
var inst_14954 = (state_14989[(7)]);
var inst_14957 = (state_14989[(9)]);
var inst_14953 = (state_14989[(8)]);
var inst_14961 = (inst_14953[inst_14954] = inst_14957);
var inst_14962__$1 = (inst_14954 + (1));
var inst_14963 = (inst_14962__$1 < n);
var state_14989__$1 = (function (){var statearr_15003 = state_14989;
(statearr_15003[(11)] = inst_14962__$1);

(statearr_15003[(12)] = inst_14961);

return statearr_15003;
})();
if(cljs.core.truth_(inst_14963)){
var statearr_15004_15029 = state_14989__$1;
(statearr_15004_15029[(1)] = (8));

} else {
var statearr_15005_15030 = state_14989__$1;
(statearr_15005_15030[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (14))){
var inst_14982 = (state_14989[(2)]);
var inst_14983 = cljs.core.async.close_BANG_.call(null,out);
var state_14989__$1 = (function (){var statearr_15007 = state_14989;
(statearr_15007[(13)] = inst_14982);

return statearr_15007;
})();
var statearr_15008_15031 = state_14989__$1;
(statearr_15008_15031[(2)] = inst_14983);

(statearr_15008_15031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (10))){
var inst_14973 = (state_14989[(2)]);
var state_14989__$1 = state_14989;
var statearr_15009_15032 = state_14989__$1;
(statearr_15009_15032[(2)] = inst_14973);

(statearr_15009_15032[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (8))){
var inst_14962 = (state_14989[(11)]);
var inst_14953 = (state_14989[(8)]);
var tmp15006 = inst_14953;
var inst_14953__$1 = tmp15006;
var inst_14954 = inst_14962;
var state_14989__$1 = (function (){var statearr_15010 = state_14989;
(statearr_15010[(7)] = inst_14954);

(statearr_15010[(8)] = inst_14953__$1);

return statearr_15010;
})();
var statearr_15011_15033 = state_14989__$1;
(statearr_15011_15033[(2)] = null);

(statearr_15011_15033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___15019,out))
;
return ((function (switch__8163__auto__,c__8178__auto___15019,out){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_15015 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15015[(0)] = state_machine__8164__auto__);

(statearr_15015[(1)] = (1));

return statearr_15015;
});
var state_machine__8164__auto____1 = (function (state_14989){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_14989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e15016){if((e15016 instanceof Object)){
var ex__8167__auto__ = e15016;
var statearr_15017_15034 = state_14989;
(statearr_15017_15034[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15016;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15035 = state_14989;
state_14989 = G__15035;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_14989){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_14989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___15019,out))
})();
var state__8180__auto__ = (function (){var statearr_15018 = f__8179__auto__.call(null);
(statearr_15018[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___15019);

return statearr_15018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___15019,out))
);


return out;
});
partition = function(n,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition__2.call(this,n,ch);
case 3:
return partition__3.call(this,n,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition.cljs$core$IFn$_invoke$arity$2 = partition__2;
partition.cljs$core$IFn$_invoke$arity$3 = partition__3;
return partition;
})()
;
/**
* Deprecated - this function will be removed. Use transducer instead
*/
cljs.core.async.partition_by = (function() {
var partition_by = null;
var partition_by__2 = (function (f,ch){
return partition_by.call(null,f,ch,null);
});
var partition_by__3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8178__auto___15178 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8178__auto___15178,out){
return (function (){
var f__8179__auto__ = (function (){var switch__8163__auto__ = ((function (c__8178__auto___15178,out){
return (function (state_15148){
var state_val_15149 = (state_15148[(1)]);
if((state_val_15149 === (7))){
var inst_15144 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15150_15179 = state_15148__$1;
(statearr_15150_15179[(2)] = inst_15144);

(statearr_15150_15179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (1))){
var inst_15107 = [];
var inst_15108 = inst_15107;
var inst_15109 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15148__$1 = (function (){var statearr_15151 = state_15148;
(statearr_15151[(7)] = inst_15108);

(statearr_15151[(8)] = inst_15109);

return statearr_15151;
})();
var statearr_15152_15180 = state_15148__$1;
(statearr_15152_15180[(2)] = null);

(statearr_15152_15180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (4))){
var inst_15112 = (state_15148[(9)]);
var inst_15112__$1 = (state_15148[(2)]);
var inst_15113 = (inst_15112__$1 == null);
var inst_15114 = cljs.core.not.call(null,inst_15113);
var state_15148__$1 = (function (){var statearr_15153 = state_15148;
(statearr_15153[(9)] = inst_15112__$1);

return statearr_15153;
})();
if(inst_15114){
var statearr_15154_15181 = state_15148__$1;
(statearr_15154_15181[(1)] = (5));

} else {
var statearr_15155_15182 = state_15148__$1;
(statearr_15155_15182[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (15))){
var inst_15138 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15156_15183 = state_15148__$1;
(statearr_15156_15183[(2)] = inst_15138);

(statearr_15156_15183[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (13))){
var state_15148__$1 = state_15148;
var statearr_15157_15184 = state_15148__$1;
(statearr_15157_15184[(2)] = null);

(statearr_15157_15184[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (6))){
var inst_15108 = (state_15148[(7)]);
var inst_15133 = inst_15108.length;
var inst_15134 = (inst_15133 > (0));
var state_15148__$1 = state_15148;
if(cljs.core.truth_(inst_15134)){
var statearr_15158_15185 = state_15148__$1;
(statearr_15158_15185[(1)] = (12));

} else {
var statearr_15159_15186 = state_15148__$1;
(statearr_15159_15186[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (3))){
var inst_15146 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15148__$1,inst_15146);
} else {
if((state_val_15149 === (12))){
var inst_15108 = (state_15148[(7)]);
var inst_15136 = cljs.core.vec.call(null,inst_15108);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15148__$1,(15),out,inst_15136);
} else {
if((state_val_15149 === (2))){
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15148__$1,(4),ch);
} else {
if((state_val_15149 === (11))){
var inst_15112 = (state_15148[(9)]);
var inst_15116 = (state_15148[(10)]);
var inst_15126 = (state_15148[(2)]);
var inst_15127 = [];
var inst_15128 = inst_15127.push(inst_15112);
var inst_15108 = inst_15127;
var inst_15109 = inst_15116;
var state_15148__$1 = (function (){var statearr_15160 = state_15148;
(statearr_15160[(7)] = inst_15108);

(statearr_15160[(11)] = inst_15128);

(statearr_15160[(8)] = inst_15109);

(statearr_15160[(12)] = inst_15126);

return statearr_15160;
})();
var statearr_15161_15187 = state_15148__$1;
(statearr_15161_15187[(2)] = null);

(statearr_15161_15187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (9))){
var inst_15108 = (state_15148[(7)]);
var inst_15124 = cljs.core.vec.call(null,inst_15108);
var state_15148__$1 = state_15148;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15148__$1,(11),out,inst_15124);
} else {
if((state_val_15149 === (5))){
var inst_15112 = (state_15148[(9)]);
var inst_15116 = (state_15148[(10)]);
var inst_15109 = (state_15148[(8)]);
var inst_15116__$1 = f.call(null,inst_15112);
var inst_15117 = cljs.core._EQ_.call(null,inst_15116__$1,inst_15109);
var inst_15118 = cljs.core.keyword_identical_QMARK_.call(null,inst_15109,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_15119 = (inst_15117) || (inst_15118);
var state_15148__$1 = (function (){var statearr_15162 = state_15148;
(statearr_15162[(10)] = inst_15116__$1);

return statearr_15162;
})();
if(cljs.core.truth_(inst_15119)){
var statearr_15163_15188 = state_15148__$1;
(statearr_15163_15188[(1)] = (8));

} else {
var statearr_15164_15189 = state_15148__$1;
(statearr_15164_15189[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (14))){
var inst_15141 = (state_15148[(2)]);
var inst_15142 = cljs.core.async.close_BANG_.call(null,out);
var state_15148__$1 = (function (){var statearr_15166 = state_15148;
(statearr_15166[(13)] = inst_15141);

return statearr_15166;
})();
var statearr_15167_15190 = state_15148__$1;
(statearr_15167_15190[(2)] = inst_15142);

(statearr_15167_15190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (10))){
var inst_15131 = (state_15148[(2)]);
var state_15148__$1 = state_15148;
var statearr_15168_15191 = state_15148__$1;
(statearr_15168_15191[(2)] = inst_15131);

(statearr_15168_15191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15149 === (8))){
var inst_15112 = (state_15148[(9)]);
var inst_15108 = (state_15148[(7)]);
var inst_15116 = (state_15148[(10)]);
var inst_15121 = inst_15108.push(inst_15112);
var tmp15165 = inst_15108;
var inst_15108__$1 = tmp15165;
var inst_15109 = inst_15116;
var state_15148__$1 = (function (){var statearr_15169 = state_15148;
(statearr_15169[(7)] = inst_15108__$1);

(statearr_15169[(14)] = inst_15121);

(statearr_15169[(8)] = inst_15109);

return statearr_15169;
})();
var statearr_15170_15192 = state_15148__$1;
(statearr_15170_15192[(2)] = null);

(statearr_15170_15192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8178__auto___15178,out))
;
return ((function (switch__8163__auto__,c__8178__auto___15178,out){
return (function() {
var state_machine__8164__auto__ = null;
var state_machine__8164__auto____0 = (function (){
var statearr_15174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15174[(0)] = state_machine__8164__auto__);

(statearr_15174[(1)] = (1));

return statearr_15174;
});
var state_machine__8164__auto____1 = (function (state_15148){
while(true){
var ret_value__8165__auto__ = (function (){try{while(true){
var result__8166__auto__ = switch__8163__auto__.call(null,state_15148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8166__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8166__auto__;
}
break;
}
}catch (e15175){if((e15175 instanceof Object)){
var ex__8167__auto__ = e15175;
var statearr_15176_15193 = state_15148;
(statearr_15176_15193[(5)] = ex__8167__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15148);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15175;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8165__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15194 = state_15148;
state_15148 = G__15194;
continue;
} else {
return ret_value__8165__auto__;
}
break;
}
});
state_machine__8164__auto__ = function(state_15148){
switch(arguments.length){
case 0:
return state_machine__8164__auto____0.call(this);
case 1:
return state_machine__8164__auto____1.call(this,state_15148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__8164__auto____0;
state_machine__8164__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__8164__auto____1;
return state_machine__8164__auto__;
})()
;})(switch__8163__auto__,c__8178__auto___15178,out))
})();
var state__8180__auto__ = (function (){var statearr_15177 = f__8179__auto__.call(null);
(statearr_15177[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8178__auto___15178);

return statearr_15177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8180__auto__);
});})(c__8178__auto___15178,out))
);


return out;
});
partition_by = function(f,ch,buf_or_n){
switch(arguments.length){
case 2:
return partition_by__2.call(this,f,ch);
case 3:
return partition_by__3.call(this,f,ch,buf_or_n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
partition_by.cljs$core$IFn$_invoke$arity$2 = partition_by__2;
partition_by.cljs$core$IFn$_invoke$arity$3 = partition_by__3;
return partition_by;
})()
;

//# sourceMappingURL=async.js.map