(ns overseer.core
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [om.core :as om :include-macros true]
            [sablono.core :as html :refer-macros  [html]]

            [cljs.core.async :refer [put! chan <!]]
            [cljs-http.client :as http]

            ;[overseer.routing :as routing]
            [overseer.stores :as stores]
            ;[overseer.util :as util]
            ))

(defn header [_ owner]
  (reify
    om/IRender
    (render [this]
      (html
        [:nav.navbar.navbar-inverse.navbar-static-top
         [:div.container
          [:div.navbar-header
           [:a.navbar-brand {:href "#"} "Overseer"]]
           [:div#navbar
            [:ul.nav.navbar-nav
             [:li.active [:a {:href "#"} "one"]]
             [:li[:a {:href "#"} "two"]]
             [:li[:a {:href "#"} "three"]]]]]]))))

(defn page-content [app-state owner]
  (reify
    om/IRender
    (render [this]
      (html
        [:div.container
         [:div.row.whitebox.control-bar
          [:div.col-md-4.stat-container
           [:p.stat-number 12]
           [:p.stat-label "Jobs unfinished"]]
          [:div.col-md-4.stat-container
           [:p.stat-number 1024]
           [:p.stat-label "Jobs ready to run"]]
          [:div.col-md-4.stat-container
           [:p.stat-number
            [:a {:href "#/jobs/failed"} 22]]
           [:p.stat-label "Jobs failed today"]]]]))))

(defn load-init-state []
  (let [ch (chan)]
    (go (->> (<! (http/request {:url "/"
                                :method "GET"
                                :accept "application/edn"
                                ;:basic-auth auth-map
                                }))
                 :body
                 (put! ch)))
    ch))

(defn ^:export start []
  ;(async-coordinator/start! stores.core/app-state (:async-coordinator @channels))


  ;(go (let [data (<! (load-init-state))]
  ;      (swap! stores/app-state merge data)))

  (om/root
    header
    stores/app-state
    {;:shared {:channel (:async-coordinator @channels)}
     :target (.getElementById js/document "om-header")})

  (om/root
    page-content
    stores/app-state
    {;:shared {:channel (:async-coordinator @channels)}
     :target (.getElementById js/document "om-page-content")})

  ;(routing/start! {:channel (:async-coordinator @channels)})

  ;; Kick off initial state AJAX load
  ;(go (put! (:async-coordinator @channels)
  ;          (<! (load-init-state))))
  )
