// Compiled by ClojureScript 0.0-2727 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('sablono.interpreter');
goog.require('sablono.util');
goog.require('clojure.walk');
goog.require('clojure.string');
/**
* Add an optional attribute argument to a function that returns a element vector.
*/
sablono.core.wrap_attrs = (function wrap_attrs(func){
return (function() { 
var G__8235__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__8234 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__8234,(0),null);
var body = cljs.core.nthnext.call(null,vec__8234,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__8235 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8236__i = 0, G__8236__a = new Array(arguments.length -  0);
while (G__8236__i < G__8236__a.length) {G__8236__a[G__8236__i] = arguments[G__8236__i + 0]; ++G__8236__i;}
  args = new cljs.core.IndexedSeq(G__8236__a,0);
} 
return G__8235__delegate.call(this,args);};
G__8235.cljs$lang$maxFixedArity = 0;
G__8235.cljs$lang$applyTo = (function (arglist__8237){
var args = cljs.core.seq(arglist__8237);
return G__8235__delegate(args);
});
G__8235.cljs$core$IFn$_invoke$arity$variadic = G__8235__delegate;
return G__8235;
})()
;
});
sablono.core.update_arglists = (function update_arglists(arglists){
var iter__4514__auto__ = (function iter__8242(s__8243){
return (new cljs.core.LazySeq(null,(function (){
var s__8243__$1 = s__8243;
while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__8243__$1);
if(temp__4126__auto__){
var s__8243__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8243__$2)){
var c__4512__auto__ = cljs.core.chunk_first.call(null,s__8243__$2);
var size__4513__auto__ = cljs.core.count.call(null,c__4512__auto__);
var b__8245 = cljs.core.chunk_buffer.call(null,size__4513__auto__);
if((function (){var i__8244 = (0);
while(true){
if((i__8244 < size__4513__auto__)){
var args = cljs.core._nth.call(null,c__4512__auto__,i__8244);
cljs.core.chunk_append.call(null,b__8245,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__8246 = (i__8244 + (1));
i__8244 = G__8246;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8245),iter__8242.call(null,cljs.core.chunk_rest.call(null,s__8243__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8245),null);
}
} else {
var args = cljs.core.first.call(null,s__8243__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),iter__8242.call(null,cljs.core.rest.call(null,s__8243__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4514__auto__.call(null,arglists);
});
/**
* Render `element` as HTML string.
*/
sablono.core.render = (function render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
* Render `element` as HTML string, without React internal attributes.
*/
sablono.core.render_static = (function render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
* Include a list of external stylesheet files.
* @param {...*} var_args
*/
sablono.core.include_css = (function() { 
var include_css__delegate = function (styles){
var iter__4514__auto__ = (function iter__8251(s__8252){
return (new cljs.core.LazySeq(null,(function (){
var s__8252__$1 = s__8252;
while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__8252__$1);
if(temp__4126__auto__){
var s__8252__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8252__$2)){
var c__4512__auto__ = cljs.core.chunk_first.call(null,s__8252__$2);
var size__4513__auto__ = cljs.core.count.call(null,c__4512__auto__);
var b__8254 = cljs.core.chunk_buffer.call(null,size__4513__auto__);
if((function (){var i__8253 = (0);
while(true){
if((i__8253 < size__4513__auto__)){
var style = cljs.core._nth.call(null,c__4512__auto__,i__8253);
cljs.core.chunk_append.call(null,b__8254,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__8255 = (i__8253 + (1));
i__8253 = G__8255;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8254),iter__8251.call(null,cljs.core.chunk_rest.call(null,s__8252__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8254),null);
}
} else {
var style = cljs.core.first.call(null,s__8252__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),iter__8251.call(null,cljs.core.rest.call(null,s__8252__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4514__auto__.call(null,styles);
};
var include_css = function (var_args){
var styles = null;
if (arguments.length > 0) {
var G__8256__i = 0, G__8256__a = new Array(arguments.length -  0);
while (G__8256__i < G__8256__a.length) {G__8256__a[G__8256__i] = arguments[G__8256__i + 0]; ++G__8256__i;}
  styles = new cljs.core.IndexedSeq(G__8256__a,0);
} 
return include_css__delegate.call(this,styles);};
include_css.cljs$lang$maxFixedArity = 0;
include_css.cljs$lang$applyTo = (function (arglist__8257){
var styles = cljs.core.seq(arglist__8257);
return include_css__delegate(styles);
});
include_css.cljs$core$IFn$_invoke$arity$variadic = include_css__delegate;
return include_css;
})()
;
/**
* Include the JavaScript library at `src`.
*/
sablono.core.include_js = (function include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
* Include Facebook's React JavaScript library.
*/
sablono.core.include_react = (function include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
* Wraps some content in a HTML hyperlink with the supplied URL.
* @param {...*} var_args
*/
sablono.core.link_to8258 = (function() { 
var link_to8258__delegate = function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
};
var link_to8258 = function (url,var_args){
var content = null;
if (arguments.length > 1) {
var G__8259__i = 0, G__8259__a = new Array(arguments.length -  1);
while (G__8259__i < G__8259__a.length) {G__8259__a[G__8259__i] = arguments[G__8259__i + 1]; ++G__8259__i;}
  content = new cljs.core.IndexedSeq(G__8259__a,0);
} 
return link_to8258__delegate.call(this,url,content);};
link_to8258.cljs$lang$maxFixedArity = 1;
link_to8258.cljs$lang$applyTo = (function (arglist__8260){
var url = cljs.core.first(arglist__8260);
var content = cljs.core.rest(arglist__8260);
return link_to8258__delegate(url,content);
});
link_to8258.cljs$core$IFn$_invoke$arity$variadic = link_to8258__delegate;
return link_to8258;
})()
;

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to8258);
/**
* Wraps some content in a HTML hyperlink with the supplied e-mail
* address. If no content provided use the e-mail address as content.
* @param {...*} var_args
*/
sablono.core.mail_to8261 = (function() { 
var mail_to8261__delegate = function (e_mail,p__8262){
var vec__8264 = p__8262;
var content = cljs.core.nth.call(null,vec__8264,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__3758__auto__ = content;
if(cljs.core.truth_(or__3758__auto__)){
return or__3758__auto__;
} else {
return e_mail;
}
})()], null);
};
var mail_to8261 = function (e_mail,var_args){
var p__8262 = null;
if (arguments.length > 1) {
var G__8265__i = 0, G__8265__a = new Array(arguments.length -  1);
while (G__8265__i < G__8265__a.length) {G__8265__a[G__8265__i] = arguments[G__8265__i + 1]; ++G__8265__i;}
  p__8262 = new cljs.core.IndexedSeq(G__8265__a,0);
} 
return mail_to8261__delegate.call(this,e_mail,p__8262);};
mail_to8261.cljs$lang$maxFixedArity = 1;
mail_to8261.cljs$lang$applyTo = (function (arglist__8266){
var e_mail = cljs.core.first(arglist__8266);
var p__8262 = cljs.core.rest(arglist__8266);
return mail_to8261__delegate(e_mail,p__8262);
});
mail_to8261.cljs$core$IFn$_invoke$arity$variadic = mail_to8261__delegate;
return mail_to8261;
})()
;

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to8261);
/**
* Wrap a collection in an unordered list.
*/
sablono.core.unordered_list8267 = (function unordered_list8267(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4514__auto__ = (function iter__8272(s__8273){
return (new cljs.core.LazySeq(null,(function (){
var s__8273__$1 = s__8273;
while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__8273__$1);
if(temp__4126__auto__){
var s__8273__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8273__$2)){
var c__4512__auto__ = cljs.core.chunk_first.call(null,s__8273__$2);
var size__4513__auto__ = cljs.core.count.call(null,c__4512__auto__);
var b__8275 = cljs.core.chunk_buffer.call(null,size__4513__auto__);
if((function (){var i__8274 = (0);
while(true){
if((i__8274 < size__4513__auto__)){
var x = cljs.core._nth.call(null,c__4512__auto__,i__8274);
cljs.core.chunk_append.call(null,b__8275,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__8276 = (i__8274 + (1));
i__8274 = G__8276;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8275),iter__8272.call(null,cljs.core.chunk_rest.call(null,s__8273__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8275),null);
}
} else {
var x = cljs.core.first.call(null,s__8273__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),iter__8272.call(null,cljs.core.rest.call(null,s__8273__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4514__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list8267);
/**
* Wrap a collection in an ordered list.
*/
sablono.core.ordered_list8277 = (function ordered_list8277(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4514__auto__ = (function iter__8282(s__8283){
return (new cljs.core.LazySeq(null,(function (){
var s__8283__$1 = s__8283;
while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__8283__$1);
if(temp__4126__auto__){
var s__8283__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8283__$2)){
var c__4512__auto__ = cljs.core.chunk_first.call(null,s__8283__$2);
var size__4513__auto__ = cljs.core.count.call(null,c__4512__auto__);
var b__8285 = cljs.core.chunk_buffer.call(null,size__4513__auto__);
if((function (){var i__8284 = (0);
while(true){
if((i__8284 < size__4513__auto__)){
var x = cljs.core._nth.call(null,c__4512__auto__,i__8284);
cljs.core.chunk_append.call(null,b__8285,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__8286 = (i__8284 + (1));
i__8284 = G__8286;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8285),iter__8282.call(null,cljs.core.chunk_rest.call(null,s__8283__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8285),null);
}
} else {
var x = cljs.core.first.call(null,s__8283__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),iter__8282.call(null,cljs.core.rest.call(null,s__8283__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4514__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list8277);
/**
* Create an image element.
*/
sablono.core.image8287 = (function() {
var image8287 = null;
var image8287__1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});
var image8287__2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});
image8287 = function(src,alt){
switch(arguments.length){
case 1:
return image8287__1.call(this,src);
case 2:
return image8287__2.call(this,src,alt);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
image8287.cljs$core$IFn$_invoke$arity$1 = image8287__1;
image8287.cljs$core$IFn$_invoke$arity$2 = image8287__2;
return image8287;
})()
;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image8287);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
* Create a field name from the supplied argument the current field group.
*/
sablono.core.make_name = (function make_name(name){
return cljs.core.reduce.call(null,(function (p1__8288_SHARP_,p2__8289_SHARP_){
return [cljs.core.str(p1__8288_SHARP_),cljs.core.str("["),cljs.core.str(p2__8289_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Create a field id from the supplied argument and current field group.
*/
sablono.core.make_id = (function make_id(name){
return cljs.core.reduce.call(null,(function (p1__8290_SHARP_,p2__8291_SHARP_){
return [cljs.core.str(p1__8290_SHARP_),cljs.core.str("-"),cljs.core.str(p2__8291_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Creates a new <input> element.
*/
sablono.core.input_field_STAR_ = (function input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
* Creates a color input field.
*/
sablono.core.color_field8292 = (function() {
var color_field8292 = null;
var color_field8292__1 = (function (name__5841__auto__){
return color_field8292.call(null,name__5841__auto__,null);
});
var color_field8292__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__5841__auto__,value__5842__auto__);
});
color_field8292 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return color_field8292__1.call(this,name__5841__auto__);
case 2:
return color_field8292__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
color_field8292.cljs$core$IFn$_invoke$arity$1 = color_field8292__1;
color_field8292.cljs$core$IFn$_invoke$arity$2 = color_field8292__2;
return color_field8292;
})()
;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field8292);

/**
* Creates a date input field.
*/
sablono.core.date_field8293 = (function() {
var date_field8293 = null;
var date_field8293__1 = (function (name__5841__auto__){
return date_field8293.call(null,name__5841__auto__,null);
});
var date_field8293__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__5841__auto__,value__5842__auto__);
});
date_field8293 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return date_field8293__1.call(this,name__5841__auto__);
case 2:
return date_field8293__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
date_field8293.cljs$core$IFn$_invoke$arity$1 = date_field8293__1;
date_field8293.cljs$core$IFn$_invoke$arity$2 = date_field8293__2;
return date_field8293;
})()
;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field8293);

/**
* Creates a datetime input field.
*/
sablono.core.datetime_field8294 = (function() {
var datetime_field8294 = null;
var datetime_field8294__1 = (function (name__5841__auto__){
return datetime_field8294.call(null,name__5841__auto__,null);
});
var datetime_field8294__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__5841__auto__,value__5842__auto__);
});
datetime_field8294 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return datetime_field8294__1.call(this,name__5841__auto__);
case 2:
return datetime_field8294__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
datetime_field8294.cljs$core$IFn$_invoke$arity$1 = datetime_field8294__1;
datetime_field8294.cljs$core$IFn$_invoke$arity$2 = datetime_field8294__2;
return datetime_field8294;
})()
;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field8294);

/**
* Creates a datetime-local input field.
*/
sablono.core.datetime_local_field8295 = (function() {
var datetime_local_field8295 = null;
var datetime_local_field8295__1 = (function (name__5841__auto__){
return datetime_local_field8295.call(null,name__5841__auto__,null);
});
var datetime_local_field8295__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__5841__auto__,value__5842__auto__);
});
datetime_local_field8295 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return datetime_local_field8295__1.call(this,name__5841__auto__);
case 2:
return datetime_local_field8295__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
datetime_local_field8295.cljs$core$IFn$_invoke$arity$1 = datetime_local_field8295__1;
datetime_local_field8295.cljs$core$IFn$_invoke$arity$2 = datetime_local_field8295__2;
return datetime_local_field8295;
})()
;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field8295);

/**
* Creates a email input field.
*/
sablono.core.email_field8296 = (function() {
var email_field8296 = null;
var email_field8296__1 = (function (name__5841__auto__){
return email_field8296.call(null,name__5841__auto__,null);
});
var email_field8296__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__5841__auto__,value__5842__auto__);
});
email_field8296 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return email_field8296__1.call(this,name__5841__auto__);
case 2:
return email_field8296__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
email_field8296.cljs$core$IFn$_invoke$arity$1 = email_field8296__1;
email_field8296.cljs$core$IFn$_invoke$arity$2 = email_field8296__2;
return email_field8296;
})()
;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field8296);

/**
* Creates a file input field.
*/
sablono.core.file_field8297 = (function() {
var file_field8297 = null;
var file_field8297__1 = (function (name__5841__auto__){
return file_field8297.call(null,name__5841__auto__,null);
});
var file_field8297__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__5841__auto__,value__5842__auto__);
});
file_field8297 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return file_field8297__1.call(this,name__5841__auto__);
case 2:
return file_field8297__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
file_field8297.cljs$core$IFn$_invoke$arity$1 = file_field8297__1;
file_field8297.cljs$core$IFn$_invoke$arity$2 = file_field8297__2;
return file_field8297;
})()
;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field8297);

/**
* Creates a hidden input field.
*/
sablono.core.hidden_field8298 = (function() {
var hidden_field8298 = null;
var hidden_field8298__1 = (function (name__5841__auto__){
return hidden_field8298.call(null,name__5841__auto__,null);
});
var hidden_field8298__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__5841__auto__,value__5842__auto__);
});
hidden_field8298 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return hidden_field8298__1.call(this,name__5841__auto__);
case 2:
return hidden_field8298__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hidden_field8298.cljs$core$IFn$_invoke$arity$1 = hidden_field8298__1;
hidden_field8298.cljs$core$IFn$_invoke$arity$2 = hidden_field8298__2;
return hidden_field8298;
})()
;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field8298);

/**
* Creates a month input field.
*/
sablono.core.month_field8299 = (function() {
var month_field8299 = null;
var month_field8299__1 = (function (name__5841__auto__){
return month_field8299.call(null,name__5841__auto__,null);
});
var month_field8299__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__5841__auto__,value__5842__auto__);
});
month_field8299 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return month_field8299__1.call(this,name__5841__auto__);
case 2:
return month_field8299__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
month_field8299.cljs$core$IFn$_invoke$arity$1 = month_field8299__1;
month_field8299.cljs$core$IFn$_invoke$arity$2 = month_field8299__2;
return month_field8299;
})()
;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field8299);

/**
* Creates a number input field.
*/
sablono.core.number_field8300 = (function() {
var number_field8300 = null;
var number_field8300__1 = (function (name__5841__auto__){
return number_field8300.call(null,name__5841__auto__,null);
});
var number_field8300__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__5841__auto__,value__5842__auto__);
});
number_field8300 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return number_field8300__1.call(this,name__5841__auto__);
case 2:
return number_field8300__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
number_field8300.cljs$core$IFn$_invoke$arity$1 = number_field8300__1;
number_field8300.cljs$core$IFn$_invoke$arity$2 = number_field8300__2;
return number_field8300;
})()
;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field8300);

/**
* Creates a password input field.
*/
sablono.core.password_field8301 = (function() {
var password_field8301 = null;
var password_field8301__1 = (function (name__5841__auto__){
return password_field8301.call(null,name__5841__auto__,null);
});
var password_field8301__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__5841__auto__,value__5842__auto__);
});
password_field8301 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return password_field8301__1.call(this,name__5841__auto__);
case 2:
return password_field8301__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
password_field8301.cljs$core$IFn$_invoke$arity$1 = password_field8301__1;
password_field8301.cljs$core$IFn$_invoke$arity$2 = password_field8301__2;
return password_field8301;
})()
;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field8301);

/**
* Creates a range input field.
*/
sablono.core.range_field8302 = (function() {
var range_field8302 = null;
var range_field8302__1 = (function (name__5841__auto__){
return range_field8302.call(null,name__5841__auto__,null);
});
var range_field8302__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__5841__auto__,value__5842__auto__);
});
range_field8302 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return range_field8302__1.call(this,name__5841__auto__);
case 2:
return range_field8302__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
range_field8302.cljs$core$IFn$_invoke$arity$1 = range_field8302__1;
range_field8302.cljs$core$IFn$_invoke$arity$2 = range_field8302__2;
return range_field8302;
})()
;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field8302);

/**
* Creates a search input field.
*/
sablono.core.search_field8303 = (function() {
var search_field8303 = null;
var search_field8303__1 = (function (name__5841__auto__){
return search_field8303.call(null,name__5841__auto__,null);
});
var search_field8303__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__5841__auto__,value__5842__auto__);
});
search_field8303 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return search_field8303__1.call(this,name__5841__auto__);
case 2:
return search_field8303__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
search_field8303.cljs$core$IFn$_invoke$arity$1 = search_field8303__1;
search_field8303.cljs$core$IFn$_invoke$arity$2 = search_field8303__2;
return search_field8303;
})()
;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field8303);

/**
* Creates a tel input field.
*/
sablono.core.tel_field8304 = (function() {
var tel_field8304 = null;
var tel_field8304__1 = (function (name__5841__auto__){
return tel_field8304.call(null,name__5841__auto__,null);
});
var tel_field8304__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__5841__auto__,value__5842__auto__);
});
tel_field8304 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return tel_field8304__1.call(this,name__5841__auto__);
case 2:
return tel_field8304__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tel_field8304.cljs$core$IFn$_invoke$arity$1 = tel_field8304__1;
tel_field8304.cljs$core$IFn$_invoke$arity$2 = tel_field8304__2;
return tel_field8304;
})()
;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field8304);

/**
* Creates a text input field.
*/
sablono.core.text_field8305 = (function() {
var text_field8305 = null;
var text_field8305__1 = (function (name__5841__auto__){
return text_field8305.call(null,name__5841__auto__,null);
});
var text_field8305__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__5841__auto__,value__5842__auto__);
});
text_field8305 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return text_field8305__1.call(this,name__5841__auto__);
case 2:
return text_field8305__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_field8305.cljs$core$IFn$_invoke$arity$1 = text_field8305__1;
text_field8305.cljs$core$IFn$_invoke$arity$2 = text_field8305__2;
return text_field8305;
})()
;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field8305);

/**
* Creates a time input field.
*/
sablono.core.time_field8306 = (function() {
var time_field8306 = null;
var time_field8306__1 = (function (name__5841__auto__){
return time_field8306.call(null,name__5841__auto__,null);
});
var time_field8306__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__5841__auto__,value__5842__auto__);
});
time_field8306 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return time_field8306__1.call(this,name__5841__auto__);
case 2:
return time_field8306__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
time_field8306.cljs$core$IFn$_invoke$arity$1 = time_field8306__1;
time_field8306.cljs$core$IFn$_invoke$arity$2 = time_field8306__2;
return time_field8306;
})()
;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field8306);

/**
* Creates a url input field.
*/
sablono.core.url_field8307 = (function() {
var url_field8307 = null;
var url_field8307__1 = (function (name__5841__auto__){
return url_field8307.call(null,name__5841__auto__,null);
});
var url_field8307__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__5841__auto__,value__5842__auto__);
});
url_field8307 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return url_field8307__1.call(this,name__5841__auto__);
case 2:
return url_field8307__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
url_field8307.cljs$core$IFn$_invoke$arity$1 = url_field8307__1;
url_field8307.cljs$core$IFn$_invoke$arity$2 = url_field8307__2;
return url_field8307;
})()
;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field8307);

/**
* Creates a week input field.
*/
sablono.core.week_field8308 = (function() {
var week_field8308 = null;
var week_field8308__1 = (function (name__5841__auto__){
return week_field8308.call(null,name__5841__auto__,null);
});
var week_field8308__2 = (function (name__5841__auto__,value__5842__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__5841__auto__,value__5842__auto__);
});
week_field8308 = function(name__5841__auto__,value__5842__auto__){
switch(arguments.length){
case 1:
return week_field8308__1.call(this,name__5841__auto__);
case 2:
return week_field8308__2.call(this,name__5841__auto__,value__5842__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
week_field8308.cljs$core$IFn$_invoke$arity$1 = week_field8308__1;
week_field8308.cljs$core$IFn$_invoke$arity$2 = week_field8308__2;
return week_field8308;
})()
;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field8308);
sablono.core.file_upload = sablono.core.file_field;
/**
* Creates a check box.
*/
sablono.core.check_box8309 = (function() {
var check_box8309 = null;
var check_box8309__1 = (function (name){
return check_box8309.call(null,name,null);
});
var check_box8309__2 = (function (name,checked_QMARK_){
return check_box8309.call(null,name,checked_QMARK_,"true");
});
var check_box8309__3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});
check_box8309 = function(name,checked_QMARK_,value){
switch(arguments.length){
case 1:
return check_box8309__1.call(this,name);
case 2:
return check_box8309__2.call(this,name,checked_QMARK_);
case 3:
return check_box8309__3.call(this,name,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
check_box8309.cljs$core$IFn$_invoke$arity$1 = check_box8309__1;
check_box8309.cljs$core$IFn$_invoke$arity$2 = check_box8309__2;
check_box8309.cljs$core$IFn$_invoke$arity$3 = check_box8309__3;
return check_box8309;
})()
;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box8309);
/**
* Creates a radio button.
*/
sablono.core.radio_button8310 = (function() {
var radio_button8310 = null;
var radio_button8310__1 = (function (group){
return radio_button8310.call(null,group,null);
});
var radio_button8310__2 = (function (group,checked_QMARK_){
return radio_button8310.call(null,group,checked_QMARK_,"true");
});
var radio_button8310__3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});
radio_button8310 = function(group,checked_QMARK_,value){
switch(arguments.length){
case 1:
return radio_button8310__1.call(this,group);
case 2:
return radio_button8310__2.call(this,group,checked_QMARK_);
case 3:
return radio_button8310__3.call(this,group,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
radio_button8310.cljs$core$IFn$_invoke$arity$1 = radio_button8310__1;
radio_button8310.cljs$core$IFn$_invoke$arity$2 = radio_button8310__2;
radio_button8310.cljs$core$IFn$_invoke$arity$3 = radio_button8310__3;
return radio_button8310;
})()
;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button8310);
/**
* Creates a seq of option tags from a collection.
*/
sablono.core.select_options8311 = (function() {
var select_options8311 = null;
var select_options8311__1 = (function (coll){
return select_options8311.call(null,coll,null);
});
var select_options8311__2 = (function (coll,selected){
var iter__4514__auto__ = (function iter__8320(s__8321){
return (new cljs.core.LazySeq(null,(function (){
var s__8321__$1 = s__8321;
while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__8321__$1);
if(temp__4126__auto__){
var s__8321__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__8321__$2)){
var c__4512__auto__ = cljs.core.chunk_first.call(null,s__8321__$2);
var size__4513__auto__ = cljs.core.count.call(null,c__4512__auto__);
var b__8323 = cljs.core.chunk_buffer.call(null,size__4513__auto__);
if((function (){var i__8322 = (0);
while(true){
if((i__8322 < size__4513__auto__)){
var x = cljs.core._nth.call(null,c__4512__auto__,i__8322);
cljs.core.chunk_append.call(null,b__8323,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__8326 = x;
var text = cljs.core.nth.call(null,vec__8326,(0),null);
var val = cljs.core.nth.call(null,vec__8326,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__8326,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),select_options8311.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__8328 = (i__8322 + (1));
i__8322 = G__8328;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8323),iter__8320.call(null,cljs.core.chunk_rest.call(null,s__8321__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__8323),null);
}
} else {
var x = cljs.core.first.call(null,s__8321__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__8327 = x;
var text = cljs.core.nth.call(null,vec__8327,(0),null);
var val = cljs.core.nth.call(null,vec__8327,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__8327,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),select_options8311.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),iter__8320.call(null,cljs.core.rest.call(null,s__8321__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4514__auto__.call(null,coll);
});
select_options8311 = function(coll,selected){
switch(arguments.length){
case 1:
return select_options8311__1.call(this,coll);
case 2:
return select_options8311__2.call(this,coll,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
select_options8311.cljs$core$IFn$_invoke$arity$1 = select_options8311__1;
select_options8311.cljs$core$IFn$_invoke$arity$2 = select_options8311__2;
return select_options8311;
})()
;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options8311);
/**
* Creates a drop-down box using the <select> tag.
*/
sablono.core.drop_down8329 = (function() {
var drop_down8329 = null;
var drop_down8329__2 = (function (name,options){
return drop_down8329.call(null,name,options,null);
});
var drop_down8329__3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});
drop_down8329 = function(name,options,selected){
switch(arguments.length){
case 2:
return drop_down8329__2.call(this,name,options);
case 3:
return drop_down8329__3.call(this,name,options,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_down8329.cljs$core$IFn$_invoke$arity$2 = drop_down8329__2;
drop_down8329.cljs$core$IFn$_invoke$arity$3 = drop_down8329__3;
return drop_down8329;
})()
;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down8329);
/**
* Creates a text area element.
*/
sablono.core.text_area8330 = (function() {
var text_area8330 = null;
var text_area8330__1 = (function (name){
return text_area8330.call(null,name,null);
});
var text_area8330__2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
text_area8330 = function(name,value){
switch(arguments.length){
case 1:
return text_area8330__1.call(this,name);
case 2:
return text_area8330__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_area8330.cljs$core$IFn$_invoke$arity$1 = text_area8330__1;
text_area8330.cljs$core$IFn$_invoke$arity$2 = text_area8330__2;
return text_area8330;
})()
;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area8330);
/**
* Creates a label for an input field with the supplied name.
*/
sablono.core.label8331 = (function label8331(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label8331);
/**
* Creates a submit button.
*/
sablono.core.submit_button8332 = (function submit_button8332(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button8332);
/**
* Creates a form reset button.
*/
sablono.core.reset_button8333 = (function reset_button8333(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button8333);
/**
* Create a form that points to a particular method and route.
* e.g. (form-to [:put "/post"]
* ...)
* @param {...*} var_args
*/
sablono.core.form_to8334 = (function() { 
var form_to8334__delegate = function (p__8335,body){
var vec__8337 = p__8335;
var method = cljs.core.nth.call(null,vec__8337,(0),null);
var action = cljs.core.nth.call(null,vec__8337,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
};
var form_to8334 = function (p__8335,var_args){
var body = null;
if (arguments.length > 1) {
var G__8338__i = 0, G__8338__a = new Array(arguments.length -  1);
while (G__8338__i < G__8338__a.length) {G__8338__a[G__8338__i] = arguments[G__8338__i + 1]; ++G__8338__i;}
  body = new cljs.core.IndexedSeq(G__8338__a,0);
} 
return form_to8334__delegate.call(this,p__8335,body);};
form_to8334.cljs$lang$maxFixedArity = 1;
form_to8334.cljs$lang$applyTo = (function (arglist__8339){
var p__8335 = cljs.core.first(arglist__8339);
var body = cljs.core.rest(arglist__8339);
return form_to8334__delegate(p__8335,body);
});
form_to8334.cljs$core$IFn$_invoke$arity$variadic = form_to8334__delegate;
return form_to8334;
})()
;

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to8334);

//# sourceMappingURL=core.js.map