(ns fierycod.graalvm-agent-helper.core)

(def ^:private AGENT_EXECUTOR "native-agent")

(defmacro in-context
  "Executes body in safe agent context for native configuration generation.
  Useful when it's hard for agent payloads to cover all logic branches.

  *In order to generate native-configuration run:*

  ```
  make native-gen-conf
  ```

  *Usage:*

  ```
  (in-context
    (some-body-which-has-to-be-inspected-via-graalvm))
  ```

  You can safely leave agent-context calls in the code. Agent context not set results in no code being generated by macro.
  "
  [& body]
  (if-not (System/getenv "USE_AGENT_CONTEXT")
    nil
    `(when (= (System/getProperty "executor") @#'fierycod.graalvm-agent-helper.core/AGENT_EXECUTOR)
       (try (do ~@body)
            (catch Exception err#
              (println "Exception in agent-context: " err#))))))
