(defproject io.github.awkay/ghostwheel "0.3.0-SNAPSHOT"
  :description "Hassle-free clojure.spec, automatic generative testing, side effect detection, and evaluation tracing for Clojure(-Script)"
  :url "https://github.com/awkay/ghostwheel"
  :license {:name "Eclipse Public License"
            :url  "https://choosealicense.com/licenses/epl-2.0/"}
  :repositories {"clojars" {:url           "https://clojars.org/repo"
                            :sign-releases true}}
  :dependencies [[org.clojure/clojure "1.9.0" :scope "provided"]
                 [org.clojure/clojurescript "1.10.339" :scope "provided"]
                 [org.clojure/spec.alpha "0.2.168" :scope "provided"]
                 [org.clojure/test.check "0.10.0-alpha3" :scope "provided"]
                 [orchestra "2017.11.12-1"]
                 [expound "0.7.1"]]
  :plugins [[lein-doo "0.1.10"]]
  :source-paths ["src"]
  :clean-targets ^{:protect false} ["target" "resources"]
  :cljsbuild {:builds [{:id           "dev-test"
                        :source-paths ["src" "test"]
                        :compiler     {:main          ghostwheel.dev-test-runner
                                       :asset-path    "base/resources/test/dev"
                                       :output-dir    "resources/test/dev"
                                       :output-to     "resources/test/dev.js"
                                       :optimizations :none
                                       :ghostwheel    true}}
                       {:id           "prod-test"
                        :source-paths ["src" "test"]
                        :compiler     {:main          ghostwheel.prod-test-runner
                                       :asset-path    "base/resources/test/prod"
                                       :output-dir    "resources/test/prod"
                                       :output-to     "resources/test/prod.js"
                                       :optimizations :none}}]})

