(ns dots.node.fs.big-int-stats-fs
  (:refer-clojure :exclude [type]))

(defn type
  "Type of file system."
  ^js [big-int-stats-fs]
  (.-type ^js big-int-stats-fs))

(defn set-type!
  "Type of file system."
  ^js [big-int-stats-fs value]
  (set! (.-type ^js big-int-stats-fs) value))

(defn bsize
  "Optimal transfer block size."
  ^js [big-int-stats-fs]
  (.-bsize ^js big-int-stats-fs))

(defn set-bsize!
  "Optimal transfer block size."
  ^js [big-int-stats-fs value]
  (set! (.-bsize ^js big-int-stats-fs) value))

(defn blocks
  "Total data blocks in file system."
  ^js [big-int-stats-fs]
  (.-blocks ^js big-int-stats-fs))

(defn set-blocks!
  "Total data blocks in file system."
  ^js [big-int-stats-fs value]
  (set! (.-blocks ^js big-int-stats-fs) value))

(defn bfree
  "Free blocks in file system."
  ^js [big-int-stats-fs]
  (.-bfree ^js big-int-stats-fs))

(defn set-bfree!
  "Free blocks in file system."
  ^js [big-int-stats-fs value]
  (set! (.-bfree ^js big-int-stats-fs) value))

(defn bavail
  "Available blocks for unprivileged users"
  ^js [big-int-stats-fs]
  (.-bavail ^js big-int-stats-fs))

(defn set-bavail!
  "Available blocks for unprivileged users"
  ^js [big-int-stats-fs value]
  (set! (.-bavail ^js big-int-stats-fs) value))

(defn files
  "Total file nodes in file system."
  ^js [big-int-stats-fs]
  (.-files ^js big-int-stats-fs))

(defn set-files!
  "Total file nodes in file system."
  ^js [big-int-stats-fs value]
  (set! (.-files ^js big-int-stats-fs) value))

(defn ffree
  "Free file nodes in file system."
  ^js [big-int-stats-fs]
  (.-ffree ^js big-int-stats-fs))

(defn set-ffree!
  "Free file nodes in file system."
  ^js [big-int-stats-fs value]
  (set! (.-ffree ^js big-int-stats-fs) value))
