(ns dots.node.fs.dirent
  "A representation of a directory entry, which can be a file or a subdirectory
   within the directory, as returned by reading from an `fs.Dir`. The
   directory entry is a combination of the file name and file type pairs.
   
   Additionally, when {@link readdir } or {@link readdirSync } is called with
   the `withFileTypes` option set to `true`, the resulting array is filled with `fs.Dirent` objects, rather than strings or `Buffer` s."
  (:refer-clojure :exclude [name]))

(defn file?
  "Returns `true` if the `fs.Dirent` object describes a regular file.
   
   **Returns:** `boolean`"
  ^js [dirent]
  (.isFile ^js dirent))

(defn directory?
  "Returns `true` if the `fs.Dirent` object describes a file system
   directory.
   
   **Returns:** `boolean`"
  ^js [dirent]
  (.isDirectory ^js dirent))

(defn block-device?
  "Returns `true` if the `fs.Dirent` object describes a block device.
   
   **Returns:** `boolean`"
  ^js [dirent]
  (.isBlockDevice ^js dirent))

(defn character-device?
  "Returns `true` if the `fs.Dirent` object describes a character device.
   
   **Returns:** `boolean`"
  ^js [dirent]
  (.isCharacterDevice ^js dirent))

(defn symbolic-link?
  "Returns `true` if the `fs.Dirent` object describes a symbolic link.
   
   **Returns:** `boolean`"
  ^js [dirent]
  (.isSymbolicLink ^js dirent))

(defn fifo?
  "Returns `true` if the `fs.Dirent` object describes a first-in-first-out
   (FIFO) pipe.
   
   **Returns:** `boolean`"
  ^js [dirent]
  (.isFIFO ^js dirent))

(defn socket?
  "Returns `true` if the `fs.Dirent` object describes a socket.
   
   **Returns:** `boolean`"
  ^js [dirent]
  (.isSocket ^js dirent))

(defn name
  "The file name that this `fs.Dirent` object refers to. The type of this
   value is determined by the `options.encoding` passed to {@link readdir } or {@link readdirSync }."
  ^js [dirent]
  (.-name ^js dirent))

(defn set-name!
  "The file name that this `fs.Dirent` object refers to. The type of this
   value is determined by the `options.encoding` passed to {@link readdir } or {@link readdirSync }."
  ^js [dirent value]
  (set! (.-name ^js dirent) value))

(defn parent-path
  "The base path that this `fs.Dirent` object refers to."
  ^js [dirent]
  (.-parentPath ^js dirent))

(defn set-parent-path!
  "The base path that this `fs.Dirent` object refers to."
  ^js [dirent value]
  (set! (.-parentPath ^js dirent) value))

(defn path
  "Alias for `dirent.parentPath`."
  ^js [dirent]
  (.-path ^js dirent))

(defn set-path!
  "Alias for `dirent.parentPath`."
  ^js [dirent value]
  (set! (.-path ^js dirent) value))
