(ns dots.node.fs.stats-fs
  "Provides information about a mounted file system.
   
   Objects returned from {@link statfs } and its synchronous counterpart are of
   this type. If `bigint` in the `options` passed to those methods is `true`, the
   numeric values will be `bigint` instead of `number`.
   
   ```console
   StatFs {
     type: 1397114950,
     bsize: 4096,
     blocks: 121938943,
     bfree: 61058895,
     bavail: 61058895,
     files: 999,
     ffree: 1000000
   }
   ```
   
   `bigint` version:
   
   ```console
   StatFs {
     type: 1397114950n,
     bsize: 4096n,
     blocks: 121938943n,
     bfree: 61058895n,
     bavail: 61058895n,
     files: 999n,
     ffree: 1000000n
   }
   ```"
  (:refer-clojure :exclude [type]))

(defn type
  "Type of file system."
  ^js [stats-fs]
  (.-type ^js stats-fs))

(defn set-type!
  "Type of file system."
  ^js [stats-fs value]
  (set! (.-type ^js stats-fs) value))

(defn bsize
  "Optimal transfer block size."
  ^js [stats-fs]
  (.-bsize ^js stats-fs))

(defn set-bsize!
  "Optimal transfer block size."
  ^js [stats-fs value]
  (set! (.-bsize ^js stats-fs) value))

(defn blocks
  "Total data blocks in file system."
  ^js [stats-fs]
  (.-blocks ^js stats-fs))

(defn set-blocks!
  "Total data blocks in file system."
  ^js [stats-fs value]
  (set! (.-blocks ^js stats-fs) value))

(defn bfree
  "Free blocks in file system."
  ^js [stats-fs]
  (.-bfree ^js stats-fs))

(defn set-bfree!
  "Free blocks in file system."
  ^js [stats-fs value]
  (set! (.-bfree ^js stats-fs) value))

(defn bavail
  "Available blocks for unprivileged users"
  ^js [stats-fs]
  (.-bavail ^js stats-fs))

(defn set-bavail!
  "Available blocks for unprivileged users"
  ^js [stats-fs value]
  (set! (.-bavail ^js stats-fs) value))

(defn files
  "Total file nodes in file system."
  ^js [stats-fs]
  (.-files ^js stats-fs))

(defn set-files!
  "Total file nodes in file system."
  ^js [stats-fs value]
  (set! (.-files ^js stats-fs) value))

(defn ffree
  "Free file nodes in file system."
  ^js [stats-fs]
  (.-ffree ^js stats-fs))

(defn set-ffree!
  "Free file nodes in file system."
  ^js [stats-fs value]
  (set! (.-ffree ^js stats-fs) value))
