(ns dots.node.fs.stats-fs-base
  (:refer-clojure :exclude [type]))

(defn type
  "Type of file system."
  ^js [stats-fs-base]
  (.-type ^js stats-fs-base))

(defn set-type!
  "Type of file system."
  ^js [stats-fs-base value]
  (set! (.-type ^js stats-fs-base) value))

(defn bsize
  "Optimal transfer block size."
  ^js [stats-fs-base]
  (.-bsize ^js stats-fs-base))

(defn set-bsize!
  "Optimal transfer block size."
  ^js [stats-fs-base value]
  (set! (.-bsize ^js stats-fs-base) value))

(defn blocks
  "Total data blocks in file system."
  ^js [stats-fs-base]
  (.-blocks ^js stats-fs-base))

(defn set-blocks!
  "Total data blocks in file system."
  ^js [stats-fs-base value]
  (set! (.-blocks ^js stats-fs-base) value))

(defn bfree
  "Free blocks in file system."
  ^js [stats-fs-base]
  (.-bfree ^js stats-fs-base))

(defn set-bfree!
  "Free blocks in file system."
  ^js [stats-fs-base value]
  (set! (.-bfree ^js stats-fs-base) value))

(defn bavail
  "Available blocks for unprivileged users"
  ^js [stats-fs-base]
  (.-bavail ^js stats-fs-base))

(defn set-bavail!
  "Available blocks for unprivileged users"
  ^js [stats-fs-base value]
  (set! (.-bavail ^js stats-fs-base) value))

(defn files
  "Total file nodes in file system."
  ^js [stats-fs-base]
  (.-files ^js stats-fs-base))

(defn set-files!
  "Total file nodes in file system."
  ^js [stats-fs-base value]
  (set! (.-files ^js stats-fs-base) value))

(defn ffree
  "Free file nodes in file system."
  ^js [stats-fs-base]
  (.-ffree ^js stats-fs-base))

(defn set-ffree!
  "Free file nodes in file system."
  ^js [stats-fs-base value]
  (set! (.-ffree ^js stats-fs-base) value))
