(ns dots.node.path.parsed-path
  "A parsed path object generated by path.parse() or consumed by path.format()."
  (:refer-clojure :exclude [name]))

(defn root
  "The root of the path such as '/' or 'c:\\'"
  ^js [parsed-path]
  (.-root ^js parsed-path))

(defn set-root!
  "The root of the path such as '/' or 'c:\\'"
  ^js [parsed-path value]
  (set! (.-root ^js parsed-path) value))

(defn dir
  "The full directory path such as '/home/user/dir' or 'c:\\path\\dir'"
  ^js [parsed-path]
  (.-dir ^js parsed-path))

(defn set-dir!
  "The full directory path such as '/home/user/dir' or 'c:\\path\\dir'"
  ^js [parsed-path value]
  (set! (.-dir ^js parsed-path) value))

(defn base
  "The file name including extension (if any) such as 'index.html'"
  ^js [parsed-path]
  (.-base ^js parsed-path))

(defn set-base!
  "The file name including extension (if any) such as 'index.html'"
  ^js [parsed-path value]
  (set! (.-base ^js parsed-path) value))

(defn ext
  "The file extension (if any) such as '.html'"
  ^js [parsed-path]
  (.-ext ^js parsed-path))

(defn set-ext!
  "The file extension (if any) such as '.html'"
  ^js [parsed-path value]
  (set! (.-ext ^js parsed-path) value))

(defn name
  "The file name without extension (if any) such as 'index'"
  ^js [parsed-path]
  (.-name ^js parsed-path))

(defn set-name!
  "The file name without extension (if any) such as 'index'"
  ^js [parsed-path value]
  (set! (.-name ^js parsed-path) value))
