(ns dots.vscode.themable-decoration-attachment-render-options
  "Represents theme specific rendeirng styles for {@link ThemableDecorationRenderOptions.before before} and
   {@link ThemableDecorationRenderOptions.after after} the content of text decorations.")

(defn content-text
  "Defines a text content that is shown in the attachment. Either an icon or a text can be shown, but not both."
  ^js [themable-decoration-attachment-render-options]
  (.-contentText ^js themable-decoration-attachment-render-options))

(defn set-content-text!
  "Defines a text content that is shown in the attachment. Either an icon or a text can be shown, but not both."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-contentText ^js themable-decoration-attachment-render-options) value))

(defn content-icon-path
  "An **absolute path** or an URI to an image to be rendered in the attachment. Either an icon
   or a text can be shown, but not both."
  ^js [themable-decoration-attachment-render-options]
  (.-contentIconPath ^js themable-decoration-attachment-render-options))

(defn set-content-icon-path!
  "An **absolute path** or an URI to an image to be rendered in the attachment. Either an icon
   or a text can be shown, but not both."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-contentIconPath ^js themable-decoration-attachment-render-options) value))

(defn border
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-border ^js themable-decoration-attachment-render-options))

(defn set-border!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-border ^js themable-decoration-attachment-render-options) value))

(defn border-color
  "CSS styling property that will be applied to text enclosed by a decoration."
  ^js [themable-decoration-attachment-render-options]
  (.-borderColor ^js themable-decoration-attachment-render-options))

(defn set-border-color!
  "CSS styling property that will be applied to text enclosed by a decoration."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-borderColor ^js themable-decoration-attachment-render-options) value))

(defn font-style
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-fontStyle ^js themable-decoration-attachment-render-options))

(defn set-font-style!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-fontStyle ^js themable-decoration-attachment-render-options) value))

(defn font-weight
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-fontWeight ^js themable-decoration-attachment-render-options))

(defn set-font-weight!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-fontWeight ^js themable-decoration-attachment-render-options) value))

(defn text-decoration
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-textDecoration ^js themable-decoration-attachment-render-options))

(defn set-text-decoration!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-textDecoration ^js themable-decoration-attachment-render-options) value))

(defn color
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-color ^js themable-decoration-attachment-render-options))

(defn set-color!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-color ^js themable-decoration-attachment-render-options) value))

(defn background-color
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-backgroundColor ^js themable-decoration-attachment-render-options))

(defn set-background-color!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-backgroundColor ^js themable-decoration-attachment-render-options) value))

(defn margin
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-margin ^js themable-decoration-attachment-render-options))

(defn set-margin!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-margin ^js themable-decoration-attachment-render-options) value))

(defn width
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-width ^js themable-decoration-attachment-render-options))

(defn set-width!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-width ^js themable-decoration-attachment-render-options) value))

(defn height
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options]
  (.-height ^js themable-decoration-attachment-render-options))

(defn set-height!
  "CSS styling property that will be applied to the decoration attachment."
  ^js [themable-decoration-attachment-render-options value]
  (set! (.-height ^js themable-decoration-attachment-render-options) value))
