/*
 * Decompiled with CFR 0.152.
 */
package me.dynomake.outline.implementation;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.StringConcatFactory;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.NonNull;
import me.dynomake.outline.OutlineWrapper;
import me.dynomake.outline.gson.GsonUtil;
import me.dynomake.outline.implementation.model.Name;
import me.dynomake.outline.implementation.model.Response;
import me.dynomake.outline.model.OutlineKey;
import me.dynomake.outline.model.OutlineKeyList;
import me.dynomake.outline.model.OutlineServer;

public class RealOutlineWrapper
implements OutlineWrapper {
    private String apiAddress;

    @Override
    public OutlineKeyList getKeys() {
        return GsonUtil.unparseJson(this.getResponse((String)"/access-keys", (String)"GET", null).responseString, OutlineKeyList.class);
    }

    @Override
    public OutlineKey generateKey() {
        return GsonUtil.unparseJson(this.getResponse((String)"/access-keys", (String)"POST", null).responseString, OutlineKey.class);
    }

    @Override
    public OutlineKey getKey(int keyIdentifier) {
        return GsonUtil.unparseJson(this.getResponse((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"/access-keys/\u0001"}, (int)keyIdentifier)), (String)"GET", null).responseString, OutlineKey.class);
    }

    @Override
    public void renameKey(int keyIdentifier, @NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.getResponse("/access-keys/" + keyIdentifier + "/name", "PUT", GsonUtil.parseJson(new Name(name)));
    }

    @Override
    public boolean removeKey(int keyIdentifier) {
        return this.getResponse((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"/access-keys/\u0001"}, (int)keyIdentifier)), (String)"DELETE", null).responseCode == 204;
    }

    @Override
    public OutlineServer getServerInformation() {
        return GsonUtil.unparseJson(this.getResponse((String)"/server", (String)"GET", null).responseString, OutlineServer.class);
    }

    private Response getResponse(@NonNull String requestAddress, @NonNull String method, String writableJson) {
        if (requestAddress == null) {
            throw new NullPointerException("requestAddress is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        try {
            URL url = new URL(this.apiAddress + requestAddress);
            HttpsURLConnection httpConn = (HttpsURLConnection)url.openConnection();
            httpConn.setRequestMethod(method);
            this.removeSSLVerifier(httpConn);
            if (writableJson != null) {
                httpConn.setDoOutput(true);
                httpConn.setRequestProperty("Content-Type", "application/json");
                OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
                writer.write(writableJson);
                writer.flush();
                writer.close();
                httpConn.getOutputStream().close();
            }
            InputStream responseStream = httpConn.getResponseCode() / 100 == 2 ? httpConn.getInputStream() : httpConn.getErrorStream();
            Scanner s = new Scanner(responseStream).useDelimiter("\\A");
            String response = s.hasNext() ? s.next() : "";
            return new Response(httpConn.getResponseCode(), response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void removeSSLVerifier(@NonNull HttpsURLConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
        }
        try {
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException e) {
            System.out.println(e.getMessage());
        }
        connection.setSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier validHosts = (arg0, arg1) -> true;
        connection.setHostnameVerifier(validHosts);
    }

    public RealOutlineWrapper(String apiAddress) {
        this.apiAddress = apiAddress;
    }
}

