/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.proxy.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.CompletableFuture;
import net.wonsi.api.request.DeleteRequest;
import net.wonsi.util.Condition;
import net.wonsi.util.ExecutorUtil;

public class RealDeleteRequest
implements DeleteRequest {
    private final Connection connection;
    private final String tableName;
    private String condition;
    private int limit;

    public RealDeleteRequest(Connection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
        this.condition = "0";
        this.limit = 1;
    }

    @Override
    public DeleteRequest where(Condition condition) {
        this.condition = condition.toString();
        return this;
    }

    @Override
    public DeleteRequest limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public CompletableFuture<Void> async() {
        return CompletableFuture.runAsync(this::sync);
    }

    @Override
    public void sync() {
        try {
            PreparedStatement statement = this.connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + this.condition + " LIMIT ?");
            statement.setInt(1, this.limit);
            ExecutorUtil.execute(statement, this.connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

