/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import lombok.NonNull;

public final class ExecutorUtil {
    public static ResultSet getResult(@NonNull PreparedStatement statement, @NonNull Connection connection) {
        if (statement == null) {
            throw new NullPointerException("statement is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        try {
            return statement.executeQuery();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void execute(@NonNull PreparedStatement statement, @NonNull Connection connection) {
        if (statement == null) {
            throw new NullPointerException("statement is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        try {
            statement.execute();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ResultSet getResult(@NonNull String query, @NonNull Connection connection) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        try {
            return connection.createStatement().executeQuery(query);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void execute(@NonNull String query, @NonNull Connection connection) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        try {
            connection.createStatement().execute(query);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ExecutorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

