/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.proxy;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.function.Function;
import lombok.NonNull;
import net.wonsi.api.Wonsi;
import net.wonsi.api.mapping.Table;
import net.wonsi.api.mapping.WonsiColumn;
import net.wonsi.api.table.WonsiTable;
import net.wonsi.column.ColumnUtil;
import net.wonsi.proxy.table.RealWonsiTable;

public class RealWonsi
implements Wonsi {
    private Connection connection;

    @Override
    public <T> WonsiTable<T> getTable(@NonNull Class<T> tClass, @NonNull Function<ResultSet, T> deserializer) {
        if (tClass == null) {
            throw new NullPointerException("tClass is marked non-null but is null");
        }
        if (deserializer == null) {
            throw new NullPointerException("deserializer is marked non-null but is null");
        }
        Table tableAnnotation = tClass.getAnnotation(Table.class);
        if (tableAnnotation == null) {
            throw new IllegalArgumentException("Class don't has annotation @Table, please read documentation!");
        }
        RealWonsiTable<T> table = new RealWonsiTable<T>(this.connection, deserializer, tableAnnotation.value());
        table.createIfNotExits(tClass);
        return table;
    }

    @Override
    public <T> WonsiTable<T> getTable(@NonNull Class<T> tClass) {
        if (tClass == null) {
            throw new NullPointerException("tClass is marked non-null but is null");
        }
        return this.getTable(tClass, resultSet -> {
            try {
                Object object = tClass.newInstance();
                for (Field field : tClass.getDeclaredFields()) {
                    WonsiColumn column = field.getAnnotation(WonsiColumn.class);
                    String name = column.name().equals("null_wonsidv") ? field.getName() : column.name();
                    field.trySetAccessible();
                    Object value = ColumnUtil.get(field.getType()).get(name, (ResultSet)resultSet);
                    field.set(object, value.getClass().isAssignableFrom(field.getType()) ? value : (value.getClass().equals(Long.class) ? Long.valueOf((Long)value) : field.getType().cast(value)));
                }
                return object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        });
    }

    public RealWonsi(Connection connection) {
        this.connection = connection;
    }
}

