/*
 * Decompiled with CFR 0.152.
 */
package net.wonsi.proxy.request;

import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.wonsi.api.request.UpdateRequest;
import net.wonsi.util.Condition;
import net.wonsi.util.ExecutorUtil;

public class RealUpdateRequest
implements UpdateRequest {
    private final Connection connection;
    private final String tableName;
    private String condition;
    private int limit;
    private Map<String, Object> data;

    public RealUpdateRequest(Connection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
        this.condition = "0";
        this.limit = 10;
    }

    @Override
    public CompletableFuture<Void> async() {
        return CompletableFuture.runAsync(this::sync);
    }

    @Override
    public void sync() {
        try {
            PreparedStatement statement = this.connection.prepareStatement("UPDATE " + this.tableName + Joiner.on((String)"= ?,").join(this.data.keySet()) + " = ? LIMIT = ?");
            int currentArgument = 1;
            for (Object o : this.data.values()) {
                statement.setObject(currentArgument, o);
                ++currentArgument;
            }
            statement.setObject(currentArgument, this.limit);
            ExecutorUtil.execute(statement, this.connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public UpdateRequest where(Condition condition) {
        this.condition = condition.toString();
        return this;
    }

    @Override
    public UpdateRequest data(Consumer<Map<String, Object>> insertData) {
        this.data = new HashMap<String, Object>();
        insertData.accept(this.data);
        return this;
    }

    @Override
    public UpdateRequest limit(int limit) {
        this.limit = limit;
        return this;
    }
}

