/*
 * Decompiled with CFR 0.152.
 */
package me.dynomake.yookassa;

import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import me.dynomake.yookassa.event.YookassaEvent;
import me.dynomake.yookassa.exception.BadRequestException;
import me.dynomake.yookassa.exception.UnspecifiedShopInformation;
import me.dynomake.yookassa.implementation.RealYookassa;
import me.dynomake.yookassa.model.Amount;
import me.dynomake.yookassa.model.Payment;
import me.dynomake.yookassa.model.Refund;
import me.dynomake.yookassa.model.Webhook;
import me.dynomake.yookassa.model.collecting.PaymentList;
import me.dynomake.yookassa.model.collecting.RefundList;
import me.dynomake.yookassa.model.collecting.WebhookList;

public interface Yookassa {
    public Payment createPayment(@NonNull Amount var1, @NonNull String var2, @NonNull String var3) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public Payment createPayment(@NonNull String var1, @NonNull boolean var2, @NonNull Amount var3, @NonNull String var4, @NonNull String var5) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public Payment createRecurrentPayment(@NonNull UUID var1, @NonNull Amount var2, @NonNull String var3) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public Payment getPayment(@NonNull UUID var1) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public PaymentList getPayments() throws UnspecifiedShopInformation, BadRequestException, IOException;

    public Refund createRefund(@NonNull UUID var1, @NonNull Amount var2) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public Refund getRefund(@NonNull UUID var1) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public RefundList getRefunds() throws UnspecifiedShopInformation, BadRequestException, IOException;

    public Webhook createWebhook(@NonNull YookassaEvent var1, @NonNull String var2) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public void deleteWebhook(@NonNull UUID var1) throws UnspecifiedShopInformation, BadRequestException, IOException;

    public WebhookList getWebhooks() throws UnspecifiedShopInformation, BadRequestException, IOException;

    public static Yookassa initialize(int shopIdentifier, @NonNull String shopToken) {
        if (shopToken == null) {
            throw new NullPointerException("shopToken is marked non-null but is null");
        }
        return new RealYookassa(shopIdentifier, shopToken);
    }
}

