/*
 * Decompiled with CFR 0.152.
 */
package me.dynomake.yookassa.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import lombok.NonNull;
import me.dynomake.yookassa.Yookassa;
import me.dynomake.yookassa.event.YookassaEvent;
import me.dynomake.yookassa.exception.BadRequestException;
import me.dynomake.yookassa.exception.UnspecifiedShopInformation;
import me.dynomake.yookassa.model.Amount;
import me.dynomake.yookassa.model.Payment;
import me.dynomake.yookassa.model.Refund;
import me.dynomake.yookassa.model.Webhook;
import me.dynomake.yookassa.model.collecting.PaymentList;
import me.dynomake.yookassa.model.collecting.RefundList;
import me.dynomake.yookassa.model.collecting.WebhookList;
import me.dynomake.yookassa.model.request.PaymentRequest;
import me.dynomake.yookassa.model.request.RecurrentPaymentRequest;
import me.dynomake.yookassa.model.request.RefundRequest;
import me.dynomake.yookassa.model.request.WebhookRequest;
import me.dynomake.yookassa.utility.JsonUtil;

public class RealYookassa
implements Yookassa {
    private int shopIdentifier;
    private String shopToken;

    @Override
    public Payment createPayment(@NonNull Amount amount, @NonNull String description, @NonNull String redirectUrl) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl is marked non-null but is null");
        }
        return this.parseResponse(Payment.class, "https://api.yookassa.ru/v3/payments", "POST", JsonUtil.toJson(PaymentRequest.create(amount, redirectUrl, description)));
    }

    @Override
    public Payment createPayment(@NonNull String paymentMethod, @NonNull boolean saveMethod, @NonNull Amount amount, @NonNull String description, @NonNull String redirectUrl) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (paymentMethod == null) {
            throw new NullPointerException("paymentMethod is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl is marked non-null but is null");
        }
        return this.parseResponse(Payment.class, "https://api.yookassa.ru/v3/payments", "POST", JsonUtil.toJson(PaymentRequest.create(amount, redirectUrl, description, paymentMethod, saveMethod)));
    }

    @Override
    public Payment createRecurrentPayment(@NonNull UUID methodId, @NonNull Amount amount, @NonNull String description) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (methodId == null) {
            throw new NullPointerException("methodId is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return this.parseResponse(Payment.class, "https://api.yookassa.ru/v3/payments", "POST", JsonUtil.toJson(new RecurrentPaymentRequest(amount, true, methodId, description)));
    }

    @Override
    public Payment getPayment(@NonNull UUID paymentIdentifier) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (paymentIdentifier == null) {
            throw new NullPointerException("paymentIdentifier is marked non-null but is null");
        }
        return this.parseResponse(Payment.class, "https://api.yookassa.ru/v3/payments/" + paymentIdentifier, "GET", null);
    }

    @Override
    public PaymentList getPayments() throws UnspecifiedShopInformation, BadRequestException, IOException {
        return this.parseResponse(PaymentList.class, "https://api.yookassa.ru/v3/payments", "GET", null);
    }

    @Override
    public Refund createRefund(@NonNull UUID paymentIdentifier, @NonNull Amount amount) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (paymentIdentifier == null) {
            throw new NullPointerException("paymentIdentifier is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        return this.parseResponse(Refund.class, "https://api.yookassa.ru/v3/refunds", "POST", JsonUtil.toJson(new RefundRequest(amount, paymentIdentifier)));
    }

    @Override
    public Refund getRefund(@NonNull UUID refundIdentifier) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (refundIdentifier == null) {
            throw new NullPointerException("refundIdentifier is marked non-null but is null");
        }
        return this.parseResponse(Refund.class, "https://api.yookassa.ru/v3/refunds/" + refundIdentifier, "GET", null);
    }

    @Override
    public RefundList getRefunds() throws UnspecifiedShopInformation, BadRequestException, IOException {
        return this.parseResponse(RefundList.class, "https://api.yookassa.ru/v3/refunds", "GET", null);
    }

    @Override
    public Webhook createWebhook(@NonNull YookassaEvent event, @NonNull String url) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.parseResponse(Webhook.class, "https://api.yookassa.ru/v3/webhooks", "POST", JsonUtil.toJson(new WebhookRequest(event.getEventName(), url)));
    }

    @Override
    public void deleteWebhook(@NonNull UUID webhookIdentifier) throws UnspecifiedShopInformation, BadRequestException, IOException {
        if (webhookIdentifier == null) {
            throw new NullPointerException("webhookIdentifier is marked non-null but is null");
        }
        this.parseResponse(null, "https://api.yookassa.ru/v3/webhooks/" + webhookIdentifier, "DELETE", null);
    }

    @Override
    public WebhookList getWebhooks() throws UnspecifiedShopInformation, BadRequestException, IOException {
        return this.parseResponse(WebhookList.class, "https://api.yookassa.ru/v3/webhooks", "GET", null);
    }

    private <T> T parseResponse(Class<T> wannableClass, @NonNull String requestAddress, @NonNull String requestMethod, String writableJson) throws IOException, UnspecifiedShopInformation, BadRequestException {
        String response;
        if (requestAddress == null) {
            throw new NullPointerException("requestAddress is marked non-null but is null");
        }
        if (requestMethod == null) {
            throw new NullPointerException("requestMethod is marked non-null but is null");
        }
        if (this.shopIdentifier == 0 || this.shopToken == null) {
            throw new UnspecifiedShopInformation();
        }
        URL url = new URL(requestAddress);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod(requestMethod);
        byte[] message = (this.shopIdentifier + ":" + this.shopToken).getBytes(StandardCharsets.UTF_8);
        String basicAuth = DatatypeConverter.printBase64Binary((byte[])message);
        httpConn.setRequestProperty("Authorization", "Basic " + basicAuth);
        if (writableJson != null) {
            httpConn.setRequestProperty("Idempotence-Key", UUID.randomUUID().toString());
            httpConn.setRequestProperty("Content-Type", "application/json");
            httpConn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
            writer.write(writableJson);
            writer.flush();
            writer.close();
            httpConn.getOutputStream().close();
        }
        boolean success = httpConn.getResponseCode() / 100 == 2;
        InputStream responseStream = success ? httpConn.getInputStream() : httpConn.getErrorStream();
        Scanner s = new Scanner(responseStream).useDelimiter("\\A");
        String string = response = s.hasNext() ? s.next() : "";
        if (!success) {
            System.out.println(response);
            throw new BadRequestException();
        }
        if (wannableClass == null) {
            return null;
        }
        return JsonUtil.fromJson(response, wannableClass);
    }

    public RealYookassa(int shopIdentifier, String shopToken) {
        this.shopIdentifier = shopIdentifier;
        this.shopToken = shopToken;
    }
}

