/*
 * Decompiled with CFR 0.152.
 */
package me.dynomake.yookassa.model.request;

import java.util.UUID;
import me.dynomake.yookassa.model.Amount;

public class PaymentRequest {
    public final Amount amount;
    public final ConfirmationType confirmation;
    public final boolean capture;
    public final String description;
    public final PaymentMethodData payment_method_data;
    public final boolean save_payment_method;
    public final UUID payment_method_id;

    public static PaymentRequest create(Amount amount, String urlRedirect, String description) {
        return new PaymentRequest(amount, new ConfirmationType(urlRedirect), true, description, null, false, null);
    }

    public static PaymentRequest create(Amount amount, String urlRedirect, String description, String paymentMethod, boolean save) {
        return new PaymentRequest(amount, new ConfirmationType(urlRedirect), true, description, new PaymentMethodData(paymentMethod), save, null);
    }

    public PaymentRequest(Amount amount, ConfirmationType confirmation, boolean capture, String description, PaymentMethodData payment_method_data, boolean save_payment_method, UUID payment_method_id) {
        this.amount = amount;
        this.confirmation = confirmation;
        this.capture = capture;
        this.description = description;
        this.payment_method_data = payment_method_data;
        this.save_payment_method = save_payment_method;
        this.payment_method_id = payment_method_id;
    }

    private static class ConfirmationType {
        public final String type = "redirect";
        public final String return_url;

        public ConfirmationType(String url) {
            this.return_url = url;
        }
    }

    private static class PaymentMethodData {
        public final String type;

        public PaymentMethodData(String type) {
            this.type = type;
        }
    }
}

