/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.GenProfile;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;

public class Command {
    private static final double DEFAULT_ALPHA = 0.5;
    private DetectorFactory detectorFactory = DetectorFactory.newInstance();
    private HashMap<String, String> opt_with_value = new HashMap();
    private HashMap<String, String> values = new HashMap();
    private HashSet<String> opt_without_value = new HashSet();
    private ArrayList<String> arglist = new ArrayList();

    private void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (this.opt_with_value.containsKey(args[i])) {
                String key = this.opt_with_value.get(args[i]);
                this.values.put(key, args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].startsWith("-")) {
                this.opt_without_value.add(args[i]);
                continue;
            }
            this.arglist.add(args[i]);
        }
    }

    private void addOpt(String opt, String key, String value) {
        this.opt_with_value.put(opt, key);
        this.values.put(key, value);
    }

    private String get(String key) {
        return this.values.get(key);
    }

    private Long getLong(String key) {
        String value = this.values.get(key);
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return Double.valueOf(this.values.get(key));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private boolean hasOpt(String opt) {
        return this.opt_without_value.contains(opt);
    }

    private File searchFile(File directory, String pattern) {
        for (File file : directory.listFiles()) {
            if (!file.getName().matches(pattern)) continue;
            return file;
        }
        return null;
    }

    private boolean loadProfile() {
        String profileDirectory = this.get("directory") + "/";
        try {
            this.detectorFactory.loadProfiles(profileDirectory);
            Long seed = this.getLong("seed");
            if (seed != null) {
                this.detectorFactory.setSeed(seed);
            }
            return false;
        }
        catch (IOException e) {
            System.err.println("ERROR: " + e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateProfile() {
        File directory = new File(this.get("directory"));
        for (String lang : this.arglist) {
            File file = this.searchFile(directory, lang + "wiki-.*-abstract\\.xml.*");
            if (file == null) {
                System.err.println("Not Found abstract xml : lang = " + lang);
                continue;
            }
            FileOutputStream os = null;
            try {
                LangProfile profile = GenProfile.loadFromWikipediaAbstract(lang, file);
                profile.omitLessFreq();
                File profile_path = new File(this.get("directory") + "/profiles/" + lang);
                os = new FileOutputStream(profile_path);
                JSON.encode((Object)profile, (OutputStream)os);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (os == null) continue;
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateProfileFromText() {
        if (this.arglist.size() != 1) {
            System.err.println("Need to specify text file path");
            return;
        }
        File file = new File(this.arglist.get(0));
        if (!file.exists()) {
            System.err.println("Need to specify existing text file path");
            return;
        }
        String lang = this.get("lang");
        if (lang == null) {
            System.err.println("Need to specify langage code(-l)");
            return;
        }
        FileOutputStream os = null;
        try {
            LangProfile profile = GenProfile.loadFromText(lang, file);
            profile.omitLessFreq();
            File profile_path = new File(lang);
            os = new FileOutputStream(profile_path);
            JSON.encode((Object)profile, (OutputStream)os);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectLang() {
        if (this.loadProfile()) {
            return;
        }
        for (String filename : this.arglist) {
            BufferedReader is = null;
            try {
                is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
                Detector detector = this.detectorFactory.create(this.getDouble("alpha", 0.5));
                if (this.hasOpt("--debug")) {
                    detector.setVerbose();
                }
                detector.append(is);
                System.out.println(filename + ":" + detector.getProbabilities());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchTest() {
        if (this.loadProfile()) {
            return;
        }
        HashMap result = new HashMap();
        for (String filename : this.arglist) {
            BufferedReader is = null;
            try {
                is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
                while (is.ready()) {
                    String line = is.readLine();
                    int idx = line.indexOf(9);
                    if (idx <= 0) continue;
                    String correctLang = line.substring(0, idx);
                    String text = line.substring(idx + 1);
                    Detector detector = this.detectorFactory.create(this.getDouble("alpha", 0.5));
                    detector.append(text);
                    String lang = "";
                    try {
                        lang = detector.detect();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!result.containsKey(correctLang)) {
                        result.put(correctLang, new ArrayList());
                    }
                    ((ArrayList)result.get(correctLang)).add(lang);
                    if (!this.hasOpt("--debug")) continue;
                    System.out.println(correctLang + "," + lang + "," + (text.length() > 100 ? text.substring(0, 100) : text));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
            ArrayList langlist = new ArrayList(result.keySet());
            Collections.sort(langlist);
            int totalCount = 0;
            int totalCorrect = 0;
            for (String lang : langlist) {
                HashMap<String, Integer> resultCount = new HashMap<String, Integer>();
                int count = 0;
                ArrayList list = (ArrayList)result.get(lang);
                for (String detectedLang : list) {
                    ++count;
                    if (resultCount.containsKey(detectedLang)) {
                        resultCount.put(detectedLang, (Integer)resultCount.get(detectedLang) + 1);
                        continue;
                    }
                    resultCount.put(detectedLang, 1);
                }
                int correct = resultCount.containsKey(lang) ? (Integer)resultCount.get(lang) : 0;
                double rate = (double)correct / (double)count;
                System.out.println(String.format("%s (%d/%d=%.2f): %s", lang, correct, count, rate, resultCount));
                totalCorrect += correct;
                totalCount += count;
            }
            System.out.println(String.format("total: %d/%d = %.3f", totalCorrect, totalCount, (double)totalCorrect / (double)totalCount));
        }
    }

    public void help() {
        System.out.println();
        System.out.println();
        System.out.println("Language detection library");
        System.out.println("==========================");
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("Detect language of files:");
        System.out.println("  --detectlang [-d <profile_directory>] [-a <alpha>] [-s <seed>] <test_file(s)>");
        System.out.println();
        System.out.println("Generate a profile from raw text:");
        System.out.println("  --genprofile-text -l <language code> <text_file_path>");
        System.out.println();
        System.out.println("Generate some profiles from wikipedia abstract XMLs:");
        System.out.println("  --genprofile -d <abstracts_directory> <2 letter language code(s)>");
        System.out.println();
        System.out.println("Run a batch test and output precision:");
        System.out.println(" --batchtest [-d <profile_directory>] [-a <alpha>] [-s <seed>] <test_data_file(s)>");
        System.out.println();
        System.out.println();
    }

    public static void main(String[] args) {
        Command command = new Command();
        command.addOpt("-d", "directory", "./");
        command.addOpt("-a", "alpha", "0.5");
        command.addOpt("-s", "seed", null);
        command.addOpt("-l", "lang", null);
        command.parse(args);
        if (command.hasOpt("--genprofile")) {
            command.generateProfile();
        } else if (command.hasOpt("--genprofile-text")) {
            command.generateProfileFromText();
        } else if (command.hasOpt("--detectlang")) {
            command.detectLang();
        } else if (command.hasOpt("--batchtest")) {
            command.batchTest();
        } else {
            command.help();
        }
    }
}

