/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common.security;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;

public class HdfsSecurityUtil {
    public static final String STORM_KEYTAB_FILE_KEY = "hdfs.keytab.file";
    public static final String STORM_USER_NAME_KEY = "hdfs.kerberos.principal";

    public static void login(Map conf, Configuration hdfsConfig) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            String userName;
            String keytab = (String)conf.get(STORM_KEYTAB_FILE_KEY);
            if (keytab != null) {
                hdfsConfig.set(STORM_KEYTAB_FILE_KEY, keytab);
            }
            if ((userName = (String)conf.get(STORM_USER_NAME_KEY)) != null) {
                hdfsConfig.set(STORM_USER_NAME_KEY, userName);
            }
            SecurityUtil.login((Configuration)hdfsConfig, (String)STORM_KEYTAB_FILE_KEY, (String)STORM_USER_NAME_KEY);
        }
    }
}

