/*
 * Decompiled with CFR 0.152.
 */
package ua_parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import ua_parser.Client;
import ua_parser.Device;
import ua_parser.DeviceParser;
import ua_parser.OS;
import ua_parser.OSParser;
import ua_parser.UserAgent;
import ua_parser.UserAgentParser;

public class Parser {
    private static final String REGEX_YAML_PATH = "/ua_parser/regexes.yaml";
    private UserAgentParser uaParser;
    private OSParser osParser;
    private DeviceParser deviceParser;

    public Parser() throws IOException {
        this(Parser.class.getResourceAsStream(REGEX_YAML_PATH));
    }

    public Parser(InputStream regexYaml) {
        this.initialize(regexYaml);
    }

    public Client parse(String agentString) {
        UserAgent ua = this.parseUserAgent(agentString);
        OS os = this.parseOS(agentString);
        Device device = this.deviceParser.parse(agentString);
        return new Client(ua, os, device);
    }

    public UserAgent parseUserAgent(String agentString) {
        return this.uaParser.parse(agentString);
    }

    public Device parseDevice(String agentString) {
        return this.deviceParser.parse(agentString);
    }

    public OS parseOS(String agentString) {
        return this.osParser.parse(agentString);
    }

    private void initialize(InputStream regexYaml) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map regexConfig = (Map)yaml.load(regexYaml);
        List uaParserConfigs = (List)regexConfig.get("user_agent_parsers");
        if (uaParserConfigs == null) {
            throw new IllegalArgumentException("user_agent_parsers is missing from yaml");
        }
        this.uaParser = UserAgentParser.fromList(uaParserConfigs);
        List osParserConfigs = (List)regexConfig.get("os_parsers");
        if (osParserConfigs == null) {
            throw new IllegalArgumentException("os_parsers is missing from yaml");
        }
        this.osParser = OSParser.fromList(osParserConfigs);
        List deviceParserConfigs = (List)regexConfig.get("device_parsers");
        if (deviceParserConfigs == null) {
            throw new IllegalArgumentException("device_parsers is missing from yaml");
        }
        this.deviceParser = DeviceParser.fromList(deviceParserConfigs);
    }
}

