/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil;

import io.github.erdos.stencil.exceptions.EvalException;
import io.github.erdos.stencil.exceptions.ParsingException;
import io.github.erdos.stencil.standalone.ArgsParser;
import io.github.erdos.stencil.standalone.StandaloneApplication;
import io.github.erdos.stencil.standalone.StencilArgsParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;

public class Main {
    public static void main(String ... stringArray) throws IOException {
        try {
            ArgsParser.ParseResult parseResult = StencilArgsParser.parse(stringArray);
            StandaloneApplication standaloneApplication = new StandaloneApplication(parseResult);
            standaloneApplication.run();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Parameter error! See --help for usage information.");
            Main.printException(illegalArgumentException);
            System.exit(2);
        }
        catch (ParsingException parsingException) {
            System.out.println("Error parsing template!");
            System.out.println("Expression: " + parsingException.getExpression());
            Main.printException(parsingException);
            System.exit(3);
        }
        catch (EvalException evalException) {
            System.out.println("Error rendering template!");
            Main.printException(evalException);
            System.exit(4);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            System.out.println("Output file already exists! Use the --overwrite switch to force files to be deleted before rendering.");
            if (fileAlreadyExistsException.getFile() != null) {
                System.out.println("File: " + new File(fileAlreadyExistsException.getFile()).getCanonicalPath());
            }
            System.exit(5);
        }
    }

    private static void printException(Throwable throwable) {
        if (throwable.getMessage() != null && !throwable.getMessage().trim().isEmpty()) {
            System.out.println(throwable.getMessage());
        } else {
            System.out.print(throwable.getClass().getName());
        }
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            System.out.println("- " + throwable2.getClass().getName() + " " + throwable2.getMessage());
        }
    }
}

