/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.functions;

import io.github.erdos.stencil.functions.Function;

public enum NumberFunctions implements Function
{
    ROUND{

        @Override
        public Object call(Object ... objectArray) {
            Number number = NumberFunctions.maybeNumber(objectArray);
            if (number == null) {
                return null;
            }
            return Math.round(number.doubleValue());
        }
    }
    ,
    CEIL{

        @Override
        public Object call(Object ... objectArray) {
            Number number = NumberFunctions.maybeNumber(objectArray);
            if (number == null) {
                return null;
            }
            return (long)Math.ceil(number.doubleValue());
        }
    }
    ,
    FLOOR{

        @Override
        public Object call(Object ... objectArray) {
            Number number = NumberFunctions.maybeNumber(objectArray);
            if (number == null) {
                return null;
            }
            return (long)Math.floor(number.doubleValue());
        }
    };


    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    private static Number maybeNumber(Object ... objectArray) {
        if (objectArray.length != 1) {
            throw new IllegalArgumentException("The function must have exactly 1 arguments!");
        }
        if (objectArray[0] == null) {
            return null;
        }
        if (!(objectArray[0] instanceof Number)) {
            throw new IllegalArgumentException("The function expects a number argument!");
        }
        return (Number)objectArray[0];
    }
}

