/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.functions;

import io.github.erdos.stencil.functions.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public enum StringFunctions implements Function
{
    JOIN{

        @Override
        public Object call(Object ... objectArray) {
            if (objectArray.length == 0) {
                throw new IllegalArgumentException("At least one arg is expected!");
            }
            if (objectArray.length == 1 || objectArray.length == 2 && objectArray[1] == null) {
                if (objectArray[0] == null) {
                    return "";
                }
                if (objectArray[0] instanceof Collection) {
                    Collection collection = (Collection)objectArray[0];
                    return collection.stream().filter(Objects::nonNull).map(Objects::toString).collect(Collectors.joining());
                }
                throw new IllegalArgumentException("First parameter must be a Collection!");
            }
            if (objectArray.length == 2) {
                if (!(objectArray[0] instanceof Collection)) {
                    throw new IllegalArgumentException("First parameter must be a Collection!");
                }
                if (!(objectArray[1] instanceof String)) {
                    throw new IllegalArgumentException("Second parameter must be a String!");
                }
                Collection collection = (Collection)objectArray[0];
                return collection.stream().filter(Objects::nonNull).map(Objects::toString).collect(Collectors.joining((String)objectArray[1]));
            }
            throw new IllegalArgumentException("Join function expects 1 or 2 arguments!");
        }
    }
    ,
    STR{

        @Override
        public Object call(Object ... objectArray) throws IllegalArgumentException {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : objectArray) {
                if (object == null) continue;
                stringBuilder.append(object);
            }
            return stringBuilder.toString();
        }
    }
    ,
    LOWERCASE{

        @Override
        public Object call(Object ... objectArray) throws IllegalArgumentException {
            if (objectArray.length != 1) {
                throw new IllegalArgumentException("lowerCase() function expects exactly 1 argument!");
            }
            if (objectArray[0] == null) {
                return null;
            }
            return objectArray[0].toString().toLowerCase();
        }
    }
    ,
    UPPERCASE{

        @Override
        public Object call(Object ... objectArray) throws IllegalArgumentException {
            if (objectArray.length != 1) {
                throw new IllegalArgumentException("upperCase() function expects exactly 1 argument!");
            }
            if (objectArray[0] == null) {
                return null;
            }
            return objectArray[0].toString().toUpperCase();
        }
    }
    ,
    TITLECASE{

        @Override
        public Object call(Object ... objectArray) throws IllegalArgumentException {
            if (objectArray.length != 1) {
                throw new IllegalArgumentException("upperCase() function expects exactly 1 argument!");
            }
            if (objectArray[0] == null) {
                return null;
            }
            return Arrays.stream(objectArray[0].toString().split("\\s")).map(string -> string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()).collect(Collectors.joining(" "));
        }
    };


    @Override
    public String getName() {
        return this.name().toLowerCase();
    }
}

