/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.UUID;
import java.util.regex.Pattern;

public final class FileHelper {
    private static final File TEMP_DIRECTORY = new File(FileHelper.requireNonNullElse(System.getProperty("stencil.tmpdir"), System.getProperty("java.io.tmpdir")));

    private FileHelper() {
    }

    public static String extension(File file) {
        return FileHelper.extension(file.getName());
    }

    public static String extension(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray[stringArray.length - 1].trim().toLowerCase();
    }

    public static String removeExtension(File file) {
        String string = file.getName();
        if (string.contains(".")) {
            int n = string.lastIndexOf(46);
            return string.substring(0, n);
        }
        return string;
    }

    public static File createNonexistentTempFile(String string, String string2) {
        return FileHelper.createNonexistentTempFile(null, string, string2);
    }

    public static File createNonexistentTempFile(File file, String string, String string2) {
        return new File(FileHelper.requireNonNullElse(file, TEMP_DIRECTORY), string + UUID.randomUUID() + string2);
    }

    public static void forceMkdir(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Missing directory for forceMkdir");
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("File exists and not a directory: " + file);
            }
        } else if (!file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Unable to create directory " + file);
        }
    }

    public static void forceDelete(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileHelper.forceDelete(file2);
            }
        }
        file.delete();
    }

    public static String toUnixSeparatedString(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null!");
        }
        String string = FileSystems.getDefault().getSeparator();
        if (string.equals("/")) {
            return path.toString();
        }
        return path.toString().replaceAll(Pattern.quote(string), "/");
    }

    private static <T> T requireNonNullElse(T t, T t2) {
        return t == null ? t2 : t;
    }
}

