/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.functions;

import io.github.erdos.stencil.functions.Function;
import java.text.NumberFormat;
import java.util.Locale;

public enum LocaleFunctions implements Function
{
    CURRENCY{

        @Override
        public Object call(Object ... objectArray) throws IllegalArgumentException {
            return LocaleFunctions.formatting(this, NumberFormat::getCurrencyInstance, objectArray);
        }
    }
    ,
    PERCENT{

        @Override
        public Object call(Object ... objectArray) throws IllegalArgumentException {
            return LocaleFunctions.formatting(this, NumberFormat::getPercentInstance, objectArray);
        }
    };


    private static String formatting(Function function, java.util.function.Function<Locale, NumberFormat> function2, Object ... objectArray) {
        if (objectArray.length == 0 || objectArray.length > 2) {
            throw new IllegalArgumentException(function.getName() + "() function expects 1 or 2 arguments");
        }
        if (objectArray[0] == null) {
            return null;
        }
        Object object = objectArray[0];
        Locale locale = objectArray.length == 2 ? Locale.forLanguageTag(objectArray[1].toString()) : Locale.getDefault();
        return function2.apply(locale).format(object);
    }

    @Override
    public String getName() {
        return this.name().toLowerCase();
    }
}

