/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil;

import java.io.File;

public final class PrepareOptions {
    private static final PrepareOptions instance = new PrepareOptions(false, null);
    private final boolean onlyIncludes;
    private final File temporaryDirectory;

    private PrepareOptions(boolean bl, File file) {
        this.onlyIncludes = bl;
        this.temporaryDirectory = file;
    }

    public static PrepareOptions options() {
        return instance;
    }

    public boolean isOnlyIncludes() {
        return this.onlyIncludes;
    }

    public File getTemporaryDirectoryOverride() {
        return this.temporaryDirectory;
    }

    public PrepareOptions withTemporaryDirectoryOverride(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Temporary directory does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Temporary directory parameter is not a directory: " + file);
        }
        return new PrepareOptions(this.onlyIncludes, file);
    }

    public PrepareOptions withOnlyIncludes() {
        return new PrepareOptions(true, this.temporaryDirectory);
    }
}

