/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.functions;

import io.github.erdos.stencil.functions.Function;
import io.github.erdos.stencil.functions.FunctionsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class FunctionEvaluator {
    private static final Map<String, Function> preloaded = new HashMap<String, Function>();
    private final Map<String, Function> functions = new HashMap<String, Function>(preloaded);

    private static void registerFunction(Map<String, Function> map, Function function) {
        if (function == null) {
            throw new IllegalArgumentException("Registered function must not be null.");
        }
        Function function2 = map.put(function.getName().toLowerCase(), function);
        if (function2 != null) {
            throw new IllegalArgumentException("Function with name has already been registered.");
        }
    }

    public void registerFunctions(Function ... functionArray) {
        for (Function function : functionArray) {
            FunctionEvaluator.registerFunction(this.functions, function);
        }
    }

    public Object call(String string, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("Function name is missing");
        }
        Function function = this.functions.get(string.toLowerCase());
        if (function == null) {
            throw new IllegalArgumentException("Did not find function for name " + string);
        }
        return function.call(objectArray);
    }

    public Iterable<Function> listFunctions() {
        return new ArrayList<Function>(this.functions.values());
    }

    static {
        for (FunctionsProvider functionsProvider : ServiceLoader.load(FunctionsProvider.class)) {
            for (Function function : functionsProvider.functions()) {
                FunctionEvaluator.registerFunction(preloaded, function);
            }
        }
    }
}

