/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil;

import io.github.erdos.stencil.impl.InputStreamExceptionPropagation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;

public interface EvaluatedDocument {
    public void write(OutputStream var1);

    default public void writeToFile(File file) throws IOException {
        if (file.exists()) {
            throw new IllegalArgumentException("Output file already exists: " + file);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.write(fileOutputStream);
        }
    }

    default public InputStream toInputStream(ExecutorService executorService) {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        InputStreamExceptionPropagation inputStreamExceptionPropagation = new InputStreamExceptionPropagation(pipedInputStream);
        try {
            pipedInputStream.connect(pipedOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        long l = Thread.currentThread().getId();
        executorService.submit(() -> {
            long l2 = Thread.currentThread().getId();
            if (l2 == l) {
                throw new IllegalStateException("The supplied executor must submit jobs to new threads!");
            }
            try {
                this.write(pipedOutputStream);
            }
            catch (Throwable throwable) {
                inputStreamExceptionPropagation.fail(throwable);
                throw throwable;
            }
            finally {
                inputStreamExceptionPropagation.finish();
            }
        });
        return inputStreamExceptionPropagation;
    }
}

