/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.impl;

import io.github.erdos.stencil.PrepareOptions;
import io.github.erdos.stencil.PreparedTemplate;
import io.github.erdos.stencil.TemplateFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public final class DirWatcherTemplateFactory
implements TemplateFactory {
    private final File templatesDirectory;
    private final TemplateFactory factory;
    private final DelayQueue<DelayedContainer<File>> delayQueue = new DelayQueue();
    private final Map<File, DelayedContainer<File>> delays = new ConcurrentHashMap<File, DelayedContainer<File>>();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public DirWatcherTemplateFactory(File file, TemplateFactory templateFactory) {
        if (file == null) {
            throw new IllegalArgumentException("Template directory parameter is null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Templates directory does not exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Templates directory parameter is not a directory!");
        }
        if (templateFactory == null) {
            throw new IllegalArgumentException("Parent factory is missing!");
        }
        this.templatesDirectory = file;
        this.factory = templateFactory;
    }

    public File getTemplatesDirectory() {
        return this.templatesDirectory;
    }

    private Optional<PreparedTemplate> handle(File file) {
        assert (file.isAbsolute());
        try {
            PreparedTemplate preparedTemplate = this.factory.prepareTemplateFile(file, PrepareOptions.options());
            return Optional.of(preparedTemplate);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return Optional.empty();
        }
    }

    public void start() throws IOException, IllegalStateException {
        if (this.running.getAndSet(true)) {
            throw new IllegalStateException("Already running!");
        }
        Path path = this.templatesDirectory.toPath();
        WatchService watchService = path.getFileSystem().newWatchService();
        WatchKey watchKey = path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        new Thread(() -> {
            try {
                this.initAllFiles();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                while (this.running.get()) {
                    LinkedList linkedList;
                    if (this.delayQueue.isEmpty()) {
                        this.addEvents(watchService.take());
                    }
                    if (0 < this.delayQueue.drainTo(linkedList = new LinkedList())) {
                        linkedList.forEach(delayedContainer -> {
                            this.delays.remove(((DelayedContainer)delayedContainer).getElem());
                            this.handle((File)((DelayedContainer)delayedContainer).getElem());
                        });
                        continue;
                    }
                    long l = ((DelayedContainer)this.delayQueue.peek()).getDelay(TimeUnit.MILLISECONDS);
                    WatchKey watchKey = watchService.poll(l, TimeUnit.MILLISECONDS);
                    if (watchKey == null) continue;
                    this.addEvents(watchKey);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }).start();
    }

    private void initAllFiles() {
        this.recurse(this.templatesDirectory).forEach(this::handle);
    }

    private Stream<File> recurse(File file) {
        if (file != null && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray == null) {
                return Stream.empty();
            }
            return Arrays.stream(stringArray).map(string -> new File(file, (String)string)).flatMap(this::recurse);
        }
        return Stream.empty();
    }

    private void addEvents(WatchKey watchKey) {
        assert (watchKey != null);
        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
            DelayedContainer<File> delayedContainer;
            WatchEvent<?> watchEvent2 = watchEvent;
            File file = new File(this.templatesDirectory, ((Path)watchEvent2.context()).toFile().getName());
            if (this.delays.containsKey(file)) {
                delayedContainer = this.delays.get(file);
                this.delays.remove(file);
                this.delayQueue.remove(delayedContainer);
            }
            delayedContainer = new DelayedContainer(1000L, file);
            this.delays.put(file, delayedContainer);
            this.delayQueue.add(delayedContainer);
        }
        watchKey.reset();
    }

    public void stop() {
        if (!this.running.getAndSet(false)) {
            throw new IllegalStateException("Already stopped!");
        }
        this.delays.clear();
        this.delayQueue.clear();
    }

    @Override
    public PreparedTemplate prepareTemplateFile(File file, PrepareOptions prepareOptions) {
        if (file == null) {
            throw new IllegalArgumentException("templateFile argument must not be null!");
        }
        if (file.isAbsolute()) {
            throw new IllegalArgumentException("templateFile must not be an absolute file!");
        }
        return this.handle(file).orElseThrow(() -> new IllegalArgumentException("Can not build template file: " + file));
    }

    private static final class DelayedContainer<X>
    implements Delayed {
        private final long expiration;
        private final X contents;

        private DelayedContainer(long l, X x) {
            if (l <= 0L) {
                throw new IllegalArgumentException("Millis must be positive!");
            }
            this.expiration = System.currentTimeMillis() + l;
            this.contents = x;
        }

        private X getElem() {
            return this.contents;
        }

        public String toString() {
            return "D+" + this.expiration;
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.expiration - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

