/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil;

import io.github.erdos.stencil.TemplateData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TemplateVariables {
    private final Set<String> fragmentNames;
    private final Set<String> variables;
    private final Node root;
    private static final Node LEAF = new Node(){

        public String toString() {
            return "*";
        }

        @Override
        public <T> T accept(NodeVisitor<T> nodeVisitor) {
            return nodeVisitor.visitLeaf();
        }
    };

    private TemplateVariables(Set<String> set, Set<String> set2) {
        this.variables = Collections.unmodifiableSet(set);
        this.fragmentNames = Collections.unmodifiableSet(set2);
        Node node = LEAF;
        for (String string : set) {
            node = TemplateVariables.reduce(node, string);
        }
        this.root = node;
    }

    private static Node reduce(Node node, final String string) {
        if (string.isEmpty()) {
            return LEAF;
        }
        if (node == null) {
            node = LEAF;
        }
        int n = string.indexOf("[]");
        int n2 = string.indexOf(".");
        if (n2 == 0) {
            return TemplateVariables.reduce(node, string.substring(1));
        }
        if (n == -1 && n2 == -1) {
            return node.accept(new NodeVisitor<Node>(){

                @Override
                public Node visitArray(Node node) {
                    throw new IllegalArgumentException("expecting map, found array.");
                }

                @Override
                public Node visitMap(Map<String, Node> map) {
                    HashMap<String, Node> hashMap = new HashMap<String, Node>(map);
                    hashMap.put(string, LEAF);
                    return TemplateVariables.mapNode(hashMap);
                }

                @Override
                public Node visitLeaf() {
                    return TemplateVariables.mapNode(Collections.singletonMap(string, LEAF));
                }
            });
        }
        if (n == 0) {
            final String string2 = string.substring(2);
            return node.accept(new NodeVisitor<Node>(){

                @Override
                public Node visitArray(Node node) {
                    return TemplateVariables.listNode(TemplateVariables.reduce(node, string2));
                }

                @Override
                public Node visitMap(Map<String, Node> map) {
                    throw new IllegalArgumentException("Expected a vector, found a map!");
                }

                @Override
                public Node visitLeaf() {
                    return TemplateVariables.listNode(TemplateVariables.reduce(LEAF, string2));
                }
            });
        }
        if (n == -1 || n2 < n || n < n2) {
            int n3 = n == -1 ? n2 : (n2 == -1 ? n : Math.min(n, n2));
            final String string3 = string.substring(0, n3);
            final String string4 = string.substring(n3);
            return node.accept(new NodeVisitor<Node>(){

                @Override
                public Node visitArray(Node node) {
                    throw new IllegalArgumentException("Expected map, found array!");
                }

                @Override
                public Node visitMap(Map<String, Node> map) {
                    HashMap<String, Node> hashMap = new HashMap<String, Node>(map);
                    hashMap.putIfAbsent(string3, LEAF);
                    hashMap.compute(string3, (string2, node) -> TemplateVariables.reduce(node, string4));
                    return TemplateVariables.mapNode(hashMap);
                }

                @Override
                public Node visitLeaf() {
                    return TemplateVariables.mapNode(Collections.singletonMap(string3, TemplateVariables.reduce(LEAF, string4)));
                }
            });
        }
        throw new IllegalArgumentException("Illegal path string: " + string);
    }

    public static TemplateVariables fromPaths(Collection<String> collection, Collection<String> collection2) {
        return new TemplateVariables(new HashSet<String>(collection), new HashSet<String>(collection2));
    }

    public Set<String> getAllVariables() {
        return this.variables;
    }

    public Set<String> getAllFragmentNames() {
        return this.fragmentNames;
    }

    public void throwWhenInvalid(TemplateData templateData) throws IllegalArgumentException {
        List<SchemaError> list = this.validate(templateData.getData(), this.root);
        if (!list.isEmpty()) {
            String string = list.stream().map(schemaError -> ((SchemaError)schemaError).msg).collect(Collectors.joining("\n"));
            throw new IllegalArgumentException("Schema error: \n" + string);
        }
    }

    private List<SchemaError> validate(Object object, Node node) {
        return TemplateVariables.validateImpl("", object, node).collect(Collectors.toList());
    }

    private static Stream<SchemaError> validateImpl(final String string, final Object object, Node node) {
        return node.accept(new NodeVisitor<Stream<SchemaError>>(){

            @Override
            public Stream<SchemaError> visitArray(Node node) {
                if (object instanceof List) {
                    AtomicInteger atomicInteger = new AtomicInteger();
                    return ((List)object).stream().flatMap(object -> {
                        String string2 = string + "[" + atomicInteger.getAndIncrement() + "]";
                        return TemplateVariables.validateImpl(string2, object, node);
                    });
                }
                return Stream.of(new SchemaError(string, "Expecting list on path!"));
            }

            @Override
            public Stream<SchemaError> visitMap(Map<String, Node> map) {
                if (object instanceof Map) {
                    Map map2 = (Map)object;
                    return map.entrySet().stream().flatMap(entry -> {
                        if (map2.containsKey(entry.getKey())) {
                            return TemplateVariables.validateImpl(string + "." + (String)entry.getKey(), map2.get(entry.getKey()), (Node)entry.getValue());
                        }
                        return Stream.of(new SchemaError(string, "Expected key " + (String)entry.getKey()));
                    });
                }
                return Stream.of(new SchemaError(string, "Expected map on path!"));
            }

            @Override
            public Stream<SchemaError> visitLeaf() {
                return Stream.empty();
            }
        });
    }

    private static Node mapNode(final Map<String, Node> map) {
        return new Node(){

            public String toString() {
                return map.toString();
            }

            @Override
            public <T> T accept(NodeVisitor<T> nodeVisitor) {
                return nodeVisitor.visitMap(map);
            }
        };
    }

    private static Node listNode(final Node node) {
        return new Node(){

            public String toString() {
                return "[" + node.toString() + "]";
            }

            @Override
            public <T> T accept(NodeVisitor<T> nodeVisitor) {
                return nodeVisitor.visitArray(node);
            }
        };
    }

    static interface NodeVisitor<T> {
        public T visitArray(Node var1);

        public T visitMap(Map<String, Node> var1);

        public T visitLeaf();
    }

    static interface Node {
        public <T> T accept(NodeVisitor<T> var1);
    }

    private static final class SchemaError {
        private final String path;
        private final String msg;

        SchemaError(String string, String string2) {
            this.path = string;
            this.msg = string2;
        }
    }
}

