/*
 * Decompiled with CFR 0.152.
 */
package io.github.erdos.stencil.functions;

import io.github.erdos.stencil.functions.Function;
import io.github.erdos.stencil.functions.FunctionsProvider;
import java.util.Arrays;
import java.util.Collection;

public enum BasicFunctions implements Function
{
    SWITCH{

        @Override
        public Object call(Object ... objectArray) {
            if (objectArray.length < 3) {
                throw new IllegalArgumentException("switch() function expects at least 3 args!");
            }
            Object object = objectArray[0];
            for (int i = 1; i < objectArray.length; i += 2) {
                Object object2 = objectArray[i];
                Object object3 = objectArray[i + 1];
                if (object == null && object2 == null) {
                    return object3;
                }
                if (object == null || !object.equals(object2)) continue;
                return object3;
            }
            if (objectArray.length % 2 == 0) {
                return objectArray[objectArray.length - 1];
            }
            return null;
        }
    }
    ,
    COALESCE{

        @Override
        public Object call(Object ... objectArray) {
            for (Object object : objectArray) {
                if (object == null || "".equals(object) || object instanceof Collection && ((Collection)object).isEmpty()) continue;
                return object;
            }
            return null;
        }
    }
    ,
    EMPTY{

        @Override
        public Object call(Object ... objectArray) {
            if (objectArray.length != 1) {
                throw new IllegalArgumentException("empty() function expects exactly 1 argument, " + objectArray.length + " given.");
            }
            Object object = objectArray[0];
            return object == null || "".equals(object) || object instanceof Collection && ((Collection)object).isEmpty() || object instanceof Iterable && !((Iterable)object).iterator().hasNext();
        }
    };


    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    public static class Provider
    implements FunctionsProvider {
        @Override
        public Iterable<Function> functions() {
            return Arrays.asList(BasicFunctions.values());
        }
    }
}

